<?php
/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/
// Require the initialisation file
require_once '../../../../init.php';


require_once MAX_PATH . '/lib/OA/Admin/TemplatePlugin.php';

// Required files
require_once MAX_PATH . '/lib/OA/Admin/Option.php';
require_once MAX_PATH . '/lib/OA/Admin/Settings.php';

require_once MAX_PATH .'/lib/OA/Admin/UI/component/Form.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
require_once MAX_PATH . '/lib/OX/Plugin/Component.php';
require_once MAX_PATH . '/www/admin/config.php';


$oDbh = OA_DB::singleton();
$table_prefix = $conf['table']['prefix'];

// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN);


// Load translation class
$oTranslation = new OX_Translation();
$translation = new OX_Translation ();

// Register input variables
phpAds_registerGlobalUnslashed(
     'errormessage'
    ,'dmp_url'
    ,'dmp_api'
    ,'id'
    ,'segment_remove'
    ,'load_segments'
);

		$doCheck = OA_Dal::factoryDO('dmp_settings');
        $doCheck->whereAdd('name = "dmp_url"');
        $doCheck->limit(1);
        $doCheck->fetch();
        $doCheck->find();
        $doCheck->fetch();
		$data =  $doCheck->toArray();

$aformdata['dmp_url'] = ($data['name']=="dmp_url") ? $data['value'] : '';

		$doCheck = OA_Dal::factoryDO('dmp_settings');
        $doCheck->whereAdd('name = "dmp_api"');
        $doCheck->limit(1);
        $doCheck->fetch();
        $doCheck->find();
        $doCheck->fetch();
		$data =  $doCheck->toArray();
		
$aformdata['dmp_api'] = ($data['name']=="dmp_api") ? $data['value'] : '';
		
	
	
	
if(isset($segment_remove) && $segment_remove =="true")
{
	
	   $ids = explode(',', $id);
   
    while (list(,$id) = each($ids)) {
				
				$doCheck = OA_Dal::factoryDO('dmp_segments');
				$doCheck->id = $id;
				if($doCheck->get($id)) {
						$details = $doCheck->toArray();
				} 
				
				$doCheck->delete(); 
				$count_lits++; 
	}
	
	  $translation = new OX_Translation ();

    if ($count_lits && $count_lits == 1 ) {
        $translated_message = $translation->translate ("<b>%s</b> Segment has been deleted", $count_lits);
    } 
	else
	{
		 $translated_message = $translation->translate ( "<b>%s</b> Segments has been deleted", $count_lits);
	}
	
    OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);
    
    OX_Admin_Redirect::redirect("plugins/dmp/dmp-segments.php");	
	
	
	exit;
}
		

if(isset($load_segments) && $load_segments =="true")
{
	//print_r($aformdata['dmp_url']);die("dfdf");
	
$url = $aformdata['dmp_url'];

	$options = array(
        CURLOPT_RETURNTRANSFER => true,   // return web page
        CURLOPT_HEADER         => false,  // don't return headers
        CURLOPT_FOLLOWLOCATION => true,   // follow redirects
        CURLOPT_MAXREDIRS      => 10,     // stop after 10 redirects       
        CURLOPT_AUTOREFERER    => true,   // set referrer on redirect
        CURLOPT_CONNECTTIMEOUT => 120,    // time-out on connect
        CURLOPT_TIMEOUT        => 120,    // time-out on response
    ); 


    $ch = curl_init($url);
    curl_setopt_array($ch, $options);
    $response  = curl_exec($ch);
	$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	curl_close($ch);
    
    if($http_code == 200)
    {
		
		if(is_array(json_decode($response, true)) )
		{
			
			$response = json_decode($response, true);
			
			if(isset($response['successCode']) && $response['successCode'] == 1000 && isset($response['segmentData']) && is_array($response['segmentData']))
			{
				
				 $response =  $response['segmentData'];
				 $segment_items = array_keys($response);
				 
				 $count_up = 0;
				  $count_new = 0;
				
				//$query = 'DELETE FROM '.$table_prefix.'dmp_segments WHERE segment_id NOT IN  ('.implode(',',$segment_items).')';
				//$oDbh->exec($query);	
				
					
				foreach($response as $seg_id => $values)
				{
					
					
					//print_r(json_encode($values['segmentCondition']));die("df");
					$aField =  array('segment_id'=>$values['segmentId'] ,'name' => $values['segmentName'] ,'description' => $values['segmentDescription'],'datePe1riod'=>$values['datePe1riod'],'rules' => json_encode($values['segmentCondition']) ,'data_updated' => date('Y-m-d H:i:s')  );
				
					$doCheck = OA_Dal::factoryDO('dmp_segments');
					$doCheck->whereAdd('segment_id = "'.$values['segmentId'].'"');
					$doCheck->limit(1);
					$doCheck->find();
					$doCheck->fetch();
					$data =  $doCheck->toArray();
					if($data['segment_id'] != $values['segmentId'])
					{
						$doAdd = OA_Dal::factoryDO('dmp_segments');
						$doAdd->setFrom($aField);
						$doAdd->insert();
						$count_new ++;
					}
					else
					{
						$doUpdate = OA_Dal::factoryDO('dmp_segments');
						$doUpdate->get($data['id']);
						$doUpdate->setFrom($aField);
						$doUpdate->updated = OA::getNow();
						$doUpdate->update();
						$count_up ++;
									
					} 
					
				}
				
				
				$message = '';
				if($count_new)
				{
					$message.='<b>'.$count_new.'</b> Segment'.(($count_new>1)? 's' : '').' has created.&nbsp;&nbsp;&nbsp;';
				}
				if($count_up)
				{
					$message.='<b>'.$count_up.'</b> Segment'.(($count_up>1)? 's' : '').' has updated.&nbsp;&nbsp;&nbsp;';
				}
				
				$translated_message = $translation->translate ($message);
				OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);
				// Go to next page
				OX_Admin_Redirect::redirect("plugins/dmp/dmp-segments.php");	
				
			}
			else
			if(isset($response['status']) && $response['status'] == 1 && isset($response['result']))
			{
				
				$translated_message = $translation->translate ($response['result']);
				OA_Admin_UI::queueMessage($translated_message, 'local', 'warning', 0);
				// Go to next page
				OX_Admin_Redirect::redirect("plugins/dmp/dmp-segments.php");	
			}
			else
			if(isset($response['status']) && $response['status'] == "false")
			{
				
				$translated_message = $translation->translate ($response['error']);
				OA_Admin_UI::queueMessage($translated_message, 'local', 'warning', 0);
				// Go to next page
				OX_Admin_Redirect::redirect("plugins/dmp/dmp-settings.php");
				
			}
			
		}
		else 
		{
			
				$translated_message = $translation->translate ('Invalid DMP url');
				OA_Admin_UI::queueMessage($translated_message, 'local', 'warning', 0);
				// Go to next page
				OX_Admin_Redirect::redirect("plugins/dmp/dmp-settings.php");
				
		}
	}
	else
	if($http_code == 403)
	{
				$response = json_decode($response, true);
				$translated_message = $translation->translate ($response['error']);
				OA_Admin_UI::queueMessage($translated_message, 'local', 'warning', 0);
				// Go to next page
				OX_Admin_Redirect::redirect("plugins/dmp/dmp-settings.php");	
	}
	else
	if($http_code == 404)
	{
		$translated_message = $translation->translate ('Invalid DMP url');
        OA_Admin_UI::queueMessage($translated_message, 'local', 'warning', 0);
        // Go to next page
        OX_Admin_Redirect::redirect("plugins/dmp/dmp-settings.php"); 
		  
	}
	else
	{
		
		$translated_message = $translation->translate ('Invalid DMP url');
        OA_Admin_UI::queueMessage($translated_message, 'local', 'warning', 0);
        // Go to next page
        OX_Admin_Redirect::redirect("plugins/dmp/dmp-settings.php");
		
	}

exit;
	
}



$doCheck = OA_Dal::factoryDO('dmp_segments');
$segments =  $doCheck->getAll(array('id','segment_id','name','description','data_updated'), $indexWitkPk = true, $flatten = false); 
$oHeaderModel = new OA_Admin_UI_Model_PageHeaderModel('DMP Segments');
$oHeaderModel->setIconClass('iconTargetingChannelsLarge');
$oHeaderModel->setpageType('list');
phpAds_PageHeader(null, $oHeaderModel);

//get template and display form
    $oTpl = new OA_Plugin_Template('dmp-segments.html','dmp');
    $oTpl->assign('formdata', $aformdata);
    $oTpl->assign('segments', $segments);
    $oTpl->display();

    
phpAds_PageFooter();
