<?php
/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/
// Require the initialisation file
require_once '../../../../init.php';


require_once MAX_PATH . '/lib/OA/Admin/TemplatePlugin.php';

// Required files
require_once MAX_PATH . '/lib/OA/Admin/Option.php';
require_once MAX_PATH . '/lib/OA/Admin/Settings.php';

require_once MAX_PATH .'/lib/OA/Admin/UI/component/Form.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
require_once MAX_PATH . '/lib/OX/Plugin/Component.php';
require_once MAX_PATH . '/www/admin/config.php';


// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN);


// Load translation class
$oTranslation = new OX_Translation();
  $translation = new OX_Translation ();

// Register input variables
phpAds_registerGlobalUnslashed(
     'errormessage'
    ,'dmp_url'
    ,'dmp_api'
    ,'id'
    ,'update_segment'
    
);

		$doCheck = OA_Dal::factoryDO('dmp_settings');
        $doCheck->whereAdd('name = "dmp_url"');
        $doCheck->limit(1);
        $doCheck->fetch();
        $doCheck->find();
        $doCheck->fetch();
		$data =  $doCheck->toArray();

$aformdata['dmp_url'] = ($data['name']=="dmp_url") ? $data['value'] : '';

		//~ $doCheck = OA_Dal::factoryDO('dmp_settings');
        //~ $doCheck->whereAdd('name = "dmp_api"');
        //~ $doCheck->limit(1);
        //~ $doCheck->fetch();
        //~ $doCheck->find();
        //~ $doCheck->fetch();
		//~ $data =  $doCheck->toArray();
		
//~ $aformdata['dmp_api'] = ($data['name']=="dmp_api") ? $data['value'] : '';


$doCheck = OA_Dal::factoryDO('dmp_segments');
$doCheck->whereAdd('id="'.$id.'"');
$segment =  $doCheck->getAll(array(), $indexWitkPk = true, $flatten = false); 



if(empty($segment)  ) 
{
	
	 $translated_message = $translation->translate ( "Selected Segment is not available");
     OA_Admin_UI::queueMessage($translated_message, 'local', 'warning', 0);
     OX_Admin_Redirect::redirect("plugins/dmp/dmp-segments.php");
	 exit;		
} 






if(isset($update_segment) && $update_segment =="true")
{
$url = $aformdata['dmp_url'].'/dmp_api/index.php/api/v1/dmp_api/segment/'.$segment[$id]['segment_id'].'?api_key='.$aformdata['dmp_api']; 

$options = array(
        CURLOPT_RETURNTRANSFER => true,   // return web page
        CURLOPT_HEADER         => false,  // don't return headers
        CURLOPT_FOLLOWLOCATION => true,   // follow redirects
        CURLOPT_MAXREDIRS      => 10,     // stop after 10 redirects
        CURLOPT_ENCODING       => "",     // handle compressed
        CURLOPT_USERAGENT      => "test", // name of client
        CURLOPT_AUTOREFERER    => true,   // set referrer on redirect
        CURLOPT_CONNECTTIMEOUT => 120,    // time-out on connect
        CURLOPT_TIMEOUT        => 120,    // time-out on response
    ); 

    $ch = curl_init($url);
    curl_setopt_array($ch, $options);
    $response  = curl_exec($ch);
	$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	curl_close($ch);
	
	
	 if($http_code == 200)
    {
			if(is_array(json_decode($response, true)) )
		{
			$response = json_decode($response, true);
			if(isset($response['status']) && $response['status'] == 1 && isset($response['result']) && is_array($response['result']))
			{
				
				 $values =  $response['result'];
				 $seg_id		 = $values['id'];	
		  
				  $aField =  array('segment_id'=>$seg_id ,'name' => $values['name'] ,'description' => $values['description'],'rules' => json_encode($values['values']) ,'data_updated' => date('Y-m-d H:i:s')  );
				
						$doUpdate = OA_Dal::factoryDO('dmp_segments');
						$doUpdate->get($id);
						$doUpdate->setFrom($aField);
						$doUpdate->updated = OA::getNow();
						$doUpdate->update();
				
				$message.='<b>'.$values['name'].'</b> segment has updated';
				$translated_message = $translation->translate ($message);
				OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);
				// Go to next page
				OX_Admin_Redirect::redirect("plugins/dmp/dmp-segment-view.php?id=".$id);					
			  
				  
			}
			else
			if(isset($response['status']) && $response['status'] == 1 && isset($response['result']))
			{
				
				$translated_message = $translation->translate ($response['result']);
				OA_Admin_UI::queueMessage($translated_message, 'local', 'warning', 0);
				// Go to next page
				OX_Admin_Redirect::redirect("plugins/dmp/dmp-segment-view.php?id=".$id);	
			}
			else
			if(isset($response['status']) && $response['status'] == "false")
			{
				
				$translated_message = $translation->translate ($response['error']);
				OA_Admin_UI::queueMessage($translated_message, 'local', 'warning', 0);
				// Go to next page
				OX_Admin_Redirect::redirect("plugins/dmp/dmp-settings.php");
				
			}
			
		}
		else
		{
			
				$translated_message = $translation->translate ('Invalid DMP url');
				OA_Admin_UI::queueMessage($translated_message, 'local', 'warning', 0);
				// Go to next page
				OX_Admin_Redirect::redirect("plugins/dmp/dmp-settings.php");
				
		}
				
				

	}
	else
	if($http_code == 403)
	{
				$response = json_decode($response, true);
				$translated_message = $translation->translate ($response['error']);
				OA_Admin_UI::queueMessage($translated_message, 'local', 'warning', 0);
				// Go to next page
				OX_Admin_Redirect::redirect("plugins/dmp/dmp-settings.php");	
	}
	else
	if($http_code == 404)
	{
		$translated_message = $translation->translate ('Invalid DMP url');
        OA_Admin_UI::queueMessage($translated_message, 'local', 'warning', 0);
        // Go to next page
        OX_Admin_Redirect::redirect("plugins/dmp/dmp-settings.php"); 
		  
	}
	else
	{
		
		$translated_message = $translation->translate ('Invalid DMP url');
        OA_Admin_UI::queueMessage($translated_message, 'local', 'warning', 0);
        // Go to next page
        OX_Admin_Redirect::redirect("plugins/dmp/dmp-settings.php");
		
	}
    

exit;


}


$segment = $segment[$id];
$seg['id'] = $segment['id'];
$seg['segment_id'] = $segment['segment_id'];
$seg['name'] = $segment['name'];
$seg['description'] = $segment['description'];
$seg['data_updated'] = $segment['data_updated'];

$abc = $segment['rules'];


$abc = json_decode(json_decode($abc),true);

$seg = array();

$condition=$abc['condition'];
foreach($abc['rules'] as $r)
{
	
	if(array_key_exists("rules",$r))
	{
		$condition=$r['condition'];
		
		foreach($r['rules'] as $rs)
        {
		  
		$hash['rule']['type'] = $rs['field'];
	    $hash['rule']['operator'] = $rs['operator'];
		$hash['rule']['value'] = $rs['value'];	
		$hash['rule']['condition']=$condition;
		$seg[] = $hash;
	    }
	    
	
    }
    else
    {
		$hash['rule']['type'] = $r['field'];
	    $hash['rule']['operator'] = $r['operator'];
		$hash['rule']['value'] = $r['value'];
		$hash['rule']['condition']=$condition;
		$seg[] = $hash;
	}
	
	
	
}

$oHeaderModel = new OA_Admin_UI_Model_PageHeaderModel($segment['name'].'<p >'.$segment['description'].'</p>');
$oHeaderModel->setIconClass('iconTargetingChannelsLarge');
$oHeaderModel->setpageType('list');
phpAds_PageHeader('dmp-segments', $oHeaderModel);

//get template and display form
    $oTpl = new OA_Plugin_Template('dmp-segment-view.html','dmp');
    $oTpl->assign('id', $id); 
    $oTpl->assign('formdata', $aformdata);
    $oTpl->assign('segment', $seg);
    $oTpl->display();

    
phpAds_PageFooter();

function split_values($value)
{
		if(is_array($value))
		{
			return implode(',',$value);
		}
		else
		{
			return $value;
		}
}


function split_operator($name)
{
		return str_replace('_',' ',$name);
}

function split_segname($name)
{
	switch($name){
		
	case 'forms.form.age';  return 'Age'; break;
	case 'device_details.browser';  return 'Browser'; break;
	case 'ip_details.city';  return 'City'; break;
	case 'ip_details.continent_code';  return 'Continent'; break;
	case 'conversion';  return 'Conversion'; break;
	case 'ip_details.country_code';  return 'Country'; break;
	case 'device_details.name';  return 'Device name'; break;
	case 'device_details.type';  return 'Device type'; break;
	case 'forms.form.email_address';  return 'Email'; break;
	case 'TimeSpan.timespan';  return 'Engagement'; break;
	case 'forms.form.gender';  return 'Gender'; break;
	case 'device_details.height';  return 'Height'; break;
	case 'impression';  return 'Impression'; break;
	case 'forms.form.income';  return 'Income'; break;
	case 'ip_details.ip_address';  return 'IP Address'; break;
	case 'ip_details.latitude';  return 'Latitude'; break;
	case 'ip_details.longitude';  return 'Longitude'; break;
	case 'multisession';  return 'Multi session'; break;
	case 'non_conveters';  return 'Non Converters'; break;
	case 'device_details.os';  return 'OS'; break;
	case 'ip_details.postal_code';  return 'Postal code'; break;
	case 'social_details.product';  return 'Product'; break;
	case 'social_details.share_type';  return 'Social media'; break;
	case 'traffic_url.traffic';  return 'Traffic'; break;
	case 'forms.form.url';  return 'URL'; break;
	case 'returninguser';  return 'User'; break;
	case 'device_details.user_agent';  return 'User agent'; break;
	case 'forms.form.website_url';  return 'Website'; break;
	case 'device_details.width';  return 'Width'; break;
	case 'non_conveters';  return 'Non'; break;
	
	default:
	 return $name;	
	}
 
	
}



