<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

/**
 * Plugins_InvocationTagsOptions contains all standard options.
 *
 * @package    OpenXPlugin
 * @subpackage InvocationTags
 */
class Plugins_InvocationTagsOptions
{
    var $maxInvocation;

    var $defaultValues = array();
    function __construct()
    {
        $conf = $GLOBALS['_MAX']['CONF'];
        $this->defaultValues = array(
            'dadposition'=>'','limit'=>'15',
            'target'            => '',
            'source'            => '','withoutplayer'=>'',
            'withtext'          => 0,
            'refresh'           => '',
            'transparent'       => 0,
            'ilayer'            => 0,
            'iframetracking'    => 0,
            'block'             => 0,
            'blockcampaign'     => 0,
            'raw'               => 0,
            'popunder'          => 1,
            'delay'             => '-',
            'absolute'          => array('top' => '-', 'left' => '-'),
            'timeout'           => '-',
            'windowoptions'     => array('toolbars' => 0, 'location' => 0, 'menubar' => 0, 'status' => 0, 'resizable' => 0, 'scrollbars' => 0),
            'xmlrpcproto'       => 0,
            'xmlrpctimeout'     => '',
            'hostlanguage'      => '',
            'thirdPartyServer'  => $conf['delivery']['clicktracking'],
            'cachebuster'       => 1,
            'comments'          => 1,
            'charset'           => '',
        );
    }

    /**
     * Return name of plugin
     *
     * @return string    A string describing the class.
     */
    function setInvocation(&$invocation) {
        $this->maxInvocation = &$invocation;
    }

    function adposition()
    {
        $mi = &$this->maxInvocation;

        $option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Ad Schedule</td> ";
		$option .= "<td width='500'> <input type='radio' name='dadposition' value='1'".(isset($maxInvocation->dadposition) && $maxInvocation->dadposition == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Pre-roll &nbsp; &nbsp;<br/>";
            	$option .= "<input type='radio' name='dadposition' value='2'".(!isset($maxInvocation->dadposition) || $maxInvocation->dadposition == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Mid-roll &nbsp; <br/>";
		$option .= "<input type='radio' name='dadposition' value='3'".(!isset($maxInvocation->dadposition) || $maxInvocation->dadposition == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Post-roll &nbsp;<br/><br/></td>";
 		$option .= "</tr>";
        return $option;
    }

       function limit()
    {
	$maxInvocation = &$this->maxInvocation;
        $option = '';
	$option .= "<tr><td width='30'>&nbsp;</td>";
	$option .= "<td width='200'>Limit</td><td width='370'>";
	$option .= "<input class='flat' type='text' name='limit' size='' value='".(isset($maxInvocation->limit) ? htmlspecialchars(stripslashes($maxInvocation->limit),ENT_QUOTES) : 15)."' style='width:175px;' tabindex='".($maxInvocation->tabindex++)."'></td></tr>";
	$option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
	 return $option;
    }
    /**
     * Generate the HTML option
     *
     * @return string    A string containing html for option
     */
    function spacer()
    {
        $mi = &$this->maxInvocation;

        $option = "<tr".($mi->zone_invocation ? '' : " bgcolor='#F6F6F6'")."><td height='10' colspan='3'>&nbsp;</td></tr>";
        return $option;
    }

    /**
     * Generate the HTML option
     *
     * @return string    A string containing html for option
     */

function withoutplayer()
    {
        $maxInvocation = &$this->maxInvocation;

        $option = '';
        $option .= "<tr><td width='30'>&nbsp;</td>";
        $option .= "<td width='200'>Pass Vast Validator Full Name</td><td width='370'>";
        $option .= "<input class='flat' type='text' name='withoutplayer' size='' value='".(isset($maxInvocation->withoutplayer) ? htmlspecialchars(stripslashes($maxInvocation->withoutplayer),ENT_QUOTES) : '')."' style='width:175px;' tabindex='".($maxInvocation->tabindex++)."'>&nbsp;&nbsp;Example: http://demo.jwplayer.com for jwplayer or http://zutils.zedo.com for zedo or http://epom.com for epom</td></tr>";
        $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
        return $option;
    }

    function what()
    {
        $maxInvocation = &$this->maxInvocation;

        $option = '';
        if (!$maxInvocation->zone_invocation && $maxInvocation->codetype != 'adviewnocookies') {
            $option .= "<tr bgcolor='#F6F6F6'><td width='30'>&nbsp;</td>";
            $option .= "<td width='200' valign='top'>".$GLOBALS['strInvocationWhat']."</td><td width='370'>";
            $option .= "<textarea class='flat' name='what' rows='3' cols='50' style='width:350px;' tabindex='".($maxInvocation->tabindex++)."'>".(isset($maxInvocation->what) ? htmlspecialchars(stripslashes($maxInvocation->what),ENT_QUOTES) : '')."</textarea></td></tr>";

            if (OA_Permission::isAccount(OA_ACCOUNT_ADMIN)) {
                $option .= "<tr bgcolor='#F6F6F6'><td height='10' colspan='3'>&nbsp;</td></tr>";
                $option .= "<tr height='1'><td colspan='3' bgcolor='#888888'><img src='" . OX::assetPath(). "/images/break.gif' height='1' width='100%'></td></tr>";
                $option .= "<tr><td height='10' colspan='3'>&nbsp;</td></tr>";
            }
        }

        return $option;
    }

    /**
     * Generate the HTML option
     *
     * @return string    A string containing html for option
     */
    function campaignid()
    {
        $conf = $GLOBALS['_MAX']['CONF'];

        $mi = &$this->maxInvocation;
        if ($mi->zone_invocation || OA_Permission::isAccount(OA_ACCOUNT_ADMIN)) {
            return null;
        }

        $option = '';
        // Display available campaigns...
        $option .= "<tr bgcolor='#F6F6F6'><td width='30'>&nbsp;</td>\n";
        $option .= "<td width='200'>".$GLOBALS['strInvocationCampaignID']."</td><td width='370'>\n";
        $option .= "<select name='campaignid' style='width:350px;' tabindex='".($mi->tabindex++)."'>\n";
        $option .= "<option value='0'>-</option>\n";
        if (OA_Permission::isAccount(OA_ACCOUNT_ADMIN)) {
            $query = "SELECT campaignid,campaignname".
                " FROM ".$conf['table']['prefix'].$conf['table']['campaigns'];
        } elseif (OA_Permission::isAccount(OA_ACCOUNT_MANAGER)) {
            $query = "SELECT m.campaignid AS campaignid".
                ",m.campaignname AS campaignname".
                " FROM ".$conf['table']['prefix'].$conf['table']['campaigns']." AS m".
                ",".$conf['table']['prefix'].$conf['table']['clients']." AS c".
                " WHERE m.clientid=c.clientid".
                " AND c.agencyid=".OA_Permission::getAgencyId();
        }
        $oDbh = OA_DB::singleton();
        $aResult = $oDbh->queryAll($query);
        if (PEAR::isError($aResult))
        {
            $option .= "<option value='0'>'.$aResult->getUserInfo().'</option>\n";
        }
        else
        {
            foreach ($aResult AS $k => $row)
            {
                $option .= "<option value='".$row['campaignid']."'".($mi->campaignid == $row['campaignid'] ? ' selected' : '').">";
                $option .= phpAds_buildName ($row['campaignid'], $row['campaignname']);
                $option .= "</option>\n";
            }
        }
        $option .= "</select>\n";
        $option .= "</td></tr>";
        $option .= "<tr bgcolor='#F6F6F6'><td height='10' colspan='3'>&nbsp;</td></tr>";
        $option .= "<tr height='1'><td colspan='3' bgcolor='#888888'><img src='" . OX::assetPath(). "/images/break.gif' height='1' width='100%'></td></tr>";
        $option .= "<tr><td height='10' colspan='3'>&nbsp;</td></tr>";
        return $option;
    }

    /**
     * Generate the HTML option
     *
     * @return string    A string containing html for option
     */
    function bannerid()
    {
        global $codetype;
        $maxInvocation = &$this->maxInvocation;

        $option = '';
        $option .= "<tr><td width='30'>&nbsp;</td>";
        $option .= "<td width='200'>".$GLOBALS['strInvocationBannerID']."</td><td width='370'>";
        if ($codetype == 'adviewnocookies') {
            $option .= "<input onBlur='max_formValidateElement(this);' class='flat' type='text' name='bannerid' value='".(isset($maxInvocation->bannerid) ? $maxInvocation->bannerid : '')."' style='width: 175px;' tabindex='".($maxInvocation->tabindex++)."'></td></tr>";
        } else {
            $option .= "<input class='flat' type='text' name='bannerid' size='' value='".(isset($maxInvocation->bannerid) ? $maxInvocation->bannerid : '')."' style='width:175px;' tabindex='".($maxInvocation->tabindex++)."'></td></tr>";
        }
        $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
        return $option;
    }

    /**
     * Generate the HTML option
     *
     * @return string    A string containing html for option
     
   function target()
    {
        $maxInvocation = &$this->maxInvocation;

        $target = (!empty($maxInvocation->target)) ? $maxInvocation->target : $this->defaultValues['target'];
        $option = '';
        $option .= "<tr><td width='30'>&nbsp;</td>
            <td width='200'>".$GLOBALS['strInvocationTarget']."</td><td width='370'>
            <select name='target' tabindex='".($maxInvocation->tabindex++)."'>
                <option value=''>Default</option>
                <option value='_blank'" . ($target == '_blank' ? " selected='selected'" : '') . ">New window</option>
                <option value='_top'" . ($target == '_top' ? " selected='selected'" : '') . ">Same window</option>
            </select>
            <tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";

        return $option;
    }
    
    

    /**
     * Generate the HTML option
     *
     * @return string    A string containing html for option
     */
   /* function source()
    {
        $maxInvocation = &$this->maxInvocation;

        $option = '';
        $option .= "<tr><td width='30'>&nbsp;</td>";
        $option .= "<td width='200'>".$GLOBALS['strInvocationSource']."</td><td width='370'>";
        $option .= "<input class='flat' type='text' name='source' size='' value='".(isset($maxInvocation->source) ? htmlspecialchars(stripslashes($maxInvocation->source),ENT_QUOTES) : $this->defaultValues['source'])."' style='width:175px;' tabindex='".($maxInvocation->tabindex++)."'></td></tr>";
        $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
        return $option;
    }

    /**
     * Generate the HTML option
     *
     * @return string    A string containing html for option
     */
     
 function target()
    {
        $maxInvocation = &$this->maxInvocation;
	
	/*$allowed_tag=array('invocationTags:oxInvocationTags:vast2',
'invocationTags:oxInvocationTags:ovast2');*/
/*DAC065*/
	$allowed_tag=array('invocationTags:oxInvocationTags:vast1','invocationTags:oxInvocationTags:vast2',
'invocationTags:oxInvocationTags:vast3','invocationTags:oxInvocationTags:ovast1','invocationTags:oxInvocationTags:ovast2',
'invocationTags:oxInvocationTags:ovast3','invocationTags:oxInvocationTags:vastwrapper2',
'invocationTags:oxInvocationTags:vastwrapper3','invocationTags:oxInvocationTags:vastwrapper1','invocationTags:oxInvocationTags:vastoverlaywrapper1'
,'invocationTags:oxInvocationTags:vastoverlaywrapper2','invocationTags:oxInvocationTags:vastoverlaywrapper3','invocationTags:oxInvocationTags:vmapinline','invocationTags:oxInvocationTags:ovmap','invocationTags:oxInvocationTags:vast2without','invocationTags:oxInvocationTags:ovast2without','invocationTags:oxInvocationTags:vast2internal','invocationTags:oxInvocationTags:ovast2internal');

	if(in_array($maxInvocation->codetype,$allowed_tag))
	{
	}
	else
	{
        $target = (!empty($maxInvocation->target)) ? $maxInvocation->target : $this->defaultValues['target'];
        $option = '';
        $option .= "<tr><td width='30'>&nbsp;</td>
            <td width='200'>".$GLOBALS['strInvocationTarget']."</td><td width='370'>
            <select name='target' tabindex='".($maxInvocation->tabindex++)."'>
                <option value=''>Default</option>
                <option value='_blank'" . ($target == '_blank' ? " selected='selected'" : '') . ">New window</option>
                <option value='_top'" . ($target == '_top' ? " selected='selected'" : '') . ">Same window</option>
            </select>
            <tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";

        return $option;
	}
    }
     
    
    function source()
    {
    $maxInvocation = &$this->maxInvocation;
	$allowed_tag=array('invocationTags:oxInvocationTags:vast1','invocationTags:oxInvocationTags:vast2',
'invocationTags:oxInvocationTags:vast3','invocationTags:oxInvocationTags:ovast1',
'invocationTags:oxInvocationTags:ovast2','invocationTags:oxInvocationTags:ovast3','invocationTags:oxInvocationTags:vastwrapper2',
'invocationTags:oxInvocationTags:vastwrapper3','invocationTags:oxInvocationTags:vastwrapper1','invocationTags:oxInvocationTags:vastoverlaywrapper1'
,'invocationTags:oxInvocationTags:vastoverlaywrapper2','invocationTags:oxInvocationTags:vastoverlaywrapper3','invocationTags:oxInvocationTags:vmapinline','invocationTags:oxInvocationTags:ovmap','invocationTags:oxInvocationTags:vast2without','invocationTags:oxInvocationTags:ovast2without','invocationTags:oxInvocationTags:vast2internal','invocationTags:oxInvocationTags:ovast2internal');

	if(in_array($maxInvocation->codetype,$allowed_tag))
	{
	}
	else
	{
      
        $option = '';
        $option .= "<tr><td width='30'>&nbsp;</td>";
        $option .= "<td width='200'>".$GLOBALS['strInvocationSource']."</td><td width='370'>";
        $option .= "<input class='flat' type='text' name='source' size='' value='".(isset($maxInvocation->source) ? htmlspecialchars(stripslashes($maxInvocation->source),ENT_QUOTES) : $this->defaultValues['source'])."' style='width:175px;' tabindex='".($maxInvocation->tabindex++)."'></td></tr>";
        $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
        return $option;
	}
    }
     
     
     
    function withtext()
    {
        $maxInvocation = &$this->maxInvocation;
        $maxInvocation = &$this->maxInvocation;
	
	/*$allowed_tag=array('invocationTags:oxInvocationTags:vast2',
'invocationTags:oxInvocationTags:ovast2');*/

	$allowed_tag=array('invocationTags:oxInvocationTags:vast1','invocationTags:oxInvocationTags:vast2',
'invocationTags:oxInvocationTags:vast3','invocationTags:oxInvocationTags:ovast1','invocationTags:oxInvocationTags:ovast2',
'invocationTags:oxInvocationTags:ovast3','invocationTags:oxInvocationTags:vastwrapper2',
'invocationTags:oxInvocationTags:vastwrapper3','invocationTags:oxInvocationTags:vastwrapper1','invocationTags:oxInvocationTags:vastoverlaywrapper1'
,'invocationTags:oxInvocationTags:vastoverlaywrapper2','invocationTags:oxInvocationTags:vastoverlaywrapper3','invocationTags:oxInvocationTags:vmapinline','invocationTags:oxInvocationTags:ovmap','invocationTags:oxInvocationTags:vast2without','invocationTags:oxInvocationTags:ovast2without','invocationTags:oxInvocationTags:vast2internal','invocationTags:oxInvocationTags:ovast2internal','invocationTags:oxInvocationTags:vast2internal','invocationTags:oxInvocationTags:ovast2internal');

	if(in_array($maxInvocation->codetype,$allowed_tag))
	{
	}
	else
	{

        $option = '';
        $option .= "<tr><td width='30'>&nbsp;</td>";
        $option .= "<td width='200'>".$GLOBALS['strInvocationWithText']."</td>";
        $option .= "<td width='370'><input type='radio' name='withtext' value='1'".(isset($maxInvocation->withtext) && $maxInvocation->withtext != 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']."<br />";
        $option .= "<input type='radio' name='withtext' value='0'".(!isset($maxInvocation->withtext) || $maxInvocation->withtext == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
        $option .= "</tr>";
        $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
        return $option;
	}
    }

    /**
     * Generate the HTML option
     *
     * @return string    A string containing html for option
     */
    function refresh()
    {
        $maxInvocation = &$this->maxInvocation;

        $option = '';
        $option .= "<tr><td width='30'>&nbsp;</td>";
        $option .= "<td width='200'>".$GLOBALS['strIFrameRefreshAfter']."</td><td width='370'>";
        $option .= "<input class='flat' type='text' name='refresh' size='' value='".(isset($maxInvocation->refresh) ? $maxInvocation->refresh : $this->defaultValues['refresh'])."' style='width:175px;' tabindex='".($maxInvocation->tabindex++)."'> ".$GLOBALS['strAbbrSeconds']."</td></tr>";
        $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
        return $option;
    }

    /**
     * Generate the HTML option
     *
     * @return string    A string containing html for option
     */
    function size()
    {
        $maxInvocation = &$this->maxInvocation;

        $option = '';
        if (!$maxInvocation->zone_invocation || ($maxInvocation->width == -1 || $maxInvocation->height == -1)) {
            $option .= "<tr><td width='30'>&nbsp;</td>";
            $option .= "<td width='200'>".$GLOBALS['strFrameSize']."</td><td width='370'>";
            $option .= $GLOBALS['strWidth'].": <input class='flat' type='text' name='frame_width' size='3' value='".((isset($maxInvocation->frame_width) && $maxInvocation->frame_width > 0) ? $maxInvocation->frame_width : '')."' tabindex='".($maxInvocation->tabindex++)."'>&nbsp;&nbsp;&nbsp;";
            $option .= $GLOBALS['strHeight'].": <input class='flat' type='text' name='frame_height' size='3' value='".((isset($maxInvocation->frame_height) &&  $maxInvocation->frame_height > 0) ? $maxInvocation->frame_height : '')."' tabindex='".($maxInvocation->tabindex++)."'>";
            $option .= "</td></tr>";
            $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
        }
        return $option;
    }

    /**
     * Generate the HTML option
     *
     * @return string    A string containing html for option
     */
    function resize()
    {
        $maxInvocation = &$this->maxInvocation;

        $option = '';
        if ($maxInvocation->server_same) {
            $option .= "<tr><td width='30'>&nbsp;</td>";
            $option .= "<td width='200'>".$GLOBALS['strIframeResizeToBanner']."</td>";
            $option .= "<td width='370'><input type='radio' name='resize' value='1'".(isset($maxInvocation->resize) && $maxInvocation->resize == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']."<br />";
            $option .= "<input type='radio' name='resize' value='0'".(!isset($maxInvocation->resize) || $maxInvocation->resize == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
            $option .= "</tr>";
            $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
        } else {
            $option .= "<input type='hidden' name='resize' value='0'>";
        }
        return $option;
    }

    /**
     * Generate the HTML option
     *
     * @return string    A string containing html for option
     */
    function transparent()
    {
        $maxInvocation = &$this->maxInvocation;

        $option = '';
        $option .= "<tr><td width='30'>&nbsp;</td>";
        $option .= "<td width='200'>".$GLOBALS['strIframeMakeTransparent']."</td>";
        $option .= "<td width='370'><input type='radio' name='transparent' value='1'".(isset($maxInvocation->transparent) && $maxInvocation->transparent == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']."<br />";
        $option .= "<input type='radio' name='transparent' value='0'".(!isset($maxInvocation->transparent) || $maxInvocation->transparent == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
        $option .= "</tr>";
        $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
        return $option;
    }

    /**
     * Generate the HTML option
     *
     * @return string    A string containing html for option
     */
    function ilayer()
    {
        $maxInvocation = &$this->maxInvocation;

        $option = '';
        $option .= "<tr><td width='30'>&nbsp;</td>";
        $option .= "<td width='200'>".$GLOBALS['strIframeIncludeNetscape4']."</td>";
        $option .= "<td width='370'><input type='radio' name='ilayer' value='1'".(isset($maxInvocation->ilayer) && $maxInvocation->ilayer == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']."<br />";
        $option .= "<input type='radio' name='ilayer' value='0'".(!isset($maxInvocation->ilayer) || $maxInvocation->ilayer == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
        $option .= "</tr>";
        $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
        return $option;
    }

    /**
     * Generate the HTML option
     *
     * @return string    A string containing html for option
     */
    function iframetracking()
    {
        $maxInvocation = &$this->maxInvocation;

        $option = '';
        $option .= "<tr><td width='30'>&nbsp;</td>";
        $option .= "<td width='200'>". $GLOBALS['strIframeGoogleClickTracking'] ."</td>";
        $option .= "<td width='370'><input type='radio' name='iframetracking' value='1'".(!isset($maxInvocation->iframetracking) || $maxInvocation->iframetracking == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']."<br />";
        $option .= "<input type='radio' name='iframetracking' value='0'".(isset($maxInvocation->iframetracking) && $maxInvocation->iframetracking == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
        $option .= "</tr>";
        $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
        return $option;
    }

    /**
     * Generate the HTML option
     *
     * @return string    A string containing html for option
    
    function block()
    {
        $maxInvocation = &$this->maxInvocation;

        $option = '';
        $option .= "<tr><td width='30'>&nbsp;</td>";
        $option .= "<td width='200'>".$GLOBALS['strInvocationDontShowAgain']."</td>";
        $option .= "<td width='370'><input type='radio' name='block' value='1'".(isset($maxInvocation->block) && $maxInvocation->block != 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']."<br />";
        $option .= "<input type='radio' name='block' value='0'".(!isset($maxInvocation->block) || $maxInvocation->block == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
        $option .= "</tr>";
        $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
        return $option;
    }*/
    function block()
    {
       
    $maxInvocation = &$this->maxInvocation; 
            
        $inlineplayer=array('invocationTags:oxInvocationTags:jwplayerinline');

        $overlayplayer=array('invocationTags:oxInvocationTags:jwplayeroverlay');
        
        $inline=array('invocationTags:oxInvocationTags:vast2internal');
        $overlay=array('invocationTags:oxInvocationTags:ovast2internal');
        
               
     /*    $inline=array('invocationTags:oxInvocationTags:vast1','invocationTags:oxInvocationTags:vast3','invocationTags:oxInvocationTags:vastwrapper2',
'invocationTags:oxInvocationTags:vastwrapper3','invocationTags:oxInvocationTags:vastwrapper1','invocationTags:oxInvocationTags:vastad3','invocationTags:oxInvocationTags:vastad4','invocationTags:oxInvocationTags:vast2without');

   $overlay=array('invocationTags:oxInvocationTags:ovast1','invocationTags:oxInvocationTags:ovast3','invocationTags:oxInvocationTags:vastoverlaywrapper1'
,'invocationTags:oxInvocationTags:vastoverlaywrapper2','invocationTags:oxInvocationTags:vastoverlaywrapper3','invocationTags:oxInvocationTags:ovast2without','invocationTags:oxInvocationTags:ovmap');

$vmap=array('invocationTags:oxInvocationTags:vmapinline');*/


    if(in_array($maxInvocation->codetype,$inlineplayer))
    {   
        
        //Video vast version  Inline Invocation tag Manivasaki March 3,2017
        $option .= "<tr><td width='30'>&nbsp;</td>";        
        $option .= "<tr><td width='30'>&nbsp;</td>";
        
        //Player Width and Height
        $option .= "<td width='200'> Player width and height<span style='color:red';>*</span><br/></td>";
        $option .= "<td width='370'>Width :
          <input type='text' name='pwidth' id='pwidth' ".(isset($maxInvocation->pwidth) ? $maxInvocation->pwidth : '')." tabindex='".($maxInvocation->tabindex++)."' required><b>px</b>&nbsp;&nbsp;Height : <input type='textbox' name='pheight' id='pheight' ".(isset($maxInvocation->pheight) ? $maxInvocation->pheight : '')." required><b>px</b><br/> </td>";
         
           //Player video Type RTMP & Progressive
        $option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Player original video Type<span style='color:red';>*</span> </td> ";
        $option .= "<td width='500'><br/><br/><input type='radio' name='ptype' value='1'".(!isset($maxInvocation->ptype) || $maxInvocation->ptype == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp; Progressive (HTTP) &nbsp;&nbsp; &nbsp; Video URL &nbsp; <input type='text' name='pvideo' id='pvideo' ".(isset($maxInvocation->pvideo) ? $maxInvocation->pvideo : '')." tabindex='".($maxInvocation->tabindex++)."' >";
        $option .= "<br/><br/><input type='radio' name='ptype' id='ptype' value='2'".(isset($maxInvocation->ptype) && $maxInvocation->ptype != 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp; Streaming (RTMP)  &nbsp;&nbsp;&nbsp; RTMP server URL <input type='text' name='rtmpurl' id='rtmpurl' ".(isset($maxInvocation->rtmpurl) ? $maxInvocation->rtmpurl : '')." tabindex='".($maxInvocation->tabindex++)."' > &nbsp; Video filename &nbsp;<input type='text' name='rtmpfile' id='rtmpfile' ".(isset($maxInvocation->rtmpfile) ? $maxInvocation->rtmpfile : '')." tabindex='".($maxInvocation->tabindex++)."' ><br/><br/></td></tr>";
        
        
        //Original video URL pass
        $option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Player Image url </td> ";
        $option .= "<td width='500'> <input type='text' name='pimg' id='pimg' ".(isset($maxInvocation->pimg) ? $maxInvocation->pimg : '')." tabindex='".($maxInvocation->tabindex++)."' ><br/><br/></td></tr>";
        //~ $option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Player original video duration  </td> ";
        //~ $option .= "<td width='500'> <input type='text' name='pduration' id='pduration' ".(isset($maxInvocation->pduration) ? $maxInvocation->pduration : '')." tabindex='".($maxInvocation->tabindex++)."' >Seconds<br/></td></tr>";
        
        //AutoPlay
        $option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Auto play </td> ";
        $option .= "<td width='500'> <input type='radio' name='autoplay' value='1'".(isset($maxInvocation->autoplay) && $maxInvocation->autoplay == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
            $option .= "<input type='radio' name='autoplay' value='2'".(!isset($maxInvocation->autoplay) || $maxInvocation->autoplay == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
        $option .= "</tr>";
        
        //Skip Ad
        $option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Skip ad</td> ";
        $option .= "<td width='500'> <input type='radio' name='skipad' value='1'".(isset($maxInvocation->skipad) && $maxInvocation->skipad == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
            $option .= "<input type='radio' name='skipad' value='2'".(!isset($maxInvocation->skipad) || $maxInvocation->skipad == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."<br/><br/><br/></td>";
        $option .= "</tr>";
        
        //Companion Ad
        $option .= "<tr><td width='50'>&nbsp;</td><td width='200' id='Companionlabel'>Companion ad</td> ";
        $option .= "<td width='500'> <input type='radio' name='compad' value='1'".(isset($maxInvocation->compad) && $maxInvocation->compad == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
        $option .= "<input type='radio' name='compad' value='2'".(!isset($maxInvocation->compad) || $maxInvocation->compad == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."<br/><br/></td><tr/>";
        //Companion Ad width & height
        $option .= "<tr><td width='50'>&nbsp;</td>
        <td width='200' id='Companionwidthlabel'>Companion Ad width and height</td>";
        $option .= "<td width='370' id='cwidt'>Width : <input type='text' name='cwidth' id='cwidth' ".(isset($maxInvocation->cwidth) ? $maxInvocation->cwidth : '')." tabindex='".($maxInvocation->tabindex++)."'>px&nbsp;&nbsp;Height : <input type='textbox' name='cheight' id='cheight' ".(isset($maxInvocation->cheight) ? $maxInvocation->cheight : '').">px<br/><br/> </td>";
        $option .= "</tr>";

        
        //Vast Version Listing 
        $option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Vast Version<span style='color:red';>*</span></td> ";
        $option .= "<td width='500'> <input type='radio' name='vast_version' id='vast_version2' value='2'".(isset($maxInvocation->vast_version) && $maxInvocation->vast_version == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;VAST 2.0 &nbsp; &nbsp;<br/>"; // vast 2.0
        
        $option .= "<input type='radio' name='vast_version' value='3'".(!isset($maxInvocation->vast_version) || $maxInvocation->vast_version == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;VAST 3.0 &nbsp; <br/>";// vast 3.0
         
        $option .= "<input type='radio' name='vast_version' value='4'".(!isset($maxInvocation->vast_version) || $maxInvocation->vast_version == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Vpaid 2.0 &nbsp;<br/>"; //Vast Ad pod

         
        $option .= "<input type='radio' name='vast_version' value='5'".(!isset($maxInvocation->vast_version) || $maxInvocation->vast_version == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Vpaid 3.0 &nbsp;<br/>"; //Wrapper 2.0
         
      //  $option .= "<input type='radio' name='vast_version' value='6'".(!isset($maxInvocation->vast_version) || $maxInvocation->vast_version == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Wrapper 3.0 &nbsp;<br/>"; //Wrapper 3.0
        
       // $option .= "<input type='radio' name='vast_version' value='7'".(!isset($maxInvocation->vast_version) || $maxInvocation->vast_version == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Vast Adpod Wrapper &nbsp;<br/>"; //Vast Ad pod Wrapper
        
       // $option .= "<input type='radio' name='vast_version' id='vastvmap' value='9'".(!isset($maxInvocation->vast_version) || $maxInvocation->vast_version == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;VMAP &nbsp;<br/>"; //VMAP
        
         
         //~ $option .= "<input type='radio' name='vast_version' value='7'".(!isset($maxInvocation->vast_version) || $maxInvocation->vast_version == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;HTML5 Inline &nbsp;<br/><br/></td>"; //HTML5 Inline
         $option .= "&nbsp;<br/><br/></tr>";
        
        //Ad Schedule For Inline Parameter
        $option .= "<tr><td width='50'>&nbsp;</td><td width='200' id='adposlabel'>Ad Schedule <span style='color:red';>*</span></td> ";
        $option .= "<td width='500' id='adschedule'> <input type='radio' name='adposition'  id='adposition2' value='1'".(isset($maxInvocation->adposition) && $maxInvocation->adposition == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Pre-roll &nbsp; &nbsp;<br/>";
        $option .= "<input type='radio' name='adposition' id='adposition' value='2'".(!isset($maxInvocation->adposition) || $maxInvocation->adposition == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Mid-roll &nbsp; Start Time : <input type='text' name='stime' id='stime' ".(isset($maxInvocation->stime) ? $maxInvocation->stime : '')." tabindex='".($maxInvocation->tabindex++)."'>Seconds<br/>";
        $option .= "<input type='radio' name='adposition' id='adposition' value='3'".(!isset($maxInvocation->adposition) || $maxInvocation->adposition == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Post-roll &nbsp;<br/><br/></td>";
        $option .= "</tr>";
        

        //JWplayer configuration start Manivasaki
        
        
        //Sharing player configuration
        $option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Sharing </td> ";
        $option .= "<td width='500'> <input type='radio' name='sharing' value='1'".(isset($maxInvocation->sharing) && $maxInvocation->sharing == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
            $option .= "<input type='radio' name='sharing' value='2'".(!isset($maxInvocation->sharing) || $maxInvocation->sharing == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
        $option .= "</tr>";
        
        //Mute or Unmute
        $option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Mute</td> ";
        $option .= "<td width='500'> <input type='radio' name='mute' value='1'".(isset($maxInvocation->mute) && $maxInvocation->mute == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
        $option .= "<input type='radio' name='mute' value='2'".(!isset($maxInvocation->mute) || $maxInvocation->mute == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
        $option .= "</tr>";
        
        //Repeat
        $option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Repeat</td> ";
        $option .= "<td width='500'> <input type='radio' name='repeat' value='1'".(isset($maxInvocation->repeat) && $maxInvocation->repeat == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
        $option .= "<input type='radio' name='repeat' value='2'".(!isset($maxInvocation->repeat) || $maxInvocation->repeat == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
        $option .= "</tr>";
        
        //Player Title
        $option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Player Title</td> ";
        $option .= "<td width='500'> <input type='radio' name='playertitle'  id='playertitle' value='1'".(isset($maxInvocation->playertitle) && $maxInvocation->playertitle == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
        $option .= "<input type='radio' name='playertitle' id='playertitle' value='2'".(!isset($maxInvocation->playertitle) || $maxInvocation->playertitle == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
        $option .= "</tr>";
        
        //Title
        $option .= "<tr><td width='50'>&nbsp;&nbsp;&nbsp;</td> <td width='200' id='titlelabel'>Title&nbsp;&nbsp;</td>";
        $option .= "<td width='450'>
          <input type='text' name='title' id='title' ".(isset($maxInvocation->title) ? $maxInvocation->title : '')." tabindex='".($maxInvocation->tabindex++)."'></td>";
        $option .= "</tr>";
        
        //description
        $option .= "<tr><td width='50'>&nbsp;&nbsp;&nbsp;</td> <td width='200' id='descriptionlabel'>Description &nbsp;&nbsp;</td>";
        $option .= "<td width='450'>
          <input type='text' name='description' id='description' ".(isset($maxInvocation->description) ? $maxInvocation->description : '')." tabindex='".($maxInvocation->tabindex++)."'></td>";
        $option .= "</tr>";
        
        //Stretching 
        $stretching = (!empty($maxInvocation->stretching)) ? $maxInvocation->stretching : $this->defaultValues['stretching'];
        $option .= "<tr><td width='50'>&nbsp;&nbsp;&nbsp;</td> 
        <td width='200' id='stretchinglabel'>Stretching &nbsp;&nbsp;</td>";
        $option .= "<td width='370'>
        <select name='stretching' tabindex='".($maxInvocation->tabindex++)."'>
               
                <option value='uniform'" . ($stretching == 'uniform' ? " selected='selected'" : '') . ">Uniform</option>
                <option value='none'" . ($stretching == 'none' ? " selected='selected'" : '') . ">None</option>
                <option value='exactfit'" . ($stretching == 'exactfit' ? " selected='selected'" : '') . ">Exactfit</option>
                 <option value='fill'" . ($stretching == 'fill' ? " selected='selected'" : '') . ">Fill</option>
            </select> </td>";
         $option .= "</tr>";
        //JWplayer configuration End Manivasaki
 
        
        //Script 
        $option .= "<script src='https://ajax.googleapis.com/ajax/libs/jquery/3.1.1/jquery.min.js'></script>";
        $option .= "
        <script>
			var jq = jQuery.noConflict(true);
		</script>
<script type='text/javascript'>
        jq(document).ready(function(){
        
        jq('#title').hide();
        jq('#titlelabel').hide();
        jq('#description').hide();
        jq('#descriptionlabel').hide();
        jq('#Companionwidthlabel').hide();
        jq('#descriptionlabel').hide();
        jq('#cwidt').hide();
        jq('input[id=vast_version2]').prop('checked', true);    
        jq('input[id=adposition2]').prop('checked', true);  
        
       jq('input[name=playertitle]').on('click',function(){ 
            var playertitle=jQuery(this).attr('value');
            if(playertitle=='1')
            {
                jq('#title').show();
                jq('#titlelabel').show();
                jq('#description').show();
                jq('#descriptionlabel').show();
                
            }
            else 
            {   
                jq('#title').hide();
                jq('#titlelabel').hide();
                jq('#description').hide();
                jq('#descriptionlabel').hide();
            }
        
            
        });
        
        jq('input[name=compad]').on('click',function(){  
            var compad=jQuery(this).attr('value');
            if(compad=='1')
            {
                jq('#Companionwidthlabel').show();
                jq('#cwidt').show();
                
            }
            else 
            {   
                jq('#Companionwidthlabel').hide();
                jq('#cwidt').hide();
                
            }
        
            
        });
        
        jq('input[name=vast_version]').on('click',function(){    
            var vast_version=jQuery(this).attr('value');
            if(vast_version=='9')
            {
                jq('#adposlabel').hide();
                jq('#adschedule').hide();               
            }
            else
            {
                jq('#adposlabel').show();
                jq('#adschedule').show();       
            }
    
        
        });
    
    
            });
        </script>";
        
        
        

        
        
         return $option;

    }
    //overlay starts here
    else if(in_array($maxInvocation->codetype,$overlayplayer))
    {

        //Video vast version  Inline Invocation tag Manivasaki March 3,2017
        $option .= "<tr><td width='30'>&nbsp;</td>";        
        $option .= "<tr><td width='30'>&nbsp;</td>";
        
        //Player Width and Height
        $option .= "<td width='200'> Player width and height <span style='color:red';>*</span><br/></td>";
        $option .= "<td width='370'>Width :
          <input type='text' name='pwidth' id='pwidth' ".(isset($maxInvocation->pwidth) ? $maxInvocation->pwidth : '')." tabindex='".($maxInvocation->tabindex++)."' required><b>px</b>&nbsp;&nbsp;Height : <input type='textbox' name='pheight' id='pheight' ".(isset($maxInvocation->pheight) ? $maxInvocation->pheight : '')."required><b>px</b><br/> </td>";
         
         //Player video Type RTMP & Progressive
        $option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Player original video Type <span style='color:red';>*</span></td> ";
        $option .= "<td width='500'><br/><br/><input type='radio' name='ptype' value='1'".(!isset($maxInvocation->ptype) || $maxInvocation->ptype == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp; Progressive (HTTP) &nbsp;&nbsp; &nbsp; Video URL &nbsp; <input type='text' name='pvideo' id='pvideo' ".(isset($maxInvocation->pvideo) ? $maxInvocation->pvideo : '')." tabindex='".($maxInvocation->tabindex++)."' >";
        
        $option .= "<br/><br/><input type='radio' name='ptype' id='ptype' value='2'".(isset($maxInvocation->ptype) && $maxInvocation->ptype != 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp; Streaming (RTMP)  &nbsp;&nbsp;&nbsp; RTMP server URL <input type='text' name='rtmpurl' id='rtmpurl' ".(isset($maxInvocation->rtmpurl) ? $maxInvocation->rtmpurl : '')." tabindex='".($maxInvocation->tabindex++)."' > &nbsp; Video filename &nbsp;<input type='text' name='rtmpfile' id='rtmpfile' ".(isset($maxInvocation->rtmpfile) ? $maxInvocation->rtmpfile : '')." tabindex='".($maxInvocation->tabindex++)."' ><br/><br/></td></tr>";

        
        //Original video URL pass
        $option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Player Image url </td> ";
        $option .= "<td width='500'> <input type='text' name='pimg' id='pimg' ".(isset($maxInvocation->pimg) ? $maxInvocation->pimg : '')." tabindex='".($maxInvocation->tabindex++)."' ><br/><br/></td></tr>";
        //~ $option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Player original video duration  </td> ";
        //~ $option .= "<td width='500'> <input type='text' name='pduration' id='pduration' ".(isset($maxInvocation->pduration) ? $maxInvocation->pduration : '')." tabindex='".($maxInvocation->tabindex++)."' >Seconds<br/></td></tr>";
        
        //AutoPlay
        $option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Auto play </td> ";
        $option .= "<td width='500'> <input type='radio' name='autoplay' value='1'".(isset($maxInvocation->autoplay) && $maxInvocation->autoplay == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
            $option .= "<input type='radio' name='autoplay' value='2'".(!isset($maxInvocation->autoplay) || $maxInvocation->autoplay == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
        $option .= "</tr>";
        
        //Skip Ad
        $option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Skip ad</td> ";
        $option .= "<td width='500'> <input type='radio' name='skipad' value='1'".(isset($maxInvocation->skipad) && $maxInvocation->skipad == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
            $option .= "<input type='radio' name='skipad' value='2'".(!isset($maxInvocation->skipad) || $maxInvocation->skipad == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."<br/><br/><br/></td>";
        $option .= "</tr>";
        
        //Companion Ad
        $option .= "<tr><td width='50'>&nbsp;</td><td width='200' id='Companionlabel'>Companion ad</td> ";
        $option .= "<td width='500'> <input type='radio' name='compad' value='1'".(isset($maxInvocation->compad) && $maxInvocation->compad == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
        $option .= "<input type='radio' name='compad' value='2'".(!isset($maxInvocation->compad) || $maxInvocation->compad == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."<br/><br/></td><tr/>";
        //Companion Ad width & height
        $option .= "<tr><td width='50'>&nbsp;</td>
        <td width='200' id='Companionwidthlabel'>Companion Ad width and height</td>";
        $option .= "<td width='370' id='cwidt'>Width : <input type='text' name='cwidth' id='cwidth' ".(isset($maxInvocation->cwidth) ? $maxInvocation->cwidth : '')." tabindex='".($maxInvocation->tabindex++)."'>px&nbsp;&nbsp;Height : <input type='textbox' name='cheight' id='cheight' ".(isset($maxInvocation->cheight) ? $maxInvocation->cheight : '').">px<br/><br/> </td>";
        $option .= "</tr>";

        
        //Vast Version Listing 
        $option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Vast Version<span style='color:red';>*</span></td> ";
        $option .= "<td width='500'> <input type='radio' name='vast_version' id='vast_version2'  value='2'".(isset($maxInvocation->vast_version) && $maxInvocation->vast_version == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;VAST 2.0 &nbsp; &nbsp;<br/>"; // vast 2.0
        
        $option .= "<input type='radio' name='vast_version' value='3'".(!isset($maxInvocation->vast_version) || $maxInvocation->vast_version == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;VAST 3.0 &nbsp; <br/>";// vast 3.0
         
        $option .= "<input type='radio' name='vast_version' value='4'".(!isset($maxInvocation->vast_version) || $maxInvocation->vast_version == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Vpaid 2.0 &nbsp;<br/>"; //Vast Ad pod

         
        $option .= "<input type='radio' name='vast_version' value='5'".(!isset($maxInvocation->vast_version) || $maxInvocation->vast_version == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Vpaid 3.0 &nbsp;<br/>"; //Wrapper 2.0
         
       // $option .= "<input type='radio' name='vast_version' value='6'".(!isset($maxInvocation->vast_version) || $maxInvocation->vast_version == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Wrapper 3.0 &nbsp;<br/>"; //Wrapper 3.0
         
       // $option .= "<input type='radio' name='vast_version' value='7'".(!isset($maxInvocation->vast_version) || $maxInvocation->vast_version == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Vast Adpod Wrapper &nbsp;<br/>"; //Vast Ad pod Wrapper
        
        
        //$option .= "<input type='radio' name='vast_version'  value='9'".(!isset($maxInvocation->vast_version) || $maxInvocation->vast_version == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;VMAP &nbsp;<br/>"; //VMAP
        

        $option .= "&nbsp;<br/><br/></tr>";
        
        
        //Ad Schedule For Inline Parameter
        $option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Ad Schedule<span style='color:red';>*</span></td> ";
        $option .= "<td width='500' id='adschedule'> <input type='radio' name='adposition'  id='adposition2' value='1'".(isset($maxInvocation->adposition) && $maxInvocation->adposition == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Pre-roll &nbsp; &nbsp;<br/>";
        $option .= "<input type='radio' name='adposition' id='adposition' value='2'".(!isset($maxInvocation->adposition) || $maxInvocation->adposition == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Mid-roll &nbsp;Start Time : <input type='text' name='stime' id='stime' ".(isset($maxInvocation->stime) ? $maxInvocation->stime : '')." tabindex='".($maxInvocation->tabindex++)."'>Seconds<br/>";
        $option .= "<input type='radio' name='adposition' id='adposition' value='3'".(!isset($maxInvocation->adposition) || $maxInvocation->adposition == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Post-roll &nbsp;<br/><br/></td>";
        $option .= "</tr>";
        //$option .= "<td width='500'>Starting Time : <input type='text' name='adstime' id='adstime' ".(isset($maxInvocation->adstime) ? $maxInvocation->adstime : '')." tabindex='".($maxInvocation->tabindex++)."'>Seconds<br/>";
       // $option .= "<br/></tr>";


        //$option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Ad duration <span style='color:red';>*</span> </td> ";
       // $option .= "<td width='500'>Ending Time : <input type='text' name='adduration' id='adduration' ".(isset($maxInvocation->adduration) ? $maxInvocation->adduration : '')." tabindex='".($maxInvocation->tabindex++)."' >Seconds<br/></td></tr>";



        //JWplayer configuration start Manivasaki
        
        
        //Sharing player configuration
        $option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Sharing </td> ";
        $option .= "<td width='500'> <input type='radio' name='sharing' value='1'".(isset($maxInvocation->sharing) && $maxInvocation->sharing == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
            $option .= "<input type='radio' name='sharing' value='2'".(!isset($maxInvocation->sharing) || $maxInvocation->sharing == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
        $option .= "</tr>";
        
        //Mute or Unmute
        $option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Mute</td> ";
        $option .= "<td width='500'> <input type='radio' name='mute' value='1'".(isset($maxInvocation->mute) && $maxInvocation->mute == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
        $option .= "<input type='radio' name='mute' value='2'".(!isset($maxInvocation->mute) || $maxInvocation->mute == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
        $option .= "</tr>";
        
        //Repeat
        $option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Repeat</td> ";
        $option .= "<td width='500'> <input type='radio' name='repeat' value='1'".(isset($maxInvocation->repeat) && $maxInvocation->repeat == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
        $option .= "<input type='radio' name='repeat' value='2'".(!isset($maxInvocation->repeat) || $maxInvocation->repeat == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
        $option .= "</tr>";
        
        //Player Title
        $option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Player Title</td> ";
        $option .= "<td width='500'> <input type='radio' name='playertitle'  id='playertitle' value='1'".(isset($maxInvocation->playertitle) && $maxInvocation->playertitle == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
        $option .= "<input type='radio' name='playertitle' id='playertitle' value='2'".(!isset($maxInvocation->playertitle) || $maxInvocation->playertitle == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."<br/><br/></td>";
        $option .= "</tr>";
        
        //Title
        $option .= "<tr><td width='50'>&nbsp;&nbsp;&nbsp;</td> <td width='200' id='titlelabel'>Title&nbsp;&nbsp;</td>";
        $option .= "<td width='450'>
          <input type='text' name='title' id='title' ".(isset($maxInvocation->title) ? $maxInvocation->title : '')." tabindex='".($maxInvocation->tabindex++)."'><br/><br/></td>";
        $option .= "</tr>";
        
        //description
        $option .= "<tr><td width='50'>&nbsp;&nbsp;&nbsp;</td> <td width='200' id='descriptionlabel'>Description &nbsp;&nbsp;</td>";
        $option .= "<td width='450'>
          <input type='text' name='description' id='description' ".(isset($maxInvocation->description) ? $maxInvocation->description : '')." tabindex='".($maxInvocation->tabindex++)."'><br/><br/></td>";
        $option .= "</tr>";
        
        //Stretching 
        $stretching = (!empty($maxInvocation->stretching)) ? $maxInvocation->stretching : $this->defaultValues['stretching'];
        $option .= "<tr><td width='50'>&nbsp;&nbsp;&nbsp;</td> 
        <td width='200' id='stretchinglabel'>Stretching &nbsp;&nbsp;</td>";
        $option .= "<td width='370'>
        <select name='stretching' tabindex='".($maxInvocation->tabindex++)."'>
               
                <option value='uniform'" . ($stretching == 'uniform' ? " selected='selected'" : '') . ">Uniform</option>
                <option value='none'" . ($stretching == 'none' ? " selected='selected'" : '') . ">None</option>
                <option value='exactfit'" . ($stretching == 'exactfit' ? " selected='selected'" : '') . ">Exactfit</option>
                 <option value='fill'" . ($stretching == 'fill' ? " selected='selected'" : '') . ">Fill</option>
            </select> </td>";
         $option .= "</tr>";
        //JWplayer configuration End Manivasaki
 
        
        //Script 
        $option .= "<script src='https://ajax.googleapis.com/ajax/libs/jquery/3.1.1/jquery.min.js'></script>";
        $option .= "
        <script>
			var jq = jQuery.noConflict(true);
		</script>
        <script type='text/javascript'>
        jq(document).ready(function(){
        
        jq('#title').hide();
        jq('#titlelabel').hide();
        jq('#description').hide();
        jq('#descriptionlabel').hide();
        jq('#Companionwidthlabel').hide();
        jq('#descriptionlabel').hide();
        jq('#cwidt').hide();
        jq('input[id=vast_version2]').prop('checked', true);    
        
        jq('input[name=playertitle]').on('click',function(){ 
            var playertitle=jQuery(this).attr('value');
            if(playertitle=='1')
            {
                jq('#title').show();
                jq('#titlelabel').show();
                jq('#description').show();
                jq('#descriptionlabel').show();
                
            }
            else 
            {   
                jq('#title').hide();
                jq('#titlelabel').hide();
                jq('#description').hide();
                jq('#descriptionlabel').hide();
            }
        
            
        });
        
        jq('input[name=compad]').on('click',function(){  
            var compad=jQuery(this).attr('value');
            if(compad=='1')
            {
                jq('#Companionwidthlabel').show();
                jq('#cwidt').show();
                
            }
            else 
            {   
                jq('#Companionwidthlabel').hide();
                jq('#cwidt').hide();
                
            }
        
            
        });
        
        
        
        
        
    
            });
        </script>";


        return $option;


    }
   
  else if(in_array($maxInvocation->codetype,$inline))
    {   
		
		//Video vast version  Inline Invocation tag Manivasaki March 3,2017
		$option .= "<tr><td width='30'>&nbsp;</td>";        
		$option .= "<tr><td width='30'>&nbsp;</td>";
		
		//Player Width and Height
		$option .= "<td width='200'> Player width and height<span style='color:red';>*</span><br/></td>";
	    $option .= "<td width='370'>Width :
	      <input type='text' name='pwidth' id='pwidth' ".(isset($maxInvocation->pwidth) ? $maxInvocation->pwidth : '')." tabindex='".($maxInvocation->tabindex++)."' required><b>px</b>&nbsp;&nbsp;Height : <input type='textbox' name='pheight' id='pheight' ".(isset($maxInvocation->pheight) ? $maxInvocation->pheight : '')." required><b>px</b><br/> </td>";
	     
	       //Player video Type RTMP & Progressive
		$option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Player original video Type<span style='color:red';>*</span> </td> ";
		$option .= "<td width='500'><br/><br/><input type='radio' name='ptype' value='1'".(!isset($maxInvocation->ptype) || $maxInvocation->ptype == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp; Progressive (HTTP) &nbsp;&nbsp; &nbsp; Video URL &nbsp; <input type='text' name='pvideo' id='pvideo' ".(isset($maxInvocation->pvideo) ? $maxInvocation->pvideo : '')." tabindex='".($maxInvocation->tabindex++)."' >";
        $option .= "<br/><br/><input type='radio' name='ptype' id='ptype' value='2'".(isset($maxInvocation->ptype) && $maxInvocation->ptype != 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp; Streaming (RTMP)  &nbsp;&nbsp;&nbsp; RTMP server URL <input type='text' name='rtmpurl' id='rtmpurl' ".(isset($maxInvocation->rtmpurl) ? $maxInvocation->rtmpurl : '')." tabindex='".($maxInvocation->tabindex++)."' > &nbsp; Video filename &nbsp;<input type='text' name='rtmpfile' id='rtmpfile' ".(isset($maxInvocation->rtmpfile) ? $maxInvocation->rtmpfile : '')." tabindex='".($maxInvocation->tabindex++)."' ><br/><br/></td></tr>";
        
        
        //Original video URL pass
		$option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Player Image url </td> ";
		$option .= "<td width='500'> <input type='text' name='pimg' id='pimg' ".(isset($maxInvocation->pimg) ? $maxInvocation->pimg : '')." tabindex='".($maxInvocation->tabindex++)."' ><br/><br/></td></tr>";
 		//~ $option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Player original video duration  </td> ";
		//~ $option .= "<td width='500'> <input type='text' name='pduration' id='pduration' ".(isset($maxInvocation->pduration) ? $maxInvocation->pduration : '')." tabindex='".($maxInvocation->tabindex++)."' >Seconds<br/></td></tr>";
		
		//AutoPlay
		$option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Auto play </td> ";
		$option .= "<td width='500'> <input type='radio' name='autoplay' value='1'".(isset($maxInvocation->autoplay) && $maxInvocation->autoplay == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
            $option .= "<input type='radio' name='autoplay' value='2'".(!isset($maxInvocation->autoplay) || $maxInvocation->autoplay == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
 		$option .= "</tr>";
 		
 		//Skip Ad
		$option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Skip ad</td> ";
		$option .= "<td width='500'> <input type='radio' name='skipad' value='1'".(isset($maxInvocation->skipad) && $maxInvocation->skipad == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
            $option .= "<input type='radio' name='skipad' value='2'".(!isset($maxInvocation->skipad) || $maxInvocation->skipad == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."<br/><br/><br/></td>";
 		$option .= "</tr>";
 		
 		//Companion Ad
 		$option .= "<tr><td width='50'>&nbsp;</td><td width='200' id='Companionlabel'>Companion ad</td> ";
		$option .= "<td width='500'> <input type='radio' name='compad' value='1'".(isset($maxInvocation->compad) && $maxInvocation->compad == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
        $option .= "<input type='radio' name='compad' value='2'".(!isset($maxInvocation->compad) || $maxInvocation->compad == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."<br/><br/></td><tr/>";
 		//Companion Ad width & height
		$option .= "<tr><td width='50'>&nbsp;</td>
		<td width='200' id='Companionwidthlabel'>Companion Ad width and height</td>";
	    $option .= "<td width='370' id='cwidt'>Width : <input type='text' name='cwidth' id='cwidth' ".(isset($maxInvocation->cwidth) ? $maxInvocation->cwidth : '')." tabindex='".($maxInvocation->tabindex++)."'>px&nbsp;&nbsp;Height : <input type='textbox' name='cheight' id='cheight' ".(isset($maxInvocation->cheight) ? $maxInvocation->cheight : '').">px<br/><br/> </td>";
		$option .= "</tr>";

 		
 		//Vast Version Listing 
 		$option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Vast Version<span style='color:red';>*</span></td> ";
		$option .= "<td width='500'> <input type='radio' name='vast_version' id='vast_version2' value='2'".(isset($maxInvocation->vast_version) && $maxInvocation->vast_version == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;VAST 2.0 &nbsp; &nbsp;<br/>"; // vast 2.0
		
        $option .= "<input type='radio' name='vast_version' value='3'".(!isset($maxInvocation->vast_version) || $maxInvocation->vast_version == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;VAST 3.0 &nbsp; <br/>";// vast 3.0
         
        $option .= "<input type='radio' name='vast_version' value='4'".(!isset($maxInvocation->vast_version) || $maxInvocation->vast_version == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Vast Adpod &nbsp;<br/>"; //Vast Ad pod

         
		$option .= "<input type='radio' name='vast_version' value='5'".(!isset($maxInvocation->vast_version) || $maxInvocation->vast_version == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Wrapper 2.0 &nbsp;<br/>"; //Wrapper 2.0
		 
		$option .= "<input type='radio' name='vast_version' value='6'".(!isset($maxInvocation->vast_version) || $maxInvocation->vast_version == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Wrapper 3.0 &nbsp;<br/>"; //Wrapper 3.0
		
		$option .= "<input type='radio' name='vast_version' value='7'".(!isset($maxInvocation->vast_version) || $maxInvocation->vast_version == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Vast Adpod Wrapper &nbsp;<br/>"; //Vast Ad pod Wrapper
		
		
		 $option .= "&nbsp;<br/><br/></tr>";
 		
		//Ad Schedule For Inline Parameter
		$option .= "<tr><td width='50'>&nbsp;</td><td width='200' id='adposlabel'>Ad Schedule <span style='color:red';>*</span></td> ";
		$option .= "<td width='500' id='adschedule'> <input type='radio' name='adposition'  id='adposition2' value='1'".(isset($maxInvocation->adposition) && $maxInvocation->adposition == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Pre-roll &nbsp; &nbsp;<br/>";
        $option .= "<input type='radio' name='adposition' id='adposition' value='2'".(!isset($maxInvocation->adposition) || $maxInvocation->adposition == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Mid-roll &nbsp; Start Time : <input type='text' name='stime' id='stime' ".(isset($maxInvocation->stime) ? $maxInvocation->stime : '')." tabindex='".($maxInvocation->tabindex++)."'>Seconds<br/>";
		$option .= "<input type='radio' name='adposition' id='adposition' value='3'".(!isset($maxInvocation->adposition) || $maxInvocation->adposition == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Post-roll &nbsp;<br/><br/></td>";
 		$option .= "</tr>";
 		

 		//JWplayer configuration start Manivasaki
 		
 		
 		//Sharing player configuration
 		$option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Sharing </td> ";
		$option .= "<td width='500'> <input type='radio' name='sharing' value='1'".(isset($maxInvocation->sharing) && $maxInvocation->sharing == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
            $option .= "<input type='radio' name='sharing' value='2'".(!isset($maxInvocation->sharing) || $maxInvocation->sharing == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
 		$option .= "</tr>";
 		
 		//Mute or Unmute
 		$option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Mute</td> ";
		$option .= "<td width='500'> <input type='radio' name='mute' value='1'".(isset($maxInvocation->mute) && $maxInvocation->mute == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
        $option .= "<input type='radio' name='mute' value='2'".(!isset($maxInvocation->mute) || $maxInvocation->mute == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
 		$option .= "</tr>";
 		
 		//Repeat
 		$option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Repeat</td> ";
		$option .= "<td width='500'> <input type='radio' name='repeat' value='1'".(isset($maxInvocation->repeat) && $maxInvocation->repeat == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
        $option .= "<input type='radio' name='repeat' value='2'".(!isset($maxInvocation->repeat) || $maxInvocation->repeat == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
 		$option .= "</tr>";
 		
 		//Player Title
 		$option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Player Title</td> ";
		$option .= "<td width='500'> <input type='radio' name='playertitle'  id='playertitle' value='1'".(isset($maxInvocation->playertitle) && $maxInvocation->playertitle == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
		$option .= "<input type='radio' name='playertitle' id='playertitle' value='2'".(!isset($maxInvocation->playertitle) || $maxInvocation->playertitle == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
 		$option .= "</tr>";
 		
 		//Title
 		$option .= "<tr><td width='50'>&nbsp;&nbsp;&nbsp;</td> <td width='200' id='titlelabel'>Title&nbsp;&nbsp;</td>";
 		$option .= "<td width='450'>
	      <input type='text' name='title' id='title' ".(isset($maxInvocation->title) ? $maxInvocation->title : '')." tabindex='".($maxInvocation->tabindex++)."'></td>";
 		$option .= "</tr>";
 		
 		//description
 		$option .= "<tr><td width='50'>&nbsp;&nbsp;&nbsp;</td> <td width='200' id='descriptionlabel'>Description &nbsp;&nbsp;</td>";
 		$option .= "<td width='450'>
	      <input type='text' name='description' id='description' ".(isset($maxInvocation->description) ? $maxInvocation->description : '')." tabindex='".($maxInvocation->tabindex++)."'></td>";
 		$option .= "</tr>";
 		
 		//Stretching 
 		$stretching = (!empty($maxInvocation->stretching)) ? $maxInvocation->stretching : $this->defaultValues['stretching'];
 		$option .= "<tr><td width='50'>&nbsp;&nbsp;&nbsp;</td> 
 		<td width='200' id='stretchinglabel'>Stretching &nbsp;&nbsp;</td>";
 		$option .= "<td width='370'>
 		<select name='stretching' tabindex='".($maxInvocation->tabindex++)."'>
               
                <option value='uniform'" . ($stretching == 'uniform' ? " selected='selected'" : '') . ">Uniform</option>
                <option value='none'" . ($stretching == 'none' ? " selected='selected'" : '') . ">None</option>
                <option value='exactfit'" . ($stretching == 'exactfit' ? " selected='selected'" : '') . ">Exactfit</option>
                 <option value='fill'" . ($stretching == 'fill' ? " selected='selected'" : '') . ">Fill</option>
            </select> </td>";
 		 $option .= "</tr>";
 		//JWplayer configuration End Manivasaki
 
 		
 		//Script 
 		$option .= "<script src='https://ajax.googleapis.com/ajax/libs/jquery/3.1.1/jquery.min.js'></script>";
 		$option .= "
 		<script>
			var jq = jQuery.noConflict(true);
		</script><script type='text/javascript'>
 		jq(document).ready(function(){
 		
 		jq('#title').hide();
 		jq('#titlelabel').hide();
 		jq('#description').hide();
		jq('#descriptionlabel').hide();
		jq('#Companionwidthlabel').hide();
		jq('#descriptionlabel').hide();
		jq('#cwidt').hide();
		jq('input[id=vast_version2]').prop('checked', true);	
		jq('input[id=adposition2]').prop('checked', true);	
 		
		jq('input[name=playertitle]').on('click',function(){	
			var playertitle=jQuery(this).attr('value');
			if(playertitle=='1')
			{
				jq('#title').show();
				jq('#titlelabel').show();
				jq('#description').show();
				jq('#descriptionlabel').show();
				
			}
			else 
			{	
				jq('#title').hide();
				jq('#titlelabel').hide();
				jq('#description').hide();
				jq('#descriptionlabel').hide();
			}
		
			
 		});
 		
 		jq('input[name=compad]').on('click',function(){	
			var compad=jQuery(this).attr('value');
			if(compad=='1')
			{
				jq('#Companionwidthlabel').show();
				jq('#cwidt').show();
				
			}
			else 
			{	
				jq('#Companionwidthlabel').hide();
				jq('#cwidt').hide();
				
			}
		
			
 		});
 		
 		jq('input[name=vast_version]').on('click',function(){	
			var vast_version=jQuery(this).attr('value');
			if(vast_version=='9')
			{
				jq('#adposlabel').hide();
				jq('#adschedule').hide();				
			}
			else
			{
				jq('#adposlabel').show();
				jq('#adschedule').show();		
			}
	
 		
		});
	
 	
			});
 		</script>";
 		if($maxInvocation->codetype=='invocationTags:oxInvocationTags:vastad3' || $maxInvocation->codetype=='invocationTags:oxInvocationTags:vastad4')
		{ 
			 $option .= "<tr><td width='30'>&nbsp;</td>";
			$option .= "<td width='200'>Duration</td><td width='370'>";
			$option .= "<input class='flat' type='text' name='duration' size='' value='".(isset($maxInvocation->duration) ? htmlspecialchars(stripslashes($maxInvocation->duration),ENT_QUOTES) : 15)."' style='width:175px;' tabindex='".($maxInvocation->tabindex++)."'></td></tr>";
			$option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
		}

		 return $option;
   
      }
   else if(in_array($maxInvocation->codetype,$overlay))
    {   
   //Video vast version  Inline Invocation tag Manivasaki March 3,2017
		$option .= "<tr><td width='30'>&nbsp;</td>";        
		$option .= "<tr><td width='30'>&nbsp;</td>";
		
		//Player Width and Height
		$option .= "<td width='200'> Player width and height <span style='color:red';>*</span><br/></td>";
	    $option .= "<td width='370'>Width :
	      <input type='text' name='pwidth' id='pwidth' ".(isset($maxInvocation->pwidth) ? $maxInvocation->pwidth : '')." tabindex='".($maxInvocation->tabindex++)."' required><b>px</b>&nbsp;&nbsp;Height : <input type='textbox' name='pheight' id='pheight' ".(isset($maxInvocation->pheight) ? $maxInvocation->pheight : '')."required><b>px</b><br/> </td>";
	     
	     //Player video Type RTMP & Progressive
		$option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Player original video Type <span style='color:red';>*</span></td> ";
		$option .= "<td width='500'><br/><br/><input type='radio' name='ptype' value='1'".(!isset($maxInvocation->ptype) || $maxInvocation->ptype == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp; Progressive (HTTP) &nbsp;&nbsp; &nbsp; Video URL &nbsp; <input type='text' name='pvideo' id='pvideo' ".(isset($maxInvocation->pvideo) ? $maxInvocation->pvideo : '')." tabindex='".($maxInvocation->tabindex++)."' >";
        
        $option .= "<br/><br/><input type='radio' name='ptype' id='ptype' value='2'".(isset($maxInvocation->ptype) && $maxInvocation->ptype != 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp; Streaming (RTMP)  &nbsp;&nbsp;&nbsp; RTMP server URL <input type='text' name='rtmpurl' id='rtmpurl' ".(isset($maxInvocation->rtmpurl) ? $maxInvocation->rtmpurl : '')." tabindex='".($maxInvocation->tabindex++)."' > &nbsp; Video filename &nbsp;<input type='text' name='rtmpfile' id='rtmpfile' ".(isset($maxInvocation->rtmpfile) ? $maxInvocation->rtmpfile : '')." tabindex='".($maxInvocation->tabindex++)."' ><br/><br/></td></tr>";

        
        //Original video URL pass
		$option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Player Image url </td> ";
		$option .= "<td width='500'> <input type='text' name='pimg' id='pimg' ".(isset($maxInvocation->pimg) ? $maxInvocation->pimg : '')." tabindex='".($maxInvocation->tabindex++)."' ><br/><br/></td></tr>";
 		//~ $option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Player original video duration  </td> ";
		//~ $option .= "<td width='500'> <input type='text' name='pduration' id='pduration' ".(isset($maxInvocation->pduration) ? $maxInvocation->pduration : '')." tabindex='".($maxInvocation->tabindex++)."' >Seconds<br/></td></tr>";
		
		//AutoPlay
		$option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Auto play </td> ";
		$option .= "<td width='500'> <input type='radio' name='autoplay' value='1'".(isset($maxInvocation->autoplay) && $maxInvocation->autoplay == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
            $option .= "<input type='radio' name='autoplay' value='2'".(!isset($maxInvocation->autoplay) || $maxInvocation->autoplay == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
 		$option .= "</tr>";
 		
 		//Skip Ad
		$option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Skip ad</td> ";
		$option .= "<td width='500'> <input type='radio' name='skipad' value='1'".(isset($maxInvocation->skipad) && $maxInvocation->skipad == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
            $option .= "<input type='radio' name='skipad' value='2'".(!isset($maxInvocation->skipad) || $maxInvocation->skipad == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."<br/><br/><br/></td>";
 		$option .= "</tr>";
 		
 		//Companion Ad
 		$option .= "<tr><td width='50'>&nbsp;</td><td width='200' id='Companionlabel'>Companion ad</td> ";
		$option .= "<td width='500'> <input type='radio' name='compad' value='1'".(isset($maxInvocation->compad) && $maxInvocation->compad == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
        $option .= "<input type='radio' name='compad' value='2'".(!isset($maxInvocation->compad) || $maxInvocation->compad == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."<br/><br/></td><tr/>";
 		//Companion Ad width & height
		$option .= "<tr><td width='50'>&nbsp;</td>
		<td width='200' id='Companionwidthlabel'>Companion Ad width and height</td>";
	    $option .= "<td width='370' id='cwidt'>Width : <input type='text' name='cwidth' id='cwidth' ".(isset($maxInvocation->cwidth) ? $maxInvocation->cwidth : '')." tabindex='".($maxInvocation->tabindex++)."'>px&nbsp;&nbsp;Height : <input type='textbox' name='cheight' id='cheight' ".(isset($maxInvocation->cheight) ? $maxInvocation->cheight : '').">px<br/><br/> </td>";
		$option .= "</tr>";

 		
 		//Vast Version Listing 
 		$option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Vast Version<span style='color:red';>*</span></td> ";
		$option .= "<td width='500'> <input type='radio' name='vast_version' id='vast_version2'  value='2'".(isset($maxInvocation->vast_version) && $maxInvocation->vast_version == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;VAST 2.0 &nbsp; &nbsp;<br/>"; // vast 2.0
		
        $option .= "<input type='radio' name='vast_version' value='3'".(!isset($maxInvocation->vast_version) || $maxInvocation->vast_version == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;VAST 3.0 &nbsp; <br/>";// vast 3.0
         
        $option .= "<input type='radio' name='vast_version' value='4'".(!isset($maxInvocation->vast_version) || $maxInvocation->vast_version == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Vast Adpod &nbsp;<br/>"; //Vast Ad pod

         
		$option .= "<input type='radio' name='vast_version' value='5'".(!isset($maxInvocation->vast_version) || $maxInvocation->vast_version == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Wrapper 2.0 &nbsp;<br/>"; //Wrapper 2.0
		 
		$option .= "<input type='radio' name='vast_version' value='6'".(!isset($maxInvocation->vast_version) || $maxInvocation->vast_version == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Wrapper 3.0 &nbsp;<br/>"; //Wrapper 3.0
		 
		$option .= "<input type='radio' name='vast_version' value='7'".(!isset($maxInvocation->vast_version) || $maxInvocation->vast_version == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Vast Adpod Wrapper &nbsp;<br/>"; //Vast Ad pod Wrapper
		
		
		//~ $option .= "<input type='radio' name='vast_version'  value='9'".(!isset($maxInvocation->vast_version) || $maxInvocation->vast_version == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;VMAP &nbsp;<br/>"; //VMAP
		

 		$option .= "&nbsp;<br/><br/></tr>";
 		
 		
		//Ad Schedule For Inline Parameter
 		$option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Ad Schedule<span style='color:red';>*</span></td> ";
		$option .= "<td width='500'>Starting Time : <input type='text' name='adstime' id='adstime' ".(isset($maxInvocation->adstime) ? $maxInvocation->adstime : '')." tabindex='".($maxInvocation->tabindex++)."'>Seconds<br/>";
		$option .= "<br/></tr>";


		$option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Ad duration <span style='color:red';>*</span> </td> ";
		$option .= "<td width='500'>Ending Time : <input type='text' name='adduration' id='adduration' ".(isset($maxInvocation->adduration) ? $maxInvocation->adduration : '')." tabindex='".($maxInvocation->tabindex++)."' >Seconds<br/></td></tr>";



 		//JWplayer configuration start Manivasaki
 		
 		
 		//Sharing player configuration
 		$option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Sharing </td> ";
		$option .= "<td width='500'> <input type='radio' name='sharing' value='1'".(isset($maxInvocation->sharing) && $maxInvocation->sharing == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
            $option .= "<input type='radio' name='sharing' value='2'".(!isset($maxInvocation->sharing) || $maxInvocation->sharing == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
 		$option .= "</tr>";
 		
 		//Mute or Unmute
 		$option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Mute</td> ";
		$option .= "<td width='500'> <input type='radio' name='mute' value='1'".(isset($maxInvocation->mute) && $maxInvocation->mute == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
        $option .= "<input type='radio' name='mute' value='2'".(!isset($maxInvocation->mute) || $maxInvocation->mute == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
 		$option .= "</tr>";
 		
 		//Repeat
 		$option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Repeat</td> ";
		$option .= "<td width='500'> <input type='radio' name='repeat' value='1'".(isset($maxInvocation->repeat) && $maxInvocation->repeat == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
        $option .= "<input type='radio' name='repeat' value='2'".(!isset($maxInvocation->repeat) || $maxInvocation->repeat == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
 		$option .= "</tr>";
 		
 		//Player Title
 		$option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Player Title</td> ";
		$option .= "<td width='500'> <input type='radio' name='playertitle'  id='playertitle' value='1'".(isset($maxInvocation->playertitle) && $maxInvocation->playertitle == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']." &nbsp; &nbsp;";
		$option .= "<input type='radio' name='playertitle' id='playertitle' value='2'".(!isset($maxInvocation->playertitle) || $maxInvocation->playertitle == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."<br/><br/></td>";
 		$option .= "</tr>";
 		
 		//Title
 		$option .= "<tr><td width='50'>&nbsp;&nbsp;&nbsp;</td> <td width='200' id='titlelabel'>Title&nbsp;&nbsp;</td>";
 		$option .= "<td width='450'>
	      <input type='text' name='title' id='title' ".(isset($maxInvocation->title) ? $maxInvocation->title : '')." tabindex='".($maxInvocation->tabindex++)."'><br/><br/></td>";
 		$option .= "</tr>";
 		
 		//description
 		$option .= "<tr><td width='50'>&nbsp;&nbsp;&nbsp;</td> <td width='200' id='descriptionlabel'>Description &nbsp;&nbsp;</td>";
 		$option .= "<td width='450'>
	      <input type='text' name='description' id='description' ".(isset($maxInvocation->description) ? $maxInvocation->description : '')." tabindex='".($maxInvocation->tabindex++)."'><br/><br/></td>";
 		$option .= "</tr>";
 		
 		//Stretching 
 		$stretching = (!empty($maxInvocation->stretching)) ? $maxInvocation->stretching : $this->defaultValues['stretching'];
 		$option .= "<tr><td width='50'>&nbsp;&nbsp;&nbsp;</td> 
 		<td width='200' id='stretchinglabel'>Stretching &nbsp;&nbsp;</td>";
 		$option .= "<td width='370'>
 		<select name='stretching' tabindex='".($maxInvocation->tabindex++)."'>
               
                <option value='uniform'" . ($stretching == 'uniform' ? " selected='selected'" : '') . ">Uniform</option>
                <option value='none'" . ($stretching == 'none' ? " selected='selected'" : '') . ">None</option>
                <option value='exactfit'" . ($stretching == 'exactfit' ? " selected='selected'" : '') . ">Exactfit</option>
                 <option value='fill'" . ($stretching == 'fill' ? " selected='selected'" : '') . ">Fill</option>
            </select> </td>";
 		 $option .= "</tr>";
 		//JWplayer configuration End Manivasaki
 
 		
 		//Script 
 		$option .= "<script src='https://ajax.googleapis.com/ajax/libs/jquery/3.1.1/jquery.min.js'></script>";
 		$option .= "
 		<script>
			var jq = jQuery.noConflict(true);
		</script>
 		<script type='text/javascript'>
 		jq(document).ready(function(){
 		
 		jq('#title').hide();
 		jq('#titlelabel').hide();
 		jq('#description').hide();
		jq('#descriptionlabel').hide();
		jq('#Companionwidthlabel').hide();
		jq('#descriptionlabel').hide();
		jq('#cwidt').hide();
 	    jq('input[id=vast_version2]').prop('checked', true);	
 		
		jq('input[name=playertitle]').on('click',function(){	
			var playertitle=jQuery(this).attr('value');
			if(playertitle=='1')
			{
				jq('#title').show();
				jq('#titlelabel').show();
				jq('#description').show();
				jq('#descriptionlabel').show();
				
			}
			else 
			{	
				jq('#title').hide();
				jq('#titlelabel').hide();
				jq('#description').hide();
				jq('#descriptionlabel').hide();
			}
		
			
 		});
 		
 		jq('input[name=compad]').on('click',function(){	
			var compad=jQuery(this).attr('value');
			if(compad=='1')
			{
				jq('#Companionwidthlabel').show();
				jq('#cwidt').show();
				
			}
			else 
			{	
				jq('#Companionwidthlabel').hide();
				jq('#cwidt').hide();
				
			}
		
			
 		});
 		
 		
 		
 		
 		
 	
			});
 		</script>";


		return $option;


}
   
    //~ else
    //~ {
        //~ $option = '';
        //~ $option .= "<tr><td width='30'>&nbsp;</td>";
        //~ $option .= "<td width='200'>".$GLOBALS['strInvocationDontShowAgain']."</td>";
        //~ $option .= "<td width='370'><input type='radio' name='block' value='1'".(isset($maxInvocation->block) && $maxInvocation->block != 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']."<br />";
        //~ $option .= "<input type='radio' name='block' value='0'".(!isset($maxInvocation->block) || $maxInvocation->block == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
        //~ $option .= "</tr>";
        //~ $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
//~ 
        //~ return $option;
    //~ 
    //~ }
    
    
    /*
    else if(in_array($maxInvocation->codetype,$inline))
    {   
        $option .= "<tr><td width='50'>&nbsp;</td><td width='200'>Ad Schedule</td> ";
        $option .= "<td width='500'> <input type='radio' name='adposition' value='1'".(isset($maxInvocation->adposition) && $maxInvocation->adposition == 1 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Pre-roll &nbsp; &nbsp;<br/>";
        $option .= "<input type='radio' name='adposition' value='2'".(!isset($maxInvocation->adposition) || $maxInvocation->adposition == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Mid-roll &nbsp; <br/>";
        $option .= "<input type='radio' name='adposition' value='3'".(!isset($maxInvocation->adposition) || $maxInvocation->adposition == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;Post-roll &nbsp;<br/><br/></td>";
        $option .= "</tr>";

        
        if($maxInvocation->codetype=='invocationTags:oxInvocationTags:vastad3' || $maxInvocation->codetype=='invocationTags:oxInvocationTags:vastad4')
        { 
             $option .= "<tr><td width='30'>&nbsp;</td>";
            $option .= "<td width='200'>Duration</td><td width='370'>";
            $option .= "<input class='flat' type='text' name='duration' size='' value='".(isset($maxInvocation->duration) ? htmlspecialchars(stripslashes($maxInvocation->duration),ENT_QUOTES) : 15)."' style='width:175px;' tabindex='".($maxInvocation->tabindex++)."'></td></tr>";
            $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
        }
        
         return $option;

    }
    else if(in_array($maxInvocation->codetype,$overlay))
    {

    }
    
    else if(in_array($maxInvocation->codetype,$vmap))
    {   
        
    }
    else
    {
        $option = '';
        $option .= "<tr><td width='30'>&nbsp;</td>";
        $option .= "<td width='200'>".$GLOBALS['strInvocationDontShowAgain']."</td>";
        $option .= "<td width='370'><input type='radio' name='block' value='1'".(isset($maxInvocation->block) && $maxInvocation->block != 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']."<br />";
        $option .= "<input type='radio' name='block' value='0'".(!isset($maxInvocation->block) || $maxInvocation->block == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
        $option .= "</tr>";
        $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
        return $option;
    
    }   
    */

    
    
    }

    /**
     * Generate the HTML option
     *
     * @return string    A string containing html for option
     */
    function blockcampaign()
    {
        $maxInvocation = &$this->maxInvocation;
        $allowed_tag=array('invocationTags:oxInvocationTags:vast1','invocationTags:oxInvocationTags:vast2',
'invocationTags:oxInvocationTags:vast3','invocationTags:oxInvocationTags:ovast1',
'invocationTags:oxInvocationTags:ovast3','invocationTags:oxInvocationTags:vastwrapper2',
'invocationTags:oxInvocationTags:vastwrapper3','invocationTags:oxInvocationTags:vastwrapper1','invocationTags:oxInvocationTags:vastoverlaywrapper1'
,'invocationTags:oxInvocationTags:vastoverlaywrapper2','invocationTags:oxInvocationTags:vastoverlaywrapper3','invocationTags:oxInvocationTags:vmapinline','invocationTags:oxInvocationTags:ovmap','invocationTags:oxInvocationTags:vast2without','invocationTags:oxInvocationTags:ovast2without','invocationTags:oxInvocationTags:vast2internal','invocationTags:oxInvocationTags:ovast2internal');

	if(in_array($maxInvocation->codetype,$allowed_tag))
	{
	}
	else
	{

        $option = '';
        $option .= "<tr><td width='30'>&nbsp;</td>";
        $option .= "<td width='200'>".$GLOBALS['strInvocationDontShowAgainCampaign']."</td>";
        $option .= "<td width='370'><input type='radio' name='blockcampaign' value='1'".(isset($maxInvocation->blockcampaign) && $maxInvocation->blockcampaign != 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']."<br />";
        $option .= "<input type='radio' name='blockcampaign' value='0'".(!isset($maxInvocation->blockcampaign) || $maxInvocation->blockcampaign == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
        $option .= "</tr>";
        $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
        return $option;
    }
}

    /**
     * Generate the HTML option
     *
     * @return string    A string containing html for option
     */
    function raw()
    {
        $maxInvocation = &$this->maxInvocation;

        $option = '';
        $option .= "<tr><td width='30'>&nbsp;</td>";
        $option .= "<td width='200'>".$GLOBALS['strInvocationTemplate']."</td>";
        $option .= "<td width='370'><input type='radio' name='raw' value='1'".(isset($maxInvocation->raw) && $maxInvocation->raw != 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']."<br />";
        $option .= "<input type='radio' name='raw' value='0'".(!isset($maxInvocation->raw) || $maxInvocation->raw == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
        $option .= "</tr>";
        $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
        return $option;
    }

    /**
     * Generate the HTML option
     *
     * @return string    A string containing html for option
     */
    function popunder()
    {
        $maxInvocation = &$this->maxInvocation;

        $option = '';
        $option .= "<tr><td width='30'>&nbsp;</td>";
        $option .= "<td width='200'>".$GLOBALS['strPopUpStyle']."</td>";
        $option .= "<td width='370'><input type='radio' name='popunder' value='0'".
             (!isset($maxInvocation->popunder) || $maxInvocation->popunder != '1' ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".
             "<img src='" . OX::assetPath(). "/images/icon-popup-over.gif' align='absmiddle'>&nbsp;".$GLOBALS['strPopUpStylePopUp']."<br />";
        $option .= "<input type='radio' name='popunder' value='1'".
             (isset($maxInvocation->popunder) && $maxInvocation->popunder == '1' ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".
             "<img src='" . OX::assetPath(). "/images/icon-popup-under.gif' align='absmiddle'>&nbsp;".$GLOBALS['strPopUpStylePopUnder']."</td>";
        $option .= "</tr>";
        $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
        return $option;
    }

    /**
     * Generate the HTML option
     *
     * @return string    A string containing html for option
     */
    function delay()
    {
        global $tabindex;
        $maxInvocation = &$this->maxInvocation;

        $option = '';
        $option .= "<tr><td width='30'>&nbsp;</td>";
        $option .= "<td width='200'>".$GLOBALS['strPopUpCreateInstance']."</td>";
        $option .= "<td width='370'><input type='radio' name='delay_type' value='none'".
             (!isset($maxInvocation->delay_type) || ($maxInvocation->delay_type != 'exit' && $maxInvocation->delay_type != 'seconds') ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strPopUpImmediately']."<br />";
        $option .= "<input type='radio' name='delay_type' value='exit'".
             (isset($maxInvocation->delay_type) && $maxInvocation->delay_type == 'exit' ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strPopUpOnClose']."<br />";
        $option .= "<input type='radio' name='delay_type' value='seconds'".
             (isset($maxInvocation->delay_type) && $maxInvocation->delay_type == 'seconds' ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strPopUpAfterSec']."&nbsp;".
             "<input class='flat' type='text' name='delay' size='' value='".(isset($maxInvocation->delay) ? $maxInvocation->delay : $this->defaultValues['delay'])."' style='width:50px;' tabindex='".($tabindex++)."'> ".$GLOBALS['strAbbrSeconds']."</td>";
        $option .= "</tr>";
        $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
        return $option;
    }

    /**
     * Generate the HTML option
     *
     * @return string    A string containing html for option
     */
    function absolute()
    {
        $maxInvocation = &$this->maxInvocation;

        $option = '';
        $option .= "<tr><td width='30'>&nbsp;</td>";
        $option .= "<td width='200'>".$GLOBALS['strPopUpTop']."</td><td width='370'>";
        $option .= "<input class='flat' type='text' name='top' size='' value='".(isset($maxInvocation->top) ? $maxInvocation->top : $this->defaultValues['absolute']['top'])."' style='width:50px;' tabindex='".($maxInvocation->tabindex++)."'> ".$GLOBALS['strAbbrPixels']."</td></tr>";
        $option .= "<tr><td width='30'>&nbsp;</td>";
        $option .= "<td width='200'>".$GLOBALS['strPopUpLeft']."</td><td width='370'>";
        $option .= "<input class='flat' type='text' name='left' size='' value='".(isset($maxInvocation->left) ? $maxInvocation->left : $this->defaultValues['absolute']['left'])."' style='width:50px;' tabindex='".($maxInvocation->tabindex++)."'> ".$GLOBALS['strAbbrPixels']."</td></tr>";
        $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
        return $option;
    }

    /**
     * Generate the HTML option
     *
     * @return string    A string containing html for option
     */
    function timeout()
    {
        $maxInvocation = &$this->maxInvocation;

        $option = '';
        $option .= "<tr><td width='30'>&nbsp;</td>";
        $option .= "<td width='200'>".$GLOBALS['strAutoCloseAfter']."</td><td width='370'>";
        $option .= "<input class='flat' type='text' name='timeout' size='' value='".(isset($maxInvocation->timeout) ? $maxInvocation->timeout : $this->defaultValues['timeout'])."' style='width:50px;' tabindex='".($maxInvocation->tabindex++)."'> ".$GLOBALS['strAbbrSeconds']."</td></tr>";
        $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
        return $option;
    }

    /**
     * Generate the HTML option
     *
     * @return string    A string containing html for option
     */
    function windowoptions()
    {
        $maxInvocation = &$this->maxInvocation;

        $option = '';
        $option .= "<tr><td width='30'>&nbsp;</td><td width='200' valign='top'>".$GLOBALS['strWindowOptions']."</td><td width='370'>";
        $option .= "<table cellpadding='0' cellspacing='0' border='0'>";
        $option .= "<tr><td>".$GLOBALS['strShowToolbars']."</td><td>&nbsp;&nbsp;&nbsp;</td><td>";
        $option .= "<input type='radio' name='toolbars' value='1'".(isset($maxInvocation->toolbars) && $maxInvocation->toolbars != 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']."<br />";
        $option .= "</td><td>&nbsp;&nbsp;&nbsp;</td><td>";
        $option .= "<input type='radio' name='toolbars' value='0'".(!isset($maxInvocation->toolbars) || $maxInvocation->toolbars == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."";
        $option .= "</td></tr><tr><td colspan='5'><img src='" . OX::assetPath(). "/images/spacer.gif' height='3' width='200' vspace='2'></td></tr>";
        $option .= "<tr><td>".$GLOBALS['strShowLocation']."</td><td>&nbsp;&nbsp;&nbsp;</td><td>";
        $option .= "<input type='radio' name='location' value='1'".(isset($maxInvocation->location) && $maxInvocation->location != 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']."<br />";
        $option .= "</td><td>&nbsp;&nbsp;&nbsp;</td><td>";
        $option .= "<input type='radio' name='location' value='0'".(!isset($maxInvocation->location) || $maxInvocation->location == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."";
        $option .= "</td></tr><tr><td colspan='5'><img src='" . OX::assetPath(). "/images/spacer.gif' height='3' width='200' vspace='2'></td></tr>";
        $option .= "<tr><td>".$GLOBALS['strShowMenubar']."</td><td>&nbsp;&nbsp;&nbsp;</td><td>";
        $option .= "<input type='radio' name='menubar' value='1'".(isset($maxInvocation->menubar) && $maxInvocation->menubar != 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']."<br />";
        $option .= "</td><td>&nbsp;&nbsp;&nbsp;</td><td>";
        $option .= "<input type='radio' name='menubar' value='0'".(!isset($maxInvocation->menubar) || $maxInvocation->menubar == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."";
        $option .= "</td></tr><tr><td colspan='5'><img src='" . OX::assetPath(). "/images/spacer.gif' height='3' width='200' vspace='2'></td></tr>";
        $option .= "<tr><td>".$GLOBALS['strShowStatus']."</td><td>&nbsp;&nbsp;&nbsp;</td><td>";
        $option .= "<input type='radio' name='status' value='1'".(isset($maxInvocation->status) && $maxInvocation->status != 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']."<br />";
        $option .= "</td><td>&nbsp;&nbsp;&nbsp;</td><td>";
        $option .= "<input type='radio' name='status' value='0'".(!isset($maxInvocation->status) || $maxInvocation->status == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."";
        $option .= "</td></tr><tr><td colspan='5'><img src='" . OX::assetPath(). "/images/spacer.gif' height='3' width='200' vspace='2'></td></tr>";
        $option .= "<tr><td>".$GLOBALS['strWindowResizable']."</td><td>&nbsp;&nbsp;&nbsp;</td><td>";
        $option .= "<input type='radio' name='resizable' value='1'".(isset($maxInvocation->resizable) && $maxInvocation->resizable != 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']."<br />";
        $option .= "</td><td>&nbsp;&nbsp;&nbsp;</td><td>";
        $option .= "<input type='radio' name='resizable' value='0'".(!isset($maxInvocation->resizable) || $maxInvocation->resizable == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."";
        $option .= "</td></tr><tr><td colspan='5'><img src='" . OX::assetPath(). "/images/spacer.gif' height='3' width='200' vspace='2'></td></tr>";
        $option .= "<tr><td>".$GLOBALS['strShowScrollbars']."</td><td>&nbsp;&nbsp;&nbsp;</td><td>";
        $option .= "<input type='radio' name='scrollbars' value='1'".(isset($maxInvocation->scrollbars) && $maxInvocation->scrollbars != 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']."<br />";
        $option .= "</td><td>&nbsp;&nbsp;&nbsp;</td><td>";
        $option .= "<input type='radio' name='scrollbars' value='0'".(!isset($maxInvocation->scrollbars) || $maxInvocation->scrollbars == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."";
        $option .= "</td></tr>";
        $option .= "</table>";
        $option .= "</td></tr><tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
        return $option;
    }

    /**
     * Generate the HTML option
     *
     * @return string    A string containing html for option
     */
    function xmlrpcproto()
    {
        $maxInvocation = &$this->maxInvocation;

        $option = '';
        $option .= "<tr><td width='30'>&nbsp;</td>";
        $option .= "<td width='200'>".$GLOBALS['strXmlRpcProtocol']."</td>";
        $option .= "<td width='370'><input type='radio' name='xmlrpcproto' value='1'".(isset($maxInvocation->xmlrpcproto) && $maxInvocation->xmlrpcproto != 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']."<br />";
        $option .= "<input type='radio' name='xmlrpcproto' value='0'".(!isset($maxInvocation->xmlrpcproto) || $maxInvocation->xmlrpcproto == 0 ? ' checked' : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
        $option .= "</tr>";
        $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
        return $option;
    }

    /**
     * Generate the HTML option
     *
     * @return string    A string containing html for option
     */
    function xmlrpctimeout()
    {
        $maxInvocation = &$this->maxInvocation;

        $option = '';
        $option .= "<tr><td width='30'>&nbsp;</td>";
        $option .= "<td width='200'>".$GLOBALS['strXmlRpcTimeout']."</td><td width='370'>";
        $option .= "<input class='flat' type='text' name='xmlrpctimeout' size='' value='".(isset($maxInvocation->xmlrpctimeout) ? $maxInvocation->xmlrpctimeout : $this->defaultValues['xmlrpctimeout'])."' style='width:175px;' tabindex='".($maxInvocation->tabindex++)."'></td></tr>";
        $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
        return $option;
    }

    /**
     * Generate the HTML option
     *
     * @return string    A string containing html for option
     */
    function hostlanguage()
    {
        global $tabindex;
        $maxInvocation = &$this->maxInvocation;

        $option = '';
        $option .= "<tr><td width='30'>&nbsp;</td>";
        $option .= "<td width='200'>".$GLOBALS['strXmlRpcLanguage']."</td><td width='370'>";
        $option .= "<select name='hostlanguage' tabindex='".($tabindex++)."'>";
        $option .= "<option value='php'".($maxInvocation->hostlanguage == 'php' ? ' selected' : $this->defaultValues['hostlanguage']).">PHP</option>";
        $option .= "</select>";
        $option .= "</td></tr>";
        return $option;
    }

    /**
     * Generate the HTML option for output adserver selection
     *
     * @return string    A string containing html for option
     */
    function thirdPartyServer()
    {
	$conf = $GLOBALS['_MAX']['CONF'];
        $pref = $GLOBALS['_MAX']['PREF'];
        $selectedOutputAdServer = (is_null($this->maxInvocation->thirdpartytrack)) ? $conf['delivery']['clicktracking'] : $this->maxInvocation->thirdpartytrack;
        $maxInvocation =& $this->maxInvocation;
		$allowed_tag=array('invocationTags:oxInvocationTags:jwplayeroverlay','invocationTags:oxInvocationTags:jwplayerinline','invocationTags:oxInvocationTags:vast1','invocationTags:oxInvocationTags:vast2','invocationTags:oxInvocationTags:vast2_internal',
'invocationTags:oxInvocationTags:vast3','invocationTags:oxInvocationTags:ovast1','invocationTags:oxInvocationTags:ovast2',
'invocationTags:oxInvocationTags:ovast3','invocationTags:oxInvocationTags:vastoverlayvpaid2',
'invocationTags:oxInvocationTags:vastoverlayvpaid3','invocationTags:oxInvocationTags:vastoverlayvpaid2',
'invocationTags:oxInvocationTags:vastoverlayvpaid3','invocationTags:oxInvocationTags:vastvpaid2',
'invocationTags:oxInvocationTags:vastvpaid3','invocationTags:oxInvocationTags:vastwrapper1','invocationTags:oxInvocationTags:vastoverlaywrapper1'
,'invocationTags:oxInvocationTags:vastoverlaywrapper2','invocationTags:oxInvocationTags:jwplayer','invocationTags:oxInvocationTags:vastoverlaywrapper3','invocationTags:oxInvocationTags:vastad3','invocationTags:oxInvocationTags:vastad4','invocationTags:oxInvocationTags:vast2internal','invocationTags:oxInvocationTags:ovast2internal');//DAC015
	if(in_array($maxInvocation->codetype,$allowed_tag))
	{
	}
	else
	{



        $option = '';
        $option .= "
        <tr>
            <td width='30'>&nbsp;</td>
            <td width='200'>{$GLOBALS['str3rdPartyTrack']}</td>
            <td width='370'>
        ";

        // Add selection box for output adservers
        $option .= "<select name='thirdpartytrack' tabindex='" . ($maxInvocation->tabindex++) . "'>";
        $option .= "<option value='0'>{$GLOBALS['strNo']}</option>";
        $option .= "<option value='generic' ".($maxInvocation->thirdpartytrack == 'generic' ? " selected='selected'" : '').">{$GLOBALS['strGenericOutputAdServer']}</option>";

        $outputAdServers = &OX_Component::getComponents('3rdPartyServers');
        $availableOutputAdServerNames = array();
        foreach ($outputAdServers as $pluginKey => $outputAdServer) {
            if (!empty($outputAdServer->hasOutputMacros)) {
                $availableOutputAdServers[$pluginKey] = $outputAdServer;
                $availableOutputAdServerNames[$pluginKey] = $outputAdServer->getName();
            }
        }
        asort($availableOutputAdServerNames);
        foreach ($availableOutputAdServerNames as $pluginKey => $outputAdServerName) {
            $option .= "<option value='{$pluginKey}'".($maxInvocation->thirdpartytrack == $pluginKey ? ' selected="selected"' : '').">" . $outputAdServerName . "</option>";
        }
        $option .= "</select>";
        $option .= "</tr>";
        $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
        return $option;
	}
    }

    

    function cacheBuster()
    {
        $maxInvocation =& $this->maxInvocation;
        $cachebuster = (is_null($this->maxInvocation->cachebuster)) ? $this->defaultValues['cacheBuster'] : $this->maxInvocation->cachebuster;

        $option = '';
        $option .= "
        <tr>
            <td width='30'>&nbsp;</td>
            <td width='200'>{$GLOBALS['strCacheBuster']}</td>
            <td width='370'><input type='radio' name='cachebuster' value='1'".($cachebuster == 1 ? " checked='checked'" : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;{$GLOBALS['strYes']}<br />
            <input type='radio' name='cachebuster' value='0'".($cachebuster == 0 ? " checked='checked'" : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;{$GLOBALS['strNo']}</td>
        </tr>
        <tr>
            <td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>
        ";
        return $option;
    }

    /**
     * Generate the HTML option for comments inclusion
     *
     * @return string    A string containing html for option
     */
    function comments()
    {
        $maxInvocation = &$this->maxInvocation;
	
	$allowed_tag=array('invocationTags:oxInvocationTags:jwplayeroverlay','invocationTags:oxInvocationTags:vast1','invocationTags:oxInvocationTags:vast2',
'invocationTags:oxInvocationTags:vast3','invocationTags:oxInvocationTags:ovast1','invocationTags:oxInvocationTags:ovast2','invocationTags:oxInvocationTags:ovast3','invocationTags:oxInvocationTags:vastvpaid2',
'invocationTags:oxInvocationTags:vastvpaid3','invocationTags:oxInvocationTags:vastwrapper2',
'invocationTags:oxInvocationTags:vastwrapper3','invocationTags:oxInvocationTags:jwplayerinline','invocationTags:oxInvocationTags:vastoverlaywrapper1'
,'invocationTags:oxInvocationTags:vastoverlayvpaid2','invocationTags:oxInvocationTags:jwplayer','invocationTags:oxInvocationTags:vastoverlayvpaid3','invocationTags:oxInvocationTags:vastad3','invocationTags:oxInvocationTags:vastad4','invocationTags:oxInvocationTags:vast2internal','invocationTags:oxInvocationTags:ovast2internal');//DAC015
	if(in_array($maxInvocation->codetype,$allowed_tag))
	{
	}
	else
	{
        $comments = (isset($maxInvocation->comments)) ? $maxInvocation->comments : $this->defaultValues['comments'];

        $option = '';
        $option .= "<tr><td width='30'>&nbsp;</td>";
        $option .= "<td width='200'>".$GLOBALS['strInvocationComments']."</td>";
        $option .= "<td width='370'><input type='radio' name='comments' value='1'".($comments == 1 ? " checked='checked'" : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strYes']."<br />";
        $option .= "<input type='radio' name='comments' value='0'".($comments == 0 ? " checked='checked'" : '')." tabindex='".($maxInvocation->tabindex++)."'>&nbsp;".$GLOBALS['strNo']."</td>";
        $option .= "</tr>";
        $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
        return $option;	
	}
    }

    /**
     * Generate the HTML option for charset inclusion
     *
     * @return string    A string containing html for option
     */
   

	function charset()
    {
        $conf = $GLOBALS['_MAX']['CONF'];
        $pref = $GLOBALS['_MAX']['PREF'];

        $maxInvocation =& $this->maxInvocation;

	
	$allowed_tag=array('invocationTags:oxInvocationTags:vast1','invocationTags:oxInvocationTags:vast2',
'invocationTags:oxInvocationTags:vast3','invocationTags:oxInvocationTags:ovast1','invocationTags:oxInvocationTags:ovast2',
'invocationTags:oxInvocationTags:ovast3','invocationTags:oxInvocationTags:vastwrapper2',
'invocationTags:oxInvocationTags:vastwrapper3','invocationTags:oxInvocationTags:jwplayerinline','invocationTags:oxInvocationTags:jwplayeroverlay'
,'invocationTags:oxInvocationTags:vastoverlayvpaid2','invocationTags:oxInvocationTags:vastoverlayvpaid3','invocationTags:oxInvocationTags:vast2internal','invocationTags:oxInvocationTags:ovast2internal');//DAC015
	if(in_array($maxInvocation->codetype,$allowed_tag))
	{
	}
	else
	{
   

        $option = "
        <tr>
            <td width='30'>&nbsp;</td>
            <td width='200'>{$GLOBALS['strCharset']}</td>
            <td width='370'>
        ";

        // Add selection box for output adservers
        $option .= "<select name='charset' tabindex='" . ($maxInvocation->tabindex++) . "'>";
        $option .= "<option value='' ". ((empty($maxInvocation->charset) && empty($maxInvocation->canDetectCharset)) ? ' selected="selected"' : '') .">{$GLOBALS['strNone']}</option>";

        if ($maxInvocation->canDetectCharset) {
            $option .= "<option value=''".(empty($maxInvocation->charset) ? ' selected="selected"' : '').">{$GLOBALS['strAutoDetect']}</option>";
        }

        $availableCharsets = $this->_getAvailableCharsets();

        asort($availableCharsets);
        foreach ($availableCharsets as $charsetCode => $charsetName) {
            $option .= "<option value='{$charsetCode}'".($maxInvocation->charset == $charsetCode ? ' selected="selected"' : '').">" . $charsetName . "</option>\n";
        }
        $option .= "</select>";
        $option .= "</tr>";
        $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
        return $option;
	}
    }

    function _getAvailableCharsets()
    {
        if (function_exists('iconv') || function_exists('mb_convert_encoding')) {
            return array(
                'ISO-8859-6'    => 'Arabic (ISO-8859-6)',
                'Windows-1256'  => 'Arabic (Windows-1256)',
                'ISO-8859-4'    => 'Baltic (ISO-8859-4)',
                'Windows-1257'  => 'Baltic (Windows-1257)',
                'ISO-8859-2'    => 'Central European (ISO-8859-2)',
                'Windows-1250'  => 'Central European (Windows-1250)',
                'GB18030'       => 'Chinese Simplified (GB18030)',
                'GB2312'        => 'Chinese Simplified (GB2312)',
                'HZ'            => 'Chinese Simplified (HZ)',
                'Big5'          => 'Chinese Traditional (Big5)',
                'KOI8-R'        => 'Cyrillic (KOI8-R)',
                'ISO-8859-5'    => 'Cyrillic (ISO-8859-5)',
                'Windows-1251'  => 'Cyrillic (Windows-1251)',
                'ISO-8859-13'   => 'Estonian (ISO-8859-13)',
                'ISO-8859-7'    => 'Greek (ISO-8859-7)',
                'Windows-1253'  => 'Greek (Windows-1253)',
                'ISO-8859-8-l'  => 'Hebrew (ISO Logical: ISO-8859-8-l)',
                'ISO-8859-8'    => 'Hebrew (ISO:Visual: ISO-8859-8)',
                'Windows-1255'  => 'Hebrew (Windows-1255)',
                'EUC-JP'        => 'Japanese (EUC-JP)',
                'Shift-JIS'     => 'Japanese (Shift-JIS)',
                'EUC-KR'        => 'Korean (EUC-KR)',
                'ISO-8859-15'   => 'Latin 9 (ISO-8859-15)',
                'TIS-620'       => 'Thai (TIS-620)',
                'ISO-8859-9'    => 'Turkish (ISO-8859-9)',
                'Windows-1254'  => 'Turkish (Windows-1254)',
                'UTF-8'         => 'Unicode (UTF-8)',
                'Windows-1258'  => 'Vietnamese (Windows-1258)',
                'ISO-8859-1'    => 'Western European (ISO-8859-1)',
                'Windows-1252'  => 'Western European (Windows-1252)'
            );
        } else if (function_exists('utf8_encode')) { // No? try utf8_encode/decode
            return array(
                'UTF-8'         => 'Unicode (UTF-8)',
                'ISO-8859-1'    => 'Western European (ISO-8859-1)',
            );
        }
    }
}

?>
