#
# TABLE STRUCTURE FOR: ads
#

DROP TABLE IF EXISTS `ads`;

CREATE TABLE `ads` (
  `ads_id` int(11) NOT NULL AUTO_INCREMENT,
  `ads_name` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `unique_name` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ads_size` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ads_type` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ads_url` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `ads_image_url` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ads_code` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `enable` int(1) DEFAULT 0,
  PRIMARY KEY (`ads_id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `ads` (`ads_id`, `ads_name`, `unique_name`, `ads_size`, `ads_type`, `ads_url`, `ads_image_url`, `ads_code`, `enable`) VALUES (1, 'Home Page Header', 'home_header', '728x90', 'code', '#', '', '', 0);
INSERT INTO `ads` (`ads_id`, `ads_name`, `unique_name`, `ads_size`, `ads_type`, `ads_url`, `ads_image_url`, `ads_code`, `enable`) VALUES (2, 'Movie Page Header', 'movie_header', '728x90', 'code', '#', '', '', 0);
INSERT INTO `ads` (`ads_id`, `ads_name`, `unique_name`, `ads_size`, `ads_type`, `ads_url`, `ads_image_url`, `ads_code`, `enable`) VALUES (3, 'Genre Page Header', 'genre_header', '728x90', 'code', '#', '', '', 0);
INSERT INTO `ads` (`ads_id`, `ads_name`, `unique_name`, `ads_size`, `ads_type`, `ads_url`, `ads_image_url`, `ads_code`, `enable`) VALUES (4, 'Country Page Header', 'country_header', '728x90', 'code', '#', '', '', 0);
INSERT INTO `ads` (`ads_id`, `ads_name`, `unique_name`, `ads_size`, `ads_type`, `ads_url`, `ads_image_url`, `ads_code`, `enable`) VALUES (5, 'Release Page Header', 'release_header', '728x90', 'code', '#', '', '', 0);
INSERT INTO `ads` (`ads_id`, `ads_name`, `unique_name`, `ads_size`, `ads_type`, `ads_url`, `ads_image_url`, `ads_code`, `enable`) VALUES (6, 'TV-series Page Header', 'tv_header', '728x90', 'code', '#', '', '', 0);
INSERT INTO `ads` (`ads_id`, `ads_name`, `unique_name`, `ads_size`, `ads_type`, `ads_url`, `ads_image_url`, `ads_code`, `enable`) VALUES (7, 'Type Page Header', 'type_header', '728x90', 'code', '#', '', '', 0);
INSERT INTO `ads` (`ads_id`, `ads_name`, `unique_name`, `ads_size`, `ads_type`, `ads_url`, `ads_image_url`, `ads_code`, `enable`) VALUES (8, 'Blog Page Header', 'blog_header', '728x90', 'code', '#', '', '', 0);
INSERT INTO `ads` (`ads_id`, `ads_name`, `unique_name`, `ads_size`, `ads_type`, `ads_url`, `ads_image_url`, `ads_code`, `enable`) VALUES (9, 'Sidebar', 'sidebar', '300x600', 'code', '#', '', '', 0);
INSERT INTO `ads` (`ads_id`, `ads_name`, `unique_name`, `ads_size`, `ads_type`, `ads_url`, `ads_image_url`, `ads_code`, `enable`) VALUES (12, 'Player Bottom', 'player_bottom', '728x90', 'code', '#', '', '', 0);
INSERT INTO `ads` (`ads_id`, `ads_name`, `unique_name`, `ads_size`, `ads_type`, `ads_url`, `ads_image_url`, `ads_code`, `enable`) VALUES (10, 'Player Top', 'player_top', '728x90', 'code', '#', '', '', 0);
INSERT INTO `ads` (`ads_id`, `ads_name`, `unique_name`, `ads_size`, `ads_type`, `ads_url`, `ads_image_url`, `ads_code`, `enable`) VALUES (11, 'Billboard(For movie,Landing page & watch page)', 'billboard', '970x250', 'code', '#', '', '', 0);


#
# TABLE STRUCTURE FOR: calendar
#

DROP TABLE IF EXISTS `calendar`;

CREATE TABLE `calendar` (
  `country_code` char(2) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `coordinates` char(15) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `timezone` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comments` varchar(85) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `utc_offset` char(8) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `utc_dst_offset` char(8) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `notes` varchar(79) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`timezone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CI', '+0519-00402', 'Africa/Abidjan', '', '+00:00', '+00:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('GH', '+0533-00013', 'Africa/Accra', '', '+00:00', '+00:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('ET', '+0902+03842', 'Africa/Addis_Ababa', '', '+03:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('DZ', '+3647+00303', 'Africa/Algiers', '', '+01:00', '+01:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('ER', '+1520+03853', 'Africa/Asmara', '', '+03:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Africa/Asmera', '', '+03:00', '+03:00', 'Link to Africa/Asmara');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('ML', '+1239-00800', 'Africa/Bamako', '', '+00:00', '+00:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CF', '+0422+01835', 'Africa/Bangui', '', '+01:00', '+01:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('GM', '+1328-01639', 'Africa/Banjul', '', '+00:00', '+00:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('GW', '+1151-01535', 'Africa/Bissau', '', '+00:00', '+00:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MW', '-1547+03500', 'Africa/Blantyre', '', '+02:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CG', '-0416+01517', 'Africa/Brazzaville', '', '+01:00', '+01:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BI', '-0323+02922', 'Africa/Bujumbura', '', '+02:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('EG', '+3003+03115', 'Africa/Cairo', '', '+02:00', '+02:00', 'DST has been canceled since 2011');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MA', '+3339-00735', 'Africa/Casablanca', '', '+00:00', '+01:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('ES', '+3553-00519', 'Africa/Ceuta', 'Ceuta & Melilla', '+01:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('GN', '+0931-01343', 'Africa/Conakry', '', '+00:00', '+00:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('SN', '+1440-01726', 'Africa/Dakar', '', '+00:00', '+00:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('TZ', '-0648+03917', 'Africa/Dar_es_Salaam', '', '+03:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('DJ', '+1136+04309', 'Africa/Djibouti', '', '+03:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CM', '+0403+00942', 'Africa/Douala', '', '+01:00', '+01:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('EH', '+2709-01312', 'Africa/El_Aaiun', '', '+00:00', '+00:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('SL', '+0830-01315', 'Africa/Freetown', '', '+00:00', '+00:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BW', '-2439+02555', 'Africa/Gaborone', '', '+02:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('ZW', '-1750+03103', 'Africa/Harare', '', '+02:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('ZA', '-2615+02800', 'Africa/Johannesburg', '', '+02:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('SS', '+0451+03136', 'Africa/Juba', '', '+03:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('UG', '+0019+03225', 'Africa/Kampala', '', '+03:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('SD', '+1536+03232', 'Africa/Khartoum', '', '+03:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('RW', '-0157+03004', 'Africa/Kigali', '', '+02:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CD', '-0418+01518', 'Africa/Kinshasa', 'west Dem. Rep. of Congo', '+01:00', '+01:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('NG', '+0627+00324', 'Africa/Lagos', '', '+01:00', '+01:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('GA', '+0023+00927', 'Africa/Libreville', '', '+01:00', '+01:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('TG', '+0608+00113', 'Africa/Lome', '', '+00:00', '+00:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AO', '-0848+01314', 'Africa/Luanda', '', '+01:00', '+01:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CD', '-1140+02728', 'Africa/Lubumbashi', 'east Dem. Rep. of Congo', '+02:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('ZM', '-1525+02817', 'Africa/Lusaka', '', '+02:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('GQ', '+0345+00847', 'Africa/Malabo', '', '+01:00', '+01:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MZ', '-2558+03235', 'Africa/Maputo', '', '+02:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('LS', '-2928+02730', 'Africa/Maseru', '', '+02:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('SZ', '-2618+03106', 'Africa/Mbabane', '', '+02:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('SO', '+0204+04522', 'Africa/Mogadishu', '', '+03:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('LR', '+0618-01047', 'Africa/Monrovia', '', '+00:00', '+00:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('KE', '-0117+03649', 'Africa/Nairobi', '', '+03:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('TD', '+1207+01503', 'Africa/Ndjamena', '', '+01:00', '+01:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('NE', '+1331+00207', 'Africa/Niamey', '', '+01:00', '+01:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MR', '+1806-01557', 'Africa/Nouakchott', '', '+00:00', '+00:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BF', '+1222-00131', 'Africa/Ouagadougou', '', '+00:00', '+00:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BJ', '+0629+00237', 'Africa/Porto-Novo', '', '+01:00', '+01:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('ST', '+0020+00644', 'Africa/Sao_Tome', '', '+00:00', '+00:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Africa/Timbuktu', '', '+00:00', '+00:00', 'Link to Africa/Bamako');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('LY', '+3254+01311', 'Africa/Tripoli', '', '+01:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('TN', '+3648+01011', 'Africa/Tunis', '', '+01:00', '+01:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('NA', '-2234+01706', 'Africa/Windhoek', '', '+01:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'AKST9AKDT', '', 'âˆ’09:00', 'âˆ’08:00', 'Link to America/Anchorage');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+515248-1763929', 'America/Adak', 'Aleutian Islands', 'âˆ’10:00', 'âˆ’09:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+611305-1495401', 'America/Anchorage', 'Alaska Time', 'âˆ’09:00', 'âˆ’08:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AI', '+1812-06304', 'America/Anguilla', '', 'âˆ’04:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AG', '+1703-06148', 'America/Antigua', '', 'âˆ’04:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BR', '-0712-04812', 'America/Araguaina', 'Tocantins', 'âˆ’03:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AR', '-3436-05827', 'America/Argentina/Buenos_Aires', 'Buenos Aires (BA, CF)', 'âˆ’03:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AR', '-2828-06547', 'America/Argentina/Catamarca', 'Catamarca (CT), Chubut (CH)', 'âˆ’03:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'America/Argentina/ComodRivadavia', '', 'âˆ’03:00', 'âˆ’03:00', 'Link to America/Argentina/Catamarca');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AR', '-3124-06411', 'America/Argentina/Cordoba', 'most locations (CB, CC, CN, ER, FM, MN, SE, SF)', 'âˆ’03:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AR', '-2411-06518', 'America/Argentina/Jujuy', 'Jujuy (JY)', 'âˆ’03:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AR', '-2926-06651', 'America/Argentina/La_Rioja', 'La Rioja (LR)', 'âˆ’03:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AR', '-3253-06849', 'America/Argentina/Mendoza', 'Mendoza (MZ)', 'âˆ’03:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AR', '-5138-06913', 'America/Argentina/Rio_Gallegos', 'Santa Cruz (SC)', 'âˆ’03:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AR', '-2447-06525', 'America/Argentina/Salta', '(SA, LP, NQ, RN)', 'âˆ’03:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AR', '-3132-06831', 'America/Argentina/San_Juan', 'San Juan (SJ)', 'âˆ’03:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AR', '-3319-06621', 'America/Argentina/San_Luis', 'San Luis (SL)', 'âˆ’03:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AR', '-2649-06513', 'America/Argentina/Tucuman', 'Tucuman (TM)', 'âˆ’03:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AR', '-5448-06818', 'America/Argentina/Ushuaia', 'Tierra del Fuego (TF)', 'âˆ’03:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AW', '+1230-06958', 'America/Aruba', '', 'âˆ’04:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('PY', '-2516-05740', 'America/Asuncion', '', 'âˆ’04:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+484531-0913718', 'America/Atikokan', 'Eastern Standard Time - Atikokan, Ontario and Southampton I, Nunavut', 'âˆ’05:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'America/Atka', '', 'âˆ’10:00', 'âˆ’09:00', 'Link to America/Adak');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BR', '-1259-03831', 'America/Bahia', 'Bahia', 'âˆ’03:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MX', '+2048-10515', 'America/Bahia_Banderas', 'Mexican Central Time - Bahia de Banderas', 'âˆ’06:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BB', '+1306-05937', 'America/Barbados', '', 'âˆ’04:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BR', '-0127-04829', 'America/Belem', 'Amapa, E Para', 'âˆ’03:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BZ', '+1730-08812', 'America/Belize', '', 'âˆ’06:00', 'âˆ’06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+5125-05707', 'America/Blanc-Sablon', 'Atlantic Standard Time - Quebec - Lower North Shore', 'âˆ’04:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BR', '+0249-06040', 'America/Boa_Vista', 'Roraima', 'âˆ’04:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CO', '+0436-07405', 'America/Bogota', '', 'âˆ’05:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+433649-1161209', 'America/Boise', 'Mountain Time - south Idaho & east Oregon', 'âˆ’07:00', 'âˆ’06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'America/Buenos_Aires', '', 'âˆ’03:00', 'âˆ’03:00', 'Link to America/Argentina/Buenos_Aires');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+690650-1050310', 'America/Cambridge_Bay', 'Mountain Time - west Nunavut', 'âˆ’07:00', 'âˆ’06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BR', '-2027-05437', 'America/Campo_Grande', 'Mato Grosso do Sul', 'âˆ’04:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MX', '+2105-08646', 'America/Cancun', 'Central Time - Quintana Roo', 'âˆ’06:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('VE', '+1030-06656', 'America/Caracas', '', 'âˆ’04:30', 'âˆ’04:30', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'America/Catamarca', '', 'âˆ’03:00', 'âˆ’03:00', 'Link to America/Argentina/Catamarca');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('GF', '+0456-05220', 'America/Cayenne', '', 'âˆ’03:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('KY', '+1918-08123', 'America/Cayman', '', 'âˆ’05:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+415100-0873900', 'America/Chicago', 'Central Time', 'âˆ’06:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MX', '+2838-10605', 'America/Chihuahua', 'Mexican Mountain Time - Chihuahua away from US border', 'âˆ’07:00', 'âˆ’06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'America/Coral_Harbour', '', 'âˆ’05:00', 'âˆ’05:00', 'Link to America/Atikokan');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'America/Cordoba', '', 'âˆ’03:00', 'âˆ’03:00', 'Link to America/Argentina/Cordoba');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CR', '+0956-08405', 'America/Costa_Rica', '', 'âˆ’06:00', 'âˆ’06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+4906-11631', 'America/Creston', 'Mountain Standard Time - Creston, British Columbia', 'âˆ’07:00', 'âˆ’07:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BR', '-1535-05605', 'America/Cuiaba', 'Mato Grosso', 'âˆ’04:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CW', '+1211-06900', 'America/Curacao', '', 'âˆ’04:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('GL', '+7646-01840', 'America/Danmarkshavn', 'east coast, north of Scoresbysund', '+00:00', '+00:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+6404-13925', 'America/Dawson', 'Pacific Time - north Yukon', 'âˆ’08:00', 'âˆ’07:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+5946-12014', 'America/Dawson_Creek', 'Mountain Standard Time - Dawson Creek & Fort Saint John, British Columbia', 'âˆ’07:00', 'âˆ’07:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+394421-1045903', 'America/Denver', 'Mountain Time', 'âˆ’07:00', 'âˆ’06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+421953-0830245', 'America/Detroit', 'Eastern Time - Michigan - most locations', 'âˆ’05:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('DM', '+1518-06124', 'America/Dominica', '', 'âˆ’04:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+5333-11328', 'America/Edmonton', 'Mountain Time - Alberta, east British Columbia & west Saskatchewan', 'âˆ’07:00', 'âˆ’06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BR', '-0640-06952', 'America/Eirunepe', 'W Amazonas', 'âˆ’04:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('SV', '+1342-08912', 'America/El_Salvador', '', 'âˆ’06:00', 'âˆ’06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'America/Ensenada', '', 'âˆ’08:00', 'âˆ’07:00', 'Link to America/Tijuana');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'America/Fort_Wayne', '', 'âˆ’05:00', 'âˆ’04:00', 'Link to America/Indiana/Indianapolis');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BR', '-0343-03830', 'America/Fortaleza', 'NE Brazil (MA, PI, CE, RN, PB)', 'âˆ’03:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+4612-05957', 'America/Glace_Bay', 'Atlantic Time - Nova Scotia - places that did not observe DST 1966-1971', 'âˆ’04:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('GL', '+6411-05144', 'America/Godthab', 'most locations', 'âˆ’03:00', 'âˆ’02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+5320-06025', 'America/Goose_Bay', 'Atlantic Time - Labrador - most locations', 'âˆ’04:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('TC', '+2128-07108', 'America/Grand_Turk', '', 'âˆ’05:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('GD', '+1203-06145', 'America/Grenada', '', 'âˆ’04:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('GP', '+1614-06132', 'America/Guadeloupe', '', 'âˆ’04:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('GT', '+1438-09031', 'America/Guatemala', '', 'âˆ’06:00', 'âˆ’06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('EC', '-0210-07950', 'America/Guayaquil', 'mainland', 'âˆ’05:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('GY', '+0648-05810', 'America/Guyana', '', 'âˆ’04:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+4439-06336', 'America/Halifax', 'Atlantic Time - Nova Scotia (most places), PEI', 'âˆ’04:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CU', '+2308-08222', 'America/Havana', '', 'âˆ’05:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MX', '+2904-11058', 'America/Hermosillo', 'Mountain Standard Time - Sonora', 'âˆ’07:00', 'âˆ’07:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+394606-0860929', 'America/Indiana/Indianapolis', 'Eastern Time - Indiana - most locations', 'âˆ’05:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+411745-0863730', 'America/Indiana/Knox', 'Central Time - Indiana - Starke County', 'âˆ’06:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+382232-0862041', 'America/Indiana/Marengo', 'Eastern Time - Indiana - Crawford County', 'âˆ’05:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+382931-0871643', 'America/Indiana/Petersburg', 'Eastern Time - Indiana - Pike County', 'âˆ’05:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+375711-0864541', 'America/Indiana/Tell_City', 'Central Time - Indiana - Perry County', 'âˆ’06:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+384452-0850402', 'America/Indiana/Vevay', 'Eastern Time - Indiana - Switzerland County', 'âˆ’05:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+384038-0873143', 'America/Indiana/Vincennes', 'Eastern Time - Indiana - Daviess, Dubois, Knox & Martin Counties', 'âˆ’05:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+410305-0863611', 'America/Indiana/Winamac', 'Eastern Time - Indiana - Pulaski County', 'âˆ’05:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'America/Indianapolis', '', 'âˆ’05:00', 'âˆ’04:00', 'Link to America/Indiana/Indianapolis');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+682059-1334300', 'America/Inuvik', 'Mountain Time - west Northwest Territories', 'âˆ’07:00', 'âˆ’06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+6344-06828', 'America/Iqaluit', 'Eastern Time - east Nunavut - most locations', 'âˆ’05:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('JM', '+1800-07648', 'America/Jamaica', '', 'âˆ’05:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'America/Jujuy', '', 'âˆ’03:00', 'âˆ’03:00', 'Link to America/Argentina/Jujuy');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+581807-1342511', 'America/Juneau', 'Alaska Time - Alaska panhandle', 'âˆ’09:00', 'âˆ’08:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+381515-0854534', 'America/Kentucky/Louisville', 'Eastern Time - Kentucky - Louisville area', 'âˆ’05:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+364947-0845057', 'America/Kentucky/Monticello', 'Eastern Time - Kentucky - Wayne County', 'âˆ’05:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'America/Knox_IN', '', 'âˆ’06:00', 'âˆ’05:00', 'Link to America/Indiana/Knox');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BQ', '+120903-0681636', 'America/Kralendijk', '', 'âˆ’04:00', 'âˆ’04:00', 'Link to America/Curacao');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BO', '-1630-06809', 'America/La_Paz', '', 'âˆ’04:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('PE', '-1203-07703', 'America/Lima', '', 'âˆ’05:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+340308-1181434', 'America/Los_Angeles', 'Pacific Time', 'âˆ’08:00', 'âˆ’07:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'America/Louisville', '', 'âˆ’05:00', 'âˆ’04:00', 'Link to America/Kentucky/Louisville');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('SX', '+180305-0630250', 'America/Lower_Princes', '', 'âˆ’04:00', 'âˆ’04:00', 'Link to America/Curacao');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BR', '-0940-03543', 'America/Maceio', 'Alagoas, Sergipe', 'âˆ’03:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('NI', '+1209-08617', 'America/Managua', '', 'âˆ’06:00', 'âˆ’06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BR', '-0308-06001', 'America/Manaus', 'E Amazonas', 'âˆ’04:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MF', '+1804-06305', 'America/Marigot', '', 'âˆ’04:00', 'âˆ’04:00', 'Link to America/Guadeloupe');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MQ', '+1436-06105', 'America/Martinique', '', 'âˆ’04:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MX', '+2550-09730', 'America/Matamoros', 'US Central Time - Coahuila, Durango, Nuevo LeÃ³n, Tamaulipas near US border', 'âˆ’06:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MX', '+2313-10625', 'America/Mazatlan', 'Mountain Time - S Baja, Nayarit, Sinaloa', 'âˆ’07:00', 'âˆ’06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'America/Mendoza', '', 'âˆ’03:00', 'âˆ’03:00', 'Link to America/Argentina/Mendoza');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+450628-0873651', 'America/Menominee', 'Central Time - Michigan - Dickinson, Gogebic, Iron & Menominee Counties', 'âˆ’06:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MX', '+2058-08937', 'America/Merida', 'Central Time - Campeche, YucatÃ¡n', 'âˆ’06:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+550737-1313435', 'America/Metlakatla', 'Metlakatla Time - Annette Island', 'âˆ’08:00', 'âˆ’08:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MX', '+1924-09909', 'America/Mexico_City', 'Central Time - most locations', 'âˆ’06:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('PM', '+4703-05620', 'America/Miquelon', '', 'âˆ’03:00', 'âˆ’02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+4606-06447', 'America/Moncton', 'Atlantic Time - New Brunswick', 'âˆ’04:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MX', '+2540-10019', 'America/Monterrey', 'Mexican Central Time - Coahuila, Durango, Nuevo LeÃ³n, Tamaulipas away from US border', 'âˆ’06:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('UY', '-3453-05611', 'America/Montevideo', '', 'âˆ’03:00', 'âˆ’02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+4531-07334', 'America/Montreal', 'Eastern Time - Quebec - most locations', 'âˆ’05:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MS', '+1643-06213', 'America/Montserrat', '', 'âˆ’04:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BS', '+2505-07721', 'America/Nassau', '', 'âˆ’05:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+404251-0740023', 'America/New_York', 'Eastern Time', 'âˆ’05:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+4901-08816', 'America/Nipigon', 'Eastern Time - Ontario & Quebec - places that did not observe DST 1967-1973', 'âˆ’05:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+643004-1652423', 'America/Nome', 'Alaska Time - west Alaska', 'âˆ’09:00', 'âˆ’08:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BR', '-0351-03225', 'America/Noronha', 'Atlantic islands', 'âˆ’02:00', 'âˆ’02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+471551-1014640', 'America/North_Dakota/Beulah', 'Central Time - North Dakota - Mercer County', 'âˆ’06:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+470659-1011757', 'America/North_Dakota/Center', 'Central Time - North Dakota - Oliver County', 'âˆ’06:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+465042-1012439', 'America/North_Dakota/New_Salem', 'Central Time - North Dakota - Morton County (except Mandan area)', 'âˆ’06:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MX', '+2934-10425', 'America/Ojinaga', 'US Mountain Time - Chihuahua near US border', 'âˆ’07:00', 'âˆ’06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('PA', '+0858-07932', 'America/Panama', '', 'âˆ’05:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+6608-06544', 'America/Pangnirtung', 'Eastern Time - Pangnirtung, Nunavut', 'âˆ’05:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('SR', '+0550-05510', 'America/Paramaribo', '', 'âˆ’03:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+332654-1120424', 'America/Phoenix', 'Mountain Standard Time - Arizona', 'âˆ’07:00', 'âˆ’07:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('TT', '+1039-06131', 'America/Port_of_Spain', '', 'âˆ’04:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('HT', '+1832-07220', 'America/Port-au-Prince', '', 'âˆ’05:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'America/Porto_Acre', '', 'âˆ’04:00', 'âˆ’04:00', 'Link to America/Rio_Branco');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BR', '-0846-06354', 'America/Porto_Velho', 'Rondonia', 'âˆ’04:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('PR', '+182806-0660622', 'America/Puerto_Rico', '', 'âˆ’04:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+4843-09434', 'America/Rainy_River', 'Central Time - Rainy River & Fort Frances, Ontario', 'âˆ’06:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+624900-0920459', 'America/Rankin_Inlet', 'Central Time - central Nunavut', 'âˆ’06:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BR', '-0803-03454', 'America/Recife', 'Pernambuco', 'âˆ’03:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+5024-10439', 'America/Regina', 'Central Standard Time - Saskatchewan - most locations', 'âˆ’06:00', 'âˆ’06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+744144-0944945', 'America/Resolute', 'Central Standard Time - Resolute, Nunavut', 'âˆ’06:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BR', '-0958-06748', 'America/Rio_Branco', 'Acre', 'âˆ’04:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'America/Rosario', '', 'âˆ’03:00', 'âˆ’03:00', 'Link to America/Argentina/Cordoba');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MX', '+3018-11452', 'America/Santa_Isabel', 'Mexican Pacific Time - Baja California away from US border', 'âˆ’08:00', 'âˆ’07:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BR', '-0226-05452', 'America/Santarem', 'W Para', 'âˆ’03:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CL', '-3327-07040', 'America/Santiago', 'most locations', 'âˆ’04:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('DO', '+1828-06954', 'America/Santo_Domingo', '', 'âˆ’04:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BR', '-2332-04637', 'America/Sao_Paulo', 'S & SE Brazil (GO, DF, MG, ES, RJ, SP, PR, SC, RS)', 'âˆ’03:00', 'âˆ’02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('GL', '+7029-02158', 'America/Scoresbysund', 'Scoresbysund / Ittoqqortoormiit', 'âˆ’01:00', '+00:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+364708-1084111', 'America/Shiprock', 'Mountain Time - Navajo', 'âˆ’07:00', 'âˆ’06:00', 'Link to America/Denver');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+571035-1351807', 'America/Sitka', 'Alaska Time - southeast Alaska panhandle', 'âˆ’09:00', 'âˆ’08:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BL', '+1753-06251', 'America/St_Barthelemy', '', 'âˆ’04:00', 'âˆ’04:00', 'Link to America/Guadeloupe');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+4734-05243', 'America/St_Johns', 'Newfoundland Time, including SE Labrador', 'âˆ’03:30', 'âˆ’02:30', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('KN', '+1718-06243', 'America/St_Kitts', '', 'âˆ’04:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('LC', '+1401-06100', 'America/St_Lucia', '', 'âˆ’04:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('VI', '+1821-06456', 'America/St_Thomas', '', 'âˆ’04:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('VC', '+1309-06114', 'America/St_Vincent', '', 'âˆ’04:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+5017-10750', 'America/Swift_Current', 'Central Standard Time - Saskatchewan - midwest', 'âˆ’06:00', 'âˆ’06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('HN', '+1406-08713', 'America/Tegucigalpa', '', 'âˆ’06:00', 'âˆ’06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('GL', '+7634-06847', 'America/Thule', 'Thule / Pituffik', 'âˆ’04:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+4823-08915', 'America/Thunder_Bay', 'Eastern Time - Thunder Bay, Ontario', 'âˆ’05:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MX', '+3232-11701', 'America/Tijuana', 'US Pacific Time - Baja California near US border', 'âˆ’08:00', 'âˆ’07:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+4339-07923', 'America/Toronto', 'Eastern Time - Ontario - most locations', 'âˆ’05:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('VG', '+1827-06437', 'America/Tortola', '', 'âˆ’04:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+4916-12307', 'America/Vancouver', 'Pacific Time - west British Columbia', 'âˆ’08:00', 'âˆ’07:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'America/Virgin', '', 'âˆ’04:00', 'âˆ’04:00', 'Link to America/St_Thomas');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+6043-13503', 'America/Whitehorse', 'Pacific Time - south Yukon', 'âˆ’08:00', 'âˆ’07:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+4953-09709', 'America/Winnipeg', 'Central Time - Manitoba & west Ontario', 'âˆ’06:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+593249-1394338', 'America/Yakutat', 'Alaska Time - Alaska panhandle neck', 'âˆ’09:00', 'âˆ’08:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CA', '+6227-11421', 'America/Yellowknife', 'Mountain Time - central Northwest Territories', 'âˆ’07:00', 'âˆ’06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AQ', '-6617+11031', 'Antarctica/Casey', 'Casey Station, Bailey Peninsula', '+11:00', '+08:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AQ', '-6835+07758', 'Antarctica/Davis', 'Davis Station, Vestfold Hills', '+05:00', '+07:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AQ', '-6640+14001', 'Antarctica/DumontDUrville', 'Dumont-d\'Urville Station, Terre Adelie', '+10:00', '+10:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AQ', '-5430+15857', 'Antarctica/Macquarie', 'Macquarie Island Station, Macquarie Island', '+11:00', '+11:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AQ', '-6736+06253', 'Antarctica/Mawson', 'Mawson Station, Holme Bay', '+05:00', '+05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AQ', '-7750+16636', 'Antarctica/McMurdo', 'McMurdo Station, Ross Island', '+12:00', '+13:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AQ', '-6448-06406', 'Antarctica/Palmer', 'Palmer Station, Anvers Island', 'âˆ’04:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AQ', '-6734-06808', 'Antarctica/Rothera', 'Rothera Station, Adelaide Island', 'âˆ’03:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AQ', '-9000+00000', 'Antarctica/South_Pole', 'Amundsen-Scott Station, South Pole', '+12:00', '+13:00', 'Link to Antarctica/McMurdo');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AQ', '-690022+0393524', 'Antarctica/Syowa', 'Syowa Station, E Ongul I', '+03:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AQ', '-7824+10654', 'Antarctica/Vostok', 'Vostok Station, Lake Vostok', '+06:00', '+06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('SJ', '+7800+01600', 'Arctic/Longyearbyen', '', '+01:00', '+02:00', 'Link to Europe/Oslo');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('YE', '+1245+04512', 'Asia/Aden', '', '+03:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('KZ', '+4315+07657', 'Asia/Almaty', 'most locations', '+06:00', '+06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('JO', '+3157+03556', 'Asia/Amman', '', '+03:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('RU', '+6445+17729', 'Asia/Anadyr', 'Moscow+08 - Bering Sea', '+12:00', '+12:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('KZ', '+4431+05016', 'Asia/Aqtau', 'Atyrau (Atirau, Gur\'yev), Mangghystau (Mankistau)', '+05:00', '+05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('KZ', '+5017+05710', 'Asia/Aqtobe', 'Aqtobe (Aktobe)', '+05:00', '+05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('TM', '+3757+05823', 'Asia/Ashgabat', '', '+05:00', '+05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Asia/Ashkhabad', '', '+05:00', '+05:00', 'Link to Asia/Ashgabat');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('IQ', '+3321+04425', 'Asia/Baghdad', '', '+03:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BH', '+2623+05035', 'Asia/Bahrain', '', '+03:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AZ', '+4023+04951', 'Asia/Baku', '', '+04:00', '+05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('TH', '+1345+10031', 'Asia/Bangkok', '', '+07:00', '+07:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('LB', '+3353+03530', 'Asia/Beirut', '', '+02:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('KG', '+4254+07436', 'Asia/Bishkek', '', '+06:00', '+06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BN', '+0456+11455', 'Asia/Brunei', '', '+08:00', '+08:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Asia/Calcutta', '', '+05:30', '+05:30', 'Link to Asia/Kolkata');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MN', '+4804+11430', 'Asia/Choibalsan', 'Dornod, Sukhbaatar', '+08:00', '+08:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CN', '+2934+10635', 'Asia/Chongqing', 'central China - Sichuan, Yunnan, Guangxi, Shaanxi, Guizhou, etc.', '+08:00', '+08:00', 'Covering historic Kansu-Szechuan time zone.');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Asia/Chungking', '', '+08:00', '+08:00', 'Link to Asia/Chongqing');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('LK', '+0656+07951', 'Asia/Colombo', '', '+05:30', '+05:30', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Asia/Dacca', '', '+06:00', '+06:00', 'Link to Asia/Dhaka');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('SY', '+3330+03618', 'Asia/Damascus', '', '+02:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BD', '+2343+09025', 'Asia/Dhaka', '', '+06:00', '+06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('TL', '-0833+12535', 'Asia/Dili', '', '+09:00', '+09:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AE', '+2518+05518', 'Asia/Dubai', '', '+04:00', '+04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('TJ', '+3835+06848', 'Asia/Dushanbe', '', '+05:00', '+05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('PS', '+3130+03428', 'Asia/Gaza', 'Gaza Strip', '+02:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CN', '+4545+12641', 'Asia/Harbin', 'Heilongjiang (except Mohe), Jilin', '+08:00', '+08:00', 'Covering historic Changpai time zone.');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('PS', '+313200+0350542', 'Asia/Hebron', 'West Bank', '+02:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('VN', '+1045+10640', 'Asia/Ho_Chi_Minh', '', '+07:00', '+07:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('HK', '+2217+11409', 'Asia/Hong_Kong', '', '+08:00', '+08:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MN', '+4801+09139', 'Asia/Hovd', 'Bayan-Olgiy, Govi-Altai, Hovd, Uvs, Zavkhan', '+07:00', '+07:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('RU', '+5216+10420', 'Asia/Irkutsk', 'Moscow+05 - Lake Baikal', '+09:00', '+09:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Asia/Istanbul', '', '+02:00', '+03:00', 'Link to Europe/Istanbul');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('ID', '-0610+10648', 'Asia/Jakarta', 'Java & Sumatra', '+07:00', '+07:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('ID', '-0232+14042', 'Asia/Jayapura', 'west New Guinea (Irian Jaya) & Malukus (Moluccas)', '+09:00', '+09:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('IL', '+3146+03514', 'Asia/Jerusalem', '', '+02:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AF', '+3431+06912', 'Asia/Kabul', '', '+04:30', '+04:30', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('RU', '+5301+15839', 'Asia/Kamchatka', 'Moscow+08 - Kamchatka', '+12:00', '+12:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('PK', '+2452+06703', 'Asia/Karachi', '', '+05:00', '+05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CN', '+3929+07559', 'Asia/Kashgar', 'west Tibet & Xinjiang', '+08:00', '+08:00', 'Covering historic Kunlun time zone.');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('NP', '+2743+08519', 'Asia/Kathmandu', '', '+05:45', '+05:45', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Asia/Katmandu', '', '+05:45', '+05:45', 'Link to Asia/Kathmandu');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('IN', '+2232+08822', 'Asia/Kolkata', '', '+05:30', '+05:30', 'Note: Different zones in history, see Time in India.');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('RU', '+5601+09250', 'Asia/Krasnoyarsk', 'Moscow+04 - Yenisei River', '+08:00', '+08:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MY', '+0310+10142', 'Asia/Kuala_Lumpur', 'peninsular Malaysia', '+08:00', '+08:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MY', '+0133+11020', 'Asia/Kuching', 'Sabah & Sarawak', '+08:00', '+08:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('KW', '+2920+04759', 'Asia/Kuwait', '', '+03:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Asia/Macao', '', '+08:00', '+08:00', 'Link to Asia/Macau');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MO', '+2214+11335', 'Asia/Macau', '', '+08:00', '+08:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('RU', '+5934+15048', 'Asia/Magadan', 'Moscow+08 - Magadan', '+12:00', '+12:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('ID', '-0507+11924', 'Asia/Makassar', 'east & south Borneo, Sulawesi (Celebes), Bali, Nusa Tenggara, west Timor', '+08:00', '+08:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('PH', '+1435+12100', 'Asia/Manila', '', '+08:00', '+08:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('OM', '+2336+05835', 'Asia/Muscat', '', '+04:00', '+04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CY', '+3510+03322', 'Asia/Nicosia', '', '+02:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('RU', '+5345+08707', 'Asia/Novokuznetsk', 'Moscow+03 - Novokuznetsk', '+07:00', '+07:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('RU', '+5502+08255', 'Asia/Novosibirsk', 'Moscow+03 - Novosibirsk', '+07:00', '+07:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('RU', '+5500+07324', 'Asia/Omsk', 'Moscow+03 - west Siberia', '+07:00', '+07:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('KZ', '+5113+05121', 'Asia/Oral', 'West Kazakhstan', '+05:00', '+05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('KH', '+1133+10455', 'Asia/Phnom_Penh', '', '+07:00', '+07:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('ID', '-0002+10920', 'Asia/Pontianak', 'west & central Borneo', '+07:00', '+07:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('KP', '+3901+12545', 'Asia/Pyongyang', '', '+09:00', '+09:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('QA', '+2517+05132', 'Asia/Qatar', '', '+03:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('KZ', '+4448+06528', 'Asia/Qyzylorda', 'Qyzylorda (Kyzylorda, Kzyl-Orda)', '+06:00', '+06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MM', '+1647+09610', 'Asia/Rangoon', '', '+06:30', '+06:30', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('SA', '+2438+04643', 'Asia/Riyadh', '', '+03:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Asia/Saigon', '', '+07:00', '+07:00', 'Link to Asia/Ho_Chi_Minh');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('RU', '+4658+14242', 'Asia/Sakhalin', 'Moscow+07 - Sakhalin Island', '+11:00', '+11:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('UZ', '+3940+06648', 'Asia/Samarkand', 'west Uzbekistan', '+05:00', '+05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('KR', '+3733+12658', 'Asia/Seoul', '', '+09:00', '+09:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CN', '+3114+12128', 'Asia/Shanghai', 'east China - Beijing, Guangdong, Shanghai, etc.', '+08:00', '+08:00', 'Covering historic Chungyuan time zone.');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('SG', '+0117+10351', 'Asia/Singapore', '', '+08:00', '+08:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('TW', '+2503+12130', 'Asia/Taipei', '', '+08:00', '+08:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('UZ', '+4120+06918', 'Asia/Tashkent', 'east Uzbekistan', '+05:00', '+05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('GE', '+4143+04449', 'Asia/Tbilisi', '', '+04:00', '+04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('IR', '+3540+05126', 'Asia/Tehran', '', '+03:30', '+04:30', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Asia/Tel_Aviv', '', '+02:00', '+03:00', 'Link to Asia/Jerusalem');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Asia/Thimbu', '', '+06:00', '+06:00', 'Link to Asia/Thimphu');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BT', '+2728+08939', 'Asia/Thimphu', '', '+06:00', '+06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('JP', '+353916+1394441', 'Asia/Tokyo', '', '+09:00', '+09:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Asia/Ujung_Pandang', '', '+08:00', '+08:00', 'Link to Asia/Makassar');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MN', '+4755+10653', 'Asia/Ulaanbaatar', 'most locations', '+08:00', '+08:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Asia/Ulan_Bator', '', '+08:00', '+08:00', 'Link to Asia/Ulaanbaatar');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CN', '+4348+08735', 'Asia/Urumqi', 'most of Tibet & Xinjiang', '+08:00', '+08:00', 'Covering historic Sinkiang-Tibet time zone.');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('LA', '+1758+10236', 'Asia/Vientiane', '', '+07:00', '+07:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('RU', '+4310+13156', 'Asia/Vladivostok', 'Moscow+07 - Amur River', '+11:00', '+11:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('RU', '+6200+12940', 'Asia/Yakutsk', 'Moscow+06 - Lena River', '+10:00', '+10:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('RU', '+5651+06036', 'Asia/Yekaterinburg', 'Moscow+02 - Urals', '+06:00', '+06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AM', '+4011+04430', 'Asia/Yerevan', '', '+04:00', '+04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('PT', '+3744-02540', 'Atlantic/Azores', 'Azores', 'âˆ’01:00', '+00:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BM', '+3217-06446', 'Atlantic/Bermuda', '', 'âˆ’04:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('ES', '+2806-01524', 'Atlantic/Canary', 'Canary Islands', '+00:00', '+01:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CV', '+1455-02331', 'Atlantic/Cape_Verde', '', 'âˆ’01:00', 'âˆ’01:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Atlantic/Faeroe', '', '+00:00', '+01:00', 'Link to Atlantic/Faroe');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('FO', '+6201-00646', 'Atlantic/Faroe', '', '+00:00', '+01:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Atlantic/Jan_Mayen', '', '+01:00', '+02:00', 'Link to Europe/Oslo');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('PT', '+3238-01654', 'Atlantic/Madeira', 'Madeira Islands', '+00:00', '+01:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('IS', '+6409-02151', 'Atlantic/Reykjavik', '', '+00:00', '+00:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('GS', '-5416-03632', 'Atlantic/South_Georgia', '', 'âˆ’02:00', 'âˆ’02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('SH', '-1555-00542', 'Atlantic/St_Helena', '', '+00:00', '+00:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('FK', '-5142-05751', 'Atlantic/Stanley', '', 'âˆ’03:00', 'âˆ’03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Australia/ACT', '', '+10:00', '+11:00', 'Link to Australia/Sydney');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AU', '-3455+13835', 'Australia/Adelaide', 'South Australia', '+09:30', '+10:30', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AU', '-2728+15302', 'Australia/Brisbane', 'Queensland - most locations', '+10:00', '+10:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AU', '-3157+14127', 'Australia/Broken_Hill', 'New South Wales - Yancowinna', '+09:30', '+10:30', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Australia/Canberra', '', '+10:00', '+11:00', 'Link to Australia/Sydney');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AU', '-3956+14352', 'Australia/Currie', 'Tasmania - King Island', '+10:00', '+11:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AU', '-1228+13050', 'Australia/Darwin', 'Northern Territory', '+09:30', '+09:30', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AU', '-3143+12852', 'Australia/Eucla', 'Western Australia - Eucla area', '+08:45', '+08:45', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AU', '-4253+14719', 'Australia/Hobart', 'Tasmania - most locations', '+10:00', '+11:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Australia/LHI', '', '+10:30', '+11:00', 'Link to Australia/Lord_Howe');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AU', '-2016+14900', 'Australia/Lindeman', 'Queensland - Holiday Islands', '+10:00', '+10:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AU', '-3133+15905', 'Australia/Lord_Howe', 'Lord Howe Island', '+10:30', '+11:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AU', '-3749+14458', 'Australia/Melbourne', 'Victoria', '+10:00', '+11:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Australia/North', '', '+09:30', '+09:30', 'Link to Australia/Darwin');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Australia/NSW', '', '+10:00', '+11:00', 'Link to Australia/Sydney');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AU', '-3157+11551', 'Australia/Perth', 'Western Australia - most locations', '+08:00', '+08:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Australia/Queensland', '', '+10:00', '+10:00', 'Link to Australia/Brisbane');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Australia/South', '', '+09:30', '+10:30', 'Link to Australia/Adelaide');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AU', '-3352+15113', 'Australia/Sydney', 'New South Wales - most locations', '+10:00', '+11:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Australia/Tasmania', '', '+10:00', '+11:00', 'Link to Australia/Hobart');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Australia/Victoria', '', '+10:00', '+11:00', 'Link to Australia/Melbourne');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Australia/West', '', '+08:00', '+08:00', 'Link to Australia/Perth');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Australia/Yancowinna', '', '+09:30', '+10:30', 'Link to Australia/Broken_Hill');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Brazil/Acre', '', 'âˆ’04:00', 'âˆ’04:00', 'Link to America/Rio_Branco');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Brazil/DeNoronha', '', 'âˆ’02:00', 'âˆ’02:00', 'Link to America/Noronha');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Brazil/East', '', 'âˆ’03:00', 'âˆ’02:00', 'Link to America/Sao_Paulo');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Brazil/West', '', 'âˆ’04:00', 'âˆ’04:00', 'Link to America/Manaus');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Canada/Atlantic', '', 'âˆ’04:00', 'âˆ’03:00', 'Link to America/Halifax');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Canada/Central', '', 'âˆ’06:00', 'âˆ’05:00', 'Link to America/Winnipeg');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Canada/East-Saskatchewan', '', 'âˆ’06:00', 'âˆ’06:00', 'Link to America/Regina');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Canada/Eastern', '', 'âˆ’05:00', 'âˆ’04:00', 'Link to America/Toronto');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Canada/Mountain', '', 'âˆ’07:00', 'âˆ’06:00', 'Link to America/Edmonton');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Canada/Newfoundland', '', 'âˆ’03:30', 'âˆ’02:30', 'Link to America/St_Johns');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Canada/Pacific', '', 'âˆ’08:00', 'âˆ’07:00', 'Link to America/Vancouver');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Canada/Saskatchewan', '', 'âˆ’06:00', 'âˆ’06:00', 'Link to America/Regina');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Canada/Yukon', '', 'âˆ’08:00', 'âˆ’07:00', 'Link to America/Whitehorse');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'CET', '', '+01:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Chile/Continental', '', 'âˆ’04:00', 'âˆ’03:00', 'Link to America/Santiago');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Chile/EasterIsland', '', 'âˆ’06:00', 'âˆ’05:00', 'Link to Pacific/Easter');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'CST6CDT', '', 'âˆ’06:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Cuba', '', 'âˆ’05:00', 'âˆ’04:00', 'Link to America/Havana');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'EET', '', '+02:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Egypt', '', '+02:00', '+02:00', 'Link to Africa/Cairo');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Eire', '', '+00:00', '+01:00', 'Link to Europe/Dublin');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'EST', '', 'âˆ’05:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'EST5EDT', '', 'âˆ’05:00', 'âˆ’04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Etc./GMT', '', '+00:00', '+00:00', 'Link to UTC');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Etc./GMT+0', '', '+00:00', '+00:00', 'Link to UTC');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Etc./UCT', '', '+00:00', '+00:00', 'Link to UTC');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Etc./Universal', '', '+00:00', '+00:00', 'Link to UTC');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Etc./UTC', '', '+00:00', '+00:00', 'Link to UTC');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Etc./Zulu', '', '+00:00', '+00:00', 'Link to UTC');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('NL', '+5222+00454', 'Europe/Amsterdam', '', '+01:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AD', '+4230+00131', 'Europe/Andorra', '', '+01:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('GR', '+3758+02343', 'Europe/Athens', '', '+02:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Europe/Belfast', '', '+00:00', '+01:00', 'Link to Europe/London');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('RS', '+4450+02030', 'Europe/Belgrade', '', '+01:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('DE', '+5230+01322', 'Europe/Berlin', '', '+01:00', '+02:00', 'In 1945, the Trizone did not follow Berlin\'s switch to DST, see Time in Germany');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('SK', '+4809+01707', 'Europe/Bratislava', '', '+01:00', '+02:00', 'Link to Europe/Prague');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BE', '+5050+00420', 'Europe/Brussels', '', '+01:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('RO', '+4426+02606', 'Europe/Bucharest', '', '+02:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('HU', '+4730+01905', 'Europe/Budapest', '', '+01:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MD', '+4700+02850', 'Europe/Chisinau', '', '+02:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('DK', '+5540+01235', 'Europe/Copenhagen', '', '+01:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('IE', '+5320-00615', 'Europe/Dublin', '', '+00:00', '+01:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('GI', '+3608-00521', 'Europe/Gibraltar', '', '+01:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('GG', '+4927-00232', 'Europe/Guernsey', '', '+00:00', '+01:00', 'Link to Europe/London');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('FI', '+6010+02458', 'Europe/Helsinki', '', '+02:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('IM', '+5409-00428', 'Europe/Isle_of_Man', '', '+00:00', '+01:00', 'Link to Europe/London');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('TR', '+4101+02858', 'Europe/Istanbul', '', '+02:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('JE', '+4912-00207', 'Europe/Jersey', '', '+00:00', '+01:00', 'Link to Europe/London');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('RU', '+5443+02030', 'Europe/Kaliningrad', 'Moscow-01 - Kaliningrad', '+03:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('UA', '+5026+03031', 'Europe/Kiev', 'most locations', '+02:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('PT', '+3843-00908', 'Europe/Lisbon', 'mainland', '+00:00', '+01:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('SI', '+4603+01431', 'Europe/Ljubljana', '', '+01:00', '+02:00', 'Link to Europe/Belgrade');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('GB', '+513030-0000731', 'Europe/London', '', '+00:00', '+01:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('LU', '+4936+00609', 'Europe/Luxembourg', '', '+01:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('ES', '+4024-00341', 'Europe/Madrid', 'mainland', '+01:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MT', '+3554+01431', 'Europe/Malta', '', '+01:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AX', '+6006+01957', 'Europe/Mariehamn', '', '+02:00', '+03:00', 'Link to Europe/Helsinki');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BY', '+5354+02734', 'Europe/Minsk', '', '+03:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MC', '+4342+00723', 'Europe/Monaco', '', '+01:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('RU', '+5545+03735', 'Europe/Moscow', 'Moscow+00 - west Russia', '+04:00', '+04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Europe/Nicosia', '', '+02:00', '+03:00', 'Link to Asia/Nicosia');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('NO', '+5955+01045', 'Europe/Oslo', '', '+01:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('FR', '+4852+00220', 'Europe/Paris', '', '+01:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('ME', '+4226+01916', 'Europe/Podgorica', '', '+01:00', '+02:00', 'Link to Europe/Belgrade');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CZ', '+5005+01426', 'Europe/Prague', '', '+01:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('LV', '+5657+02406', 'Europe/Riga', '', '+02:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('IT', '+4154+01229', 'Europe/Rome', '', '+01:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('RU', '+5312+05009', 'Europe/Samara', 'Moscow+00 - Samara, Udmurtia', '+04:00', '+04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('SM', '+4355+01228', 'Europe/San_Marino', '', '+01:00', '+02:00', 'Link to Europe/Rome');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BA', '+4352+01825', 'Europe/Sarajevo', '', '+01:00', '+02:00', 'Link to Europe/Belgrade');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('UA', '+4457+03406', 'Europe/Simferopol', 'central Crimea', '+02:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MK', '+4159+02126', 'Europe/Skopje', '', '+01:00', '+02:00', 'Link to Europe/Belgrade');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('BG', '+4241+02319', 'Europe/Sofia', '', '+02:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('SE', '+5920+01803', 'Europe/Stockholm', '', '+01:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('EE', '+5925+02445', 'Europe/Tallinn', '', '+02:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AL', '+4120+01950', 'Europe/Tirane', '', '+01:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Europe/Tiraspol', '', '+02:00', '+03:00', 'Link to Europe/Chisinau');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('UA', '+4837+02218', 'Europe/Uzhgorod', 'Ruthenia', '+02:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('LI', '+4709+00931', 'Europe/Vaduz', '', '+01:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('VA', '+415408+0122711', 'Europe/Vatican', '', '+01:00', '+02:00', 'Link to Europe/Rome');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AT', '+4813+01620', 'Europe/Vienna', '', '+01:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('LT', '+5441+02519', 'Europe/Vilnius', '', '+02:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('RU', '+4844+04425', 'Europe/Volgograd', 'Moscow+00 - Caspian Sea', '+04:00', '+04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('PL', '+5215+02100', 'Europe/Warsaw', '', '+01:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('HR', '+4548+01558', 'Europe/Zagreb', '', '+01:00', '+02:00', 'Link to Europe/Belgrade');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('UA', '+4750+03510', 'Europe/Zaporozhye', 'Zaporozh\'ye, E Lugansk / Zaporizhia, E Luhansk', '+02:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CH', '+4723+00832', 'Europe/Zurich', '', '+01:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'GB', '', '+00:00', '+01:00', 'Link to Europe/London');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'GB-Eire', '', '+00:00', '+01:00', 'Link to Europe/London');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'GMT', '', '+00:00', '+00:00', 'Link to UTC');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'GMT-0', '', '+00:00', '+00:00', 'Link to UTC');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'GMT+0', '', '+00:00', '+00:00', 'Link to UTC');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'GMT0', '', '+00:00', '+00:00', 'Link to UTC');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Greenwich', '', '+00:00', '+00:00', 'Link to UTC');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Hong Kong', '', '+08:00', '+08:00', 'Link to Asia/Hong_Kong');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'HST', '', 'âˆ’10:00', 'âˆ’10:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Iceland', '', '+00:00', '+00:00', 'Link to Atlantic/Reykjavik');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MG', '-1855+04731', 'Indian/Antananarivo', '', '+03:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('IO', '-0720+07225', 'Indian/Chagos', '', '+06:00', '+06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CX', '-1025+10543', 'Indian/Christmas', '', '+07:00', '+07:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CC', '-1210+09655', 'Indian/Cocos', '', '+06:30', '+06:30', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('KM', '-1141+04316', 'Indian/Comoro', '', '+03:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('TF', '-492110+0701303', 'Indian/Kerguelen', '', '+05:00', '+05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('SC', '-0440+05528', 'Indian/Mahe', '', '+04:00', '+04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MV', '+0410+07330', 'Indian/Maldives', '', '+05:00', '+05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MU', '-2010+05730', 'Indian/Mauritius', '', '+04:00', '+04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('YT', '-1247+04514', 'Indian/Mayotte', '', '+03:00', '+03:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('RE', '-2052+05528', 'Indian/Reunion', '', '+04:00', '+04:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Iran', '', '+03:30', '+04:30', 'Link to Asia/Tehran');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Israel', '', '+02:00', '+03:00', 'Link to Asia/Jerusalem');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Jamaica', '', 'âˆ’05:00', 'âˆ’05:00', 'Link to America/Jamaica');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Japan', '', '+09:00', '+09:00', 'Link to Asia/Tokyo');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'JST-9', '', '+09:00', '+09:00', 'Link to Asia/Tokyo');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Kwajalein', '', '+12:00', '+12:00', 'Link to Pacific/Kwajalein');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Libya', '', '+02:00', '+02:00', 'Link to Africa/Tripoli');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'MET', '', '+01:00', '+02:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Mexico/BajaNorte', '', 'âˆ’08:00', 'âˆ’07:00', 'Link to America/Tijuana');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Mexico/BajaSur', '', 'âˆ’07:00', 'âˆ’06:00', 'Link to America/Mazatlan');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Mexico/General', '', 'âˆ’06:00', 'âˆ’05:00', 'Link to America/Mexico_City');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'MST', '', 'âˆ’07:00', 'âˆ’07:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'MST7MDT', '', 'âˆ’07:00', 'âˆ’06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Navajo', '', 'âˆ’07:00', 'âˆ’06:00', 'Link to America/Denver');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'NZ', '', '+12:00', '+13:00', 'Link to Pacific/Auckland');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'NZ-CHAT', '', '+12:45', '+13:45', 'Link to Pacific/Chatham');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('WS', '-1350-17144', 'Pacific/Apia', '', '+13:00', '+14:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('NZ', '-3652+17446', 'Pacific/Auckland', 'most locations', '+12:00', '+13:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('NZ', '-4357-17633', 'Pacific/Chatham', 'Chatham Islands', '+12:45', '+13:45', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('FM', '+0725+15147', 'Pacific/Chuuk', 'Chuuk (Truk) and Yap', '+10:00', '+10:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CL', '-2709-10926', 'Pacific/Easter', 'Easter Island & Sala y Gomez', 'âˆ’06:00', 'âˆ’05:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('VU', '-1740+16825', 'Pacific/Efate', '', '+11:00', '+11:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('KI', '-0308-17105', 'Pacific/Enderbury', 'Phoenix Islands', '+13:00', '+13:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('TK', '-0922-17114', 'Pacific/Fakaofo', '', '+13:00', '+13:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('FJ', '-1808+17825', 'Pacific/Fiji', '', '+12:00', '+13:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('TV', '-0831+17913', 'Pacific/Funafuti', '', '+12:00', '+12:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('EC', '-0054-08936', 'Pacific/Galapagos', 'Galapagos Islands', 'âˆ’06:00', 'âˆ’06:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('PF', '-2308-13457', 'Pacific/Gambier', 'Gambier Islands', 'âˆ’09:00', 'âˆ’09:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('SB', '-0932+16012', 'Pacific/Guadalcanal', '', '+11:00', '+11:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('GU', '+1328+14445', 'Pacific/Guam', '', '+10:00', '+10:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('US', '+211825-1575130', 'Pacific/Honolulu', 'Hawaii', 'âˆ’10:00', 'âˆ’10:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('UM', '+1645-16931', 'Pacific/Johnston', 'Johnston Atoll', 'âˆ’10:00', 'âˆ’10:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('KI', '+0152-15720', 'Pacific/Kiritimati', 'Line Islands', '+14:00', '+14:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('FM', '+0519+16259', 'Pacific/Kosrae', 'Kosrae', '+11:00', '+11:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MH', '+0905+16720', 'Pacific/Kwajalein', 'Kwajalein', '+12:00', '+12:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MH', '+0709+17112', 'Pacific/Majuro', 'most locations', '+12:00', '+12:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('PF', '-0900-13930', 'Pacific/Marquesas', 'Marquesas Islands', 'âˆ’09:30', 'âˆ’09:30', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('UM', '+2813-17722', 'Pacific/Midway', 'Midway Islands', 'âˆ’11:00', 'âˆ’11:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('NR', '-0031+16655', 'Pacific/Nauru', '', '+12:00', '+12:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('NU', '-1901-16955', 'Pacific/Niue', '', 'âˆ’11:00', 'âˆ’11:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('NF', '-2903+16758', 'Pacific/Norfolk', '', '+11:30', '+11:30', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('NC', '-2216+16627', 'Pacific/Noumea', '', '+11:00', '+11:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('AS', '-1416-17042', 'Pacific/Pago_Pago', '', 'âˆ’11:00', 'âˆ’11:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('PW', '+0720+13429', 'Pacific/Palau', '', '+09:00', '+09:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('PN', '-2504-13005', 'Pacific/Pitcairn', '', 'âˆ’08:00', 'âˆ’08:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('FM', '+0658+15813', 'Pacific/Pohnpei', 'Pohnpei (Ponape)', '+11:00', '+11:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Pacific/Ponape', '', '+11:00', '+11:00', 'Link to Pacific/Pohnpei');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('PG', '-0930+14710', 'Pacific/Port_Moresby', '', '+10:00', '+10:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('CK', '-2114-15946', 'Pacific/Rarotonga', '', 'âˆ’10:00', 'âˆ’10:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('MP', '+1512+14545', 'Pacific/Saipan', '', '+10:00', '+10:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Pacific/Samoa', '', 'âˆ’11:00', 'âˆ’11:00', 'Link to Pacific/Pago_Pago');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('PF', '-1732-14934', 'Pacific/Tahiti', 'Society Islands', 'âˆ’10:00', 'âˆ’10:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('KI', '+0125+17300', 'Pacific/Tarawa', 'Gilbert Islands', '+12:00', '+12:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('TO', '-2110-17510', 'Pacific/Tongatapu', '', '+13:00', '+13:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Pacific/Truk', '', '+10:00', '+10:00', 'Link to Pacific/Chuuk');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('UM', '+1917+16637', 'Pacific/Wake', 'Wake Island', '+12:00', '+12:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('WF', '-1318-17610', 'Pacific/Wallis', '', '+12:00', '+12:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Pacific/Yap', '', '+10:00', '+10:00', 'Link to Pacific/Chuuk');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Poland', '', '+01:00', '+02:00', 'Link to Europe/Warsaw');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Portugal', '', '+00:00', '+01:00', 'Link to Europe/Lisbon');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'PRC', '', '+08:00', '+08:00', 'Link to Asia/Shanghai');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'PST8PDT', '', 'âˆ’08:00', 'âˆ’07:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'ROC', '', '+08:00', '+08:00', 'Link to Asia/Taipei');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'ROK', '', '+09:00', '+09:00', 'Link to Asia/Seoul');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Singapore', '', '+08:00', '+08:00', 'Link to Asia/Singapore');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Turkey', '', '+02:00', '+03:00', 'Link to Europe/Istanbul');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'UCT', '', '+00:00', '+00:00', 'Link to UTC');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Universal', '', '+00:00', '+00:00', 'Link to UTC');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'US/Alaska', '', 'âˆ’09:00', 'âˆ’08:00', 'Link to America/Anchorage');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'US/Aleutian', '', 'âˆ’10:00', 'âˆ’09:00', 'Link to America/Adak');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'US/Arizona', '', 'âˆ’07:00', 'âˆ’07:00', 'Link to America/Phoenix');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'US/Central', '', 'âˆ’06:00', 'âˆ’05:00', 'Link to America/Chicago');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'US/East-Indiana', '', 'âˆ’05:00', 'âˆ’04:00', 'Link to America/Indiana/Indianapolis');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'US/Eastern', '', 'âˆ’05:00', 'âˆ’04:00', 'Link to America/New_York');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'US/Hawaii', '', 'âˆ’10:00', 'âˆ’10:00', 'Link to Pacific/Honolulu');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'US/Indiana-Starke', '', 'âˆ’06:00', 'âˆ’05:00', 'Link to America/Indiana/Knox');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'US/Michigan', '', 'âˆ’05:00', 'âˆ’04:00', 'Link to America/Detroit');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'US/Mountain', '', 'âˆ’07:00', 'âˆ’06:00', 'Link to America/Denver');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'US/Pacific', '', 'âˆ’08:00', 'âˆ’07:00', 'Link to America/Los_Angeles');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'US/Pacific-New', '', 'âˆ’08:00', 'âˆ’07:00', 'Link to America/Los_Angeles');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'US/Samoa', '', 'âˆ’11:00', 'âˆ’11:00', 'Link to Pacific/Pago_Pago');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'UTC', '', '+00:00', '+00:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'W-SU', '', '+04:00', '+04:00', 'Link to Europe/Moscow');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'WET', '', '+00:00', '+01:00', '');
INSERT INTO `calendar` (`country_code`, `coordinates`, `timezone`, `comments`, `utc_offset`, `utc_dst_offset`, `notes`) VALUES ('', '', 'Zulu', '', '+00:00', '+00:00', 'Link to UTC');


#
# TABLE STRUCTURE FOR: ci_sessions
#

DROP TABLE IF EXISTS `ci_sessions`;

CREATE TABLE `ci_sessions` (
  `id` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT 0,
  `data` longblob DEFAULT NULL,
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('keib9jeajhmp3vi17svljmuc1fptjtrg', '127.0.0.1', 1607437888, '__ci_last_regenerate|i:1607437888;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('flpmmpuh2b2coss47965hl9gj4ltd2nt', '127.0.0.1', 1607438092, '__ci_last_regenerate|i:1607438092;active_language_id|s:1:\"1\";login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:3:\"162\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2nkhauvvcinlgm2jmvb621jbhf4vkn43', '127.0.0.1', 1607437915, '__ci_last_regenerate|i:1607437888;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('n7t0vbdng25meh8r9as1n05deviop7ri', '127.0.0.1', 1607944954, '__ci_last_regenerate|i:1607944954;active_language_id|s:1:\"1\";login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:3:\"160\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cauhithd9p7mvuvenlilpo8k1dktcb93', '127.0.0.1', 1607519604, '__ci_last_regenerate|i:1607519604;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jifebff5mjsohj10unldsot2rgj77ann', '127.0.0.1', 1607519994, '__ci_last_regenerate|i:1607519994;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5c2tf5o6hbd6q9o4lb6a67epij07h8ad', '127.0.0.1', 1607527258, '__ci_last_regenerate|i:1607527258;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2qqspmqeosaa75l64om3tudpcjkpss1e', '127.0.0.1', 1607527563, '__ci_last_regenerate|i:1607527563;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:2:\"16\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3h0l548is3pdhqktn28g9k8sfrq590ve', '127.0.0.1', 1607533399, '__ci_last_regenerate|i:1607533399;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"4\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('sj58vlef80kluv3csb7332h6v4hu8kug', '127.0.0.1', 1607552624, '__ci_last_regenerate|i:1607552624;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"4\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a46g4fj2hmnslao093iur1958jt1nfb9', '127.0.0.1', 1607553163, '__ci_last_regenerate|i:1607553163;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"4\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('98uu9mdclbc7jelkd7t57nc0poi72717', '127.0.0.1', 1607553471, '__ci_last_regenerate|i:1607553471;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:4:\"4001\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('t380r9rtfflp9lvjj58gudl4pdpnc39h', '127.0.0.1', 1607553537, '__ci_last_regenerate|i:1607553471;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:4:\"4001\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2juv3bocce6loks0eandaaatmptsm5up', '127.0.0.1', 1607616121, '__ci_last_regenerate|i:1607615838;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('emba9vre3m07mstfuppjo40c5jut4jg8', '127.0.0.1', 1607695949, '__ci_last_regenerate|i:1607695760;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('47rkf28u92tstbecg4o70qm2rljergvg', '127.0.0.1', 1607704972, '__ci_last_regenerate|i:1607704972;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d2aeirllu5spnktbpsu8m787ad1vldmp', '127.0.0.1', 1607695896, '__ci_last_regenerate|i:1607695896;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('e0cln2uablrta59e7o4nv4s16nbvtj46', '127.0.0.1', 1607704972, '__ci_last_regenerate|i:1607704972;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0gsevbcvktnn1u54t71tj6fnbubd6plm', '127.0.0.1', 1607809907, '__ci_last_regenerate|i:1607809907;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('j5kn9n66mo83c2v7r7mhe5h7cvq9nhh8', '127.0.0.1', 1607810150, '__ci_last_regenerate|i:1607809907;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('e6gdoh00k0v9i8c6fd42f669c8g8bj1b', '127.0.0.1', 1607874564, '__ci_last_regenerate|i:1607874557;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ud4jn7jfbj6ddjjon8lqnfij3mpl6gu2', '127.0.0.1', 1607874557, '__ci_last_regenerate|i:1607874557;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('eh54vg4b8ie7h1lvcacj47540j7kcojh', '127.0.0.1', 1607888049, '__ci_last_regenerate|i:1607888049;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d263lqdtpbqatdnks3jt2dpf7u51da6g', '127.0.0.1', 1607888063, '__ci_last_regenerate|i:1607888051;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('427utubb8oaofdjp2pnq9e7kcd9f1kps', '127.0.0.1', 1607945391, '__ci_last_regenerate|i:1607945391;active_language_id|s:1:\"1\";login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('go1cvej42o636k0jq5bq2i70stim9kb4', '127.0.0.1', 1607945957, '__ci_last_regenerate|i:1607945957;active_language_id|s:1:\"1\";login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"6\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('k08luqs4t9b5rt24run1r6enr5mhph5r', '127.0.0.1', 1607946788, '__ci_last_regenerate|i:1607946788;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vqdoa31a52r4vn0gs2dqktp47ojia4jj', '127.0.0.1', 1607946943, '__ci_last_regenerate|i:1607946943;active_language_id|s:1:\"1\";login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"6\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9imn14idlfdg7aomkv4o4gkk90unsdj3', '127.0.0.1', 1607946017, '__ci_last_regenerate|i:1607946017;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('58uj68bqoo9m4r6j0v0p3rpf0a9bcoi7', '127.0.0.1', 1607973717, '__ci_last_regenerate|i:1607973717;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:2:\"16\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bjcq1tp81j7ahocglu4atoifq67qq54r', '127.0.0.1', 1607947256, '__ci_last_regenerate|i:1607947256;active_language_id|s:1:\"1\";login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:4:\"4001\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('trllun87gi0obn8b1sjv5i3oao8flflj', '127.0.0.1', 1607950988, '__ci_last_regenerate|i:1607950988;active_language_id|s:1:\"1\";login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:2:\"23\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('misgcvmeprr2etlcecde4m54uivjevd1', '127.0.0.1', 1607951373, '__ci_last_regenerate|i:1607951373;active_language_id|s:1:\"1\";login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:2:\"30\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bjeit3ovporusgu2qgoauh07i9a55m56', '127.0.0.1', 1607951689, '__ci_last_regenerate|i:1607951689;active_language_id|s:1:\"1\";login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:2:\"35\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('94a2avsqbhv76kv7iogt8dqok5ttqrn2', '127.0.0.1', 1607952005, '__ci_last_regenerate|i:1607952005;active_language_id|s:1:\"1\";login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:2:\"35\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4ht3vps2kgjq34tm80fioi66kus10hv1', '127.0.0.1', 1607952495, '__ci_last_regenerate|i:1607952495;active_language_id|s:1:\"1\";login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:3:\"162\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0rqqegtfja077fvkinm4ig2l9e6r152s', '127.0.0.1', 1607952280, '__ci_last_regenerate|i:1607952280;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cm0as4mpkmvibd7f43i79t7k18nkhoks', '127.0.0.1', 1607952283, '__ci_last_regenerate|i:1607952283;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('h8vs2nujs9ml7g28a3o07trg2oh3v0ou', '127.0.0.1', 1607952299, '__ci_last_regenerate|i:1607952298;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1bojpklku0u9ptlhpejvmplhm206ajfj', '127.0.0.1', 1607952299, '__ci_last_regenerate|i:1607952299;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ignhv2eatgg9lbjil13cr3b4ovtmm0ca', '127.0.0.1', 1607952308, '__ci_last_regenerate|i:1607952308;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9hqaqom5chvkgnscq2dpcgm8vjtl1oba', '127.0.0.1', 1607952308, '__ci_last_regenerate|i:1607952308;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mr7f0p65ogc1k0v2pel8e2ie7il2phsu', '127.0.0.1', 1607952319, '__ci_last_regenerate|i:1607952319;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('pono0m8a1r154je4sr8b67q3njdpfpsa', '127.0.0.1', 1607952321, '__ci_last_regenerate|i:1607952321;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mf1aok9n9mdv16ksmvp5sqita55us551', '127.0.0.1', 1607952323, '__ci_last_regenerate|i:1607952323;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5gbafqg50mevdgo0epqjhjo4dg9gmrcv', '127.0.0.1', 1607952323, '__ci_last_regenerate|i:1607952323;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('meqkaqgld5hk4mf7dta4vqhmikc9fl5v', '127.0.0.1', 1607952373, '__ci_last_regenerate|i:1607952373;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ishvv43r44bn2t08cf3ugs4ado8vf87a', '127.0.0.1', 1607952376, '__ci_last_regenerate|i:1607952376;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7hqdpd90u5qg4bm115brvckki6dkp9p5', '127.0.0.1', 1607952380, '__ci_last_regenerate|i:1607952380;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qji66pfdl1a9bv0c85456efnf83vgldr', '127.0.0.1', 1607952380, '__ci_last_regenerate|i:1607952380;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('v6lifuc1b45j3qcoo8fdkfjl8m1q39pk', '127.0.0.1', 1607952407, '__ci_last_regenerate|i:1607952407;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rmg853k994ivp5autgpfj9bt5vv47sc6', '127.0.0.1', 1607952440, '__ci_last_regenerate|i:1607952440;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('n8vptu4peavsm4lglsve2inlami2ihf1', '127.0.0.1', 1607952440, '__ci_last_regenerate|i:1607952440;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3s1591abs01f8a0kvp3j2k30rah1r8nh', '127.0.0.1', 1607952441, '__ci_last_regenerate|i:1607952441;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('boa11en7qkvnsoahql2hsdfp5b2psn3j', '127.0.0.1', 1607952441, '__ci_last_regenerate|i:1607952441;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4je4aef852plr5agkcar7ocenacgcuvu', '127.0.0.1', 1607952441, '__ci_last_regenerate|i:1607952441;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aejtm4okptooq98o7davso0sbttujt59', '127.0.0.1', 1607952443, '__ci_last_regenerate|i:1607952443;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ih50flae48prbcfm4o889cdtngsdmvj0', '127.0.0.1', 1607952443, '__ci_last_regenerate|i:1607952443;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ek7gu5ffbrpn948f52hpvt51atr33mrr', '127.0.0.1', 1607952463, '__ci_last_regenerate|i:1607952463;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('u82ktpco3k582h3eeqbvuip0vh10c2c0', '127.0.0.1', 1607952463, '__ci_last_regenerate|i:1607952463;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0jeie2rq8elrpp5cghod8mfrprd5of2k', '127.0.0.1', 1607952466, '__ci_last_regenerate|i:1607952466;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3mbs5sdfrbarprfmg8jn8m7jir4vtdn4', '127.0.0.1', 1607952466, '__ci_last_regenerate|i:1607952466;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qt85b2io6sgfjb6u3plilhldf9aokq10', '127.0.0.1', 1607974964, '__ci_last_regenerate|i:1607974964;active_language_id|s:1:\"1\";login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:2:\"26\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('t9rkeqcuscg8kndiccb93854tjjgp7ia', '127.0.0.1', 1607952512, '__ci_last_regenerate|i:1607952512;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ie5rdnjnq23fshsia064u43e9fja2e8e', '127.0.0.1', 1607952512, '__ci_last_regenerate|i:1607952512;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ilh9jjuau98ss7dscosn456bb0sshv16', '127.0.0.1', 1607952515, '__ci_last_regenerate|i:1607952515;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('m5etshvedoji8ppipegpnahe21s5bqks', '127.0.0.1', 1607952515, '__ci_last_regenerate|i:1607952515;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b26ct9ct5ht543lo8kidohaeafd4c5kf', '127.0.0.1', 1607974139, '__ci_last_regenerate|i:1607974139;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:2:\"28\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5fom8h85b6a8cbt2e79do262qv7heuf8', '127.0.0.1', 1607974469, '__ci_last_regenerate|i:1607974469;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"5\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('apnpdefl6s117o097cfm9d7bm0a38kts', '127.0.0.1', 1607974777, '__ci_last_regenerate|i:1607974777;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:3:\"160\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('md89m7e6tomusv70bsj69r4et8gmhcqo', '127.0.0.1', 1607976796, '__ci_last_regenerate|i:1607976796;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"4\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ku9f24v9aiqsbpopp26s1nln4n45ijgt', '127.0.0.1', 1607979481, '__ci_last_regenerate|i:1607979481;active_language_id|s:1:\"1\";login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"4\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7jaafcpvlno1jd6q2gdvrkit1or8a319', '127.0.0.1', 1607977460, '__ci_last_regenerate|i:1607977460;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rbshduf5m9cbsdnkds1lub9csir84sr7', '127.0.0.1', 1607977997, '__ci_last_regenerate|i:1607977997;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4rctqfo7ppu9t77gmelnpfeo3bkcrtrj', '127.0.0.1', 1607978018, '__ci_last_regenerate|i:1607977997;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"4\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('76srpikgh11lgqdqtngh1s91bd7fm37l', '127.0.0.1', 1608225738, '__ci_last_regenerate|i:1608225738;active_language_id|s:1:\"1\";login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"4\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6tnsrjd3rvmhsg2hibhh0pvr0f0i9rj2', '127.0.0.1', 1608032691, '__ci_last_regenerate|i:1608032691;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"5\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nqci1kqs8kccjj74oohjanuk4u7a9e7o', '127.0.0.1', 1608034895, '__ci_last_regenerate|i:1608034895;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"5\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('l6hb9969qahd108544udqpl0a0o26d73', '127.0.0.1', 1608034895, '__ci_last_regenerate|i:1608034895;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"5\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mtevk9vhvmppcva0d7vam2ocllt8tpff', '127.0.0.1', 1608038447, '__ci_last_regenerate|i:1608038447;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2df79pqvauui2gi6g3vh8dukmkdi488g', '127.0.0.1', 1608039114, '__ci_last_regenerate|i:1608039114;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bt2rm6626g4aif7esqefnne16mog0u5l', '127.0.0.1', 1608039114, '__ci_last_regenerate|i:1608039114;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('i2jeti0mf7s5rfopnoie1q0j0343r9ad', '127.0.0.1', 1608056368, '__ci_last_regenerate|i:1608056368;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cn3124r9qd2o2o7gotcjuhkntoga3t87', '127.0.0.1', 1608063634, '__ci_last_regenerate|i:1608063634;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9d4d53ol45egni4p899llam68ihrbgt2', '127.0.0.1', 1608064080, '__ci_last_regenerate|i:1608064080;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('h461tc2g6oevdko40bopp2nsa0lesrkc', '127.0.0.1', 1608066821, '__ci_last_regenerate|i:1608066821;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rq67mbd62pdvi6528m7p9em96df2ddhs', '127.0.0.1', 1608067449, '__ci_last_regenerate|i:1608067449;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('f9tf0igf9kvvi480tmrhi49r3hpc584d', '127.0.0.1', 1608125176, '__ci_last_regenerate|i:1608125176;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dv6gj6l4qvv36uqlu3tfm1v116tgd82r', '127.0.0.1', 1608125621, '__ci_last_regenerate|i:1608125621;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fvavtlhnj9krmnrclqdeol5qbekcqdis', '127.0.0.1', 1608127082, '__ci_last_regenerate|i:1608127082;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('h7uh8lo4q7rh424a394qg9iancnc79c2', '127.0.0.1', 1608130073, '__ci_last_regenerate|i:1608130073;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('60a354ldr4pfmc6u68dk8d9dr0ef6mqa', '127.0.0.1', 1608130922, '__ci_last_regenerate|i:1608130922;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('n7oih2h9kkk981d67lhto21d8mernfpv', '127.0.0.1', 1608131317, '__ci_last_regenerate|i:1608131317;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('h1mi6v4bi2gde0m33hgd7f326aq97mup', '127.0.0.1', 1608132922, '__ci_last_regenerate|i:1608132922;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:2:\"18\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8bde42jufecnnc8jkr2svdskcrbb2vog', '127.0.0.1', 1608166259, '__ci_last_regenerate|i:1608166259;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bv1uch2f3kkb3ilovc0cdunpmmq9ovo2', '127.0.0.1', 1608215127, '__ci_last_regenerate|i:1608215127;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qao6iuuv767pnqn2tq6dt23iltcsn1a0', '127.0.0.1', 1608198923, '__ci_last_regenerate|i:1608198923;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7l76cuvbfn2v8phn4greq8tmngvm0aju', '127.0.0.1', 1608198923, '__ci_last_regenerate|i:1608198923;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('02uhn8sla0stp14nmjorsj005dncofre', '127.0.0.1', 1608198925, '__ci_last_regenerate|i:1608198925;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('sjis8o4n0e0a5v6oki05r49vfnufan63', '127.0.0.1', 1608198925, '__ci_last_regenerate|i:1608198925;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('k86rtcas2j6g2f7v1hfbdi7pro6fnikv', '127.0.0.1', 1608198926, '__ci_last_regenerate|i:1608198926;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mc4c21fg5utgmghfvqnvs8plt5gjupmh', '127.0.0.1', 1608198932, '__ci_last_regenerate|i:1608198932;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('sniem1gidthf1cu7n7v5ov3m35minn22', '127.0.0.1', 1608198933, '__ci_last_regenerate|i:1608198932;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d7gs3eam02i45mn2lhgah9em50picp92', '127.0.0.1', 1608198933, '__ci_last_regenerate|i:1608198932;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('i5vecon14a49i8nb7vgp9s040db4lpv8', '127.0.0.1', 1608198933, '__ci_last_regenerate|i:1608198933;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fuaur36jph7ed07digl8fb0406o7cg3t', '127.0.0.1', 1608198933, '__ci_last_regenerate|i:1608198933;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rec9abothftg5jlkttg9qufrvhdb6e0v', '127.0.0.1', 1608198933, '__ci_last_regenerate|i:1608198933;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('se1d8rtcvg1skiovb7775fpftv7cpk5k', '127.0.0.1', 1608198946, '__ci_last_regenerate|i:1608198945;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('80uv19kd83nelp5p3v66sprfvltlpmqb', '127.0.0.1', 1608198946, '__ci_last_regenerate|i:1608198945;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('sg80633qbjegn1pf1ve8299o1iu0mehd', '127.0.0.1', 1608198946, '__ci_last_regenerate|i:1608198945;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('pkqolvm2d22omghqet1buqqiprr9goie', '127.0.0.1', 1608198959, '__ci_last_regenerate|i:1608198959;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6a285mne00mc4jirtrvrpatfqonp1m7e', '127.0.0.1', 1608198959, '__ci_last_regenerate|i:1608198959;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jj70gb3t50g48vo510q5ageoc4r957na', '127.0.0.1', 1608198962, '__ci_last_regenerate|i:1608198962;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('iao9e2r897032784i57tgif2hj94pt32', '127.0.0.1', 1608198962, '__ci_last_regenerate|i:1608198962;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('chq16qtmvt80kabtaup4pieifbclna31', '127.0.0.1', 1608198962, '__ci_last_regenerate|i:1608198962;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('authi1m2f08p3fah6mevvh8kp3kpb85l', '127.0.0.1', 1608200683, '__ci_last_regenerate|i:1608200682;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0jm68e7rqpuucm6jsi6jn6r0n6tjbpo7', '127.0.0.1', 1608207069, '__ci_last_regenerate|i:1608207068;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('320jpmpah3a7am680vupj9j5ii0gl4hj', '127.0.0.1', 1608207069, '__ci_last_regenerate|i:1608207068;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8jn1a56hv7qtd6768oahjb7hsg8g177l', '127.0.0.1', 1608207071, '__ci_last_regenerate|i:1608207071;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4cfljiafffmgt1sdi36mdo5uo196njhc', '127.0.0.1', 1608207071, '__ci_last_regenerate|i:1608207071;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8pum61je9banaodmq5ngurgt2529dge5', '127.0.0.1', 1608207071, '__ci_last_regenerate|i:1608207071;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5nvnm0c9ot18pvic2b79aeubav61mjd4', '127.0.0.1', 1608216024, '__ci_last_regenerate|i:1608216024;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"4\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jppknvfbu5sbcs9qbuv7a48s6gap8btm', '127.0.0.1', 1608225959, '__ci_last_regenerate|i:1608225959;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"4\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bh5igik26lsfvnhmoatibdqeif7b5n8d', '127.0.0.1', 1608242100, '__ci_last_regenerate|i:1608242100;active_language_id|s:1:\"1\";login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"5\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qd00vtj46msv384quvhff8a6ucgskgan', '127.0.0.1', 1608226371, '__ci_last_regenerate|i:1608226371;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:3:\"160\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nr729g7ej4vpsadfb7c0pv492rhnm5ea', '127.0.0.1', 1608226240, '__ci_last_regenerate|i:1608226240;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('o93caodjsns6ia6rnd5glfmj2ukrf2s6', '127.0.0.1', 1608240634, '__ci_last_regenerate|i:1608240634;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('hgv6cr2ece9sar8s5q1efn0q21orsn8r', '127.0.0.1', 1608226371, '__ci_last_regenerate|i:1608226371;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:3:\"160\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('j19uc1e9db7308mraedqomt4l62nr4r7', '127.0.0.1', 1608240634, '__ci_last_regenerate|i:1608240634;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('oql84q1f1m7d4k84m8p8j72qobm1v2vq', '127.0.0.1', 1608242101, '__ci_last_regenerate|i:1608242100;active_language_id|s:1:\"1\";login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"5\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cjr28n72p6aomjdgiqih1gngellfg9oj', '127.0.0.1', 1608298371, '__ci_last_regenerate|i:1608298350;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('v6gl4hctg5qqibd0qt0bflmtakq7arfd', '127.0.0.1', 1608298487, '__ci_last_regenerate|i:1608298487;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('t54foa21fgb5pfrrangt35v2r0kisibi', '127.0.0.1', 1608305545, '__ci_last_regenerate|i:1608305545;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9avo3g6b17psdern3ju5rvovh7v17d11', '127.0.0.1', 1608305549, '__ci_last_regenerate|i:1608305545;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6fitkc6l9h23dpi6u6t6broqfpbm6ppj', '127.0.0.1', 1608305702, '__ci_last_regenerate|i:1608305702;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('05g05n979mtdchk30tjpob18t9o8pifl', '178.148.134.26', 1608306181, '__ci_last_regenerate|i:1608306181;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ojjd3dbnnkl6s867v8p9s8p8ociruhg3', '86.14.119.224', 1608307013, '__ci_last_regenerate|i:1608307013;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rh3p0i46e8jhurc3rhi8mgkq7gadq0cn', '34.244.225.184', 1608305876, '__ci_last_regenerate|i:1608305876;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ghtpilbbd0b4437thj6tls07j3d7qev6', '178.148.134.26', 1608305922, '__ci_last_regenerate|i:1608305917;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ejimsvuh6mv1qc6cp92ucjih1h56s4hs', '112.135.12.183', 1608307388, '__ci_last_regenerate|i:1608307388;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('l7qdp4k4og2epesthnfmme0slnrn59js', '86.14.119.224', 1608401121, '__ci_last_regenerate|i:1608401121;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rhrs3thsi44s0orcstu65vd70j249mn2', '178.148.134.26', 1608307019, '__ci_last_regenerate|i:1608307019;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kh9rpt7ebu3o5br3jl11hfh0qs3ukbrg', '178.148.134.26', 1608306717, '__ci_last_regenerate|i:1608306717;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8gqmm3up6okv6ikvr1heav9jid62iqlq', '86.14.119.224', 1608400478, '__ci_last_regenerate|i:1608400478;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('igivrer7j03hjmr3l2105pihhg3d5dk7', '178.148.134.26', 1608307186, '__ci_last_regenerate|i:1608307019;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3bbqb51in95t1mrbsric1l3chdlqcvvb', '86.14.119.224', 1608307024, '__ci_last_regenerate|i:1608307024;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('50j38p9lfsso0g5p9nls0uoomdn77gt4', '112.135.12.183', 1608307505, '__ci_last_regenerate|i:1608307388;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('hh2q3tgsfas5inu0fhpfqoqudkh45kps', '178.148.134.26', 1608307906, '__ci_last_regenerate|i:1608307902;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nmrdbk5vi66t3u62t497208a3nb3mfkd', '34.244.225.184', 1608316012, '__ci_last_regenerate|i:1608316012;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fpst6q800usrb1j1k339g71irt6ud0ha', '127.0.0.1', 1608316021, '__ci_last_regenerate|i:1608316017;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('h449dqs6niuhjbu875m64h1kiboepqui', '112.135.12.49', 1608363232, '__ci_last_regenerate|i:1608363232;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qt9s419bcfo2239k4g472jjqfttfhkkk', '34.241.243.59', 1608362988, '__ci_last_regenerate|i:1608362988;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6scsltt46j3csi6qsudjkgporj4d3gep', '112.135.12.49', 1608363233, '__ci_last_regenerate|i:1608363232;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4h9fvn9cv10sepbkk0l0hlr13rq8cs5i', '178.148.134.26', 1608392475, '__ci_last_regenerate|i:1608392475;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('tmv33tdaciqanjitgb8op7jl9kj2j61i', '178.148.134.26', 1608391332, '__ci_last_regenerate|i:1608391332;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0791uohif7pgr7k2g7mk192c9jr1veab', '34.244.225.184', 1608391893, '__ci_last_regenerate|i:1608391893;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3p1m24unqdm1f40l07a8bpcjkfa96j4t', '178.148.134.26', 1608393421, '__ci_last_regenerate|i:1608393421;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('v2dqls6f84sh4h2idvugvipsps9ehdut', '178.148.134.26', 1608393799, '__ci_last_regenerate|i:1608393799;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:2:\"18\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9jh4drn1mtia0255k0qi1tj6kuui4eh2', '112.135.7.65', 1608393794, '__ci_last_regenerate|i:1608393794;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4iqae29tcgi08kv1f4ehlc0gksvl03qc', '65.154.226.165', 1608393522, '__ci_last_regenerate|i:1608393522;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kaeconj6316oit763q8m4l57fan51dqg', '112.135.7.65', 1608394100, '__ci_last_regenerate|i:1608394100;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5t2enc5quf05li605lf5nut3dcsdtdu2', '178.148.134.26', 1608394168, '__ci_last_regenerate|i:1608394168;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:2:\"18\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('eih10net2qpjr6dnjua1ef5fhan1gsd1', '112.135.7.65', 1608395934, '__ci_last_regenerate|i:1608395934;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fro0a7vui7u1fucu0kp54k1a3hiukugr', '178.148.134.26', 1608394561, '__ci_last_regenerate|i:1608394561;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:2:\"80\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kbps34cj0pqpab6je9ikthaf89t49q6s', '178.148.134.26', 1608413389, '__ci_last_regenerate|i:1608413389;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:2:\"30\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bcsreh8c314j9k5slb0iejtedu6td26i', '112.135.7.65', 1608396337, '__ci_last_regenerate|i:1608396337;login_error|s:31:\"Username & password not match..\";__ci_vars|a:1:{s:11:\"login_error\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jb0j19fel2su5nurj33h5td4p709q8p5', '52.114.14.102', 1608396126, '__ci_last_regenerate|i:1608396126;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9ohtiq3s4vihbrkf84214b7kopt6c61u', '178.148.134.26', 1608396183, '__ci_last_regenerate|i:1608396160;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('u8fvog51gm4tvtk7i6ind06kmgbjlbk6', '52.114.14.102', 1608396195, '__ci_last_regenerate|i:1608396195;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qmgvv3j849clcvgtdqemc5mv5qviev9i', '112.135.7.65', 1608400922, '__ci_last_regenerate|i:1608400922;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:4:\"3002\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4m8daa2t7ngllv58r2acudce18fnuo25', '89.216.20.145', 1608398607, '__ci_last_regenerate|i:1608398587;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('h7nfqrpe0kcfraaqf0r8vgsnbq5mucp5', '5.63.10.250', 1608399833, '__ci_last_regenerate|i:1608399833;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('m3m1tohjj6s20n7ov0oc7md7cq6jtqf4', '160.153.153.29', 1608399850, '__ci_last_regenerate|i:1608399850;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('l1ck9fv662ianj3kpcjclc4polvv7re4', '46.182.4.118', 1608399865, '__ci_last_regenerate|i:1608399865;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('salp94ft9idjp89t1ktl4seo0v9gur95', '132.148.104.131', 1608399882, '__ci_last_regenerate|i:1608399881;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1h6maer140cq6sjtcbgqf39t4kkbpa91', '198.71.238.23', 1608399899, '__ci_last_regenerate|i:1608399899;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9st34iq7n5t2ptgp6ru08sqlk045a2rk', '89.216.20.145', 1608400119, '__ci_last_regenerate|i:1608399955;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('sue94ls9275u7309gnsrcrv5q188irff', '184.168.193.156', 1608400014, '__ci_last_regenerate|i:1608400014;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0j426q6m782deanagdc4ht84o89c4m4o', '198.71.239.51', 1608400054, '__ci_last_regenerate|i:1608400054;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('p01q0ac0aqvfdg4equbtcqia110d4btk', '182.50.130.6', 1608400072, '__ci_last_regenerate|i:1608400072;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vs543chspags28le2as6q4brj9mmhd29', '176.223.121.235', 1608400086, '__ci_last_regenerate|i:1608400086;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('f04d01gp780l76od5tl0ol71sarukp89', '198.71.238.20', 1608400102, '__ci_last_regenerate|i:1608400102;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rfvau6p5frd0ikhbqh2bvtbs5a74av5g', '160.153.146.164', 1608400117, '__ci_last_regenerate|i:1608400117;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8ifhvbjuv09d4p4959qp35kr2hljb550', '160.153.147.36', 1608400133, '__ci_last_regenerate|i:1608400133;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6pqg4ef6iiu75hkvkujcccmjctve09oj', '198.71.239.15', 1608400151, '__ci_last_regenerate|i:1608400151;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a66v0ierp5a0dna7d1spiqg13b2pq0pb', '107.180.111.8', 1608400166, '__ci_last_regenerate|i:1608400166;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5ksl0dmss06r3qe7c7j93t47s2t6ae0t', '45.10.150.50', 1608400183, '__ci_last_regenerate|i:1608400183;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a4st7jbhapj59go4qetpvt75hlm2m31f', '160.153.153.29', 1608400198, '__ci_last_regenerate|i:1608400198;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('oivb97obdn6a4q946tv062hcms2pkjbb', '198.71.239.33', 1608400251, '__ci_last_regenerate|i:1608400251;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9irnfib66sqmoqk74p9fn2uqbf4pbidq', '50.63.92.10', 1608400278, '__ci_last_regenerate|i:1608400278;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6vns3169bt5enktmocr9m9grom42dpnu', '79.170.44.150', 1608400367, '__ci_last_regenerate|i:1608400367;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ksr067tl79thv37o3kn3g2om15i5juls', '45.40.166.2', 1608400411, '__ci_last_regenerate|i:1608400411;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('uvt8ijpr354c04p560vd7j4bbcuiv172', '173.201.196.59', 1608400427, '__ci_last_regenerate|i:1608400427;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kbetj2hpsmrd840nbfhlqkb6q4kcv438', '54.221.27.173', 1608400451, '__ci_last_regenerate|i:1608400451;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1gg66dfgtbsrfiadu0pqq0o2f655kd0e', '138.118.166.15', 1608400470, '__ci_last_regenerate|i:1608400470;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kq19977s2kbv596ugm4hae71hpg6n82a', '86.14.119.224', 1608560762, '__ci_last_regenerate|i:1608560762;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a959er94m934e56emthtk3rg5j3lo1m6', '112.135.7.65', 1608401035, '__ci_last_regenerate|i:1608400922;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:2:\"21\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('65mo523jlriaokgdnqs1f8u5ajrp5bth', '86.14.119.224', 1608545932, '__ci_last_regenerate|i:1608545932;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('hue0i68n64t7bdapi2auvg0aelorf2qk', '87.116.165.164', 1608403993, '__ci_last_regenerate|i:1608403988;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6affs2g8lin3afgdh551e8lo9hlnhsfo', '54.213.119.9', 1608412662, '__ci_last_regenerate|i:1608412662;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3c7j515csheceqip8nt3d3hliv4t9pr6', '54.191.52.173', 1608412664, '__ci_last_regenerate|i:1608412664;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('u5fcc5vks48s3qtg3rcqkoaklvv3233t', '178.148.134.26', 1608413389, '__ci_last_regenerate|i:1608413389;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:2:\"30\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kdp1ld21g8v22tjckivc2jq29se565et', '34.244.225.184', 1608413440, '__ci_last_regenerate|i:1608413440;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('k3s05psho37h8vcli6om9faeue0tpmdl', '34.222.143.74', 1608418692, '__ci_last_regenerate|i:1608418692;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('77ajfpaga577mucsde79t5km3i6k4vr5', '178.148.134.26', 1608423381, '__ci_last_regenerate|i:1608423380;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ls72p217r0gp43o9q496d6makg5d4rch', '205.169.39.25', 1608440596, '__ci_last_regenerate|i:1608440595;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('s020enbtkk5pmvpapg3rjma7n1qgk1ah', '212.83.146.233', 1608457767, '__ci_last_regenerate|i:1608457766;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cscmsq295nfhsdat70o2so6irt7mc98m', '195.154.62.232', 1608464284, '__ci_last_regenerate|i:1608464283;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('k0hubhlifegi3ijsj20g7ik1cbmi3jcm', '54.221.27.173', 1608472499, '__ci_last_regenerate|i:1608472499;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('890gph8vrdqbmune98of2stof1ve6jbd', '34.244.225.184', 1608474085, '__ci_last_regenerate|i:1608474085;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('660iqro6odpoontpl4udihi1v8oud06i', '178.148.134.26', 1608475034, '__ci_last_regenerate|i:1608475034;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:2:\"16\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cvei2pd5aj4m25i9s2lqhj18jiqlb4md', '178.148.134.26', 1608475462, '__ci_last_regenerate|i:1608475462;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";user_active_menu|s:1:\"2\";active_menu|s:1:\"5\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('q86bsjjl3iq8jtlmoma2auhjq74epeb7', '178.148.134.26', 1608475764, '__ci_last_regenerate|i:1608475764;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";user_active_menu|s:1:\"2\";active_menu|s:1:\"4\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('s81tjukhrdu47nuccvbj1btkjr8ljoe0', '178.148.134.26', 1608476338, '__ci_last_regenerate|i:1608476338;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";user_active_menu|s:1:\"2\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('t3cgflkskelcd2f42usujj1f0co4ik55', '178.148.134.26', 1608476874, '__ci_last_regenerate|i:1608476874;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";user_active_menu|s:1:\"2\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gigqbmbl69m41vjorfqonvh2pm2514j1', '178.148.134.26', 1608477380, '__ci_last_regenerate|i:1608477380;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ucsapvkqild77gr3d7kl8aq251040l6k', '178.148.134.26', 1608477388, '__ci_last_regenerate|i:1608477380;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:2:\"12\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b9ckee50oq5i6mfrba2hisp8tthmo34l', '178.148.134.26', 1608560615, '__ci_last_regenerate|i:1608560615;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dd4fqkv0aioiinpimrinar1mg1geh1ma', '89.216.20.145', 1608483372, '__ci_last_regenerate|i:1608483350;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('psd0r4qau08cfdn64en1uet4t12f8rif', '24.135.202.225', 1608483369, '__ci_last_regenerate|i:1608483354;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('lblnghbt5i2k923tr4aumo16rf2q422q', '86.14.119.224', 1608550023, '__ci_last_regenerate|i:1608550023;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('m47d97umho58a10vblto421kjjlpf2cu', '86.14.119.224', 1609782168, '__ci_last_regenerate|i:1609782168;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('367p3is18oo4j76r9ugaj6ut3k3uunes', '178.148.134.26', 1608560582, '__ci_last_regenerate|i:1608560582;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vbdgsnl33d7gc84j6jmhcuf7pss7mkm0', '127.0.0.1', 1608559579, '__ci_last_regenerate|i:1608559573;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('pvabkchl121qspkffurkqgna79ob7tgv', '112.135.0.95', 1608560327, '__ci_last_regenerate|i:1608560327;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('s3f0ukv1icll2ovbmieekfqdudt9c9e0', '178.148.134.26', 1608561164, '__ci_last_regenerate|i:1608561164;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ec9d82di7qdg8ahvgtg4iq8hetu9jasi', '86.14.119.224', 1608561246, '__ci_last_regenerate|i:1608561246;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:3:\"160\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rjuj6hhbaoq0dlcdv0b560p5gedc0cbb', '178.148.134.26', 1608582638, '__ci_last_regenerate|i:1608582638;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rdaopbm210ar8qojeakefle7u45hoj87', '178.148.134.26', 1608563589, '__ci_last_regenerate|i:1608563589;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('adhgo724h8snlu9hn97djlvde3e868au', '86.14.119.224', 1608562691, '__ci_last_regenerate|i:1608562691;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:2:\"20\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('r0n284ue0k46snevb2a6a7ihlgmknfun', '86.14.119.224', 1608564844, '__ci_last_regenerate|i:1608564844;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:3:\"350\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2tl6j2kqj9npg3q35tjo9fl8u65u1vbu', '34.240.166.114', 1608563474, '__ci_last_regenerate|i:1608563474;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vou8f3mancnv9gg9lkcfs9mnv1q27ckq', '178.148.134.26', 1608564115, '__ci_last_regenerate|i:1608564115;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gbdf3ksatk62stuimmo68bfithfb0qpn', '178.148.134.26', 1608564615, '__ci_last_regenerate|i:1608564615;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";user_active_menu|s:1:\"2\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('g9nuc23ee24u2v7tdtbs3ts7hvnkrbm2', '178.148.134.26', 1608564873, '__ci_last_regenerate|i:1608564615;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";user_active_menu|s:1:\"2\";active_menu|s:4:\"3001\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kj6h168clvbdaque52rvvcpof4md3ad0', '86.14.119.224', 1608568987, '__ci_last_regenerate|i:1608568987;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('pgc58i7e43808dh0fofdgg9lufmeldkp', '86.14.119.224', 1608841414, '__ci_last_regenerate|i:1608841414;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('so0kojdr47ouvsi5v8971sj76vl22j48', '178.148.134.26', 1608582918, '__ci_last_regenerate|i:1608582907;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jdmsmhs2oh34ggp1du5k0m5nboqe7m2c', '217.27.176.227', 1608675158, '__ci_last_regenerate|i:1608675158;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4pbj9b57il79ggl0sctvq63h5bs2f3av', '217.27.176.227', 1608675158, '__ci_last_regenerate|i:1608675158;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fvk5n2fqvvnvk9opr7t594fo66j8qlip', '217.27.176.227', 1608675159, '__ci_last_regenerate|i:1608675159;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b6855ieg60uek8ersqggpssvkbon7o6a', '217.27.176.227', 1608675159, '__ci_last_regenerate|i:1608675159;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9u0lqvbcboqg9ff4vivmpbauht4fdi09', '217.27.176.227', 1608675197, '__ci_last_regenerate|i:1608675197;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('tufeu63pj86si3iieg2md9o9vdggcb37', '217.27.176.227', 1608675197, '__ci_last_regenerate|i:1608675197;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('hbccep05a7nvemdr3t48co3srb2nkpdc', '217.27.176.227', 1608675200, '__ci_last_regenerate|i:1608675200;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('855a414b20g2mrkq71rvgvc8rt9dr7la', '217.27.176.227', 1608675200, '__ci_last_regenerate|i:1608675200;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('pof3jsdttj8bh0j2pbhe292pp18t3qhr', '217.27.176.227', 1608675216, '__ci_last_regenerate|i:1608675216;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jc6l5fk9l305qvil57c9ce413tomql59', '217.27.176.227', 1608675216, '__ci_last_regenerate|i:1608675216;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ltgk6sfvmk2lgue46gujvcjntsnunhp0', '217.27.176.227', 1608711571, '__ci_last_regenerate|i:1608711571;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jgudjq5np4q14q2349vtv45d10gc8flg', '217.27.176.227', 1608739609, '__ci_last_regenerate|i:1608739608;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('r09c9a432q19j9ntvria8ukelathfuf3', '212.200.181.99', 1608746850, '__ci_last_regenerate|i:1608746839;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('t9l9ij4d3t5d6r4mjmal6d0n06ntfnja', '212.200.181.99', 1608747727, '__ci_last_regenerate|i:1608747727;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gftsgs2nn0p64j4e63r20kjj1sk061q0', '87.116.167.114', 1608748948, '__ci_last_regenerate|i:1608748948;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4id2m2vtu69qjkgns9qpvsfapo5h689h', '178.148.134.26', 1608814070, '__ci_last_regenerate|i:1608814069;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('skuqv06fv6ho59hp4t24beh64clhcssp', '178.148.134.26', 1608842401, '__ci_last_regenerate|i:1608842401;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_language_id|s:1:\"1\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('52k812n9lmpobmu9419p8k388ivgmhji', '89.216.20.145', 1608823694, '__ci_last_regenerate|i:1608823694;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:3:\"350\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3olp74vtjt7rv3m17rkh51j0etdb09gu', '89.216.20.145', 1608823745, '__ci_last_regenerate|i:1608823694;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:2:\"15\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ndesjkn76d5a13uqisqlcj6kplhc80ik', '86.14.119.224', 1609002614, '__ci_last_regenerate|i:1609002614;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:3:\"162\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3foljrfqt10sdjcqbjjdc0bf5jvca2ih', '86.14.119.224', 1608841559, '__ci_last_regenerate|i:1608841559;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('u8q4ci6hr0f0b3tkm2p9f2pcfm5aptjg', '86.14.119.224', 1608841559, '__ci_last_regenerate|i:1608841559;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('r81evs1n06vta9coibumka5gujjcga4k', '86.14.119.224', 1608841562, '__ci_last_regenerate|i:1608841562;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1b4rem6rdt52diru6hndk01i7g9skol9', '86.14.119.224', 1608841562, '__ci_last_regenerate|i:1608841562;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('h2dr1t8ml989bjrh5eptqt7jq2088fuu', '86.14.119.224', 1608841563, '__ci_last_regenerate|i:1608841563;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jp18kn9crhc900du4ega114fq5u4eit0', '86.14.119.224', 1608841701, '__ci_last_regenerate|i:1608841701;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('27rd081pia9s81v1utgvma7idctqe9km', '86.14.119.224', 1608841701, '__ci_last_regenerate|i:1608841701;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0pr0o72glljrk3td7h9t5gpt7051k0jn', '86.14.119.224', 1608841701, '__ci_last_regenerate|i:1608841701;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('udb61tmk2uotvh3tdldf1rrrb3sf49cc', '86.14.119.224', 1608841702, '__ci_last_regenerate|i:1608841702;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2vjkh1d2sn9jk5sops02vvl0lmnkouv7', '86.14.119.224', 1608841702, '__ci_last_regenerate|i:1608841702;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('n4bonotclb8ur6f8onnb55tfik2aqbc9', '86.14.119.224', 1608841702, '__ci_last_regenerate|i:1608841702;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dvsemiib7q8po3a4gfedfi1ilrgmpme2', '86.14.119.224', 1608841723, '__ci_last_regenerate|i:1608841723;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('u5co48n1g116ejedtg9b65ebefphvs0s', '86.14.119.224', 1608841723, '__ci_last_regenerate|i:1608841723;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('97c44hnsapir6olvqsrh0dhvgh4ghq0f', '86.14.119.224', 1608841723, '__ci_last_regenerate|i:1608841723;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6gnm98fgsk9hq1691eotrc9890hs4adp', '178.148.134.26', 1608842827, '__ci_last_regenerate|i:1608842827;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_language_id|s:1:\"1\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1ufjstdm0kmjt526v5hu74qd584um4ag', '178.148.134.26', 1608843122, '__ci_last_regenerate|i:1608842827;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_language_id|s:1:\"1\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8m2rjbpq129to09mjrc1dn3qe0m8v4r3', '212.200.181.82', 1608853250, '__ci_last_regenerate|i:1608853216;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9jo9956tdmt2b6li9dt0sup2491jbd2o', '178.148.134.26', 1608862311, '__ci_last_regenerate|i:1608862311;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7hrnhhiuq4uiajhcfqo54iomg2gm2k7q', '112.135.11.160', 1608870928, '__ci_last_regenerate|i:1608870836;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:2:\"35\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0hp6vb9kkdnrhfi55oc9jn8m9dca4asd', '178.148.134.26', 1608915353, '__ci_last_regenerate|i:1608915352;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jt8b33vheumd5s9ppa6s552ftk3ffp13', '178.148.134.26', 1608915642, '__ci_last_regenerate|i:1608915642;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mcjp7k6k48v3j6crllan7gn89csussba', '209.17.96.26', 1608986669, '__ci_last_regenerate|i:1608986669;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('iprrutp1t2lin3e5u66q9bpgsco5jang', '212.227.221.145', 1608998868, '__ci_last_regenerate|i:1608998868;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rmknda14j9mjlnibtc1na0edtiro9pfv', '212.227.221.145', 1608998868, '__ci_last_regenerate|i:1608998868;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7adfe202hr3fiqrt70fiojtph88fro27', '178.148.134.26', 1609002663, '__ci_last_regenerate|i:1609002589;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dukv541sbfvmpn3tnh1q7ghp4s9oqfn3', '86.14.119.224', 1609165037, '__ci_last_regenerate|i:1609165037;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:3:\"162\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('q4jmq0cfu7jqgqajfmkodtohem60n4sa', '34.255.181.17', 1609002623, '__ci_last_regenerate|i:1609002623;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('te8ir5rq55d37mdstboj1jv46o13au3i', '112.135.8.251', 1609063222, '__ci_last_regenerate|i:1609063222;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"8\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c5ggbh9j7f4deljs3blfhd7g49d5c6rc', '52.51.213.177', 1609062654, '__ci_last_regenerate|i:1609062654;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('o8ahflnote49gkho0i1rbqj3vvad1ig1', '112.135.8.251', 1609063563, '__ci_last_regenerate|i:1609063563;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3h6t4unur04n4q4j4n23rp4n2umfbm5h', '52.114.14.102', 1609063454, '__ci_last_regenerate|i:1609063454;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ne495plkfo7e05lcc6m5efjhv3jdktji', '178.148.134.26', 1609063496, '__ci_last_regenerate|i:1609063477;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('u33fc0ho70lmjnvg3l6gk1uv21nnl83r', '112.135.8.251', 1609063563, '__ci_last_regenerate|i:1609063563;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('sqkup5fb2mujrood47l39874ouk27d3n', '52.209.127.151', 1609093858, '__ci_last_regenerate|i:1609093858;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('p0rhr85iou8qi8uq8bke4choqac36271', '178.148.134.26', 1609154304, '__ci_last_regenerate|i:1609154156;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:3:\"162\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('sqr0hn1ie6r3f1cnl74e35plvufueqmn', '52.114.77.26', 1609154216, '__ci_last_regenerate|i:1609154216;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('74vcisvpaqp2dsdsfa6cs8c7ntshobks', '86.14.119.224', 1610056533, '__ci_last_regenerate|i:1610056533;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('04ds1sg32g8ev2cpd98punsor8fbjnk7', '86.14.119.224', 1610168988, '__ci_last_regenerate|i:1610168988;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:3:\"162\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('t47lutdfhpkqvv4ldvimddndgk3hdtov', '87.116.164.20', 1609179331, '__ci_last_regenerate|i:1609179323;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('h016vcslccrd22uovhiuqbtbac0lnmj0', '164.132.48.179', 1609269359, '__ci_last_regenerate|i:1609269359;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('35hikk1a7ok7dcut9ic6dr9nq434255h', '209.17.96.226', 1609372935, '__ci_last_regenerate|i:1609372934;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ho58kbdot03bbqbo2ffvqaqjdp3gu28e', '104.131.99.170', 1609397013, '__ci_last_regenerate|i:1609397013;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d5cpv08v8ddnef88fnb8c67c3cs47jcj', '212.200.181.41', 1609614483, '__ci_last_regenerate|i:1609614463;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('r58klvdt1dgcfigdaae6enpa8021m4bu', '62.240.28.165', 1609636853, '__ci_last_regenerate|i:1609636853;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3lule33enhvg8e1tdr3g50uq3lv72ui2', '209.17.97.34', 1609671720, '__ci_last_regenerate|i:1609671720;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ac1errnekkd42s9vh27rl41dbb5sruh0', '209.17.97.18', 1609748462, '__ci_last_regenerate|i:1609748462;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4nooeubb30t6ev8sbej7m0j273tepgcb', '81.152.234.147', 1609782424, '__ci_last_regenerate|i:1609782168;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cs8m3q4n7uj9pj1jvcrj3ujpu4gt6tq6', '209.17.96.250', 1609833103, '__ci_last_regenerate|i:1609833103;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0v4shlbmlkt9ug3528kkjgmrvql046v2', '134.122.6.239', 1609925562, '__ci_last_regenerate|i:1609925562;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('lud496kprifi563ejhceqclv90h27ghs', '178.148.134.26', 1609958713, '__ci_last_regenerate|i:1609958713;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";user_active_menu|s:1:\"2\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6v8j50sj8hgai6hrigdaeo592iuifvtm', '178.148.134.26', 1609958782, '__ci_last_regenerate|i:1609958713;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";user_active_menu|s:1:\"2\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('q82htanop7n6biqb2jm08qdntb1msjfu', '178.148.134.26', 1610041652, '__ci_last_regenerate|i:1610041651;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('i7eg7lamqachmbt4egg6c6dsc70ra9f5', '35.164.240.26', 1610041717, '__ci_last_regenerate|i:1610041716;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qbum67inu3hqbsrm3bmmtlmf6cgeed6f', '35.164.240.26', 1610041718, '__ci_last_regenerate|i:1610041718;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('m9huiacjs37s6ri6fn95qvmv9p9gr1gj', '54.187.3.82', 1610041719, '__ci_last_regenerate|i:1610041719;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fguh7bf8od8fu64fpnk0msgje9ghpjd5', '212.200.65.187', 1610050414, '__ci_last_regenerate|i:1610050392;login_error|s:31:\"Username & password not match..\";__ci_vars|a:1:{s:11:\"login_error\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('konen0ohqqagacmofphe7knbpqb2q6fi', '81.152.234.147', 1610056936, '__ci_last_regenerate|i:1610056936;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:3:\"301\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('av03e3j2rkac7onb17c40vh3o9dr9l9d', '178.148.134.26', 1610056845, '__ci_last_regenerate|i:1610056672;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:3:\"301\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gmsc6f268u2vgia051e5o8i58vbfm1iu', '81.152.234.147', 1610058453, '__ci_last_regenerate|i:1610058453;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cdrcp0hap9bio1bl23uivjkdd04csd2b', '81.152.234.147', 1610066645, '__ci_last_regenerate|i:1610066645;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('pomfe073qfpm18srl01kmokvvj3u062s', '178.148.134.26', 1610064653, '__ci_last_regenerate|i:1610064653;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jfnpu4qhcpsq34kcgobthi78ilb2e2gv', '178.148.134.26', 1610064655, '__ci_last_regenerate|i:1610064655;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('da51btgt94lgirtvsake16pf3hnv55r3', '178.148.134.26', 1610064655, '__ci_last_regenerate|i:1610064655;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('74c3il9q71e1m3lkirk07d4a1kkd5nrn', '178.148.134.26', 1610064656, '__ci_last_regenerate|i:1610064655;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('p4qrg45jqq4pdtdmqc4ua9q2rsqn93cv', '81.152.234.147', 1610352085, '__ci_last_regenerate|i:1610352085;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kk2usn20rok8krnts5j41lvjvcb0pgbc', '54.191.77.220', 1610142231, '__ci_last_regenerate|i:1610142231;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('uacts4a71cq2km8vh3ut57vo34qjor09', '54.191.151.117', 1610142232, '__ci_last_regenerate|i:1610142232;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1r16rk5jthfrsfu73qk16iahvvh6dcd0', '34.221.133.41', 1610151169, '__ci_last_regenerate|i:1610151169;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('u4v5dik0lk9uf1l31mrugiq9jpkc2pfg', '51.158.66.83', 1610162199, '__ci_last_regenerate|i:1610162199;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gv1om1mvnu5r2sovmnjtabphvgdpeqon', '86.14.119.224', 1610168988, '__ci_last_regenerate|i:1610168988;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:3:\"162\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('pu22k7k77ln0lkh795p6reujblrcsthe', '3.250.126.136', 1610200758, '__ci_last_regenerate|i:1610200758;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ng0b372a6h65ttj09l5l2a34ogire4j2', '178.148.134.26', 1610200875, '__ci_last_regenerate|i:1610200761;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ofe0tj2krasmunn4o8r6bpf15laiffao', '52.38.22.56', 1610268181, '__ci_last_regenerate|i:1610268181;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('k5eh1gkp3uevub219bpufsudvpb3cg76', '54.187.3.82', 1610268183, '__ci_last_regenerate|i:1610268183;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('u233pric7ndtr229hujbqik9refggsf0', '54.202.186.189', 1610268184, '__ci_last_regenerate|i:1610268184;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9e9k1tlti88omqosq572257pulibrtrg', '209.17.96.18', 1610275949, '__ci_last_regenerate|i:1610275949;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c8qngsv3ec70rp1f87feftrdf127q9le', '110.235.233.137', 1610311063, '__ci_last_regenerate|i:1610311063;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8b7g26v5p9bmoq48e1vlug084uqb4i2l', '110.235.233.137', 1610311389, '__ci_last_regenerate|i:1610311384;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gmbv1hkpodrca4alh8u8k2h70pf7anit', '52.38.22.56', 1610319618, '__ci_last_regenerate|i:1610319618;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nqbfs80ma9p1iarm8gdsjct5m1lampdi', '54.202.186.189', 1610319620, '__ci_last_regenerate|i:1610319619;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('u0hklv30ipfcm0j4r3ms3c6cff6m3353', '81.152.234.147', 1610352508, '__ci_last_regenerate|i:1610352508;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('f2m2motuv50ssq631qkl1b9m5e657479', '110.235.233.137', 1610352509, '__ci_last_regenerate|i:1610352509;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jibe5ietku2kpj2s3lir7ivj0gtnk9gu', '81.152.234.147', 1610360197, '__ci_last_regenerate|i:1610360197;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('hh9co9mood0ulq4suutporbj0v5f8lp7', '110.235.233.137', 1610352510, '__ci_last_regenerate|i:1610352509;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cqln7msjus7migbvujelra4glaumb7b3', '81.152.234.147', 1610530481, '__ci_last_regenerate|i:1610530481;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3drpnpj4e5hu7e9600c5hrv8j9qbnnod', '110.235.233.137', 1610366983, '__ci_last_regenerate|i:1610366983;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"8\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('k96qpl388u2ul2a4k16ifs2jd9cav5du', '110.235.233.137', 1610366983, '__ci_last_regenerate|i:1610366983;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ufa6rccddmg8ainbo6r15t00luseg1nb', '86.14.119.224', 1610374858, '__ci_last_regenerate|i:1610374858;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('358t3bpnpa2hkj3erdc4l52uq2qf5iri', '86.14.119.224', 1610374858, '__ci_last_regenerate|i:1610374858;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('hi21mq48fgqpkuphm1sue31nf6op0881', '86.14.119.224', 1610374860, '__ci_last_regenerate|i:1610374860;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6aun2kmeaioo82ergrng9f6hov8lnprk', '86.14.119.224', 1610374860, '__ci_last_regenerate|i:1610374860;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('umkf09p30uae0nr4u67gnjaet6d639fo', '86.14.119.224', 1610374860, '__ci_last_regenerate|i:1610374860;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ujp2m3b0d89494nbrb0d1d2iahf4hpdn', '86.14.119.224', 1610375264, '__ci_last_regenerate|i:1610375264;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('o3jrb74qnrdnkumdhmqinjnklsdk083g', '86.14.119.224', 1610375264, '__ci_last_regenerate|i:1610375264;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mimlmlqim8v2jlohaf7dhai5apqp4v7k', '86.14.119.224', 1610375264, '__ci_last_regenerate|i:1610375264;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('re5ik96u607mh0tedp86jffca4bm00u7', '86.14.119.224', 1610375264, '__ci_last_regenerate|i:1610375264;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2b8rbp70rrtki9fih7g4fr85je5rt84h', '86.14.119.224', 1610375264, '__ci_last_regenerate|i:1610375264;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('89hur5nqcv8mpf6cudlt27imb2vd4qsl', '86.14.119.224', 1610375264, '__ci_last_regenerate|i:1610375264;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('daqtpfru8lvouq6av2hqr11pcapkqhsc', '3.250.230.47', 1610386620, '__ci_last_regenerate|i:1610386620;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7051gqkblf9ok5jenjajcmi8bbmi3jej', '54.184.18.91', 1610458029, '__ci_last_regenerate|i:1610458029;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2tkcvv9vtj88lc01g3hn23hf3jga64r0', '52.38.22.56', 1610458030, '__ci_last_regenerate|i:1610458030;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('puhe4h377sq7s8hhgh53dhhqt9vnsp8i', '54.187.248.191', 1610458031, '__ci_last_regenerate|i:1610458031;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ls773v7f1sp8le8n7v2a5eq1dhm5mjvk', '110.235.233.40', 1610462986, '__ci_last_regenerate|i:1610462960;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7nfvrh846u31uvgs3mh7711694setjdf', '209.17.97.26', 1610474891, '__ci_last_regenerate|i:1610474891;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7qcfr08jmavko7ribrmftt4hehit1b1r', '81.152.234.147', 1610654583, '__ci_last_regenerate|i:1610654583;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6balv5hlb83151pvcb13o5h377bsjurb', '209.17.96.42', 1610598059, '__ci_last_regenerate|i:1610598059;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('uh6rm3mvg020d25polvb6e1f4f6e3a62', '110.235.233.40', 1610609231, '__ci_last_regenerate|i:1610609207;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:2:\"25\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('g31pbhd0uh9muqmqrrgp1r0ja7c70l9m', '110.235.233.40', 1610623890, '__ci_last_regenerate|i:1610623890;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:2:\"25\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gcagg86ho8fqq6rpivein9fs2sq9hdrf', '110.235.233.40', 1610624129, '__ci_last_regenerate|i:1610623890;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"6\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bog0smh6mkqob9svkfc3ldo3v81damns', '110.235.233.40', 1610625843, '__ci_last_regenerate|i:1610625843;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"6\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cg4aoe4qgs56m5b1b8lnkmugolp41qhm', '110.235.233.40', 1610626693, '__ci_last_regenerate|i:1610626693;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"6\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ld1qmjllil22vi7qc4npa6sti50m4jg6', '110.235.233.40', 1610630147, '__ci_last_regenerate|i:1610630147;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"8\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('23ul0dhqv0np72ulk3s75vf3hr3dfvn4', '110.235.233.40', 1610630457, '__ci_last_regenerate|i:1610630457;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"6\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0fa0hd756t67st33ct684emq46ack4ls', '110.235.233.40', 1610630497, '__ci_last_regenerate|i:1610630457;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"8\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('uk0av8rh5eo0af799ea9mhtaflt6i9vg', '81.152.234.147', 1610654583, '__ci_last_regenerate|i:1610654583;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('eimi7o0mjb5mjrm48o1v380hin1h0t2c', '110.235.233.40', 1610656488, '__ci_last_regenerate|i:1610656488;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"8\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7p0kd1e1g0mju54usu8s9e5ubbg6881o', '110.235.233.40', 1610657096, '__ci_last_regenerate|i:1610657096;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"6\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6kia15rd2r00aa9g0cltimsccn9p5ogk', '110.235.233.40', 1610657579, '__ci_last_regenerate|i:1610657579;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"6\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('lv7fd791oodrmhnsbno18hkeapmgrdv6', '110.235.233.40', 1610657964, '__ci_last_regenerate|i:1610657964;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"6\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('19f7muum51090nl6npahqre30j3f0r2n', '110.235.233.40', 1610658493, '__ci_last_regenerate|i:1610658493;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"8\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d6rimu01mqptrm9ir8ci4h9vomeh19rp', '110.235.233.40', 1610658817, '__ci_last_regenerate|i:1610658817;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";success|s:20:\"Successfully Added..\";__ci_vars|a:1:{s:7:\"success\";s:3:\"old\";}active_menu|s:1:\"8\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('oipnchru7oto5s0cd8qc9dbjvmqorq8j', '110.235.233.40', 1610659156, '__ci_last_regenerate|i:1610659156;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"8\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fm8al4urrqmhojmmaniefeikn827e1bp', '110.235.233.40', 1610659800, '__ci_last_regenerate|i:1610659800;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"6\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('54v2djn9u3q0s27nul8v4ot85ie3s2cp', '110.235.233.40', 1610660101, '__ci_last_regenerate|i:1610660101;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"3\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qi1jn3mn0gv4raqg8o0ig0jmtlnpjlpb', '110.235.233.40', 1610660407, '__ci_last_regenerate|i:1610660407;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";success|s:20:\"Successfully Added..\";__ci_vars|a:1:{s:7:\"success\";s:3:\"old\";}active_menu|s:1:\"8\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('43jfbd4madd2g58ccgt9kp40mliiu9ff', '110.235.233.40', 1610661112, '__ci_last_regenerate|i:1610661112;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"6\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nhb790qpe5i8bna247knba46ef8bunef', '110.235.233.40', 1610661911, '__ci_last_regenerate|i:1610661911;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"6\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3h01n1jvaog0qo15pfod3rirok1kpk0h', '110.235.233.40', 1610662485, '__ci_last_regenerate|i:1610662485;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"6\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('76ijou8hsp4q0c7jg9pka19npsianr1c', '110.235.233.40', 1610662758, '__ci_last_regenerate|i:1610662485;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"8\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1skst1b9urjn13q67vnrp644456afdii', '51.158.109.3', 1610687601, '__ci_last_regenerate|i:1610687601;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ahlp233ilfdr9gccajrgvsit31ml30j0', '209.17.97.106', 1610702233, '__ci_last_regenerate|i:1610702233;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ju9bnkv0510cdi5c6t8cuugmlfkchqk2', '34.220.2.205', 1610710612, '__ci_last_regenerate|i:1610710612;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a6us7udpjbfs8q9m0u4d9g1u9e9993am', '18.236.162.84', 1610710613, '__ci_last_regenerate|i:1610710613;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jp18v1s9fgns495ddfbs45ajiblsmdft', '34.222.143.74', 1610710614, '__ci_last_regenerate|i:1610710614;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jtrn9u6t5bqi5592630ic396qmqqh9h0', '110.235.233.40', 1610788832, '__ci_last_regenerate|i:1610788832;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gjvg5co5qnuvbgtjobf418qj3kgm8kus', '110.235.233.40', 1610791066, '__ci_last_regenerate|i:1610791066;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:2:\"30\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fi2rsjog6rvq7roqtls7lobqihhoog64', '110.235.233.40', 1610793297, '__ci_last_regenerate|i:1610793297;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";success|s:22:\"Successfully Updated..\";__ci_vars|a:1:{s:7:\"success\";s:3:\"old\";}active_menu|s:2:\"30\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aosgdgaoc45735f911ac9tvbtj0jojcs', '110.235.233.40', 1610793298, '__ci_last_regenerate|i:1610793297;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";success|s:22:\"Successfully Updated..\";__ci_vars|a:1:{s:7:\"success\";s:3:\"old\";}active_menu|s:2:\"30\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('13i4ckvfmsgsldd5kngvhm1bdfmqk10v', '34.253.46.5', 1610798237, '__ci_last_regenerate|i:1610798237;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bglmpgfm6j75lqp4egej5omnb4ev1kij', '95.180.86.91', 1610798273, '__ci_last_regenerate|i:1610798243;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c5estocgshr1lco6fqgef1susodraio7', '127.0.0.1', 1610799621, '__ci_last_regenerate|i:1610799619;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('tug48p6hu9t8tvbr6l767dop8griqjh0', '95.180.86.91', 1610800739, '__ci_last_regenerate|i:1610800610;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:3:\"179\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('p2qeoqhcnahk67s4llfp0eq0lmkhf7dl', '34.253.46.5', 1610804858, '__ci_last_regenerate|i:1610804858;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('msevtjj2fv7j997h8q9u3ccbjclpk1l4', '110.235.233.40', 1610822533, '__ci_last_regenerate|i:1610822533;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:2:\"30\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kg99s0p7p7c465r9uk4tmf1nk7arhki1', '110.235.233.40', 1610823014, '__ci_last_regenerate|i:1610823014;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";success|s:27:\"Episode Added Successfully.\";__ci_vars|a:1:{s:7:\"success\";s:3:\"old\";}active_menu|s:2:\"30\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('g6meposb0t7slqkep59h03b94ci2btga', '110.235.233.40', 1610823014, '__ci_last_regenerate|i:1610823014;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";success|s:22:\"Successfully Updated..\";__ci_vars|a:1:{s:7:\"success\";s:3:\"old\";}active_menu|s:2:\"30\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a1d0e1gbfruh57bqaqm018pjikj8l37f', '3.26.48.118', 1610833012, '__ci_last_regenerate|i:1610833012;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7qsklv8poucv5711q8dnd7hfk4q4b9v8', '112.135.3.184', 1610894644, '__ci_last_regenerate|i:1610894549;login_status|s:1:\"1\";user_id|s:1:\"1\";name|s:17:\"Lazar Andjelkovic\";admin_is_login|s:1:\"1\";login_type|s:5:\"admin\";active_menu|s:2:\"23\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8itokecphi0oc509t0c2f4afot4rfkk7', '112.135.3.184', 1610894563, '__ci_last_regenerate|i:1610894563;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3co4khbsplnci4bn2u5o2pk70k86j0bk', '175.157.40.143', 1610894582, '__ci_last_regenerate|i:1610894582;');


#
# TABLE STRUCTURE FOR: comments
#

DROP TABLE IF EXISTS `comments`;

CREATE TABLE `comments` (
  `comments_id` int(20) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) NOT NULL,
  `video_id` int(20) NOT NULL,
  `comment_type` int(5) NOT NULL DEFAULT 1,
  `replay_for` int(10) DEFAULT 0,
  `comment` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `comment_at` datetime DEFAULT NULL,
  `publication` int(5) DEFAULT 0,
  PRIMARY KEY (`comments_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

#
# TABLE STRUCTURE FOR: config
#

DROP TABLE IF EXISTS `config`;

CREATE TABLE `config` (
  `config_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`config_id`)
) ENGINE=MyISAM AUTO_INCREMENT=233 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (1, 'system_name', 'OVOO - Live TV & Movie Portal CMS with Unlimited TV-Series');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (2, 'site_name', 'ayozat.com');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (3, 'author', 'Jone Doe');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (4, 'business_address', 'Alpha House, 9 Tipton St, Dudley DY3 1HE');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (5, 'business_phone', '');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (6, 'contact_email', 'noreply@ayozat.com');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (7, 'system_email', 'system@ayozat.com');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (8, 'system_short_name', 'OVOO');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (9, 'social_share_enable', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (10, 'default_color', '#00CC6A');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (11, 'front_end_theme', 'red');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (12, 'seo_title', '');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (13, 'focus_keyword', '');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (14, 'meta_description', '');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (15, 'blog_enable', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (16, 'blog_title', '');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (17, 'blog_keyword', '');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (18, 'blog_meta_description', '');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (19, 'home_page_seo_title', '');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (20, 'language', 'english');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (21, 'site_url', 'https://ayozat.com/');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (22, 'total_movie_in_slider', '5');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (23, 'footer1_title', 'About');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (24, 'footer1_content', '<p><br></p>');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (25, 'footer2_title', 'Useful Link');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (26, 'footer2_content', '<p><br></p>');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (27, 'footer3_title', 'Useful Link');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (28, 'footer3_content', '<p><br></p>');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (29, 'copyright_text', 'Copyright 2020 <a href=\"#\">Ayozat.com</a>');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (30, 'slider_type', 'image');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (31, 'slide_per_page', '8');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (32, 'protocol', 'smtp');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (33, 'mailpath', '/usr/bin/sendmail');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (34, 'smtp_host', 'smtp.ionos.co.uk');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (35, 'smtp_user', 'noreply@ayozat.com');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (36, 'smtp_pass', 'xxxxxxxxxxxx');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (37, 'smtp_port', '587');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (38, 'smtp_crypto', 'tls');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (39, 'facebook_url', '#');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (40, 'twitter_url', '#');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (41, 'vimeo_url', '#');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (42, 'linkedin_url', '#');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (43, 'youtube_url', '#');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (44, 'google_analytics_id', 'UA-00000000-1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (45, 'about_us_enable', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (46, 'about_us_title', 'about');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (47, 'about_us_text', 'about us');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (48, 'about_us_to_primary_menu', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (49, 'about_us_to_footer_menu', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (50, 'facebook_comment_appid', '0000');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (51, 'comments_method', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (52, 'comments_approval', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (53, 'ad_160x600_code', '');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (54, 'ad_160x600_type', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (55, 'ad_160x600_image_url', '');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (56, 'ad_250x300_type', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (57, 'ad_250x300_image_url', '');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (58, 'ad_250x300_code', '');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (59, 'ad_160x600_url', '');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (60, 'ad_250x300_url', '#');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (61, 'map_api', 'xxxxxxxxxxxxxxxxxxxxxxx');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (62, 'map_lat', 'xxxxxxxxxxxxxxxx');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (63, 'map_lng', 'xxxxxxxxxxxxxxxxxxxx');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (64, 'movie_per_page', '18');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (65, 'google_application_name', 'Connect With Ovoo');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (66, 'google_client_id', 'xxxxxxxxxxxxxxxxxxxx');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (67, 'google_client_secret', 'xxxxxxxxxxxxxxxxxxxxxxx');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (68, 'google_redirect_uri', 'https://google.com/');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (69, 'google_api_key', '');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (70, 'google_login_enable', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (71, 'facebook_app_id', 'xxxxxxxxxxxxxxxxxxxx');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (72, 'facebook_app_secret', 'xxxxxxxxxxxxxxxxxxxxxxxxxxxxx');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (73, 'facebook_graph_version', 'v2.10');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (74, 'google_login_enable', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (75, 'facebook_login_enable', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (76, 'tv_series_publish', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (77, 'tv_series_title', 'Tv-Series Page SEO Title');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (78, 'tv_series_keyword', '');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (79, 'tv_series_meta_description', '                                                                                          ');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (80, 'tv_series_pin_primary_menu', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (81, 'tv_series_pin_footer_menu', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (82, 'purchase_code', '060df522-cdef-41bb-8466-0dbd80ccdf32');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (83, 'header_templete', 'header2');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (84, 'footer_templete', 'footer1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (85, 'dark_theme', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (86, 'player_color_skin', 'red');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (87, 'player_watermark', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (88, 'player_watermark_logo', 'uploads/watermark_logo.gif');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (89, 'player_watermark_url', '#');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (90, 'player_share', '');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (91, 'player_share_fb_id', '35345');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (92, 'player_seek_button', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (95, 'player_volume_remember', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (93, 'player_seek_forward', '10');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (94, 'player_seek_back', '5');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (98, 'live_tv_publish', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (99, 'live_tv_title', 'Latest TV Page SEO Title');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (100, 'live_tv_keyword', '');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (101, 'live_tv_meta_description', '                                                                                          ');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (102, 'live_tv_pin_primary_menu', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (103, 'live_tv_pin_footer_menu', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (104, 'registration_enable', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (105, 'frontend_login_enable', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (106, 'push_notification_enable', '');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (107, 'onesignal_appid', 'xxxxxxxxxxxxxxx');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (108, 'onesignal_actionmessage', 'We\\\'d like to show you notifications for the latest news.');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (109, 'onesignal_acceptbuttontext', 'ALLOW');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (110, 'onesignal_cancelbuttontext', 'NO THANKS');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (111, 'onesignal_api_keys', 'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (112, 'landing_page_enable', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (113, 'landing_page_image_url', 'landing_page/bg.jpg');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (142, 'mobile_apps_api_secret_key', 'ca6e1dcdc6a190d');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (115, 'country_to_primary_menu', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (116, 'genre_to_primary_menu', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (117, 'release_to_primary_menu', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (118, 'show_star_image', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (119, 'movie_page_seo_title', 'Movie Page SEO Title');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (120, 'movie_page_focus_keyword', '');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (121, 'movie_page_meta_description', '');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (128, 'dmca_policy_content', 'privacy_policy_content');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (122, 'privacy_policy_content', '');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (123, 'privacy_policy_to_primary_menu', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (124, 'privacy_policy_to_footer_menu', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (125, 'disclaimer_text', '');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (126, 'disclaimer_text_enable', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (127, 'movie_report_enable', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (129, 'dmca_to_primary_menu', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (130, 'dmca_to_footer_menu', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (131, 'dmca_content', '');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (132, 'contact_to_primary_menu', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (133, 'contact_to_footer_menu', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (134, 'movie_report_note', 'Please help us to describe the issue so we can fix it asap. \r\nNote: This feature used to report the issue for the current movie, not used for requesting new subtitle/audio in another language');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (135, 'movie_report_email', 'contact@mydomain.com');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (136, 'movie_request_enable', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (137, 'movie_request_email', 'contact@mydomain.com');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (138, 'envato_support_untill', '2019-01-01');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (139, 'cron_key', '7f1d24e9c56b093');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (140, 'db_backup', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (141, 'backup_schedule', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (143, 'version', '3.2.7');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (144, 'preroll_ads_enable', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (145, 'preroll_ads_video', 'https://sample-videos.com/video123/mp4/720/big_buck_bunny_720p_20mb.mp4');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (146, 'admob_ads_enable', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (147, 'admob_app_id', 'ca-app-pub-xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxe');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (148, 'admob_banner_ads_id', 'ca-app-pub-xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (149, 'admob_interstitial_ads_id', 'ca-app-pub-xxxxxxxxxxxxxxxxxxx/xxxxxxxxxxxxxx');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (150, 'admob_publisher_id', 'pub-xxxxxxxxxxxxxxxxxxe');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (151, 'recaptcha_site_key', 'xxxxxxxxxxxxxxxxxxx');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (152, 'recaptcha_secret_key', 'xxxxxxxxxxxxxxxxxxxx');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (153, 'az_to_primary_menu', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (154, 'az_to_footer_menu', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (155, 'recaptcha_enable', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (156, 'active_theme', 'default');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (157, 'active_language_id', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (158, 'disqus_short_name', 'ovoo');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (159, 'trial_enable', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (160, 'trial_period', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (171, 'tmdb_language', 'en');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (172, 'default_quality', 'HD');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (173, 'app_menu', 'grid');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (174, 'app_program_guide_enable', 'true');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (175, 'app_mandatory_login', 'true');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (176, 'genre_visible', 'true');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (177, 'country_visible', 'true');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (178, 'timezone', 'Asia/Dhaka');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (179, 'season_order', 'DESC');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (180, 'episode_order', 'DESC');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (181, 'video_source', 'mp4');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (182, 'video_file_order', 'DESC');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (183, 'tmbd_api_key', 'xxxxxxxxxxxxxxxxxxxx');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (193, 'slider_border_radius', '10');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (192, 'slider_height', '600');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (190, 'slider_arrow', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (191, 'slider_bullet', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (189, 'slider_fullwide', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (194, 'logo', 'logo.png');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (196, 'favicon', 'favicon_5fde251a17298.png');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (197, 'landing_bg', 'landing_page/bg.jpg');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (199, 'trial_enable', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (200, 'trial_period', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (201, 'paypal_email', 'paypal@domain.com');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (202, 'currency_symbol', '$');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (203, 'stripe_publishable_key', 'xxxxxxxxxxxxxxxxxxxxxxxxxxx');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (204, 'stripe_secret_key', 'xxxxxxxxxxxxxxxxxxxxxxxxxxx');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (205, 'currency', 'USD');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (206, 'paypal_client_id', 'xxxxxxxxxxxxxxxxxxxx');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (207, 'exchange_rate_update_by_cron', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (208, 'enable_ribbon', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (209, 'mobile_ads_enable', '0');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (210, 'mobile_ads_network', 'admob');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (211, 'fan_native_ads_placement_id', 'xxxxxxxxxxxxxxxxxxxx');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (212, 'fan_banner_ads_placement_id', 'xxxxxxxxxxxxxxxxxxxxxxx');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (213, 'fan_Interstitial_ads_placement_id', 'xxxxxxxxxxxxxxxxxxxxxx');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (214, 'startapp_app_id', 'xxxxxxxxxxx');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (218, 'apk_version_code', '15');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (219, 'apk_version_name', 'v1.2.8');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (220, 'apk_whats_new', 'New UI\r\nDownload option\r\nAdvanced Search\r\nSubscription');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (221, 'latest_apk_url', 'http://oxoo.spagreen.net/demo/oxoo-v121.apk');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (222, 'apk_update_is_skipable', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (223, 'razorpay_key_id', 'xxxxxxxxxxx');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (224, 'razorpay_key_secret', 'xxxxxxxxxxxx');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (225, 'paypal_enable', 'true');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (226, 'stripe_enable', 'true');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (227, 'razorpay_enable', 'true');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (228, 'razorpay_inr_exchange_rate', '1');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (229, 'admob_native_ads_id', 'xxxxxxxxxxx');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (230, 'offline_payment_enable', 'false');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (231, 'offline_payment_title', 'Offline Payment');
INSERT INTO `config` (`config_id`, `title`, `value`) VALUES (232, 'offline_payment_instruction', 'Offline payment instruction goes here.');


#
# TABLE STRUCTURE FOR: country
#

DROP TABLE IF EXISTS `country`;

CREATE TABLE `country` (
  `country_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `description` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `slug` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `publication` int(2) NOT NULL,
  PRIMARY KEY (`country_id`)
) ENGINE=InnoDB AUTO_INCREMENT=88 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (1, 'International', '', 'international', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (2, 'Asia', '', 'asia', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (3, 'USA', '', 'usa', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (4, 'China', '', 'china', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (5, 'Japan', '', 'japan', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (6, 'Korean', '', 'korean', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (7, 'Nepal', '', 'nepal', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (8, 'Thailand', '', 'thailand', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (9, 'Tamil', '', 'tamil', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (10, 'India', '', 'india', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (11, 'France', '', 'france', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (12, 'Italy', '', 'italy', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (13, 'German', '', 'german', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (14, 'London', '', 'london', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (15, 'Canada', '', 'canada', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (16, 'Denmark', '', 'denmark', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (17, 'UK', '', 'uk', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (18, 'Hong kong', '', 'hong-kong', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (19, 'UAE', '', 'uae', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (20, 'Australia', '', 'australia', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (21, 'South Korea', '', 'south-korea', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (22, 'Russia', '', 'russia', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (23, ' Sweden', '', 'sweden', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (24, 'Spain', '', 'spain', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (25, 'Brazil', '', 'brazil', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (26, 'Iran', '', 'iran', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (27, 'Israel', '', 'israel', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (28, 'Indonesia', '', 'indonesia', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (29, 'Philippines', '', 'philippines', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (30, ' Peru', ' Peru', 'peru', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (31, ' Canada', ' Canada', 'canada', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (32, ' Japan', ' Japan', 'japan', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (33, ' USA', ' USA', 'usa', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (34, ' Hong Kong', ' Hong Kong', 'hong-kong', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (35, ' Mexico', ' Mexico', 'mexico', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (36, ' New Zealand', ' New Zealand', 'new-zealand', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (37, ' UK', ' UK', 'uk', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (38, ' Denmark', ' Denmark', 'denmark', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (39, ' Australia', ' Australia', 'australia', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (40, ' Germany', ' Germany', 'germany', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (41, ' Hungary', ' Hungary', 'hungary', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (42, ' India', ' India', 'india', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (43, 'Hungary', 'Hungary', 'hungary', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (44, ' France', ' France', 'france', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (45, ' China', ' China', 'china', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (46, 'Chile', 'Chile', 'chile', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (47, ' Argentina', ' Argentina', 'argentina', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (48, 'Egypt', 'Egypt', 'egypt', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (49, 'New Zealand', 'New Zealand', 'new-zealand', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (50, 'Croatia', 'Croatia', 'croatia', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (51, ' Switzerland', ' Switzerland', 'switzerland', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (52, ' Tunisia', ' Tunisia', 'tunisia', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (53, 'Belgium', 'Belgium', 'belgium', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (68, 'United States of America', 'United States of America', 'united-states-of-america', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (69, 'Bangladesh', 'Bangladesh', 'bangladesh', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (70, 'United Kingdom', 'United Kingdom', 'united-kingdom', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (71, 'Malaysia', 'Malaysia', 'malaysia', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (72, 'South Africa', 'South Africa', 'south-africa', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (73, 'Switzerland', 'Switzerland', 'switzerland', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (74, 'Germany', 'Germany', 'germany', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (75, 'Sweden', 'Sweden', 'sweden', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (76, 'Bulgaria', 'Bulgaria', 'bulgaria', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (77, 'Soviet Union', 'Soviet Union', 'soviet-union', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (78, 'Netherlands', 'Netherlands', 'netherlands', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (80, 'Malta', 'Malta', 'malta', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (81, 'Taiwan', 'Taiwan', 'taiwan', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (82, 'Argentina', 'Argentina', 'argentina', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (83, 'Iceland', 'Iceland', 'iceland', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (84, 'CA', 'CA', 'ca', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (85, 'JP', 'JP', 'jp', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (86, 'US', 'US', 'us', 1);
INSERT INTO `country` (`country_id`, `name`, `description`, `slug`, `publication`) VALUES (87, 'GB', 'GB', 'gb', 1);


#
# TABLE STRUCTURE FOR: cron
#

DROP TABLE IF EXISTS `cron`;

CREATE TABLE `cron` (
  `cron_id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `image_url` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `save_to` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `videos_id` int(250) DEFAULT NULL,
  `admin_email_from` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `admin_email` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `email_to` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `email_sub` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`cron_id`)
) ENGINE=MyISAM AUTO_INCREMENT=111 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (1, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/byzeG5z2HRMajhI7ML2zbcSyuvv.jpg', 'uploads/star_image/4.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (2, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/xDhu9q3Sk3kMVzcOqfa4YibKWMP.jpg', 'uploads/star_image/16.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (3, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/h8o5CowohYMNE3USzyWKN0CgwFv.jpg', 'uploads/star_image/17.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (4, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/kwyClWei18GOssMPbrs4RL61izG.jpg', 'uploads/star_image/26.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (5, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/3QzMI2O7NP2j45XBCoBl7o1KogN.jpg', 'uploads/star_image/27.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (6, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/88FfjxT3cFDIbCIK0UmwyjEF6tU.jpg', 'uploads/star_image/28.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (7, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/3j6dLrmRF5eXZtE256ojJRTNNq6.jpg', 'uploads/star_image/29.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (8, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/2U0KIVdWCbNMFLhCnpB5568eMrU.jpg', 'uploads/star_image/30.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (9, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/t2KrtknCJd5zsXWmMH089z5ePbT.jpg', 'uploads/star_image/31.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (10, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/9Oe7l13NoYrdgM5nZcWiK6pHW7L.jpg', 'uploads/star_image/32.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (11, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/n6vfEUjEF5lFeTcEyaFPChO2EQl.jpg', 'uploads/star_image/33.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (12, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/g97ryO8gIF3VaE0PaSpws8f0PjS.jpg', 'uploads/star_image/35.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (13, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/2w6zTvca2I7yIQvQOvK0EZtIn0O.jpg', 'uploads/star_image/36.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (14, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/nJgaxVjWnS64wCNFQ1MnqeHjvRP.jpg', 'uploads/star_image/37.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (15, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/zgCDH4kRXESzKLOtqNu8Gk5KNxh.jpg', 'uploads/star_image/38.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (16, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/ilfWPRkmy7pQfFXEESWjmLv4jl8.jpg', 'uploads/star_image/40.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (17, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/tJ2pg6LHMPcmeO0UzcNmhesbJ6z.jpg', 'uploads/star_image/41.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (18, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/zwWZ51P10q6fAydhoQk2tkOR8ei.jpg', 'uploads/star_image/42.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (19, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/lpCeWZrezfcEKKsYBVvLtrOpe36.jpg', 'uploads/star_image/43.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (20, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/fXj6FdgWPp8om9O2HD2Uv4yhcBi.jpg', 'uploads/star_image/44.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (21, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/26HoToajEl7LjiajPXlLWOpGRPg.jpg', 'uploads/star_image/46.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (22, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/fFj1Lhkn5FZWDbAGOJTRFsGYi1J.jpg', 'uploads/star_image/48.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (23, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/yEaR9SLMkQmEoW16Bf99hwLeQqT.jpg', 'uploads/star_image/49.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (24, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/pFqT2n2DOMqbtM4zW7k1texKrBY.jpg', 'uploads/star_image/50.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (25, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/9D0mW0x9W5MOehihDN7VlGKjqSk.jpg', 'uploads/star_image/51.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (26, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/iKcMFAKLnd9k0vLyHCv3pLKbNfy.jpg', 'uploads/star_image/52.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (27, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/ciUcw3FUSsxOf5BAx0fPhxQiijE.jpg', 'uploads/star_image/53.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (28, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/vR6cUehVVzFoOyDFq6ugHYAaAbi.jpg', 'uploads/star_image/54.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (29, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/2xwVbDRoDsuykeEsn7BBXRLT2Bp.jpg', 'uploads/star_image/55.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (30, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/z6j8Waj2NOs3LL5qQbErrfghnj4.jpg', 'uploads/star_image/56.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (31, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/tO7w2vzG1eiiVD2NwIF7WfjAjuf.jpg', 'uploads/star_image/57.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (32, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/udAKCPDJt2yQ7gdqdhZLvA73BSl.jpg', 'uploads/star_image/58.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (33, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/h6FJdct42dMtl0fSeuQt2r1s0kL.jpg', 'uploads/star_image/59.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (34, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/kt4Yt7sSKme7pZ7mZO7gg2JpwNC.jpg', 'uploads/star_image/60.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (35, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/zTfcR15XEP0adnAkDYxqv3KrfYg.jpg', 'uploads/star_image/61.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (36, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/eQSUtckCym9ssmSGjH0sVMGQnzM.jpg', 'uploads/star_image/62.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (37, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/gDKmkYRtXIya6HAxtZ3VxCaj0I2.jpg', 'uploads/star_image/63.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (38, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/ln1te8Hh26rrbP8chktKEFLT6ol.jpg', 'uploads/star_image/64.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (39, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/pxDLoZ4aYR7qRAFsmUj3r5vUUMD.jpg', 'uploads/star_image/65.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (40, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/7BAijrUZxGv9vF5jXh0yUxbDHMP.jpg', 'uploads/star_image/66.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (41, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/5VlwzRw76sAIVyehJxan8KC7CLo.jpg', 'uploads/star_image/67.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (42, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/jGcpktUdPqVERqb8BqYwp0YC5Z1.jpg', 'uploads/star_image/68.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (43, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/uYYvAfPiSx5BoWA0CrUS32p3qI5.jpg', 'uploads/star_image/69.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (44, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/rHkFOPzdJGimnC4yRqophK9tvEO.jpg', 'uploads/star_image/70.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (45, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/5p5p2yOJDmveQHgKyM92sovta31.jpg', 'uploads/star_image/76.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (46, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/v8ZNr34QDk0lw2QEoRmv4KqTIIA.jpg', 'uploads/star_image/83.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (47, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/8QgdVcTIocr6xdnD0lxhOBPAfUs.jpg', 'uploads/star_image/84.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (48, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/lRI9Ky1SMOehn04OqhYJ5hQfgIK.jpg', 'uploads/star_image/85.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (49, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/hHwmtTj7qfE8Aquzpv8MOkgRQ3k.jpg', 'uploads/star_image/86.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (50, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/biEgalVrcGWwBDFEYXyybKj4M41.jpg', 'uploads/star_image/87.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (51, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/7cecEmpjHUyxvmJ5ekMaYT1yOQb.jpg', 'uploads/star_image/88.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (52, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/yoxashVRv3PBTiispOboUjIZJy2.jpg', 'uploads/star_image/89.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (53, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/mkCWTmyWtInbtNiSkBaUU20DgXz.jpg', 'uploads/star_image/93.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (54, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/cvv0JsUSaRS51fh5XYm6yurVYcK.jpg', 'uploads/star_image/94.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (55, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/6lNCZC7XJCXcaw3dhVYX6MxIvLf.jpg', 'uploads/star_image/95.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (56, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/vxVytfyJeNDoftv1ch01EH9FpNm.jpg', 'uploads/star_image/100.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (57, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/dqXTeoYjfIpp008l9XjPFmSipm6.jpg', 'uploads/star_image/101.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (58, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/uKthYRGhfpLAyaQ4P64nH9eYcxz.jpg', 'uploads/star_image/102.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (59, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/16eXzuCXDgzl9T9qCYtr59Q0Ryc.jpg', 'uploads/star_image/104.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (60, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/dziA7mHZZO67FuplWvTuN98KqTQ.jpg', 'uploads/star_image/105.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (61, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/nhQ6CUbtWjmocr2UOBME43RAcR0.jpg', 'uploads/star_image/106.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (62, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/9r14GdalzQelaxG6DHI9F0teZXn.jpg', 'uploads/star_image/107.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (63, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/b4QxgWFjN09GMchSJXa1UAz0OY3.jpg', 'uploads/star_image/108.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (64, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/jKBYJop4N2hsizY2MgWtyoiJAZ4.jpg', 'uploads/star_image/109.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (65, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/hBDjQyU2xJ9vELw0H63igS7ugSD.jpg', 'uploads/star_image/110.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (66, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/vfvodDyHYL5JJ1JxPptZD4fg62z.jpg', 'uploads/star_image/111.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (67, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/6L3j9U9IkxJhatF8ASsO3PtNZUN.jpg', 'uploads/star_image/112.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (68, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/b97tFhZ5EiynBrWMZ6bpC48ZPow.jpg', 'uploads/star_image/113.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (69, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/1C6VGYklEbMvKffXSNnGOhnv1VI.jpg', 'uploads/star_image/114.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (70, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/gD7Fd6ksHRGNnWFOw0qv9v8QVmd.jpg', 'uploads/star_image/115.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (71, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/sZAJ7TS52RxyejiirXhhqmYxxwn.jpg', 'uploads/star_image/116.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (72, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/5Tmqy8R2Ao4wUm826W17ioRPaZe.jpg', 'uploads/star_image/118.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (73, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/5ZfGe8oDDhRWZi81URvCoNWognr.jpg', 'uploads/star_image/119.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (74, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/zD0YSQ05q3lXdMjix79CxgIHjPB.jpg', 'uploads/star_image/121.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (75, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/zzHfJYGhhsTeN2OoLgXolvJPRyh.jpg', 'uploads/star_image/123.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (76, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/c6p0wEXDZQ549MTItKY0WkLDJL1.jpg', 'uploads/star_image/124.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (77, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/5Nmi3sTqMDl3STrCSCD4kSKZadT.jpg', 'uploads/star_image/127.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (78, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/kEWFRyH3vYyw5pdIzzAO5374sb4.jpg', 'uploads/star_image/129.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (79, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/5RZtgV7iFQFvVijQJzNFzViAEu8.jpg', 'uploads/star_image/130.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (80, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/rRuqfKzHDihOBO5iywiUW5wAawN.jpg', 'uploads/star_image/131.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (81, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/brz9fX8bprzqkRtQkWX7oXNWw4J.jpg', 'uploads/star_image/132.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (82, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/v34026VquSHeMPgl0BbdRijKW4i.jpg', 'uploads/star_image/133.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (83, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/rKk9V7OkxeBiSsf6CScSrwB3NfD.jpg', 'uploads/star_image/134.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (84, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/6KHYmOVncIMwJZa2OkqIAR1z4Qm.jpg', 'uploads/star_image/135.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (85, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/fgJ4oZAoxS5SYa5rCUbJBuESsii.jpg', 'uploads/star_image/136.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (86, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/mT81KoZ9dfUkfMVpCAmWLYtB7SC.jpg', 'uploads/star_image/137.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (87, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/2E4Ujpec5xMHetkfjErfuBvzJfO.jpg', 'uploads/star_image/139.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (88, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/wKe3WXOWLo0yrHiQNLQxQrIIovE.jpg', 'uploads/star_image/140.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (89, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/3MS31iCNI8A24t4cDaCc4CV1e87.jpg', 'uploads/star_image/141.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (90, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/9eGUVUBTQLA6e3uT0YmZQ72hPbT.jpg', 'uploads/star_image/142.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (91, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/17szXtRhSUmdYCivNTtlFPNwQh6.jpg', 'uploads/star_image/143.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (92, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/y642LERKLtOlqTjcckH8oWDVBGb.jpg', 'uploads/star_image/144.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (93, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/9w8e41q6hzBIMss8EQvtaIPOSmV.jpg', 'uploads/star_image/145.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (94, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/7EanyqqLfQzS9PnKIBa6w1Rbbi8.jpg', 'uploads/star_image/148.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (95, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/bWIt5hnn3pV0p3M8MQcVibT3M6C.jpg', 'uploads/star_image/150.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (96, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/ydx0eRPERKg6oD9r3horgYGJkaK.jpg', 'uploads/star_image/152.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (97, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/yKc6ymn8uzhflDRIIzUtlPXOTW.jpg', 'uploads/star_image/160.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (98, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/kO9YVHXr8x2NV2ZbvCt9VgHpamW.jpg', 'uploads/star_image/161.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (99, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/qExsfkKG3XI70JRQQhHgxUubI2n.jpg', 'uploads/star_image/162.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (100, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/emVEmk616yXVHwwjpt0oxf9E2nK.jpg', 'uploads/star_image/163.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (101, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/asOkGl8G0bbGJZhayppEvrhtcEm.jpg', 'uploads/star_image/164.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (102, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/7fBGYxFBcfaQfqa3rUjAeMj5I4T.jpg', 'uploads/star_image/165.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (103, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/wkM8oAU7S1DDzhWcbjRcJbxsoH9.jpg', 'uploads/star_image/166.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (104, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/9KyhidWj4XjpYGqrvTQeSHjfpsN.jpg', 'uploads/star_image/167.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (105, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/hvm6Xqu9nq9IXbvEcM6PUUaiigG.jpg', 'uploads/star_image/168.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (106, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/s8yUbtAu6wueQjDRncuSX6x6ZUt.jpg', 'uploads/star_image/169.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (107, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/AkOwJ81bJkoorsGZMjhMpQZbCrO.jpg', 'uploads/star_image/170.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (108, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/9Bsvemc5lCvKNJdS5bt4BEa7TFR.jpg', 'uploads/star_image/171.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (109, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/rXpErfaKzGG27xhPf2Sn1iw5cSu.jpg', 'uploads/star_image/173.jpg', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `cron` (`cron_id`, `type`, `action`, `image_url`, `save_to`, `videos_id`, `admin_email_from`, `admin_email`, `email_to`, `email_sub`, `message`) VALUES (110, 'image', 'download', 'https://image.tmdb.org/t/p/w138_and_h175_bestv2/yQJd3IBj12vr48b7ZKqrzyHiWYS.jpg', 'uploads/star_image/178.jpg', NULL, NULL, NULL, NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: currency
#

DROP TABLE IF EXISTS `currency`;

CREATE TABLE `currency` (
  `currency_id` int(11) NOT NULL AUTO_INCREMENT,
  `country` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `currency` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `iso_code` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `symbol` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `exchange_rate` double NOT NULL DEFAULT 1,
  `default` int(11) NOT NULL DEFAULT 0,
  `status` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`currency_id`)
) ENGINE=MyISAM AUTO_INCREMENT=133 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (1, 'Albania', 'Leke', 'ALL', 'Lek', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (2, 'America', 'Dollars', 'USD', '$', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (3, 'Afghanistan', 'Afghanis', 'AFN', '؋', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (4, 'Argentina', 'Pesos', 'ARS', '$', '61.399228', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (5, 'Aruba', 'Guilders', 'AWG', 'ƒ', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (6, 'Australia', 'Dollars', 'AUD', '$', '1.4882', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (7, 'Azerbaijan', 'New Manats', 'AZN', 'ман', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (8, 'Bahamas', 'Dollars', 'BSD', '$', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (9, 'Barbados', 'Dollars', 'BBD', '$', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (10, 'Belarus', 'Rubles', 'BYR', 'p.', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (11, 'Belgium', 'Euro', 'EUR', '€', '0.922379', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (12, 'Beliz', 'Dollars', 'BZD', 'BZ$', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (13, 'Bermuda', 'Dollars', 'BMD', '$', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (14, 'Bolivia', 'Bolivianos', 'BOB', '$b', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (15, 'Bosnia and Herzegovina', 'Convertible Marka', 'BAM', 'KM', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (16, 'Botswana', 'Pula', 'BWP', 'P', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (17, 'Bulgaria', 'Leva', 'BGN', 'лв', '1.803753', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (18, 'Brazil', 'Reais', 'BRL', 'R$', '4.330496', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (19, 'Britain (United Kingdom)', 'Pounds', 'GBP', '£', '83', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (20, 'Brunei Darussalam', 'Dollars', 'BND', '$', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (21, 'Cambodia', 'Riels', 'KHR', '៛', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (22, 'Canada', 'Dollars', 'CAD', '$', '1.325097', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (23, 'Cayman Islands', 'Dollars', 'KYD', '$', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (24, 'Chile', 'Pesos', 'CLP', '$', '794.622928', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (25, 'China', 'Yuan Renminbi', 'CNY', '¥', '6.984162', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (26, 'Colombia', 'Pesos', 'COP', '$', '3313', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (27, 'Costa Rica', 'Colón', 'CRC', '₡', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (28, 'Croatia', 'Kuna', 'HRK', 'kn', '6.869981', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (29, 'Cuba', 'Pesos', 'CUP', '₱', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (30, 'Cyprus', 'Euro', 'EUR', '€', '0.922379', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (31, 'Czech Republic', 'Koruny', 'CZK', 'Kč', '22.911451', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (32, 'Denmark', 'Kroner', 'DKK', 'kr', '6.890187', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (33, 'Dominican Republic', 'Pesos', 'DOP ', 'RD$', '53.507402', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (34, 'East Caribbean', 'Dollars', 'XCD', '$', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (35, 'Egypt', 'Pounds', 'EGP', '£', '15.61815', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (36, 'El Salvador', 'Colones', 'SVC', '$', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (37, 'England (United Kingdom)', 'Pounds', 'GBP', '£', '83', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (38, 'Euro', 'Euro', 'EUR', '€', '0.922379', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (39, 'Falkland Islands', 'Pounds', 'FKP', '£', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (40, 'Fiji', 'Dollars', 'FJD', '$', '2.195918', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (41, 'France', 'Euro', 'EUR', '€', '0.922379', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (42, 'Ghana', 'Cedis', 'GHC', '¢', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (43, 'Gibraltar', 'Pounds', 'GIP', '£', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (44, 'Greece', 'Euro', 'EUR', '€', '0.922379', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (45, 'Guatemala', 'Quetzales', 'GTQ', 'Q', '7.63804', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (46, 'Guernsey', 'Pounds', 'GGP', '£', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (47, 'Guyana', 'Dollars', 'GYD', '$', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (48, 'Holland (Netherlands)', 'Euro', 'EUR', '€', '0.922379', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (49, 'Honduras', 'Lempiras', 'HNL', 'L', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (50, 'Hong Kong', 'Dollars', 'HKD', '$', '7.767071', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (51, 'Hungary', 'Forint', 'HUF', 'Ft', '310.231043', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (52, 'Iceland', 'Kronur', 'ISK', 'kr', '126.858376', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (53, 'India', 'Rupees', 'INR', 'Rp', '71.40112', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (54, 'Indonesia', 'Rupiahs', 'IDR', 'Rp', '13612.651679', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (55, 'Iran', 'Rials', 'IRR', '﷼', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (56, 'Ireland', 'Euro', 'EUR', '€', '0.922379', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (57, 'Isle of Man', 'Pounds', 'IMP', '£', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (58, 'Israel', 'New Shekels', 'ILS', '₪', '3.427408', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (59, 'Italy', 'Euro', 'EUR', '€', '0.922379', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (60, 'Jamaica', 'Dollars', 'JMD', 'J$', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (61, 'Japan', 'Yen', 'JPY', '¥', '109.814254', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (62, 'Jersey', 'Pounds', 'JEP', '£', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (63, 'Kazakhstan', 'Tenge', 'KZT', 'лв', '376.834123', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (64, 'Korea (North)', 'Won', 'KPW', '₩', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (65, 'Korea (South)', 'Won', 'KRW', '₩', '1183.94149', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (66, 'Kyrgyzstan', 'Soms', 'KGS', 'лв', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (67, 'Laos', 'Kips', 'LAK', '₭', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (68, 'Latvia', 'Lati', 'LVL', 'Ls', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (69, 'Lebanon', 'Pounds', 'LBP', '£', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (70, 'Liberia', 'Dollars', 'LRD', '$', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (71, 'Liechtenstein', 'Switzerland Francs', 'CHF', 'CHF', '0.980752', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (72, 'Lithuania', 'Litai', 'LTL', 'Lt', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (73, 'Luxembourg', 'Euro', 'EUR', '€', '0.922379', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (74, 'Macedonia', 'Denars', 'MKD', 'ден', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (75, 'Malaysia', 'Ringgits', 'MYR', 'RM', '4.139749', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (76, 'Malta', 'Euro', 'EUR', '€', '0.922379', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (77, 'Mauritius', 'Rupees', 'MUR', '₨', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (78, 'Mexico', 'Pesos', 'MXN', '$', '18.585695', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (79, 'Mongolia', 'Tugriks', 'MNT', '₮', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (80, 'Mozambique', 'Meticais', 'MZN', 'MT', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (81, 'Namibia', 'Dollars', 'NAD', '$', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (82, 'Nepal', 'Rupees', 'NPR', '₨', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (83, 'Netherlands Antilles', 'Guilders', 'ANG', 'ƒ', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (84, 'Netherlands', 'Euro', 'EUR', '€', '0.922379', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (85, 'New Zealand', 'Dollars', 'NZD', '$', '1.553574', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (86, 'Nicaragua', 'Cordobas', 'NIO', 'C$', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (87, 'Nigeria', 'Nairas', 'NGN', '₦', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (88, 'North Korea', 'Won', 'KPW', '₩', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (89, 'Norway', 'Krone', 'NOK', 'kr', '9.253793', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (90, 'Oman', 'Rials', 'OMR', '﷼', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (91, 'Pakistan', 'Rupees', 'PKR', '₨', '154.392233', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (92, 'Panama', 'Balboa', 'PAB', 'B/.', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (93, 'Paraguay', 'Guarani', 'PYG', 'Gs', '6626', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (94, 'Peru', 'Nuevos Soles', 'PEN', 'S/.', '3.383275', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (95, 'Philippines', 'Pesos', 'PHP', 'Php', '50.525693', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (96, 'Poland', 'Zlotych', 'PLN', 'zł', '3.917289', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (97, 'Qatar', 'Rials', 'QAR', '﷼', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (98, 'Romania', 'New Lei', 'RON', 'lei', '4.396745', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (99, 'Russia', 'Rubles', 'RUB', 'руб', '63.537178', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (100, 'Saint Helena', 'Pounds', 'SHP', '£', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (101, 'Saudi Arabia', 'Riyals', 'SAR', '﷼', '3.75061', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (102, 'Serbia', 'Dinars', 'RSD', 'Дин.', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (103, 'Seychelles', 'Rupees', 'SCR', '₨', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (104, 'Singapore', 'Dollars', 'SGD', '$', '1.390516', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (105, 'Slovenia', 'Euro', 'EUR', '€', '0.922379', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (106, 'Solomon Islands', 'Dollars', 'SBD', '$', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (107, 'Somalia', 'Shillings', 'SOS', 'S', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (108, 'South Africa', 'Rand', 'ZAR', 'R', '14.88117', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (109, 'South Korea', 'Won', 'KRW', '₩', '1183.94149', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (110, 'Spain', 'Euro', 'EUR', '€', '0.922379', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (111, 'Sri Lanka', 'Rupees', 'LKR', '₨', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (112, 'Sweden', 'Kronor', 'SEK', 'kr', '9.694847', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (113, 'Switzerland', 'Francs', 'CHF', 'CHF', '0.980752', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (114, 'Suriname', 'Dollars', 'SRD', '$', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (115, 'Syria', 'Pounds', 'SYP', '£', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (116, 'Taiwan', 'New Dollars', 'TWD', 'NT$', '30.0056', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (117, 'Thailand', 'Baht', 'THB', '฿', '31.163295', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (118, 'Trinidad and Tobago', 'Dollars', 'TTD', 'TT$', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (119, 'Turkey', 'Lira', 'TRY', 'TL', '6.053817', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (120, 'Turkey', 'Liras', 'TRL', '£', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (121, 'Tuvalu', 'Dollars', 'TVD', '$', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (122, 'Ukraine', 'Hryvnia', 'UAH', '₴', '24.336642', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (123, 'United Kingdom', 'Pounds', 'GBP', '£', '83', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (124, 'United States of America', 'Dollars', 'USD', '$', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (125, 'Uruguay', 'Pesos', 'UYU', '$U', '37.880896', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (126, 'Uzbekistan', 'Sums', 'UZS', 'лв', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (127, 'Vatican City', 'Euro', 'EUR', '€', '0.922379', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (128, 'Venezuela', 'Bolivares Fuertes', 'VEF', 'Bs', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (129, 'Vietnam', 'Dong', 'VND', '₫', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (130, 'Yemen', 'Rials', 'YER', '﷼', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (131, 'Zimbabwe', 'Zimbabwe Dollars', 'ZWD', 'Z$', '1', 0, 1);
INSERT INTO `currency` (`currency_id`, `country`, `currency`, `iso_code`, `symbol`, `exchange_rate`, `default`, `status`) VALUES (132, 'Bangladesh', 'Taka', 'BDT', '৳', '83', 0, 1);


#
# TABLE STRUCTURE FOR: download_link
#

DROP TABLE IF EXISTS `download_link`;

CREATE TABLE `download_link` (
  `download_link_id` int(11) NOT NULL AUTO_INCREMENT,
  `videos_id` int(11) DEFAULT NULL,
  `link_title` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `resolution` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '720p',
  `file_size` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '00MB',
  `download_url` varchar(500) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `in_app_download` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`download_link_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

#
# TABLE STRUCTURE FOR: episode_download_link
#

DROP TABLE IF EXISTS `episode_download_link`;

CREATE TABLE `episode_download_link` (
  `episode_download_link_id` int(11) NOT NULL AUTO_INCREMENT,
  `videos_id` int(11) DEFAULT NULL,
  `season_id` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `link_title` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `resolution` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '720p',
  `file_size` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '00MB',
  `download_url` varchar(500) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `in_app_download` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`episode_download_link_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

#
# TABLE STRUCTURE FOR: episodes
#

DROP TABLE IF EXISTS `episodes`;

CREATE TABLE `episodes` (
  `episodes_id` int(11) NOT NULL AUTO_INCREMENT,
  `stream_key` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `videos_id` int(11) DEFAULT NULL,
  `seasons_id` int(11) DEFAULT NULL,
  `episodes_name` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `file_source` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `source_type` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `file_url` varchar(500) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order` int(50) NOT NULL DEFAULT 0,
  `date_added` datetime NOT NULL DEFAULT '2019-01-01 00:00:00',
  `last_ep_added` datetime NOT NULL DEFAULT '2019-01-01 00:00:00',
  PRIMARY KEY (`episodes_id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `episodes` (`episodes_id`, `stream_key`, `videos_id`, `seasons_id`, `episodes_name`, `file_source`, `source_type`, `file_url`, `order`, `date_added`, `last_ep_added`) VALUES (7, 'up5wna6ivrtg', 3, 1, 'Maestro - 5AM London', 'embed', 'link', 'https://player.vimeo.com/video/360811328', 5, '2021-01-17 00:42:13', '2019-01-01 00:00:00');
INSERT INTO `episodes` (`episodes_id`, `stream_key`, `videos_id`, `seasons_id`, `episodes_name`, `file_source`, `source_type`, `file_url`, `order`, `date_added`, `last_ep_added`) VALUES (2, 'suztd62yp6on', 4, 2, 'Windigo vs x6tence Galaxy', 'embed', 'link', 'https://player.vimeo.com/video/448529982', 0, '2020-12-14 19:13:49', '2019-01-01 00:00:00');
INSERT INTO `episodes` (`episodes_id`, `stream_key`, `videos_id`, `seasons_id`, `episodes_name`, `file_source`, `source_type`, `file_url`, `order`, `date_added`, `last_ep_added`) VALUES (3, 'bb8eczgwlsyw', 3, 1, 'Yung Fume - Fat Joe', 'embed', 'link', 'https://player.vimeo.com/video/360812333', 2, '2021-01-16 15:57:46', '2019-01-01 00:00:00');
INSERT INTO `episodes` (`episodes_id`, `stream_key`, `videos_id`, `seasons_id`, `episodes_name`, `file_source`, `source_type`, `file_url`, `order`, `date_added`, `last_ep_added`) VALUES (4, '15qt0t22v0mr', 3, 1, 'Yung Fume - Islands', 'embed', 'link', 'https://player.vimeo.com/video/360812562', 3, '2021-01-16 15:58:42', '2019-01-01 00:00:00');
INSERT INTO `episodes` (`episodes_id`, `stream_key`, `videos_id`, `seasons_id`, `episodes_name`, `file_source`, `source_type`, `file_url`, `order`, `date_added`, `last_ep_added`) VALUES (5, 'xhbahpefm1hw', 3, 1, 'Yung Fume - Secrets', 'embed', 'link', 'https://player.vimeo.com/video/360812813', 4, '2021-01-16 16:00:10', '2019-01-01 00:00:00');
INSERT INTO `episodes` (`episodes_id`, `stream_key`, `videos_id`, `seasons_id`, `episodes_name`, `file_source`, `source_type`, `file_url`, `order`, `date_added`, `last_ep_added`) VALUES (6, 'zaycizjqj45w', 3, 1, 'Yung Fume ft. M Huncho - Droptop', 'embed', 'link', 'https://player.vimeo.com/video/360812947', 5, '2021-01-16 16:01:50', '2019-01-01 00:00:00');
INSERT INTO `episodes` (`episodes_id`, `stream_key`, `videos_id`, `seasons_id`, `episodes_name`, `file_source`, `source_type`, `file_url`, `order`, `date_added`, `last_ep_added`) VALUES (8, 'e9vh7we0kcnq', 3, 1, 'Karlito DBG Ft. Trap Skimp, Jordan Morris Pablo - Sauce', 'embed', 'link', 'https://player.vimeo.com/video/360811186', 6, '2021-01-17 00:43:43', '2019-01-01 00:00:00');


#
# TABLE STRUCTURE FOR: genre
#

DROP TABLE IF EXISTS `genre`;

CREATE TABLE `genre` (
  `genre_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `description` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `slug` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `publication` int(1) NOT NULL,
  `featured` int(2) DEFAULT 0,
  PRIMARY KEY (`genre_id`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (1, 'Action', 'Action Movie<br>', 'action', 1, 1);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (2, 'TV Show', 'Tv Show <br>', 'tv-show', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (3, 'Si-Fi', '', 'si-fi', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (4, 'Adventure', 'Adventure Movies<br>', 'adventure', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (5, 'Animation', 'Animation Movies<br>', 'animation', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (6, 'Biography', 'Biography Movies<br>', 'biography', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (7, 'Comedy', 'Comedy Movies<br>', 'comedy', 1, 1);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (8, 'Crime', 'Crime Movies<br>', 'crime', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (9, 'Documentary', 'Documentary Movies<br>', 'documentary', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (10, 'Drama', '', 'drama', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (11, 'Family', 'Family<br>', 'family', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (12, 'Fantasy', 'Fantasy Movies<br>', 'fantasy', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (13, 'History', '', 'history', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (14, 'Horror', 'Horror Movies<br>', 'horror', 1, 1);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (15, 'Music', '', 'music', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (16, 'Musical', '', 'musical', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (17, 'Mystery', '', 'mystery', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (18, 'Thriller', '', 'thriller', 1, 1);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (19, 'War', '', 'war', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (20, 'Western', '', 'western', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (21, 'TV Series', '', 'tv-series', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (22, ' Romance', ' Romance', 'romance', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (23, ' Adventure', ' Adventure', 'adventure', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (24, ' Thriller', ' Thriller', 'thriller', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (25, ' Drama', ' Drama', 'drama', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (26, ' Fantasy', ' Fantasy', 'fantasy', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (27, ' Sci-Fi', ' Sci-Fi', 'sci-fi', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (28, ' Comedy', ' Comedy', 'comedy', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (29, ' Family', ' Family', 'family', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (30, ' Action', ' Action', 'action', 1, 1);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (31, 'Short', 'Short', 'short', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (32, ' Music', ' Music', 'music', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (33, ' History', ' History', 'history', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (34, ' Crime', ' Crime', 'crime', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (35, ' Western', ' Western', 'western', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (36, ' Sport', ' Sport', 'sport', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (37, ' Short', ' Short', 'short', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (38, ' Mystery', ' Mystery', 'mystery', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (39, 'Romance', 'Romance', 'romance', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (40, 'Action & Adventure', 'Action & Adventure', 'action-adventure', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (41, 'Sci-Fi & Fantasy', 'Sci-Fi & Fantasy', 'sci-fi-fantasy', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (42, 'Science Fiction', 'Science Fiction', 'science-fiction', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (44, 'TV Movie', 'TV Movie', 'tv-movie', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (45, 'News', 'News', 'news', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (46, 'جريمة', 'جريمة', 'جريمة', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (47, 'إثارة', 'إثارة', 'إثارة', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (48, 'دراما', 'دراما', 'دراما', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (49, 'حركة', 'حركة', '', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (50, 'خيال علمي', 'خيال علمي', '', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (51, 'مغامرة', 'مغامرة', '', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (52, 'فانتازيا', 'فانتازيا', '', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (53, 'رسوم متحركة', 'رسوم متحركة', '', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (54, 'عائلي', 'عائلي', '', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (55, 'كوميديا', 'كوميديا', '', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (56, 'وثائقي', 'وثائقي', '', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (57, 'Science-Fiction', 'Science-Fiction', 'science-fiction', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (58, 'Historie', 'Historie', 'historie', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (59, 'Abenteuer', 'Abenteuer', 'abenteuer', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (60, 'Familie', 'Familie', 'familie', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (61, 'Krimi', 'Krimi', 'krimi', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (62, 'Boxing', 'Boxing', 'boxing', 1, 1);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (63, 'Military', 'Military', 'military', 1, 1);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (64, 'Brawlhalla', '', 'brawlhalla', 1, 0);
INSERT INTO `genre` (`genre_id`, `name`, `description`, `slug`, `publication`, `featured`) VALUES (65, 'Gaming', '', 'gaming', 1, 0);


#
# TABLE STRUCTURE FOR: keys
#

DROP TABLE IF EXISTS `keys`;

CREATE TABLE `keys` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT 'System',
  `key` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `level` int(2) NOT NULL,
  `ignore_limits` tinyint(1) NOT NULL DEFAULT 0,
  `is_private_key` tinyint(1) NOT NULL DEFAULT 0,
  `ip_addresses` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_created` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `keys` (`id`, `label`, `key`, `level`, `ignore_limits`, `is_private_key`, `ip_addresses`, `date_created`) VALUES (1, 'Default', 'baaa1f522fa7620', 1, 0, 0, NULL, 1582700749);


#
# TABLE STRUCTURE FOR: language
#

DROP TABLE IF EXISTS `language`;

CREATE TABLE `language` (
  `phrase_id` int(11) NOT NULL AUTO_INCREMENT,
  `phrase` longtext COLLATE utf8_unicode_ci NOT NULL,
  `english` longtext COLLATE utf8_unicode_ci NOT NULL,
  `bengali` longtext COLLATE utf8_unicode_ci NOT NULL,
  `spanish` longtext COLLATE utf8_unicode_ci NOT NULL,
  `arabic` longtext COLLATE utf8_unicode_ci NOT NULL,
  `dutch` longtext COLLATE utf8_unicode_ci NOT NULL,
  `russian` longtext COLLATE utf8_unicode_ci NOT NULL,
  `chinese` longtext COLLATE utf8_unicode_ci NOT NULL,
  `turkish` longtext COLLATE utf8_unicode_ci NOT NULL,
  `portuguese` longtext COLLATE utf8_unicode_ci NOT NULL,
  `hungarian` longtext COLLATE utf8_unicode_ci NOT NULL,
  `french` longtext COLLATE utf8_unicode_ci NOT NULL,
  `greek` longtext COLLATE utf8_unicode_ci NOT NULL,
  `german` longtext COLLATE utf8_unicode_ci NOT NULL,
  `italian` longtext COLLATE utf8_unicode_ci NOT NULL,
  `thai` longtext COLLATE utf8_unicode_ci NOT NULL,
  `urdu` longtext COLLATE utf8_unicode_ci NOT NULL,
  `hindi` longtext COLLATE utf8_unicode_ci NOT NULL,
  `latin` longtext COLLATE utf8_unicode_ci NOT NULL,
  `indonesian` longtext COLLATE utf8_unicode_ci NOT NULL,
  `japanese` longtext COLLATE utf8_unicode_ci NOT NULL,
  `korean` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`phrase_id`)
) ENGINE=MyISAM AUTO_INCREMENT=11546 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11317, 'profile', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11318, 'change_password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11319, 'logout', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11320, 'movies', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11321, 'TV-Series', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11322, 'stars', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11323, 'countries', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11324, 'pages', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11325, 'posts', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11326, 'register_user', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11327, 'recent_comments', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11328, 'most_popular_video', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11329, 'top_rated_video', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11330, 'recent_post', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11331, 'recent_subscriber', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11332, '\'are_you_sure\'', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11333, '\'it_will_be_delete_permanently!\'', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11334, '\'cancel\'', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11335, '\'yes, delete_it!\'', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11336, '\'deleted!\'', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11337, 'add_user', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11338, 'sl', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11339, 'full_name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11340, 'email', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11341, 'role', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11342, 'option', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11343, 'edit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11344, 'delete', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11345, 'save_changes', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11346, 'theme_options', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11347, 'purchase_code', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11348, 'site_name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11349, 'site_url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11350, 'system_email', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11351, 'business_address', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11352, 'business_phone', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11353, 'contact_email', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11354, 'google_map_api', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11355, 'google_map_lat', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11356, 'google_map_lng', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11357, 'dark_theme_enable', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11358, 'front_end_theme_color', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11359, 'header_templete', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11360, 'footer_templete', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11361, 'registration_enable', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11362, 'blog_enable', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11363, 'footer_setting', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11364, 'Footer-1_title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11365, 'footer-1_content', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11366, 'Footer-2_title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11367, 'footer-2_content', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11368, 'Footer-3_title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11369, 'footer-3_content', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11370, 'copyright_text', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11371, 'email_setting', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11372, 'mail_type', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11373, 'smtp (Recommanded)', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11374, 'sendmail', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11375, 'smtp_server_address', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11376, 'smtp_username', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11377, 'smtp_password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11378, 'smtp_port', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11379, 'smtp_crypto', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11380, 'ssl', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11381, 'tls', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11382, 'mail_path', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11383, 'social_share_(_addThis)', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11384, 'enable', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11385, 'disable', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11386, 'facebook_url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11387, 'twitter_url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11388, 'linkedin_url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11389, 'vimeo_url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11390, 'youtube_url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11391, 'logo_setting', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11392, 'website_logo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11393, 'website_favicon', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11394, 'add_country', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11395, 'name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11396, 'slug', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11397, 'description', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11398, 'status', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11399, 'tv_name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11400, 'thumbnail', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11401, 'poster', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11402, 'meta_description', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11403, 'focus_keyword', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11404, 'tags', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11405, 'publish', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11406, 'featured', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11407, 'live_tv_category', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11408, 'add', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11409, 'title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11410, 'actor', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11411, 'director', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11412, 'writer', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11413, 'IMDb_rating', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11414, 'release_date', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11415, 'country', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11416, 'genre', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11417, 'video_type', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11418, 'runtime', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11419, 'video_quality', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11420, 'publication', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11421, 'enable_download', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11422, 'link', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11423, 'file', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11424, 'tv_series_setting', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11425, 'primary_menu', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11426, 'footer_menu', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11427, 'published', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11428, 'add_live_tv', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11429, 'preview', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11430, 'unpublished', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11431, 'all_pages', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11432, 'add_page', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11433, 'Title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11434, 'publish_at', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11435, 'all_posts', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11436, 'add_post', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11437, 'Title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11438, 'post_category', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11439, 'upload_videos', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11440, 'select_file', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11441, 'upload_video', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11442, 'source', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11443, 'video_list', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11444, 'download_url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11445, 'download_link_list', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11446, 'add_video', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11447, 'edit_video', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11448, 'player_setting', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11449, 'color_skin', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11450, 'volume_remember', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11451, 'player_watermark', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11452, 'watermark', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11453, 'player_watermark_logo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11454, 'watermark_url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11455, 'player_share', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11456, 'share', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11457, 'player_share_fb_id', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11458, 'player_seek_button', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11459, 'seek_button', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11460, 'player_seek_forward', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11461, 'player_seek_back', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11462, 'add_new_video_type', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11463, 'menu_bar', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11464, 'footer', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11465, 'add_star', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11466, 'fetch_from_TMDB', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11467, 'star_name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11468, 'star_type', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11469, 'add_new_post', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11470, 'post_title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11471, 'content', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11472, 'category', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11473, 'seo_setting', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11474, 'create_backup', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11475, 'facebook_login_details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11476, 'facebook_login', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11477, 'facebook_app_id', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11478, 'facebook_app_secret', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11479, 'facebook_graph_version', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11480, 'google_login_details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11481, 'google_login', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11482, 'application_name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11483, 'client_id', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11484, 'client_secret', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11485, 'google_redirect_uri', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11486, 'ads_name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11487, 'unique_name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11488, 'type', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11489, 'ads_size', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11490, 'Edit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11491, 'live_tv_setting', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11492, 'add_seasons', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11493, 'session_name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11494, 'episodes', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11495, 'seasons_name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11496, 'episodes_list', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11497, 'add_slider', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11498, 'slider_setting', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11499, 'slider_type', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11500, 'image_slider', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11501, 'latest_movie', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11502, 'total_movie', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11503, 'movie_per_page', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11504, 'approved', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11505, 'unapproved', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11506, 'trash', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11507, 'spam', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11508, 'all', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11509, 'author', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11510, 'comment', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11511, 'in_response_to', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11512, 'submitted_on', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11513, 'push_notification_setting', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11514, 'push_notification', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11515, 'onesignal_api_keys', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11516, 'onesignal_appid', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11517, 'onesignal_actionmessage', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11518, 'onesignal_acceptbuttontext', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11519, 'onesignal_cancelbuttontext', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11520, 'Title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11521, 'add_new_post_category', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11522, 'category_name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11523, 'send_push_notification', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11524, 'headings', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11525, 'message', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11526, 'add_genre', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11527, 'page_title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11528, 'hook_to', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11529, 'Title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11530, 'Title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11531, 'Title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11532, 'edit_post', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11533, 'Title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11534, 'edit_page', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11535, 'Title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11536, 'video_link', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11537, 'Image', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11538, 'Title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11539, 'Edit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11540, 'edit_video_type', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11541, 'quality', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11542, 'save', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11543, 'username', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11544, 'Edit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `bengali`, `spanish`, `arabic`, `dutch`, `russian`, `chinese`, `turkish`, `portuguese`, `hungarian`, `french`, `greek`, `german`, `italian`, `thai`, `urdu`, `hindi`, `latin`, `indonesian`, `japanese`, `korean`) VALUES (11545, 'Edit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');


#
# TABLE STRUCTURE FOR: language_list
#

DROP TABLE IF EXISTS `language_list`;

CREATE TABLE `language_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `short_form` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `language_code` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `folder_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `text_direction` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int(11) NOT NULL DEFAULT 1,
  `language_order` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `language_list` (`id`, `name`, `short_form`, `language_code`, `folder_name`, `text_direction`, `status`, `language_order`) VALUES (1, 'English', 'en', 'en_us', 'english', 'ltr', 1, 1);


#
# TABLE STRUCTURE FOR: languages_iso
#

DROP TABLE IF EXISTS `languages_iso`;

CREATE TABLE `languages_iso` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(49) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `iso` char(2) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=136 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (1, 'English', 'en');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (2, 'Afar', 'aa');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (3, 'Abkhazian', 'ab');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (4, 'Afrikaans', 'af');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (5, 'Amharic', 'am');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (6, 'Arabic', 'ar');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (7, 'Assamese', 'as');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (8, 'Aymara', 'ay');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (9, 'Azerbaijani', 'az');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (10, 'Bashkir', 'ba');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (11, 'Belarusian', 'be');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (12, 'Bulgarian', 'bg');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (13, 'Bihari', 'bh');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (14, 'Bislama', 'bi');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (15, 'Bangla', 'bn');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (16, 'Tibetan', 'bo');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (17, 'Breton', 'br');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (18, 'Catalan', 'ca');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (19, 'Corsican', 'co');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (20, 'Czech', 'cs');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (21, 'Welsh', 'cy');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (22, 'Danish', 'da');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (23, 'German', 'de');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (24, 'Bhutani', 'dz');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (25, 'Greek', 'el');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (26, 'Esperanto', 'eo');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (27, 'Spanish', 'es');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (28, 'Estonian', 'et');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (29, 'Basque', 'eu');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (30, 'Persian', 'fa');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (31, 'Finnish', 'fi');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (32, 'Fiji', 'fj');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (33, 'Faeroese', 'fo');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (34, 'French', 'fr');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (35, 'Frisian', 'fy');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (36, 'Irish', 'ga');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (37, 'Scots/Gaelic', 'gd');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (38, 'Galician', 'gl');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (39, 'Guarani', 'gn');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (40, 'Gujarati', 'gu');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (41, 'Hausa', 'ha');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (42, 'Hindi', 'hi');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (43, 'Croatian', 'hr');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (44, 'Hungarian', 'hu');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (45, 'Armenian', 'hy');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (46, 'Interlingua', 'ia');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (47, 'Interlingue', 'ie');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (48, 'Inupiak', 'ik');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (49, 'Indonesian', 'in');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (50, 'Icelandic', 'is');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (51, 'Italian', 'it');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (52, 'Hebrew', 'iw');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (53, 'Japanese', 'ja');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (54, 'Yiddish', 'ji');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (55, 'Javanese', 'jw');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (56, 'Georgian', 'ka');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (57, 'Kazakh', 'kk');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (58, 'Greenlandic', 'kl');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (59, 'Cambodian', 'km');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (60, 'Kannada', 'kn');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (61, 'Korean', 'ko');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (62, 'Kashmiri', 'ks');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (63, 'Kurdish', 'ku');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (64, 'Kirghiz', 'ky');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (65, 'Latin', 'la');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (66, 'Lingala', 'ln');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (67, 'Laothian', 'lo');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (68, 'Lithuanian', 'lt');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (69, 'Latvian/Lettish', 'lv');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (70, 'Malagasy', 'mg');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (71, 'Maori', 'mi');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (72, 'Macedonian', 'mk');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (73, 'Malayalam', 'ml');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (74, 'Mongolian', 'mn');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (75, 'Moldavian', 'mo');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (76, 'Marathi', 'mr');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (77, 'Malay', 'ms');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (78, 'Maltese', 'mt');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (79, 'Burmese', 'my');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (80, 'Nauru', 'na');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (81, 'Nepali', 'ne');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (82, 'Dutch', 'nl');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (83, 'Norwegian', 'no');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (84, 'Occitan', 'oc');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (85, '(Afan)/Oromoor/Oriya', 'om');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (86, 'Punjabi', 'pa');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (87, 'Polish', 'pl');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (88, 'Pashto/Pushto', 'ps');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (89, 'Portuguese', 'pt');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (90, 'Quechua', 'qu');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (91, 'Rhaeto-Romance', 'rm');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (92, 'Kirundi', 'rn');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (93, 'Romanian', 'ro');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (94, 'Russian', 'ru');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (95, 'Kinyarwanda', 'rw');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (96, 'Sanskrit', 'sa');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (97, 'Sindhi', 'sd');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (98, 'Sangro', 'sg');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (99, 'Serbo-Croatian', 'sh');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (100, 'Singhalese', 'si');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (101, 'Slovak', 'sk');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (102, 'Slovenian', 'sl');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (103, 'Samoan', 'sm');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (104, 'Shona', 'sn');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (105, 'Somali', 'so');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (106, 'Albanian', 'sq');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (107, 'Serbian', 'sr');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (108, 'Siswati', 'ss');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (109, 'Sesotho', 'st');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (110, 'Sundanese', 'su');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (111, 'Swedish', 'sv');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (112, 'Swahili', 'sw');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (113, 'Tamil', 'ta');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (114, 'Telugu', 'te');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (115, 'Tajik', 'tg');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (116, 'Thai', 'th');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (117, 'Tigrinya', 'ti');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (118, 'Turkmen', 'tk');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (119, 'Tagalog', 'tl');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (120, 'Setswana', 'tn');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (121, 'Tonga', 'to');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (122, 'Turkish', 'tr');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (123, 'Tsonga', 'ts');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (124, 'Tatar', 'tt');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (125, 'Twi', 'tw');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (126, 'Ukrainian', 'uk');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (127, 'Urdu', 'ur');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (128, 'Uzbek', 'uz');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (129, 'Vietnamese', 'vi');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (130, 'Volapuk', 'vo');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (131, 'Wolof', 'wo');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (132, 'Xhosa', 'xh');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (133, 'Yoruba', 'yo');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (134, 'Chinese', 'zh');
INSERT INTO `languages_iso` (`id`, `name`, `iso`) VALUES (135, 'Zulu', 'zu');


#
# TABLE STRUCTURE FOR: live_tv
#

DROP TABLE IF EXISTS `live_tv`;

CREATE TABLE `live_tv` (
  `live_tv_id` int(11) NOT NULL AUTO_INCREMENT,
  `tv_name` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `seo_title` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `live_tv_category_id` int(50) DEFAULT NULL,
  `slug` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `language` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT 'en',
  `stream_from` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `stream_label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `stream_url` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `poster` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `thumbnail` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `focus_keyword` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `featured` int(2) DEFAULT 1,
  `is_paid` int(5) NOT NULL DEFAULT 1,
  `tags` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `publish` int(10) unsigned DEFAULT 0,
  PRIMARY KEY (`live_tv_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `live_tv` (`live_tv_id`, `tv_name`, `seo_title`, `live_tv_category_id`, `slug`, `language`, `stream_from`, `stream_label`, `stream_url`, `poster`, `thumbnail`, `focus_keyword`, `meta_description`, `featured`, `is_paid`, `tags`, `description`, `publish`) VALUES (1, 'Military Channel', 'Military Channel', 1, 'military-channel', 'en', 'hls', 'HD', 'https://vuezat.com/live/British-Army.m3u8', 'military-channel.png', 'military-channel.png', 'British Army,Be The Best,Life Hacks,Resilience Training', 'BTB TV - Owned and operated by Ayozat, brings you the best of the British Army \r\n\r\nFrom life hacks to resilience training to fire power demonstrations to cooking and survival skills.', 1, 1, 'British Army,Be The Best, Life Hacks,Resilience Training', '<p>BTB TV - Owned and operated by Ayozat, brings you the best of the British Army</p><p>From life hacks to resilience training to fire power demonstrations to cooking and survival skills.</p>', 1);
INSERT INTO `live_tv` (`live_tv_id`, `tv_name`, `seo_title`, `live_tv_category_id`, `slug`, `language`, `stream_from`, `stream_label`, `stream_url`, `poster`, `thumbnail`, `focus_keyword`, `meta_description`, `featured`, `is_paid`, `tags`, `description`, `publish`) VALUES (2, 'Beatz Radio', 'Beatz Radio Pilatus ', 2, 'beatz-radio', 'en', 'hls', 'HD', 'https://rp_tv_1.vedge.infomaniak.com/livecast/rp_tv_1/playlist.m3u8', 'beatz-radio.png', 'beatz-radio.png', 'Live Music,Dance Music,Live Radio', 'Watch a mixup of all different music right here on Beatz', 1, 1, 'Live Music,Dance Music,Live Radio', '<p><span style=\"font-size: 13.93px;\">Watch a mixup of all different music right here on Beatz</span><br></p>', 1);


#
# TABLE STRUCTURE FOR: live_tv_category
#

DROP TABLE IF EXISTS `live_tv_category`;

CREATE TABLE `live_tv_category` (
  `live_tv_category_id` int(11) NOT NULL AUTO_INCREMENT,
  `live_tv_category` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `slug` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `live_tv_category_desc` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` int(11) DEFAULT 1,
  PRIMARY KEY (`live_tv_category_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `live_tv_category` (`live_tv_category_id`, `live_tv_category`, `slug`, `live_tv_category_desc`, `status`) VALUES (1, 'Entertainment', 'entertainment', '', 1);
INSERT INTO `live_tv_category` (`live_tv_category_id`, `live_tv_category`, `slug`, `live_tv_category_desc`, `status`) VALUES (2, 'Music', 'music', '', 1);


#
# TABLE STRUCTURE FOR: live_tv_url
#

DROP TABLE IF EXISTS `live_tv_url`;

CREATE TABLE `live_tv_url` (
  `live_tv_url_id` int(11) NOT NULL AUTO_INCREMENT,
  `stream_key` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `live_tv_id` int(11) DEFAULT NULL,
  `url_for` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `quality` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `url` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`live_tv_url_id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `live_tv_url` (`live_tv_url_id`, `stream_key`, `live_tv_id`, `url_for`, `source`, `label`, `quality`, `url`) VALUES (6, 'hhsxgfq5dido', 1, 'opt2', 'hls', 'LQ', 'LQ', '');
INSERT INTO `live_tv_url` (`live_tv_url_id`, `stream_key`, `live_tv_id`, `url_for`, `source`, `label`, `quality`, `url`) VALUES (5, 'ixtlgqy5nx3n', 1, 'opt1', 'hls', 'SD', 'SD', '');
INSERT INTO `live_tv_url` (`live_tv_url_id`, `stream_key`, `live_tv_id`, `url_for`, `source`, `label`, `quality`, `url`) VALUES (7, '55h5n4zom484', 2, 'opt1', 'hls', 'SD', 'SD', '');
INSERT INTO `live_tv_url` (`live_tv_url_id`, `stream_key`, `live_tv_id`, `url_for`, `source`, `label`, `quality`, `url`) VALUES (8, '5frpvnk7l7i3', 2, 'opt2', 'hls', 'LQ', 'LQ', '');


#
# TABLE STRUCTURE FOR: logs
#

DROP TABLE IF EXISTS `logs`;

CREATE TABLE `logs` (
  `id` int(11) NOT NULL,
  `uri` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method` varchar(6) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `params` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `api_key` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `time` int(11) NOT NULL,
  `rtime` float DEFAULT NULL,
  `authorized` varchar(1) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `response_code` smallint(3) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

#
# TABLE STRUCTURE FOR: page
#

DROP TABLE IF EXISTS `page`;

CREATE TABLE `page` (
  `page_id` int(11) NOT NULL AUTO_INCREMENT,
  `page_title` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `seo_title` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `slug` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `primary_menu` int(10) DEFAULT 0,
  `footer_menu` int(10) DEFAULT 0,
  `focus_keyword` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_description` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `publication` int(11) DEFAULT 1,
  `publish_at` datetime DEFAULT NULL,
  `deletable` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`page_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

#
# TABLE STRUCTURE FOR: plan
#

DROP TABLE IF EXISTS `plan`;

CREATE TABLE `plan` (
  `plan_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `day` int(50) DEFAULT 0,
  `screens` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `price` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`plan_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `plan` (`plan_id`, `name`, `day`, `screens`, `price`, `status`) VALUES (1, 'Basic', 7, NULL, '5', 1);
INSERT INTO `plan` (`plan_id`, `name`, `day`, `screens`, `price`, `status`) VALUES (2, 'Professional ', 30, NULL, '10', 1);
INSERT INTO `plan` (`plan_id`, `name`, `day`, `screens`, `price`, `status`) VALUES (3, 'Ultra', 90, NULL, '20', 1);


#
# TABLE STRUCTURE FOR: post_category
#

DROP TABLE IF EXISTS `post_category`;

CREATE TABLE `post_category` (
  `post_category_id` int(11) NOT NULL AUTO_INCREMENT,
  `category` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `slug` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category_desc` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`post_category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

#
# TABLE STRUCTURE FOR: post_comments
#

DROP TABLE IF EXISTS `post_comments`;

CREATE TABLE `post_comments` (
  `post_comments_id` int(20) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) NOT NULL,
  `post_id` int(20) NOT NULL,
  `comment_type` int(5) NOT NULL DEFAULT 1,
  `replay_for` int(10) DEFAULT 0,
  `comment` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `comment_at` datetime DEFAULT NULL,
  `publication` int(5) DEFAULT 1,
  PRIMARY KEY (`post_comments_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

#
# TABLE STRUCTURE FOR: posts
#

DROP TABLE IF EXISTS `posts`;

CREATE TABLE `posts` (
  `posts_id` int(11) NOT NULL AUTO_INCREMENT,
  `post_title` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `seo_title` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `slug` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `focus_keyword` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_description` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `category_id` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `image_link` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_id` int(20) DEFAULT 1,
  `post_at` datetime DEFAULT NULL,
  `publication` int(11) DEFAULT 1,
  PRIMARY KEY (`posts_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

#
# TABLE STRUCTURE FOR: quality
#

DROP TABLE IF EXISTS `quality`;

CREATE TABLE `quality` (
  `quality_id` int(10) NOT NULL AUTO_INCREMENT,
  `quality` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` int(5) DEFAULT 1,
  PRIMARY KEY (`quality_id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `quality` (`quality_id`, `quality`, `description`, `status`) VALUES (1, '4K', 'High Defination', 1);
INSERT INTO `quality` (`quality_id`, `quality`, `description`, `status`) VALUES (2, 'HD', 'Sandard Defination', 1);
INSERT INTO `quality` (`quality_id`, `quality`, `description`, `status`) VALUES (3, 'SD', 'Ultra High Defination', 1);
INSERT INTO `quality` (`quality_id`, `quality`, `description`, `status`) VALUES (4, 'CAM', 'Web Camera Video', 1);
INSERT INTO `quality` (`quality_id`, `quality`, `description`, `status`) VALUES (7, 'LQ', 'Low Quality', 1);
INSERT INTO `quality` (`quality_id`, `quality`, `description`, `status`) VALUES (8, 'DVD', 'Digital Video Device', 1);


#
# TABLE STRUCTURE FOR: rating
#

DROP TABLE IF EXISTS `rating`;

CREATE TABLE `rating` (
  `rating_id` int(50) NOT NULL AUTO_INCREMENT,
  `video_id` int(11) NOT NULL,
  `ip` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `rating` int(5) DEFAULT NULL,
  `datetime` datetime DEFAULT NULL,
  PRIMARY KEY (`rating_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

#
# TABLE STRUCTURE FOR: report
#

DROP TABLE IF EXISTS `report`;

CREATE TABLE `report` (
  `report_id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `id` int(50) DEFAULT NULL,
  `issue` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `report_datetime` datetime DEFAULT current_timestamp(),
  `message` text COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT 'pending',
  PRIMARY KEY (`report_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `report` (`report_id`, `type`, `id`, `issue`, `report_datetime`, `message`, `status`) VALUES (1, 'movie', 2, '1- Subtitle Missing Subtitle<br>', '2020-12-14 20:13:36', NULL, 'pending');


#
# TABLE STRUCTURE FOR: request
#

DROP TABLE IF EXISTS `request`;

CREATE TABLE `request` (
  `request_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `email` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `movie_name` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `request_datetime` datetime DEFAULT current_timestamp(),
  `status` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT 'pending',
  PRIMARY KEY (`request_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `request` (`request_id`, `name`, `email`, `movie_name`, `message`, `request_datetime`, `status`) VALUES (1, 'Lazar Andjelkovic', 'comandossis95@gmail.com', 'lazar', 'TEST', '2020-12-09 22:37:08', 'pending');


#
# TABLE STRUCTURE FOR: rest_logins
#

DROP TABLE IF EXISTS `rest_logins`;

CREATE TABLE `rest_logins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `password` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `rest_logins` (`id`, `username`, `password`, `status`) VALUES (1, 'admin', 'a8818ffe4624284', 1);


#
# TABLE STRUCTURE FOR: seasons
#

DROP TABLE IF EXISTS `seasons`;

CREATE TABLE `seasons` (
  `seasons_id` int(11) NOT NULL AUTO_INCREMENT,
  `videos_id` int(11) DEFAULT NULL,
  `seasons_name` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order` int(50) NOT NULL DEFAULT 0,
  `publish` int(11) DEFAULT 1,
  PRIMARY KEY (`seasons_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `seasons` (`seasons_id`, `videos_id`, `seasons_name`, `order`, `publish`) VALUES (1, 3, 'Season 1', 0, 1);
INSERT INTO `seasons` (`seasons_id`, `videos_id`, `seasons_name`, `order`, `publish`) VALUES (2, 4, 'Season 1', 0, 1);


#
# TABLE STRUCTURE FOR: slider
#

DROP TABLE IF EXISTS `slider`;

CREATE TABLE `slider` (
  `slider_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `description` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `video_link` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `image_link` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `slug` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action_type` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `action_btn_text` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `action_id` int(50) DEFAULT NULL,
  `action_url` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order` int(50) NOT NULL DEFAULT 0,
  `publication` int(1) NOT NULL,
  PRIMARY KEY (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `slider` (`slider_id`, `title`, `description`, `video_link`, `image_link`, `slug`, `action_type`, `action_btn_text`, `action_id`, `action_url`, `order`, `publication`) VALUES (2, '.', '', '', 'https://ayozattest.com/uploads/sliders/slider-2.jpg', '', 'webview', 'Play', NULL, '', 0, 1);
INSERT INTO `slider` (`slider_id`, `title`, `description`, `video_link`, `image_link`, `slug`, `action_type`, `action_btn_text`, `action_id`, `action_url`, `order`, `publication`) VALUES (3, 'Gaming', 'Live competitive gaming & Esports', '', 'https://ayozattest.com/uploads/sliders/slider-3.jpg', 'gaming', 'webview', 'Play', NULL, 'https://ayozat.com/live-tv/gaming.html', 0, 1);
INSERT INTO `slider` (`slider_id`, `title`, `description`, `video_link`, `image_link`, `slug`, `action_type`, `action_btn_text`, `action_id`, `action_url`, `order`, `publication`) VALUES (4, 'Music', '', '', 'https://ayozattest.com/uploads/sliders/slider-4.jpg', 'music', 'webview', 'Play', NULL, 'https://ayozat.com/live-tv/ayo.html', 0, 1);
INSERT INTO `slider` (`slider_id`, `title`, `description`, `video_link`, `image_link`, `slug`, `action_type`, `action_btn_text`, `action_id`, `action_url`, `order`, `publication`) VALUES (5, 'Sport', '', '', 'https://ayozattest.com/uploads/sliders/slider-5.jpg', 'sport', 'webview', 'Play', NULL, 'https://ayozat.com', 0, 1);
INSERT INTO `slider` (`slider_id`, `title`, `description`, `video_link`, `image_link`, `slug`, `action_type`, `action_btn_text`, `action_id`, `action_url`, `order`, `publication`) VALUES (6, '.', '', '', 'https://ayozattest.com/uploads/sliders/slider-6.jpg', '', 'webview', 'Play', NULL, 'https://ayozat.com/live-tv/gaming.html', 0, 1);


#
# TABLE STRUCTURE FOR: star
#

DROP TABLE IF EXISTS `star`;

CREATE TABLE `star` (
  `star_id` int(10) NOT NULL AUTO_INCREMENT,
  `star_type` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `star_name` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `star_desc` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `view` int(11) NOT NULL DEFAULT 1,
  `status` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`star_id`)
) ENGINE=MyISAM AUTO_INCREMENT=182 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (1, 'actor', 'Oliver Norvell Hardy', 'oliver-norvell-hardy', 'Oliver Norvell Hardy (born Norvell Hardy, January 18, 1892 – August 7, 1957) was an American comic actor and one half of Laurel and Hardy, the double act that began in the era of silent films and lasted from 1927 to 1955. He appeared with his comedy partner Stan Laurel in 107 short films, feature films, and cameo roles. He was credited with his first film, Outwitting Dad, in 1914. In most of his silent films before joining producer Hal Roach, he was billed on screen as Babe Hardy.', 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (2, 'actor', 'Larry Semon', 'larry-semon', 'Lawrence \"Larry\" Semon (February 9, 1889 – October 8, 1928) was an American actor, director, producer, and screenwriter during the silent film era. In his day, Semon was considered a major movie comedian, but he is now remembered mainly for working with both Stan Laurel and Oliver Hardy before they started working together.  He is also sometimes noted for directing (as well as appearing in) the 1925 silent film The Wizard of Oz, which had a slight influence on the better-known 1939 talkie The Wizard of Oz released by MGM. The film was included in the 2005 three-disc DVD version of the 1939 film, along with other silent Oz movies.', 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (3, 'director', 'Norman Taurog', 'norman-taurog', 'Norman Rae Taurog (February 23, 1899 – April 7, 1981) was an American film director and screenwriter. From 1920 to 1968, Taurog directed 180 films. At the age of 32, he received the Academy Award for Best Director for Skippy (1931). He is the second youngest person ever to win the award after Damien Chazelle, who won for La La Land in 2017. He was later nominated for Best Director for the film Boys Town (1938). He directed some of the best-known actors of the twentieth century, including his nephew Jackie Cooper, Spencer Tracy, Mickey Rooney, Judy Garland, Deanna Durbin, Fred Astaire, Gene Kelly, Deborah Kerr, Peter Lawford, Dean Martin, Jerry Lewis, and Elvis Presley. Taurog directed six Martin and Lewis films, and nine Elvis Presley films, more than any other director. For his contribution to the motion picture industry, Norman Taurog has a star on the Hollywood Walk of Fame at 1600 Vine Street.', 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (21, 'actor', 'Matthew Turner', 'matthew-turner', '', 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (5, 'actor', 'Frank Alexander', 'frank-alexander', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (6, 'actor', 'Lucille Carlisle', 'lucille-carlisle', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (7, 'actor', 'Betty Young', 'betty-young', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (8, 'actor', 'Alice Davenport', 'alice-davenport', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (9, 'actor', 'Al Thompson', 'al-thompson', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (10, 'actor', 'Pete Gordon', 'pete-gordon', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (11, 'actor', 'Frank J. Coleman', 'frank-j-coleman', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (12, 'actor', 'Jack Miller', 'jack-miller', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (13, 'actor', 'Grover Ligon', 'grover-ligon', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (14, 'actor', 'William Hauber', 'william-hauber', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (15, 'actor', 'Coy Watson Jr.', 'coy-watson-jr', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (16, 'actor', 'Ernie Adams', 'ernie-adams', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (17, 'actor', 'Madame Sul-Te-Wan', 'madame-sul-te-wan', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (18, 'actor', 'Hans F. Koenekamp', 'hans-f-koenekamp', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (19, 'actor', 'Albert E. Smith', 'albert-e-smith', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (20, 'actor', 'Roland Asher', 'roland-asher', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (22, 'director', 'Umesh Perera', 'umesh-perera', '', 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (23, 'actor', 'Lucas Darella', 'lucas-darella', '', 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (24, 'director', 'Eddie Donnelly', 'eddie-donnelly', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (25, 'writer', 'John Foster', 'john-foster', '', 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (26, 'actor', 'Janet Gaynor', 'janet-gaynor', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (27, 'actor', 'Fredric March', 'fredric-march', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (28, 'actor', 'Adolphe Menjou', 'adolphe-menjou', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (29, 'actor', 'May Robson', 'may-robson', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (30, 'actor', 'Andy Devine', 'andy-devine', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (31, 'actor', 'Lionel Stander', 'lionel-stander', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (32, 'actor', 'Owen Moore', 'owen-moore', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (33, 'actor', 'Peggy Wood', 'peggy-wood', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (34, 'actor', 'Elizabeth Jenns', 'elizabeth-jenns', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (35, 'actor', 'Edgar Kennedy', 'edgar-kennedy', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (36, 'actor', 'J. C. Nugent', 'j-c-nugent', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (37, 'actor', 'Guinn Williams', 'guinn-williams', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (38, 'actor', 'Irving Bacon', 'irving-bacon', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (39, 'actor', 'Jane Barnes', 'jane-barnes', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (40, 'actor', 'Clara Blandick', 'clara-blandick', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (41, 'actor', 'Wade Boteler', 'wade-boteler', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (42, 'actor', 'Sidney Bracey', 'sidney-bracey', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (43, 'actor', 'Harry C. Bradley', 'harry-c-bradley', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (44, 'actor', 'George Chandler', 'george-chandler', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (45, 'actor', 'Pat Flaherty', 'pat-flaherty', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (46, 'actor', 'Francis Ford', 'francis-ford', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (47, 'actor', 'Joe Gray', 'joe-gray', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (48, 'actor', 'Jonathan Hale', 'jonathan-hale', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (49, 'actor', 'Chuck Hamilton', 'chuck-hamilton', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (50, 'actor', 'Lillian Harmer', 'lillian-harmer', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (51, 'actor', 'Edward Hearn', 'edward-hearn', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (52, 'actor', 'I. Stanford Jolley', 'i-stanford-jolley', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (53, 'actor', 'Carole Landis', 'carole-landis', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (54, 'actor', 'Chris-Pin Martin', 'chris-pin-martin', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (55, 'actor', 'Edwin Maxwell', 'edwin-maxwell', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (56, 'actor', 'Marshall Neilan', 'marshall-neilan', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (57, 'actor', 'David Newell', 'david-newell', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (58, 'actor', 'Robert Emmett O\'Connor', 'robert-emmett-oconnor', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (59, 'actor', 'Dennis O\'Keefe', 'dennis-okeefe', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (60, 'actor', 'Franklin Pangborn', 'franklin-pangborn', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (61, 'actor', 'Jed Prouty', 'jed-prouty', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (62, 'actor', 'Tom Ricketts', 'tom-ricketts', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (63, 'actor', 'Paul Stanton', 'paul-stanton', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (64, 'actor', 'Fred \'Snowflake\' Toones', 'fred-snowflake-toones', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (65, 'actor', 'Clarence Wilson', 'clarence-wilson', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (66, 'actor', 'David O. Selznick', 'david-o-selznick', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (67, 'actor', 'Lyle R. Wheeler', 'lyle-r-wheeler', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (68, 'actor', 'Max Steiner', 'max-steiner', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (69, 'writer', 'Ben Hecht', 'ben-hecht', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (70, 'director', 'William A. Wellman', 'william-a-wellman', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (71, 'writer', 'Dorothy Parker', 'dorothy-parker', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (72, 'writer', 'Alan Campbell', 'alan-campbell', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (73, 'writer', 'Robert Carson', 'robert-carson', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (74, 'actor', 'James E. Newcom', 'james-e-newcom', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (75, 'actor', 'W. Howard Greene', 'w-howard-greene', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (76, 'actor', 'Val Lewton', 'val-lewton', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (77, 'actor', 'Hal C. Kern', 'hal-c-kern', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (78, 'actor', 'Omar Kiam', 'omar-kiam', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (79, 'actor', 'Lansing C. Holden', 'lansing-c-holden', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (80, 'actor', 'Charles Richards', 'charles-richards', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (81, 'actor', 'Anson Stevenson', 'anson-stevenson', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (82, 'actor', 'Jamie Stewart', 'jamie-stewart', '', 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (83, 'actor', 'Roscoe \'Fatty\' Arbuckle', 'roscoe-fatty-arbuckle', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (84, 'actor', 'Minta Durfee', 'minta-durfee', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (85, 'actor', 'Charlie Chaplin', 'charlie-chaplin', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (86, 'actor', 'Frank Opperman', 'frank-opperman', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (87, 'actor', 'Al St. John', 'al-st-john', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (88, 'actor', 'Hank Mann', 'hank-mann', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (89, 'actor', 'Mack Swain', 'mack-swain', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (90, 'actor', 'Dan Albert', 'dan-albert', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (91, 'actor', 'Charles Avery', 'charles-avery', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (92, 'actor', 'Joe Bordeaux', 'joe-bordeaux', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (93, 'actor', 'Glen Cavender', 'glen-cavender', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (94, 'actor', 'Charley Chase', 'charley-chase', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (95, 'actor', 'Edward F. Cline', 'edward-f-cline', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (96, 'actor', 'Frank Dolan', 'frank-dolan', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (97, 'actor', 'Edwin Frazee', 'edwin-frazee', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (98, 'actor', 'Alice Howell', 'alice-howell', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (99, 'actor', 'Charles Lakin', 'charles-lakin', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (100, 'actor', 'Wallace MacDonald', 'wallace-macdonald', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (101, 'actor', 'Harry McCoy', 'harry-mccoy', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (102, 'actor', 'Rube Miller', 'rube-miller', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (103, 'actor', 'Edward Nolan', 'edward-nolan', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (104, 'actor', 'Mack Sennett', 'mack-sennett', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (105, 'actor', 'Ford Sterling', 'ford-sterling', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (106, 'actor', 'Slim Summerville', 'slim-summerville', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (107, 'actor', 'Billy Gilbert', 'billy-gilbert', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (108, 'actor', 'Frank D. Williams', 'frank-d-williams', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (109, 'actor', 'Walter Huston', 'walter-huston', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (110, 'actor', 'Una Merkel', 'una-merkel', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (111, 'actor', 'William L. Thorne', 'william-l-thorne', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (112, 'actor', 'Lucille La Verne', 'lucille-la-verne', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (113, 'actor', 'Helen Freeman', 'helen-freeman', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (114, 'actor', 'Otto Hoffman', 'otto-hoffman', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (115, 'actor', 'Edgar Dearing', 'edgar-dearing', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (116, 'actor', 'Russell Simpson', 'russell-simpson', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (117, 'actor', 'Charles Crockett', 'charles-crockett', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (118, 'actor', 'Kay Hammond', 'kay-hammond', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (119, 'actor', 'Helen Ware', 'helen-ware', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (120, 'actor', 'E. Alyn Warren', 'e-alyn-warren', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (121, 'actor', 'Jason Robards Sr.', 'jason-robards-sr', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (122, 'actor', 'Gordon Thorpe', 'gordon-thorpe', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (123, 'actor', 'Ian Keith', 'ian-keith', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (124, 'actor', 'Cameron Prud\'Homme', 'cameron-prudhomme', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (125, 'actor', 'James Bradbury Sr.', 'james-bradbury-sr', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (126, 'actor', 'James Eagles', 'james-eagles', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (127, 'actor', 'Oscar Apfel', 'oscar-apfel', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (128, 'actor', 'Frank Campeau', 'frank-campeau', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (129, 'actor', 'Hobart Bosworth', 'hobart-bosworth', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (130, 'actor', 'Henry B. Walthall', 'henry-b-walthall', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (131, 'actor', 'Hank Bell', 'hank-bell', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (132, 'actor', 'Maurice Black', 'maurice-black', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (133, 'actor', 'Ed Brady', 'ed-brady', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (134, 'actor', 'Robert Brower', 'robert-brower', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (135, 'actor', 'Kernan Cripps', 'kernan-cripps', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (136, 'actor', 'Mary Forbes', 'mary-forbes', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (137, 'actor', 'Robert Homans', 'robert-homans', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (138, 'actor', 'Jane Keckley', 'jane-keckley', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (139, 'actor', 'Robert Keith', 'robert-keith', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (140, 'actor', 'Henry Kolker', 'henry-kolker', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (141, 'actor', 'Ralph Lewis', 'ralph-lewis', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (142, 'actor', 'George MacQuarrie', 'george-macquarrie', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (143, 'actor', 'Scott Seaton', 'scott-seaton', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (144, 'actor', 'Carl Stockdale', 'carl-stockdale', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (145, 'actor', 'Harry Stubbs', 'harry-stubbs', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (146, 'actor', 'Kathrin Clare Ward', 'kathrin-clare-ward', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (147, 'actor', 'James Smith', 'james-smith', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (148, 'director', 'D. W. Griffith', 'd-w-griffith', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (149, 'actor', 'Hugo Riesenfeld', 'hugo-riesenfeld', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (150, 'actor', 'Karl Struss', 'karl-struss', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (151, 'actor', 'Walter J. Israel', 'walter-j-israel', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (152, 'actor', 'William Cameron Menzies', 'william-cameron-menzies', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (153, 'writer', 'Stephen Vincent Benét', 'stephen-vincent-bent', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (154, 'writer', 'John W. Considine Jr.', 'john-w-considine-jr', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (155, 'actor', 'Orville O. Dull', 'orville-o-dull', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (156, 'writer', 'Gerrit J. Lloyd', 'gerrit-j-lloyd', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (157, 'actor', 'Harold Witt', 'harold-witt', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (158, 'actor', 'Raymond A. Klune', 'raymond-a-klune', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (159, 'actor', 'Herbert Sutch', 'herbert-sutch', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (160, 'actor', 'Vivian Blaine', 'vivian-blaine', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (161, 'actor', 'Perry Como', 'perry-como', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (162, 'actor', 'Carmen Miranda', 'carmen-miranda', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (163, 'actor', 'Martha Stewart', 'martha-stewart', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (164, 'actor', 'Stephen Dunne', 'stephen-dunne', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (165, 'actor', 'Reed Hadley', 'reed-hadley', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (166, 'actor', 'Stanley Prager', 'stanley-prager', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (167, 'actor', 'Charles Tannen', 'charles-tannen', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (168, 'actor', 'George E. Stone', 'george-e-stone', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (169, 'actor', 'Frank Orth', 'frank-orth', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (170, 'actor', 'Donald MacBride', 'donald-macbride', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (171, 'actor', 'Lex Barker', 'lex-barker', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (172, 'actor', 'Alvin Hammer', 'alvin-hammer', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (173, 'actor', 'Boris Leven', 'boris-leven', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (174, 'actor', 'Joseph LaShelle', 'joseph-lashelle', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (175, 'actor', 'Thomas Little', 'thomas-little', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (176, 'writer', 'Leonard Praskins', 'leonard-praskins', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (177, 'actor', 'Bryan Foy', 'bryan-foy', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (178, 'writer', 'Gypsy Rose Lee', 'gypsy-rose-lee', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (179, 'director', 'Lewis Seiler', 'lewis-seiler', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (180, 'actor', 'Norman Colbert', 'norman-colbert', NULL, 1, 1);
INSERT INTO `star` (`star_id`, `star_type`, `star_name`, `slug`, `star_desc`, `view`, `status`) VALUES (181, 'actor', 'Yvonne Wood', 'yvonne-wood', NULL, 1, 1);


#
# TABLE STRUCTURE FOR: subscription
#

DROP TABLE IF EXISTS `subscription`;

CREATE TABLE `subscription` (
  `subscription_id` int(50) NOT NULL AUTO_INCREMENT,
  `plan_id` int(50) NOT NULL,
  `user_id` int(50) NOT NULL,
  `price_amount` double NOT NULL,
  `paid_amount` float NOT NULL,
  `currency` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT 'USD',
  `timestamp_from` int(50) NOT NULL,
  `timestamp_to` int(50) NOT NULL,
  `payment_method` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `transaction_id` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_info` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `payment_timestamp` int(50) NOT NULL,
  `recurring` int(10) NOT NULL DEFAULT 1,
  `status` int(5) NOT NULL DEFAULT 1,
  PRIMARY KEY (`subscription_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

#
# TABLE STRUCTURE FOR: subtitle
#

DROP TABLE IF EXISTS `subtitle`;

CREATE TABLE `subtitle` (
  `subtitle_id` int(11) NOT NULL AUTO_INCREMENT,
  `videos_id` int(50) NOT NULL,
  `video_file_id` int(50) DEFAULT NULL,
  `language` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `kind` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `src` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `srclang` varchar(5) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `common` int(2) DEFAULT 0,
  `status` int(2) DEFAULT 1,
  PRIMARY KEY (`subtitle_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

#
# TABLE STRUCTURE FOR: tvseries_subtitle
#

DROP TABLE IF EXISTS `tvseries_subtitle`;

CREATE TABLE `tvseries_subtitle` (
  `tvseries_subtitle_id` int(11) NOT NULL AUTO_INCREMENT,
  `videos_id` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `episodes_id` int(250) DEFAULT NULL,
  `language` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `kind` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `src` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `srclang` varchar(5) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `common` int(2) DEFAULT 0,
  `status` int(2) DEFAULT 1,
  PRIMARY KEY (`tvseries_subtitle_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

#
# TABLE STRUCTURE FOR: user
#

DROP TABLE IF EXISTS `user`;

CREATE TABLE `user` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `slug` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `username` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `email` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_password_set` int(5) NOT NULL DEFAULT 0 COMMENT '0 = unknown, 1=set, 2 =unset',
  `password` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `gender` int(2) DEFAULT 1,
  `role` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `token` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `theme` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT 'default',
  `theme_color` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT '#16163F',
  `join_date` datetime DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `deactivate_reason` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `dob` date DEFAULT '0000-00-00',
  `firebase_auth_uid` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` int(10) NOT NULL DEFAULT 1,
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `user` (`user_id`, `name`, `slug`, `username`, `email`, `is_password_set`, `password`, `gender`, `role`, `token`, `theme`, `theme_color`, `join_date`, `last_login`, `deactivate_reason`, `phone`, `dob`, `firebase_auth_uid`, `status`) VALUES (1, 'Lazar Andjelkovic', '', 'lazar@ayozat.co.uk', 'lazar@ayozat.co.uk', 0, '619a098f150b34c49a8a8eac5ae23fa6', 1, 'admin', NULL, 'default', '#16163F', '2020-02-26 12:57:18', '2021-01-17 20:43:06', NULL, '', '0000-00-00', NULL, 1);
INSERT INTO `user` (`user_id`, `name`, `slug`, `username`, `email`, `is_password_set`, `password`, `gender`, `role`, `token`, `theme`, `theme_color`, `join_date`, `last_login`, `deactivate_reason`, `phone`, `dob`, `firebase_auth_uid`, `status`) VALUES (2, 'Lazar', '', 'lazarhytale@gmail.com', 'lazarhytale@gmail.com', 0, '619a098f150b34c49a8a8eac5ae23fa6', 1, 'subscriber', NULL, 'default', '#16163F', '2020-12-16 03:14:47', '2020-12-18 21:21:53', NULL, NULL, '0000-00-00', NULL, 1);


#
# TABLE STRUCTURE FOR: video_file
#

DROP TABLE IF EXISTS `video_file`;

CREATE TABLE `video_file` (
  `video_file_id` int(11) NOT NULL AUTO_INCREMENT,
  `stream_key` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `videos_id` int(11) DEFAULT NULL,
  `file_source` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `source_type` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `file_url` varchar(500) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `label` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Server#1',
  `order` int(50) NOT NULL DEFAULT 0,
  PRIMARY KEY (`video_file_id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `video_file` (`video_file_id`, `stream_key`, `videos_id`, `file_source`, `source_type`, `file_url`, `label`, `order`) VALUES (1, 'g10yhizgq9fw', 1, 'embed', 'link', 'https://player.vimeo.com/video/391779895', 'Server #1', 1);
INSERT INTO `video_file` (`video_file_id`, `stream_key`, `videos_id`, `file_source`, `source_type`, `file_url`, `label`, `order`) VALUES (2, 'i855h4hbs89h', 2, 'embed', 'link', 'https://player.vimeo.com/video/385565822	', 'Server #1', 1);
INSERT INTO `video_file` (`video_file_id`, `stream_key`, `videos_id`, `file_source`, `source_type`, `file_url`, `label`, `order`) VALUES (3, 'by9in0n3d184', 5, 'embed', 'link', 'https://player.vimeo.com/video/375729235', 'The Show', 0);
INSERT INTO `video_file` (`video_file_id`, `stream_key`, `videos_id`, `file_source`, `source_type`, `file_url`, `label`, `order`) VALUES (4, 'n6ox1umhtzww', 6, 'embed', 'link', 'https://player.vimeo.com/video/391779895', 'Server#1', 0);
INSERT INTO `video_file` (`video_file_id`, `stream_key`, `videos_id`, `file_source`, `source_type`, `file_url`, `label`, `order`) VALUES (5, 'f87x2dmcc2kj', 7, 'embed', 'link', 'https://player.vimeo.com/video/377854175', 'Server#1', 0);
INSERT INTO `video_file` (`video_file_id`, `stream_key`, `videos_id`, `file_source`, `source_type`, `file_url`, `label`, `order`) VALUES (6, '9v1ep9o17h21', 8, 'embed', 'link', 'https://player.vimeo.com/video/352484527', 'Server#1', 0);
INSERT INTO `video_file` (`video_file_id`, `stream_key`, `videos_id`, `file_source`, `source_type`, `file_url`, `label`, `order`) VALUES (7, 'ed1w3odx1yeg', 9, 'embed', 'link', 'https://player.vimeo.com/video/363803328', 'Server#1', 0);
INSERT INTO `video_file` (`video_file_id`, `stream_key`, `videos_id`, `file_source`, `source_type`, `file_url`, `label`, `order`) VALUES (8, 'q2sik7gyib9i', 10, 'embed', 'link', 'https://player.vimeo.com/video/459001901', 'Server#1', 0);
INSERT INTO `video_file` (`video_file_id`, `stream_key`, `videos_id`, `file_source`, `source_type`, `file_url`, `label`, `order`) VALUES (9, 'ujkdggy6n5p4', 11, 'embed', 'link', 'https://player.vimeo.com/video/375709512', 'Server#1', 0);
INSERT INTO `video_file` (`video_file_id`, `stream_key`, `videos_id`, `file_source`, `source_type`, `file_url`, `label`, `order`) VALUES (10, '5brdlajyzni7', 12, 'embed', 'link', 'https://player.vimeo.com/video/361649036', 'Server#1', 0);
INSERT INTO `video_file` (`video_file_id`, `stream_key`, `videos_id`, `file_source`, `source_type`, `file_url`, `label`, `order`) VALUES (11, '206nbz7bco2w', 13, 'embed', 'link', 'https://player.vimeo.com/video/363807193', 'Server#1', 0);


#
# TABLE STRUCTURE FOR: video_type
#

DROP TABLE IF EXISTS `video_type`;

CREATE TABLE `video_type` (
  `video_type_id` int(11) NOT NULL AUTO_INCREMENT,
  `video_type` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `video_type_desc` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `primary_menu` int(11) DEFAULT NULL,
  `footer_menu` int(11) DEFAULT NULL,
  `slug` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`video_type_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `video_type` (`video_type_id`, `video_type`, `video_type_desc`, `primary_menu`, `footer_menu`, `slug`) VALUES (1, 'Trending', '', NULL, NULL, 'trending');
INSERT INTO `video_type` (`video_type_id`, `video_type`, `video_type_desc`, `primary_menu`, `footer_menu`, `slug`) VALUES (2, 'Trending2', '', NULL, NULL, 'trending2');


#
# TABLE STRUCTURE FOR: videos
#

DROP TABLE IF EXISTS `videos`;

CREATE TABLE `videos` (
  `videos_id` int(11) NOT NULL AUTO_INCREMENT,
  `imdbid` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `title` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `seo_title` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `slug` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `stars` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `director` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `writer` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `rating` varchar(5) COLLATE utf8mb4_unicode_520_ci DEFAULT '0',
  `release` varchar(25) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `country` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `genre` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `video_type` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `runtime` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `video_quality` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT 'HD',
  `is_paid` int(5) NOT NULL DEFAULT 1,
  `publication` int(5) DEFAULT NULL,
  `trailer` int(5) DEFAULT 0,
  `trailler_youtube_source` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `enable_download` int(5) DEFAULT 1,
  `focus_keyword` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_description` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tags` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `imdb_rating` varchar(5) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_tvseries` int(11) NOT NULL DEFAULT 0,
  `total_rating` int(50) DEFAULT 1,
  `today_view` int(250) DEFAULT 0,
  `weekly_view` int(250) DEFAULT 0,
  `monthly_view` int(250) DEFAULT 0,
  `total_view` int(250) DEFAULT 1,
  `last_ep_added` datetime DEFAULT '2019-04-04 00:00:00',
  PRIMARY KEY (`videos_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `videos` (`videos_id`, `imdbid`, `title`, `seo_title`, `slug`, `description`, `stars`, `director`, `writer`, `rating`, `release`, `country`, `genre`, `video_type`, `runtime`, `video_quality`, `is_paid`, `publication`, `trailer`, `trailler_youtube_source`, `enable_download`, `focus_keyword`, `meta_description`, `tags`, `imdb_rating`, `is_tvseries`, `total_rating`, `today_view`, `weekly_view`, `monthly_view`, `total_view`, `last_ep_added`) VALUES (2, '', 'DJ Exposure Live at El Dorado Festival', 'DJ Exposure Live at El Dorado Festival', 'dj-exposure-live-at-el-dorado-festival', '<p>Listen to this recorded set by DJ Exposure\'s live show at&nbsp;EL DORADO FESTIVAL<br></p>', '', NULL, NULL, '0', '2020-12-14', NULL, '15', NULL, '90 mins', 'HD', 0, 1, 0, '', 0, 'DJ Set,DJ Exposure,El Dorado Festival,Live Show', 'Listen to this recorded set by DJ Exposure\'s live show at EL DORADO FESTIVAL', '', '', 0, 1, 63, 63, 63, 64, '2019-04-04 00:00:00');
INSERT INTO `videos` (`videos_id`, `imdbid`, `title`, `seo_title`, `slug`, `description`, `stars`, `director`, `writer`, `rating`, `release`, `country`, `genre`, `video_type`, `runtime`, `video_quality`, `is_paid`, `publication`, `trailer`, `trailler_youtube_source`, `enable_download`, `focus_keyword`, `meta_description`, `tags`, `imdb_rating`, `is_tvseries`, `total_rating`, `today_view`, `weekly_view`, `monthly_view`, `total_view`, `last_ep_added`) VALUES (3, '', 'DEndZ', '', 'dendz', '<p style=\"margin-right: 0px; margin-bottom: 10px; margin-left: 0px; font-family: \" open=\"\" sans\",=\"\" sans-serif;\"=\"\">Rising UK Hip Hop talent from rappers to producers, DEndz showcases the very best of British urban music</p><p style=\"margin-right: 0px; margin-bottom: 10px; margin-left: 0px; font-family: \" open=\"\" sans\",=\"\" sans-serif;\"=\"\"><br style=\"color: rgb(214, 212, 212); background-color: rgb(19, 19, 19);\"></p>', '', NULL, NULL, '0', '2020-12-14', NULL, '15', NULL, '', 'HD', 0, 1, 0, '', 0, 'Urban Hip Hop,Grime,UK Hip Hop,Music Series', '                Rising UK Hip Hop talent from rappers to producers, DEndz showcases the very best of British urban music            ', 'Urban Hip Hop,Grime,UK Hip Hop,Music Series', '', 1, 1, 14, 14, 14, 15, '2021-01-17 00:43:43');
INSERT INTO `videos` (`videos_id`, `imdbid`, `title`, `seo_title`, `slug`, `description`, `stars`, `director`, `writer`, `rating`, `release`, `country`, `genre`, `video_type`, `runtime`, `video_quality`, `is_paid`, `publication`, `trailer`, `trailler_youtube_source`, `enable_download`, `focus_keyword`, `meta_description`, `tags`, `imdb_rating`, `is_tvseries`, `total_rating`, `today_view`, `weekly_view`, `monthly_view`, `total_view`, `last_ep_added`) VALUES (4, '', 'Rivalry.gg Rising Stars - Windigo vs x6tence Galaxy', 'Rivalry.gg Rising Stars - Windigo vs x6tence Galaxy', 'rivalrygg-rising-stars-windigo-vs-x6tence-galaxy', '<p>An amazing best of 3 by Windigo vs x6tence Galaxy. Watch two great esports teams battle it out in an intense 5v5 match up and see who will be crowned champion.</p><p><br></p>', '', NULL, NULL, '0', '2020-12-14', NULL, NULL, NULL, '', 'HD', 0, 1, 0, '', 0, 'Esports,Gaming,CSGO', 'An amazing best of 3 by Windigo vs x6tence Galaxy. Watch two great esports teams battle it out in an intense 5v5 match up and see who will be crowned champion.\r\n\r\n', 'Esports,Gaming,CSGO', '', 1, 1, 12, 12, 12, 13, '2020-12-14 19:13:49');
INSERT INTO `videos` (`videos_id`, `imdbid`, `title`, `seo_title`, `slug`, `description`, `stars`, `director`, `writer`, `rating`, `release`, `country`, `genre`, `video_type`, `runtime`, `video_quality`, `is_paid`, `publication`, `trailer`, `trailler_youtube_source`, `enable_download`, `focus_keyword`, `meta_description`, `tags`, `imdb_rating`, `is_tvseries`, `total_rating`, `today_view`, `weekly_view`, `monthly_view`, `total_view`, `last_ep_added`) VALUES (5, '', 'The Show', 'The Show', 'the-show', '<p><span style=\"font-family: sans-serif;\">The Show</span><span style=\"font-family: sans-serif;\">&nbsp;is a 1922 American silent short comedy film</span><span style=\"font-family: sans-serif;\">&nbsp;directed by Larry Semon</span><span style=\"font-family: sans-serif;\">&nbsp;and Norman Taurog</span><span style=\"font-family: sans-serif;\">&nbsp;and featuring Oliver Hardy</span><span style=\"font-family: sans-serif;\">.</span><br></p>', '1,2,5,6,7,8,9,10,11,12,13,14,15,16,17', '20,2,3', '2,3', '0', '1922-03-19', '3', '1,7', NULL, '25 Mins', 'SD', 0, 1, 0, '', 0, 'shortfilm,silentfilm,comedy,action,1922,the show', '                                                                                                The Show is a 1922 American silent short comedy film directed by Larry Semon and Norman Taurog and featuring Oliver Hardy.                                                                        ', 'the show,1922,comedy,action,silent film,movies,short film,larry semon,oliver hardy,silent short comedy film', '6.5', 0, 1, 11, 11, 11, 12, '2019-04-04 00:00:00');
INSERT INTO `videos` (`videos_id`, `imdbid`, `title`, `seo_title`, `slug`, `description`, `stars`, `director`, `writer`, `rating`, `release`, `country`, `genre`, `video_type`, `runtime`, `video_quality`, `is_paid`, `publication`, `trailer`, `trailler_youtube_source`, `enable_download`, `focus_keyword`, `meta_description`, `tags`, `imdb_rating`, `is_tvseries`, `total_rating`, `today_view`, `weekly_view`, `monthly_view`, `total_view`, `last_ep_added`) VALUES (6, '', '2019 London Youth Boxing Challenge', '2019 London Youth Boxing Challenge', '2019-london-youth-boxing-challenge-6', '<p>An Ayozat Film: Royal Fusiliers Vs Metropolitan Police</p><p>Knife crime is on the rise in United Kingdom, reaching epidemic proportions.</p><p>The British Army and the Metropolitan Police bring you boxing clubs from around London, combatting #knifecrime and to celebrate youth talent...</p>', '21', '22,23', '', '0', '2021-01-15', NULL, '62,63', NULL, '48 Mins', 'HD', 0, 1, 0, '', 0, 'boxing,sports,knifefree,antiknifecrime,RoyalRegimentOfFusillers,MetropolitanPolice,BritishArmy', '                                An Ayozat Film: Royal Fusiliers Vs Metropolitan Police\r\n\r\nKnife crime is on the rise in United Kingdom, reaching epidemic proportions.\r\n\r\nThe British Army and the Metropolitan Police bring you boxing clubs from around London, combatting #knifecrime and to celebrate youth talent...                        ', 'boxing,sports,knifefree,antiknifecrime,royalregimentoffusillers,metropolitanpolice,britisharmy', '', 0, 1, 3, 3, 3, 4, '2019-04-04 00:00:00');
INSERT INTO `videos` (`videos_id`, `imdbid`, `title`, `seo_title`, `slug`, `description`, `stars`, `director`, `writer`, `rating`, `release`, `country`, `genre`, `video_type`, `runtime`, `video_quality`, `is_paid`, `publication`, `trailer`, `trailler_youtube_source`, `enable_download`, `focus_keyword`, `meta_description`, `tags`, `imdb_rating`, `is_tvseries`, `total_rating`, `today_view`, `weekly_view`, `monthly_view`, `total_view`, `last_ep_added`) VALUES (7, '', 'Mighty Mouse and the Wolf', 'Mighty Mouse and the Wolf', 'mighty-mouse-and-the-wolf', '<p>A Terrytoons cartoon released 20 July 1945. A twisted version of some famous fairy tales! The Wolf introduces himself and explains that he\'s misunderstood! Red Riding Hood comes along, and the Wolf changes into his zoot suit, grabs Red and makes her do a jive boogie-woogie dance with him! Mighty Mouse sees this, and he clobbers the Wolf. Then the Wolf cross-dresses to impersonate Little Bo Peep, and lures a flock of lambs into his trap. He whips out a gun and makes the sheep take their wool off! Mighty Mouse sees this, and he beats the heck out of the Wolf. The Wolf then tries to get into the Three Little Pigs\' house by pretending to be a cowboy. He calls for backup. The Wolves attack the pigs, Mighty Mouse trounces them, and all is well in Cartoonland!<br></p>', '', '24', '25', '0', '1945-07-20', '3', '5,31', NULL, '6 Mins', 'SD', 0, 1, 0, '', 0, 'animation,short,kids,family,micky mouse,comedy,cartoon,disney,wolf,mighty mouse,mighty mouse and the wolf', '                A Terrytoons cartoon released 20 July 1945. A twisted version of some famous fairy tales! The Wolf introduces himself and explains that he\'s misunderstood! Red Riding Hood comes along, and the Wolf changes into his zoot suit, grabs Red and makes her do a jive boogie-woogie dance with him! Mighty Mouse sees this, and he clobbers the Wolf. Then the Wolf cross-dresses to impersonate Little Bo Peep, and lures a flock of lambs into his trap. He whips out a gun and makes the sheep take their wool off! Mighty Mouse sees this, and he beats the heck out of the Wolf. The Wolf then tries to get into the Three Little Pigs\' house by pretending to be a cowboy. He calls for backup. The Wolves attack the pigs, Mighty Mouse trounces them, and all is well in Cartoonland!            ', 'animation,short,kids,family,micky mouse,comedy,cartoon,disney,wolf,mighty mouse,mighty mouse and the wolf', '7', 0, 1, 3, 3, 3, 4, '2019-04-04 00:00:00');
INSERT INTO `videos` (`videos_id`, `imdbid`, `title`, `seo_title`, `slug`, `description`, `stars`, `director`, `writer`, `rating`, `release`, `country`, `genre`, `video_type`, `runtime`, `video_quality`, `is_paid`, `publication`, `trailer`, `trailler_youtube_source`, `enable_download`, `focus_keyword`, `meta_description`, `tags`, `imdb_rating`, `is_tvseries`, `total_rating`, `today_view`, `weekly_view`, `monthly_view`, `total_view`, `last_ep_added`) VALUES (8, '', 'Culver Stockton College Vs. Central Methodist University - 1st Sept 2018', 'Culver Stockton College Vs. Central Methodist University - 1st Sept 2018', 'culver-stockton-college-vs-central-methodist-university-1st-sept-2018', '<p>Culver-Stockton films: Football</p><p>Jordan Grant scored two touchdowns and Denzel Campbell returned a kickoff for another touchdown as the Culver-Stockton College football team opened its home schedule with a 35-22 victory over Central Methodist University Saturday night at Ellison Poulton Stadium.<br></p><p>The victory snapped an 11-game on-field losing streak to the Eagles and improves the Wildcats to 2-0 for the first time since the 2014 season. The last on-field victory against CMU came in 2006, a 12-7 victory at home. C-SC was awarded a forfeit victory in 2013 after the Eagles used an ineligible player.<br></p><p>The Wildcats started the scoring on their opening drive, driving 63 yards on 11 plays before Ben Workman drilled a 29-yard field to make it 3-0.<br></p><p>C-SC caught a break late in the first quarter when a low snap on a punt attempt forced CMU punter Nathan Hampton to kneel on the ground. His knee touched the ground and the Wildcats took over on the eagle 33-yard line.<br></p><p>The Wildcats made the Eagles pay for the mistake as made it 10-0 on the first play of the second quarter when Grant took a pass from quarterback Korbin Marcum and scampered in from five yards out. Marcum was 4-for-4 on the drive covering 33 yards.<br>Workman added a 26-yard field goal to make it 13-0 in the second quarter before the Eagles tacked on two field goals of their own in the final three minutes of the first half to trail 13-6 entering the halftime break.<br></p><p>Neither team did much in the third quarter until CMU scored a touchdown with 2:37 to play period. The extra point was blocked and the Wildcats clinging to a 13-12 lead but with CMU holding the momentum.<br></p><p>That momentum shifted on the ensuing kickoff when Campbell fielded the kick at the 13-yard line and raced up the right side for 87 yards and a Wildcat touchdown. Workman\'s extra point made it 20-12 C-SC with 2:21 left in the quarter.<br></p><p>The Eagles added a third field goal to cut the margin to 20-15 and then the visitors forced a turnover on the ensuing possession and took over at the Wildcat 37-yard line. Five plays later CMU scored a touchdown and led 22-20 with 11:58 to play in the game.<br>Again the Wildcats didn\'t panic.<br></p><p>Starting at their own 25 after a touchback, the Wildcats answered with a 14-play, 75-yard drive that culminated in a three-yard touchdown pass from Marcum to Mateen Johnson. Marcum hooked up with Nathan Barnes on the two-point conversion and the Wildcats led 28-22.<br></p><p>The C-SC defense forced a three-and-out on the ensuing possession and this time CMU\'s Hampton ran a fake punt and was tackled by Kendall Kothe for a five-yard loss.<br>The Wildcats made the Eagles pay for that error and Grant blasted in from the 10-yard line on the fifth play of the drive to give the Wildcats a 35-22 cushion with three minutes to play.<br></p><p>Nick Lariviere intercepted CMU\'s Dantae Vandeven on the first play after the kickoff to seal the victory. The Wildcats ran out the clock to end the game.<br></p><p>Marcum was spectacular in victory, throwing for 305 yards on 39 of 47 accuracy and two touchdowns. Connor Perrine was his main target, catching 11 passes for just 64 yards. Perrine caught nine of those passes in the second half.<br></p><p>Campbell had eight receptions for 86 yards while Stephen Murphy collected nine passes for 72 yards. Marcum connected with seven different receivers in the game.<br>Barnes finished as the leading rusher for the Wildcats with 80 yards on 15 carries. He recorded 62 yards on 11 carries in the fourth quarter alone. The Wildcats finished the game with 101 yards rushing and 406 yards overall.<br></p><p>Defensively, Pat Robinson totaled a team-high eight tackles, including four solo stops. Robinson also had the Wildcats\' only sack of the game and recorded two tackles for loss. Dalton Huffmangarnered seven tackles in the game, while Stephen Benson had three passes defended.<br></p><p>C-SC will try to make it three straight to start the season next Saturday at home against MidAmerica Nazarene University. The Pioneers defeated to Graceland 38-3 Saturday to even its record at 1-1. Kickoff is slated for 2:30 p.m. at Poulton Stadium.</p>', '', NULL, NULL, '0', '2018-09-01', '3', '36', NULL, '185 Mins', 'HD', 0, 1, 0, '', 0, 'sports,football,culver stockton college,vs,central methodist university', 'Culver-Stockton films: Football\r\n\r\nJordan Grant scored two touchdowns and Denzel Campbell returned a kickoff for another touchdown as the Culver-Stockton College football team opened its home schedule with a 35-22 victory over Central Methodist University Saturday night at Ellison Poulton Stadium.\r\n\r\nThe victory snapped an 11-game on-field losing streak to the Eagles and improves the Wildcats to 2-0 for the first time since the 2014 season. The last on-field victory against CMU came in 2006, a 12-7 victory at home. C-SC was awarded a forfeit victory in 2013 after the Eagles used an ineligible player.\r\n\r\nThe Wildcats started the scoring on their opening drive, driving 63 yards on 11 plays before Ben Workman drilled a 29-yard field to make it 3-0.\r\n\r\nC-SC caught a break late in the first quarter when a low snap on a punt attempt forced CMU punter Nathan Hampton to kneel on the ground. His knee touched the ground and the Wildcats took over on the eagle 33-yard line.\r\n\r\nThe Wildcats made the Eagles pay for the mistake as made it 10-0 on the first play of the second quarter when Grant took a pass from quarterback Korbin Marcum and scampered in from five yards out. Marcum was 4-for-4 on the drive covering 33 yards.\r\nWorkman added a 26-yard field goal to make it 13-0 in the second quarter before the Eagles tacked on two field goals of their own in the final three minutes of the first half to trail 13-6 entering the halftime break.\r\n\r\nNeither team did much in the third quarter until CMU scored a touchdown with 2:37 to play period. The extra point was blocked and the Wildcats clinging to a 13-12 lead but with CMU holding the momentum.\r\n\r\nThat momentum shifted on the ensuing kickoff when Campbell fielded the kick at the 13-yard line and raced up the right side for 87 yards and a Wildcat touchdown. Workman\'s extra point made it 20-12 C-SC with 2:21 left in the quarter.\r\n\r\nThe Eagles added a third field goal to cut the margin to 20-15 and then the visitors forced a turnover on the ensuing possession and took over at the Wildcat 37-yard line. Five plays later CMU scored a touchdown and led 22-20 with 11:58 to play in the game.\r\nAgain the Wildcats didn\'t panic.\r\n\r\nStarting at their own 25 after a touchback, the Wildcats answered with a 14-play, 75-yard drive that culminated in a three-yard touchdown pass from Marcum to Mateen Johnson. Marcum hooked up with Nathan Barnes on the two-point conversion and the Wildcats led 28-22.\r\n\r\nThe C-SC defense forced a three-and-out on the ensuing possession and this time CMU\'s Hampton ran a fake punt and was tackled by Kendall Kothe for a five-yard loss.\r\nThe Wildcats made the Eagles pay for that error and Grant blasted in from the 10-yard line on the fifth play of the drive to give the Wildcats a 35-22 cushion with three minutes to play.\r\n\r\nNick Lariviere intercepted CMU\'s Dantae Vandeven on the first play after the kickoff to seal the victory. The Wildcats ran out the clock to end the game.\r\n\r\nMarcum was spectacular in victory, throwing for 305 yards on 39 of 47 accuracy and two touchdowns. Connor Perrine was his main target, catching 11 passes for just 64 yards. Perrine caught nine of those passes in the second half.\r\n\r\nCampbell had eight receptions for 86 yards while Stephen Murphy collected nine passes for 72 yards. Marcum connected with seven different receivers in the game.\r\nBarnes finished as the leading rusher for the Wildcats with 80 yards on 15 carries. He recorded 62 yards on 11 carries in the fourth quarter alone. The Wildcats finished the game with 101 yards rushing and 406 yards overall.\r\n\r\nDefensively, Pat Robinson totaled a team-high eight tackles, including four solo stops. Robinson also had the Wildcats\' only sack of the game and recorded two tackles for loss. Dalton Huffmangarnered seven tackles in the game, while Stephen Benson had three passes defended.\r\n\r\nC-SC will try to make it three straight to start the season next Saturday at home against MidAmerica Nazarene University. The Pioneers defeated to Graceland 38-3 Saturday to even its record at 1-1. Kickoff is slated for 2:30 p.m. at Poulton Stadium.', 'sports,football,culver stockton college,vs,central methodist university', '', 0, 1, 1, 1, 1, 2, '2019-04-04 00:00:00');
INSERT INTO `videos` (`videos_id`, `imdbid`, `title`, `seo_title`, `slug`, `description`, `stars`, `director`, `writer`, `rating`, `release`, `country`, `genre`, `video_type`, `runtime`, `video_quality`, `is_paid`, `publication`, `trailer`, `trailler_youtube_source`, `enable_download`, `focus_keyword`, `meta_description`, `tags`, `imdb_rating`, `is_tvseries`, `total_rating`, `today_view`, `weekly_view`, `monthly_view`, `total_view`, `last_ep_added`) VALUES (9, '', 'A Star Is Born', 'A Star Is Born', 'a-star-is-born', '<p>Esther Blodgett is just another starry-eyed farm kid trying to break into the movies. Waitressing at a Hollywood party, she catches the eye of alcoholic star Norman Maine, is given a test, and is caught up in the Hollywood glamor machine (ruthlessly satirized). She and her idol Norman marry; but his career abruptly dwindles to nothing.<br></p>', '26,27,28,29,30,31,32,33,34,35,37,40,60,61,65,48,55,53,59,64,58,41,42,45,46,54,62,47,56,39,51,52,43,49', '70', '71,72,70,69,66', '0', '1937-04-27', '3', '22,25', NULL, '111 Mins', 'SD', 0, 1, 0, '', 0, 'Show Business,Waitress,Alcoholic,Movie Star,Hollywood', 'Esther Blodgett is just another starry-eyed farm kid trying to break into the movies. Waitressing at a Hollywood party, she catches the eye of alcoholic star Norman Maine, is given a test, and is caught up in the Hollywood glamor machine (ruthlessly satirized). She and her idol Norman marry; but his career abruptly dwindles to nothing.', 'Show Business,Waitress,Alcoholic,Movie Star,Hollywood', '7.3', 0, 1, 3, 3, 3, 4, '2019-04-04 00:00:00');
INSERT INTO `videos` (`videos_id`, `imdbid`, `title`, `seo_title`, `slug`, `description`, `stars`, `director`, `writer`, `rating`, `release`, `country`, `genre`, `video_type`, `runtime`, `video_quality`, `is_paid`, `publication`, `trailer`, `trailler_youtube_source`, `enable_download`, `focus_keyword`, `meta_description`, `tags`, `imdb_rating`, `is_tvseries`, `total_rating`, `today_view`, `weekly_view`, `monthly_view`, `total_view`, `last_ep_added`) VALUES (10, '', 'Ben10MMA Plays Brawlhalla With Squid', 'Ben10MMA Plays Brawlhalla With Squid', 'ben10mma-plays-brawlhalla-with-squid', '<p>Squid plays the 2D platform game Brawlhalla with UFC Fighter Ben \"Ben10\" Nguyen<br></p>', '82', '22', NULL, '0', '2021-01-15', '1,17', '64,65', NULL, '42 Mins', 'HD', 0, 1, 0, '', 0, 'Brawlhalla,Gaming,Esports,MMA,Ben 10,Ben Nguyen', 'Squid plays the 2D platform game Brawlhalla with UFC Fighter Ben \"Ben10\" Nguyen', 'Brawlhalla,Gaming,Esports,MMA,Ben 10,Ben Nguyen', '', 0, 1, 1, 1, 1, 2, '2019-04-04 00:00:00');
INSERT INTO `videos` (`videos_id`, `imdbid`, `title`, `seo_title`, `slug`, `description`, `stars`, `director`, `writer`, `rating`, `release`, `country`, `genre`, `video_type`, `runtime`, `video_quality`, `is_paid`, `publication`, `trailer`, `trailler_youtube_source`, `enable_download`, `focus_keyword`, `meta_description`, `tags`, `imdb_rating`, `is_tvseries`, `total_rating`, `today_view`, `weekly_view`, `monthly_view`, `total_view`, `last_ep_added`) VALUES (11, '', 'The Knockout', 'The Knockout', 'the-knockout', '<p>To show his girl how brave he is Fatty challenges the champion to a fight. Charlie referees, trying to avoid contact with the two monsters.<br></p>', '83,84,35,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,13,100,101,102,103,104,105,106,107', '91', '85', '0', '1914-06-11', '3,17', '7', NULL, '24 Mins', 'SD', 0, 1, 0, '', 0, 'Charlie Chaplin,Comedy,Fatty,Fighting,Knockout,Silent comedy', '                To show his girl how brave he is Fatty challenges the champion to a fight. Charlie referees, trying to avoid contact with the two monsters.            ', 'Charlie Chaplin,Comedy,Fatty,Fighting,Knockout,Silent comedy', '5.8', 0, 1, 2, 2, 2, 3, '2019-04-04 00:00:00');
INSERT INTO `videos` (`videos_id`, `imdbid`, `title`, `seo_title`, `slug`, `description`, `stars`, `director`, `writer`, `rating`, `release`, `country`, `genre`, `video_type`, `runtime`, `video_quality`, `is_paid`, `publication`, `trailer`, `trailler_youtube_source`, `enable_download`, `focus_keyword`, `meta_description`, `tags`, `imdb_rating`, `is_tvseries`, `total_rating`, `today_view`, `weekly_view`, `monthly_view`, `total_view`, `last_ep_added`) VALUES (12, '', 'Abraham Lincoln', 'Abraham Lincoln', 'abraham-lincoln', '<p>Silent film master D.W. Griffith\'s first talkie works as a companion piece to his classic BIRTH OF A NATION, providing a detailed biographical sketch of the 16th president. We see his birth in a log cabin, the tragic death of his first love, Ann Rutledge (Una Merkel), his debates with Douglas, his accepting of the presidency, the terrible toll of the Civil War, and finally the tragic assassination at Ford\'s Theater. Griffith shows his usual meticulous attention to period detail, and the framing of the various vignettes has the feel of historical photographs come to life. Walter Huston is excellent in the title role, with a portrayal that subtly evolves from laconic, wizened rascal to noble elder statesman. This is a fascinating, worthy film, and an interesting historical document in and of itself.<br></p>', '109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,46,137,138,139,140,141,142,143,144,145,146', '148', '153,154,156', '0', '1930-11-08', '3', '13,25', NULL, '85 Mins', 'SD', 0, 1, 0, '', 0, 'Drama,History,President Of United States,Assassination,Debate,Presidental', '                Silent film master D.W. Griffith\'s first talkie works as a companion piece to his classic BIRTH OF A NATION, providing a detailed biographical sketch of the 16th president. We see his birth in a log cabin, the tragic death of his first love, Ann Rutledge (Una Merkel), his debates with Douglas, his accepting of the presidency, the terrible toll of the Civil War, and finally the tragic assassination at Ford\'s Theater. Griffith shows his usual meticulous attention to period detail, and the framing of the various vignettes has the feel of historical photographs come to life. Walter Huston is excellent in the title role, with a portrayal that subtly evolves from laconic, wizened rascal to noble elder statesman. This is a fascinating, worthy film, and an interesting historical document in and of itself.            ', 'History,Drama,President Of United States,Assassination,Debate,Presidental', '5.7', 0, 1, 3, 3, 3, 4, '2019-04-04 00:00:00');
INSERT INTO `videos` (`videos_id`, `imdbid`, `title`, `seo_title`, `slug`, `description`, `stars`, `director`, `writer`, `rating`, `release`, `country`, `genre`, `video_type`, `runtime`, `video_quality`, `is_paid`, `publication`, `trailer`, `trailler_youtube_source`, `enable_download`, `focus_keyword`, `meta_description`, `tags`, `imdb_rating`, `is_tvseries`, `total_rating`, `today_view`, `weekly_view`, `monthly_view`, `total_view`, `last_ep_added`) VALUES (13, '', 'Doll Face', 'Doll Face', 'doll-face', '<p>Burlesque queen, Doll Face Carroll, is dismissed from an audition for a legitimate Broadway show because she lacks culture. Her boss/manager Mike decides that she can get both culture and plenty of publicity by writing her autobiography. He hires a ghost writer to do all the work, but doesn\'t count on the possibility that Doll Face and her collaborator might have more than a book on their minds.<br></p>', '160,59,161,162,163,164,165,166,167,168,169,170,171,172', '179', '176,178', '0', '1945-12-31', '3', '7,32,39', NULL, '78 Mins', 'SD', 0, 1, 0, '', 0, 'Music,Burlesque,Dancer,AutoBiography', 'Burlesque queen, Doll Face Carroll, is dismissed from an audition for a legitimate Broadway show because she lacks culture. Her boss/manager Mike decides that she can get both culture and plenty of publicity by writing her autobiography. He hires a ghost writer to do all the work, but doesn\'t count on the possibility that Doll Face and her collaborator might have more than a book on their minds.', 'Music,Burlesque,Dancer,AutoBiography', '6', 0, 1, 4, 4, 4, 5, '2019-04-04 00:00:00');


#
# TABLE STRUCTURE FOR: wish_list
#

DROP TABLE IF EXISTS `wish_list`;

CREATE TABLE `wish_list` (
  `wish_list_id` int(11) NOT NULL AUTO_INCREMENT,
  `wish_list_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `videos_id` int(11) DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  `status` int(11) DEFAULT 1,
  PRIMARY KEY (`wish_list_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wish_list` (`wish_list_id`, `wish_list_type`, `user_id`, `videos_id`, `create_at`, `status`) VALUES (1, 'wl', 1, 13, '2021-01-16 18:37:23', 1);


