# 2.x to 3.x migration guide

The release of the `3.0` version of the library introduced many breaking changes in the API.

This document is provided to support migration from a `2.x` to a `3.x` version of the library.

## Version 3.0.0-alpha.0

### Added better support for Companion Ads

* Companion value `type: String` is now only associated to `staticResources` and renamed to `creativeType`
* Changed companion value `htmlResource: String` to `htmlResources: Array<String>`
* Changed companion value `iframeResource: String` to `iframeResources: Array<String>`
* Changed companion value `staticResource: String` to `staticResources: Array<{url: String, creativeType: String|null}>`

### Better extension parsing

Each `Extension` now has the format:

* `name: String|null` - extension name
* `value: any` - value inside extension (if it is another node it will be passed into children instead)
* `attributes: Object` - attributes of extension
* `children: Array<Extension>` - children nodes in the extension. They will be parsed with `Extension` format.

Extension won't be added to the parsed result if it contains no value, attributes and children.
Comments and empty strings will be ignored.

For example, this extension:

```xml
<Extensions>
  <Extension>
    { foo: bar }
  </Extension>
  <Extension type="Pricing">
    <Prices>
      <Price model="CPM" currency="USD" source="someone">
        <![CDATA[ 0 ]]>
      </Price>
      <Price model="CPM" currency="USD" source="someone">
        <![CDATA[ 234.5 ]]>
      </Price>
    </Prices>
    <PricingPolicy>
      <!-- Test of comment -->
      <![CDATA[http://example.com/pricing-policy.html]]>
    </PricingPolicy>
  </Extension>
  <Extension type="OverlyNestedExtension">
    <GreatFather age="70">
      <Father age="40" alive="false">
        <Daughter age="20">Maria</Daughter>
        <Daughter age="20">Lola</Daughter>
        <Son age="25">Paul</Son>
      </Father>
    </GreatFather>
  </Extension>
</Extensions>
```

Would be parsed as:

```js
{
  extensions: [
    {
      name:"Extension",
      value:"{ foo: bar }",
      attributes:{},
      children:[]
    },
    {
      name:"Extension",
      value:null,
      attributes:{"type":"Pricing"},
      children:[
        {
          name:"Prices",
          value:null,
          attributes:{},
          children:[
            {
              name:"Price",
              value:"0",
              attributes:{"model":"CPM","currency":"USD","source":"someone"},
              children:[]
            },
            {
              name:"Price",
              value:"234.5",
              attributes:{"model":"CPM","currency":"USD","source":"someone"},
              children:[]
            }
          ]
        },
        {
          name:"PricingPolicy",
          value:"http://example.com/pricing-policy.html",
          attributes:{},
          children:[]
        }
      ]
    },
    {
      name:"Extension",
      value:null,
      attributes:{"type":"OverlyNestedExtension"},
      children:[
        {
          name:"GreatFather",
          value:null,
          attributes:{"age":"70"},
          children:[
            {
              name:"Father",
              value:null,
              attributes:{"age":"40","alive":"false"},
              children:[
                {
                  name:"Daughter",
                  value:"Maria",
                  attributes:{"age":"20"},
                  children:[]
                },
                {
                  name:"Daughter",
                  value:"Lola",
                  attributes:{"age":"20"},
                  children:[]
                },
                {
                  name:"Son",
                  value:"Paul",
                  attributes:{"age":"25"},
                  children:[]
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}
```

### From babel 6 to babel 7

Vast-client now uses babel 7, so direct uses of the package `src` folder will need babel 7 in its own package to work.

### NodeJS EventEmitter replaced with custom class

A lighter custom class with the same syntax has been created to replace nodeJS EventEmitter. API docs for custom class described [here](https://github.com/dailymotion/vast-client-js/blob/3.0-version/docs/api/event-emitter.md).

## Version 3.0.0-alpha.1

### No more imports from `src`

`module` package.json entry with pre-build files has been replaced with `browser` entry pointing towards already built files. This is to facilitate packages still using babel 6 (as it is not compatible with babel 7). Check [README](https://github.com/dailymotion/vast-client-js/blob/3.0-version/README.md#api-documentation) file for more detailed info.

## Version 3.0.0-alpha.2

### Companion ads in Wrapper elements are now parsed

Previously companion ads in `Wrapper` elements were being ignored. `companionClickTrackingURLTemplates` from wrapper companion ads are passed down to other companion ads.

## Version 3.0.0-alpha.7

### ⚠️ *Important* ⚠️

Some attributes have been changed to include `id` values. Changes have been done to:

```js
Ad {
  advertiser: Array<{ id: String|null, value: String }>
  impressionURLTemplates: Array<{ id: String|null, url: String }>
}
```

```js
CreativeLinear {
  videoClickThroughURLTemplate: { id: String|null, url: String }|null
  videoClickTrackingURLTemplates: Array<{ id: String|null, url: String }>
  videoCustomClickURLTemplates: Array<{ id: String|null, url: String }>
}
```

```js
NonLinearAd {
  nonlinearClickTrackingURLTemplates: Array<{ id: String|null, url: String }>
}
```

```js
CompanionAd {
  companionClickTrackingURLTemplates: Array<{ id: String|null, url: String }>
}
```

```js
Icon {
  iconClickTrackingURLTemplates: Array<{ id: String|null, url: String }>
}
```

### The following classes have been replaced with objects:

* AdExtension (now called Extension)
* AdVerification
* Ad
* CompanionAd
* CreativeCompanion
* CreativeLinear
* CreativeNonLinear
* Creative
* Icon
* MediaFile
* Mezzanine
* NonLinearAd
* VASTResponse

### Changes to requests

* `FlashURLHandler` has been removed. If it is needed from this point on, it should be passed as a custom url handler in options.
* Requests (`NodeURLHandler` and `XHRURLHandler`) now have a timeout of `120000ms` by default.

### Improvents for VAST-resolving/VAST-resolved event logs

* `fetchVAST` can now be called with 2 more arguments `wrapperDepth` and `previousUrl`: `fetchVAST(url, wrapperDepth = 0, previousUrl = null)`
* Parameter `options` from `getAndParseVAST` is now optional: `getAndParseVAST(url, options = {})`
* property `rootURL` in `VASTParser` is now set after url template filter functions have been called.
* `parseVastXml` can now be passed additional properties in `options` object, `url` and `wrapperDepth`: `parseVastXml(vastXml, { isRootVAST = false, url = null, wrapperDepth = 0 })`

Due to a bug where `originalUrl` was being assigned not as the root url, but the previous url, the following has changed:

* `VAST-resolving` event payload now has field `originalUrl` correctly renamed to `previousUrl`.
* Parameter `originalUrl` from `resolveWrappers` has been correctly renamed to `previousUrl`: `resolveWrappers(ad, wrapperDepth, previousUrl)`
* `resolveAds` param `originalUrl` in `options` object has been renamed to `previousUrl`. It also can be passed `url` into `options`. For example: `resolveAds(ads = [], { url, previousUrl })`
* `options` parameter in `VASTParser` `parse` function now expects `previousUrl` instead of `originalUrl`. It also can be passed `url` into `options`.

## Version 3.0.0-alpha.8

### Improvement for vast trackers to support 4.1 macros

* `track(eventName, once = false)` becomes `track(eventName, { macros = {}, once = false })`

#### VAST 4.1 Macros

The vast-client now support VAST 4.1 Macros. The complete list of new supported macros is in the file [macros.js](/src/util/macros.js). The following macro value will be set automatically (according to IAB specs) by vast-client if it exists in the tracking url:

* ADCATEGORIES
* ADPLAYHEAD
* ADSERVINGID
* ADTYPE
* ASSETURI
* BLOCKEDADCATEGORIES
* CACHEBUSTING
* CONTENTPLAYHEAD
* MEDIAPLAYHEAD
* PODSEQUENCE
* TIMESTAMP
* UNIVERSALADID

If a macro exist in the tracking url, but no value is known and is supported it will be replaced with `-1` as specified by iAB. For more in-depth explainations on macros, please see [vast-tracker.md](vast-tracker.md#macros)

## Version 3.0.0-alpha.9

### Wrapper and verification scripts

When a vast is unwrapped, the final vast, once parsed now contains its verifications script and also the one from previous wrapper if any.

### Node minimal version updated

We now require node version 10.12+

## Version 3.0.0

### Sequence attribute value overriden by wrapper parent sequence value

The sequence attribute of an Inline ad when wrapped in wrapper will be replaced by the one of its parent wrapper.
The replacement will be made only if the parent wrapper contains only one ad. Otherwise sequences from the unwrapped ad will be kept.

e.g, for a use case where an AdPod contain:

* Inline with sequence 1
* Inline with sequence 2
* Wrapper with sequence 3 wrapping a Inline with sequence 1

once parsed we will obtain :

* Inline sequence 1,
* Inline sequence 2,
* Inline sequence 3

In the use case where a wrapper wrap an AdPod, the wrapper sequence will be ignored.e.g

* Wrapper sequence 3 containing:
  * Inline sequence 1,
  * Inline sequence 2,
  * Inline sequence 3

once parsed we will obtain :

* Inline sequence 1,
* Inline sequence 2,
* Inline sequence 3

### New bundler

Replaced rollup plugin used for minify from `uglify` to `terser`
