<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

class Google_Service_Vision_BoundingPoly extends Google_Collection
{
  protected $collection_key = 'vertices';
  protected $normalizedVerticesType = 'Google_Service_Vision_NormalizedVertex';
  protected $normalizedVerticesDataType = 'array';
  protected $verticesType = 'Google_Service_Vision_Vertex';
  protected $verticesDataType = 'array';

  /**
   * @param Google_Service_Vision_NormalizedVertex
   */
  public function setNormalizedVertices($normalizedVertices)
  {
    $this->normalizedVertices = $normalizedVertices;
  }
  /**
   * @return Google_Service_Vision_NormalizedVertex
   */
  public function getNormalizedVertices()
  {
    return $this->normalizedVertices;
  }
  /**
   * @param Google_Service_Vision_Vertex
   */
  public function setVertices($vertices)
  {
    $this->vertices = $vertices;
  }
  /**
   * @return Google_Service_Vision_Vertex
   */
  public function getVertices()
  {
    return $this->vertices;
  }
}
