package djdooh_target

import (
	"djextrafunc"
	"djgetad"
	"djlogger"
	openrtb3 "openrtb/openrtb3"
	"reflect"
	"strings"
)

type Command struct {
	Name string
	Args []string
}

type Commander struct{}

var doohobj *openrtb3.Dooh

// Function for coverting string to function arguments
func StringCommandParser(cmd string) *Command {
	parts := strings.Split(cmd, "(")
	parts2 := strings.Split(parts[1], ")")
	count := strings.Count(parts2[0], ",")
	parts3 := strings.Split(djextrafunc.ReplaceNth(parts2[0], ",", "", "^", "", count), "^")
	return &Command{
		Name: parts[0],
		Args: parts3[0:],
	}
}

// Function for checking overall app targeting criteria
func CheckDoohCriteria(doohChannel chan []djgetad.GetAd, dooh *openrtb3.Dooh, ads []djgetad.GetAd) {
	doohobj = dooh
	var filterads []djgetad.GetAd
	defer func() {
		if err := recover(); err != nil {
			djlogger.Log.Println("Error occured : ", err, " Recovered from panic")
			doohChannel <- filterads
		}
	}()
	
			validate_campaign := make(map[int]int)


	for _, ad := range ads {
		
		
				if validate_campaign[ad.Placement_id] == 1 {
			
			filterads = append(filterads, ad)
			continue
		}
		
		if validate_campaign[ad.Placement_id] == 2 {
			continue
		} 
		
		validate_campaign[ad.Placement_id] = 2 // by default not match 
		
		
		var ex bool
		var funcarr []string
		if ad.Compiledlimitation != "" && ad.Compiledlimitation != "true" {
			s := strings.Split(ad.Compiledlimitation, " and ")
			for _, element := range s {
				if element != "" {
					for _, e := range strings.Split(element, " or ") {
						if e != "" {
							funcarr = append(funcarr, e)
						}
					}
				}
			}
			for _, funcName := range funcarr {
				if funcName != "" {
					command := StringCommandParser(funcName)
					c := &Commander{}
					f := reflect.ValueOf(c).MethodByName(command.Name)
					if f.IsValid() {
						inputs := []reflect.Value{reflect.ValueOf(*command)}
						fu := f.Call(inputs)
						if fu[0].Interface().(bool) == false {
							ex = false
							break
						} else {
							ex = true
						}
					} else {
						ex = true
					}
				}
			}
			if ex != false {
				filterads = append(filterads, ad)
												validate_campaign[ad.Placement_id] = 1 // match

			}
		} else {
			filterads = append(filterads, ad)
											validate_campaign[ad.Placement_id] = 1 // match

		}
	}
	doohChannel <- filterads
}

/*------------------------------------------------------
	Dooh Targeting Start : category,ID <==> 11/03/2020 - 11/03/2020
--------------------------------------------------------*/

// Category Start
func (c Commander) MAX_checkClient_DoohPubCat(cmd Command) bool {
	var reqDoohCategory []string
	var argDoohCategory []string
	i := len(cmd.Args) - 1
	op := strings.TrimSpace(strings.Replace(cmd.Args[i], "'", "", -1))
	for _, cat := range doohobj.Pub.Cat {
		reqDoohCategory = append(reqDoohCategory, strings.TrimSpace(strings.Replace(strings.ToLower(cat), "'", "", -1)))
	}
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argDoohCategory = append(argDoohCategory, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqDoohCategory != nil {
		if op == "==" {
			return djextrafunc.CheckEqual(reqDoohCategory, argDoohCategory)
		} else if op == "!=" {
			return !djextrafunc.CheckEqual(reqDoohCategory, argDoohCategory)
		} else if op == "=~" {
			for _, v := range argDoohCategory {
				for _, v1 := range reqDoohCategory {
					if v1 == v {
						return true
					}
				}
			}
		} else if op == "!~" {
			for _, v := range argDoohCategory {
				for _, v1 := range reqDoohCategory {
					if v1 == v {
						return false
					}
				}
			}
			return true
		} else {
			return false
		}
	}
	return false
}

// Category End

// ID Start
func (c Commander) MAX_checkClient_DoohID(cmd Command) bool {
	reqDoohID := doohobj.ID
	argDoohID := strings.TrimSpace(strings.Replace(cmd.Args[0], "'", "", -1))
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	if reqDoohID != "" {
		if op == "==" || op == "=~" {
			return reqDoohID == argDoohID
		} else if op == "!=" || op == "!~" {
			return reqDoohID != argDoohID
		} else {
			return false
		}
	}
	return false
}

// ID End
/*------------------------------------------------------
	Dooh Targeting Start : category,ID <==> 11/03/2020 - 11/03/2020
--------------------------------------------------------*/
