package client

import "strings"
import "alpha/adDelivery/deliveryLimitation/validation"
import 	"go/build"
import 	"sort"
import "encoding/csv"
import	"os"
import	"fmt"

func Browser(limitation string,op string,val string) bool {
	
	result :=  validation.CheckArrayValueMatch(limitation,val)
	
	switch op {
    case "=~":
        return result
    case "!~":
        return !result
    }
    
    return false
}

func Os(limitation string,op string,val string) bool {
	
	result :=  validation.CheckArrayValueMatch(limitation,val)
	
	switch op {
    case "=~":
        return result
    case "!~":
        return !result
    }
    
    return false
}


func Language(limitation string,op string,val string) bool {
	
	result :=  validation.CheckArrayValueMatch(limitation,val)
	
	switch op {
    case "=~":
        return result
    case "!~":
        return !result
    }
    
    return false
} 


func Ip(limitation string,op string,val string) bool {
	
	result :=  validation.CheckStringMatch(limitation,val)
	
	switch op {
    case "==":
        return result
    case "!=":
        return !result
    }
    
    return false
}


func Segment(limitation string,op string,dmp_id string) bool {
	
	result := false
	
	for _, val := range strings.Split(limitation, ",") {
			
		
		lines, _ := ReadCsv(build.Default.GOPATH + "/ssp-alpha/segments/seg_" + val + ".csv")
		
			
			for _,line := range lines {
			total_found := sort.SearchStrings(line, dmp_id) 

				if total_found > 0 {
					
					result = true
					
					break
					break
				}
			
		}
		}
    					fmt.Println(result)	

switch op {
    case "=~":
        return result
    case "!~":
        return !result
    }
    
    return false
 }





func ReadCsv(filename string) ([][]string, error) {

	// Open CSV file
	f, err := os.Open(filename)
	if err != nil {
		return [][]string{}, err
	}
	defer f.Close()

	// Read File into a Variable
	lines, err := csv.NewReader(f).ReadAll()
	if err != nil {
		return [][]string{}, err
	}

	return lines, nil
}






func BrowserVersion(limitation string,op string,browser_name string,browser_version string) bool {
	
		l := strings.Split(limitation, "|")
		tar_browser := l[0]
		tar_browserVer := l[1]
		
		result := validation.CheckStringMatch(browser_name,tar_browser)
		
		switch op {
    case "nn":
        return result
    case "==":
        return result && validation.CheckStringMatch(browser_version,tar_browserVer)
    case "!=":
        return !(result && validation.CheckStringMatch(browser_version,tar_browserVer))
    case "lt":
        return result && validation.CheckStringintLess(browser_version,tar_browserVer)    
    case "gt":
        return result && validation.CheckStringintGra(browser_version,tar_browserVer)    
    case "le":
        return result && validation.CheckStringintLessEq(browser_version,tar_browserVer)    
    case "ge":
        return result && validation.CheckStringintGraEq(browser_version,tar_browserVer)    
        
    }
        return false

}

func OsVersion(limitation string,op string,os_name string,os_version string) bool {
	
		l := strings.Split(limitation, "|")
		tar_os := l[0]
		tar_osVer := l[1]
		
		result := validation.CheckStringMatch(os_name,tar_os)
		
		switch op {
    case "nn":
        return result
    case "==":
        return result && validation.CheckStringMatch(os_version,tar_osVer)
    case "!=":
        return !(result && validation.CheckStringMatch(os_version,tar_osVer))
    case "lt":
        return result && validation.CheckStringintLess(os_version,tar_osVer)    
    case "gt":
        return result && validation.CheckStringintGra(os_version,tar_osVer)    
    case "le":
        return result && validation.CheckStringintLessEq(os_version,tar_osVer)    
    case "ge":
        return result && validation.CheckStringintGraEq(os_version,tar_osVer)    
        
    }
        return false

}


func Domain(limitation string,op string,domain_name string) bool {
	
		
		
		
		result := validation.CheckStringMatch(limitation,domain_name)
		
		switch op {
    case "==":
        return result
    case "!=":
        return !result
    case "=~":
        return  validation.CheckStringContains(domain_name , limitation)
    case "!~":
        return !validation.CheckStringContains(domain_name , limitation)
    case "=x":
        return validation.CheckStringRexMatch(domain_name , limitation)
    case "!x":
        return !validation.CheckStringRexMatch(domain_name , limitation) 
  
    }
        return false

}

func Ua(limitation string,op string,ua_name string) bool {
	
		
		
		
		result := validation.CheckStringMatch(limitation,ua_name)
		
		switch op {
    case "==":
        return result
    case "!=":
        return !result
    case "=~":
        return  validation.CheckStringContains(ua_name , limitation)
    case "!~":
        return !validation.CheckStringContains(ua_name , limitation)
    case "=x":
        return validation.CheckStringRexMatch(ua_name , limitation)
    case "!x":
        return !validation.CheckStringRexMatch(ua_name , limitation) 
  
    } 
        return false

}




func SetBrowserName(s string) string {
	
	
	switch s {
    case "Chrome":
        return "GC"
    case "Firefox":
        return "FX"
    case "IE":
        return "IE"
    case "Safari":
        return "SF"
    case "Opera":
		return "OP"
   
    } 
	 
return s	
}

func SetBrowserFullName(s string) string {
	
	
	switch s {
    case "Chrome":
        return "Chrome"
    case "Firefox":
        return "Firefox"
    case "IE":
        return "Internet Explorer"
    case "Safari":
        return "Safari"
    case "Opera":
      return "Opera"
    case "BlackBerry":
      return "BlackBerry"
    
   
    } 
	 
return s	
}

func SetOsName(s string) string {
	
	
	switch s {
    case "Windows":
        return "w7"
    case "MacOSX":
        return "osx"
    case "Linux":
        return "linux"
     
    } 
	 
return s	
}

func SetOsFullName(s string) string {
	
	
	switch s {
    case "Windows":
        return "Windows"
    case "Linux":
        return "Linux"
    case "Android":
        return "Android"
    case "iOS":
        return "iOS"
    case "ChromeOS":
        return "Chrome OS"
     
    } 
	  
return s	
}


 

