package ads_external

import "alpha/adDelivery/structure"
import "fmt"
import "alpha/adDelivery/globalvariables"
import config "alpha/configuration"

import "encoding/json"

import "net/http"
import "bytes"
import "io/ioutil"
import "time"

func GetExernalAds(outputData *structure.OutputData) {

	zn := outputData.Zone_details
	zoneExtra := getZoneOpenRtbParams(outputData.Zone_id)
	pub_details := getZonePublisherDetails(outputData.Zone_id, zn.Affiliateid)
	matchedDeals := getZoneMatechedDeals(outputData.Zone_id, zn.Width, zn.Height)
	buyer_details := getZoneBuyerDetails(outputData.Zone_id, zn.Ssp_buyer)

	buffer_amount, rtb_responsetime := getAdminDetails()

	zn.SeconBidBuffer = buffer_amount

	GrobalVariables := globalvariables.SetAllGrobalVariables(outputData.R)

	var req interface{}
	var selection_type string

	if zn.Width == -12 && zn.Height == -12 {

		req = GenerateNativeImageObjects(outputData, zoneExtra, pub_details, matchedDeals, buyer_details, GrobalVariables)
		selection_type = "native_image"

	} else if zn.Width == -22 && zn.Height == -22 {

		req = GenerateNativeVideoObjects(outputData, zoneExtra, pub_details, matchedDeals, buyer_details, GrobalVariables)
		selection_type = "native_video"

	} else if zn.Width == -21 || zn.Width == -24 || zn.Width == -23 || zn.Width == -25 || zn.Width == -26 || zn.Width == -27 {

		req = GenerateVideoAudioObjects(outputData, zoneExtra, pub_details, matchedDeals, buyer_details, GrobalVariables)
		selection_type = "outstream"

	} else if outputData.Tag_type == "video" || outputData.Tag_type == "audio" {

		req = GenerateVideoAudioObjects(outputData, zoneExtra, pub_details, matchedDeals, buyer_details, GrobalVariables)
		selection_type = "video"
	} else if outputData.Tag_type == "outstream" {

		req = GenerateVideoAudioObjects(outputData, zoneExtra, pub_details, matchedDeals, buyer_details, GrobalVariables)
		selection_type = "outstream"

	} else {

		req = GenerateImgObjects(outputData, zoneExtra, pub_details, matchedDeals, buyer_details, GrobalVariables)
		selection_type = "image"

	}

	request_json, _ := json.Marshal(req)
	fmt.Println("Request",string(request_json))

	request, err := http.NewRequest("POST", config.GetConfig("mainpath", "ssp"), bytes.NewBuffer(request_json))
	request.Header.Set("Content-Type", "application/json")
	client := &http.Client{Timeout: time.Duration(rtb_responsetime) * time.Millisecond}
	resp, err := client.Do(request)

	if err != nil {
		panic(err)
	}
	defer resp.Body.Close()

	if resp.Status == "200 OK" {

		body, _ := ioutil.ReadAll(resp.Body)

		fmt.Println("Response", string(body))

		responseS := ExternalResponse{}

		json.Unmarshal([]byte(body), &responseS)

		if responseS.Ads.Num1.Adm != "" {

			responseS.Ads.Num1.Adm = responseS.Ads.Num1.Adm

			if selection_type == "native_image" {

				outputData.Html = ExtenalAdRenderNativeImage(zoneExtra, responseS.Ads.Num1.Adm) + "<img width=0 height=0 src='" + responseS.Ads.Num1.Burl + "'>"
				outputData.External_ad = true
			} else if selection_type == "outstream" {

				if outputData.Tag_type == "sdk" {

					outputData.HtmlInterface = AdRenderOutstreamVideoAdSDK(responseS.Ads.Num1.Adm, zn, outputData.R)

				} else {

					respId := responseS.Ads.Num1.ID
					redisClients.SetKey("vidxml"+respId, responseS.Ads.Num1.Adm)

					var vast string
					redisClients.GetKey("vidxml"+respId, &vast)
					fmt.Println(vast)
					fmt.Println("vidxml" + respId)

					vastXml := config.GetConfig("protocol", "webpath") + config.GetConfig("host", "app") + config.GetConfig("port", "app") + "/vastxml" + "?xmlkey=vidxml" + respId
					outputData.Html = AdRenderOutstreamVideoAd_external(vastXml, zn.Vidtype)
				}

				outputData.External_ad = true

			} else if selection_type == "video" {

				outputData.Html = responseS.Ads.Num1.Adm
				outputData.External_ad = true

			} else {

				outputData.Html = responseS.Ads.Num1.Adm + "<img width=0 height=0 src='" + responseS.Ads.Num1.Burl + "'>"
				outputData.External_ad = true

			}

		}

	}

}
