package redisclient

import (
	config "alpha/configuration"
	"alpha/logger"
	"context"
	"encoding/json"
	"fmt"
	"time"

	"github.com/go-redis/redis"
)

var cxt = context.Background()

var (
	client = &RedisClient{}
)

type RedisClient struct {
	c *redis.Client
}

func RedisHello() {
	fmt.Println("hello")
}

// GetClient get the redis client
func Initialize() *RedisClient {

	host := config.GetConfig("host", "redis")
	port := config.GetConfig("port", "redis")
	pass := config.GetConfig("password", "redis")

	c := redis.NewClient(&redis.Options{
		Addr:     host + ":" + port,
		Password: pass,
		DB:       0,
		// Addr:     "13.56.216.189:6379",
		// Password: "Hysl2fer8r",
		// DB:       0,
	})

	//defer c.Close()
	if err := c.Ping(cxt).Err(); err != nil {
		logger.Log.Println("Unable to connect to redis " + err.Error())
	}
	client.c = c
	return client
}

func (client *RedisClient) SetKey(key string, value interface{}) error {

	//This code is used to set the expire time for redis key
	//expiration := time.Minute * 1
	expiration := time.Minute * 50

	cacheEntry, err := json.Marshal(value)
	if err != nil {
		return err
	}
	err = client.c.Set(cxt, key, cacheEntry, expiration).Err()
	if err != nil {
		return err
	}
	return nil
}

func (client *RedisClient) GetKey(key string, src interface{}) error {
	val, err := client.c.Get(cxt, key).Result()
	if err == redis.Nil || err != nil {
		return err
	}
	err = json.Unmarshal([]byte(val), &src)
	if err != nil {
		return err
	}
	return nil
}

func (client *RedisClient) HSetKey(key string, value map[string]interface{}) error {

	err := client.c.HMSet(cxt, key, value)
	if err != nil {
		fmt.Println(err)
	}
	return nil
}

func (client *RedisClient) HGetKey(key string, src map[string]string) error {

	val, err := client.c.HGetAll(cxt, key).Result()
	if err == redis.Nil || err != nil {
		return err
	}
	jsondata, err := json.Marshal(val)
	if err != nil {
		fmt.Println(err)
	}
	err = json.Unmarshal(jsondata, &src)
	if err != nil {
		return err
	}
	return nil
}
