package structure

import (
	"net/http"
)

type AdmaruOutput struct {
	R                *http.Request
	Adunit_id        string
	Adunit_details   AdUnitDetails
	Provider_id      []string
	Provider_Details []ProviderDetails
	Html             string
	HtmlInterface    map[string]interface{}
	Internal_ad      bool
	External_ad      bool
	Publisher_type   string
	Adunit_type      string
	Delivery_type    int
	Adsource_details []AdSourceDetails
	Adsource_id      string
}

type AdUnitDetails struct {
	Adunit_id   string `redis:"adunit_id"`
	Adunit_type string `redis:"adunit_type"`
	Envtype     string `redis:"envtype"`
	Status      string `redis:"status"`
}

type AdSourceDetails struct {
	Adsourceid    string `json:"adsourceid"`
	Adformat      string `json:"adformat"`
	Src_Obj       string `json:"src_obj"`
	Env_Type      string `json:"env_type"`
	Status        string `json:"status"`
	Provider      string `json:"provider"`
	Adtype        string `json:"adtype"`
	Thirdpartytag string `json:"thirdpartytag"`
	Bidprice      string `json:"bidprice"`
	FileName      string `json:"filename"`
	HTML          string `json:"HTML"`
	Width         string `json:"width"`
	Height        string `json:"height"`
}

type ConnAdSourceDetails struct {
	Adsourceid string `json:"adsourceid"`
}

type ConnAdunitDetails struct {
	Priorty_1 []ConnAdSourceDetails
	Priorty_2 []ConnAdSourceDetails
	Priorty_3 []ConnAdSourceDetails
	Priorty_4 []ConnAdSourceDetails
	Priorty_5 []ConnAdSourceDetails
}

type ProviderDetails struct {
	Provider_id  string `redis:"provider_id"`
	Type         string `redis:"type"`
	ProviderSrc  string `redis:"providersrc"`
	Descrption   string `redis:"descrption"`
	Publisher_id string `redis:"publisher_id"`
	Status       string `redis:"status"`
}

type GlobalVariables struct {
	R               *http.Request
	Ip_address      string
	Latitude        string
	Longitude       string
	Country_code    string
	Country_name    string
	Subdivision_one string
	Subdivision_two string
	Continent       string
	City            string
	Postal_code     string
	UsMetro         string
	Organisation    string
	ConnectionType  string
	Useragent       string
	DeviceName      string
	DeviceModel     string
	DeviceType      string
	Os              string
	Osv             string
	OsShort         string
	Language        string
	Domain          string
	Browser         string
	BrowserVersion  string
	BrowserShort    string
	Hostname        string
	PageURL         string
	RefURL          string
	DomainName      string
	Source          string
}
