package deliverylimitation

import (
	"alpha/addelivery/globalvariaables"
	"alpha/addelivery/structure"
	"fmt"
	"net/http"
)

type DeliverLimitStruct struct {
	R               *http.Request
	Ip_address      string
	Latitude        string
	Longitude       string
	Country_code    string
	Country_name    string
	Subdivision_one string
	Subdivision_two string
	Continent       string
	City            string
	Postal_code     string
	UsMetro         string
	Organisation    string
	ConnectionType  string
	Useragent       string
	Os              string
	Osv             string
	OsShort         string
	Language        string
	Domain          string
	Browser         string
	BrowserVersion  string
	BrowserShort    string

	Hostname   string
	PageURL    string
	RefURL     string
	DomainName string
	Source     string
}

func CheckTargeting(adunit structure.AdUnitDetails, r *http.Request) {
	globalvariables := globalvariaables.SetAllGrobalVariables(r)

	Deliverylimitation := DeliverLimitStruct{
		R:               globalvariables.R,
		Ip_address:      globalvariables.Ip_address,
		Latitude:        globalvariables.Latitude,
		Longitude:       globalvariables.Longitude,
		Country_code:    globalvariables.Country_code,
		Country_name:    globalvariables.Country_name,
		Subdivision_one: globalvariables.Subdivision_one,
		Continent:       globalvariables.Continent,
		City:            globalvariables.City,
		Useragent:       globalvariables.Useragent,
		Os:              globalvariables.Os,
		Osv:             globalvariables.Osv,
		OsShort:         globalvariables.OsShort,
		Language:        globalvariables.Language,
		Domain:          globalvariables.Domain,
		Browser:         globalvariables.Browser,
		BrowserVersion:  globalvariables.BrowserVersion,
		BrowserShort:    globalvariables.BrowserShort,
		Hostname:        globalvariables.Hostname,
		PageURL:         globalvariables.PageURL,
		RefURL:          globalvariables.RefURL,
		DomainName:      globalvariables.DomainName,
		Source:          globalvariables.Source}

	fmt.Printf("Delivery variables : %+v\n", Deliverylimitation)
}
