package adunit

import (
	"alpha/addelivery/structure"
	"fmt"
)

func GetAdunitDetails(adunit1 *structure.AdmaruOutput) bool {
	adunit_id := adunit1.Adunit_id
	adunit_info := FetchAdunitModel(adunit_id)

	adunit1.Adunit_details = adunit_info
	return true
}

func GetAdsourceDetails(admaruoutput *structure.AdmaruOutput) {
	adunit_id := admaruoutput.Adunit_id
	connDetails := FetchConnDetails(adunit_id)
	listOfConnections := make(map[string][]structure.ConnAdSourceDetails)
	listOfProviders := make(map[string]structure.ProviderDetails)
	listOfConnections["priority_1"] = connDetails.Priorty_1
	listOfConnections["priority_2"] = connDetails.Priorty_2
	listOfConnections["priority_3"] = connDetails.Priorty_3
	listOfConnections["priority_4"] = connDetails.Priorty_4
	listOfConnections["priority_5"] = connDetails.Priorty_5

	connectionidx := []string{"priority_1", "priority_2", "priority_3", "priority_4", "priority_5"}
	filteredconnections := []structure.AdSourceDetails{}
	for _, i := range connectionidx {
		singlePriority := listOfConnections[i]
		for j := range singlePriority {
			adsource_id := singlePriority[j].Adsourceid

			adsource_info := FetchAdsourceModel(adsource_id)
			if adsource_info.Status == "1" {
				filteredconnections = append(filteredconnections, adsource_info)
			}
		}
		if filteredconnections != nil {
			break
		}

	}
	admaruoutput.Adsource_details = filteredconnections
	fmt.Printf(" filteredconnections :%+v\n", filteredconnections)
	fmt.Printf(" filteredconnections :%+v\n", admaruoutput.Adsource_details[0].Provider)
	for i := 0; i < len(admaruoutput.Adsource_details); i++ {
		fmt.Println("called")
		provider := admaruoutput.Adsource_details[i].Provider
		provider_info := FetchProviderDetails(provider)
		listOfProviders[admaruoutput.Adsource_id] = provider_info
	}
	fmt.Printf("listOfProviders :%+v\n", listOfProviders)
}
