package addelivery

import (
	"alpha/addelivery/adunit"
	"alpha/addelivery/deliverylimitation"
	"alpha/addelivery/helper"

	"alpha/addelivery/structure"
	config "alpha/configuration"
	"net/http"
)

func AdAsyncTag(w http.ResponseWriter, r *http.Request) string {
	admaruOutput := structure.AdmaruOutput{}
	admaruOutput.R = r
	admaruOutput.Adunit_type = "async"
	admaruOutput.Adunit_id = helper.GetUrlParam(r, "adunitid")
	adunit.GetAdunitDetails(&admaruOutput)
	adunit.GetAdsourceDetails(&admaruOutput)
	deliverylimitation.CheckTargeting(admaruOutput.Adunit_details, r)
	var htmltext string

	// ImgTag := ""

	FileName := "index.jpg"
	Height := "159"
	Width := "318"

	HTML := `<img src='` + config.GetConfig("protocol", "webpath") + config.GetConfig("images", "webpath") + `/` + FileName + `' width='` + Width + `' height='` + Height + `' alt='' title='' border='0' /><div id='beacon_` + "gfg" + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'></div>`

	htmltext = HTML

	return adunit.ConvertJs(htmltext)

}
