package configuration

import (
	//~ "fmt"
	"log"
	"os"

	"github.com/joho/godotenv"
	//~ "crypto/md5"
)

func init() {

	configpath := "configuration"
	err := godotenv.Load(configpath + ".env")

	if err != nil {
		log.Fatalf("Error loading " + configpath + ".env file")
	}
}

func GetConfig(key string, tab string) string {

	return os.Getenv(tab + "_" + key)
}

func GetDatabaseConfig() map[string]string {

	databaseVariables := []string{"type", "host", "socket", "port", "username", "password", "name", "persistent", "mysql4_compatibility", "protocol", "compress", "ssl", "capath", "ca"}

	databaseConfig := make(map[string]string)

	for _, i := range databaseVariables {
		databaseConfig[i] = os.Getenv("database_" + i)
	}

	return databaseConfig
}
