package structure

import (
	"net/http"
)

type AdmaruOutput struct {
	R                  *http.Request
	Adunit_id          string
	Adunit_details     AdUnitDetails
	Adsource_details   AdSourceDetails
	ConnAdunit_details ConnAdunitDetails
	Html               string
	HtmlInterface      map[string]interface{}
	Adsource_id        string
	Internal_ad        bool
	External_ad        bool
	Publisher_type     string
	Adunit_type        string
	Delivery_type      int
}

type AdUnitDetails struct {
	Adunit_id   string `redis:"adunit_id"`
	Adunit_type string `redis:"adunit_type"`
	Envtype     string `redis:"envtype"`
	Status      string `redis:"status"`
}

type AdSourceDetails struct {
	Adsourceid    string `json:"adsourceid"`
	Adformat      string `json:"adformat"`
	Src_Obj       string `json:"src_obj"`
	Env_Type      string `json:"env_type"`
	Status        string `json:"status"`
	Format        string `json:"adformat"`
	Provider      string `json:"provider"`
	Adtype        string `json:"adtype"`
	Thirdpartytag string `json:"thirdpartytag"`
	Bidprice      string `json:"bidprice"`
	FileName      string `json:"filename"`
	HTML          string `json:"HTML"`
	Width         string `json:"width"`
	Height        string `json:"height"`
}

type ConnAdSourceDetails struct {
	Adsourceid    string  `json:"adsourceid"`
	Adformat      int     `json:"adformat"`
	Src_Obj       string  `json:"src_obj"`
	Env_Type      int     `json:"env_type"`
	Status        string  `json:"status"`
	Format        string  `json:"adformat"`
	Provider      string  `json:"provider"`
	Adtype        string  `json:"adtype"`
	Thirdpartytag string  `json:"thirdpartytag"`
	Bidprice      float64 `json:"bidprice"`
	FileName      string  `json:"filename"`
	HTML          string  `json:"HTML"`
	Width         string  `json:"width"`
	Height        string  `json:"height"`
}

// type ConnAdunitAdsource struc
// 	Priority_1 []AdSourceDetails `redi
// 	Priority_2 []AdSourceDetails `redis:
// 	Priority_3 []AdSourceDetails `red3"`
///}

//

type ConnAdunitDetails struct {
	Priorty_1 []ConnAdSourceDetails
	Priorty_2 []ConnAdSourceDetails
	Priorty_3 []ConnAdSourceDetails
	Priorty_4 []ConnAdSourceDetails
	Priorty_5 []ConnAdSourceDetails
}

type ProviderDetails struct {
	Providerid   string `redis:"provider_id"`
	Providertype string `redis:"type"`
	ProviderSrc  string `redis:"providersrc"`
	Description  string `redis:"descrption"`
	Publisherid  string `redis:"publisher_id"`
	Status       string `redis:"status"`
}

// func (s *AdUnitDetails) FillStruct(m map[string]string) error {

// 	for k, v := range m {

// 		fmt.Printf("k :%+v\n and V:%+v\n", k, v)
// 		err := SetField(s, k, v)
// 		if err != nil {
// 			return err
// 		}
// 	}
// 	return nil
// }

// func SetField(obj interface{}, name string, value string) error {
// 	structValue := reflect.ValueOf(obj).Elem()
// 	structFieldValue := structValue.FieldByName(name)

// 	if !structFieldValue.IsValid() {
// 		return fmt.Errorf("No such field: %s in obj", name)

// 	}

// 	// fmt.Printf("datatype: %v", structFieldValue.Type())
// 	if !structFieldValue.CanSet() {
// 		return fmt.Errorf("Cannot set %s field value", name)
// 	}

// 	structFieldType := structFieldValue.Type()
// 	// fmt.Printf("datatype: %v", structFieldType)
// 	val := reflect.ValueOf(value)
// 	// fmt.Printf("value: %s", val)
// 	if structFieldType != val.Type() {
// 		invalidTypeError := errors.New("Provided value type didn't match obj field type")
// 		return invalidTypeError
// 	}

// 	structFieldValue.Set(val)
// 	return nil
// }
