package adunit

import (
	"alpha/addelivery/structure"
	"alpha/redisclient"
	"encoding/json"
	"fmt"

	"strings"

	"github.com/mitchellh/mapstructure"
)

var redisrepo = redisclient.Initialize()

func FetchAdunitModel(adunit_id string) structure.AdUnitDetails {
	adunit := structure.AdUnitDetails{}
	hashmap := make(map[string]string)
	redisrepo.HGetKey("AdUnit_"+adunit_id, hashmap)
	fmt.Printf("adunitredis map:%+v\n", hashmap)
	mapstructure.Decode(hashmap, &adunit)
	fmt.Printf("struct data :%+v\n", adunit)
	return adunit

}

func FetchAdsourceModel(adsource_id string) structure.AdSourceDetails {
	adsource := structure.AdSourceDetails{}
	hashmap := make(map[string]string)
	// adsource_id_str := strconv.Itoa(adsource_id)
	redisrepo.HGetKey("Adsource_"+adsource_id, hashmap)
	mapstructure.Decode(hashmap, &adsource)
	return adsource

}

func FetchConnDetails(conn_id string) structure.ConnAdunitDetails {

	// // connDetails := structure.ConnAdunitDetails{}
	// priority_1 := []structure.ConnAdSourceDetails{}
	// priority_2 := []structure.ConnAdSourceDetails{}
	// priority_3 := []structure.ConnAdSourceDetails{}
	// // demo := structure.ConnAdSourceDetails{}
	// priority_4 := []structure.ConnAdSourceDetails{}
	// priority_5 := []structure.ConnAdSourceDetails{}
	connectedstruct := structure.ConnAdunitDetails{}
	// connDetails_id_str := strconv.Itoa(adunit_id)
	hashmap := make(map[string]string)
	redisrepo.HGetKey("sample4", hashmap)
	fmt.Printf("sample4 map:%+v\n", hashmap)
	for k, v := range hashmap {
		fmt.Printf("Keys :%+v\n", k)
		fmt.Printf("value :%+v\n", v)
		if k == "priority_1" {
			err := json.Unmarshal([]byte(v), &connectedstruct.Priorty_1)
			if err != nil {
				fmt.Println(err)
			}
		} else if k == "priority_2" {
			err := json.Unmarshal([]byte(v), &connectedstruct.Priorty_2)
			if err != nil {
				fmt.Println(err)
			}
		} else if k == "priority_3" {
			err := json.Unmarshal([]byte(v), &connectedstruct.Priorty_3)
			if err != nil {
				fmt.Println(err)
			}
		} else if k == "priority_4" {
			err := json.Unmarshal([]byte(v), &connectedstruct.Priorty_4)
			if err != nil {
				fmt.Println(err)
			}
		} else if k == "priority_5" {
			err := json.Unmarshal([]byte(v), &connectedstruct.Priorty_5)
			if err != nil {
				fmt.Println(err)
			}
		} else {
			fmt.Println("Empty Connected Adunit and Adsource")
		}
		// mapstructure.Decode(v, &priority_3)
	}

	// mapstructure.Decode(hashmap, &priority_3)
	// fmt.Printf("priority_1 map:%+v\n", priority_1)
	// fmt.Printf("priority_2 map:%+v\n", priority_2)
	// fmt.Printf("priority_3 map:%+v\n", priority_3)
	// fmt.Printf("priority_4 map:%+v\n", priority_4)
	// fmt.Printf("priority_5 map:%+v\n", priority_5)
	// demo = priority_3[0]
	// fmt.Printf("demo map:%+v\n", demo.)
	// err:=json.Unmarshal(priority_3[0],&demo)
	// if err !=nil{
	// 	fmt.Println(err)

	// connectedstruct := structure.ConnAdunitDetails{}
	// connectedstruct.Priorty_1 = priority_1
	// connectedstruct.Priorty_2 = priority_2
	// connectedstruct.Priorty_3 = priority_3
	// connectedstruct.Priorty_4 = priority_4
	// connectedstruct.Priorty_5 = priority_5
	// }

	fmt.Printf("connectedstruct :%+v\n", connectedstruct)
	return connectedstruct
}

func FetchProviderDetails(provider_id string) structure.ProviderDetails {
	provider := structure.ProviderDetails{}
	hashmap := make(map[string]string)
	// adsource_id_str := strconv.Itoa(adsource_id)
	redisrepo.HGetKey("Provider_"+provider_id, hashmap)
	mapstructure.Decode(hashmap, &provider)
	return provider

}

func ConvertJs(html string) string {

	var jsLines []string
	var search []string
	var replace []string

	search = append(search, "\\")
	search = append(search, "\r")
	search = append(search, "'")
	search = append(search, "<")

	replace = append(replace, "\\\\")
	replace = append(replace, "")
	replace = append(replace, "\\'")
	replace = append(replace, "<'+'")

	for i, element := range search {

		html = strings.ReplaceAll(html, element, replace[i])
	}

	lines := strings.Split(html, "\n")

	for _, e := range lines {

		if strings.Trim(e, "") != "" {

			jsLines = append(jsLines, "ox_name += '"+strings.Trim(e, "")+"';\n")
		}

	}

	buffer := "var ox_name = '';\n "
	buffer = buffer + strings.Join(jsLines, "\n")
	buffer = buffer + "\ndocument.write(ox_name);\n"

	return buffer

}
