<?php


require_once LIB_PATH . '/Extension/invocationTags/InvocationTags.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';

/**
 *
 * Invocation tag plugin.
 *
 */
class Plugins_InvocationTags_OxInvocationTags_inbanner extends Plugins_InvocationTags
{

    /**
     * Return name of plugin
     *
     * @return string
     */
    function getName()
    {
        return $this->translate("In-Banner");
    }

    /**
     * Return the English name of the plugin. Used when
     * generating translation keys based on the plugin
     * name.
     *
     * @return string An English string describing the class.
     */
    function getNameEN()
    {
        return 'Inbanner';
    }

    /**
     * Check if plugin is allowed
     *
     * @return boolean  True - allowed, false - not allowed
     */
    function isAllowed($extra)
    {
        $isAllowed = parent::isAllowed($extra);
        return true;
    }

    function getOrder()
    {
        parent::getOrder();
        return 11;
    }

    /**
     * Return list of options
     *
     * @return array    Group of options
     */
    function getOptionsList()
    {
        if (is_array($this->defaultOptions)) {
            if (in_array('cacheBuster', $this->defaultOptions)) {
                unset($this->defaultOptions['cacheBuster']);
            }
        }
        $options = array (
            'width'    	=> MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            'height'    	=> MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            'getZoneSize'   => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            'getBgImage'    => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
        );
       return $options;
    }

    /**
     * Return invocation code for this plugin (codetype)
     *
     * @return string
     */
    function generateInvocationCode()
    {
        $aComments = array(
            'SSL Delivery Comment' => '',
            'Comment'              => $this->translate("
  * This noscript section of this tag only shows image banners. There
  * is no width or height in these banners, so if you want these tags to
  * allocate space for the ad before it shows, you will need to add this
  * information to the <img> tag.
  *
  * If you do not want to deal with the intricities of the noscript
  * section, delete the tag (from <noscript>... to </noscript>). On
  * average, the noscript tag is called from less than 1% of internet
  * users."),
            );
        parent::prepareCommonInvocationData($aComments);

  /*VIDEO JS*/ 

        $conf = $GLOBALS['_MAX']['CONF'];
        $mi = &$this->maxInvocation;
		$zoneid=$mi->zoneid;
	    $position=$mi->position;
        if (isset($_POST['zone_height'])&& $_POST['zone_height'] != 0) {
			$zone_size = $_POST['zone_height'];
            
		}else{
            $zone_size = "1";
        }

        if (isset($_POST['bg_img'])&& $_POST['bg_img'] != NULL) {
            $bg_image = $_POST['bg_img'];
        }
		 
        
	$way=$conf['webpath']['admin'].'/plugins/Outstream/delivery/inbanner.php';
	$buffer  = "<script type='text/javascript'><!--//<![CDATA[
    var adurl = (location.protocol=='https:'?'https://$way':'http://$way');
    document.write (\"<\" + \"script language='JavaScript' \");
    document.write (\"type='text/javascript' src='\"+adurl);
    document.write (\"?zoneid={$zoneid}\");
    document.write (\"&amp;zone_size={$zone_size}\");
    document.write (\"&amp;bg_image_url={$bg_image}\");
    document.write (\"&amp;position={$position}";

	$buffer .="\");\n";
	$buffer .= "   document.write (\"&amp;loc=\" + escape(window.location));\n";
    $buffer .= "   if (document.referrer) document.write (\"&amp;referer=\" + escape(document.referrer));\n";
       $buffer .= "   document.write (\"&amp;display_width=\" + window.innerWidth);\n";
       
	$buffer .= "   document.write (\"'><\\/scr\"+\"ipt>\");\n";
    $buffer .= "//]]>--></script>"; 

        return $buffer;
    }

    function setInvocation(&$invocation) {

        $this->maxInvocation = &$invocation;
        $this->maxInvocation->canDetectCharset = true;

    }


}

?>
