<?php

require_once MAX_PATH . '/lib/OA.php';
require_once MAX_PATH . '/lib/max/Plugin/Common.php';
require_once LIB_PATH . '/Extension/bannerTypeHtml/bannerTypeHtml.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';

if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

class Plugins_BannerTypeHTML_Outstream_Outstream extends Plugins_BannerTypeHTML
{
    /**
     * Return type of plugin
     *
     * @return string A string describing the type of plugin.
     */
     
    function getStorageType()
    {
        return 'html';
    }

    /**
     * Return the media (content) type
     *
     */
    function getContentType()
    {
        return 'html';
    }
     
    function getOptionDescription()
    {
        //return $this->translate("Outstream video Ads");
        return $this->translate("In-Banner video Ads");
    }

    function validateForm(&$form)
    {
        return true;
    }

    function processForm($insert, $bannerid, $aFields , $aVariables)
    {

        $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
        $img_type = 'web';

        $aVariables['storagetype'] = 'html' ;
        $bg_img = array();
        $thumb_img = array();

        if (!empty($_FILES['bg_image']) && $_FILES['bg_image']['size'] > 0) { 

            $oFile = OA_Creative_File::factoryUploadedFile('bg_image');
            checkForErrorFileUploaded($oFile);
            $oFile->store($img_type);
            $aFile = $oFile->getFileDetails();
            if (!empty($aFile)) {
                $bg_img['filename']      = $aFile['filename'];
                $bg_img['contenttype']   = $aFile['contenttype'];
                $bg_img['width']         = $aFile['width'];
                $bg_img['height']        = $aFile['height'];
                $bg_img['pluginversion'] = $aFile['pluginversion'];
                $editSwf                 = $aFile['editswf'];
            }

            
            // Delete old file for this banner
            if (!empty($aVariables['filename']) && ($aVariables['filename'] != $aFile['filename'])) {
                DataObjects_Banners::deleteBannerFile($aVariables['storagetype'], $aVariables['filename']);
            }
        }
        
        if (!empty($_FILES['thumb_image']) && $_FILES['thumb_image']['size'] > 0) { 

            $oFile = OA_Creative_File::factoryUploadedFile('thumb_image');
            checkForErrorFileUploaded($oFile);
            $oFile->store($img_type);
            $aFile1 = $oFile->getFileDetails();
            if (!empty($aFile)) {
                $thumb_img['filename']      = $aFile1['filename'];
                $thumb_img['contenttype']   = $aFile1['contenttype'];
                $thumb_img['width']         = $aFile1['width'];
                $thumb_img['height']        = $aFile1['height'];
                $thumb_img['pluginversion'] = $aFile1['pluginversion'];
                $editSwf                     = $aFile1['editswf'];
            }
            
            // Delete old file for this banner
            if (!empty($aVariables['filename']) && ($aVariables['filename'] != $aFile1['filename'])) {
                DataObjects_Banners::deleteBannerFile($aVariables['storagetype'], $aVariables['filename']);
            }
        }

        $inlinefields = array(
            'video_url'         => $_POST['video_url'],
            'skip'              => $_POST['skip'],
            'bg_image'          => $bg_img['filename'],
            'thumbnail_image'   => $thumb_img['filename'],
            'destination_url'   => $_POST['destination_url'],
            'extension_type'    => $_POST['extension_type'],
            'external_wrapper'  => $_POST['external_wrapper']
        );

        OA_Dal_Delivery_query("update {$table_prefix}banners set parameters = '".
        serialize($inlinefields)."',url='".$_POST['destination_url']."' where bannerid = ".$bannerid);
        
        $doBanners = OA_Dal::factoryDO('banners');
        //print_r($doBanners);
        // Get existing banner details
        if (!empty($bannerid)) {
            if ($doBanners->get($bannerid)) {
                $row = $doBanners->toArray();
            }
        }
        
        $doBanners->setFrom($aVariables);           
        $doBanners->update();

        return true;
    }
     
    function preprocessForm($insert, $bannerid, &$aFields, &$aVariables)
    {
        return true;
    }
    
    function buildForm(&$form, &$row)
    {
        //FETCH VALUE 
        $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
        $array = OA_Dal_Delivery_query("select parameters from {$table_prefix}banners where bannerid ='".$row['bannerid']."' ");
        $values1 = OA_Dal_Delivery_fetchAssoc($array);

        $values = unserialize($values1['parameters']);

        $form->addElement('header', 'header_b_display', 'Banner display');

        $form->addElement('text', 'video_url', 'Video URL');

        $extension_type = array("MP4" => "MP4","WEBM" => "WEBM","HLS" => "HLS");

        $form->addElement('select', 'extension_type','Extension Type',$extension_type); 

        $form->addElement('text', 'skip', 'Skip (In Secs.)', array("placeholder"=> "00:00:00"));
        $form->addElement('text', 'destination_url',"Destination URL");

        addUploadGroup($form, $row,
            array(
                'uploadName' => 'bg_image',
                'radioName' => 'bg_image',
                'imageName'  => $front_image,
                'fileName'  => $values['bg_image'],
                'fileSize'  => $front_size,
                'newLabel'  => "Background Image",
                'updateLabel'  => "Do you wish to keep your existing <b>Background Image</b>, or do you want to upload another?",
                'handleSWF' => true
              )
        );

        addUploadGroup($form, $row,
            array(
                'uploadName' => 'thumb_image',
                'radioName' => 'thumb_image',
                'imageName'  => $front_image1,
                'fileName'  => $values['thumbnail_image'],
                'fileSize'  => $front_size1,
                'newLabel'  => "Thumbnail Image",
                'updateLabel'  => "Do you wish to keep your existing <b>Thumbnail Image</b>, or do you want to upload another?",
                'handleSWF' => true
              )
        );


        $sizeG['width'] = $form->createElement('text', 'width', $GLOBALS['strWidth'].":");
        $sizeG['width']->setAttribute('onChange', 'oa_sizeChangeUpdateMessage("warning_change_banner_size");');
        $sizeG['width']->setSize(5);

        $sizeG['height'] = $form->createElement('text', 'height', $GLOBALS['strHeight'].":");
        $sizeG['height']->setAttribute('onChange', 'oa_sizeChangeUpdateMessage("warning_change_banner_size");');
        $sizeG['height']->setSize(5);

        $form->addGroup($sizeG, 'size', $GLOBALS['strSize'], "&nbsp;", false);

        
        //$form->addElement('fileupload', 'bg_image', 'Background Image');
       

        $front_image = _getContentTypeIconImageName($row['contenttype']);
        $front_size = _getBannerSizeText($type, $row['filename']);   

       
        $front_image1 = _getContentTypeIconImageName($row['contenttype']);
        $front_size1 = _getBannerSizeText($type, $values['thumbnail_image']); 

        $form->addElement('header', 'header_b_links', "Banner link");
        $form->addElement('text', 'tp_tag', 'Third Party Tags (optional)',$tp_tag);

        //~DEFAULT VALUES
        $form->setDefaults(array(extension_type => $values['extension_type']));
        $form->setDefaults(array(video_url => $values['video_url'])); 
        $form->setDefaults(array(destination_url => $values['destination_url'])); 
       
        $form->setDefaults(array(tp_tag => $values['tp_tag'])); 
        $form->setDefaults(array(icon_url => $values['icon_url'])); 
        $form->setDefaults(array(skip => $values['skip'])); 
         $form->setDefaults(array(height => $values['height']));
          $form->setDefaults(array(width => $values['width']));
        $form->setDefaults(array(thumb_image => $values['thumb_image']));
        
        //~UNIQUE BANNER FOR BANNER LINK
        $form->addElement('hidden', 'ext_bannertype', $this->getComponentIdentifier());
        
        $form->addRule('video_url', 'Video Url is Required', 'required');

        $form->addRule('size', 'Size is Required', 'required');
    }


    
}
