<?php
include('session.php');
include('../config.php');
?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/' data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>Adserver - Zone </title>
    <meta name="description" content="" />
    <?php include('head.php'); ?>
    <style>
        label[for=textarea-a],
        #textarea-a {
            display: none;
        }

        #radio-mini-2:checked~label[for=textarea-a],
        #radio-mini-2:checked~#textarea-a {
            display: block;
        }

        /* override */
        label[for=textarea-a],
        #textarea-a {
            display: none;
        }

        #over:checked~label[for=textarea-a],
        #over:checked~#textarea-a {
            display: block;
        }

        /* contract */
        label[for=textarea-a],
        #textarea-a {
            display: none;
        }

        #contract:checked~label[for=textarea-a],
        #contract:checked~#textarea-a {
            display: block;
        }

        /*  Remnant */
        label[for=textarea-a],
        #textarea-a {
            display: none;
        }

        #remnant:checked~label[for=textarea-a],
        #remnant:checked~#textarea-a {
            display: block;
        }

        .inputbox {

            border-radius: 0 !important;
        }

        .cancel-style {
            color: red !important
        }

        .cancel-style:hover {
            color: #fff !important
        }
    </style>

</head>

<body onload="Zone_link()">
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>

            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container">
                        <form name="campaignaddform" action="" method="POST">
                            <div class="card mt-5">
                                <div class="card-header">
                                    <p class="h3 text-secondary">Link Zone With Banners</p>
                                    <br>
                                    <div class="col-md-5">
                                    <h4>Zone : <?php echo $_GET['zonename']; ?> </h4>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="container">
                                        <div class="row">
                                            <div class="col-md-8">
                                                <div class="form-group row mb-2">
                                                    <p class="h6 text-primary mb-2">Please choose what to link to this zone</p>
                                                    <!-- <hr class="solid"> -->
                                                    <div class="mb-4 col-md-6">

                                                        <select id="linking" class="form-select text-dark">
                                                            <option selected value="placement">Link banners by parent campaign
                                                            </option>
                                                            <option value="ad">Link individual banners</option>
                                                        </select>
                                                        <div id="campaigntype_msg">

                                                        </div>
                                                    </div>

                                                </div>
                                            </div>

                                        </div>

                                        <div class="row">
                                            <div class="col-md-8">
                                                <div class="form-group row mb-2">
                                                    <p class="h6 text-primary mb-2">Select the campaign you would like to link to this zone</p>
                                                    <!-- <hr class="solid"> -->
                                                    <div class="col-6" id="sel_advertiser">
                                                        <label class="form-label">Select Advertiser</label>
                                                        <select class="form-select text-dark" id="advertiser" onchange="get_campaign(this.value)">
                        
                                                            <!-- <option value="1">test</option>
                                                              <option value="2">test1</option> -->
                                                        </select>


                                                    </div>
                                                    <div class="col-6" id="sel_campaign">
                                                        <label class="form-label">Select Campaign</label>
                                                        <select class="form-select text-dark" id="campaign" onchange="get_banner(this.value)">
                                                            

                                                        </select>
                                                    </div>
                                                    <div class="col-6" id="sel_banner">
                                                        <label class="form-label">Select Banner</label>
                                                        <select class="form-select text-dark" id="banner">
                                                            

                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="row">


                                                    <div class="row justify-content-right">
                                                        <div class="col">
                                                            <button type="button" class="btn btn-primary" style="position:relative;top:10px" onclick="link()">
                                                                Link
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                        </form>
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-5">
                                    <p class="h3">Linked Banners</p>
                                </div>

                                <hr class="solid">
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="mt-2 mb-4 container">
                                    <div class="table-responsive text-nowrap">
                                        <!-- campaign table -->
                                        <table id="example2" class="table table-striped table-responsive table-hover">
                                            <thead>
                                                <tr class="text-nowrap">
                                                    <th class="th-color text-center"><input type="checkbox" class="form-check-input" id="select-all"></th>
                                                    <th class="th-color text-center">Campaign Name</th>
                                                    <th class="th-color">ID</th>
                                                    <th class="th-color">Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                        <!-- campaign table -->
                                        <!-- banner table -->
                                        <table id="example3" class="table table-striped table-responsive table-hover">
                                            <thead>
                                                <tr class="text-nowrap">
                                                    <th class="th-color text-center"><input type="checkbox" class="form-check-input" id="select-all"></th>
                                                    <th class="th-color text-center">Banner Name</th>
                                                    <th class="th-color">ID</th>
                                                    <th class="th-color">Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                        <!-- campaign table -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php include('footer.php'); ?>
            </div>
        </div>
    </div>


    <script src="../js/sweetalert.min.js"></script>
    <script>
        document.getElementById('sel_campaign').style.display = 'none';

        document.getElementById('sel_banner').style.display = 'none';

        var live_URL = '<?php echo $apiinvenpath; ?>';
        var agency_id = '<?php echo $_SESSION['agencyid']; ?>';
        var zone_id = '<?php echo $_REQUEST['zoneid']; ?>';

        console.log("agency_id", agency_id);
        var token = 'Bearer ' + document.getElementById('token').value;


        //21-06-2023 nithya

        function get_campaign(clientid) {

            document.getElementById('sel_campaign').style.display = 'block';
            document.getElementById('campaign').value = '0';

            //var client_id = document.getElementById('clientid').value;
            //alert(clientid);
            $.ajax({
                type: "GET",
                url: live_URL + '/get_all_campaigns/' + clientid,
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function(data) {
                console.log("campaign res", data.data);
                var campaign_name = [], defaultValue =`<option value="0" selected>Select Campaign</option>`;

                data.data.map((data) => {
                    campaign_name += `<option value=${data.campaignid}>${data.campaignname}</option>`;
                });
                console.log("output", campaign_name);
                // let sortTheCampaign = cam_name.sort(function (a, b) {
                //     return a.campaignname.localeCompare(b.campaignname);
                // });
                // console.log("sort value", sortTheCampaign);
                document.getElementById('campaign').innerHTML = defaultValue + campaign_name;
            });



        }

        function get_banner(campaignid) {
            if (document.getElementById('linking').value == 'placement') {
                document.getElementById('sel_banner').style.display = 'none';
            } else {

                document.getElementById('sel_banner').style.display = 'block';

                document.getElementById('banner').value = 0;
            }
            $.ajax({
                type: "GET",
                url: live_URL + '/get_campaignwise_banner/' + campaignid,
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function(data) {
                console.log("live res", data.data);
                var banner_name = [], defaultValue =`<option value="0" selected>Select Banner</option>`;

                data.data.map((data) => {
                    banner_name += `<option value=${data.bannerid}>${data.description}</option>`;
                });
                console.log("output", banner_name);
                // let sortTheCampaign = cam_name.sort(function (a, b) {
                //     return a.campaignname.localeCompare(b.campaignname);
                // });
                // console.log("sort value", sortTheCampaign);
                document.getElementById('banner').innerHTML = defaultValue + banner_name;
            });



        }
        $('#linking').change(function() {

            document.getElementById('advertiser').value = '0';
            document.getElementById('sel_banner').style.display = 'none';
            document.getElementById('sel_campaign').style.display = 'none';

            var link_option = $('#linking option:selected').val();


            if (link_option == "placement") {

                document.getElementById('example3').style.display = 'none';
                document.getElementById('example2').style.display = 'table';
                table_campaign();
                location.reload();
            } else if (link_option == "ad") {

                document.getElementById('example2').style.display = 'none';
                document.getElementById('example3').style.display = 'table';
                table_banner();

            }

        });

        Zone_link = () => {

            $.ajax({
                type: "GET",
                url: live_URL + '/get_all_advertiser/' + agency_id,
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function(data) {
                console.log("live res", data.data);
                var advertiser_name = [], defaultValue =`<option value="0" selected>Select Advertiser</option>`;

                data.data.map((data) => {
                    advertiser_name += `<option value=${data.clientid}>${data.clientname}</option>`;
                });
                // let sortTheCampaign = cam_name.sort(function (a, b) {
                //     return a.campaignname.localeCompare(b.campaignname);
                // });
                // console.log("sort value", sortTheCampaign);
                document.getElementById('advertiser').innerHTML = defaultValue + advertiser_name;
            });
            var link_option = $('#linking option:selected').val();


            if (link_option == "placement") {
                document.getElementById('example3').style.display = 'none';
                document.getElementById('example2').style.display = 'table';
                table_campaign();
            } else {
                document.getElementById('example2').style.display = 'none';
                document.getElementById('example3').style.display = 'table';
                table_banner();
            }

        };





        function link() {

            var link_option = $('#linking option:selected').val();

            var banner_id = $('#banner option:selected').val();

            var campaign_id = $('#campaign option:selected').val();

            if (link_option == "ad") {
                var values = {
                    "bannerid": "" + banner_id + "",
                }

                var api_url = live_URL + '/adbyzone_link/' + zone_id;

            } else {
                var values = {
                    "campaignid": "" + campaign_id + "",
                }

                var api_url = live_URL + '/campaignbyzone_link/' + zone_id;
            }

            $.ajax({
                type: "POST",
                url: api_url,
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: values,
                dataType: "json",
                encode: true,
            }).done(function(data) {

                swal({
                        title: data.msg,
                        type: "success"
                    })
                    .then(data => {
                        if (data.msg == 'Banners linked successfully to the zoneid!') {
                            table_banner();
                        } else if (data.msg == 'Campaigns linked successfully!') {
                            table_campaign();

                        }
                        location.reload();
                    });
                    
            });

        }


        //             // if (data.msg == 'No Stats Available') {
        // 			// 	$('#example2').DataTable({
        // 			// 		ordering: false,
        // 			// 		destroy: true,
        // 			// 		responsive: true,
        // 			// 		bPaginate: false,                    
        //             //         bAutoWidth : false,
        // 			// 		bInfo: false,
        // 			// 		data:[],
        // 			// 		searching: false,
        // 			// 		oLanguage: {
        // 			// 			sEmptyTable:"No Data Found"
        // 			// 		}
        // 			// 	});
        // 			// }else{
        //                 // alert("hai");

        //             // }
        //         }

        function unlink(campaignid) {

            var unlink_url = live_URL + '/campaignbyzone_unlink/' + zone_id;
            var val = {
                "campaignid": "" + campaignid + "",
            }


            $.ajax({

                type: "POST",
                url: unlink_url,
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: val,
                dataType: "json",
                encode: true,
            }).done(function(data) {

                alert(data.msg);
                location.reload();

            });

        }

        function unlink_banner(bannerid) {

            var unlink_url = live_URL + '/adbyzone_unlink/' + zone_id;
            var val = {
                "bannerid": "" + bannerid + "",
            }


            $.ajax({

                type: "POST",
                url: unlink_url,
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: val,
                dataType: "json",
                encode: true,
            }).done(function(data) {

                alert(data.msg);
                location.reload();

            });

        }

        function table_campaign() {
            var link_option = $('#linking option:selected').val();


            var link_url = live_URL + '/get_tree_campaign/' + zone_id;
            $.ajax({
                type: "GET",
                url: link_url,
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                dataType: 'json',
                encode: true,
                success: function(data) {
                    for (var i = 0; i < data.length; i++) {
                        if(data[i].banners.length<=0){
                            // swal('No Campaign linked with the zone');
                            break;
                        }
                        else{
                        var row = $('<tr><td><input type="checkbox" name="checkrow" class="form-check-input" id="checkrow" onchange="getSelectedCampaign(' + data[i].campaign_id + ')"></td><td style="color:blue"><i class="fa fa-folder" aria-hidden="true"></i>&nbsp;' + data[i].campaign_name + '</td><td>' + data[i].campaign_id + '</td><td><button type="button" class="btn btn-danger" onclick="unlink(' + data[i].campaign_id + ')"> Unlink</button></td></tr>');
                        $('#example2').append(row);
                        for (var j = 0; j < data[i].banners.length; j++) {
                            var ban = data[i].banners[j];
                            var row = $('<tr><td><input type="checkbox" name="checkrow" class="form-check-input" id="checkrow" onchange="getSelectedCampaign(' + ban.banner_id + ')"></td><td style="padding-left:50px;color:#1F51FF"><i class="fa fa-image" aria-hidden="true"></i>&nbsp;' + ban.banner_name + '</td><td>' + ban.banner_id + '</td><td></td></tr>');
                            $('#example2').append(row);

                        }
                    }
                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    alert('Error: ' + textStatus + ' - ' + errorThrown);
                }
            });
        }

        function table_banner() {
            var link_url = live_URL + '/get_linked_banners/' + zone_id;
            $.ajax({
                type: "GET",
                url: link_url,
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: 'json',
                encode: true,
                success: function(data) {
                    console.log("live response", data);
                    for (var i = 0; i < data.data.length; i++) {
                        var row = $('<tr><td><input type="checkbox" name="checkrow" class="form-check-input" id="checkrow" onchange="getSelectedCampaign(' + data.data[i].bannerid + ')"></td><td style="color:#1F51FF"><i class="fa fa-image" aria-hidden="true"></i>&nbsp;' + data.data[i].description + '</td><td>' + data.data[i].bannerid + '</td><td><button type="button" class="btn btn-danger" onclick="unlink_banner(' + data.data[i].bannerid + ')"> Unlink</button></td></tr>');
                        $('#example3').append(row);

                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    alert('Error: ' + textStatus + ' - ' + errorThrown);
                }
            });
        }
    </script>

</body>
</html>