<?php
/*
 * 
 * File Created by DAC141
 * 
 */

/*--------------- Start of Advertiser Statistics ------------*/







$app->get('/get_widgets_advertiser_campaign_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them group by campaignid
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date ='';
		$end_date = '';
		if($client)
		{
	        $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();				
			
			$timezone = $TimeZoneRow[0]['timezone'];			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			
			$sql="select 			
			sum(h.impressions) as all_imps,
			sum(h.clicks) as all_clks,
			sum(h.conversions) as all_convs,
			sum(h.impressions) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	,
			round(sum(h.total_revenue),2) as spend,		
			-- c.campaignname as campaignname,			
			DATE(h.date_time) as date_time
	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
		
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by DATE(h.date_time)";

			// print_r($sql);exit;
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);
		$sth->execute();		
		$todos = $sth->fetchAll();	
		// print_r($todos);
		if($todos)
		{
			foreach($todos as $todo) {
				$imps += $todo['all_imps'];
				
				$clks += $todo['all_clks'];
				
				$convs += $todo['all_convs'];
								
				$todo['impressions'] = $imps;
				
				$todo['clicks'] = $clks;
				
				$todo['conversions'] = $convs;
				
				$data[] = $todo;
			}
			return $this->response->withJson($data);
		}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
		return $this->response->withJson($response);
		}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));




//widgets-----------get all-----------------------------------------



	
$app->get('/get_all_widgets_advertiser_campaign_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them group by campaignid
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');

		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		
		if($client)
		{
			// $sql="select 			
			// sum(h.impressions) as impressions,
			// sum(h.clicks) as clicks,
			// sum(h.conversions) as conversions,
			// sum(h.impressions) as requests,
			// round(sum(h.total_revenue),2) as revenue,
			// round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			// round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	,
			// round(sum(h.total_revenue),2) as spend,		
			// c.campaignname as campaignname,
			
			// DATE(h.date_time) as date_time
	
			// from
			// ".$table_prefix."data_summary_ad_hourly as h,
			// ".$table_prefix."banners as b,
			// ".$table_prefix."campaigns as c,
			// ".$table_prefix."clients as cl 
			
			// where
		
			// h.ad_id = b.bannerid
			// AND c.campaignid = b.campaignid
			// AND c.clientid = cl.clientid
			// AND cl.clientid = :advertiserid	";
			
			$sql="select 			

			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.impressions) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	,
			round(sum(h.total_revenue),2) as spend	
		
	
			from
			rv_data_summary_ad_hourly as h,
			rv_banners as b,
			rv_campaigns as c,
			rv_clients as cl 
			where
		
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			
			AND cl.clientid = :advertiserid";

		
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);
		$sth->execute();		
		$todos = $sth->fetchAll();	
		// print_r($todos);
		if($todos)
		{
			return $this->response->withJson($todos);
		}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
		return $this->response->withJson($response);
		}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});




//xandr widgets statistics 
	
$app->get('/get_all_xandr_widgets_advertiser_campaign_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them group by campaignid
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');

		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		
		if($client)
		{		
			$sql="select 		
			sum(x.impressions) as impressions,
			sum(x.clicks) as clicks,
			sum(x.ctr) as ctr,	
			round(sum(x.total_revenue),2) as revenue,	
			sum(x.ecpm) as ecpm,		
			round(sum(x.total_revenue),2) as spend,
			sum(x.total_convs) as conversions,
			sum(x.impressions) as requests,	
			c.campaignid as campaignid,		
			c.campaignname as campaignname,			
			x.date as date_time
	
			from
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl ,
			".$table_prefix."xandr_reports as x 
			where
			x.creative_id=b.xandrcreativeid			
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid	
			group by c.campaignid,x.date";

		
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);
		$sth->execute();		
		$todos = $sth->fetchAll();	
		// print_r($todos);
		if($todos)
		{
			
			$finalArray = array();
			

			foreach ($todos as $discount) {
			
				$finalArray['impressions'] += $discount['impressions'];
				$finalArray['clicks'] += $discount['clicks'];
				$finalArray['requests'] += $discount['requests'];
				$finalArray['conversions'] += $discount['conversions'];

				
			}
			


$finalArray1[] = $finalArray;
		
			return $this->response->withJson($finalArray1);
		}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
		return $this->response->withJson($response);
		}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});








//All  revive Top websites 

$app->get('/get_all_top_banner_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
			
		// $sql="select 
		// c.campaignname as campaignname,
		// b.description as bannername,
		// DATE(h.date_time) as date_time,
		// sum(h.impressions) as impressions,
		// sum(h.clicks) as clicks,
		// sum(h.conversions) as conversions,
		// round(sum(h.total_revenue),2) as spend,
		// round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
		// from
		// ".$table_prefix."data_summary_ad_hourly as h,
		// ".$table_prefix."banners as b,
		// ".$table_prefix."campaigns as c,
		// ".$table_prefix."clients as cl 
		// where
		// h.ad_id = b.bannerid
		// AND c.campaignid = b.campaignid
		// AND c.clientid = cl.clientid
		// AND cl.clientid = :advertiserid
		// group by b.bannerid ORDER BY spend DESC limit 5";


		$sql="select 
		
			a.name as affiliatename,			
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as spend,
			round((sum(h.clicks)/sum(h.impressions)) * 100,0) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."zones as z,
			".$table_prefix."affiliates as a,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			z.affiliateid = a.affiliateid			
			 AND h.zone_id = z.zoneid
			 AND h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid			
			 group by a.affiliateid ORDER BY ctr DESC limit 5";


		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);
		$sth->execute();
		$todos = $sth->fetchAll();	

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});





//  revive Top websites  Statistics

$app->get('/get_top_banner_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		$start_date ='';
		$end_date = '';
		if($client)
		{
		    $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();			
			
			$timezone = $TimeZoneRow[0]['timezone'];			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			
			$sql="select 
			a.name as affiliatename,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as spend,
			round((sum(h.clicks)/sum(h.impressions)) * 100,0) as ctr,

			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."zones as z,
			".$table_prefix."affiliates as a,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			z.affiliateid = a.affiliateid
			 AND
			h.zone_id = z.zoneid
			AND h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by a.name
			 ORDER BY impressions DESC limit 5";
			
			 // echo "<pre>";print_r($sql);exit;
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);
			$sth->execute();
			$todos = $sth->fetchAll();			

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}  
}
 
})->add($container->get('datevalidation'));






// Get Advertiser campaign Statistics

$app->get('/get_advertiser_campaign_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them group by campaignid
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date ='';
		$end_date = '';
		if($client)
		{
	        $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			$sql="select 

			sum(x.impressions) as impressions,
			sum(x.clicks) as clicks,
			sum(x.ctr) as ctr,	
			round(sum(x.total_revenue),2) as revenue,	
			sum(x.ecpm) as ecpm,		
			round(sum(x.total_revenue),2) as spend,
			sum(x.total_convs) as conversions,
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			h.ad_id as ad_id,
			b.bannerid as bannerid,
			b.description as bannername,
			DATE(h.date_time) as date_time,			
			sum(x.impressions) as requests
		
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl ,
			".$table_prefix."xandr_reports as x 
			where
			x.creative_id=b.xandrcreativeid
			AND h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."'";



		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		
		$todos = $sth->fetchAll();

		// print_r($todos );
		
		if($todos)
		{
			if(!empty($todos[0]['ad_id']))
			{
				return $this->response->withJson($todos);
			}
			else{
				$response = array('response'=>'ok','msg'=>'No Stats Available');
				return $this->response->withJson($response);
			}
		}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
		return $this->response->withJson($response);
		}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));









// Get Advertiser campaign Statistics

$app->get('/get_xandr_advertiser_campaign_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them group by campaignid
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date ='';
		$end_date = '';
		if($client)
		{
	        $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			$sql="select 

			sum(x.impressions) as xandr_impressions,
			sum(x.clicks) as xandr_clicks,
			round(sum(x.ctr),2) as xandr_ctr,			
			round(sum(x.ecpm),2) as xandr_ecpm,
			
			round(sum(x.total_revenue),2) as revenue,			
			round(sum(x.total_revenue),2) as spend,
			sum(x.total_convs) as conversions,
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			h.ad_id as ad_id,
			b.bannerid as bannerid,
			b.description as bannername,
			DATE(h.date_time) as date_time,			
			sum(x.impressions) as requests
		
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl ,
			".$table_prefix."xandr_reports as x 
			where
			x.creative_id=b.xandrcreativeid
			AND h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."'";



		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		
		$todos = $sth->fetchAll();

		// print_r($todos );
		
		if($todos)
		{
			if(!empty($todos[0]['ad_id']))
			{
				return $this->response->withJson($todos);
			}
			else{
				$response = array('response'=>'ok','msg'=>'No Stats Available');
				return $this->response->withJson($response);
			}
		}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
		return $this->response->withJson($response);
		}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));



// All Advertiser Campaign Statistics

$app->get('/get_all_dashboard_advertiser_campaign_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		if($client)
		{			
			$sql="select 
			sum(x.impressions) as xandr_impressions,
			sum(x.clicks) as xandr_clicks,
			round(sum(x.ctr),2) as xandr_ctr,			
			round(sum(x.ecpm),2) as xandr_ecpm,		
			round(sum(x.total_revenue),2) as revenue,			
			round(sum(x.total_revenue),2) as spend,
			sum(x.total_convs) as conversions,
			-- cl.clientid as clientid,
			-- cl.clientname as clientname,
			c.campaignid as campaignid,
			c.campaignname as campaignname,
			b.bannerid as bannerid,
			b.description as bannername,
			x.date as date_time,		
			sum(x.impressions) as requests
			
			from
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl ,
			".$table_prefix."xandr_reports as x 
			where
			x.creative_id=b.xandrcreativeid		
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			group by c.campaignid,b.bannerid,x.date";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);
		$sth->execute();		
		$todos = $sth->fetchAll();

		if($todos)
		{
		if(!empty($todos[0]['ad_id']))
			{
				return $this->response->withJson($todos);
			}
			else{
				$response = array('response'=>'ok','msg'=>'No Stats Available');
				return $this->response->withJson($response);
			}
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});






//camp id Graph Statistics

$app->get('/get_campaignid_campaign_graph_statistics/[{start_date},{end_date},{campaign_id}]', function($request, $response, $args)
{
	// print_r(campaign_id);exit;
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$campaign_id = $args['campaign_id']; 
		//echo "....hiiii...";
		//print_r(campaign_id);exit;
		$stc = "select * from ".$table_prefix."banners where campaignid=:campaignid";
		$std = $this->db->prepare($stc);
		$std->bindParam("campaignid",$campaignid);
		$std->execute();
		$client = $std->fetchAll();
        $start_date ='';
		$end_date = '';
		if($client)
		{
		    $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			$sql="select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
			TIMESTAMP(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.impressions) as requests,
			round(sum(h.total_revenue),0) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,0) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND cl.clientid = c.clientid
			AND c.clientid = :campaignid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by c.campaignid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":campaignid",$campaignid);

			$sth->execute();

			$todos = $sth->fetchAll();
			
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));




//banner  Graph Statistics

$app->get('/get_all_dashboard_banner_graph_statistics/[{bannerid}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$bannerid = $args['bannerid']; 

	
		$stc = "select * from ".$table_prefix."banners where bannerid=:bannerid";
		$std = $this->db->prepare($stc);
		$std->bindParam("bannerid",$bannerid);
		$std->execute();
		$campaigns = $std->fetchAll();

		if($campaigns)
		{					
			$sql="select 
			--cl.clientid as clientid,
			b.bannerid as bannerid,
			b.description as bannername,
			--cl.clientname as clientname,
			c.campaignid as campaignid,
			c.campaignname as campaignname,
			--TIMESTAMP(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.impressions) as requests,
			round(sum(h.total_revenue),0) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,0) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			h.ad_id = b.bannerid			
			AND cl.clientid = c.clientid
			AND c.campaignid = b.campaignid
			AND b.bannerid = :bannerid
			group by b.bannerid,c.campaignid";			

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":bannerid",$bannerid);		
			$sth->execute();
			$todos = $sth->fetchAll();		
			
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});




//xandr banner  Graph Statistics

$app->get('/get_all_xandr_banner_graph_statistics/[{bannerid}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$bannerid = $args['bannerid']; 

	
		$stc = "select * from ".$table_prefix."banners where bannerid=:bannerid";
		$std = $this->db->prepare($stc);
		$std->bindParam("bannerid",$bannerid);
		$std->execute();
		$campaigns = $std->fetchAll();

		if($campaigns)
		{	
			$sql="select 
			sum(x.impressions) as impressions,
			sum(x.clicks) as clicks,
			round(sum(x.ctr),2) as ctr,			
			round(sum(x.ecpm),2) as ecpm,
			round(sum(x.total_revenue),2) as revenue,		
			round(sum(x.total_revenue),2) as spend,
			sum(x.total_convs) as conversions,
			cl.clientid as clientid,
			cl.clientname as clientname,
			c.campaignid as campaignid,
			c.campaignname as campaignname,
			b.bannerid as bannerid,
			b.description as bannername,
			sum(x.impressions) as requests
			from
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl ,
			".$table_prefix."xandr_reports as x 
			where
			x.creative_id=b.xandrcreativeid
			AND cl.clientid = c.clientid
			AND c.campaignid = b.campaignid
			AND b.bannerid = :bannerid			
			group by b.bannerid";
					

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":bannerid",$bannerid);
			$sth->execute();
			$todos = $sth->fetchAll();

			
			
			// $sql="select 
			// cl.clientid as clientid,
			// b.bannerid as bannerid,
			// b.description as bannername,
			// cl.clientname as clientname,
			// CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
			// TIMESTAMP(h.date_time) as date_time,
			// sum(h.impressions) as impressions,
			// sum(h.clicks) as clicks,
			// sum(h.conversions) as conversions,
			// sum(h.impressions) as requests,
			// round(sum(h.total_revenue),0) as revenue,
			// round((sum(h.clicks)/sum(h.impressions)) * 100,0) as ctr,
			// round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	
			// from
			// ".$table_prefix."data_summary_ad_hourly as h,
			// ".$table_prefix."banners as b,
			// ".$table_prefix."campaigns as c,
			// ".$table_prefix."clients as cl 
			// where
			// h.ad_id = b.bannerid			
			// AND cl.clientid = c.clientid
			// AND c.campaignid = b.campaignid
			// AND b.bannerid = :bannerid
			// group by b.bannerid";					

			// $sth = $this->db->prepare($sql);
			// $sth->bindParam(":bannerid",$bannerid);			
			// $sth->execute();
			// $todos = $sth->fetchAll();
			
		
	
			
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});





//revive---banner  Graph Statistics

$app->get('/get_revive_banner_graph_statistics/[{start_date},{end_date},{bannerid}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$bannerid = $args['bannerid']; 

// print_r($enddate);
	
		$stc = "select * from ".$table_prefix."banners where bannerid=:bannerid";
		$std = $this->db->prepare($stc);
		$std->bindParam("bannerid",$bannerid);
		$std->execute();
		$campaigns = $std->fetchAll();
       
		if($campaigns)
		{	
			//$start_date=date('Y-m-d 00:00:00', strtotime($startdate));
            //$end_date=date('Y-m-d 23:59:59', strtotime($enddate));
            
            $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($startdate));
            $end_date=date('Y-m-d 23:59:59', strtotime($enddate));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			
			// print_r($end_date );
			$sql="select 
			cl.clientid as clientid,
			b.bannerid as bannerid,
			b.description as bannername,
			cl.clientname as clientname,
			CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
			-- TIMESTAMP(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.impressions) as requests,
			round(sum(h.total_revenue),0) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,0) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			h.ad_id = b.bannerid			
			AND cl.clientid = c.clientid
			AND c.campaignid = b.campaignid
			AND b.bannerid = :bannerid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by cl.clientid,b.bannerid,c.campaignid";
			
			
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":bannerid",$bannerid);		
			$sth->execute();
			$todos = $sth->fetchAll();
				
			
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid banner Id');
			return $this->response->withJson($response);

		}
  
}
 
});





//xandr---banner  Graph Statistics

$app->get('/get_dashboard_banner_graph_statistics/[{start_date},{end_date},{bannerid}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$bannerid = $args['bannerid']; 
		$startdate_chunks = explode(' ', $startdate);
		$enddate_chunks = explode(' ', $enddate);
	
		$stc = "select * from ".$table_prefix."banners where bannerid=:bannerid";
		$std = $this->db->prepare($stc);
		$std->bindParam("bannerid",$bannerid);
		$std->execute();
		$banners = $std->fetchAll();
     
		if($banners)
		{				
			$sql="select 
			sum(x.impressions) as impressions,
			sum(x.clicks) as clicks,
			round(sum(x.ctr),2) as ctr,			
			round(sum(x.ecpm),2) as ecpm,
			round(sum(x.total_revenue),2) as revenue,		

			round(sum(x.total_revenue),2) as spend,
			sum(x.total_convs) as conversions,
			
			-- c.campaignid as campaignid,
			-- c.campaignname as campaignname,

			b.bannerid as bannerid,
			b.description as bannername,

		
			sum(x.impressions) as requests
			from
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl ,
			".$table_prefix."xandr_reports as x 
			where

			x.creative_id=b.xandrcreativeid
			AND cl.clientid = c.clientid
			AND c.campaignid = b.campaignid
			AND b.bannerid = :bannerid
			AND x.date between '".$startdate_chunks[0]."'
			AND '".$enddate_chunks[0]."' group by b.bannerid";			

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":bannerid",$bannerid);
			$sth->execute();
			$todos = $sth->fetchAll();
			
		
		// exit;
			
			if($todos)
			{
				return $this->response->withJson($todos);
			}else{
				$response = array('response'=>'ok','msg'=>'No Stats Available');
					return $this->response->withJson($response);
			}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid banner Id');
			return $this->response->withJson($response);

		}
  
}
 
});





//xandr-get all Campaign  Graph Statistics

$app->get('/get_all_xandr_dashboard_campaign_graph_statistics/[{campaign_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');	
		$campaign_id = $args['campaign_id']; 
	
		$stc = "select * from ".$table_prefix."campaigns where campaignid=:campaignid";
		$std = $this->db->prepare($stc);
		$std->bindParam("campaignid",$campaign_id);
		$std->execute();
		$campaigns = $std->fetchAll();
        
	
		if($campaigns)
		{	


			$sql="select 
			sum(x.impressions) as impressions,
			sum(x.clicks) as clicks,
			round(sum(x.ctr),2) as ctr,			
			round(sum(x.ecpm),2) as ecpm,
			round(sum(x.total_revenue),2) as revenue,
			sum(x.impressions) as requests,
			round(sum(x.total_revenue),2) as spend,
			sum(x.total_convs) as conversions,
			--cl.clientid as clientid,
			--cl.clientname as clientname,
			c.campaignid as campaignid,
			c.campaignname  as campaignname,
			sum(x.impressions) as requests
			from
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl ,
			".$table_prefix."xandr_reports as x 
			where
			x.creative_id=b.xandrcreativeid
			AND c.campaignid = b.campaignid
			AND cl.clientid = c.clientid
			AND c.campaignid = :campaignid			
			group by c.campaignid";		

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":campaignid",$campaign_id);
			$sth->execute();
			$todos = $sth->fetchAll();
			
			// $sql="select 
			// cl.clientid as clientid,
			// cl.clientname as clientname,
			// c.campaignid as campaignid
			// CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
			// TIMESTAMP(h.date_time) as date_time,
			// sum(x.impressions) as impressions,
			// sum(x.clicks) as clicks,
			// sum(x.conversions) as conversions,
			// sum(x.impressions) as requests,
			// round(sum(x.total_revenue),0) as revenue,
			// round(sum(x.ctr),0) as ctr,
			// round(sum(x.ecpm),0) as ecpm
				
			// from
			// ".$table_prefix."data_summary_ad_hourly as h,
			// ".$table_prefix."banners as b,
			// ".$table_prefix."campaigns as c,
			// ".$table_prefix."clients as cl 
			// where
			// h.ad_id = b.bannerid
			// AND c.campaignid = b.campaignid
			// AND cl.clientid = c.clientid
			// AND c.campaignid = :campaignid
			// group by c.campaignid";


			// $sth = $this->db->prepare($sql);
			// $sth->bindParam(":campaignid",$campaign_id);
			// $sth->execute();
			// $todos = $sth->fetchAll();		
			
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid campaign Id');
			return $this->response->withJson($response);

		}
  
}
 
});




//revive- getall Campaign revive  Graph Statistics

$app->get('/get_all_dashboard_campaign_graph_statistics/[{campaign_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');	
		$campaign_id = $args['campaign_id']; 
	
		$stc = "select * from ".$table_prefix."campaigns where campaignid=:campaignid";
		$std = $this->db->prepare($stc);
		$std->bindParam("campaignid",$campaign_id);
		$std->execute();
		$campaigns = $std->fetchAll();
        
				// CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,

		if($campaigns)
		{	
			
			$sql="select 
			--cl.clientid as clientid,
			c.campaignid as campaignid,

			--cl.clientname as clientname,
			c.campaignname as campaignname,
			--TIMESTAMP(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.impressions) as requests,
			round(sum(h.total_revenue),0) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,0) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND cl.clientid = c.clientid
			AND c.campaignid = :campaignid
			group by c.campaignid";


			$sth = $this->db->prepare($sql);
			$sth->bindParam(":campaignid",$campaign_id);
			$sth->execute();
			$todos = $sth->fetchAll();		
			
			if($todos)
			{
				return $this->response->withJson($todos);
			}else{
				$response = array('response'=>'ok','msg'=>'No Stats Available');
					return $this->response->withJson($response);
			}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid campaign Id');
			return $this->response->withJson($response);

		}
  
}
 
});






//Campaign  Graph Statistics

$app->get('/get_dashboard_campaign_graph_statistics/[{start_date},{end_date},{campaign_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$campaign_id = $args['campaign_id']; 
		$startdate_chunks = explode(' ', $startdate);
		$enddate_chunks = explode(' ', $enddate);

	
		$stc = "select * from ".$table_prefix."campaigns where campaignid=:campaignid";
		$std = $this->db->prepare($stc);
		$std->bindParam("campaignid",$campaign_id);
		$std->execute();
		$campaigns = $std->fetchAll();
        
		
		if($campaigns)
		{	
			
			$sql="select 
			sum(x.impressions) as impressions,
			sum(x.clicks) as clicks,
			round(sum(x.ctr),2) as ctr,			
			round(sum(x.ecpm),2) as ecpm,
			round(sum(x.total_revenue),2) as revenue,
			round(sum(x.total_revenue),2) as spend,
			sum(x.total_convs) as conversions,
			
			c.campaignid as campaignid,
			c.campaignname as campaignname,
			sum(x.impressions) as requests
			from
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl ,
			".$table_prefix."xandr_reports as x 
			where
			x.creative_id=b.xandrcreativeid
			AND c.campaignid = b.campaignid
			AND cl.clientid = c.clientid
			AND c.campaignid = :campaignid
			AND x.date between '".$startdate_chunks[0]."'
			AND '".$enddate_chunks[0]."' group by c.campaignid";		

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":campaignid",$campaign_id);
			$sth->execute();
			$todos = $sth->fetchAll();

			// print_r($todos );
	
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});






//Revive-Campaign  Graph Statistics

$app->get('/get_revive_campaign_graph_statistics/[{start_date},{end_date},{campaign_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$campaign_id = $args['campaign_id']; 


	
		$stc = "select * from ".$table_prefix."campaigns where campaignid=:campaignid";
		$std = $this->db->prepare($stc);
		$std->bindParam("campaignid",$campaign_id);
		$std->execute();
		$campaigns = $std->fetchAll();
        
		
		if($campaigns)
		{	
			//$start_date=date('Y-m-d 00:00:00', strtotime($startdate));
            //$end_date=date('Y-m-d 23:59:59', strtotime($enddate));
            
            $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($startdate));
            $end_date=date('Y-m-d 23:59:59', strtotime($enddate));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);

			$sql="select 			
			-- cl.clientid as clientid,
			-- cl.clientname as clientname,
			c.campaignid as campaignid,
			c.campaignname as campaignname,
			-- TIMESTAMP(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.impressions) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm					
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,			
			".$table_prefix."clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND cl.clientid = c.clientid
			AND c.campaignid = :campaignid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by c.campaignid";
// print_r($sql);exit;
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":campaignid",$campaign_id);
			$sth->execute();
			$todos = $sth->fetchAll();

			if($todos)
			{
			return $this->response->withJson($todos);
			}else{
				$response = array('response'=>'ok','msg'=>'No Stats Available');
					return $this->response->withJson($response);
			}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid campaign Id');
			return $this->response->withJson($response);

		}
  
}
 
});




//Advertiser Graph Statistics

$app->get('/get_revivee_advertiser_campaign_graph_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
        $start_date ='';
		$end_date = '';
		if($client)
		{
		    $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();			
		
			$timezone = $TimeZoneRow[0]['timezone'];			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			$sql="select 
			
			
			cl.clientid as clientid,
			cl.clientname as clientname,
			CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
			TIMESTAMP(h.date_time) as date_time,

			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.impressions) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
	
	
		
			
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			
			".$table_prefix."clients as cl 
			where
			

			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by c.campaignid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);
			$sth->execute();
			$todos = $sth->fetchAll();
			// print_r(	$todos );
			
			
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));






//Advertiser Graph Statistics

$app->get('/get_advertiser_campaign_graph_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];		
		$enddate=$args['end_date']; 

		$startdate_chunks = explode(' ', $startdate);
		$enddate_chunks = explode(' ', $enddate);
		$advertiser_id = $args['advertiser_id']; 

		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
      
		if($client)
		{
		    
		
			// $start_date=date('Y-m-d 00:00:00', strtotime($startdate));
            // $end_date=date('Y-m-d 23:59:59', strtotime($enddate));
            
            $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($startdate));
            $end_date=date('Y-m-d 23:59:59', strtotime($enddate));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);		

			$revive_sql="select 			
			cl.clientid as clientid,
			cl.clientname as clientname,
			c.campaignid as campaignid,
			c.campaignname as campaignname,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.impressions) as requests,		
			round(sum(h.total_revenue),2) as revenue,
			round(sum(h.total_revenue),2) as spend,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm				
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,			
			".$table_prefix."clients as cl 		 
			where		

			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by DATE(h.date_time),cl.clientid,c.campaignid";
			
			// echo "<pre>";print_r($revive_sql);exit;
						
			$sth_revive_sql = $this->db->prepare($revive_sql);
			$sth_revive_sql->bindParam(":advertiserid",$advertiser_id);
			$sth_revive_sql->execute();
			$todos__revive_sql = $sth_revive_sql->fetchAll();
			
			$sql="select 			
			sum(x.impressions) as xandr_impressions,
			sum(x.clicks) as xandr_clicks,
			round(sum(x.ctr),2) as xandr_ctr,			
			round(sum(x.ecpm),2) as xandr_ecpm,			
			round(sum(x.total_revenue),2) as revenue,			
			round(sum(x.total_revenue),2) as spend,
			sum(x.total_convs) as conversions,
			sum(x.impressions) as requests,
			cl.clientid as clientid,
			cl.clientname as clientname,
			c.campaignid as campaignid,
			date(x.date) as date_time,
			c.campaignname as campaignname
					
			from
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,			
			".$table_prefix."clients as cl ,
			".$table_prefix."xandr_reports as x 
			where
			x.creative_id=b.xandrcreativeid			
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid			
			AND x.date between '".$start_date."'
			AND '".$end_date."'			
			group by c.campaignid,cl.clientid,date(x.date)";
			
			// echo "<pre>";print_r($sql);exit;

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);
			$sth->execute();
			$todos = $sth->fetchAll();
						
		if($todos || $todos__revive_sql)
		{
			$response = array('todos__revive_sql'=>$todos__revive_sql,'todos'=>$todos);
		return $this->response->withJson($response);
	}
	else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));








//Advertiser All Graph Statistics

$app->get('/get_all_revive_advertiser_campaign_graph_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
			
		$sql="select 

			
		cl.clientid as clientid,
		cl.clientname as clientname,
		CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
		TIMESTAMP(h.date_time) as date_time,			
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,	
		round(sum(h.total_revenue),2) as revenue,	
		round((sum(h.clicks)/sum(h.impressions)) * 100,0) as ctr,
		round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	,
		round(sum(h.total_revenue),2) as spend,
		sum(h.conversions) as conversions,	
		sum(h.impressions) as requests


	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl 

		where	
	
		h.ad_id = b.bannerid
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		group by c.campaignid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		$todos = $sth->fetchAll();
		
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});





//Advertiser All Graph Statistics

$app->get('/get_all_advertiser_campaign_graph_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{	
			$revive_sql="select 			
			-- cl.clientid as clientid,
			-- cl.clientname as clientname,
			c.campaignname as campaignname,
			-- TIMESTAMP(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.impressions) as requests,
			round(sum(h.total_revenue),2) as spend,		
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm				
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,			
			".$table_prefix."clients as cl 	 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid 
			group by c.campaignid";
			
			$sth_revive_sql = $this->db->prepare($revive_sql);
			$sth_revive_sql->bindParam(":advertiserid",$advertiser_id);
			$sth_revive_sql->execute();
			$todos__revive_sql = $sth_revive_sql->fetchAll();		


			$sql="select 			
			sum(x.impressions) as xandr_impressions,
			sum(x.clicks) as xandr_clicks,
			round(sum(x.ctr),2) as xandr_ctr,			
			round(sum(x.ecpm),2) as xandr_ecpm,			
			round(sum(x.total_revenue),2) as revenue,				
			round(sum(x.total_revenue),2) as spend,
			sum(x.impressions) as requests,
			sum(x.total_convs) as conversions,
			-- cl.clientid as clientid,
			-- cl.clientname as clientname,
			CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname
			from
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,			
			".$table_prefix."clients as cl ,
			".$table_prefix."xandr_reports as x 
			where
			x.creative_id=b.xandrcreativeid			
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid				
			group by c.campaignid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);
			$sth->execute();
			$todos = $sth->fetchAll();
	
			if($todos || $todos__revive_sql)
			{
				$response = array('todos__revive_sql'=>$todos__revive_sql,'todos'=>$todos);
				return $this->response->withJson($response);
			}
			else{
				$response = array('response'=>'ok','msg'=>'No Stats Available');
					return $this->response->withJson($response);
			}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});





//Advertiser All Graph Statistics

$app->get('/get_all_campaign_graph_statistics/[{campaign_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$campaign_id = $args['campaign_id']; 
		// print_r($campaign_id);
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$campaign_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
			
		$sql="select 
		cl.clientid as clientid,
		cl.clientname as clientname,
		CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
		TIMESTAMP(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.impressions) as requests,
		round(sum(h.total_revenue),0) as revenue,
		
		round((sum(h.clicks)/sum(h.impressions)),0) * 100 as ctr,
		round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl 
		where
		h.ad_id = b.bannerid
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		group by c.campaignid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		$todos = $sth->fetchAll();
	
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});







//All Top Campaign 

$app->get('/get_all_top_campaign_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
			
	// 	$sql="select 

				

	// sum(h.impressions) as impressions,
	// 	sum(h.clicks) as clicks,
	// 	sum(h.conversions) as conversions,
	// 	sum(h.impressions) as requests,
	// 	round(sum(h.total_revenue),2) as revenue,
	// 	round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
	// 	round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	,
	// 	round(sum(h.total_revenue),2) as spend,	

	// 	c.campaignname as campaignname,
	// 	b.description as bannername,
    //     DATE(h.date_time) as date_time
		
	// 	from
	// 	".$table_prefix."data_summary_ad_hourly as h,
	// 	".$table_prefix."banners as b,
	// 	".$table_prefix."campaigns as c,
	// 	".$table_prefix."clients as cl 
		
	// 	where		
	// 	h.ad_id = b.bannerid
	// 	AND c.campaignid = b.campaignid
	// 	AND c.clientid = cl.clientid
	// 	AND cl.clientid = :advertiserid
	// 	group by c.campaignid ORDER BY ctr DESC limit 5";
	// 	$sth = $this->db->prepare($sql);
	// 	$sth->bindParam(":advertiserid",$advertiser_id);


		$sql="select 			

		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.impressions) as requests,
		round(sum(h.total_revenue),2) as revenue,
		round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
		round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	,
		round(sum(h.total_revenue),2) as spend,	
	
		c.campaignname as campaignname
		
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl 
		
		where		
		h.ad_id = b.bannerid
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		group by c.campaignname ORDER BY ctr DESC limit 5";
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		$todos = $sth->fetchAll();

		// echo "query";
		// print_r($todos);exit;

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});








// Get Advertiser campaign Statistics

$app->get('/get_xandr_widgets_advertiser_campaign_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them group by campaignid
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
		$startdate_chunks = explode(' ', $startdate);
		$enddate_chunks = explode(' ', $enddate);
		
		$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();			
			
			$timezone = $TimeZoneRow[0]['timezone'];			
			//$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            //$end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);

		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
	
		if($client)
		{
			$sql="select 
				sum(x.impressions) as all_imps,
				sum(x.impressions) as impressions,
				sum(x.clicks) as all_clks,
				sum(x.clicks) as clicks,
				round(sum(x.ctr),2) as ctr,	
				round(sum(x.total_revenue),2) as revenue,	
				sum(x.ecpm) as ecpm,		
				round(sum(x.total_revenue),2) as spend,
				sum(x.impressions) as requests,
				sum(x.total_convs) as all_convs,
				sum(x.total_convs) as conversions,
				cl.clientid as clientid,
				-- cl.clientname as clientname,
				b.campaignid as campaignid,
				-- c.campaignname as campaignname,			
				b.bannerid as bannerid,
				-- b.description as bannername,		
				x.date as date_time		
				from		
				rv_banners as b,
				rv_campaigns as c,
				rv_clients as cl ,
				rv_xandr_reports as x 
				where
					x.creative_id=b.xandrcreativeid			
					AND b.campaignid= c.campaignid 
					AND c.clientid = cl.clientid
					AND cl.clientid = :advertiserid
					AND x.date between '".$start_date."'
					AND '".$end_date."' group by cl.clientid,b.campaignid,b.bannerid,x.date";
					
					// print_r($sql);exit;
			
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);
			$sth->execute();		
			$todos = $sth->fetchAll();	

			// if there is no website avaliable it should not return null to front end js
			$no_website=array();
			for($i=0;$i<count($todos);$i++){
				$bannerid = $todos[$i]['bannerid'];
				if($todos[$i]['bannerid']==null){
					$no_website[]=$bannerid ;
				}
			}
	
			if(count($todos)==count($no_website)){
				$response = array('response'=>'ok','msg'=>'No Stats Available');
				return $this->response->withJson($response);
			}
			
			if($todos)
			{
				return $this->response->withJson($todos);
			}
			else{
				$response = array('response'=>'ok','msg'=>'No Stats Available');
				return $this->response->withJson($response);
			}
		}
		else{
				
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
	}
 
});






//All xandr Top Campaign 

$app->get('/get_all_xandr_top_campaign_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
			
		$sql="select 

			sum(x.impressions) as impressions,
			sum(x.clicks) as clicks,
			sum(x.ctr) as ctr,	
			round(sum(x.total_revenue),2) as revenue,	
			sum(x.ecpm) as ecpm,		
			round(sum(x.total_revenue),2) as spend,
			sum(x.total_convs) as conversions,
			c.campaignname as campaignname,
			b.bannerid as bannerid,
			b.description as bannername,		
			x.date as date_time,		
			sum(x.impressions) as requests
		
		from
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl ,
		".$table_prefix."xandr_reports as x 
		where
		x.creative_id = b.xandrcreativeid
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		group by c.campaignid,b.bannerid,x.date ORDER BY ctr DESC limit 5";
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);
		$sth->execute();
		$todos = $sth->fetchAll();
	
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});




// top campaign statistics

$app->get('/get_top_campaign_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		$start_date ='';
		$end_date = '';
		if($client)
		{
		    $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();			
			
			$timezone = $TimeZoneRow[0]['timezone'];			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			

			$sql="select 
	
		
			
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.impressions) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	,
			round(sum(h.total_revenue),2) as spend,		
			c.campaignname as campaignname
	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			
			where		
			
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by c.campaignid ORDER BY impressions DESC limit 5";

			// print_r($sql);exit;


			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		$todos = $sth->fetchAll();

		// echo "query";
		// print_r($todos);exit;

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));








//xandr top campaigns statistics

$app->get('/get_xandr_top_campaign_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
		//$startdate_chunks = explode(' ', $startdate);
		//$enddate_chunks = explode(' ', $enddate);
		
		$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();			
			
			$timezone = $TimeZoneRow[0]['timezone'];			
			//$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            //$end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);

		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		
		if($client)
		{		   			
			$sql="select 
			sum(x.impressions) as impressions,
			sum(x.clicks) as clicks,
			sum(x.ctr) as ctr,	
			round(sum(x.total_revenue),2) as revenue,	
			sum(x.ecpm) as ecpm,		
			round(sum(x.total_revenue),2) as spend,
			sum(x.total_convs) as conversions,			
			c.campaignname as campaignname,
			sum(x.impressions) as requests
			from
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl ,
			".$table_prefix."xandr_reports as x 
			where
			x.creative_id = b.xandrcreativeid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND x.date between '".$start_date."'
			AND '".$end_date."'			
			group by c.campaignid 
			ORDER BY impressions DESC limit 5";
			
			// echo "<pre>";print_r($sql);exit;
		
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);
			$sth->execute();
			$todos = $sth->fetchAll();
	
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
  
}
 
})->add($container->get('datevalidation'));






//All Top websites xandr

$app->get('/get_all_top_website_statistics/[{clientid}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];

		$client_id=$args['clientid']; 

			// $sql="select 							  
			// DATE(x.date) as date_time,
			// sum(x.impressions) as impressions,
			// sum(x.clicks) as clicks,
			// sum(x.ctr) as ctr,
			// sum(x.impressions) as requests,				
			// x.domain_name as websitesname			
			// from
			// ".$table_prefix."xandr_site_reports as x		
			// group by x.date,x.domain_name						
			// ORDER BY x.ctr DESC limit 5";

			$sql111="select 								  
			sum(x.impressions) as impressions,
			sum(x.clicks) as clicks,
			sum(x.ctr) as ctr,			
			round(sum(x.total_revenue),2) as spend,	
			x.domain_name as websitesname,
			sum(x.impressions) as requests
			
			from
			".$table_prefix."xandr_site_reports as x,	
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl
			where		
			x.advertiser_id = b.advertiserid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = $client_id			
			group by x.domain_name
			ORDER BY ctr DESC limit 5";
			
			
			$sql="select 								  
			sum(x.impressions) as impressions,
			sum(x.clicks) as clicks,
			sum(x.ctr) as ctr,			
			round(sum(x.total_revenue),2) as spend,	
			x.domain_name as websitesname,
			sum(x.impressions) as requests
			from
			".$table_prefix."clients as cl,
			".$table_prefix."xandr_site_reports as x
			where		
			cl.advertiser_id = x.advertiser_id
			AND cl.clientid = $client_id group by x.domain_name
			ORDER BY impressions DESC limit 5";
			
			
			
			
			

		$sth = $this->db->prepare($sql);
		$sth->execute();
		$todos = $sth->fetchAll();	


		// if there is no website avaliable it should not return null to front end js
		$no_website=array();
		for($i=0;$i<count($todos);$i++){
			$websitesname = $todos[$i]['websitesname'];
			if($todos[$i]['websitesname']==null){
				$no_website[]=$websitesname ;
			}
		}

		if(count($todos)==count($no_website)){
			$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
		}

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
  
}
 
});




// $app->get('/get_top_website_statistics/[{start_date},{end_date}]', function($request, $response, $args)
// {
	
// 	if ($request->getAttribute('has_errors')) {
//         //There are errors, read them
//         $errors = $request->getAttribute('errors');      
//         return $this->response->withJson($errors);
        
//         return $response;
//     } else {
    
// 		$input = $request->getParsedBody();
// 		$table_prefix= $this->get('settings')['path']['table_prefix'];

// 		$startdate=$args['start_date'];
// 		$enddate=$args['end_date']; 	
// 		$start_date ='';
// 		$end_date = '';		

// 			$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
// 			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
// 			$TimeZonestd->execute();
// 			$TimeZoneRow = $TimeZonestd->fetchAll();		
		
			
// 			$timezone = $TimeZoneRow[0]['timezone'];
			
// 			$start_date=date('Y-m-d', strtotime($start_date));
//             $end_date=date('Y-m-d', strtotime($end_date));
			
// 			date_default_timezone_set($timezone);
// 			$Starts = strtotime($startdate);
// 			$Ends = strtotime($enddate);
		
// 			date_default_timezone_set("UTC");
// 			$start_date = date("Y-m-d", $Starts);
// 			$end_date  = date("Y-m-d", $Ends);			
		
// 			$sql="select 								  
// 			DATE(x.date) as date_time,
// 			sum(x.impressions) as impressions,
// 			sum(x.clicks) as clicks,
// 			sum(x.ctr) as ctr,			
// 			round(sum(x.total_revenue),2) as spend,	
// 			x.domain_name as websitesname			
// 			from
// 			".$table_prefix."xandr_site_reports as x		
// 			where		
// 			x.date between '".$start_date."'
// 			AND '".$end_date."' ORDER BY x.ctr DESC limit 5";
// 			$sth = $this->db->prepare($sql);
// 			$sth->execute();	
// 			$todos = $sth->fetchAll();	
		

// // if there is no website avaliable it should not return null to front end js
//            $no_website=array();
// 			for($i=0;$i<count($todos);$i++){
// 				$websitesname = $todos[$i]['websitesname'];
// 				if($todos[$i]['websitesname']==null){
// 					$no_website[]=$websitesname ;
// 				}
// 			}

// 			if(count($todos)==count($no_website)){
// 				$response = array('response'=>'ok','msg'=>'No Stats Available');
// 				return $this->response->withJson($response);
// 			}

			
			
		

// 		if($todos)
// 		{
// 		return $this->response->withJson($todos);
// 	}else{
// 		$response = array('response'=>'ok','msg'=>'No Stats Available');
// 			return $this->response->withJson($response);
// 	}
	
  
// }
 
// });




$app->get('/get_top_website_statistics/[{start_date},{end_date},{clientid}]', function($request, $response, $args)
{
	// print_r($args);exit;
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];

		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$client_id=$args['clientid']; 	
		//$startdate_chunks = explode(' ', $startdate);
		//$enddate_chunks = explode(' ', $enddate);
		
		$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();			
			
			$timezone = $TimeZoneRow[0]['timezone'];			
			//$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            //$end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
		
			$sqlCOPY="select 								  
			sum(x.impressions) as impressions,
			sum(x.clicks) as clicks,
			sum(x.ctr) as ctr,			
			round(sum(x.total_revenue),2) as spend,	
			x.domain_name as websitesname,
			sum(x.impressions) as requests
			from
			".$table_prefix."xandr_site_reports as x,	
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl
			where		
			x.advertiser_id = b.advertiserid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = $client_id
			AND x.date between '".$start_date."'
			AND '".$end_date."' group by x.domain_name
			ORDER BY impressions DESC limit 5";
			
			
			$sql="select 								  
			sum(x.impressions) as impressions,
			sum(x.clicks) as clicks,
			sum(x.ctr) as ctr,			
			round(sum(x.total_revenue),2) as spend,	
			x.domain_name as websitesname,
			sum(x.impressions) as requests
			from
			".$table_prefix."clients as cl,
			".$table_prefix."xandr_site_reports as x
			where		
			cl.advertiser_id = x.advertiser_id
			AND cl.clientid = $client_id
			AND x.date between '".$start_date."'
			AND '".$end_date."' group by x.domain_name
			ORDER BY impressions DESC limit 5";
			
			// print_r($sql);exit;
			$sth = $this->db->prepare($sql);
			$sth->execute();	
			$todos = $sth->fetchAll();	 
		

// if there is no website avaliable it should not return null to front end js
           $no_website=array();
			for($i=0;$i<count($todos);$i++){
				$websitesname = $todos[$i]['websitesname'];
				if($todos[$i]['websitesname']==null){
					$no_website[]=$websitesname ;
				}
			}

			if(count($todos)==count($no_website)){
				$response = array('response'=>'ok','msg'=>'No Stats Available');
				return $this->response->withJson($response);
			}

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
	
  
}
 
});



//Campaign Report Statistics
// $app->get('/get_advertiser_campaign_xender_report_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
// {
	$app->get('/get_advertiser_campaign_report_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them group by campaignid h.ad_id as ad_id,b.bannerid as bannerid,b.description as bannername,
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date ='';
		$end_date = '';
		if($client)
		{
			$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			


			$sql="select 
		cl.clientid as clientid,
		cl.clientname as clientname,
		c.campaignname as campaignname,
		c.campaignid as campaignid,


		-- DATE(h.date_time) as date_time,	
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.impressions) as requests,
		round(sum(h.total_revenue),0) as revenue
		
		-- round((sum(h.clicks)/sum(h.impressions)),0) * 100 as ctr,
		-- round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl 
		where
		h.ad_id = b.bannerid
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by c.campaignid,cl.clientid";
			

			$sth = $this->db->prepare($sql);
			
			$sth->bindParam(":advertiserid",$advertiser_id);
			
			$sth->execute();

		    $todos = $sth->fetchAll();

		if($todos)
		{
			foreach($todos as $todo) {
				$ctr = round(($todo['clicks']/$todo['impressions']) * 100,2);
				
				$ecpm = round(($todo['revenue']/$todo['impressions']) * 1000,2);
				
				$todo['ctr'] = $ctr;
				$todo['ecpm'] = $ecpm;
				
				$data[] = $todo;
					
			}
			
		return $this->response->withJson($data);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));
// $app->get('/get_advertiser_campaign_report_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
// {
	$app->get('/get_advertiser_campaign_xender_report_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them group by campaignid h.ad_id as ad_id,b.bannerid as bannerid,b.description as bannername,
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
		$startdate_chunks = explode(' ', $startdate);
		$enddate_chunks = explode(' ', $enddate);
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date ='';
		$end_date = '';
		if($client)
		{
			$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			$sql="select 			
			sum(x.impressions) as xandr_impressions,
			sum(x.clicks) as xandr_clicks,
			round(sum(x.ctr),2) as xandr_ctr,			
			round(sum(x.ecpm),2) as xandr_ecpm,			
			round(sum(x.total_revenue),2) as revenue,			
			round(sum(x.total_revenue),2) as spend,
			sum(x.total_convs) as conversions,
			sum(x.impressions) as requests,
			cl.clientid as clientid,
			c.campaignid as campaignid,

			
			cl.clientname as clientname,
			-- x.date as date_time,
			CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname
					
			from
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,			
			".$table_prefix."clients as cl ,
			".$table_prefix."xandr_reports as x 
			where
			x.creative_id=b.xandrcreativeid			
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid			
			AND x.date between '".$startdate_chunks[0]."'
			AND '".$enddate_chunks[0]."'			
			group by c.campaignid,cl.clientid";
			

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);

			$sth->execute();

		    $todos = $sth->fetchAll();

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));

// All Advertiser Campaign Statistics
$app->get('/get_all_advertiser_campaign__xender_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		if($client)
		{
			$sql="select 			
			sum(x.impressions) as xandr_impressions,
			sum(x.clicks) as xandr_clicks,
			round(sum(x.ctr),2) as xandr_ctr,			
			round(sum(x.ecpm),2) as xandr_ecpm,			
			round(sum(x.total_revenue),2) as revenue,			
			round(sum(x.total_revenue),2) as spend,
			sum(x.total_convs) as conversions,
			sum(x.impressions) as requests,
			--cl.clientid as clientid,
			--cl.clientname as clientname,
			c.campaignid as campaignid,
			--b.bannerid as bannerid,
			--x.date as date_time,
			c.campaignname  as campaignname
					
			from
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,			
			".$table_prefix."clients as cl ,
			".$table_prefix."xandr_reports as x 
			where
			x.creative_id=b.xandrcreativeid			
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid							
			group by c.campaignid";

			// $sql="select 

			// sum(x.impressions) as xandr_impressions,
			// sum(x.clicks) as xandr_clicks,
			// round(sum(x.ctr),2) as xandr_ctr,			
			// round(sum(x.ecpm),2) as xandr_ecpm,		
			// round(sum(x.total_revenue),2) as revenue,	
			
			// round(sum(x.total_revenue),2) as spend,
			// sum(x.total_convs) as conversions,
			// cl.clientid as clientid,
			// cl.clientname as clientname,
			// b.campaignid as campaignid,
			// c.campaignname as campaignname,
			// DATE(h.date_time) as date_time,		
			// sum(x.impressions) as requests		
			
			// from
			// ".$table_prefix."data_summary_ad_hourly as h,
			// ".$table_prefix."banners as b,
			// ".$table_prefix."campaigns as c,
			// ".$table_prefix."clients as cl ,
			// ".$table_prefix."xandr_reports as x 
			// where
			// x.creative_id = b.xandrcreativeid
			// AND
			// h.ad_id = b.bannerid
			// AND c.campaignid = b.campaignid
			// AND c.clientid = cl.clientid
			// AND cl.clientid = :advertiserid
			//  group by campaignid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		
		$todos = $sth->fetchAll();

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});

$app->get('/get_all_advertiser_campaign_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		if($client)
		{
			
			$sql="select 
			--cl.clientid as clientid,
			--cl.clientname as clientname,
			c.campaignid as campaignid,
			c.campaignname as campaignname,
			--h.ad_id as ad_id,
			--b.bannerid as bannerid,
			--b.description as bannername,
			--DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.impressions) as requests,
			round(sum(h.total_revenue),2) as revenue,
			
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			group by c.campaignid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		
		$todos = $sth->fetchAll();

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});

//Advertiser Banner Statistics

$app->get('/get_advertiser_banner_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
		
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();	
    
		if($client)
		{
			$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			// $start_date=date('Y-m-d 00:00:00', strtotime($startdate));
            // $end_date=date('Y-m-d 23:59:59', strtotime($enddate));			
			
			$sql="select 
			h.ad_id as ad_id,
			-- DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			b.description as bannername
			-- cl.clientid as clientid,		
			-- round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			-- round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl
			where
			h.ad_id = b.bannerid
			AND c.clientid = :advertiserid
			AND cl.clientid = c.clientid
			AND b.campaignid = c.campaignid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' GROUP BY h.ad_id,b.bannerid";
			
			// echo "<pre>";print_r($sql);exit;

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);
		$sth->execute();
		$todos = $sth->fetchAll();
		
		if($todos)
		{
			foreach($todos as $todo) {
				$ctr = round(($todo['clicks']/$todo['impressions']) * 100,2);
				
				$ecpm = round(($todo['revenue']/$todo['impressions']) * 1000,2);
				
				$todo['ctr'] = $ctr;
				$todo['ecpm'] = $ecpm;
				
				$data[] = $todo;
					
			}
			return $this->response->withJson($data);
			
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));

//All Advertiser Banner Statistics
$app->get('/get_all_advertiser_banner_xender_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix']; 
		$advertiser_id = $args['advertiser_id']; 
		
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
		$sql="select 
		sum(x.impressions) as impressions,
		sum(x.clicks) as clicks,
		sum(x.total_convs) as conversions,
		round(sum(x.total_revenue),2) as revenue,
		b.bannerid as bannerid,
		--b.campaignid as campaignid,
		b.description as bannername,
		--cl.clientid as clientid,		
		round((sum(x.clicks)/sum(x.impressions)) * 100,2) as ctr,
		round((Sum(x.total_revenue)/sum(x.impressions))*1000,2) as ecpm	
		from	
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl,
		".$table_prefix."xandr_reports as x 
		where
		x.creative_id = b.xandrcreativeid		
		AND c.clientid = :advertiserid
		AND cl.clientid = c.clientid
		AND b.campaignid = c.campaignid
		GROUP BY b.bannerid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});
$app->get('/get_all_advertiser_banner_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix']; 
		$advertiser_id = $args['advertiser_id']; 
		
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
		$sql="select 
		h.ad_id as ad_id,
		--DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		round(sum(h.total_revenue),2) as revenue,
		b.bannerid as bannerid,
		--c.campaignid as campaignid,
		b.description as bannername,
		--cl.clientid as clientid,		
		round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
		round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl
		where
		h.ad_id = b.bannerid
		AND c.clientid = :advertiserid
		AND cl.clientid = c.clientid
		AND b.campaignid = c.campaignid
		GROUP BY b.bannerid,h.ad_id";
		
		// print_r($sql);exit;

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});

//Advertiser Campaignwise Banner Statistics
$app->get('/get_advertiser_campaignwise_banner_xender_statistics/[{start_date},{end_date},{advertiser_id},{campaign_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
		$campaign_id = $args['campaign_id']; 
		
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date ='';
		$end_date = '';

		if($client)
		{
	        $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			$sql="select 
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(x.impressions) as impressions,
			sum(x.clicks) as clicks,
			sum(x.total_convs) as conversions,
			round(sum(x.total_revenue),2) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			b.description as bannername,
			cl.clientid as clientid,		
			round((sum(x.clicks)/sum(x.impressions)) * 100,2) as ctr,
			round((Sum(x.total_revenue)/sum(x.impressions))*1000,2) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."xandr_reports as x 
		    where
		    x.creative_id = b.xandrcreativeid
	        AND
			h.ad_id = b.bannerid
			AND c.clientid = :advertiserid
			AND c.campaignid = :campaignid
			AND cl.clientid = c.clientid
			AND b.campaignid = c.campaignid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' GROUP BY ad_id";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);
			$sth->bindParam(":campaignid",$campaign_id);

			$sth->execute();
			$todos = $sth->fetchAll();
			if($todos)
			{
			return $this->response->withJson($todos);
	       }else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	    }
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));


$app->get('/get_advertiser_campaignwise_banner_statistics/[{start_date},{end_date},{advertiser_id},{campaign_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
		$campaign_id = $args['campaign_id']; 
		
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date ='';
		$end_date = '';

		if($client)
		{
	        $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			$sql="select 
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			b.description as bannername,
			cl.clientid as clientid,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl
			where
			h.ad_id = b.bannerid
			AND c.clientid = :advertiserid
			AND c.campaignid = :campaignid
			AND cl.clientid = c.clientid
			AND b.campaignid = c.campaignid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' GROUP BY ad_id";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);
			$sth->bindParam(":campaignid",$campaign_id);

			$sth->execute();
			$todos = $sth->fetchAll();
			if($todos)
			{
			return $this->response->withJson($todos);
	       }else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	    }
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));



/*--------------- End of Advertiser Statistics ------------*/







$app->get('/get_advertiser_banner_xender_report_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
		$startdate_chunks = explode(' ', $startdate);
		$enddate_chunks = explode(' ', $enddate);

		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();	
    
		if($client)
		{			
			$sql="select 			
			sum(x.impressions) as impressions,
			sum(x.clicks) as clicks,
			round(sum(x.ctr),2) as ctr,			
			round(sum(x.ecpm),2) as ecpm,			
			round(sum(x.total_revenue),2) as revenue,			
			round(sum(x.total_revenue),2) as spend,
			sum(x.total_convs) as conversions,
			sum(x.impressions) as requests,
			b.description as bannername,
			b.bannerid as bannerid,
			-- cl.clientid as clientid,
			-- cl.clientname as clientname,
			-- x.date as date_time,
			c.campaignname as campaignname
			from
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,			
			".$table_prefix."clients as cl ,
			".$table_prefix."xandr_reports as x 
			where
			x.creative_id=b.xandrcreativeid			
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid			
			AND x.date between '".$startdate_chunks[0]."'
			AND '".$enddate_chunks[0]."'			
			group by c.campaignid,b.description,b.bannerid";
			

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));


/*--------------- Start of Publisher Statistics ------------*/




/*--------------- End of Publisher Statistics ------------*/










