<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>Adserver - Banner </title>
    <meta name="description" content="" />
    <?php include('head.php'); ?>

</head>
<style>
    .swal-button--danger {
        background-color: #2523b3;
    }

    .swal-button--cancel {
        color: white;
        background-color: #ff3e1d;
    }

    .swal-button--cancel:not([disabled]):hover {
        background-color: #ff0800;
    }

    .swal-button--danger:not([disabled]):hover {
        background-color: #2523b3;
    }

    .text-hide {
        display: flex;
        width: 130px !important;
        overflow: hidden;
        white-space: nowrap;
        text-overflow: ellipsis;
    }

    .text-hide:hover {
        overflow: hidden;
    }

    .card-body {
        padding: 0 !important;
    }

    .dataTables_scrollBody {
        height: auto !important;
    }

    .table-striped {
        width: 1200px !important;
    }

    .text_convert {
        text-transform: capitalize;
    }

    .btn:disabled {
        pointer-events: none;
        opacity: 0.95;
        background-color: #9E9E9E;
        border-color: #9E9E9E;
    }

    .loader {
        display: none;
        position: fixed;
        width: 100%;
        height: 100%;
        top: 0;
        left: 0;
        z-index: 999;
        background: rgba(255, 255, 255, 0.8) url("../assets/img/loader.gif") center no-repeat;
    }

    .align_size {
        width: 800px;
    }

    ;
</style>

<body onload="zonelist(); ">
    <div class="loader"></div>
    <input type='hidden' name="campaignid" id="campaignid" value="<?php echo $_GET['campaignid']; ?>" />
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>
            <!-- / Menu -->
            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->
                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container">
                        <div class="nav-align-top my-4 mx-3">
                            <ul class="nav nav-tabs" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link" href="banner_edit.php?bannerid=<?php echo $_GET['bannerid']; ?>&campaignid=<?php echo $_GET['campaignid']; ?>"><?php echo $GLOBALS['strBanner_Edit_Head']; ?></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="delivery_options.php?bannerid=<?php echo $_GET['bannerid']; ?>&campaignid=<?php echo $_GET['campaignid']; ?>"><?php echo $GLOBALS['delivery_options']; ?></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link active" href="#"><?php echo $GLOBALS['link_zones']; ?></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="banner_advanced.php?bannerid=<?php echo $_GET['bannerid']; ?>&campaignid=<?php echo $_GET['campaignid']; ?>"><?php echo $GLOBALS['advanced']; ?></a>
                                </li>
                                 <li class="nav-item">
									<a class="nav-link" href="banner-secondtag.php?bannerid=<?php echo $_GET['bannerid']; ?>&campaignid=<?php echo $_GET['campaignid']; ?>"><?php echo $GLOBALS['banner_secondtag']; ?></a>
                                </li>
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane fade show active" id="delivery_options_banner" role="tabpanel">
                                    <div class="row">
                                        <div class="col-6">
                                            <p class="h3 mt-4"><?php echo $GLOBALS['link_banner_by_zone']; ?></p>
                                        </div>
                                        <hr class="solid">
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="mt-2 mb-4 container">
                                                <div class="table-responsive text-nowrap">
                                                    <table id="Zonelist" class="table table-responsive ">
                                                        <thead>
                                                            <tr class="text-nowrap">
                                                                <th class="thauth-login-basic.html-color text-start text-center"><?php echo $GLOBALS['strName']; ?></th>
                                                                <th class="thauth-login-basic.html-color th-color text-center"><?php echo $GLOBALS['link_banner_id']; ?></th>
                                                                <th class="thauth-login-basic.html-color th-color text-center"><?php echo $GLOBALS['link_banner_action']; ?></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                        <!-- / Content -->

                        <!-- Footer -->

                        <?php include('footer.php'); ?>

                        <!-- / Footer -->

                        <div class="content-backdrop fade"></div>
                    
                    <!-- Content wrapper -->
                </div>
                <!-- / Layout page -->
            </div>

            <!-- Overlay -->
            <div class="layout-overlay layout-menu-toggle"></div>
        </div>
    <script>
        var live_URL = '<?php echo $apiinvenpath; ?>';
        var token = 'Bearer ' + document.getElementById('token').value;
        var test1 = [],
            test2 = [];

        var bannerid = '<?php echo $_REQUEST['bannerid']; ?>';

        function zonelist() {


            $.ajax({
                url: live_URL + '/get_bannersizewise_zone/' + bannerid,
                type: 'GET',
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                dataType: 'json',
                encode: true,
                success: function(data) {


                    if (data.msg == 'Width and height doesnot match for banner and zone') {
                        $('#Zonelist').DataTable({
                            ordering: false,
					        destroy: true,
					        responsive: true,
					        bPaginate: false,                    
                            bAutoWidth : false,
					        bInfo: false,
					        data:[],
					        searching: false,
					        oLanguage: {
                                sEmptyTable:`<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`

					        	// sEmptyTable:"No Data Found"
					        }
				        });
                    }else{

                        console.log(data.data[0].zones);
                        for (var i = 0; i < data.data.length; i++) {
                            var row = $('<tr><td style="color:blue"><i class="fa fa-folder" aria-hidden="true"></i>&nbsp;' + data.data[i].publishername + '</td><td class="text-center">' + data.data[i].publisherid + '</td><td></td></tr>');
                            $('#Zonelist').append(row);
                            for (var j = 0; j < data.data[i].zones.length; j++) {
                                var zon = data.data[i].zones[j];
                                // let test2 = data.data[0].zones[j].zoneid;
                                // console.log("zone data", test2);
                                test1.push(zon.zonecount);
                                test2.push(zon.zoneid);
                                var row = $('<tr><td style="padding-left:50px;color:#1F51FF"><i class="fa fa-image" aria-hidden="true"></i>&nbsp;' + zon.zonename + '</td><td class="text-center">' + zon.zoneid + '</td><td class="text-center"><button type="button" id="link' + zon.zoneid + '" class="btn btn-danger" onclick="link_banner(' + zon.zoneid + ')"><?php echo $GLOBALS['link']; ?></button>&nbsp<button type="button" id="unlink' + zon.zoneid + '" class="btn btn-danger" onclick="unlink_banner(' + zon.zoneid + ')"> <?php echo $GLOBALS['unlink']; ?></button></td></tr>');
                                $('#Zonelist').append(row);
                            }
                        }
                        // console.log("test1", test1);
                        get_zone(test1, test2);
                    }

                },
                error: function() {},
            });
        }

        function get_zone(zon, zone_id) {
            console.log("zone", zon, "zone id", zone_id);
            for (let i = 0; i < zon.length; i++) {
                if (zon[i] == 0) {
                    document.getElementById("link" + zone_id[i]).disabled = false;
                    document.getElementById("unlink" + zone_id[i]).disabled = true;
                } else {
                    document.getElementById("link" + zone_id[i]).disabled = true;
                    document.getElementById("unlink" + zone_id[i]).disabled = false;
                }
            }
        };

        function link_banner(zoneid) {

            var link_url = live_URL + '/zonebyad_link/' + bannerid;


            var val = {
                "zoneid": "" + zoneid + "",
            }

            $.ajax({

                type: "POST",
                url: link_url,
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: val,
                dataType: "json",
                encode: true,
            }).done(function(data) {
                console.log('data...zone',data);

                alert(data.Message);
                location.reload();

            });

        }


        function unlink_banner(zoneid) {

            var link_url = live_URL + '/zonebyad_unlink/' + bannerid;


            var val = {
                "zoneid": "" + zoneid + "",
            }


            $.ajax({

                type: "POST",
                url: link_url,
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: val,
                dataType: "json",
                encode: true,
            }).done(function(data) {

                alert(data.msg);
                location.reload();

            });

        }

        // function button() {

        // var live_URL = '<?php echo $apiinvenpath; ?>';
        //     var token = 'Bearer ' + document.getElementById('token').value;

        //           var bannerid = '<?php echo $_REQUEST['bannerid']; ?>';

        //                 var values = {
        //                     "bannerid": "" + bannerid + "",
        //                 }

        //                 var api_url = live_URL + '/bannerbyzone_link/' + zone_id;


        //             $.ajax({
        //                 type: "POST",
        //                 url: api_url,
        //                 beforeSend: function(xhr) {
        //                     xhr.setRequestHeader('Authorization', token);
        //                 },
        //                 data: values,
        //                 dataType: "json",
        //                 encode: true,
        //             }).done(function(data) {

        //                 swal({
        //                         title: data.msg,
        //                         type: "success"
        //                     })
        //                     .then(data => {
        //                         if (data.msg == 'Banner already linked with zone') {
        //                         document.getElementById("unlink").disabled = true;
        //                              document.getElementById("unlink").disabled = false;
        //                         } else if (data.msg == 'Campaigns linked successfully!') {
        //                             document.getElementById("unlink").disabled = false;
        //                              document.getElementById("unlink").disabled = true;

        //                         }
        //                         location.reload();
        //                     });

        //             });

        //         }
    </script>
</body>

</html>
