<?php
include 'session.php';
include '../config.php';
include('../common.php'); ?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='assets/' data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title><?php echo $projecttitle; ?> - <?php echo $GLOBALS['delivery_options']; ?></title>
    <meta name="description" content="" />
    <?php include 'head.php'; ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.8/js/select2.min.js" defer></script>
    <link rel="stylesheet" href="../assets/css/lightbox.min.css">
    <style>
        .cancel-style {
            color: red !important
        }

        .cancel-style:hover {
            color: #fff !important
        }

        canvas {
            height: 175px;
            border-style: solid;
            border-width: 1px;
            border-color: black;
        }

        input {
            font-family: verdana;
            font-size: 12pt;
        }

        thead,
        tbody {
            display: block;
        }

        tbody {
            max-height: 400px;
            overflow-y: auto;
            overflow-x: auto;
        }

        tr,
        td {
            width: 1000px;
        }
    </style>
</head>

<body onload="get_limitations()">
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include 'sidebar.php'; ?>
            <!-- / Menu -->
            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include 'navbar.php'; ?>
                <!-- / Navbar -->
                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container">
						<div class="nav-align-top my-4 mx-3">
						<ul class="nav nav-tabs" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link" href="banner_edit.php?bannerid=<?php echo $_GET['bannerid']; ?>&campaignid=<?php echo $_GET['campaignid']; ?>"><?php echo $GLOBALS['strBanner_Edit_Head']; ?></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link active" href="#"><?php echo $GLOBALS['delivery_options']; ?></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="linked_zones.php?bannerid=<?php echo $_GET['bannerid']; ?>&campaignid=<?php echo $_GET['campaignid']; ?>"><?php echo $GLOBALS['link_zones']; ?></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="banner_advanced.php?bannerid=<?php echo $_GET['bannerid']; ?>&campaignid=<?php echo $_GET['campaignid']; ?>"><?php echo $GLOBALS['advanced']; ?></a>
                                </li>
                                 <li class="nav-item">
									<a class="nav-link" href="banner-secondtag.php?bannerid=<?php echo $_GET['bannerid']; ?>&campaignid=<?php echo $_GET['campaignid']; ?>"><?php echo $GLOBALS['banner_secondtag']; ?></a>
                                </li>
                            </ul>
						
                        <div class="card mt-5 mb-5">
                            <div class="card-header">
                                <p class="h3"><?php echo $GLOBALS['delivery_options']; ?></p>
                                <input type='hidden' name="bannerid" id="bannerid" value="<?php echo $_GET['bannerid']; ?>" />
                            </div>
                            <div class="card-body">
                                <div class="row mb-3">
                                    <div class="col-4">
                                        <label class="form-label mb-2" style="font-size: 1.8ch;"><?php echo $GLOBALS['add_del_rule']; ?></label>
                                    </div>
                                    <div class="col-5">
                                        <select id="delivery_rule" name="delivery_rule" class="form-select text-dark">
                                            <option value="0">Select Rule</option>
                                            <option value="deliveryLimitations:Client:Browser">Client - Browser (Deprecated)</option>
                                            <option value="deliveryLimitations:Client:BrowserVersion">Client - Browser Version</option>
                                            <option value="deliveryLimitations:Client:Domain">Client - Domain</option>
                                            <option value="deliveryLimitations:Client:Ip">Client - IP address</option>
                                            <option value="deliveryLimitations:Client:Language">Client - Language</option>
                                            <option value="deliveryLimitations:Client:Os">Client - Operating system (Deprecated)</option>
                                            <option value="deliveryLimitations:Client:OsVersion">Client - Operating System Version</option>
                                            <option value="deliveryLimitations:Client:Useragent">Client - Useragent</option>
                                            <option value="deliveryLimitations:Geo:City">Geo - Country / City</option>
                                            <option value="deliveryLimitations:Geo:ConnectionType">Geo - Connection Type</option>
                                            <option value="deliveryLimitations:Geo:Continent">Geo - Continent</option>
                                            <option value="deliveryLimitations:Geo:Country">Geo - Country</option>
                                            <option value="deliveryLimitations:Geo:Latlong">Geo - Latitude/Longitude</option>
                                            <option value="deliveryLimitations:Geo:Organisation">Geo - ISP/Organisation</option>
                                            <option value="deliveryLimitations:Geo:Postalcode">Geo - US/Canada Postal Code</option>
                                            <option value="deliveryLimitations:Geo:Subdivision1">Geo - Level 1 Subdivision</option>
                                            <option value="deliveryLimitations:Geo:Subdivision2">Geo - Level 2 Subdivision</option>
                                            <option value="deliveryLimitations:Geo:UsMetro">Geo - US Metro Code</option>
                                            <option value="deliveryLimitations:Site:Channel">Site - Delivery Rule Set</option>
                                            <option value="deliveryLimitations:Site:Hostnamelist">Site - Hostname List</option>
                                            <option value="deliveryLimitations:Site:Pageurl">Site - Page URL</option>
                                            <option value="deliveryLimitations:Site:Referingpage">Site - Referring Page</option>
                                            <option value="deliveryLimitations:Site:Registerabledomainlist">Site - Registerable Domain List</option>
                                            <option value="deliveryLimitations:Site:Source">Site - Source</option>
                                            <option value="deliveryLimitations:Site:Variable">Site - Variable</option>
                                            <option value="deliveryLimitations:Time:Date">Time - Date</option>
                                            <option value="deliveryLimitations:Time:Day">Time - Day of week</option>
                                            <option value="deliveryLimitations:Time:Hour">Time - Hour of day</option>
                                        </select>
                                    </div>
                                    <div class="col-3 justify-content-end">
                                        <button class="btn btn-primary text-white" style="position:relative;left:5%" id="addBtn"><?php echo $GLOBALS['add_rule']; ?></button>
                                    </div>
                                </div>

                                <hr class="solid">
                                <div class="container" id="added_rules">
                                    <div class="row mb-3">
                                        <div class="col-12">
                                            <p class="h4 text-dark"><?php echo $GLOBALS['added_rules']; ?></p>
                                            <p id="rule_error" class="alert alert-danger"></p>
                                        </div>
                                    </div>
                                </div>

                                <div class="container" id="no_rules">
                                    <div class="row mb-3">
                                        <div class="col-10">
                                            <p class="h6 text-primary"><?php echo $GLOBALS['no_rules']; ?></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="container">
                                    <div class="row mb-3">
                                        <div class="table-responsive text-nowrap">
                                            <table id="delivery_table" class="table table-striped table-responsive ">
                                                <tbody id="table_body">
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="container" id="get_banner_delivery_options">
                                <input name='xandrId' id='xandrId' type='hidden' value='' />
<input id='start_duration' name='start_duration' type='hidden' value='' />
<input id='end_duration' name='end_duration' type='hidden' value='' />
<table border='0' width='100%' cellpadding='0' cellspacing='0' bgcolor='#FFFFFF'>
    <td height='25' colspan='3' bgcolor='#FFFFFF'>
        <b>Custom Api</b>
      </td>        
    <tr>
        <td height='1' colspan='6'>Custom Api</td>
        <td height='1' colspan='6'>
            <select id='customid' class="form-select text-dark" name='customid' onchange=customChange(this.value);' class='medium'>
                <option value=''>-- Select Api --</option>
                </select>
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Advertiser Id</td>
        <td height='1' colspan='6'>
            <input name='advertiserid' class="form-select text-dark" type='text' value='' id='advertiserid' class='medium'>
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>        
        <tr>
        <td height='1' colspan='6'>Custom Name</td>
        <td height='1' colspan='6'>
            <input name='api_description' class="form-select text-dark" type='text' value='' id='api_description' class='medium'>
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>        
        <tr>
        <td height='1' colspan='6'>Line Item Name</td>
        <td height='1' colspan='6'>
            <input name='line_item_name' class="form-select text-dark" type='text' value='' id='line_item_name' class='medium'>
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Goal Target</td>
        <td height='1' colspan='6'>
            <input name='goaltarget' class="form-select text-dark" type='text' value='' id='goaltarget' class='medium'>
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Goal Threshold</td>
        <td height='1' colspan='6'>
            <input name='goalthreshold' class="form-select text-dark" type='text' value='' id='goalthreshold' class='medium'>
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Life Time Budget</td>
        <td height='1' colspan='6'>
            <input name='lifetimebudget'class="form-select text-dark"  type='text' value='' id='lifetimebudget' class='medium'>
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Post Click Goal Target</td>
        <td height='1' colspan='6'>
            <input name='postgoaltarget' class="form-select text-dark" type='text' value='' id='postgoaltarget' class='medium'>
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Post Click Goal Threshold</td>
        <td height='1' colspan='6'>
            <input name='postgoalthreshold'class="form-select text-dark"  type='text' value='' id='postgoalthreshold' class='medium'>
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Banner Duration</td>
        <td height='1' colspan='6'>
        <input type="date" name="banner_start" class="form-select text-dark" id="banner_start" class="form-control" placeholder="DD-MM-YYYY" />
        <input type="date" name="banner_end" class="form-select text-dark" id="banner_end" class="form-control" placeholder="DD-MM-YYYY" />
            <!-- <input class='date1' name='banner_start' id='banner_start' type='text' onchange='banner_duration(this.id,this.value)' value='' tabindex='2'/>
            <input type='image' src='".OX::assetPath ()."/images/icon-calendar.gif' class= 'calendar_icon' id='banner_start_button' align='absmiddle' border='0' tabindex='3' />
            <input class='date1' name='banner_end' id='banner_end' type='text' onchange='banner_duration(this.id,this.value)' value='' tabindex='4' /> 
            <input type='image' src='".OX::assetPath ()."/images/icon-calendar.gif' class= 'calendar_icon' id='banner_end_button' align='absmiddle' border='0' tabindex='3' />
            <script type='text/javascript'> -->
                <!-- Calendar.setup({
                    inputField: 'banner_start',
                    ifFormat: '%Y-%m-%d',
                    button: 'banner_start_button',
                    align: 'Bl',
                    weekNumbers: false,
                    firstDay: 1,
                    electric: false
                });
            
                Calendar.setup({
                    inputField: 'banner_end',
                    ifFormat: '%Y-%m-%d',
                    button: 'banner_end_button',
                    align: 'Bl',
                    weekNumbers: false,
                    firstDay: 1,
                    electric: false
                }); -->
                
                <!-- // var banner_start = '".$aBanner['duration_start']."';
                // var banner_end = '".$aBanner['duration_end']."';
            
                // $('input[id=start_duration]').val(banner_start);
                // $('input[id=end_duration]').val(banner_end);
            
            function banner_duration(id,value){
            // if(id=='duration_start'){ 
                    $('input[id=start_duration]').val($('#banner_start').val());
                    
            // }
            // if(id=='duration_end'){
                    $('input[id=end_duration]').val($('#banner_end').val());
            // } -->
            <!-- } -->
            </script>
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Banner visible in Xandr/BannerSecondTag</td>
        <td height='1' colspan='6'>
        
        <input type="date" name="xandr_banner_start" class="form-select text-dark" id="xandr_banner_start" class="form-control" placeholder="DD-MM-YYYY" />
        <input type="date" name="xandr_banner_end" class="form-select text-dark" id="xandr_banner_end" class="form-control" placeholder="DD-MM-YYYY" />
            <!-- <input class='date1' name='xandr_banner_start' id='xandr_banner_start' type='text' onchange='banner_duration(this.id,this.value)' value='' tabindex='2'/>
            <input type='image' src='".OX::assetPath ()."/images/icon-calendar.gif' class= 'calendar_icon' id='xandr_banner_start_button' align='absmiddle' border='0' tabindex='3' />
            <input class='date1' name='xandr_banner_end' id='xandr_banner_end' type='text' onchange='banner_duration(this.id,this.value)' value='' tabindex='4' /> 
            <input type='image' src='".OX::assetPath ()."/images/icon-calendar.gif' class= 'calendar_icon' id='xandr_banner_end_button' align='absmiddle' border='0' tabindex='3' /> -->
            <!-- <script type='text/javascript'>
                Calendar.setup({
                    inputField: 'xandr_banner_start',
                    ifFormat: '%Y-%m-%d',
                    button: 'xandr_banner_start_button',
                    align: 'Bl',
                    weekNumbers: false,
                    firstDay: 1,
                    electric: false
                });
            
                Calendar.setup({
                    inputField: 'xandr_banner_end',
                    ifFormat: '%Y-%m-%d',
                    button: 'xandr_banner_end_button',
                    align: 'Bl',
                    weekNumbers: false,
                    firstDay: 1,
                    electric: false
                });
                
            </script> -->
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Country</td>
        <td height='1' colspan='6'>
            <select id='countryid' class="form-select text-dark" name='countryid' class='medium'>
                <option value='46'>Switzerland</option>
            </select>         
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Region</td>
        <td height='1' colspan='6'>
            <textarea name='regionid' class="form-select text-dark" id='regionid' class='large small-h'></textarea>        
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Cities</td>
        <td height='1' colspan='6'>
            <textarea name='citiesid' class="form-select text-dark" id='citiesid' class='large small-h'></textarea>        
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Currency</td>
        <td height='1' colspan='6'>
            <input name='currency' class="form-select text-dark" type='text' value='' id='currency' class='medium'  />
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Payment Type</td>
        <td height='1' colspan='6'>
            <input name='paymenttype' class="form-select text-dark" type='text' value='' id='paymenttype' class='medium'  />
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Creative Rotation</td>
        <td height='1' colspan='6'>
            <input name='creativerotation' class="form-select text-dark" type='text' value='' id='creativerotation' class='medium'  />
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Ad Type</td>
        <td height='1' colspan='6'>
            <input name='adtype' class="form-select text-dark"  type='text' value='' id='adtype' class='medium'  />
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Device Types</td>
        <td height='1' colspan='6'>
            <input name='devicetypes' class="form-select text-dark" type='text' value='' id='devicetypes' class='medium'  />
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Revenue Type</td>
        <td height='1' colspan='6'>
            <input name='revenuetype' class="form-select text-dark" type='text' value='' id='revenuetype' class='medium'  />
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Minimum CPM</td>
        <td height='1' colspan='6'>
            <input name='mincpm' class="form-select text-dark" type='text' value='' id='mincpm' class='medium'  />
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Maximum CPM</td>
        <td height='1' colspan='6'>
            <input name='maxcpm' class="form-select text-dark" type='text' value='' id='maxcpm' class='medium'  />
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Pacing Percent</td>
        <td height='1' colspan='6'>
            <input name='pacing_percent' class="form-select text-dark" type='text' value='' id='pacing_percent' class='medium'  />
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Deal List</td>
        <td height='1' colspan='6'>
            <input name='deal_list' class="form-select text-dark" type='text' value='' id='deal_list' class='medium'  />
        </td>
        </tr>
    </table>
<br /><br /><br />
                                </div>
                                <!-- Save Changes Button -->
                                <div class="row mb-3" id="save_changes_btn">
                                    <div class="justify-content-end">
                                        <div class="col">
                                            <button class="btn btn-primary text-white" style="position:relative;left:75%" onclick="savechanges()"><?php echo $GLOBALS['save_changes']; ?></button>
                                        </div>
                                    </div>
                                </div>

                                <!-- Delivery Capping Per Visitor -->
                                <div class="card-header">
                                    <p class="h3"><?php echo $GLOBALS['delivery_capping']; ?></p>
                                    <p id="capping_error" class="alert alert-danger"></p>
                                </div>
                                <div class="card-body">
                                    <div class="row mb-3">
                                        <div class="col-4">
                                            <label class="form-label mb-2" style="font-size: 1.4ch;"> <?php echo $GLOBALS['limit_views']; ?> </label>
                                        </div>
                                        <div class="col-6">
                                            <input type="text" name="limit_views" id="limit_views" class="form-control" onkeypress="return isNumber(event)" placeholder="" />
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-4">
                                            <label class="form-label mb-2" style="font-size: 1.4ch;"> <?php echo $GLOBALS['limit_views_session']; ?> </label>
                                        </div>
                                        <div class="col-6">
                                            <input type="text" name="limit_views_session" id="limit_views_session" class="form-control" onkeypress="return isNumber(event)" placeholder="" />
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-4">
                                            <label class="form-label mb-2" style="font-size: 1.4ch;"> <?php echo $GLOBALS['reset_view']; ?> </label>
                                        </div>
                                        <div class="col-1">
                                            <label class="form-label">&nbsp;<?php echo $GLOBALS['hour']; ?></label>
                                        </div>
                                        <div class="col-1"><input type="text" name="hour" id="hour" class="form-control" onkeypress="return isNumber(event)" placeholder="" />
                                        </div>
                                        <div class="col-1">
                                            <label class="form-label">&nbsp;<?php echo $GLOBALS['minutes']; ?></label>
                                        </div>
                                        <div class="col-1"><input type="text" name="minutes" id="minutes" class="form-control" onkeypress="return isNumber(event)" placeholder="" />
                                        </div>
                                        <div class="col-1">
                                            <label class="form-label">&nbsp;<?php echo $GLOBALS['seconds']; ?></label>
                                        </div>
                                        <div class="col-1"><input type="text" name="seconds" id="seconds" class="form-control" onkeypress="return isNumber(event)" placeholder="" />
                                        </div>
                                    </div>
                                    <div class="row justify-content-end">
                                        <div class="col">
                                            <button class="btn btn-primary text-white" style="position:relative;left:75%" onclick="addcapping()"><?php echo $GLOBALS['add_capping']; ?></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        </div>
                    </div>
                    <!-- / Content -->
                    <!-- Footer -->
                    <?php include 'footer.php'; ?>
                    <!-- / Footer -->
                    <!-- <script src="../assets/js/lightbox-plus-jquery.min.js"></script> -->
                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <script>
        var row_id = 0;
        var live_URL = '<?php echo $apiinvenpath; ?>';
        var token = 'Bearer ' + document.getElementById('token').value;
        var bannerid = '<?php echo $_REQUEST['bannerid']; ?>';

        $(document).ready(function() {
            $('#capping_error').hide();
            $('#rule_error').hide();
            $.ajax({
                url: live_URL + '/get_capping/' + bannerid,
                type: "GET",
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function(data) {
                $('#limit_views').val(data.data.capping);
                $('#limit_views_session').val(data.data.session_capping);
                var reset_time = data.data.block;
                var h = Math.floor(reset_time / 3600);
                var m = Math.floor(reset_time % 3600 / 60);
                var s = Math.floor(reset_time % 3600 % 60);
                $('#hour').val(h);
                $('#minutes').val(m);
                $('#seconds').val(s);
            });
            $.ajax({
                url: live_URL + '/get_banner_delivery_options/' + bannerid,
                type: "GET",
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function(data) {
                console.log("get_banner_deliveryoptions=",data);
                var timedate1=data.time1;
                var timedate2=data.time2;
                var data = data.data;
                console.log('test'+data);
                
                for(var i = 0; i < data.length; i++) {
                    $.ajax({
                type: "GET",
                url: live_URL + '/get_banner_acl_delivery_options/' + bannerid,
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function (data) {
               console.log(data);
               var row = data.data;
    var options = '';
    if(data.customid == row.customid)
                    {
                        var djax_chk='selected=selected';
                    }
                    else
                    {
                        var djax_chk='';
                    }  
                    
    for(var i=0; i<row.length; i++) { // Loop through the data & construct the options
        options += '<option '+djax_chk+' value="'+row[i].customid+'">'+row[i].name+'</option>';
       
    }

    // Append to the html
    $('#customid').append(options);               
                // showdata(data);
            });
            
            
            
           
                    $('#xandrId').val(data[i].xandrcreativeid);
                    $('#advertiserid').val(data[i].advertiserid);
                    $('#api_description').val(data[i].api_description);
                    $('#line_item_name').val(data[i].line_item_name);
                    $('#goaltarget').val(data[i].goaltarget);
                    $('#goalthreshold').val(data[i].goalthreshold);
                    $('#lifetimebudget').val(data[i].lifetimebudget);
                    $('#postgoaltarget').val(data[i].postgoaltarget);
                    $('#postgoalthreshold').val(data[i].postgoalthreshold);
                    $('#banner_start').val(data[i].duration_start);
                    $('#banner_end').val(data[i].duration_end);
                    $('#xandr_banner_start').val(data[i].xandr_duration_start);
                    $('#xandr_banner_end').val(data[i].xandr_duration_end);
                    $('#regionid').val(data[i].regionid);
                    $('#citiesid').val(data[i].citiesid);
                    $('#currency').val(data[i].currency);
                    $('#paymenttype').val(data[i].paymenttype);
                    $('#creativerotation').val(data[i].creativerotation);
                    $('#adtype').val(data[i].adtype);
                    $('#devicetypes').val(data[i].devicetypes);
                    $('#revenuetype').val(data[i].revenuetype);
                    $('#mincpm').val(data[i].mincpm);
                    $('#maxcpm').val(data[i].maxcpm);
                    $('#pacing_percent').val(data[i].pacing_percent);
                    $('#deal_list').val(data[i].deal_list);

                    
                }
            });
        });

        // Get limitations from database
        function get_limitations() {
            $.ajax({
                url: live_URL + '/get_limitation/' + bannerid,
                type: "GET",
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function(data) {
                var getdata = data.data;
                var data_length;
                if (!getdata) {
                    data_length = 0;
                } else {
                    data_length = getdata.length;
                }
                if (data_length == 0) {
                    $('#no_rules').show();
                    // $('#save_changes_btn').hide();
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container" id="time-date1">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary">Time - Date</p>
                                                <p class="h6 text-secondary">Only display this banner when:</p>
                                            </div>
                                            
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Time:Date" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"> Time - Date </label>
                                            </div>
                                            <div class="col-6">
                                                <select class="form-select text-dark" id="timedate_sel" name="timedate_sel">
                                                    <option value="==">Is equal to</option>
                                                    <option value="is different from">Is different from</option>
                                                    <option value=">">is later than</option>
                                                    <option value=">=" selected="selected">is later than or equal to</option>
                                                    <option value="<">is earlier than</option>
                                                    <option value="<=">is earlier than or equal to</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4"></div>
                                            <div class="col-6">
                                                <input type="date" name="timedate" id="timedate1" class="form-control" placeholder="DD-MM-YYYY" />
                                            </div>
                                        </div>
                                    </div></td></tr>`);
                                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container" id="time-date2">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary">Time - Date</p>
                                                <p class="h6 text-secondary">Only display this banner when:</p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Time:Date" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"> Time - Date </label>
                                            </div>
                                            <div class="col-6">
                                                <select class="form-select text-dark" id="timedate_sel" name="timedate_sel">
                                                    <option value="==">Is equal to</option>
                                                    <option value="is different from">Is different from</option>
                                                    <option value=">">is later than</option>
                                                    <option value=">=">is later than or equal to</option>
                                                    <option value="<">is earlier than</option>
                                                    <option value="<=" selected="selected">is earlier than or equal to</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4"></div>
                                            <div class="col-6">
                                                <input type="date" name="timedate" id="timedate2" class="form-control" placeholder="DD-MM-YYYY" />
                                            </div>
                                        </div>
                                    </div></td></tr>`);
                } else {
                    $('#no_rules').hide();
                    $('#save_changes_btn').show();
                    console.log("get_data:", data.data);
                    $.each(getdata, function(index, value) {
                        var type = value['type'];
                        var comparison = value['comparison'];
                        var logical = value['logical'];
                        var data = value['data'];
                        var i = ++value['executionorder'];
                        $('#delivery_rule').val(type);
                        addBtn.click();
                        if (type == 'deliveryLimitations:Client:Browser') {
                            $('tr#R' + i + ' #condition').val(logical);
                            $('tr#R' + i + ' #delivery_rule_cb').val(comparison);
                            var browser = data.split(',');
                            $.each(browser, function(j, val) {
                                $("tr#R" + i + " .browser_check[value='" + val + "']").prop('checked', true);
                            });

                        } else if (type == 'deliveryLimitations:Client:BrowserVersion') {
                            $('tr#R' + i + ' #condition').val(logical);
                            $('tr#R' + i + ' #delivery_rule_cbv').val(comparison);
                            if ($('tr#R' + i + ' #delivery_rule_cbv').val() == 'nn') {
                                $('tr#R' + i + ' #browser_version').val('');
                                $('tr#R' + i + ' #brow_ver').hide();
                            } else {
                                $('tr#R' + i + ' #brow_ver').show();
                            }
                            var browser_ver = data.split('|');
                            $('tr#R' + i + ' #browser_select').val(browser_ver[0]);
                            $('tr#R' + i + ' #browser_version').val(browser_ver[1]);

                        } else if (type == 'deliveryLimitations:Client:Domain') {
                            $('tr#R' + i + ' #condition').val(logical);
                            $('tr#R' + i + ' #delivery_rule_cb').val(comparison);
                            $('tr#R' + i + ' #domain').val(data);

                        } else if (type == 'deliveryLimitations:Client:Ip') {
                            $('tr#R' + i + ' #condition').val(logical);
                            $('tr#R' + i + ' #ip_sel').val(comparison);
                            $('tr#R' + i + ' #ipaddress').val(data);

                        } else if (type == 'deliveryLimitations:Client:Language') {
                            $('tr#R' + i + ' #condition').val(logical);
                            $('tr#R' + i + ' #lang_sel').val(comparison);
                            var language = data.split(',');
                            $('tr#R' + i + ' .language_select').val(language).change();


                        } else if (type == 'deliveryLimitations:Client:Os') {
                            $('tr#R' + i + ' #condition').val(logical);
                            $('tr#R' + i + ' #delivery_rule_cos').val(comparison);
                            var os = data.split(',');
                            $.each(os, function(j, val) {
                                $("tr#R" + i + " .os_check[value='" + val + "']").prop('checked', true);
                            });

                        } else if (type == 'deliveryLimitations:Client:OsVersion') {
                            $('tr#R' + i + ' #condition').val(logical);
                            $('tr#R' + i + ' #delivery_rule_cosv').val(comparison);
                            if ($('tr#R' + i + ' #delivery_rule_cosv').val() == 'nn') {
                                $('tr#R' + i + ' #os_version').val('');
                                $('tr#R' + i + ' #os_ver').hide();
                            } else {
                                $('tr#R' + i + ' #os_ver').show();
                            }
                            var os_ver = data.split('|');
                            $('tr#R' + i + ' #os_select').val(os_ver[0]);
                            $('tr#R' + i + ' #os_version').val(os_ver[1]);

                        } else if (type == 'deliveryLimitations:Client:Useragent') {
                            $('tr#R' + i + ' #condition').val(logical);
                            $('tr#R' + i + ' #useragent_sel').val(comparison);
                            $('tr#R' + i + ' #useragent').val(data);

                        } else if (type == 'deliveryLimitations:Geo:City') {
                            $('tr#R' + i + ' #condition').val(logical);
                            $('tr#R' + i + ' #delivery_rule_city').val(comparison);
                            var city = data.split('|');
                            $('tr#R' + i + ' #city').val(city[1]);
                            get_country(type, i, city[0]);

                        } else if (type == 'deliveryLimitations:Geo:ConnectionType') {
                            $('tr#R' + i + ' #condition').val(logical);
                            $('tr#R' + i + ' #delivery_rule_conection').val(comparison);
                            var con_type = data.split(',');
                            $.each(con_type, function(j, val) {
                                $("tr#R" + i + " .connection_check[value='" + val + "']").prop('checked', true);
                            });

                        } else if (type == 'deliveryLimitations:Geo:Continent') {
                            $('tr#R' + i + ' #condition').val(logical);
                            $('tr#R' + i + ' #delivery_rule_continent').val(comparison);
                            var continent = data.split(',');
                            $.each(continent, function(j, val) {
                                $("tr#R" + i + " .continent_check[value='" + val + "']").prop('checked', true);
                            });

                        } else if (type == 'deliveryLimitations:Geo:Country') {
                            $('tr#R' + i + ' #condition').val(logical);
                            $('tr#R' + i + ' #delivery_rule_country').val(comparison);
                            get_country(type, i, data);

                        } else if (type == 'deliveryLimitations:Geo:Latlong') {
                            $('tr#R' + i + ' #condition').val(logical);
                            $('tr#R' + i + ' #delivery_rule_latitude').val(comparison);
                            var lat_long = data.split(',');
                            $('tr#R' + i + ' #latitude1').val(lat_long[0]);
                            $('tr#R' + i + ' #latitude2').val(lat_long[1]);
                            $('tr#R' + i + ' #longitude1').val(lat_long[2]);
                            $('tr#R' + i + ' #longitude2').val(lat_long[3]);

                        } else if (type == 'deliveryLimitations:Geo:Organisation') {
                            $('tr#R' + i + ' #condition').val(logical);
                            $('tr#R' + i + ' #delivery_rule_isp').val(comparison);
                            $('tr#R' + i + ' #isp').val(data);

                        } else if (type == 'deliveryLimitations:Geo:Postalcode') {
                            $('tr#R' + i + ' #condition').val(logical);
                            $('tr#R' + i + ' #delivery_rule_postal').val(comparison);
                            $('tr#R' + i + ' #us_canada').val(data);

                        } else if (type == 'deliveryLimitations:Geo:Subdivision1') {
                            $('tr#R' + i + ' #condition').val(logical);
                            $('tr#R' + i + ' #delivery_rule_level1').val(comparison);
                            var subdiv1 = data.split('|');
                            get_subdiv1_country(i, subdiv1[0], subdiv1[1]);

                        } else if (type == 'deliveryLimitations:Geo:Subdivision2') {
                            $('tr#R' + i + ' #condition').val(logical);
                            $('tr#R' + i + ' #delivery_rule_level2').val(comparison);
                            var subdiv2 = data.split('|');
                            get_subdiv2_country(i, subdiv2[0], subdiv2[1]);

                        } else if (type == 'deliveryLimitations:Geo:UsMetro') {
                            $('tr#R' + i + ' #condition').val(logical);
                            $('tr#R' + i + ' #delivery_rule_metro').val(comparison);
                            get_usmetro(i, data);

                        } else if (type == 'deliveryLimitations:Site:Pageurl') {
                            $('tr#R' + i + ' #condition').val(logical);
                            $('tr#R' + i + ' #sitepageurl_sel').val(comparison);
                            $('tr#R' + i + ' #site_page').val(data);

                        } else if (type == 'deliveryLimitations:Site:Referingpage') {
                            $('tr#R' + i + ' #condition').val(logical);
                            $('tr#R' + i + ' #siterefpage_sel').val(comparison);
                            $('tr#R' + i + ' #site_referring').val(data);

                        } else if (type == 'deliveryLimitations:Site:Source') {
                            $('tr#R' + i + ' #condition').val(logical);
                            $('tr#R' + i + ' #sitesource_sel').val(comparison);
                            $('tr#R' + i + ' #site_source').val(data);

                        } else if (type == 'deliveryLimitations:Site:Variable') {
                            $('tr#R' + i + ' #condition').val(logical);
                            $('tr#R' + i + ' #sitesource_sel').val(comparison);
                            var value = data.split('|');
                            $('tr#R' + i + ' #site_variable').val(value[0]);
                            $('tr#R' + i + ' #site_variable1').val(value[1]);

                        } else if (type == 'deliveryLimitations:Time:Date') {
                            $('tr#R' + i + ' #condition').val(logical);
                            $('tr#R' + i + ' #timedate_sel').val(comparison);
                            var date= data.split('@');
                         var year = parseInt(date[0].substr(0,4), 10);
var day = parseInt(date[0].substr(6, 7), 10);
var month = parseInt(date[0].substr(4,2), 10);
// // // console.log(year);
// // // console.log(month);
// // // console.log(day);
var date=year+"-"+month+"-"+day;
// // var mydate = new Date(date);
// // // console.log(mydate);
// // // console.log(date);
// // var date2 = new Date("2022/5/19");
// // console.log(date2);


// var dateString = "10/23/2015"; // Oct 23
// var dateObject = new Date(dateString);
var now = new Date(date);

var day = ("0" + now.getDate()).slice(-2);
var month = ("0" + (now.getMonth() + 1)).slice(-2);

var today = now.getFullYear()+"-"+(month)+"-"+(day) ;
// // document.body.innerHTML = dateObject.toString();
                            $('tr#R' + i + ' #timedate').val(today);

                        } else if (type == 'deliveryLimitations:Time:Day') {
                            $('tr#R' + i + ' #condition').val(logical);
                            $('tr#R' + i + ' #delivery_rule_tday').val(comparison);
                            var day = data.split(',');
                            $.each(day, function(j, val) {
                                $("tr#R" + i + " .time_day[value='" + val + "']").prop('checked', true);
                            });
                        } else if (type == 'deliveryLimitations:Time:Hour') {
                            $('tr#R' + i + ' #condition').val(logical);
                            $('tr#R' + i + ' #delivery_rule_thour').val(comparison);
                            var time = data.split(',');
                            $.each(time, function(j, val) {
                                $("tr#R" + i + " .time_hour[value='" + val + "']").prop('checked', true);
                            });
                        }
                    });
                }
            });
        }

        // add rule
        $('#addBtn').on('click', function() {
            var select_option = $('#delivery_rule option:selected').val();
            if (select_option != '0') {
                $('#no_rules').hide();
                $('#save_changes_btn').show();
                if (select_option == "deliveryLimitations:Client:Browser") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="client-browser">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['client_browser']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">

                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>

                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Client:Browser"><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>

                                            </div>

                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"> <?php echo $GLOBALS['client_browser']; ?> </label>
                                            </div>
                                            <div class="col-6">
                                                <select id="delivery_rule_cb" name="delivery_rule_cb" class="form-select text-dark" >
                                                    <option value="=~">Is any of</option>
                                                    <option value="!~">Is not any of</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-2"><input type="checkbox" class="form-check-input browser_check" id="chrome" name="chrome" value="GC"><label class="form-label">&nbsp;<?php echo $GLOBALS['chrome']; ?></label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input browser_check" id="firefox" name="firefox" value="FX"><label class="form-label">&nbsp;<?php echo $GLOBALS['firefox']; ?></label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input browser_check" id="edge" name="edge" value="edge"><label class="form-label">&nbsp;<?php echo $GLOBALS['edge']; ?></label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input browser_check" id="safari" name="SF" value="safari"><label class="form-label">&nbsp;<?php echo $GLOBALS['safari']; ?></label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input browser_check" id="opera" name="opera" value="OP"><label class="form-label">&nbsp;<?php echo $GLOBALS['opera']; ?></label></div>
                                        </div>
                                    </div> </td></tr>`);

                } else if (select_option == "deliveryLimitations:Client:BrowserVersion") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="client-browser-ver">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['client_browser_version']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Client:BrowserVersion" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>

                                            </div>

                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"> <?php echo $GLOBALS['client_browser_version']; ?> </label>
                                            </div>
                                            <div class="col-6">
                                                <select id="delivery_rule_cbv" name="delivery_rule_cbv" class="form-select text-dark" onchange="delivery_rule_cbv(this.value,${row_id});">
                                                    <option value="nn">Is any version of</option>
                                                    <option value="==">Is equal to</option>
                                                    <option value="!=">Is Different from</option>
                                                    <option value="lt">Is less than</option>
                                                    <option value="gt">Is greater than</option>
                                                    <option value="le">Is less or equal to</option>
                                                    <option value="ge">Is greater or equal to</option>

                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"> <?php echo $GLOBALS['browser']; ?> </label>
                                            </div>
                                            <div class="col-6">
                                                <select id="browser_select" name="browser_select" class="form-select text-dark"  >
                                                    <option value="Chrome">Chrome</option>
                                                    <option value="Firefox">Firefox</option>
                                                    <option value="Edge">Edge</option>
                                                    <option value="Safari">Safari</option>
                                                    <option value="Opera">Opera</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div id="brow_ver">
                                            <div class="row mb-3">
                                                <div class="col-4">
                                                    <label class="form-label mb-2" style="font-size: 1.4ch;"> <?php echo $GLOBALS['version']; ?> </label>
                                                </div>
                                                <div class="col-6">
                                                    <input type="text" name="browser_version" id="browser_version" class="form-control" placeholder="<?php echo $GLOBALS['enter_browser_version']; ?>" />
                                                </div>
                                            </div>
                                        </div>
                                    </div></td></tr>`);
                    var value = $('tr#R' + row_id + ' #delivery_rule_cbv option:selected').val();
                    delivery_rule_cbv(value, row_id);

                } else if (select_option == "deliveryLimitations:Client:Domain") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="client-domain">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['client_domain']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Client:Domain" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"> <?php echo $GLOBALS['client_domain']; ?> </label>
                                            </div>
                                            <div class="col-6">
                                                <select class="form-select text-dark" id="domain_sel" name="domain_sel">
                                                    <option value="==">Is equal to</option>
                                                    <option value="!=">Is different from</option>
                                                    <option value="=~">Contains</option>
                                                    <option value="!~">Does not contain</option>
                                                    <option value="=x">Regex match</option>
                                                    <option value="!x">Regex does not match</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4"></div>
                                            <div class="col-6">
                                                <input type="text" name="domain" id="domain" class="form-control" placeholder="<?php echo $GLOBALS['enter_domain']; ?>" />
                                            </div>
                                        </div>
                                    </div></td></tr>`);

                } else if (select_option == "deliveryLimitations:Client:Ip") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="client-ip">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['client_ip']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Client:Ip" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"> <?php echo $GLOBALS['client_ip']; ?> </label>
                                            </div>
                                            <div class="col-6">
                                                <select class="form-select text-dark" id="ip_sel" name="ip_sel">
                                                    <option value="==">Is equal to</option>
                                                    <option value="!=">Is different from</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4"></div>
                                            <div class="col-6">
                                                <input type="text" name="ipaddress" id="ipaddress" class="form-control" placeholder="<?php echo $GLOBALS['enter_ip']; ?>" />
                                            </div>
                                        </div>
                                    </div></td></tr>`);

                } else if (select_option == "deliveryLimitations:Client:Language") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="client-lang">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['client_lang']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Client:Language" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"> <?php echo $GLOBALS['client_lang']; ?> </label>
                                            </div>
                                            <div class="col-6">
                                                <select class="form-select text-dark" id="lang_sel" name="lang_sel">
                                                    <option value="=~">Is any of</option>
                                                    <option value="!~">Is not any of</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"> <?php echo $GLOBALS['language']; ?> </label>
                                            </div>
                                            <div class="col-6">
                                                <select multiple id="language_select${row_id}" name="language_select" class="form-select text-dark language_select" onchange="">
                                                <option value="af">Afrikaans</option>
                                                <option value="sq">Albanian</option>
                                                <option value="am">Amharic</option>
                                                <option value="ar">Arabic</option>
                                                <option value="ar-dz">Arabic/Algeria</option>
                                                <option value="ar-bh">Arabic/Bahrain</option>
                                                <option value="ar-eg">Arabic/Egypt</option>
                                                <option value="ar-iq">Arabic/Iraq</option>
                                                <option value="ar-jo">Arabic/Jordan</option>
                                                <option value="ar-kw">Arabic/Kuwait</option>
                                                <option value="ar-lb">Arabic/Lebanon</option>
                                                <option value="ar-ly">Arabic/Libya</option>
                                                <option value="ar-ma">Arabic/Morocco</option>
                                                <option value="ar-om">Arabic/Oman</option>
                                                <option value="ar-qa">Arabic/Qatar</option>
                                                <option value="ar-sa">Arabic/Saudi Arabia</option>
                                                <option value="ar-sy">Arabic/Syria</option>
                                                <option value="ar-tn">Arabic/Tunisia</option>
                                                <option value="ar-ae">Arabic/United Arab Emirates</option>
                                                <option value="ar-ye">Arabic/Yemen</option>
                                                <option value="hy">Armenian</option>
                                                <option value="as">Assamese</option>
                                                <option value="az">Azeri</option>
                                                <option value="eu">Basque</option>
                                                <option value="be">Belarusian</option>
                                                <option value="bn">Bengali</option>
                                                <option value="bs">Bosnian</option>
                                                <option value="bg">Bulgarian</option>
                                                <option value="my">Burmese</option>
                                                <option value="ca">Catalan</option>
                                                <option value="zh">Chinese</option>
                                                <option value="zh-cn">Chinese/China</option>
                                                <option value="zh-hk">Chinese/Hong Kong SAR</option>
                                                <option value="zh-mo">Chinese/Macau SAR</option>
                                                <option value="zh-sg">Chinese/Singapore</option>
                                                <option value="zh-tw">Chinese/Taiwan</option>
                                                <option value="hr">Croatian</option>
                                                <option value="cs">Czech</option>
                                                <option value="da">Danish</option>
                                                <option value="nl">Dutch</option>
                                                <option value="nl-be">Dutch/Belgium</option>
                                                <option value="nl-nl">Dutch/Netherlands</option>
                                                <option value="en">English</option>
                                                <option value="en-au">English/Australia</option>
                                                <option value="en-bz">English/Belize</option>
                                                <option value="en-ca">English/Canada</option>
                                                <option value="en-cb">English/Caribbean</option>
                                                <option value="en-gb">English/Great Britain</option>
                                                <option value="en-in">English/India</option>
                                                <option value="en-ie">English/Ireland</option>
                                                <option value="en-jm">English/Jamaica</option>
                                                <option value="en-nz">English/New Zealand</option>
                                                <option value="en-ph">English/Philippines</option>
                                                <option value="en-za">English/SouthernAfrica</option>
                                                <option value="en-tt">English/Trinidad</option>
                                                <option value="en-us">English/UnitedStates</option>
                                                <option value="et">Estonian</option>
                                                <option value="mk">FYRO Macedonia</option>
                                                <option value="fo">Faroese</option>
                                                <option value="fa">Farsi</option>
                                                <option value="fi">Finnish</option>
                                                <option value="fr">French</option>
                                                <option value="fr-be">French/Belgium</option>
                                                <option value="fr-ca">French/Canada</option>
                                                <option value="fr-fr">French/France</option>
                                                <option value="fr-lu">French/Luxembourg</option>
                                                <option value="fr-ch">French/Switzerland</option>
                                                <option value="gd">Gaelic</option>
                                                <option value="de">German</option>
                                                <option value="de-at">German/Austria</option>
                                                <option value="de-de">German/Germany</option>
                                                <option value="de-li">German/Liechtenstein</option>
                                                <option value="de-lu">German/Luxembourg</option>
                                                <option value="de-ch">German/Switzerland</option>
                                                <option value="el">Greek</option>
                                                <option value="gn">Guarani</option>
                                                <option value="gu">Gujarati</option>
                                                <option value="he">Hebrew</option>
                                                <option value="hi">Hindi</option>
                                                <option value="hu">Hungarian</option>
                                                <option value="is">Icelandic</option>
                                                <option value="id">Indonesian</option>
                                                <option value="it">Italian</option>
                                                <option value="it-it">Italian/Italy</option>
                                                <option value="it-ch">Italian/Switzerland</option>
                                                <option value="ja">Japanese</option>
                                                <option value="kn">Kannada</option>
                                                <option value="ks">Kashmiri</option>
                                                <option value="kk">Kazakh</option>
                                                <option value="km">Khmer</option>
                                                <option value="ko">Korean</option>
                                                <option value="lo">Lao</option>
                                                <option value="la">Latin</option>
                                                <option value="lv">Latvian</option>
                                                <option value="lt">Lithuanian</option>
                                                <option value="ms">Malay</option>
                                                <option value="ms-bn">Malay/Brunei</option>
                                                <option value="ms-my">Malay/Malaysia</option>
                                                <option value="ml">Malayalam</option>
                                                <option value="mt">Maltese</option>
                                                <option value="mi">Maori</option>
                                                <option value="mr">Marathi</option>
                                                <option value="mn">Mongolian</option>
                                                <option value="ne">Nepali</option>
                                                <option value="no">Norwegian</option>
                                                <option value="or">Oriya</option>
                                                <option value="pl">Polish</option>
                                                <option value="pt">Portuguese</option>
                                                <option value="pt-br">Portuguese/Brazil</option>
                                                <option value="pt-pt">Portuguese/Portugal</option>
                                                <option value="pa">Punjabi</option>
                                                <option value="rm">Raeto-Romance</option>
                                                <option value="ro">Romanian</option>
                                                <option value="ro-mo">Romanian/Moldova</option>
                                                <option value="ru">Russian</option>
                                                <option value="ru-mo">Russian/Moldova</option>
                                                <option value="sa">Sanskrit</option>
                                                <option value="sr">Serbian</option>
                                                <option value="tn">Setsuana</option>
                                                <option value="sd">Sindhi</option>
                                                <option value="si">Sinhala</option>
                                                <option value="sk"> Slovak</option>
                                                <option value="sl">Slovenian</option>
                                                <option value="so">Somali</option>
                                                <option value="sb">Sorbian</option>
                                                <option value="es">Spanish</option>
                                                <option value="es-ar">Spanish/Argentina</option>
                                                <option value="es-bo">Spanish/Bolivia</option>
                                                <option value="es-cl">Spanish/Chile</option>
                                                <option value="es-co">Spanish/Colombia</option>
                                                <option value="es-cr">Spanish/CostaRica</option>
                                                <option value="es-do">Spanish/Dominican Republic</option>
                                                <option value="es-ec">Spanish/Ecuador</option>
                                                <option value="es-sv">Spanish/El Salvador</option>
                                                <option value="es-gt">Spanish/Guatemala</option>
                                                <option value="es-hn">Spanish/Honduras</option>
                                                <option value="es-mx">Spanish/Mexico</option>
                                                <option value="es-ni">Spanish/Nicaragua</option>
                                                <option value="es-pa">Spanish/Panama</option>
                                                <option value="es-py">Spanish/Paraguay</option>
                                                <option value="es-pe">Spanish/Peru</option>
                                                <option value="es-pr">Spanish/Puerto Rico</option>
                                                <option value="es-es">Spanish/Spain(Traditional)</option>
                                                <option value="es-uy">Spanish/Uruguay</option>
                                                <option value="es-ve">Spanish/Venezuela</option>
                                                <option value="sw">Swahili</option>
                                                <option value="sv">Swedish</option>
                                                <option value="sv-fi">Swedish/Finland</option>
                                                <option value="sv-se">Swedish/Sweden</option>
                                                <option value="tg">Tajik</option>
                                                <option value="ta">Tamil</option>
                                                <option value="tt">Tatar</option>
                                                <option value="te">Telugu</option>
                                                <option value="th">Thai</option>
                                                <option value="bo">Tibetan</option>
                                                <option value="ts">Tsonga</option>
                                                <option value="tr">Turkish</option>
                                                <option value="tk">Turkmen</option>
                                                <option value="uk">Ukrainian</option>
                                                <option value="ur">Urdu</option>
                                                <option value="uz">Uzbek</option>
                                                <option value="vi">Vietnamese</option>
                                                <option value="cy">Welsh</option>
                                                <option value="xh">Xhosa</option>
                                                <option value="yi">Yiddish</option>
                                                <option value="zu">Zulu</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div></td></tr>`);
                    $('#language_select' + row_id).select2();

                } else if (select_option == "deliveryLimitations:Client:Os") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="client-os">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['client_os']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Client:Os" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"> <?php echo $GLOBALS['client_os']; ?> </label>
                                            </div>
                                            <div class="col-6">
                                                <select id="delivery_rule_cos" name="delivery_rule_cos" class="form-select text-dark" onchange="">
                                                    <option value="=~">Is any of</option>
                                                    <option value="!~">Is not any of</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-2"><input type="checkbox" class="form-check-input os_check" id="windows" name="windows" value="w7"><label class="form-label">&nbsp;<?php echo $GLOBALS['windows']; ?></label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input os_check" id="ios" name="ios" value="ios"><label class="form-label">&nbsp;<?php echo $GLOBALS['ios']; ?></label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input os_check" id="android" name="android" value="android"><label class="form-label">&nbsp;<?php echo $GLOBALS['android']; ?></label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input os_check" id="linux" name="linux" value="linux"><label class="form-label">&nbsp;<?php echo $GLOBALS['linux']; ?></label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input os_check" id="chromeos" name="chromeos" value="chromeos"><label class="form-label">&nbsp;<?php echo $GLOBALS['chrome_os']; ?></label></div>
                                        </div>
                                    </div></td></tr>`);

                } else if (select_option == "deliveryLimitations:Client:OsVersion") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="client-os-ver">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['client_os_version']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Client:OsVersion" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"> <?php echo $GLOBALS['client_os_version']; ?> </label>
                                            </div>
                                            <div class="col-6">
                                                <select id="delivery_rule_cosv" name="delivery_rule_cosv" class="form-select text-dark" onchange="delivery_rule_cosv(this.value,${row_id})">
                                                    <option value="nn">Is any version of</option>
                                                    <option value="==">Is equal to</option>
                                                    <option value="!=">Is Different from</option>
                                                    <option value="lt">Is less than</option>
                                                    <option value="gt">Is greater than</option>
                                                    <option value="le">Is less or equal to</option>
                                                    <option value="ge">Is greater or equal to</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"> <?php echo $GLOBALS['os']; ?> </label>
                                            </div>
                                            <div class="col-6">
                                                <select id="os_select" name="os_select" class="form-select text-dark" onchange="">
                                                    <option value="Windows">Windows</option>
                                                    <option value="iOS">iOS</option>
                                                    <option value="Linux">Linux</option>
                                                    <option value="Android">Android</option>
                                                    <option value="Chrome OS">Chrome OS</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div id="os_ver">
                                            <div class="row mb-3">
                                                <div class="col-4">
                                                    <label class="form-label mb-2" style="font-size: 1.4ch;"> <?php echo $GLOBALS['version']; ?> </label>
                                                </div>
                                                <div class="col-6">
                                                    <input type="text" name="os_version" id="os_version" class="form-control" placeholder="<?php echo $GLOBALS['enter_os_ver']; ?>" />
                                                </div>
                                            </div>
                                        </div>
                                    </div></td></tr>`);
                    var value = $('tr#R' + row_id + ' #delivery_rule_cosv option:selected').val();
                    delivery_rule_cosv(value, row_id);

                } else if (select_option == "deliveryLimitations:Client:Useragent") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="client-useragent">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['client_user_agent']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Client:Useragent" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"> <?php echo $GLOBALS['client_user_agent']; ?> </label>
                                            </div>
                                            <div class="col-6">
                                                <select class="form-select text-dark" id="useragent_sel" name="useragent_sel">
                                                    <option value="==">Is equal to</option>
                                                    <option value="!=">Is different from</option>
                                                    <option value="=~">Contains</option>
                                                    <option value="!~">Does not contain</option>
                                                    <option value="=x">Regex match</option>
                                                    <option value="!x">Regex does not match</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4"></div>
                                            <div class="col-6">
                                                <input type="text" name="useragent" id="useragent" class="form-control" placeholder="<?php echo $GLOBALS['enter_user_agent']; ?>" />
                                            </div>
                                        </div>
                                    </div></td></tr>`);

                } else if (select_option == "deliveryLimitations:Geo:City") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="geo-city">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['geo_country_city']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Geo:City" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"><?php echo $GLOBALS['geo_country_city']; ?></label>
                                            </div>
                                            <div class="col-6">
                                                <select class="form-select text-dark" id="delivery_rule_city" name="city_sel">
                                                    <option value="==">is equal to</option>
                                                    <option value="!=">is different from</option>
                                                    <option value="=~">Contains</option>
                                                    <option value="!~">Does not contain</option>
                                                    <option value="=x">Regex match</option>
                                                    <option value="!x">Regex does not match</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"><?php echo $GLOBALS['country']; ?> </label>
                                            </div>
                                            <div class="col-6">
                                                <select class="form-select text-dark" id="geo_country_city" name="geo_country_city">
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"><?php echo $GLOBALS['city']; ?> </label>
                                            </div>
                                            <div class="col-6">
                                                <input type="text" class="form-control text-dark" id="city" name="city">
                                            </div>
                                        </div>
                                    </div></td></tr>`);

                    var type = 'deliveryLimitations:Geo:City';
                    get_country(type, row_id);

                } else if (select_option == "deliveryLimitations:Geo:ConnectionType") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="geo-connection-type">

                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['geo_connection']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Geo:ConnectionType" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"><?php echo $GLOBALS['geo_connection']; ?></label>
                                            </div>
                                            <div class="col-6">
                                                <select id="delivery_rule_conection" name="delivery_rule" class="form-select text-dark"  >
                                                    <option value="=~">Is any of</option>
                                                    <option value="!~">Is not any of</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-2">
                                                <input type="checkbox" class="form-check-input connection_check" id="unknown" name="unknown" value="unknown"><label class="form-label">&nbsp;<?php echo $GLOBALS['unknown']; ?></label>
                                            </div>
                                            <div class="col-2">
                                                <input type="checkbox" class="form-check-input connection_check" id="broadband" name="broadband" value="cabledsl"><label class="form-label"> &nbsp;<?php echo $GLOBALS['broadband']; ?></label>
                                            </div>
                                            <div class="col-2">
                                                <input type="checkbox" class="form-check-input connection_check" id="cellular" name="cellular" value="cellular"><label class="form-label">&nbsp;<?php echo $GLOBALS['cellular']; ?></label>
                                            </div>
                                            <div class="col-2">
                                                <input type="checkbox" class="form-check-input connection_check" id="dial-up" name="dial-up" value="dialup"><label class="form-label"> &nbsp;<?php echo $GLOBALS['dail_up']; ?></label>
                                            </div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input connection_check" id="corporate" name="corporate" value="corporate"><label class="form-label"> &nbsp;<?php echo $GLOBALS['corporate']; ?></label>
                                            </div>
                                        </div>
                                    </div></td></tr>`);

                } else if (select_option == "deliveryLimitations:Geo:Continent") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="geo-continent">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['geo_continent']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Geo:Continent" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                <?php echo $GLOBALS['geo_continent']; ?> </label>
                                            </div>
                                            <div class="col-6">
                                                <select id="delivery_rule_continent" name="delivery_rule" class="form-select text-dark"  >
                                                    <option value="=~">Is any of</option>
                                                    <option value="!~">Is not any of</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-3"><input type="checkbox" class="form-check-input continent_check" id="africa" name="africa" value="AF"><label class="form-label">&nbsp; <?php echo $GLOBALS['africa']; ?></label></div>
                                            <div class="col-3"><input type="checkbox" class="form-check-input continent_check" id="antartica" name="antartica" value="AQ"><label class="form-label">&nbsp; <?php echo $GLOBALS['antartica']; ?> </label></div>
                                            <div class="col-3"><input type="checkbox" class="form-check-input continent_check" id="asia" name="asia" value="AS"><label class="form-label">&nbsp; <?php echo $GLOBALS['asia']; ?></label></div>
                                            <div class="col-3"><input type="checkbox" class="form-check-input continent_check" id="caribbian" name="caribbian" value="CA"><label class="form-label">&nbsp; <?php echo $GLOBALS['caribbian']; ?></label></div>
                                            <div class="col-3"><input type="checkbox" class="form-check-input continent_check" id="europe" name="europe" value="EU"><label class="form-label">&nbsp; <?php echo $GLOBALS['europe']; ?></label></div>
                                            <div class="col-3"><input type="checkbox" class="form-check-input continent_check" id="north_america" name="north_america" value="NA"><label class="form-label">&nbsp; <?php echo $GLOBALS['n_america']; ?> </label></div>
                                            <div class="col-3"><input type="checkbox" class="form-check-input continent_check" id="australia_oceania" name="australia_oceania" value="OC"><label class="form-label">&nbsp; <?php echo $GLOBALS['australia_oceania']; ?></label></div>
                                            <div class="col-3"><input type="checkbox" class="form-check-input continent_check" id="south_america" name="south_america" value="SA"><label class="form-label">&nbsp;<?php echo $GLOBALS['s_america']; ?></label></div>
                                        </div>
                                    </div></td></tr>`);

                } else if (select_option == "deliveryLimitations:Geo:Country") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="geo-country">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['geo_country']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Geo:Country" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                <?php echo $GLOBALS['geo_country']; ?> </label>
                                            </div>
                                            <div class="col-6">
                                                <select id="delivery_rule_country" name="delivery_rule" class="form-select text-dark"  >
                                                    <option value="=~">Is any of</option>
                                                    <option value="!~">Is not any of</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"><?php echo $GLOBALS['country']; ?> </label>
                                            </div>
                                            <div class="col-6">
                                                <select multiple class="form-select text-dark geo_country" id="geo_country${row_id}" name="geo_country">
                                                    
                                                </select>
                                            </div>
                                        </div>
                                    </div></td></tr>`);

                    $('#geo_country' + row_id).select2();
                    var type = 'deliveryLimitations:Geo:Country';
                    get_country(type, row_id);

                } else if (select_option == "deliveryLimitations:Geo:Latlong") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="Latitude/Longitude">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['geo_lat_long']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Geo:Latlong" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                <?php echo $GLOBALS['geo_lat_long']; ?> </label>
                                            </div>
                                            <div class="col-6">
                                                <select class="form-select text-dark" id="delivery_rule_latitude" name="latlong_sel">
                                                    <option value="==">is within</option>
                                                    <option value="!=">is not within</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"> </label>
                                            </div>
                                            <div class="col-2">
                                                <input type="text" name="latitude1" id="latitude1" class="form-control" placeholder="" value="0" onkeypress="return isNumber(event)"/>
                                            </div>
                                            <div class="col-2">
                                                <label class="form-label text-center"> ><?php echo $GLOBALS['latitude']; ?>< </label>
                                            </div>
                                            <div class="col-2">
                                                <input type="text" name="latitude2" id="latitude2" class="form-control" placeholder="" value="0" onkeypress="return isNumber(event)" />
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"> </label>
                                            </div>
                                            <div class="col-2">
                                                <input type="text" name="longitude1" id="longitude1" class="form-control" placeholder="" value="0" onkeypress="return isNumber(event)" />
                                            </div>
                                            <div class="col-2">
                                                <label class="form-label text-center"> ><?php echo $GLOBALS['longitude']; ?>< </label>
                                            </div>
                                            <div class="col-2">
                                                <input type="text" name="longitude2" id="longitude2" class="form-control" placeholder="" value="0" onkeypress="return isNumber(event)" />
                                            </div>
                                        </div>
                                    </div></td></tr>`);

                } else if (select_option == "deliveryLimitations:Geo:Organisation") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="geo-isp-organisation">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['geo_isp_org']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Geo:Organisation" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                <?php echo $GLOBALS['geo_isp_org']; ?></label>
                                            </div>
                                            <div class="col-6">
                                                <select class="form-select text-dark" id="delivery_rule_isp" name="org_sel">
                                                    <option value="==">is equal to</option>
                                                    <option value="!=">is different from</option>
                                                    <option value="=~">Contains</option>
                                                    <option value="!~">Does not contain</option>
                                                    <option value="=x">Regex match</option>
                                                    <option value="!x">Regex does not match</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"> </label>
                                            </div>
                                            <div class="col-6">
                                                <input type="text" name="ISP/Organisation" id="isp" class="form-control" placeholder="<?php echo $GLOBALS['enter_isp']; ?>" />
                                            </div>
                                        </div>
                                    </div></td></tr>`);

                } else if (select_option == "deliveryLimitations:Geo:Postalcode") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td> <div class="container mt-3" id="geo-us-canada-postal">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['geo_us_postal']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Geo:Postalcode" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                <?php echo $GLOBALS['geo_us_postal']; ?></label>
                                            </div>
                                            <div class="col-6">
                                                <select class="form-select text-dark" id="delivery_rule_postal" name="postal_sel">
                                                    <option value="==">is equal to</option>
                                                    <option value="!=">is different from</option>
                                                    <option value="=~">Contains</option>
                                                    <option value="!~">Does not contain</option>
                                                    <option value="=x">Regex match</option>
                                                    <option value="!x">Regex does not match</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"> </label>
                                            </div>
                                            <div class="col-6">
                                                <input type="text" name="us_canada" id="us_canada" class="form-control" placeholder="<?php echo $GLOBALS['enter_postal']; ?>" />
                                            </div>
                                        </div>
                                    </div></td></tr>`);

                } else if (select_option == "deliveryLimitations:Geo:Subdivision1") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="Geo-Level1-Subdivision">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['geo_subdiv1']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Geo:Subdivision1" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                <?php echo $GLOBALS['geo_subdiv1']; ?></label>
                                            </div>
                                            <div class="col-6">
                                                <select id="delivery_rule_level1" name="delivery_rule" class="form-select text-dark"  >
                                                    <option value="=~">Is any of</option>
                                                    <option value="!~">Is not any of</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"><?php echo $GLOBALS['country']; ?> </label>
                                            </div>
                                            <div class="col-6">
                                                <select class="form-select text-dark" id="subdiv1_country" name="subdivision1" onchange="get_subdivision1(${row_id});">
                                                    
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"><?php echo $GLOBALS['subdivions']; ?></label>
                                            </div>
                                            <div class="col-6">
                                                <select multiple class="form-select text-dark level1_subdiv" id="level1_subdiv${row_id}" name="subdiv1">
                                                    
                                                </select>
                                            </div>
                                        </div>
                                    </div></td></tr>`);

                    $('#level1_subdiv' + row_id).select2();

                    get_subdiv1_country(row_id);

                } else if (select_option == "deliveryLimitations:Geo:Subdivision2") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="Geo-Level2-Subdivision">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['geo_subdiv2']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Geo:Subdivision2" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                <?php echo $GLOBALS['geo_subdiv2']; ?></label>
                                            </div>
                                            <div class="col-6">
                                                <select id="delivery_rule_level2" name="delivery_rule" class="form-select text-dark"  >
                                                    <option value="=~">Is any of</option>
                                                    <option value="!~">Is not any of</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"><?php echo $GLOBALS['country']; ?> </label>
                                            </div>
                                            <div class="col-6">
                                                <select class="form-select text-dark" id="subdiv2_country" name="subdiv2_country" onchange="get_subdivision2(${row_id});">
                                                    
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"><?php echo $GLOBALS['subdivions']; ?></label>
                                            </div>
                                            <div class="col-6">
                                                <select multiple class="form-select text-dark level2_subdiv" id="level2_subdiv${row_id}" name="subdiv2">
                                                    
                                                </select>
                                            </div>
                                        </div>
                                    </div></td></tr>`);

                    $('#level2_subdiv' + row_id).select2();
                    get_subdiv2_country(row_id);

                } else if (select_option == "deliveryLimitations:Geo:UsMetro") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="Geo-US-Metro-Code">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['geo_us_metro']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Geo:UsMetro" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                <?php echo $GLOBALS['geo_us_metro']; ?></label>
                                            </div>
                                            <div class="col-6">
                                                <select id="delivery_rule_metro" name="delivery_rule" class="form-select text-dark"  >
                                                    <option value="=~">Is any of</option>
                                                    <option value="!~">Is not any of</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"> </label>
                                            </div>
                                            <div class="col-6">
                                               <select multiple class="form-select text-dark metro_select" id="metro_select${row_id}" name="metro_select">
                                                    
                                                </select>
                                            </div>
                                        </div>
                                    </div></td></tr>`);
                    $('#metro_select' + row_id).select2();
                    get_usmetro(row_id);
                } else if (select_option == "deliveryLimitations:Site:Channel") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="site-rule">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['site_rule']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Site:Channel" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"> <?php echo $GLOBALS['site_rule']; ?> </label>
                                            </div>
                                            <div class="col-6">
                                                <select class="form-select text-dark" id="siterule_sel" name="siterule_sel">
                                                    <option value="=~">Is any of</option>
                                                    <option value="!~">Is not any of</option>
                                                    <option value="==">Is all of</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4"></div>
                                            <div class="col-6">
                                                <textarea name="siterule" id="siterule" class="form-control" rows="10"></textarea>
                                            </div>
                                        </div>
                                    </div></td></tr>`);

                } else if (select_option == "deliveryLimitations:Site:Hostnamelist") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="site-host">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['site_host']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Site:Hostnamelist" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"> <?php echo $GLOBALS['site_host']; ?> </label>
                                            </div>
                                            <div class="col-6">
                                                <select class="form-select text-dark" id="sitehost_sel" name="sitehost_sel">
                                                    <option value="=~">Whitelist - Only deliver on these hostnames</option>
                                                    <option value="!~">Blacklist - Do not deliver on these hostnames</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <textarea name="sitehost" id="sitehost" class="form-control" rows="14"></textarea>
                                            </div>
                                            <div class="col-6">
                                                <label class="form-label"><?php echo $GLOBALS['enter_host']; ?></label>
                                                <textarea name="sitehost1" id="sitehost1" class="form-control" rows="6"></textarea><br>
                                                <button class="btn btn-primary text-white" id="removehostname" onclick=""><?php echo $GLOBALS['remove_host']; ?></button>
                                            </div>
                                        </div>
                                    </div></td></tr>`);

                } else if (select_option == "deliveryLimitations:Site:Pageurl") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="Site-Page-url">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['site_page_url']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Site:Pageurl" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                <?php echo $GLOBALS['site_page_url']; ?> </label>
                                            </div>
                                            <div class="col-6">
                                                <select class="form-select text-dark" id="sitepageurl_sel" name="sitepageurl_sel">
                                                    <option value="==">is equal to</option>
                                                    <option value="!=">is different from</option>
                                                    <option value="=~">Contains</option>
                                                    <option value="!~">Does not contain</option>
                                                    <option value="=x">Regex match</option>
                                                    <option value="!x">Regex does not match</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"> </label>
                                            </div>
                                            <div class="col-6">
                                                <input type="text" name="site_page" id="site_page" class="form-control" placeholder="<?php echo $GLOBALS['enter_url']; ?>" />
                                            </div>
                                        </div>
                                    </div></td></tr>`);

                } else if (select_option == "deliveryLimitations:Site:Referingpage") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="Site-Referring-Page">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['site_refer']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Site:Referingpage" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                <?php echo $GLOBALS['site_refer']; ?> </label>
                                            </div>
                                            <div class="col-6">
                                                <select class="form-select text-dark" id="siterefpage_sel" name="siterefpage_sel">
                                                     <option value="==">is equal to</option>
                                                    <option value="!=">is different from</option>
                                                    <option value="=~">Contains</option>
                                                    <option value="!~">Does not contain</option>
                                                    <option value="=x">Regex match</option>
                                                    <option value="!x">Regex does not match</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"> </label>
                                            </div>
                                            <div class="col-6">
                                                <input type="text" name="site_referring" id="site_referring" class="form-control" placeholder="<?php echo $GLOBALS['enter_refer']; ?>" />
                                            </div>
                                        </div>
                                    </div></td></tr>`);

                } else if (select_option == "deliveryLimitations:Site:Registerabledomainlist") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="Registerable-Domain">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['site_domain_list']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Site:Registerabledomainlist" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                <?php echo $GLOBALS['site_domain_list']; ?> </label>
                                            </div>
                                            <div class="col-6">
                                                <select class="form-select text-dark" id="regdomain_sel" name="regdomain_sel">
                                                    <option value="=x">Whitelist - Only deliver on these registerable domains</option>
                                                    <option value="!x">Blacklist - Do not deliver on these registerable domains</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <textarea rows="10" name="whitelist" id="whitelist" class="form-control" placeholder="" /> </textarea>
                                            </div>
                                            <div class="col-6">
                                                <textarea rows="4" name="blacklist" id="blacklist" class="form-control" placeholder="" /> </textarea>
                                            </div>
                                        </div>
                                    </div></td></tr>`);

                } else if (select_option == "deliveryLimitations:Site:Source") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="Site-Source">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['site_source']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Site:Source" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                <?php echo $GLOBALS['site_source']; ?></label>
                                            </div>
                                            <div class="col-6">
                                                <select class="form-select text-dark" id="sitesource_sel" name="sitesource_sel">
                                                     <option value="==">is equal to</option>
                                                    <option value="!=">is different from</option>
                                                    <option value="=~">Contains</option>
                                                    <option value="!~">Does not contain</option>
                                                    <option value="=x">Regex match</option>
                                                    <option value="!x">Regex does not match</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"> </label>
                                            </div>
                                            <div class="col-6">
                                                <input type="text" name="site_source" id="site_source" class="form-control" placeholder="<?php echo $GLOBALS['enter_source']; ?>" />
                                            </div>
                                        </div>
                                    </div></td></tr>`);

                } else if (select_option == "deliveryLimitations:Site:Variable") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="Site-Variable">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['site_variable']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Site:Variable" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                <?php echo $GLOBALS['site_variable']; ?> </label>
                                            </div>
                                            <div class="col-6">

                                                <select class="form-select text-dark" id="sitevariable_sel" name="sitevariable_sel">
                                                    <option value="==">is equal to</option>
                                                    <option value="!=">is different from</option>
                                                    <option value="=~">Contains</option>
                                                    <option value="!~">Does not contain</option>
                                                    <option value="=x">Regex match</option>
                                                    <option value="!x">Regex does not match</option>
                                                    <option value="lt">is less than</option>
                                                    <option value="gt">is greater than</option>
                                                    <option value="le">is less or equal to</option>
                                                    <option value="ge">is greater or equal to</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"><?php echo $GLOBALS['strName']; ?></label>
                                            </div>
                                            <div class="col-6">
                                                <input type="text" name="site_variable" id="site_variable" class="form-control" placeholder="<?php echo $GLOBALS['enter_name']; ?>" />
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"><?php echo $GLOBALS['variable']; ?></label>
                                            </div>
                                            <div class="col-6">
                                                <input type="text" name="site_variable1" id="site_variable1" class="form-control" placeholder="<?php echo $GLOBALS['enter_variable']; ?>" />
                                            </div>
                                        </div>
                                    </div></td></tr>`);

                } else if (select_option == "deliveryLimitations:Time:Date") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="time-date">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['time_date']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Time:Date" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"> <?php echo $GLOBALS['time_date']; ?> </label>
                                            </div>
                                            <div class="col-6">
                                                <select class="form-select text-dark" id="timedate_sel" name="timedate_sel">
                                                    <option value="==">Is equal to</option>
                                                    <option value="!=">Is different from</option>
                                                    <option value=">">is later than</option>
                                                    <option value=">=">is later than or equal to</option>
                                                    <option value="<">is earlier than</option>
                                                    <option value="<=">is earlier than or equal to</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4"></div>
                                            <div class="col-6">
                                                <input type="date" name="timedate" id="timedate" class="form-control" placeholder="DD-MM-YYYY" />
                                            </div>
                                        </div>
                                    </div></td></tr>`);

                } else if (select_option == "deliveryLimitations:Time:Day") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="time-day">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['time_week']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Time:Day" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"><?php echo $GLOBALS['time_week']; ?></label>
                                            </div>
                                            <div class="col-6">
                                                <select id="delivery_rule_tday" name="delivery_rule_tday" class="form-select text-dark" onchange="">
                                                    <option value="=~">Is any of</option>
                                                    <option value="!~">Is not any of</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-3"><input type="checkbox" class="form-check-input time_day" id="sunday" name="sunday" value="0"><label class="form-label">&nbsp;<?php echo $GLOBALS['sunday']; ?></label></div>
                                            <div class="col-3"><input type="checkbox" class="form-check-input time_day" id="monday" name="monday" value="1"><label class="form-label">&nbsp;<?php echo $GLOBALS['monday']; ?></label></div>
                                            <div class="col-3"><input type="checkbox" class="form-check-input time_day" id="tuesday" name="tuesday" value="2"><label class="form-label">&nbsp;<?php echo $GLOBALS['tuesday']; ?></label></div>
                                            <div class="col-3"><input type="checkbox" class="form-check-input time_day" id="wednesday" name="wednesday" value="3"><label class="form-label">&nbsp;<?php echo $GLOBALS['wednesday']; ?></label></div>
                                            <div class="col-3"><input type="checkbox" class="form-check-input time_day" id="thursday" name="thursday" value="4"><label class="form-label">&nbsp;<?php echo $GLOBALS['thursday']; ?></label></div>
                                            <div class="col-3"><input type="checkbox" class="form-check-input time_day" id="friday" name="friday" value="5"><label class="form-label">&nbsp;<?php echo $GLOBALS['friday']; ?></label></div>
                                            <div class="col-3"><input type="checkbox" class="form-check-input time_day" id="saturday" name="saturday" value="6"><label class="form-label">&nbsp;<?php echo $GLOBALS['saturday']; ?></label></div>
                                        </div>
                                    </div></td></tr>`);

                } else if (select_option == "deliveryLimitations:Time:Hour") {
                    $('#delivery_table').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="time-hour">
                                        <div class="row mb-3">
                                            <div class="col-7">
                                                <p class="h4 text-primary"><?php echo $GLOBALS['time_hour']; ?></p>
                                                <p class="h6 text-secondary"><?php echo $GLOBALS['only_display']; ?></p>
                                            </div>
                                            <div class="col-2 justify-content-end">
                                                <select id="condition" name="condition" class="form-select text-primary" >
                                                    <option value="and">AND</option>
                                                    <option value="or">OR</option>
                                                </select>
                                            </div>
                                            <div class="col-3 justify-content-end">
                                                <button class="btn rounded-pill btn-icon text-primary remove" style="position:relative;left:10%" value="deliveryLimitations:Time:Hour" ><i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;"> <?php echo $GLOBALS['time_hour']; ?> </label>
                                            </div>
                                            <div class="col-6">
                                                <select id="delivery_rule_thour" name="delivery_rule_thour" class="form-select text-dark" onchange="">
                                                    <option value="=~">Is any of</option>
                                                    <option value="!~">Is not any of</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-2"><input type="checkbox" class="form-check-input  time_hour" id="hour0" name="hour0" value="0"><label class="form-label">&nbsp;00.00 - 00.59</label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input  time_hour" id="hour1" name="hour1" value="1"><label class="form-label">&nbsp;01.00 - 01.59</label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input  time_hour" id="hour2" name="hour2" value="2"><label class="form-label">&nbsp;02.00 - 02.59</label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input  time_hour" id="hour3" name="hour3" value="3"><label class="form-label">&nbsp;03.00 - 03.59</label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input  time_hour" id="hour4" name="hour4" value="4"><label class="form-label">&nbsp;04.00 - 04.59</label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input  time_hour" id="hour5" name="hour5" value="5"><label class="form-label">&nbsp;05.00 - 05.59</label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input  time_hour" id="hour6" name="hour6" value="6"><label class="form-label">&nbsp;06.00 - 06.59</label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input  time_hour" id="hour7" name="hour7" value="7"><label class="form-label">&nbsp;07.00 - 07.59</label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input  time_hour" id="hour8" name="hour8" value="8"><label class="form-label">&nbsp;08.00 - 08.59</label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input  time_hour" id="hour9" name="hour9" value="9"><label class="form-label">&nbsp;09.00 - 09.59</label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input  time_hour" id="hour10" name="hour10" value="10"><label class="form-label">&nbsp;10.00 - 10.59</label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input  time_hour" id="hour11" name="hour11" value="11"><label class="form-label">&nbsp;11.00 - 11.59</label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input  time_hour" id="hour12" name="hour12" value="12"><label class="form-label">&nbsp;12.00 - 12.59</label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input  time_hour" id="hour13" name="hour13" value="13"><label class="form-label">&nbsp;13.00 - 13.59</label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input  time_hour" id="hour14" name="hour14" value="14"><label class="form-label">&nbsp;14.00 - 14.59</label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input  time_hour" id="hour15" name="hour15" value="15"><label class="form-label">&nbsp;15.00 - 15.59</label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input  time_hour" id="hour16" name="hour16" value="16"><label class="form-label">&nbsp;16.00 - 16.59</label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input  time_hour" id="hour17" name="hour17" value="17"><label class="form-label">&nbsp;17.00 - 17.59</label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input  time_hour" id="hour18" name="hour18" value="18"><label class="form-label">&nbsp;18.00 - 18.59</label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input  time_hour" id="hour19" name="hour19" value="19"><label class="form-label">&nbsp;19.00 - 19.59</label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input  time_hour" id="hour20" name="hour20" value="20"><label class="form-label">&nbsp;20.00 - 20.59</label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input  time_hour" id="hour21" name="hour21" value="21"><label class="form-label">&nbsp;21.00 - 21.59</label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input  time_hour" id="hour22" name="hour22" value="22"><label class="form-label">&nbsp;22.00 - 22.59</label></div>
                                            <div class="col-2"><input type="checkbox" class="form-check-input  time_hour" id="hour23" name="hour23" value="23"><label class="form-label">&nbsp;23.00 - 23.59</label></div>
                                        </div>
                                    </div></td></tr>`);

                }
            }
            remove_condition();
        });

        //Remove rule
        function remove_condition() {
            $('#delivery_table tr:first #condition').hide();
        }

        //get_country_api and country_edit
        function get_country(type, id, country_code) {
            $.ajax({
                type: "GET",
                url: live_URL + '/get_all_country/',
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function(data) {
                var country = [];
                data.data.map((data) => {
                    country += `<option value=${data.country_code}>${data.country_name}</option>`;
                });
                if (!country_code) {
                    if (type == 'deliveryLimitations:Geo:City') {
                        $('tr#R' + id + ' #geo_country_city').html(country);
                    } else if (type == 'deliveryLimitations:Geo:Country') {
                        $('tr#R' + id + ' .geo_country').html(country);
                    }
                } else {
                    if (type == 'deliveryLimitations:Geo:City') {
                        $('tr#R' + id + ' #geo_country_city').val(country_code);
                    } else if (type == 'deliveryLimitations:Geo:Country') {
                        countries = country_code.split(',');
                        $('tr#R' + id + ' .geo_country').val(countries).change();
                        $(function() {
                            //Initialize Select2 Elements
                            $('tr#R' + id + ' #geo_country' + id).select2();
                        })
                    }
                }
            });
        }

        //get subdiv1 country_api and country_edit
        function get_subdiv1_country(id, country_code, state) {
            $.ajax({
                type: "GET",
                url: live_URL + '/get_subdiv1_country/',
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function(data) {
                var subdiv1_country = [];
                data.data.map((data) => {
                    subdiv1_country += `<option value=${data.country_code}>${data.country_name}</option>`;
                });
                if (!country_code) {
                    $('tr#R' + id + ' #subdiv1_country').html(subdiv1_country);
                    get_subdivision1(id);

                } else {
                    $('tr#R' + id + ' #subdiv1_country').val(country_code);
                    get_subdivision1(id, state);
                }
            });
        }

        function get_subdiv2_country(id, country_code, state) {
            $.ajax({
                type: "GET",
                url: live_URL + '/get_subdiv2_country/',
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function(data) {
                var subdiv2_country = [];
                data.data.map((data) => {
                    subdiv2_country += `<option value=${data.country_code}>${data.country_name}</option>`;
                });
                if (!country_code) {
                    $('tr#R' + id + ' #subdiv2_country').html(subdiv2_country);
                    get_subdivision2(id);

                } else {
                    $('tr#R' + id + ' #subdiv2_country').val(country_code);
                    get_subdivision2(id, state);
                }
            });
        }



        //get subdivision1
        function get_subdivision1(id, state) {
            var country_code = $('tr#R' + id + ' #subdiv1_country option:selected').val();
            $.ajax({
                type: "GET",
                url: live_URL + '/get_all_subdivition1/' + country_code,
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function(data) {
                var subdivisions = [];
                data.data.map((data) => {
                    subdivisions += `<option value=${data.state_code}>${data.state_name}</option>`;
                });
                $('tr#R' + id + ' .level1_subdiv').html(subdivisions);
                $('tr#R' + id + ' #level1_subdiv' + id).select2();
                if (state) {
                    selected_states = state.split(',');
                    $('tr#R' + id + ' .level1_subdiv').val(selected_states).change();
                    $('tr#R' + id + ' #level1_subdiv' + id).select2();
                }
            });
        }

        //get subdivision2
        function get_subdivision2(id, state) {
            var country_code = $('tr#R' + id + ' #subdiv2_country option:selected').val();
            $.ajax({
                type: "GET",
                url: live_URL + '/get_all_subdivition2/' + country_code,
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function(data) {
                var subdivisions = [];
                data.data.map((data) => {
                    subdivisions += `<option value=${data.state_code}>${data.state_name}</option>`;
                });
                $('tr#R' + id + ' .level2_subdiv').html(subdivisions);
                $('tr#R' + id + ' #level2_subdiv' + id).select2();
                if (state) {
                    selected_states = state.split(',');
                    $('tr#R' + id + ' .level2_subdiv').val(selected_states).change();
                    $('tr#R' + id + ' #level2_subdiv' + id).select2();

                }
            });
        }

        //get usmetro and us_metro edit
        function get_usmetro(id, usmetro_code) {
            $.ajax({
                type: "GET",
                url: live_URL + '/get_all_usmetro/',
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function(data) {
                var us_metro = [];
                data.data.map((data) => {
                    us_metro += `<option value=${data.usmetro_code}>${data.usmetro_name}</option>`;
                });
                if (!usmetro_code) {
                    $('tr#R' + id + ' .metro_select').html(us_metro);
                } else {
                    metro = usmetro_code.split(',');
                    $('tr#R' + id + ' .metro_select').val(metro).change();
                    $('tr#R' + id + ' #metro_select' + id).select2();
                }
            });
        }

        // jQuery button click event to remove a row.
        $('#delivery_table').on('click', '.remove', function() {
            var child = $(this).closest('tr').nextAll();
            child.each(function() {
                var id = $(this).attr('id');
                var dig = parseInt(id.substring(1));
                $(this).attr('id', `R${dig - 1}`);
            });
            $(this).closest('tr').remove();
            row_id--;
            remove_condition();
        });

        //Hide Browser Version
        function delivery_rule_cbv(value, id) {
            if (value == "nn") {
                $('tr#R' + id + ' #browser_version').val('');
                $('tr#R' + id + ' #brow_ver').hide();
            } else {
                $('tr#R' + id + ' #brow_ver').show();
            }
        }

        //Hide OS Version
        function delivery_rule_cosv(value, id) {
            if (value == "nn") {
                $('tr#R' + id + ' #os_version').val('');
                $('tr#R' + id + ' #os_ver').hide();
            } else {
                $('tr#R' + id + ' #os_ver').show();
            }
        }

        //Update Delivery options
        function savechanges() {
            var rows = $('#delivery_table tbody tr').length;
            var params = [];
            var formData = [];
            var check_val = [];
            var error = false;
            var customid = $('#customid').val();
            var advertiserid = $('#advertiserid').val();
            var line_item_name = $('#line_item_name').val();
            var currency = $('#currency').val();
            var paymenttype = $('#paymenttype').val();
            var creativerotation = $('#creativerotation').val();
            var adtype = $('#adtype').val();
            var devicetypes = $('#devicetypes').val();
            var revenuetype = $('#revenuetype').val();
            var maxcpm = $('#maxcpm').val();
            var mincpm = $('#mincpm').val();
            var goaltarget = $('#goaltarget').val();
            var goalthreshold = $('#goalthreshold').val();
            var lifetimebudget = $('#lifetimebudget').val();
            var postgoaltarget = $('#postgoaltarget').val();
            var postgoalthreshold = $('#postgoalthreshold').val();
            var pacing_percent = $('#pacing_percent').val();
            var deal_list = $('#deal_list').val();
            var api_description = $('#api_description').val();
            var countryid = $('#countryid').val();
            var regionid = $('#regionid').val();
            var citiesid = $('#citiesid').val();

            if (customid != '' && advertiserid != '') {
                advertiserid      = (advertiserid != '') ? advertiserid : '';
                customid      = (customid != '') ? customid : '';
                currency      = (currency != '') ? currency : 'CHF';
                paymenttype      = (paymenttype != '') ? paymenttype : 'impression';
                creativerotation      = (creativerotation != '') ? creativerotation : 'ctr-optimized';
                adtype      = (adtype != '') ? adtype : 'banner';
                devicetypes      = (devicetypes != '') ? devicetypes : 'pc,phone,tablet';
                revenuetype      = (revenuetype != '') ? revenuetype : 'cost_plus_margin';
                maxcpm      = (maxcpm != '') ? maxcpm : '4';
                mincpm      = (mincpm != '') ? mincpm : '1';
                goaltarget      = (goaltarget != '') ? goaltarget : '0';
                goalthreshold      = (goalthreshold != '') ? goalthreshold : '1';
                lifetimebudget      = (lifetimebudget != '') ? lifetimebudget : '12';
                postgoaltarget      = (postgoaltarget != '') ? postgoaltarget : '0';
                postgoalthreshold      = (postgoalthreshold != '') ? postgoalthreshold : '1';
                pacing_percent      = (pacing_percent != '') ? pacing_percent : '100';
                deal_list      = (deal_list != '') ? deal_list : '6691';
                api_description      = (api_description != '') ? api_description : '';
                countryid      = (countryid != '') ? countryid : '46';
                regionid      = (regionid != '') ? regionid : '';
                citiesid      = (citiesid != '') ? citiesid : '';
                
            }
            var formData1;
            formData1 = {
                    "bannerid": bannerid,
                    "customid": customid,
                    "advertiserid": advertiserid,
                    "line_item_name": line_item_name,
                    "currency": currency,
                    "paymenttype": paymenttype,
                    "creativerotation":creativerotation,
                    "adtype":adtype,
                    "devicetypes":devicetypes,
                    "revenuetype": revenuetype,
                    "maxcpm": maxcpm,
                    "mincpm": mincpm,
                    "goaltarget": goaltarget,
                    "goalthreshold": goalthreshold,
                    "lifetimebudget": lifetimebudget,
                    "postgoaltarget": postgoaltarget,
                    "postgoalthreshold": postgoalthreshold,
                    "pacing_percent": pacing_percent,
                    "deal_list": deal_list,
                    "api_description": api_description,
                    "countryid": countryid,
                    "regionid": regionid,
                    "citiesid": citiesid
                };
               console.log('rows-------'+rows);
            for (var i = 0; i < rows; i++) {
                var j = i + 1;
                var rule_id = $('#delivery_table tr#R' + j + ' div:first').attr('id');
                if (rule_id == 'time-date1') {
                    var condition ="and";
                    var option = $('tr#R' + j + ' #timedate_sel option:selected').val();
                    var data = $('tr#R' + j + ' #timedate1').val();
                    //params[i] = rule_id + ',' + condition + ',' + option + ',' + option1;
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Time:Date",
                        "comparison": option,
                        "data": data
                    };
                }
               else if (rule_id == 'time-date2') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #timedate_sel option:selected').val();
                    var data = $('tr#R' + j + ' #timedate2').val();
                    //params[i] = rule_id + ',' + condition + ',' + option + ',' + option1;
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Time:Date",
                        "comparison": option,
                        "data": data
                    };
                }
               else if (rule_id == 'client-browser') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #delivery_rule_cb option:selected').val();
                    $('tr#R' + j + ' .browser_check:checked').each(function() {
                        check_val += this.value + ',';
                    });
                    if (check_val == '') {
                        $('tr#R' + j + ' #client-browser').css("background-color", "#f8d7da");
                        error = true;
                    } else {
                        $('tr#R' + j + ' #client-browser').css("background-color", "");
                    }
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Client:Browser",
                        "comparison": option,
                        "data": check_val
                    };
                    check_val = [];


                } else if (rule_id == 'client-browser-ver') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #delivery_rule_cbv option:selected').val();
                    var data = $('tr#R' + j + ' #browser_select option:selected').val();
                    var version = $('tr#R' + j + ' #browser_version').val();
                    if (option != 'nn' && version == '') {
                        $('tr#R' + j + ' #client-browser-ver').css("background-color", "#f8d7da");
                        error = true;
                    } else {
                        $('tr#R' + j + ' #client-browser-ver').css("background-color", "");
                    }
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Client:BrowserVersion",
                        "comparison": option,
                        "data": data + '|' + version
                    };

                } else if (rule_id == 'client-domain') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #domain_sel option:selected').val();
                    var data = $('tr#R' + j + ' #domain').val();
                    if (data == '') {
                        $('tr#R' + j + ' #client-domain').css("background-color", "#f8d7da");
                        error = true;
                    } else {
                        $('tr#R' + j + ' #client-domain').css("background-color", "");
                    }
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Client:Domain",
                        "comparison": option,
                        "data": data
                    };

                } else if (rule_id == 'client-ip') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #ip_sel option:selected').val();
                    var data = $('tr#R' + j + ' #ipaddress').val();
                    if (data == '') {
                        $('tr#R' + j + ' #client-ip').css("background-color", "#f8d7da");
                        error = true;
                    } else {
                        $('tr#R' + j + ' #client-ip').css("background-color", "");
                    }
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Client:Ip",
                        "comparison": option,
                        "data": data
                    };

                } else if (rule_id == 'client-lang') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #lang_sel option:selected').val();
                    var data = $('tr#R' + j + ' .language_select').val();
                    if (data == '') {
                        $('tr#R' + j + ' #client-lang').css("background-color", "#f8d7da");
                        error = true;
                    } else {
                        $('tr#R' + j + ' #client-lang').css("background-color", "");
                    }
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Client:Language",
                        "comparison": option,
                        "data": data + ''
                    };

                } else if (rule_id == 'client-os') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #delivery_rule_cos option:selected').val();
                    $('tr#R' + j + ' .os_check:checked').each(function() {
                        check_val += this.value + ',';
                    });
                    if (check_val.length == 0) {
                        $('tr#R' + j + ' #client-os').css("background-color", "#f8d7da");
                        error = true;
                    } else {
                        $('tr#R' + j + ' #client-os').css("background-color", "");
                    }
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Client:Os",
                        "comparison": option,
                        "data": check_val
                    };
                    check_val = [];

                } else if (rule_id == 'client-os-ver') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #delivery_rule_cosv option:selected').val();
                    var data = $('tr#R' + j + ' #os_select option:selected').val();
                    var version = $('tr#R' + j + ' #os_version').val();
                    if (option != 'nn' && version == '') {
                        $('tr#R' + j + ' #client-os-ver').css("background-color", "#f8d7da");
                        error = true;
                    } else {
                        $('tr#R' + j + ' #client-os-ver').css("background-color", "");
                    }
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Client:OsVersion",
                        "comparison": option,
                        "data": data + '|' + version
                    };

                } else if (rule_id == 'client-useragent') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #useragent_sel option:selected').val();
                    var data = $('tr#R' + j + ' #useragent').val();
                    if (data == '') {
                        $('tr#R' + j + ' #client-useragent').css("background-color", "#f8d7da");
                        error = true;
                    } else {
                        $('tr#R' + j + ' #client-useragent').css("background-color", "");
                    }
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Client:Useragent",
                        "comparison": option,
                        "data": data
                    };

                } else if (rule_id == 'geo-city') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #delivery_rule_city option:selected').val();
                    var data = $('tr#R' + j + ' #geo_country_city option:selected').val();
                    var city = $('tr#R' + j + ' #city').val();
                    if (city == '') {
                        $('tr#R' + j + ' #geo-city').css("background-color", "#f8d7da");
                        error = true;
                    } else {
                        $('tr#R' + j + ' #geo-city').css("background-color", "");
                    }
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Geo:City",
                        "comparison": option,
                        "data": data + '|' + city
                    };

                } else if (rule_id == 'geo-connection-type') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #delivery_rule_conection option:selected').val();
                    $('tr#R' + j + ' .connection_check:checked').each(function() {
                        check_val += this.value + ',';
                    });
                    if (check_val.length == 0) {
                        $('tr#R' + j + ' #geo-connection-type').css("background-color", "#f8d7da");
                        error = true;
                    } else {
                        $('tr#R' + j + ' #geo-connection-type').css("background-color", "");
                    }
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Geo:ConnectionType",
                        "comparison": option,
                        "data": check_val
                    };
                    check_val = [];

                } else if (rule_id == 'geo-continent') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #delivery_rule_continent option:selected').val();
                    $('tr#R' + j + ' .continent_check:checked').each(function() {
                        check_val += this.value + ',';
                    });
                    if (check_val.length == 0) {
                        $('tr#R' + j + ' #geo-continent').css("background-color", "#f8d7da");
                        error = true;
                    } else {
                        $('tr#R' + j + ' #geo-continent').css("background-color", "");
                    }
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Geo:Continent",
                        "comparison": option,
                        "data": check_val
                    };
                    check_val = [];

                } else if (rule_id == 'geo-country') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #delivery_rule_country option:selected').val();
                    var data = $('tr#R' + j + ' .geo_country').val();
                    if (data == '') {
                        $('tr#R' + j + ' #geo-country').css("background-color", "#f8d7da");
                        error = true;
                    } else {
                        $('tr#R' + j + ' #geo-country').css("background-color", "");
                    }
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Geo:Country",
                        "comparison": option,
                        "data": data + ''
                    };

                } else if (rule_id == 'Latitude/Longitude') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #delivery_rule_latitude option:selected').val();
                    var min_lat = $('tr#R' + j + ' #latitude1').val();
                    var max_lat = $('tr#R' + j + ' #latitude2').val();
                    var min_long = $('tr#R' + j + ' #longitude1').val();
                    var max_long = $('tr#R' + j + ' #longitude2').val();
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Geo:Latlong",
                        "comparison": option,
                        "data": min_lat + ',' + max_lat + ',' + min_long + ',' + max_long
                    };

                } else if (rule_id == 'geo-isp-organisation') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #delivery_rule_isp option:selected').val();
                    var data = $('tr#R' + j + ' #isp').val();
                    if (data == '') {
                        $('tr#R' + j + ' #geo-isp-organisation').css("background-color", "#f8d7da");
                        error = true;
                    } else {
                        $('tr#R' + j + ' #geo-isp-organisation').css("background-color", "");
                    }
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Geo:Organisation",
                        "comparison": option,
                        "data": data
                    };

                } else if (rule_id == 'geo-us-canada-postal') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #delivery_rule_postal option:selected').val();
                    var data = $('tr#R' + j + ' #us_canada').val();
                    if (data == '') {
                        $('tr#R' + j + ' #geo-us-canada-postal').css("background-color", "#f8d7da");
                        error = true;
                    } else {
                        $('tr#R' + j + ' #geo-us-canada-postal').css("background-color", "");
                    }
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Geo:Postalcode",
                        "comparison": option,
                        "data": data
                    };

                } else if (rule_id == 'Geo-Level1-Subdivision') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #delivery_rule_level1 option:selected').val();
                    var country = $('tr#R' + j + ' #subdiv1_country').val();
                    var data = $('tr#R' + j + ' .level1_subdiv').val();
                    if (data == '') {
                        $('tr#R' + j + ' #Geo-Level1-Subdivision').css("background-color", "#f8d7da");
                        error = true;
                    } else {
                        $('tr#R' + j + ' #Geo-Level1-Subdivision').css("background-color", "");
                    }
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Geo:Subdivision1",
                        "comparison": option,
                        "data": country + '|' + data
                    };

                } else if (rule_id == 'Geo-Level2-Subdivision') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #delivery_rule_level2 option:selected').val();
                    var country = $('tr#R' + j + ' #subdiv2_country').val();
                    var data = $('tr#R' + j + ' .level2_subdiv').val();
                    if (data == '') {
                        $('tr#R' + j + ' #Geo-Level2-Subdivision').css("background-color", "#f8d7da");
                        error = true;
                    } else {
                        $('tr#R' + j + ' #Geo-Level2-Subdivision').css("background-color", "");
                    }
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Geo:Subdivision2",
                        "comparison": option,
                        "data": country + '|' + data
                    };

                } else if (rule_id == 'Geo-US-Metro-Code') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #delivery_rule_metro option:selected').val();
                    var data = $('tr#R' + j + ' .metro_select').val();
                    if (data == '') {
                        $('tr#R' + j + ' #Geo-US-Metro-Code').css("background-color", "#f8d7da");
                        error = true;
                    } else {
                        $('tr#R' + j + ' #Geo-US-Metro-Code').css("background-color", "");
                    }
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Geo:UsMetro",
                        "comparison": option,
                        "data": data + ''
                    };

                } else if (rule_id == 'site-rule') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #siterule_sel option:selected').val();
                    var data = $('tr#R' + j + ' #siterule').val();
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Site:Channel",
                        "comparison": option,
                        "data": data
                    };

                } else if (rule_id == 'site-host') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #sitehost_sel option:selected').val();
                    var data = $('tr#R' + j + ' #sitehost').val();
                    var host = $('tr#R' + j + ' #sitehost1').val();
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Site:Hostnamelist",
                        "comparison": option,
                        "data": data,
                        "host": host
                    };

                } else if (rule_id == 'Site-Page-url') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #sitepageurl_sel option:selected').val();
                    var data = $('tr#R' + j + ' #site_page').val();
                    if (data == '') {
                        $('tr#R' + j + ' #Site-Page-url').css("background-color", "#f8d7da");
                        error = true;
                    } else {
                        $('tr#R' + j + ' #Site-Page-url').css("background-color", "");
                    }
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Site:Pageurl",
                        "comparison": option,
                        "data": data
                    };

                } else if (rule_id == 'Site-Referring-Page') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #siterefpage_sel option:selected').val();
                    var data = $('tr#R' + j + ' #site_referring').val();
                    if (data == '') {
                        $('tr#R' + j + ' #Site-Referring-Page').css("background-color", "#f8d7da");
                        error = true;
                    } else {
                        $('tr#R' + j + ' #Site-Referring-Page').css("background-color", "");
                    }
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Site:Referingpage",
                        "comparison": option,
                        "data": data
                    };

                } else if (rule_id == 'Registerable-Domain') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #regdomain_sel option:selected').val();
                    var data = $('tr#R' + j + ' #whitelist').val();
                    var blacklist = $('tr#R' + j + ' #blacklist').val();
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Site:Registerabledomainlist",
                        "comparison": option,
                        "data": data,
                        "blacklist": blacklist
                    };

                } else if (rule_id == 'Site-Source') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #sitesource_sel option:selected').val();
                    var data = $('tr#R' + j + ' #site_source').val();
                    if (data == '') {
                        $('tr#R' + j + ' #Site-Source').css("background-color", "#f8d7da");
                        error = true;
                    } else {
                        $('tr#R' + j + ' #Site-Source').css("background-color", "");
                    }
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Site:Source",
                        "comparison": option,
                        "data": data
                    };

                } else if (rule_id == 'Site-Variable') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #sitevariable_sel option:selected').val();
                    var data = $('tr#R' + j + ' #site_variable').val();
                    var site = $('tr#R' + j + ' #site_variable1').val();
                    if (data == '' || site == '') {
                        $('tr#R' + j + ' #Site-Variable').css("background-color", "#f8d7da");
                        error = true;
                    } else {
                        $('tr#R' + j + ' #Site-Variable').css("background-color", "");
                    }
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Site:Variable",
                        "comparison": option,
                        "data": data + '|' + site
                    };

                } else if (rule_id == 'time-date') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #timedate_sel option:selected').val();
                    var data = $('tr#R' + j + ' #timedate').val();
                    if (data == '') {
                        $('tr#R' + j + ' #time-date').css("background-color", "#f8d7da");
                        error = true;
                    } else {
                        $('tr#R' + j + ' #time-date').css("background-color", "");
                    }
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Time:Date",
                        "comparison": option,
                        "data": data
                    };

                } else if (rule_id == 'time-day') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #delivery_rule_tday option:selected').val();
                    $('tr#R' + j + ' .time_day:checked').each(function() {

                        check_val += this.value + ',';
                    });
                    if (check_val.length == 0) {
                        $('tr#R' + j + ' #time-day').css("background-color", "#f8d7da");
                        error = true;
                    } else {
                        $('tr#R' + j + ' #time-day').css("background-color", "");
                    }
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Time:Day",
                        "comparison": option,
                        "data": check_val
                    };
                    check_val = [];

                } else if (rule_id == 'time-hour') {
                    var condition = $('tr#R' + j + ' #condition option:selected').val();
                    var option = $('tr#R' + j + ' #delivery_rule_thour option:selected').val();
                    $('tr#R' + j + ' .time_hour:checked').each(function() {
                        check_val += this.value + ',';
                    });
                    if (check_val.length == 0) {
                        $('tr#R' + j + ' #time-hour').css("background-color", "#f8d7da");
                        error = true;
                    } else {
                        $('tr#R' + j + ' #time-hour').css("background-color", "");
                    }
                    formData[i] = {
                        "logical": condition,
                        "type": "deliveryLimitations:Time:Hour",
                        "comparison": option,
                        "data": check_val
                    };
                    check_val = [];

                }

            }
            if (error == true) {
                $('#rule_error').show();
                $('#rule_error').html('<?php echo $GLOBALS['strcheckinput_Parameters']; ?>');
                return false;
            }
            error = false;
            var result = {
                "data": formData
            };
            $.ajax({
                type: "POST",
                url: live_URL + '/set_limitation/' + bannerid,
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: result,
                dataType: "json",
                encode: true,
            }).done(function(data) {
                console.log("res:", data);
                swal({
                        title: data.msg,
                        type: "success"
                    })
                    .then(data => {
                        location.reload();
                    });
            });
            $.ajax({
                    type: "POST",
                    url: live_URL+"/set_limitation_delivary_option/"+bannerid,
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: formData1,
                    dataType: "json",
                    encode: true,
                }).done(function (data) {

                    console.log("clientid:",clientid)
                    console.log(data);
                        
                    swal({
                        title: data.msg,
                        type: "success"
                    })
                    .then(data => {
                        location.reload();
                    }); 
                            
                });
        }

        //Chech Number Input
        function isNumber(evt) {
            evt = (evt) ? evt : window.event;
            var charCode = (evt.which) ? evt.which : evt.keyCode;
            if (charCode > 31 && (charCode < 48 || charCode > 57)) {
                return false;
            }
            return true;
        }

        //Add Capping
        function addcapping() {
            var capping = $('#limit_views').val();
            var session_capping = $('#limit_views_session').val();
            var hours = $('#hour').val();
            var minutes = $('#minutes').val();
            var seconds = $('#seconds').val();
            if ((capping != '' && session_capping != '' && hours != '' && minutes != '' && seconds != '')) {
                var block = (hours * 3600 + minutes * 60 + seconds * 1);
                var values = {
                    "block": "" + block + "",
                    "capping": "" + capping + "",
                    "session_capping": "" + session_capping + "",
                }
                $.ajax({
                    type: "POST",
                    url: live_URL + '/set_capping/' + bannerid,
                    beforeSend: function(xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: values,
                    dataType: "json",
                    encode: true,
                }).done(function(data) {
                    console.log("res:", data);
                    swal({
                            title: data.msg,
                            type: "success"
                        })
                        .then(data => {
                            location.reload();
                        });
                });
            } else {
                $('#capping_error').show();
                $('#capping_error').html('<?php echo $GLOBALS['capping_error']; ?>');
                return false;
            }
        }
    </script>
</body>

</html>
