<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/' data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title><?php echo $projecttitle; ?> - Banner Report </title>

    <meta name="description" content="" />
    <style>
        .loader {
            display: none;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999;
            background: rgba(255, 255, 255, 0.8) url("../assets/img/loader.gif") center no-repeat;
        }

        h5 {
            position: relative;
            left: 250%;
        }

        /* Close Button */
        .dataTables_wrapper .dataTables_filter input:not(:valid):not(:focus) {
            box-shadow: 0 0 5px #fff !important;
        }

        .dataTables_wrapper .dataTables_filter input::-webkit-search-cancel-button {
            -webkit-appearance: none !important;
        }

        .dataTables_wrapper .dataTables_filter button {
            visibility: hidden;
            outline: none;
        }

        .dataTables_wrapper .dataTables_filter input:valid~button {
            visibility: visible;
        }

        button.close {
            padding: 0;
            background-color: transparent;
            border: 0;
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
        }

        .close {
            float: right;
            font-size: 1.5rem;
            font-weight: 700;
            line-height: 1;
            color: #000;
            text-shadow: 0 1px 0 #fff;
            opacity: .5;
        }
    </style>
    <?php include('head.php'); ?>
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
</head>

<body onload="onChangeDetails()">
    <div class="loader"></div>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>
            <!-- / Menu -->
            <!-- Layout container -->
            <div class="layout-page" id="myImage">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card mt-3 mb-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-9">
                                        <p class="h4" id='reportTitle'><?php echo $GLOBALS['strReport_Banner_Report_Head']; ?></p>
                                        <!-- <p class="h4" id='reportTitle'>Banner Report</p> -->
                                        <input type='hidden' name="campaignid" id="campaignid" value="<?php echo $_GET['campaignid']; ?>" />
                                        <input type='hidden' id="startDate" value="<?php echo $_GET['start_date']; ?>" />
                                        <input type='hidden' id="endDate" value="<?php echo $_GET['end_date']; ?>" />
                                        <input type='hidden' id="campaignName" value="<?php echo $_GET['campaignname']; ?>" />
                                    </div>
                                    <div class="mb-3" style="width:28%; margin-left: 38%;">
                                        <select id="getBanner" name="allfilter" class="form-select text-dark" aria-label="Default select example" onchange="onChangeDetails(this.value)">
                                            <option value="Today"><?php echo $GLOBALS['strToday']; ?></option>
                                            <option value="Yesterday"><?php echo $GLOBALS['strYesterday']; ?></option>
                                            <option selected value="Last 7 days"><?php echo $GLOBALS['strLast_7_days']; ?></option>
                                            <option value="Last 30 days"><?php echo $GLOBALS['strLast 30 days']; ?></option>
                                            <option value="Last Month"><?php echo $GLOBALS['strLast Month']; ?></option>
                                            <option value="This Month"><?php echo $GLOBALS['strThis Month']; ?></option>
                                            <option value='All Statistics'><?php echo $GLOBALS['strAll Statistics']; ?></option>
                                            <option value="Custom"><?php echo $GLOBALS['strCustom']; ?></option>

                                        </select>
                                        <input style="display: none; width: 95%; margin-left:3%" id="daterange" name="daterange" class='mt-2' />
                                    </div>
                                    <div class="mb-3" style="width:30%" onchange="onChangeDetails(this.value);">
                                        <!-- onChangeReviveXandr(); -->
                                        <select id="reportType" class="form-select text-dark">
                                            <option selected value="Xandr"><?php echo $GLOBALS['strXandr']; ?></option>
                                            <option value="Revive"><?php echo $GLOBALS['strRevive']; ?></option>
                                            <option value="all">All Webseite</option>
                                        </select>
                                    </div>
                                </div>

                                <div>
                                    <div class="table-responsive text-nowrap mt-4">
                                        <table id="bannerrep" class="table table-striped" width='100%'>
                                            <thead>
                                                <tr class="text-dark">
                                                    <th class="text-dark"><?php echo $GLOBALS['strName']; ?></th>
                                                    <th class="text-dark"><?php echo $GLOBALS['strImpression']; ?></th>
                                                    <th class="text-dark text-center" style="text-align: center;"><?php echo $GLOBALS['strClicks']; ?></th>
                                                    <th class="text-dark text-start"><?php echo $GLOBALS['strCTR']; ?> %</th>
                                                </tr>
                                            </thead>
                                            <tbody id="ban_table">

                                            </tbody>

                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- / Content -->

                    <!-- Footer -->
                    <?php include('footer.php'); ?>
                    <!-- / Footer -->
                    <!--<script type="text/javascript" src="https://cdn.jsdelivr.net/jquery/latest/jquery.min.js"></script>-->
                    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
                    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
                    <script>
                        var live_URL = '<?php echo $apistatpath; ?>';
                        var domain_url = live_URL + '/get_advertiser_banner_statistics/';
                        var Xandr_url = live_URL + '/get_advertiser_banner_xender_report_statistics/';
                        var campaignBanner_url = live_URL + '/get_advertiser_campaignwise_banner_statistics/';
                        var campaignBannerxender_url = live_URL + '/get_advertiser_campaignwise_banner_xender_statistics/';
                        var token = 'Bearer ' + document.getElementById('token').value;
                        var getBanData = "",
                            setDate;
                        var client_id = document.getElementById('clientid').value;
                        var campaign_id = document.getElementById('campaignid').value;
                        var startDate = document.getElementById('startDate').value;
                        var endDate = document.getElementById('endDate').value;
                        var campaignName = document.getElementById('campaignName').value;

                        localStorage.clear();

                        function onChangeDetails() {
                            $(".loader").show();
                            const date = new Date();
                            let getSelectedDay = document.getElementById('getBanner').value;
                            var getTypeofreports = document.getElementById('reportType').value;

                            if (getSelectedDay == 'Today') {
                                $("#daterange").css("display", "none");
                                let v3 = JSON.stringify(date);
                                v3 = v3.slice(1, 11);
                                var start_date = v3,
                                    end_date = v3;
                                setDate = v3;
                                if (getTypeofreports == 'Xandr') {
                                    getXandrDate(start_date, end_date);
                                } else if (getTypeofreports == 'Revive') {
                                    getBannerDate(start_date, end_date);
                                } else {
                                    getAllWebsite(v3, v3);
                                }
                            } else if (getSelectedDay == 'Yesterday') {
                                $("#daterange").css("display", "none");
                                let current_date = date.setDate(date.getDate() - 1);
                                const get_date = new Date(date);
                                let yesterday_date = JSON.stringify(get_date);
                                yesterday_date = yesterday_date.slice(1, 11);
                                var start_date = yesterday_date,
                                    end_date = yesterday_date;
                                if (getTypeofreports == 'Xandr') {
                                    getXandrDate(start_date, end_date);
                                } else if (getTypeofreports == 'Revive') {
                                    getBannerDate(start_date, end_date);
                                } else {
                                    getAllWebsite(start_date, start_date);
                                }
                            } else if (getSelectedDay == 'Last 7 days') {
                                $("#daterange").css("display", "none");
                                let date_start = date.setDate(date.getDate() - 7);
                                let get_date = new Date(date_start);
                                let first_day = JSON.stringify(get_date);
                                first_day = first_day.slice(1, 11);

                                let date1 = new Date();
                                let current_date = date1.setDate(date1.getDate() - 1);
                                const get_7Days = new Date(date1);
                                let date_end = JSON.stringify(get_7Days);
                                date_end = date_end.slice(1, 11);

                                if (getTypeofreports == 'Xandr') {
                                    getXandrDate(first_day, date_end);
                                } else if (getTypeofreports == 'Revive') {
                                    getBannerDate(first_day, date_end);
                                } else {
                                    getAllWebsite(first_day, date_end);
                                }
                            } else if (getSelectedDay == 'Last 30 days') {
                                $("#daterange").css("display", "none");
                                let date_start = date.setDate(date.getDate() - 30);
                                let get_date = new Date(date_start);
                                var first_day = JSON.stringify(get_date);
                                first_day = first_day.slice(1, 11);

                                let date1 = new Date();
                                let current_date = date1.setDate(date1.getDate() - 1);
                                const get_30Days = new Date(date1);
                                let date_end = JSON.stringify(get_30Days);
                                date_end = date_end.slice(1, 11);
                                if (getTypeofreports == 'Xandr') {
                                    getXandrDate(first_day, date_end);
                                } else if (getTypeofreports == 'Revive') {
                                    getBannerDate(first_day, date_end);
                                } else {
                                    getAllWebsite(first_day, date_end);
                                }
                            } else if (getSelectedDay == 'This Month') {
                                $("#daterange").css("display", "none");
                                let firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                                let cDate = firstDay.getDate(),
                                    cMonth = firstDay.getMonth() + 1,
                                    cYear = firstDay.getFullYear();
                                let first_day = cYear + "-" + cMonth + "-" + cDate;

                                const current_date = new Date();
                                let date_end = JSON.stringify(current_date);
                                date_end = date_end.slice(1, 11);
                                if (getTypeofreports == 'Xandr') {
                                    getXandrDate(first_day, date_end);
                                } else if (getTypeofreports == 'Revive') {
                                    getBannerDate(first_day, date_end);
                                } else {
                                    getAllWebsite(first_day, date_end);
                                }
                            } else if (getSelectedDay == 'Last Month') {
                                $("#daterange").css("display", "none");
                                var prevMonthLastDate = new Date(date.getFullYear(), date.getMonth(), 0);
                                var prevMonthFirstDate = new Date(date.getFullYear() - (date.getMonth() > 0 ? 0 : 1), (date.getMonth() - 1 + 12) % 12, 1);
                                var formatDateComponent = function(dateComponent) {
                                    return (dateComponent < 10 ? '0' : '') + dateComponent;
                                }
                                var formatDate = function(date) {
                                    return date.getFullYear() + "-" + formatDateComponent(date.getMonth() + 1) + "-" + formatDateComponent(date.getDate())
                                };
                                var start_date = formatDate(prevMonthFirstDate),
                                    end_date = formatDate(prevMonthLastDate);
                                if (getTypeofreports == 'Xandr') {
                                    getXandrDate(start_date, end_date);
                                } else if (getTypeofreports == 'Revive') {
                                    getBannerDate(start_date, end_date);
                                } else {
                                    getAllWebsite(start_date, start_date);
                                }
                            } else if (getSelectedDay == 'All Statistics') {
                                $("#daterange").css("display", "none");

                                let allStats_url = getTypeofreports == 'Revive' ? '/get_all_advertiser_banner_statistics/' :
                                    getTypeofreports == 'Xandr' ? '/get_all_advertiser_banner_xender_statistics/' :
                                    // '/get_all_website_all_stats_advertiser_banner_statistics/';
                                    '/get_all_website_advertiser_banner_report_statistics/'+0 + ',' + 0 + ',';
                                // if(getTypeofreports=='Xandr'){                                   
                                $.ajax({
                                    url: live_URL + allStats_url + client_id,
                                    type: 'GET',
                                    beforeSend: function(xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: {},
                                    success: function(data) {

                                        $(".loader").hide();
                                        if (data.msg == 'No Stats Available') {
                                            $('#bannerrep').DataTable({
                                                ordering: false,
                                                destroy: true,
                                                responsive: true,
                                                bPaginate: false,
                                                bInfo: false,
                                                data: [],
                                                searching: false,
                                                oLanguage: {
                                                    sEmptyTable: "No Data Found"
                                                }
                                            });
                                        } else {
                                            var xandr = "xandr";
                                            var getBanner = $("#getBanner").val();
                                            var cust_startdate = localStorage.getItem("cust_startdate");
                                            var cust_enddate = localStorage.getItem("cust_enddate");

                                            // var start_date= localStorage.getItem("start_date");
                                            // var end_date= localStorage.getItem("end_date");

                                            if (getBanner == "Custom" && cust_startdate != null && cust_enddate != null) {
                                                console.log('........');
                                                var start_date = cust_startdate;
                                                var end_date = cust_enddate;
                                            } else {
                                                var start_date = start_date;
                                                var end_date = end_date;
                                            }
                                            $('#bannerrep').DataTable({
                                                "ordering": true,
                                                "destroy": true,
                                                data: data,
                                                columns: [{
                                                        'data': null,
                                                        title: 'Name',
                                                        wrap: true,
                                                        "render": function(banner) {
                                                            return '<a href="banner_reportgraph.php?bannerid=' + banner.bannerid + '&bannername=' + banner.bannername + '&start_date=' + start_date + '&end_date=' + end_date + '&params=' + xandr + '">' + banner.bannername + '</a>'
                                                        }
                                                    },
                                                    {
                                                        data: 'impressions',
                                                        className: "text-center"
                                                    },
                                                    {
                                                        data: 'clicks',
                                                        className: "text-center"
                                                    },
                                                    {
                                                        data: 'ctr',
                                                        className: "text-center"
                                                    },


                                                ],
                                                "footerCallback": function(row, data, start, end, display) {
                                                    var api = this.api(),
                                                        data;

                                                    // converting to interger to find total
                                                    var intVal = function(i) {
                                                        return typeof i === 'string' ?
                                                            i.replace(/[\$,]/g, '') * 1 :
                                                            typeof i === 'number' ?
                                                            i : 0;
                                                    };

                                                    // computing column Total of the complete result 
                                                    var impressions = api
                                                        .column(1)
                                                        .data()
                                                        .reduce(function(a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    var clicks = api
                                                        .column(2)
                                                        .data()
                                                        .reduce(function(a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);



                                                    var ctr = api
                                                        .column(3)
                                                        .data()
                                                        .reduce(function(a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    // Update footer by showing the total with the reference of the column index 
                                                    $(api.column(0).footer()).html('Total');
                                                    $(api.column(1).footer()).html(impressions);
                                                    $(api.column(2).footer()).html(clicks);
                                                    $(api.column(3).footer()).html(ctr.toFixed(2));
                                                },
                                                initComplete: function(settings) {
                                                    //settings.nTable.id --> Get table ID
                                                    $('#' + settings.nTable.id + '_filter input').wrap(`
                                                        <div class="d-inline-flex position-relative"></div>
                                                `).after(`
                                                        <button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
                                                        <span aria-hidden="true">&times;</span>
                                                        </button>
                                                `).attr('required', 'required').attr('title', 'Search');

                                                    // Click Event on Clear button
                                                    $(document).on('click', '#' + settings.nTable.id + '_filter button', function() {
                                                        $('#' + settings.nTable.id).DataTable({
                                                            "retrieve": true,
                                                        }).search('').draw(); // reDraw table
                                                    });
                                                }
                                            });
                                        }
                                    },
                                    error: function() {},
                                });

                                // }
                                // else if(getTypeofreports=='Revive') {
                                //     $.ajax({
                                //     url: live_URL + '/get_all_advertiser_banner_statistics/' + client_id,
                                //     type: 'GET',
                                //     beforeSend: function (xhr) {
                                //         xhr.setRequestHeader('Authorization', token);
                                //     },
                                //     data: {},
                                //     success: function (data) {

                                //         $(".loader").hide();
                                //         if (data.msg == 'No Stats Available') {
                                //             $('#bannerrep').DataTable({
                                //             ordering: false,
                                //             destroy: true,
                                //             responsive: true,
                                //             bPaginate: false,
                                //             bInfo: false,
                                //             data:[],
                                //             searching: false,
                                //             oLanguage: {
                                //                 sEmptyTable:"No Data Found"
                                //             }
                                //         });
                                //         }
                                //         else {
                                //             var revive="revive";
                                //             var getBanner = $("#getBanner").val(); 
                                //             var cust_startdate= localStorage.getItem("cust_startdate");                                  
                                //             var cust_enddate= localStorage.getItem("cust_enddate");
                                //             // var start_date= localStorage.getItem("start_date");
                                //             // var end_date= localStorage.getItem("end_date");

                                //             if(getBanner=="Custom"&& cust_startdate!=null && cust_enddate!=null ){
                                //                 console.log('........');
                                //                 var start_date=cust_startdate;
                                //                 var end_date=cust_enddate;
                                //             }else{
                                //                 var start_date=start_date;
                                //                 var end_date=end_date;
                                //             }
                                //             $('#bannerrep').DataTable({
                                //                 "ordering": true,
                                //                 "destroy": true,
                                //                 data: data,
                                //                 columns: [
                                //                     // { data: 'bannername' },

                                //                     { 'data': null, title: 'Name', wrap: true, "render": function (banner) { return '<a href="banner_reportgraph.php?bannerid='+banner.bannerid+'&bannername='+banner.bannername+'&start_date='+start_date+'&end_date='+end_date+'&params='+revive+'">'+banner.bannername+'</a>' } },

                                //                     { data: 'impressions', className: "text-center" },
                                //                     { data: 'clicks', className: "text-center" },
                                //                     { data: 'ctr', className: "text-center" },



                                //                 ],
                                //                 "footerCallback": function ( row, data, start, end, display ) {
                                //                 var api = this.api(), data;

                                //                 // converting to interger to find total
                                //                 var intVal = function ( i ) {
                                //                     return typeof i === 'string' ?
                                //                         i.replace(/[\$,]/g, '')*1 :
                                //                         typeof i === 'number' ?
                                //                             i : 0;
                                //                 };

                                //                 // computing column Total of the complete result 
                                //                 var impressions = api
                                //                     .column( 1 )
                                //                     .data()
                                //                     .reduce( function (a, b) {
                                //                         return intVal(a) + intVal(b);
                                //                     }, 0 );

                                //             var clicks = api
                                //                     .column( 2 )
                                //                     .data()
                                //                     .reduce( function (a, b) {
                                //                         return intVal(a) + intVal(b);
                                //                     }, 0 );



                                //             var ctr = api
                                //                     .column( 3 )
                                //                     .data()
                                //                     .reduce( function (a, b) {
                                //                         return intVal(a) + intVal(b);
                                //                     }, 0 );





                                //                 // Update footer by showing the total with the reference of the column index 
                                //             $( api.column( 0 ).footer() ).html('Total');
                                //                 $( api.column( 1 ).footer() ).html(impressions);
                                //                 $( api.column( 2 ).footer() ).html(clicks);
                                //                 $( api.column( 3 ).footer() ).html(ctr.toFixed(2));
                                //             },
                                // 			initComplete: function(settings) 
                                // 			{
                                // 			    //settings.nTable.id --> Get table ID
                                // 			    $('#'+settings.nTable.id+'_filter input').wrap(`
                                // 				    <div class="d-inline-flex position-relative"></div>
                                // 			  ` ).after(`
                                // 					<button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
                                // 					  <span aria-hidden="true">&times;</span>
                                // 					</button>
                                // 			   `).attr('required','required').attr('title','Search');

                                // 			   // Click Event on Clear button
                                // 			    $(document).on('click', '#'+settings.nTable.id+'_filter button', function(){
                                // 				 $('#'+settings.nTable.id).DataTable({
                                // 				   "retrieve": true,
                                // 				  }).search('').draw(); // reDraw table
                                // 			    });
                                // 			}
                                //             });
                                //         }
                                //     },
                                //     error: function () { },
                                //     });
                                // }
                            } else if (getSelectedDay == 'Custom') {
                                $(".loader").hide();
                                $("#daterange").css("display", "block");
                                let custom_currentDate = JSON.stringify(date);
                                custom_currentDate = custom_currentDate.slice(1, 11);
                                console.log("set date", custom_currentDate);

                                getTypeofreports == 'Xandr' ? getXandrDate(custom_currentDate, custom_currentDate) :
                                getTypeofreports == 'Revive'?getBannerDate(custom_currentDate, custom_currentDate):
                                getAllWebsite(custom_currentDate, custom_currentDate);

                                $(function() {
                                    $('input[name="daterange"]').daterangepicker({
                                        opens: 'left',
                                        locale: {
                                            format: 'DD/MMM/YYYY'
                                        },
                                    }, function(start, end, label) {
                                        var getBanner = $("#getBanner").val();
                                        var start_date = start.format('YYYY-MM-DD'),
                                            end_date = end.format('YYYY-MM-DD');

                                        localStorage.setItem("cust_startdate", start_date);
                                        localStorage.setItem("cust_enddate", end_date);

                                        if (getTypeofreports == 'Xandr') {
                                            getXandrDate(start_date, end_date);
                                        } else if (getTypeofreports == 'Revive') {
                                            getBannerDate(start_date, end_date);
                                        } else {
                                            getAllWebsite(start_date, start_date);
                                        }
                                    });
                                })
                            }
                        };

                        // onChangeReviveXandr = () => {
                        //     let getSelectedDay = document.getElementById('getBanner').value;
                        //     // getSelectedDay == "Custom"?location.reload():"";
                        // };

                        function getBannerDate(start_date, end_date) {
                            var cust_startdate = localStorage.getItem("cust_startdate");
                            var cust_enddate = localStorage.getItem("cust_enddate");

                            localStorage.setItem("start_date", start_date);
                            localStorage.setItem("end_date", end_date);

                            var getBanner = $("#getBanner").val();
                            console.log('getBanner....', getBanner);

                            if (getBanner == "Custom" && cust_startdate != null && cust_enddate != null) {
                                var start_end_date = cust_startdate + ' 00:00:00,' + cust_enddate + ' 23:59:59,';
                            } else {
                                var start_end_date = start_date + ' 00:00:00,' + end_date + ' 23:59:59,';
                            }

                            if (campaign_id == '') {
                                $.ajax({
                                    url: domain_url + start_end_date + client_id,
                                    type: 'GET',
                                    beforeSend: function(xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: {},
                                    success: function(data) {
                                        $(".loader").hide();
                                        if (data.msg == 'No Stats Available') {
                                            $('#bannerrep').DataTable({
                                                ordering: false,
                                                destroy: true,
                                                responsive: true,
                                                bPaginate: false,
                                                bInfo: false,
                                                data: [],
                                                searching: false,
                                                oLanguage: {
                                                    sEmptyTable: "No Data Found"
                                                }
                                            });
                                        } else {
                                            var revive = "revive";
                                            var getBanner = $("#getBanner").val();
                                            var cust_startdate = localStorage.getItem("cust_startdate");
                                            var cust_enddate = localStorage.getItem("cust_enddate");
                                            var start_date = localStorage.getItem("start_date");
                                            var end_date = localStorage.getItem("end_date");

                                            if (getBanner == "Custom" && cust_startdate != null && cust_enddate != null) {
                                                console.log('........');
                                                var start_date = cust_startdate;
                                                var end_date = cust_enddate;
                                            } else {
                                                var start_date = start_date;
                                                var end_date = end_date;
                                            }

                                            $('#bannerrep').DataTable({
                                                "ordering": true,
                                                "destroy": true,
                                                data: data,
                                                columns: [{
                                                        'data': null,
                                                        title: 'Name',
                                                        wrap: true,
                                                        "render": function(banner) {
                                                            return '<a href="banner_reportgraph.php?bannerid=' + banner.bannerid + '&bannername=' + banner.bannername + '&start_date=' + start_date + '&end_date=' + end_date + '&params=' + revive + '">' + banner.bannername + '</a>'
                                                        }
                                                    },
                                                    {
                                                        data: 'impressions',
                                                        className: "text-center"
                                                    },
                                                    {
                                                        data: 'clicks',
                                                        className: "text-center"
                                                    },
                                                    {
                                                        data: 'ctr',
                                                        className: "text-center"
                                                    },

                                                ],
                                                "footerCallback": function(row, data, start, end, display) {
                                                    var api = this.api(),
                                                        data;

                                                    // converting to interger to find total
                                                    var intVal = function(i) {
                                                        return typeof i === 'string' ?
                                                            i.replace(/[\$,]/g, '') * 1 :
                                                            typeof i === 'number' ?
                                                            i : 0;
                                                    };

                                                    // computing column Total of the complete result 
                                                    var impressions = api
                                                        .column(1)
                                                        .data()
                                                        .reduce(function(a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    var clicks = api
                                                        .column(2)
                                                        .data()
                                                        .reduce(function(a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);



                                                    var ctr = api
                                                        .column(3)
                                                        .data()
                                                        .reduce(function(a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);



                                                    // Update footer by showing the total with the reference of the column index 
                                                    $(api.column(0).footer()).html('Total');
                                                    $(api.column(1).footer()).html(impressions);
                                                    $(api.column(2).footer()).html(clicks);
                                                    $(api.column(3).footer()).html(ctr.toFixed(2));
                                                },
                                                initComplete: function(settings) {
                                                    //settings.nTable.id --> Get table ID
                                                    $('#' + settings.nTable.id + '_filter input').wrap(`
												    <div class="d-inline-flex position-relative"></div>
											  `).after(`
													<button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
													  <span aria-hidden="true">&times;</span>
													</button>
											   `).attr('required', 'required').attr('title', 'Search');

                                                    // Click Event on Clear button
                                                    $(document).on('click', '#' + settings.nTable.id + '_filter button', function() {
                                                        $('#' + settings.nTable.id).DataTable({
                                                            "retrieve": true,
                                                        }).search('').draw(); // reDraw table
                                                    });
                                                }
                                            });
                                        }
                                    },
                                    error: function() {},
                                });
                            } else {
                                $.ajax({
                                    url: campaignBanner_url + startDate + ' 00:00:00,' + endDate + ' 23:59:59,' + client_id + ',' + campaign_id,
                                    type: 'GET',
                                    beforeSend: function(xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: {},
                                    success: function(data) {
                                        $(".loader").hide();

                                        if (data.msg == 'No Stats Available') {
                                            $('#bannerrep').DataTable({
                                                ordering: false,
                                                destroy: true,
                                                responsive: true,
                                                bPaginate: false,
                                                bInfo: false,
                                                data: [],
                                                searching: false,
                                                oLanguage: {
                                                    sEmptyTable: "No Data Found"
                                                }
                                            });
                                        } else {
                                            document.getElementById('getBanner').style.display = "none";
                                            document.title = campaignName;
                                            document.getElementById('reportTitle').innerHTML = document.title;

                                            $('#bannerrep').DataTable({
                                                "ordering": true,
                                                "destroy": true,
                                                data: data,
                                                columns: [{
                                                        data: 'bannername',
                                                        className: 'text-start'
                                                    },
                                                    {
                                                        data: 'impressions',
                                                        className: 'text-center'
                                                    },
                                                    {
                                                        data: 'clicks',
                                                        className: 'text-center'
                                                    },
                                                    {
                                                        data: 'ctr',
                                                        className: 'text-center'
                                                    },

                                                ],
                                                "footerCallback": function(row, data, start, end, display) {
                                                    var api = this.api(),
                                                        data;

                                                    // converting to interger to find total
                                                    var intVal = function(i) {
                                                        return typeof i === 'string' ?
                                                            i.replace(/[\$,]/g, '') * 1 :
                                                            typeof i === 'number' ?
                                                            i : 0;
                                                    };

                                                    // computing column Total of the complete result 
                                                    var impressions = api.column(1).data().reduce(function(a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);

                                                    var clicks = api.column(2).data().reduce(function(a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);



                                                    var ctr = api.column(3).data().reduce(function(a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);



                                                    // Update footer by showing the total with the reference of the column index 
                                                    $(api.column(0).footer()).html('Total');
                                                    $(api.column(1).footer()).html(impressions);
                                                    $(api.column(2).footer()).html(clicks);
                                                    $(api.column(3).footer()).html(ctr.toFixed(2));
                                                },
                                            });
                                        }
                                    },
                                    error: function() {},
                                });
                            }
                        };

                        function getXandrDate(start_date, end_date) {
                            var cust_startdate = localStorage.getItem("cust_startdate");
                            var cust_enddate = localStorage.getItem("cust_enddate");

                            localStorage.setItem("start_date", start_date);
                            localStorage.setItem("end_date", end_date);

                            var getBanner = $("#getBanner").val();
                            console.log('getBanner....', getBanner);

                            if (getBanner == "Custom" && cust_startdate != null && cust_enddate != null) {
                                var start_end_date = cust_startdate + ' 00:00:00,' + cust_enddate + ' 23:59:59,';
                                // var start_date=cust_startdate;
                                // var end_date=cust_enddate;'
                                console.log('cust_startdate..', cust_startdate);
                                console.log('cust_enddate....', cust_enddate);
                            } else {
                                var start_end_date = start_date + ' 00:00:00,' + end_date + ' 23:59:59,';
                                console.log('start_date..', start_date);
                                console.log('end_date....', end_date);
                                // var start_date=start_date;
                                // var end_date=end_date;
                            }

                            if (campaign_id == '') {
                                $.ajax({
                                    url: Xandr_url + start_end_date + client_id,
                                    type: 'GET',
                                    beforeSend: function(xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: {},
                                    success: function(data) {
                                        //$('#hmm').html(data);
                                        $(".loader").hide();

                                        if (data.msg == 'No Stats Available') {
                                            $('#bannerrep').DataTable({
                                                ordering: false,
                                                destroy: true,
                                                responsive: true,
                                                bPaginate: false,
                                                bInfo: false,
                                                data: [],
                                                searching: false,
                                                oLanguage: {
                                                    sEmptyTable: "No Data Found"
                                                }
                                            });
                                        } else {
                                            var xandr = "xandr";
                                            var getBanner = $("#getBanner").val();

                                            var cust_startdate = localStorage.getItem("cust_startdate");
                                            var cust_enddate = localStorage.getItem("cust_enddate");

                                            var start_date = localStorage.getItem("start_date");
                                            var end_date = localStorage.getItem("end_date");

                                            if (getBanner == "Custom" && cust_startdate != null && cust_enddate != null) {
                                                console.log('........');
                                                var start_date = cust_startdate;
                                                var end_date = cust_enddate;
                                            } else {
                                                var start_date = start_date;
                                                var end_date = end_date;
                                            }

                                            $('#bannerrep').DataTable({
                                                "ordering": true,
                                                "destroy": true,
                                                data: data,
                                                columns: [{
                                                        'data': null,
                                                        title: 'Name',
                                                        wrap: true,
                                                        "render": function(banner) {
                                                            return '<a href="banner_reportgraph.php?bannerid=' + banner.bannerid + '&bannername=' + banner.bannername + '&start_date=' + start_date + '&end_date=' + end_date + '&params=' + xandr + '">' + banner.bannername + '</a>'
                                                        }
                                                    },
                                                    {
                                                        data: 'impressions',
                                                        className: "text-center"
                                                    },
                                                    {
                                                        data: 'clicks',
                                                        className: "text-center"
                                                    },
                                                    {
                                                        data: 'ctr',
                                                        className: "text-center"
                                                    },

                                                ],
                                                "footerCallback": function(row, data, start, end, display) {
                                                    var api = this.api(),
                                                        data;

                                                    // converting to interger to find total
                                                    var intVal = function(i) {
                                                        return typeof i === 'string' ?
                                                            i.replace(/[\$,]/g, '') * 1 :
                                                            typeof i === 'number' ?
                                                            i : 0;
                                                    };

                                                    // computing column Total of the complete result 
                                                    var impressions = api
                                                        .column(1)
                                                        .data()
                                                        .reduce(function(a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    var clicks = api
                                                        .column(2)
                                                        .data()
                                                        .reduce(function(a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);



                                                    var ctr = api
                                                        .column(3)
                                                        .data()
                                                        .reduce(function(a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);



                                                    // Update footer by showing the total with the reference of the column index 
                                                    $(api.column(0).footer()).html('Total');
                                                    $(api.column(1).footer()).html(impressions);
                                                    $(api.column(2).footer()).html(clicks);
                                                    $(api.column(3).footer()).html(ctr.toFixed(2));
                                                },
                                                initComplete: function(settings) {
                                                    //settings.nTable.id --> Get table ID
                                                    $('#' + settings.nTable.id + '_filter input').wrap(`
                                                    <div class="d-inline-flex position-relative"></div>
                                            `).after(`
                                                    <button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
                                                    <span aria-hidden="true">&times;</span>
                                                    </button>
                                            `).attr('required', 'required').attr('title', 'Search');

                                                    // Click Event on Clear button
                                                    $(document).on('click', '#' + settings.nTable.id + '_filter button', function() {
                                                        $('#' + settings.nTable.id).DataTable({
                                                            "retrieve": true,
                                                        }).search('').draw(); // reDraw table
                                                    });
                                                }
                                            });
                                        }
                                    },
                                    error: function() {},
                                });
                            } else {
                                $.ajax({
                                    url: campaignBannerxender_url + startDate + ' 00:00:00,' + endDate + ' 23:59:59,' + client_id + ',' + campaign_id,
                                    type: 'GET',
                                    beforeSend: function(xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: {},
                                    success: function(data) {
                                        //$('#hmm').html(data);
                                        $(".loader").hide();

                                        if (data.msg == 'No Stats Available') {
                                            $('#bannerrep').DataTable({
                                                ordering: false,
                                                destroy: true,
                                                responsive: true,
                                                bPaginate: false,
                                                bInfo: false,
                                                data: [],
                                                searching: false,
                                                oLanguage: {
                                                    sEmptyTable: "No Data Found"
                                                }
                                            });
                                        } else {
                                            document.getElementById('getBanner').style.display = "none";
                                            document.title = campaignName;
                                            document.getElementById('reportTitle').innerHTML = document.title;

                                            $('#bannerrep').DataTable({
                                                "ordering": true,
                                                "destroy": true,
                                                data: data,
                                                columns: [{
                                                        data: 'bannername',
                                                        className: 'text-start'
                                                    },
                                                    {
                                                        data: 'impressions',
                                                        className: 'text-center'
                                                    },
                                                    {
                                                        data: 'clicks',
                                                        className: 'text-center'
                                                    },
                                                    {
                                                        data: 'ctr',
                                                        className: 'text-center'
                                                    },

                                                ],
                                                "footerCallback": function(row, data, start, end, display) {
                                                    var api = this.api(),
                                                        data;

                                                    // converting to interger to find total
                                                    var intVal = function(i) {
                                                        return typeof i === 'string' ?
                                                            i.replace(/[\$,]/g, '') * 1 :
                                                            typeof i === 'number' ?
                                                            i : 0;
                                                    };

                                                    // computing column Total of the complete result 
                                                    var impressions = api.column(1).data().reduce(function(a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);

                                                    var clicks = api.column(2).data().reduce(function(a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);



                                                    var ctr = api.column(3).data().reduce(function(a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);


                                                    // Update footer by showing the total with the reference of the column index 
                                                    $(api.column(0).footer()).html('Total');
                                                    $(api.column(1).footer()).html(impressions);
                                                    $(api.column(2).footer()).html(clicks);
                                                    $(api.column(3).footer()).html(ctr.toFixed(2));
                                                },
                                            });
                                        }
                                    },
                                    error: function() {},
                                });
                            }
                        };

                        function getAllWebsite(start_date, end_date) {
                            var cust_startdate = localStorage.getItem("cust_startdate");
                            var cust_enddate = localStorage.getItem("cust_enddate");

                            if (getBanner == "Custom" && cust_startdate != null && cust_enddate != null) {
                                var start_end_date = cust_startdate + ' 00:00:00,' + cust_enddate + ' 23:59:59,';
                            } else {
                                var start_end_date = start_date + ' 00:00:00,' + end_date + ' 23:59:59,';
                            }

                            $.ajax({
                                url: live_URL + '/get_all_website_advertiser_banner_report_statistics/' + start_end_date + client_id,
                                type: 'GET',
                                beforeSend: function(xhr) {
                                    xhr.setRequestHeader('Authorization', token);
                                },
                                data: {},
                                success: function(data) {
                                    $(".loader").hide();
                                    if (data.msg == 'No Stats Available') {
                                        $('#bannerrep').DataTable({
                                            ordering: false,
                                            destroy: true,
                                            responsive: true,
                                            bPaginate: false,
                                            bInfo: false,
                                            data: [],
                                            searching: false,
                                            oLanguage: {
                                                sEmptyTable: "No Data Found"
                                            }
                                        });
                                    } else {
                                        var xandr = "xandr";
                                        var getBanner = $("#getBanner").val();
                                        var cust_startdate = localStorage.getItem("cust_startdate");
                                        var cust_enddate = localStorage.getItem("cust_enddate");

                                        // var start_date= localStorage.getItem("start_date");
                                        // var end_date= localStorage.getItem("end_date");

                                        if (getBanner == "Custom" && cust_startdate != null && cust_enddate != null) {
                                            console.log('........');
                                            var start_date = cust_startdate;
                                            var end_date = cust_enddate;
                                        } else {
                                            var start_date = start_date;
                                            var end_date = end_date;
                                        }
                                        $('#bannerrep').DataTable({
                                            "ordering": true,
                                            "destroy": true,
                                            data: data,
                                            columns: [{
                                                    'data': null,
                                                    title: 'Name',
                                                    wrap: true,
                                                    "render": function(banner) {
                                                        return '<a href="banner_reportgraph.php?bannerid=' + banner.bannerid + '&bannername=' + banner.bannername + '&start_date=' + start_date + '&end_date=' + end_date + '&params=' + xandr + '">' + banner.bannername + '</a>'
                                                    }
                                                },
                                                {
                                                    data: 'impressions',
                                                    className: "text-center"
                                                },
                                                {
                                                    data: 'clicks',
                                                    className: "text-center"
                                                },
                                                {
                                                    data: 'ctr',
                                                    className: "text-center"
                                                },
                                            ],
                                            "footerCallback": function(row, data, start, end, display) {
                                                var api = this.api(),
                                                    data;

                                                // converting to interger to find total
                                                var intVal = function(i) {
                                                    return typeof i === 'string' ?
                                                        i.replace(/[\$,]/g, '') * 1 :
                                                        typeof i === 'number' ?
                                                        i : 0;
                                                };

                                                // computing column Total of the complete result 
                                                var impressions = api
                                                    .column(1)
                                                    .data()
                                                    .reduce(function(a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);

                                                var clicks = api
                                                    .column(2)
                                                    .data()
                                                    .reduce(function(a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);



                                                var ctr = api
                                                    .column(3)
                                                    .data()
                                                    .reduce(function(a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);

                                                // Update footer by showing the total with the reference of the column index 
                                                $(api.column(0).footer()).html('Total');
                                                $(api.column(1).footer()).html(impressions);
                                                $(api.column(2).footer()).html(clicks);
                                                $(api.column(3).footer()).html(ctr.toFixed(2));
                                            },
                                            initComplete: function(settings) {
                                                //settings.nTable.id --> Get table ID
                                                $('#' + settings.nTable.id + '_filter input').wrap(`
                                                        <div class="d-inline-flex position-relative"></div>
                                                `).after(`
                                                        <button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
                                                        <span aria-hidden="true">&times;</span>
                                                        </button>
                                                `).attr('required', 'required').attr('title', 'Search');

                                                // Click Event on Clear button
                                                $(document).on('click', '#' + settings.nTable.id + '_filter button', function() {
                                                    $('#' + settings.nTable.id).DataTable({
                                                        "retrieve": true,
                                                    }).search('').draw(); // reDraw table
                                                });
                                            }
                                        });
                                    }
                                },
                                error: function() {},
                            });
                        };
                    </script>
                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>
        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
</body>

</html>