<?php
include('session.php');
include('../config.php');
include('../common.php');

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>Adserver - Banner </title>
    <meta name="description" content="" />
    <?php include('head.php'); ?>

</head>
<style>
    .swal-button--danger {
        background-color: #2523b3;
    }

    .swal-button--cancel {
        color: white;
        background-color: #ff3e1d;
    }

    .swal-button--cancel:not([disabled]):hover {
        background-color: #ff0800;
    }

    .swal-button--danger:not([disabled]):hover {
        background-color: #2523b3;
    }

    .text-hide {
        display: flex;
        width: 130px !important;
        overflow: hidden;
        white-space: nowrap;
        text-overflow: ellipsis;
    }

    .text-hide:hover {
        overflow: hidden;
    }

    .card-body {
        padding: 0 !important;
    }

    .dataTables_scrollBody {
        height: auto !important;
    }

    .table-striped {
        width: 1200px !important;
    }

    .text_convert {
        text-transform: capitalize;
    }

    .loader {
        display: none;
        position: fixed;
        width: 100%;
        height: 100%;
        top: 0;
        left: 0;
        z-index: 999;
        background: rgba(255, 255, 255, 0.8) url("../assets/img/loader.gif") center no-repeat;
    }

    .align_size {
        width: 800px;
    }

    ;
</style>

<body onload="Bannerlist();">
    <div class="loader"></div>
    <input type='hidden' name="campaignid" id="campaignid" value="<?php echo $_GET['campaignid']; ?>" />
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>

            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card mt-5">
                            <div class="card-header">
                                <div class="row">
                                    <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                        <p class="h3 text-center text-sm-center text-md-start text-lg-start text-xl-start text-xxl-start">
                                            <?php echo $GLOBALS['str_Banner_List_Head']; ?>
                                        </p>
                                    </div>
                                    <!-- style="position:relative;left:50%" -->
                                    <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                        <div class="d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                            <button type="button" class="btn btn-primary" id="deleteall" style="margin-right: 2%;">
                                                <a href="#" class="text-white" id="deleteallbtn">
                                                    <i class="bx bx-trash bg-label-white" aria-hidden="true" title="Delete"></i>
                                                    <?php echo $GLOBALS['delete']; ?>
                                                </a>
                                            </button>
                                            <button type="button" class="btn btn-primary" id="addBannerButton" onclick="window.location.href='banner_add.php'">
                                                <a href="banner_add.php" class="text-white">
                                                    <i class="menu-icon tf-icons bx bx-plus"></i>
                                                    <?php echo $GLOBALS['strInventory_AddBanner']; ?>
                                                </a>
                                            </button>
                                        </div>
                                        <div class="row">
                                            <div class="col">
                                                <div class="row">
                                                    <div class="col-10">


                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-2"></div>
                                        </div>
                                    </div>
                                </div>
                                <hr class="solid">
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="mt-2 mb-4 container">
                                        <div class="table-responsive text-nowrap">
                                            <table id="Bannerlist" class="table table-striped table-responsive ">
                                                <thead>
                                                    <tr class="text-nowrap">
                                                        <th class="th-color text-center"><input class="form-check-input" type="checkbox" id="select-all"></th>
                                                        <th class="thauth-login-basic.html-color text-start text-center"><?php echo $GLOBALS['strName']; ?></th>
                                                        <th class="thauth-login-basic.html-color th-color text-center"><?php echo $GLOBALS['strInventory_Campaign_List_Type']; ?></th>
                                                        <th class="thauth-login-basic.html-color th-color text-center"><?php echo $GLOBALS['strSize']; ?></th>
                                                        <th class="th-color text-center"><?php echo $GLOBALS['strURL']; ?></th>
                                                        <th class="th-color text-center"><?php echo $GLOBALS['strUpdate']; ?></th>
                                                        <th class="thauth-login-basic.html-color th-color text-center" style="width:100px"><?php echo $GLOBALS['strInventory_Campaign_List_Status']; ?></th>
                                                        <th class="thauth-login-basic.html-color th-color text-center"><?php echo $GLOBALS['strInventory_Campaign_List_Action']; ?></th>
                                                        <!-- <th class="thauth-login-basic.html-color text-start text-center">Name</th>
                                                        <th class="thauth-login-basic.html-color th-color text-center">Type</th>
                                                        <th class="thauth-login-basic.html-color th-color text-center">Size</th>
                                                        <th class="th-color text-center">Url</th>
                                                        <th class="th-color text-center">Update</th>
                                                        <th class="thauth-login-basic.html-color th-color text-center" style="width:200px">Status</th>
                                                        <th class="thauth-login-basic.html-color th-color text-center">Action</th> -->
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <!-- / Content -->

                    <!-- Footer -->

                    <?php include('footer.php'); ?>

                    <!-- / Footer -->

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper ,className: " text-hide"-->
    <script>
        const token = 'Bearer ' + document.getElementById('token').value;
        let clientid = document.getElementById('clientid').value;
        let getCampaignId = document.getElementById('campaignid').value;
        let live_URL = '<?php echo $apiinvenpath; ?>';

        let domain_url = live_URL + '/get_all_banner/';
        let delete_url = live_URL + '/delete_banner/';
        let activeDeactive = live_URL + '/banner_status_update/';
        let campaignWishBanner_URL = live_URL + '/get_campaignwise_banner/';
        document.getElementById('deleteall').disabled = true;

        function Bannerlist() {
            $(".loader").show();
            // document.getElementById("deleteBannerButton").style.display = getCampaignId !== ""?"none":"compact";
            document.getElementById("addBannerButton").style.display = getCampaignId !== "" ? "none" : "compact";

            $.ajax({
                url: getCampaignId !== "" ? campaignWishBanner_URL + getCampaignId : domain_url + clientid,
                type: 'GET',
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                success: function(data) {
                    $(".loader").hide();
                    if (data.msg == 'No Data' && data.statuscode == 200) {
                        $('#Bannerlist').DataTable({
                            ordering: false,
                            destroy: true,
                            responsive: true,
                            bPaginate: false,
                            bAutoWidth: false,
                            bInfo: false,
                            data: [],
                            searching: false,
                            oLanguage: {
                                sEmptyTable: `<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`

                                // sEmptyTable:"No Data Found"
                            }
                        });
                    } else {
                        $('#Bannerlist').DataTable({
                            ordering: true,
                            destroy: true,
                            scrollY: 450,
                            scrollX: true,
                            data: data.data,
                            sort: true,
                            columns: [{
                                    data: 'bannerid',
                                    className: " text-center",
                                    render: function(data, type, row, meta) {
                                        // return '<input class="form-check-input" type="checkbox" name="checkrow" id="checkrow">';
                                        return '<input type="checkbox" name="checkrow" class="form-check-input chkCountry" id="checedkrows" value="' + row.bannerid + '" data-campaign-id="' + row.bannerid + '">';
                                    }
                                },
                                {
                                    'data': null,
                                    title: 'Name',
                                    wrap: true,
                                    className: "text-start",
                                    "render": function(banner) {
                                        // return  '<a href="banner_chart.php?bannerid= '+banner.bannerid+'">'+banner.bannername+'</a>';
                                        return '<div class="text-wrap text-break" style="width: 14rem;"><a href="banner_edit.php?bannerid='+banner.bannerid + '&campaignid=' + banner.campaignid + '">' + banner.description + '</a></div>';
                                    }
                                },
                                {
                                    data: 'storagetype',
                                    className: "text-start",
                                    render: function(data, type, row, meta) {
                                        // console.log('data..',data);
                                        // return '<div style="width:5rem"><p>'+row.storagetype+'</p></div>';
                                        return row.storagetype;
                                    }
                                },
                                {
                                    data: 'width',
                                    className: "text-center",
                                    render: function(data, type, row, meta) {
                                        if (row.width > 0 || row.height > 0) {
                                            // return '<div style="width:7rem"><p>'+row.width + ' * ' + row.height+'</p></div>';
                                            return row.width + ' * ' + row.height;
                                        } else {
                                            // return '<div style="width:5rem"><p> - </p></div>';
                                            return "-"
                                        }
                                    }
                                },
                                {
                                    data: 'url',
                                    className: 'text-start text-wrap text-break'
                                },
                                {
                                    data: 'updated',
                                    className: 'text-center'
                                },
                                {
                                    data: 'status',
                                    // width: '68%',
                                    render: function(data, type, row, meta) {
                                        if (row.status == 0) {
                                            // var status = '<div><span class="badge bg-success fw-bold p-2 text_convert text-center" style="width:80px">&nbsp; Active &nbsp;</span>&nbsp;<a href="#"> <i class="fa fa-toggle-on text-danger" id="Deactivate" aria-hidden="true" title="Deactivate" style="font-size:20px"  onclick="activeDeactivate('+row.bannerid+');"></i></a></div>';
                                            var status = '<div><span class="badge bg-success fw-bold p-2 text_convert text-center" style="width:80px">&nbsp;  <?php echo $GLOBALS['strInventory_Campaign_List_Active']; ?> &nbsp;</span>&nbsp;<a href="#"> <i class="fa fa-toggle-on text-danger" id="Deactivate" aria-hidden="true" title=<?php echo $GLOBALS['deactivate']; ?> style="font-size:20px"  onclick="activeDeactivate(' + row.bannerid + ');"></i></a></div>';

                                        } else {
                                            var status = '<div><span class="badge bg-danger fw-bold p-2 text_convert" style="width:80px">&nbsp;<?php echo $GLOBALS['strInventory_Campaign_List_Inactive']; ?>&nbsp;</span>&nbsp; <a href="#"> <i class="fa fa-toggle-on text-success" id="activestatus" aria-hidden="true" title=<?php echo $GLOBALS['activate']; ?> style="font-size:20px;"  onclick="activeDeactivate(' + row.bannerid + ');"></i></a></div>';
                                            // var status = '<div><span class="badge bg-danger fw-bold p-2 text_convert" style="width:80px">&nbsp;Inactive&nbsp;</span>&nbsp; <a href="#"> <i class="fa fa-toggle-on text-success" id="activestatus" aria-hidden="true" title="Activate" style="font-size:20px;"  onclick="activeDeactivate('+row.bannerid+');"></i></a></div>';
                                        }
                                        return status;
                                    },
                                    className: 'urltext text-center',
                                },
                                {
                                    data: 'bannerid',
                                    render: function(data, type, row, meta) {
                                        // return '<div class="row"><div class="col-1"><a title=<?php echo $GLOBALS['strBanner_Edit_Head']; ?> class="btn btn-icon btn-xs btn-primary" href="banner_edit.php?bannerid='+row.bannerid+'"><i class="bx bx-edit mt-0 label-primary" " style="font-size:14px"></i></a>&nbsp;<a title=<?php echo $GLOBALS['delivery_options']; ?> class="btn btn-icon btn-xs btn-primary" href="delivery_options.php?bannerid='+row.bannerid+'"><i class="fas fa-shipping-fast"></i></a>&nbsp;<a title=<?php echo $GLOBALS['linked_zones']; ?> class="btn btn-icon btn-xs btn-primary" href="linked_zones.php?bannerid='+row.bannerid+'"><i class="fas fa-link"></i></a>&nbsp;<a class="btn btn-icon btn-xs btn-danger" href="#"><i class="bx bx-trash label-Primary" style="font-size:15px;color:white;" title=<?php echo $GLOBALS['delete']; ?> onclick="deleteBanner('+row.bannerid+')"></i></a></div></div>';
                                        return '<div class="row"><div class="col-1"><a title=<?php echo $GLOBALS['strBanner_Edit_Head']; ?>  class="btn btn-icon btn-xs btn-primary" href="banner_edit.php?bannerid=' + row.bannerid + '&campaignid=' + row.campaignid + '"><i class="bx bx-edit mt-0 label-primary" " style="font-size:14px"></i></a>&nbsp;<a title=<?php echo $GLOBALS['delivery_options']; ?>  class="btn btn-icon btn-xs btn-primary" href="delivery_options.php?bannerid=' + row.bannerid + '"><i class="fas fa-shipping-fast"></i></a>&nbsp;<a  title=<?php echo $GLOBALS['linked_zones']; ?> class="btn btn-icon btn-xs btn-primary" href="linked_zones.php?bannerid=' + row.bannerid + '"><i class="fas fa-link"></i></a>&nbsp;<a class="btn btn-icon btn-xs btn-danger" href="#"><i class="bx bx-trash label-Primary" style="font-size:15px;color:white;" title=<?php echo $GLOBALS['delete']; ?> onclick="deleteBanner(' + row.bannerid + ')"></i></a></div></div>';
                                    }
                                },
                            ],
                        });
                    }
                },
                error: function() {},
            });
        }

        function activeDeactivate(bannerid) {
            // console.log("bannerid",bannerid);
            swal({
                // title: "Are you sure want to update the status?",

                title: `<?php echo $GLOBALS['update_status']; ?>`,

                buttons: true,
                dangerMode: true,
                type: "success"
            }).then(function(isConfirm) {
                if (isConfirm) {
                    $.ajax({
                        type: "POST",
                        url: activeDeactive + bannerid,
                        beforeSend: function(xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        dataType: "json",
                        encode: true,
                    }).done(function(data) {
                        console.log(data.msg);
                        console.log(bannerid);
                        // if (data.msg == "Banner Activated successfully!") {
                            if (data.msg == `<?php echo $GLOBALS['banner_activated']; ?>`) {

                            location.reload();
                            // $("#activestatus").css("color", "#696cff");
                        } else {
                            location.reload();
                            // $("#activestatus").css("color", "#777");  
                        }
                    });
                } else {
                    console.log(campaignid);
                }
            });
        };

        $(document).on('click', '#select-all', function() {
            $(".chkCountry").prop("checked", this.checked);
            document.getElementById('deleteall').disabled = ($('.chkCountry:checked').length > 0) ? false: true;
            // $("#select_count").html($("input.chkCountry:checked").length+" Selected");
        });

        $(document).on('click', '.chkCountry', function() {

            if ($('.chkCountry:checked').length > 0) {
                $("#deleteall").prop('disabled', false);
            } else {
                $("#deleteall").prop('disabled', true);
            }

            if ($('.chkCountry:checked').length == $('.chkCountry').length) {
                $('#select-all').prop('checked', true);
            } else {
                $('#select-all').prop('checked', false);
            }
            // $("#select_count").html($("input.chkCountry:checked").length+" Selected");
        });

        document.getElementById('deleteallbtn').onclick = function(e) {

            var campaigndeleteids = [];
            $(".chkCountry:checked").each(function() {
                campaigndeleteids.push($(this).attr('data-campaign-id'));
            });
            if (campaigndeleteids.length <= 0) {
                alert("Please select campaign.");
            }

            console.log(campaigndeleteids);
            swal({
                title: `<?php echo $GLOBALS['want_delete']; ?>`,
                // title: "Are you sure want to delete?",
                buttons: true,
                dangerMode: true,
                type: "success"
            }).then(function(isConfirm) {

                if (isConfirm) {
                    $.ajax({
                        type: "DELETE",
                        url: delete_url + campaigndeleteids,
                        beforeSend: function(xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        dataType: "json",
                        encode: true,
                    }).done(function(data) {
                        location.reload();
                    });
                    swal(`<?php echo $GLOBALS['banner_deleted_successfully']; ?>`);
                    // swal("Campaign deleted successfully");
                } else {
                    //swal("Campaign delete failed");
                }

            });
        }



        function deleteBanner(bannerid) {
            console.log("bannerid:", bannerid)
            // console.log("token",token)
            swal({
                title: `<?php echo $GLOBALS['want_delete']; ?>`,
                // title: "Are you sure want to delete?",
                buttons: true,
                dangerMode: true,
                type: "success"
            }).then(function(isConfirm) {
                $(".loader").show();
                if (isConfirm) {
                    $.ajax({
                        url: delete_url + bannerid,
                        type: "DELETE",
                        beforeSend: function(xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        dataType: "json",
                        encode: true,
                    }).done(function(data) {
                        swal(`<?php echo $GLOBALS['banner_deleted_successfully']; ?>`);
                        // swal("Banner Deleted Sucessfully");
                        location.reload();
                    })
                    $(".loader").hide();
                    // swal("Banner Deleted Sucessfully");

                } else {
                    swal("Banner is Not Delete");
                    $(".loader").hide();
                }
            });
        };

        document.getElementById('select-all').onclick = function() {
            var checkboxes = document.querySelectorAll('input[type="checkbox"]');
            for (var checkbox of checkboxes) {
                checkbox.checked = this.checked;
            }
        }
    </script>
</body>

</html>