<?php
// Require the initialisation file
require_once '../../../../init.php';

//Required files
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/lib/OA/Admin/Option.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';

// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN);

$title="Packet Management";
$oHeaderModel = new OA_Admin_UI_Model_PageHeaderModel($title);
phpAds_PageHeader('Packet Management', $oHeaderModel);

if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

?>

<script src="assets/js/jquery-1.12.4.js"></script>

<script src="assets/js/jquery.dataTables.min.js"></script>

<link rel="stylesheet" type="text/css" href="assets/css/jquery.dataTables.min.css" />

<script type="text/javascript">
	var jq = jQuery.noConflict();
	jq.browser = {};
	(function () {
		jq.browser.msie = false;
		jq.browser.version = 0;
		if (navigator.userAgent.match(/MSIE ([0-9]+)\./)) {
			jq.browser.msie = true;
			jq.browser.version = RegExp.$1;
		}
	})();
	jq(document).ready(function() {
			
		jq('#category_list').DataTable();
	});

	function induselect() {	 
		
		 if (jq('.cb-element:checked').length == 0){
		  jq('#selectval').prop('checked',false);
				jq('#DeleteSelection').parent().addClass( "inactive" );
		 }
		 if (jq('.cb-element:checked').length > 1){
			 jq('#selectval').prop('checked',false);
				jq('#DeleteSelection').parent().removeClass( "inactive" );
		 }
		 if (jq('.cb-element:checked').length == jq('.cb-element').length){
			jq('#selectval').prop('checked',true);
			jq('#DeleteSelection').parent().removeClass( "inactive" );		
		 }
	}
	
	function selectall(event) {
		checkboxes = document.getElementsByName('foo');
	  
		if(document.getElementById("selectval").checked)
		{
			
			jq('#DeleteSelection').parent().removeClass( "inactive" );
			
		}else
		{
			jq('#DeleteSelection').parent().addClass( "inactive" );		
		}
		
		for(var i=0, n=checkboxes.length;i<n;i++) {
		 
			checkboxes[i].checked = event.checked;
		}
	}
</script>

<style>
	.statusimage{
		width: 20px;
		height: 20px;
		padding-left: 10px;
	}
	table.dataTable.display tbody tr.odd>.sorting_1, table.dataTable.order-column.stripe tbody tr.odd>.sorting_1{
		background-color: #f9f9f9;
	}
	table.dataTable.display tbody tr.even>.sorting_1, table.dataTable.order-column.stripe tbody tr.even>.sorting_1{
		background-color: #f6f6f6
	}
	
</style>

<div style="float:right;"><a  style="display: block;width: 132px;height: 10px;
    background: #DDDCDC;
    padding: 10px;
    text-align: center;
    border-radius: 5px;
    color:#0767a8;
    font-weight: bold;"  href="packet_add.php">Add Packets</a></div>

<div style="clear:both;"></div>	

<?php

$get_category = OA_Dal_Delivery_query("SELECT * FROM packets") or die("error in get category");

if(OA_Dal_Delivery_numRows($get_category)>0)
{		
	?>
	<div class="tableWrapper">
	<div class="tableHeader">
		<ul class="tableActions">                   
			<li class="inactive activeIfSelected">	
				<a id='DeleteSelection' href=""><img src="assets/images/cross.png" width="15px" height="15px">&nbsp;Delete</a> 
				<br/>
				<script>
					jq('#DeleteSelection').click(function(event) {  
						event.preventDefault();     
						
						if (!jq(this).parents('li').hasClass('inactive')) {
							var ids = [];
						
						jq(this).parents('.tableWrapper').find("#category_list tbody tr td .cb-element:checked").each(function() {
								ids.push(this.value);
							});
							//~ alert(ids);
							window.location = 'packet_action.php?value=delete&id=' + ids.join(',');
						}					
					});
				</script>												
			</li>            
		</ul>
		<div class="clear"></div>
		<div class="corner left"></div>
		<div class="corner right"></div>		
	</div>

	<table width="100%" id="category_list" class="display">		
		<thead>
			<tr>				
				<td><input type="checkbox" id="selectval" value="multiple" onClick="selectall(this)"></td>
				<td><font size='2'><b>Packet Name</b></font></td>
				<td><font size='2'><b>Life Time</b></font></td>
				<td><font size='2'><b>Minimum. Cpm</b></font></td>
				<td><font size='2'><b>Maximum. Cpm</b></font></td>
				<td><font size='2'><b>Impression. Cpm</b></font></td>
				<td><font size='2'><b>Action</b></font></td>
			</tr>
		</thead>	
		
	<?php		
		$all_categoryid = [];	
		while($getCategory = OA_Dal_Delivery_fetchAssoc($get_category)){
	?>
			
			<tr>
				<td style="padding-left: 18px;">
					<input type="checkbox" name="foo" value="<?php echo $getCategory['id'];?>" class="cb-element" onClick="induselect()">
				</td>
				<td>
					<font size='2'><?php echo $getCategory['packetname']?></font>
				</td>
				<td>
					<font size='2'><?php echo $getCategory['lifetime']?></font>
				</td>
				<td>
					<font size='2'><?php echo $getCategory['mcpm']?></font>
				</td>
				<td>
					<font size='2'><?php echo $getCategory['mx_cpm']?></font>
				</td>
				<td>
					<font size='2'><?php echo $getCategory['imp_cpm']?></font>
				</td>
				<td>
					<font size='2'><a href="packet_edit.php?id=<?php echo $getCategory['id']?>">Edit</a>
					/
					<font size='2'><a href="packet_action.php?id=<?php echo $getCategory['id']?>&value=delete">Delete</a>
				</td> 
			</tr>
	<?php 
			$all_categoryid[] = $getCategory['id'];			
			$i++;
		}
	?>
			<input type ="hidden" id ="allcategoryid" name="allcategory" value="<?php echo $all_categoryid; ?>">
		</table>
	<?php
}	
else
{?>
	<div class="errormessage">
		Currently there are No Category available.</div><?php
}
?>
</div>

<?php
/*-------------------------------------------------------*/
/* HTML framework                                        */
/*-------------------------------------------------------*/
phpAds_PageFooter();

?>
