<?php

ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

$path = dirname(__FILE__);
require_once $path . '/../../init.php';

use PHPMailer\PHPMailer\PHPMailer; 
use PHPMailer\PHPMailer\Exception;

require_once 'PHPMailer/src/Exception.php';
require_once 'PHPMailer/src/PHPMailer.php';
require_once 'PHPMailer/src/SMTP.php';


$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

if (!function_exists('OX_Delivery_logMessage()')) 
{
    function OX_Delivery_logMessage()
    {
        return true;
    }
}

OA_Dal_Delivery_query("ALTER TABLE rv_banners ADD COLUMN daily_cron INT");

$djprotocol = $GLOBALS['_MAX']['SSL_REQUEST'] ? 'https://' :'http://';

$start_date = date('Y-m-d 00:00:00');
$end_date   = date('Y-m-d 23:59:59');

$SendMail = array();

$sql=OA_Dal_Delivery_query("SELECT b.bannerid, b.daily_mail AS email FROM ".$table_prefix."clients AS c JOIN ".$table_prefix."campaigns AS ca ON c.clientid=ca.clientid JOIN ".$table_prefix."banners AS b ON ca.campaignid=b.campaignid WHERE b.daily_cron = 1 GROUP BY b.bannerid");
while($rowbanid = OA_Dal_Delivery_fetchAssoc($sql))	
{
	$bannerid     = $rowbanid['bannerid'];
	$sendMail	  = $rowbanid['email'];
		
	if(!empty($sendMail))
	{	
		$SendMail[$bannerid] = explode(",",$sendMail);
	}

	$name = 'WilliWay';
	$filename = '';
	$storagetype = '';
	$Banner = OA_Dal_Delivery_query("SELECT description AS name, filename, imageurl, bannertext, contenttype, storagetype FROM ".$table_prefix."banners WHERE bannerid = '".$bannerid."' ") or die("error1");
	if(OA_Dal_Delivery_numRows($Banner) > 0 ) 
	{	
		$row = OA_Dal_Delivery_fetchAssoc($Banner);
		$name 		 = $row['name'];
		$filename    = $row['filename'];
		$storagetype = $row['storagetype'];
		$contenttype = $row['contenttype'];
		$imageurl    = $row['imageurl'];
		$bannertext  = $row['bannertext'];
	}

	$bannerType = 0;
	if($storagetype =='web')
	{
		$ImgPath = $djprotocol . $GLOBALS['_MAX']['CONF']['webpath']['imagesSSL'].'/';   

		$imgSrc = $ImgPath.$filename;
		$bannerType = 1;
	}
	else if($storagetype =='sql')
	{
		$ImgPath = $djprotocol . $GLOBALS['_MAX']['CONF']['webpath']['deliverySSL'].'/ai.php?filename=';   

		$imgSrc = $ImgPath.$filename.'&contenttype='.$contenttype;
		$bannerType = 1;
	}
	else if($storagetype =='url')
	{
		$imgSrc = $imageurl;
		$bannerType = 1;
	}
	else if($storagetype =='txt')
	{
		$imgSrc = $bannertext;
		$bannerType = 2;
	}			

	$PeriodStart= date("d-m-Y", strtotime($start_date));  
	$PeriodEnd= date("d-m-Y", strtotime($end_date)); 

	$subject = 'Banner-Bericht';

	$message = '<html>
	<body style="background-color: #64B5F6;">
		<div class="container text-center" style="background-color: #64B5F6;">
			<table class="table table-striped" style="width: 100%;background-color: #64B5F6;">
				<tr>
					<td width="20%"></td>
					<td width="20%"></td>
					<td width="20%"><img src="'.OX::assetPath ().'/images/logosswiss.jpg" style="width:300px;"></td>
					<td width="20%"></td>
					<td width="20%"></td>
				</tr>
			</table>
			<table class="table table-striped" style="width: 100%;background-color: #64B5F6;">
				<tr>
					<td width="30%">
						<h1 style="color:#fff;font-size: 36px;font-weight: bold;text-align: left;">Kampagnen&#252;bersicht</h1>
						<p style="color:#fff;font-size: 30px;font-weight: bold;text-align: left;">'.$name.'</p>
					</td>
					<td width="20%"></td>
					<td width="20%"></td>
					<td width="30%">
						<div style="background-color: white;padding: 5px;border-radius: 10px;">
							<p style="color:#87BFF1;font-size: 24px;font-weight: bold;text-align: center;margin: 2px;">'.$PeriodStart.' - '.$PeriodEnd.'</p>
						</div>
					</td>
				</tr>
			</table>
			<table class="table table-striped" style="width: 100%;background-color: #64B5F6;">
				<tr>
					<td width="100%">';
					
					if($bannerType == 1)
					{
						$message .= '<img src="'.$imgSrc.'" style="height:250px;width:60%;display: block;margin-left: auto;margin-right: auto;">';
					}
					else if($bannerType == 2)
					{
						$message .= '<div class="bannercode">'.$imgSrc.'</div>';
					}
					
					$message .= '</td></tr>
					<tr>
					<td width="100%">
						<div style="">
							<h1 style="color:#000;font-size: 36px;font-weight: bold;padding:8px;display: inline-block;background-color: #FFF;-webkit-box-shadow: 0 10px 8px -6px black;-moz-box-shadow: 0 10px 8px -6px black;box-shadow: 0 10px 8px -6px black;text-align: left;">Luzerner Rundschau</h1></div>';

						$Report1 = OA_Dal_Delivery_query("SELECT DATE(date_time) as date_time, sum(impressions) as impressions, sum(clicks) as clicks FROM ".$table_prefix."data_summary_ad_hourly WHERE date_time>='".$start_date."' and date_time<='".$end_date."' AND ad_id = '{$bannerid}' AND zone_id != 0 GROUP BY DATE(date_time) ORDER BY date_time ASC") or die("adid error1");
						
							if(OA_Dal_Delivery_numRows($Report1) > 0 ) 
							{								
								$message .= '<h1 style="color:#fff;font-size: 26px;font-weight: bold;text-align: left;">Anzeigenimpression</h1>
								<table class="table1" style="background-color:#fff;width: 100%;">';
																		
								$totalimp = 0;
								$totalclk = 0;
								$totalctr = 0;

								$i =1;
								
								while($row1 = OA_Dal_Delivery_fetchAssoc($Report1))
								{
									if($i == 1) 
									{
										$_class = "odd hilite";

										$CSS = 'border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;background-color: #f2f2f2 !important;';
									} 
									elseif($i%2 == 0) 
									{
										$_class = "even";

										$CSS = '';
									} 
									else 
									{
										$_class = "odd";

										$CSS = 'border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;background-color: #f2f2f2 !important;';

									}
									$i++;
									$CTR = 0;
									if(!empty($row1['impressions']) && !empty($row1['clicks']))
									{
										$CTR = number_format((($row1['clicks'] / $row1['impressions']) * 100),2).'%';
									}
									$clicks = $row1['clicks'] ? $row1['clicks'] : '-';						
									$ctr = $CTR ? $CTR : '-';
									$message .= '
										<tr style="'.$CSS.'">
											<td>'.date("d.m.Y", strtotime($row1['date_time'])).'</td>
											<td>'.$row1['impressions'].'</td>
											<td>'.$clicks.'</td>
											<td>'.$ctr.'</td>
										</tr>';


									$totalimp += $row1['impressions'];
									$totalclk += $row1['clicks'];
									$totalctr += $CTR;
								}

								$totalimp = $totalimp ? $totalimp : '-';
								$totalclk = $totalclk ? $totalclk : '-';
								
								$totalctr = number_format((($totalclk / $totalimp) * 100),2);
								$totalctr = $totalctr ? $totalctr.'%' : '-';
								
								$message .= '<tr>
									<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;background-color: #f2f2f2 !important;"></td>
									<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;background-color: #f2f2f2 !important;"><b>Impr.</b></td>
									<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;background-color: #f2f2f2 !important;"><b>Clicks</b></td>
									<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;background-color: #f2f2f2 !important;"><b>CTR</b></td>
								</tr>';


								$message .= '<tr>
									<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;"><b>Summe</b></td>
									<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;">'.$totalimp.'</td>
									<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;">'.$totalclk.'</td>
									<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;">'.$totalctr.'</td>
								</tr>';	
								
								$message .= '</table>';
							}		

						$Report2 = OA_Dal_Delivery_query("SELECT DATE(date_time) as date_time, sum(impressions) as impressions, sum(clicks) as clicks FROM ".$table_prefix."data_summary_ad_hourly WHERE date_time>='".$start_date."' and date_time<='".$end_date."' AND ad_id ='{$bannerid}' AND zone_id = 0 GROUP BY DATE(date_time) ORDER BY date_time ASC") or die("error1");			
							if(OA_Dal_Delivery_numRows($Report2) > 0 ) 
							{								
								$message .= '<h1 style="color:#fff;font-size: 26px;font-weight: bold;text-align: left;">Anzeigenimpression</h1>
								<table class="table2" style="background-color: #fff;width: 100%;">';
								
								$i =1;

								$totalimp2 = 0;
								$totalclk2 = 0;
								$totalctr2 = 0;

								while($row2 = OA_Dal_Delivery_fetchAssoc($Report2))
								{
									if($i == 1) 
									{
										$_class = "odd hilite";

										$CSS = 'border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;background-color: #f2f2f2 !important;';
									} 
									elseif($i%2 == 0) 
									{
										$_class = "even";

										$CSS = '';
									} 
									else 
									{
										$_class = "odd";

										$CSS = 'border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;background-color: #f2f2f2 !important;';
									}
									$i++;
									$CTR = 0;
									if(!empty($row2['impressions']) && !empty($row2['clicks']))
									{
										$CTR = number_format((($row2['clicks'] / $row2['impressions']) * 100),2).'%';
									}
									$clicks = $row2['clicks'] ? $row2['clicks'] : '-';						
									$ctr = $CTR ? $CTR : '-';
									$message .= '
										<tr style="'.$CSS.'">
											<td>'.date("d.m.Y", strtotime($row2['date_time'])).'</td>
											<td>'.$row2['impressions'].'</td>
											<td>'.$clicks.'</td>
											<td>'.$ctr.'</td>
										</tr>';


									$totalimp2 += $row2['impressions'];
									$totalclk2 += $row2['clicks'];
									$totalctr2 += $CTR;
								}

								$totalimp2 = $totalimp2 ? $totalimp2 : '-';
								$totalclk2 = $totalclk2 ? $totalclk2 : '-';
								$totalctr2 = number_format((($totalclk2 / $totalimp2) * 100),2);
								$totalctr2 = $totalctr2 ? $totalctr2.'%' : '-';

								$message .= '<tr>
									<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;background-color: #f2f2f2 !important;"></td>
									<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;background-color: #f2f2f2 !important;"><b>Impr.</b></td>
									<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;background-color: #f2f2f2 !important;"><b>Clicks</b></td>
									<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;background-color: #f2f2f2 !important;"><b>CTR</b></td>
								</tr>';

								$message .= '<tr>
									<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;"><b>Summe</b></td>
									<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;">'.$totalimp2.'</td>
									<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;">'.$totalclk2.'</td>
									<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;">'.$totalctr2.'</td>
								</tr>';	
								
								$message .= '</table>';

							}		
							
					$message .= '</td>
					<td width="15%"></td>
				</tr>
			</table>
		</div>
	</body>
	</html>';
	
	OA_Dal_Delivery_query("ALTER TABLE rv_banners ADD COLUMN daily_mail VARCHAR(255)");


	$testsql = OA_Dal_Delivery_query("SELECT sum(impressions) as testimp,ad_id FROM rv_data_summary_ad_hourly WHERE ad_id=".$bannerid." and date_time>='".$start_date."' and date_time<='".$end_date."' GROUP BY ad_id");
	$rowbanid2 = OA_Dal_Delivery_fetchAssoc($testsql);
	if($rowbanid2['testimp']>0)
	{	
		$email = new PHPMailer();
		$email->IsSMTP();
		$email->SMTPDebug = 0;
		$email->SMTPAuth = true;
		$email->SMTPSecure = 'ssl';
		$email->Host = "smtp.gmail.com";
		$email->Port = 465;
		$email->IsHTML(true);
		$email->Username = 'backend.developer2020@gmail.com';
		$email->Password = 'ujxlvdbjadzhjcpx';
		$email->setFrom("backend.developer2020@gmail.com", "Ecrome Admin");	
		//die();
		if(!empty($SendMail[$bannerid])) 
		{	
			foreach ($SendMail[$bannerid] as $key => $val) 
			{
				//$email->addAddress($val);
			}
		}
		$email->Subject = $subject;
		$email->Body = $message;
		$mail = $email->send();
	}
	else
	{
		echo "End";
	}
}

?>
