<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file
require_once '../../init.php';

// Required files
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/lib/OA/Dal.php';

if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

// Register input variables
phpAds_registerGlobalUnslashed('prepend', 'append', 'submitbutton');

// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_MANAGER);
OA_Permission::enforceAccessToObject('clients',   $clientid);
OA_Permission::enforceAccessToObject('campaigns', $campaignid);
OA_Permission::enforceAccessToObject('banners',   $bannerid);


/*-------------------------------------------------------*/
/* Store preferences									 */
/*-------------------------------------------------------*/
$session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['clientid'] = $clientid;
$session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['campaignid'][$clientid] = $campaignid;
phpAds_SessionDataStore();

/*-------------------------------------------------------*/
/* Process submitted form                                */
/*-------------------------------------------------------*/

if (isset($submitbutton)) {
    OA_Permission::checkSessionToken();

    // Update banner
    $doBanners = OA_Dal::factoryDO('banners');
    $doBanners->get($bannerid);
    $doBanners->prepend = $prepend;
    $doBanners->append  = $append;
    $doBanners->update();

    // Queue confirmation message
    $translation = new OX_Translation();
    $translated_message = $translation->translate($GLOBALS['strBannerAdvancedHasBeenUpdated'], array(
        MAX::constructURL(MAX_URL_ADMIN, 'banner-edit.php?clientid=' .  $clientid . '&campaignid=' . $campaignid . '&bannerid=' . $bannerid),
        htmlspecialchars($doBanners->description)
    ));

    OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);

    header ("Location: banner-advanced.php?clientid=".$clientid."&campaignid=".$campaignid."&bannerid=".$bannerid);
    exit;
}

/*-------------------------------------------------------*/
/* HTML framework                                        */
/*-------------------------------------------------------*/

// Initialise some parameters
$pageName = basename($_SERVER['SCRIPT_NAME']);
$tabindex = 1;
$agencyId = OA_Permission::getAgencyId();
$aEntities = array('clientid' => $clientid, 'campaignid' => $campaignid, 'bannerid' => $bannerid);

// Display navigation
$aOtherCampaigns = Admin_DA::getPlacements(array('agency_id' => $agencyId));
$aOtherBanners = Admin_DA::getAds(array('placement_id' => $campaignid), false);
MAX_displayNavigationBanner($pageName, $aOtherCampaigns, $aOtherBanners, $aEntities);

/*-------------------------------------------------------*/
/* Main code                                             */
/*-------------------------------------------------------*/

$doBanners = OA_Dal::factoryDO('banners');
$doBanners->selectAdd('storagetype AS type');
$doBanners->bannerid = $bannerid;
if ($doBanners->find(true)) {
    $banner = $doBanners->toArray();
}

$tabindex = 1;

    echo "<form name='appendform' method='post' action='banner-advanced.php' onSubmit='return phpAds_formSubmit() && max_formValidate(this);'>";
    echo "<input type='hidden' name='clientid' value='".(isset($clientid) && $clientid != '' ? $clientid : '')."'>";
    echo "<input type='hidden' name='campaignid' value='".(isset($campaignid) && $campaignid != '' ? $campaignid : '')."'>";
    echo "<input type='hidden' name='bannerid' value='".(isset($bannerid) && $bannerid != '' ? $bannerid : '')."'>";
    echo "<input type='hidden' name='token' value='".htmlspecialchars(phpAds_SessionGetToken(), ENT_QUOTES)."'>";

    echo "<br /><table border='0' width='100%' cellpadding='0' cellspacing='0'>";
   // echo "<tr><td height='25' colspan='3'><b>AD Tag</b></td></tr>";
    //~ echo "<tr height='1'><td width='30'><img src='" . OX::assetPath() . "/images/break.gif' height='1' width='30'></td>";
    //~ echo "<td width='200'><img src='" . OX::assetPath() . "/images/break.gif' height='1' width='200'></td>";
    //~ echo "<td width='100%'><img src='" . OX::assetPath() . "/images/break.gif' height='1' width='100%'></td></tr>";
    //~ echo "<tr><td height='10' colspan='3'>&nbsp;</td></tr>";

    //~ echo "<tr><td width='30'>&nbsp;</td><td width='200' valign='top'>".$strBannerPrependHTML."</td><td>";
    //~ echo "<textarea class='code' name='prepend' rows='6' cols='55' style='width: 100%;' tabindex='".($tabindex++)."'>".htmlspecialchars($banner['prepend'])."</textarea>";
    //~ echo "</td></tr>";
    $urlcampaignid = $_GET['campaignid'];
    $urlbannerid = $_GET['bannerid'];
    
    $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

    $ext_bannertype = '';
    $Banner = OA_Dal_Delivery_query("SELECT ext_bannertype FROM ".$table_prefix."banners WHERE bannerid = '".$_GET['bannerid']."'") or die("banners error1");
	if(OA_Dal_Delivery_numRows($Banner) > 0 ) 
	{	
		$row = OA_Dal_Delivery_fetchAssoc($Banner);
		$ext_bannertype = $row['ext_bannertype'];
	}
    if($ext_bannertype == 'bannerTypeHtml:VideoAds:Videoads')
    {		
		$conf = $GLOBALS['_MAX']['CONF'];
		$way=$conf['webpath']['admin'].'/plugins/VideoAds/delivery/videoads.php';
		$buffer  = "<script type='text/javascript'><!--//<![CDATA[\n";
		$buffer .= "   var adurl = (location.protocol=='https:'?'https://$way':'http://$way');\n";
		$buffer .= "   document.write (\"<\" + \"script language='JavaScript' \");\n";
		$buffer .= "   document.write (\"type='text/javascript' src='\"+adurl);\n";
		$buffer .= "   document.write (\"?campaignid=".$urlcampaignid."&what=".$urlbannerid."\");\n";
		$buffer .= "   document.write (\"&amp;loc=\" + escape(window.location));\n";
		$buffer .= "   if (document.referrer) document.write (\"&amp;referer=\" + escape(document.referrer));\n";
		$buffer .= "   document.write (\"&amp;display_width=\" + window.innerWidth);\n";
		$buffer .= "   document.write (\"'><\\/scr\"+\"ipt>\");\n";
		$buffer .= "//]]>--></script>"; 				
	}
	else
	{
		$buffer .= "<script type='text/javascript'><!--//<![CDATA[\n";
		$buffer .= "   var m3_u = (location.protocol=='https:'?'https:".MAX_commonConstructPartialDeliveryUrl($conf['file']['js'], true)."':'http:".MAX_commonConstructPartialDeliveryUrl($conf['file']['js'])."');\n";
		$buffer .= "   var m3_r = Math.floor(Math.random()*99999999999);\n";
		$buffer .= "  if (!document.MAX_used) document.MAX_used = ',';\n";
		$buffer .="   document.write (\"<scr\"+\"ipt type='text/javascript' src='\"+m3_u);\n\n";
		$buffer .="     document.write (\"?campaignid=".$urlcampaignid."&what=".$urlbannerid."\");\n";
		$buffer .= "   document.write ('&amp;cb=' + m3_r);\n ";
		
		
		$buffer .= "   document.write ('&amp;ct0="."$"."{CLICK_URL_ENC}');\n ";
		
		// Don't pass in exclude unless necessary
		$buffer .= "   if (document.MAX_used != ',') document.write (\"&amp;exclude=\" + document.MAX_used);\n";

		if (empty($mi->charset)) {
			$buffer .= "   document.write (document.charset ? '&amp;charset='+document.charset : (document.characterSet ? '&amp;charset='+document.characterSet : ''));\n";
		} else {
			$buffer .= "   document.write ('&amp;charset=" . $mi->charset . "');\n";
		}
		$buffer .= "   document.write (\"&amp;loc=\" + escape(window.location));\n";
		$buffer .= "   if (document.referrer) document.write (\"&amp;referer=\" + escape(document.referrer));\n";
		$buffer .= "   if (document.context) document.write (\"&context=\" + escape(document.context));\n";


		$buffer .= "   document.write (\"'><\\/scr\"+\"ipt>\");\n";
		$buffer .= "//]]>--></script>";
		$buffer .="<noscript><a href='http://dev.djaxbidder.com/inbanner_video/www/delivery/ck.php?n=a22d9ab1&amp;cb=''{CACHEBUSTER}' target='_blank'><img src='http://dev.djaxbidder.com/inbanner_video/www/delivery/avw.php?zoneid=2&amp;cb={CACHEBUSTER}&amp;n=a22d9ab1' border='0' alt='' /></a></noscript>";
	}
        
echo "<tr><td><img src='" . OX::assetPath() . "/images/spacer.gif' height='1' width='100%'></td>";
    echo "<td colspan='2'><img src='" . OX::assetPath() . "/images/break-l.gif' height='1' width='200' vspace='6'></td>";

    echo "<tr>";
    echo "<textarea class='code' id='bannercode' name='append' rows='6' cols='55' style='width: 100%;' tabindex='".($tabindex++)."'>".$buffer."
    </textarea>";
    echo "</td></tr>";

    // Footer
    echo "<tr><td height='10' colspan='3'>&nbsp;</td></tr>";
    echo "<tr height='1'><td colspan='3' bgcolor='#888888'><img src='" . OX::assetPath() . "/images/break.gif' height='1' width='100%'></td></tr>";
    echo "</table><br />";

   // echo "<br /><input type='submit' name='submitbutton' value='".$strSaveChanges."' tabindex='".($tabindex++)."'>";
    echo "</form>";
    
	echo "
	<script type='text/javascript'>
		<!--
			$(document).ready(function() {
				$('#bannercode').selectText();
			});
		//-->
	</script>";

/*-------------------------------------------------------*/
/* HTML framework                                        */
/*-------------------------------------------------------*/

phpAds_PageFooter();

?>
