<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/


// Require the initialisation file
	//DAC102 - Connect DB
   require_once '../../init.php';
 
 if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}
 //DAC102 - Connect DB

// Required files
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/lib/OA/Creative/File.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/lib/max/other/common.php';
require_once MAX_PATH . '/lib/max/other/html.php';
require_once MAX_PATH . '/lib/OA/Admin/UI/component/Form.php';
require_once MAX_PATH . '/lib/OA/Maintenance/Priority.php';

require_once LIB_PATH . '/Plugin/Component.php';

$htmltemplate = MAX_commonGetValueUnslashed('htmltemplate');

// Register input variables
phpAds_registerGlobalUnslashed(
     'alink'
    ,'alink_chosen'
    ,'alt'
    ,'alt_imageurl'
    ,'asource'
    ,'atar'
    ,'adserver'
    ,'bannertext'
    ,'campaignid'
    ,'clientid'
    ,'comments'
    ,'description'
    ,'ext_bannertype'
    ,'height'
    ,'imageurl'
    ,'keyword'
    ,'message'
    ,'replaceimage'
    ,'replacealtimage'
    ,'status'
    ,'statustext'
    ,'type'
    ,'submit'
    ,'target'
    ,'transparent'
    ,'upload'
    ,'url'
    ,'weight'
    ,'width'
    ,'customid'
    ,'advertiserid'
    ,'api_description'
    ,'xandrcreativeid'
    ,'goaltarget'
    ,'goalthreshold'
);

/*-------------------------------------------------------*/
/* Client interface security                             */
/*-------------------------------------------------------*/
OA_Permission::enforceAccount(OA_ACCOUNT_MANAGER, OA_ACCOUNT_ADVERTISER);
OA_Permission::enforceAccessToObject('clients',   $clientid);
OA_Permission::enforceAccessToObject('campaigns', $campaignid);

if (OA_Permission::isAccount(OA_ACCOUNT_ADVERTISER)) {
    OA_Permission::enforceAllowed(OA_PERM_BANNER_EDIT);
    OA_Permission::enforceAccessToObject('banners', $bannerid);
} else {
    OA_Permission::enforceAccessToObject('banners', $bannerid, true);
}


/*-------------------------------------------------------*/
/* Store preferences									 */
/*-------------------------------------------------------*/
$session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['clientid'] = $clientid;
$session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['campaignid'][$clientid] = $campaignid;
phpAds_SessionDataStore();

/*-------------------------------------------------------*/
/* HTML framework                                        */
/*-------------------------------------------------------*/

// Decide whether this is add or edit, get banner data or initialise it
if ($bannerid != '') {
    // Fetch the data from the database
    $doBanners = OA_Dal::factoryDO('banners');
    if ($doBanners->get($bannerid)) {
        $aBanner = $doBanners->toArray();
    }

    // Set basic values
    $type               = $aBanner['storagetype'];
    $ext_bannertype     = $aBanner['ext_bannertype'];

    if (empty($ext_bannertype)) {
        if ($type == 'html') {
            $ext_bannertype = 'bannerTypeHtml:oxHtml:genericHtml';
        } elseif ($type == 'txt') {
            $ext_bannertype = 'bannerTypeText:oxText:genericText';
        }
    }
    if (!empty($aBanner['filename'])) {
        $aBanner['replaceimage'] = "f"; //select keep image by default
    }

    $aBanner['clientid']   = $clientid;

}
else {
    // Set default values for new banner
    $aBanner['bannerid']     = '';
    $aBanner['campaignid']   = $campaignid;
    $aBanner['clientid']     = $clientid;
    $aBanner['alt']          = '';
    $aBanner['status']       = '';
    $aBanner['bannertext']   = '';
    $aBanner['url']          = "http://";
    $aBanner['target']       = '';
    $aBanner['imageurl']     = "http://";
    $aBanner['width']        = '';
    $aBanner['height']       = '';
    $aBanner['htmltemplate'] = '';
    $aBanner['description']  = '';
    $aBanner['comments']     = '';
    $aBanner['contenttype']  = '';
    $aBanner['adserver']     = 'none';
    $aBanner['keyword']      = '';
    $aBanner["weight"]       = $pref['default_banner_weight'];
    $aBanner['customid']        = '';
    $aBanner['advertiserid']    = '';
    $aBanner['api_description'] = '';
    $aBanner['xandrcreativeid'] = '';
    $aBanner['goaltarget'] = '';
    $aBanner['goalthreshold'] = '';

    $aBanner['iframe_friendly'] = true;
}
if ($ext_bannertype)
{
    $oComponent = OX_Component::factoryByComponentIdentifier($ext_bannertype);
    //  we may want to use the ancestor class for some sort of generic functionality
    if (!$oComponent)
    {
        $oComponent = OX_Component::getFallbackHandler($extension);
    }
    $formDisabled = (!$oComponent || !$oComponent->enabled);
}
if ((!$ext_bannertype) && $type && (!in_array($type, array('sql','web','url','html','txt'))))
{
    $oComponent = OX_Component::factoryByComponentIdentifier($type);
    $formDisabled = (!$oComponent || !$oComponent->enabled);
    if ($oComponent)
    {
        $ext_bannertype = $type;
        $type = $oComponent->getStorageType();
    }
    else
    {
        $ext_bannertype = '';
        $type = '';
    }
}


// If adding a new banner or used storing type is disabled
// determine which bannertype to show as default
$show_sql   = $conf['allowedBanners']['sql'];
$show_web   = $conf['allowedBanners']['web'];
$show_url   = $conf['allowedBanners']['url'];
$show_html  = $conf['allowedBanners']['html'];
$show_txt   = $conf['allowedBanners']['text'];

if (isset($type) && $type == "sql")      $show_sql     = true;
if (isset($type) && $type == "web")      $show_web     = true;
if (isset($type) && $type == "url")      $show_url     = true;
if (isset($type) && $type == "html")     $show_html    = true;
if (isset($type) && $type == "txt")      $show_txt     = true;

$bannerTypes = array();
if ($show_web) {
    $bannerTypes['web']['web'] = $GLOBALS['strWebBanner'];
}
if ($show_sql) {
    $bannerTypes['sql']['sql'] = $GLOBALS['strMySQLBanner'];
}
if ($show_url) {
    $bannerTypes['url']['url']= $GLOBALS['strURLBanner'];
}
if ($show_html) {
    $aBannerTypeHtml = OX_Component::getComponents('bannerTypeHtml');
    foreach ($aBannerTypeHtml AS $tmpComponent)
    {
        $componentIdentifier = $tmpComponent->getComponentIdentifier();
        $bannerTypes['html'][$componentIdentifier] = $tmpComponent->getOptionDescription();
    }
}
if ($show_txt) {
    $aBannerTypeText = OX_Component::getComponents('bannerTypeText');
    foreach ($aBannerTypeText AS $tmpComponent)
    {
        $componentIdentifier = $tmpComponent->getComponentIdentifier();
        $bannerTypes['text'][$componentIdentifier] = $tmpComponent->getOptionDescription();
    }
}

if (!$type)
{
    if ($show_txt)     $type = "txt";
    if ($show_html)    $type = "html";
    if ($show_url)     $type = "url";
    if ($show_sql)     $type = "sql";
    if ($show_web)     $type = "web";
}

// Build banner form
$form = buildBannerForm($type, $aBanner, $oComponent, $formDisabled);

$valid = $form->validate();
if ($valid && $oComponent && $oComponent->enabled)
{
    $valid = $oComponent->validateForm($form);
}
if ($valid)
{
    //process submitted values
    processForm($bannerid, $form, $oComponent, $formDisabled);
}
else { //either validation failed or form was not submitted, display the form
    displayPage($bannerid, $campaignid, $clientid, $bannerTypes, $aBanner, $type, $form, $ext_bannertype, $formDisabled);
}



function displayPage($bannerid, $campaignid, $clientid, $bannerTypes, $aBanner, $type, $form, $ext_bannertype, $formDisabled=false)
{
    // Initialise some parameters
    $pageName = basename($_SERVER['SCRIPT_NAME']);
    $aEntities = array('clientid' => $clientid, 'campaignid' => $campaignid, 'bannerid' => $bannerid);

    $entityId = OA_Permission::getEntityId();
    if (OA_Permission::isAccount(OA_ACCOUNT_ADVERTISER)) {
        $entityType = 'advertiser_id';
    } else {
        $entityType = 'agency_id';
    }

    // Display navigation
    $aOtherCampaigns = Admin_DA::getPlacements(array($entityType => $entityId));
    $aOtherBanners = Admin_DA::getAds(array('placement_id' => $campaignid), false);

    // Display banner preview
    MAX_displayNavigationBanner($pageName, $aOtherCampaigns, $aOtherBanners, $aEntities);

    //actual page content - type chooser and form
    /*-------------------------------------------------------*/
    /* Main code                                             */
    /*-------------------------------------------------------*/
    $oTpl = new OA_Admin_Template('banner-edit.html');

    $oTpl->assign('clientId',  $clientid);
    $oTpl->assign('campaignId',  $campaignid);
    $oTpl->assign('bannerId',  $bannerid);
    $oTpl->assign('bannerTypes', $bannerTypes);
    $oTpl->assign('bannerType', ($ext_bannertype ? $ext_bannertype : $type));
    $oTpl->assign('bannerHeight', $aBanner["height"]);
    $oTpl->assign('bannerWidth', $aBanner["width"]);
    $oTpl->assign('disabled', $formDisabled);
    $oTpl->assign('form', $form->serialize());


    $oTpl->display();

    /*********************************************************/
    /* HTML framework                                        */
    /*********************************************************/
    phpAds_PageFooter();
}


function buildBannerForm($type, $aBanner, &$oComponent=null, $formDisabled=false)
{
    //-- Build forms
    $form = new OA_Admin_UI_Component_Form("bannerForm", "POST", $_SERVER['SCRIPT_NAME'], null, array("enctype"=>"multipart/form-data"));
    $form->forceClientValidation(true);
    $form->addElement('hidden', 'clientid', $aBanner['clientid']);
    $form->addElement('hidden', 'campaignid', $aBanner['campaignid']);
    $form->addElement('hidden', 'bannerid', $aBanner['bannerid']);
    $form->addElement('hidden', 'type', $type);
    $form->addElement('hidden', 'status', $aBanner['status']);
$form->addElement('text', 'start_duration', $GLOBALS['duration_start']);
    $form->addElement('text', 'end_duration', $GLOBALS['duration_end']);
    $form->addElement('hidden', 'xandrId', $aBanner['xandrcreativeid']);

    if ($type == 'sql' || $type == 'web') {
        $form->addElement('custom', 'banner-iab-note', null, null);
    }

    $form->addElement('header', 'header_basic', $GLOBALS['strBasicInformation']);
    if (OA_Permission::isAccount(OA_ACCOUNT_ADMIN) || OA_Permission::isAccount(OA_ACCOUNT_MANAGER)) {
        $form->addElement('text', 'description', $GLOBALS['strName']);
    }
    else {
        $form->addElement('static', 'description', $GLOBALS['strName'], $aBanner['description']);
    }

    //local banners
    if ($type == 'sql' || $type == 'web') {
        if ($type == 'sql') {
            $header = $form->createElement('header', 'header_sql', $GLOBALS['strMySQLBanner']." -  banner creative");
        }
        else {
            $header = $form->createElement('header', 'header_sql', $GLOBALS['strWebBanner']." -  banner creative");
        }
        $header->setAttribute('icon', 'icon-banner-stored.gif');
        $form->addElement($header);

        $imageName = _getContentTypeIconImageName($aBanner['contenttype']);
        $size = _getBannerSizeText($type, $aBanner['filename']);

        addUploadGroup($form, $aBanner,
            array(
                'uploadName' => 'upload',
                'radioName' => 'replaceimage',
                'imageName'  => $imageName,
                'fileName'  => $aBanner['filename'],
                'fileSize'  => $size,
                'newLabel'  => $GLOBALS['strNewBannerFile'],
                'updateLabel'  => $GLOBALS['strUploadOrKeep'],
              )
        );

        $form->addElement('header', 'header_b_links', "Banner link");
        $form->addElement('text', 'url', $GLOBALS['strURL']);
        $targetElem = $form->createElement('text', 'target', $GLOBALS['strTarget']);
        $targetElem->setAttribute('maxlength', '16');
        $form->addElement($targetElem);

        $form->addElement('header', 'header_b_display', 'Banner display');
        $form->addElement('text', 'alt', $GLOBALS['strAlt']);
        $form->addElement('text', 'statustext', $GLOBALS['strStatusText']);
        $form->addElement('text', 'bannertext', $GLOBALS['strTextBelow']);

        if (!empty($aBanner['bannerid'])) {
            $sizeG['width'] = $form->createElement('text', 'width', $GLOBALS['strWidth'].":");
            $sizeG['width']->setAttribute('onChange', 'oa_sizeChangeUpdateMessage("warning_change_banner_size");');
            $sizeG['width']->setSize(5);

            $sizeG['height'] = $form->createElement('text', 'height', $GLOBALS['strHeight'].":");
            $sizeG['height']->setAttribute('onChange', 'oa_sizeChangeUpdateMessage("warning_change_banner_size");');
            $sizeG['height']->setSize(5);
            $form->addGroup($sizeG, 'size', $GLOBALS['strSize'], "&nbsp;", false);

            //validation rules
            $translation = new OX_Translation();
            $widthRequiredRule = array($translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strWidth'])), 'required');
            $widthPositiveRule = array($translation->translate($GLOBALS['strXGreaterThanZeroField'], array($GLOBALS['strWidth'])), 'min', 1);
            $heightRequiredRule = array($translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strHeight'])), 'required');
            $heightPositiveRule = array($translation->translate($GLOBALS['strXGreaterThanZeroField'], array($GLOBALS['strHeight'])), 'min', 1);
            $numericRule = array($GLOBALS['strNumericField'] , 'numeric');

            $form->addGroupRule('size', array(
                'width' => array($widthRequiredRule, $numericRule, $widthPositiveRule),
                'height' => array($heightRequiredRule, $numericRule, $heightPositiveRule)));
        }

        //TODO $form->addRule("size", 'Please enter a number', 'numeric'); //this should make all fields in group size are numeric
    }

    //external banners
    if ($type == "url") {
        $header = $form->createElement('header', 'header_txt', $GLOBALS['strURLBanner']);
        $header->setAttribute('icon', 'icon-banner-url.gif');
        $form->addElement($header);

        $form->addElement('text', 'imageurl', $GLOBALS['strNewBannerURL']);

        $form->addElement('header', 'header_b_links', "Banner link");
        $form->addElement('text', 'url', $GLOBALS['strURL']);
        $targetElem = $form->createElement('text', 'target', $GLOBALS['strTarget']);
        $targetElem->setAttribute('maxlength', '16');
        $form->addElement($targetElem);

        $form->addElement('header', 'header_b_display', 'Banner display');
        $form->addElement('text', 'alt', $GLOBALS['strAlt']);

        $form->addElement('text', 'statustext', $GLOBALS['strStatusText']);
        $form->addElement('text', 'bannertext', $GLOBALS['strTextBelow']);

        $sizeG['width'] = $form->createElement('text', 'width', $GLOBALS['strWidth'].":");
        $sizeG['width']->setAttribute('onChange', 'oa_sizeChangeUpdateMessage("warning_change_banner_size");');
        $sizeG['width']->setSize(5);

        $sizeG['height'] = $form->createElement('text', 'height', $GLOBALS['strHeight'].":");
        $sizeG['height']->setAttribute('onChange', 'oa_sizeChangeUpdateMessage("warning_change_banner_size");');
        $sizeG['height']->setSize(5);
        $form->addGroup($sizeG, 'size', $GLOBALS['strSize'], "&nbsp;", false);

        //validation rules
        $translation = new OX_Translation();
        $widthRequiredRule = array($translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strWidth'])), 'required');
        $widthPositiveRule = array($translation->translate($GLOBALS['strXGreaterThanZeroField'], array($GLOBALS['strWidth'])), 'min', 1);
        $heightRequiredRule = array($translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strHeight'])), 'required');
        $heightPositiveRule = array($translation->translate($GLOBALS['strXGreaterThanZeroField'], array($GLOBALS['strHeight'])), 'min', 1);
        $numericRule = array($GLOBALS['strNumericField'] , 'numeric');

        $form->addGroupRule('size', array(
            'width' => array($widthRequiredRule, $numericRule, $widthPositiveRule),
            'height' => array($heightRequiredRule, $numericRule, $heightPositiveRule)));
    }

    //html & text banners
    if ($oComponent) {
        $oComponent->buildForm($form, $aBanner);
    }

    $translation = new OX_Translation();

    //common for all banners
    if (OA_Permission::isAccount(OA_ACCOUNT_ADMIN) || OA_Permission::isAccount(OA_ACCOUNT_MANAGER)) {
        $form->addElement('header', 'header_additional', "Additional data");
        
        $form->addElement('text', 'keyword', $GLOBALS['strKeyword']);
        $weightElem = $form->createElement('text', 'weight', $GLOBALS['strWeight']);
        $weightElem->setSize(6);
        $form->addElement($weightElem);
        $form->addElement('textarea', 'comments', $GLOBALS['strComments']);
        $weightPositiveRule = $translation->translate($GLOBALS['strXPositiveWholeNumberField'], array($GLOBALS['strWeight']));
        $form->addRule('weight', $weightPositiveRule, 'regex', '#^\d+$#');
        $form->addRule('weight', $weightPositiveRule, 'nonzero');
        
        // Custom Api selection
        $form->addElement('header', 'header_additional', "Custom Api");
        $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
        $query=OA_Dal_Delivery_query("SELECT api.* FROM {$table_prefix}custom_api as api");
        if(OA_Dal_Delivery_numRows($query)>0)
        {
            $azones = array ('' => $GLOBALS ['strSelectCustomApi']);
            while ($row = OA_Dal_Delivery_fetchAssoc($query)) 
            {      
                if(in_array($row['customid'],$aBanner['customid'])) 
                {
                    $djax_chk='selected=selected';
                }
                else
                {
                    $djax_chk='';
                }   
                
                $azones[$row['customid']] =   $row['name'];
            }
        }

        $form->addElement ( 'select', 'customid', $GLOBALS ['strCustomApi'], $azones, array ('id' => 'customid' ) );

        //Advertiser Selection
        /* $form->addElement('header', 'header_additional', "Advertiser");
        $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
        $query=OA_Dal_Delivery_query("SELECT adv.* FROM {$table_prefix}clients as adv");
        $whitelists = [];
        if(OA_Dal_Delivery_numRows($query)>0)
        {
            $azones = array ('' => $GLOBALS ['strSelectAdvertiserid']);
            while ($row = OA_Dal_Delivery_fetchAssoc($query)) 
            {      
                if(in_array($row['clientid'],$req_check)) 
                {
                    $djax_chk='selected=selected';
                }
                else
                {
                    $djax_chk='';
                }   
                
                $azones[$row['clientid']] =   $row['clientname'];
            }
        }
        
        $form->addElement ( 'select', 'advertiser_id', $GLOBALS ['strAdvertiser'], $azones, array ('id' => 'advertiser_id' ) );
        */

        // echo "<pre>";print_r($aBanner);exit;

        $form->addElement('text', 'advertiserid', $GLOBALS['strAdvertiser'], $aBanner['advertiserid']);

        $form->addElement('textarea', 'api_description', $GLOBALS['strApiDesc'], $aBanner['api_description']);
        
        $form->addElement('text', 'goaltarget', $GLOBALS['strGoalTarget'], $aBanner['goaltarget']);

        $form->addElement('text', 'goalthreshold', $GLOBALS['strGoalThreshold'], $aBanner['goalthreshold']);
        
        $BannerDuration .= '<tr><td width="30">&nbsp;</td><td width="170">Banner Duration</td><td><input class="date" name="banner_start" id="banner_start" type="text" onchange="banner_duration(this.id,this.value)" value="'.$aBanner['duration_start'].'" tabindex="2"/>
        <input type="image" src="'.OX::assetPath () . '/images/icon-calendar.gif" class= "calendar_icon" id="banner_start_button" align="absmiddle" border="0" tabindex="3" />
        <input class="date" name="banner_end" id="banner_end" type="text" onchange="banner_duration(this.id,this.value)" value="'.$aBanner['duration_end'].'" tabindex="4" /> 
        <input type="image" src="'.OX::assetPath () . '/images/icon-calendar.gif" class= "calendar_icon" id="banner_end_button" align="absmiddle" border="0" tabindex="3" /></td><tr>
        <style>
           #end_duration, #start_duration{
               display : none;
           }
           #end_duration < tr{
            display : none;
        }
        </style>';
        $form->addElement('html','BannerDuration',$BannerDuration);
    }


    /*****************dJAX Banner Report***************/
       
    $djprotocol = $GLOBALS['_MAX']['SSL_REQUEST'] ? 'https://' :'http://';
    $path = $djprotocol . $GLOBALS['_MAX']['CONF']['webpath']['admin'] . '/ReportSend.php';   

    $BannerReport = '<style>
    .buttonClass {
      background-color: #4CAF50;
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      text-decoration: none;
      display: inline-block;
      cursor: pointer;
      font-size:13px;
    }
    </style><span id="sect_pricing" class="">
        <table class="section" border="0" width="100%" cellpadding="0" cellspacing="0">
        <tbody>
        <tr><td height="25" colspan="3"><b>Send Statistics</b></td></tr>
        
        <tr style="height:1px;">
        <td width="30"><img src="'.OX::assetPath().'/images/break.gif" alt="" style="height:1px; width:30px;"></td>
        <td width="170"><img src="'.OX::assetPath().'/images/break.gif" alt="" style="height:1px; width:170px;"></td>
        <td width="100%"><img src="'.OX::assetPath().'/images/break.gif" alt="" style="height:1px;" width="100%"></td>
        </tr>';
        
        if (!empty($aBanner['bannerid'])) 
        {
			$Checked = $aBanner['daily_cron'] == 1 ? 'checked' : '';
        }
        else
        {
			$Checked = 'checked';
		}
        $BannerReport .= '<tr><td height="10" colspan="3">&nbsp;</td></tr>';
       
        
        $BannerReport .= '<tr>
        <td width="30">&nbsp;</td><td width="170"><label for="">Periode</label></td>
        <td width="100%">';

    $BannerReport .= '
        <select name="period_preset" id="period_preset" onchange="periodFormChange(1)" tabindex="1">
            <option value="today" selected="selected">Today</option>
            <option value="yesterday">Yesterday</option>
            <option value="this_week">This week</option>
            <option value="last_week"> Last week</option>
            <option value="last_7_days">Last 7 days</option>
            <option value="this_month">This month</option>
            <option value="last_month">Last month</option>
            <option value="all_stats">All statistics</option>
            <option value="specific">Specific dates</option>
        </select>

        <input class="date" name="period_start" id="period_start" type="text" value="" tabindex="2"/>
        <input type="image" src="'.OX::assetPath () . '/images/icon-calendar.gif" class= "calendar_icon" id="period_start_button" align="absmiddle" border="0" tabindex="3" />
        <input class="date" name="period_end" id="period_end" type="text" value="" tabindex="4" /> 
        <input type="image" src="'.OX::assetPath () . '/images/icon-calendar.gif" class= "calendar_icon" id="period_end_button" align="absmiddle" border="0" tabindex="3" />';
        
    $BannerReport .= '</td></tr>';
    
    
    $BannerReport .= '<tr><td height="10" colspan="3">&nbsp;</td></tr>'; 
    
        
    
    
    $BannerReport .= '<tr>
    <td width="30">&nbsp;</td><td width="170"><label for="">Send Receiption MailAddress </label></td>
    <td width="100%">
    <textarea name="SendMail" id="SendMail" class="large small-h" wrap="off" dir="ltr" placeholder="Ex: mail1@gmail.com, mail2@gmail.com"></textarea>
    </td>
    </tr>';
    
                $BannerReport .= '<tr><td height="10" colspan="3">&nbsp;</td></tr>'; 

    
    $BannerReport .= '<tr>
        <td width="30">&nbsp;</td><td width="170"><label for="">täglich senden</label></td>
        <td width="100%">
        <input type="checkbox" name="daily_cron" id="daily_cron" class="daily_cron" value="1" '.$Checked.'>
        </td>
        <tr><td height="10" colspan="3">&nbsp;</td></tr>';
        
                    $BannerReport .= '<tr><td height="10" colspan="3">&nbsp;</td></tr>'; 
$BannerReport .= '<tr>
    <td width="30">&nbsp;</td><td width="170"><label for="">Daily Cron MailAddress </label></td>
    <td width="100%">
    <textarea name="daily_mail" id="daily_mail" class="large small-h" wrap="off" dir="ltr" placeholder="Ex: mail1@gmail.com, mail2@gmail.com">'.$aBanner['daily_mail'].'</textarea>
    </td>
    </tr>';
    
    
    if(!empty($_GET['bannerid']))
    {
        $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

        $reqCheck = OA_Dal_Delivery_query("SELECT COUNT(*) FROM ".$table_prefix."data_summary_ad_hourly WHERE ad_id = ".$_GET['bannerid']." ") or die("error1");

        if(OA_Dal_Delivery_numRows($reqCheck) > 0 ) 
        {
            $BannerReport .= '<tr><td height="10" colspan="3">&nbsp;</td></tr><tr>
            <td width="30">&nbsp;</td><td width="170"><label for=""></label></td>
            <td width="100%">
            <a class="buttonClass" onclick="myFunction()">Send Now</a>
            </td>
            </tr>';
        }
    }
    
    $BannerReport .= '</tbody></table></span>';
    $BannerReport .= "<script type='text/javascript'>

    //Banner Duration Setup
    Calendar.setup({
        inputField: 'banner_start',
        ifFormat: '%Y-%m-%d',
        button: 'banner_start_button',
        align: 'Bl',
        weekNumbers: false,
        firstDay: 1,
        electric: false
    });

    Calendar.setup({
        inputField: 'banner_end',
        ifFormat: '%Y-%m-%d',
        button: 'banner_end_button',
        align: 'Bl',
        weekNumbers: false,
        firstDay: 1,
        electric: false
    });

   function banner_duration(id,value){ //alert($('#banner_start').val());alert($('#banner_end').val());
   // if(id=='banner_start'){ 
        $('#start_duration').val($('#banner_start').val());
   // }
   // if(id=='banner_end'){
        $('#end_duration').val($('#banner_end').val());
   // }
   }
    
    Calendar.setup({
        inputField: 'period_start',
        ifFormat: '%Y-%m-%d',
        button: 'period_start_button',
        align: 'Bl',
        weekNumbers: false,
        firstDay: 1,
        electric: false
    });
    Calendar.setup({
        inputField: 'period_end',
        ifFormat: '%Y-%m-%d',
        button: 'period_end_button',
        align: 'Bl',
        weekNumbers: false,
        firstDay: 1,
        electric: false
    });

    function periodFormChange(bAutoSubmit) {
        var o = document.getElementById('period_preset');
        var periodSelectName = o.options[o.selectedIndex].value;
                  
        if(periodSelectName=='today')
        {
            document.getElementById('period_start').value = '".date('d F Y', strtotime(date('Y-m-d')))."';
            document.getElementById('period_end').value = '".date('d F Y', strtotime(date('Y-m-d')))."';
        }
        else if(periodSelectName=='yesterday')
        {
            document.getElementById('period_start').value = '".date('d F Y', strtotime(date('Y-m-d', strtotime('Yesterday'))))."';
            document.getElementById('period_end').value = '".date('d F Y', strtotime(date('Y-m-d', strtotime('Yesterday'))))."';
        }                      
        else if(periodSelectName=='this_week')
        {
            document.getElementById('period_start').value = '".date('d F Y', strtotime(date('Y-m-d', strtotime('this week Monday'))))."';
            document.getElementById('period_end').value = '".date('d F Y', strtotime(date('Y-m-d')))."';
        }
        else if(periodSelectName=='last_week')
        {
            document.getElementById('period_start').value = '".date('d F Y', strtotime(date('Y-m-d', strtotime('previous Monday'))))."';
            document.getElementById('period_end').value = '".date('d F Y', strtotime(date('Y-m-d', strtotime('previous Sunday'))))."';
        }
        else if(periodSelectName=='last_7_days')
        {
            document.getElementById('period_start').value = '".date('d F Y', strtotime(date('Y-m-d', strtotime('Today - 7 Day'))))."';
            document.getElementById('period_end').value = '".date('d F Y', strtotime(date('Y-m-d', strtotime('Today - 1 Day'))))."';
        }
        else if(periodSelectName=='this_month')
        {
            document.getElementById('period_start').value = '".date('d F Y', strtotime(date('Y-m-d', mktime(0, 0, 0, date('m'), 1, date('Y')))))."';
            document.getElementById('period_end').value = '".date('d F Y', strtotime(date('Y-m-d')))."';
        }
        else if(periodSelectName=='last_month')
        {
            document.getElementById('period_start').value = '".date('d F Y', strtotime(date('Y-m-d', mktime(0, 0, 0, (date('m') - 1), 1, date('Y')))))."';
            document.getElementById('period_end').value = '".date('d F Y', strtotime(date('Y-m-d', mktime(0, 0, 0, date('m'), 0, date('Y')))))."';
        }
        else if(periodSelectName=='all_stats')
        {
            document.getElementById('period_start').value = '';
            document.getElementById('period_end').value = '';
        }
        var specific = periodSelectName == 'specific';
        var periodTabIndex = 2;
        document.getElementById('period_start').readOnly = !specific;
        document.getElementById('period_start_button').disabled = !specific;
        document.getElementById('period_end').readOnly = !specific;
        document.getElementById('period_end_button').disabled = !specific;
        if(!specific) {
            if(bAutoSubmit) {
                document.getElementById('period_start').disabled = true;
                document.getElementById('period_end').disabled = true;
            }
            document.getElementById('period_start').classList.add('disapp');
            document.getElementById('period_end').classList.add('disapp');
            document.getElementById('period_start').tabIndex = null;
            document.getElementById('period_start_button').tabIndex = null;
            document.getElementById('period_end').tabIndex = null;
            document.getElementById('period_end_button').tabIndex = null;
            document.getElementById('period_start_button').src ='".OX::assetPath () . "/images/icon-calendar.gif';
            document.getElementById('period_end_button').src ='".OX::assetPath () . "/images/icon-calendar.gif';
        } else {
            document.getElementById('period_start').classList.remove('disapp');
            document.getElementById('period_end').classList.remove('disapp');
            document.getElementById('period_start').tabIndex = periodTabIndex;
            document.getElementById('period_start_button').tabIndex = periodTabIndex + 1;
            document.getElementById('period_end').tabIndex = periodTabIndex + 2;
            document.getElementById('period_end_button').tabIndex = periodTabIndex + 3;
            document.getElementById('period_start_button').src ='".OX::assetPath () . "/images/icon-calendar.gif';
            document.getElementById('period_end_button').src ='".OX::assetPath () . "/images/icon-calendar.gif';
        }
        document.getElementById('period_start_button').readOnly = !specific;
        document.getElementById('period_end_button').readOnly = !specific;
        document.getElementById('period_start_button').style.cursor = specific ? 'pointer' : 'default';
        document.getElementById('period_end_button').style.cursor = specific ? 'pointer' : 'default';            
    }
    periodFormChange(0);
    
    function myFunction() {
        var SendMail = document.getElementById('SendMail').value;
        
        var PeriodPreset = document.getElementById('period_preset').value;
        var PeriodStart = document.getElementById('period_start').value;
        var PeriodEnd = document.getElementById('period_end').value;
        
        if(SendMail)
        {            
            window.location.href = '".$path."?clientid=".$_GET['clientid']."&campaignid=".$_GET['campaignid']."&bannerid=".$_GET['bannerid']."&PeriodPreset='+PeriodPreset+'&SendMail='+SendMail;
        }
    }

    </script>";
    
    $form->addElement('html','BannerReport',$BannerReport);
 
    /*****************dJAX Banner Report***************/


    //we want submit to be the last element in its own separate section
    $form->addElement('controls', 'form-controls');
    $form->addElement('submit', 'submit', 'Save changes');

    //validation rules
    if (OA_Permission::isAccount(OA_ACCOUNT_ADMIN) || OA_Permission::isAccount(OA_ACCOUNT_MANAGER)) {
        $urlRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strName']));
        $form->addRule('description', $urlRequiredMsg, 'required');
    }

    //set banner values
    $form->setDefaults($aBanner);

    if ($formDisabled)
    {
        $form->freeze();
    }

    return $form;
}


function addUploadGroup($form, $aBanner, $vars)
{
        $uploadG = [];

        $update = !empty($vars['fileName']);

        if ($update) {
            $uploadG['radio1'] = $form->createElement('radio', $vars['radioName'], null, (empty($vars['imageName']) ? '' : "<img src='".OX::assetPath()."/images/".$vars['imageName']."' align='absmiddle'> ").$vars['fileName']." <i dir=".$GLOBALS['phpAds_TextDirection'].">(".$vars['fileSize'].")</i>", 'f');
            $uploadG['radio2'] = $form->createElement('radio', $vars['radioName'], null, null, 't');
            $uploadG['upload'] = $form->createElement('file', $vars['uploadName'], null, array("onchange" => "selectFile(this)", "style" => "width: 250px;"));

            $form->addGroup($uploadG, $vars['uploadName'].'_group', $vars['updateLabel'], array("<br>", "", "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"), false);
        } else { //add new creative
            $uploadG['hidden'] = $form->createElement("hidden", $vars['radioName']);
            $uploadG['upload'] = $form->createElement('file', $vars['uploadName'], null, array("onchange" => "selectFile(this)", "size" => 26, "style" => "width: 250px"));

            $form->addGroup($uploadG, $vars['uploadName'].'_group', $vars['newLabel'], "<br>", false);

            if (!empty($vars['decorateId'])) {
                $form->addDecorator($vars['uploadName'].'_group', 'process', array('tag' => 'tr',
                    'addAttributes' => array('id' => $vars['decorateId'].'{numCall}',
                    'style' => 'display:none')));
            }

        }
        $form->setDefaults(array(
            $vars['radioName'] => $update ? 'f' : 't',
        ));
}


function processForm($bannerid, $form, &$oComponent, $formDisabled=false)
{
    $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

    $aFields = $form->exportValues();

    $doBanners = OA_Dal::factoryDO('banners');
    // Get the existing banner details (if it is not a new banner)
    if (!empty($bannerid)) {
        if ($doBanners->get($bannerid)) {
            $aBanner = $doBanners->toArray();
        }
    }

    $aVariables = array();
    $aVariables['campaignid']      = $aFields['campaignid'];
    $aVariables['target']          = isset($aFields['target']) ? $aFields['target'] : '';
    $aVariables['height']          = isset($aFields['height']) ? $aFields['height'] : 0;
    $aVariables['width']           = isset($aFields['width'])  ? $aFields['width'] : 0;
    $aVariables['weight']          = !empty($aFields['weight']) ? $aFields['weight'] : 0;
    $aVariables['adserver']        = !empty($aFields['adserver']) ? $aFields['adserver'] : '';
    $aVariables['alt']             = !empty($aFields['alt']) ? $aFields['alt'] : '';
    $aVariables['bannertext']      = !empty($aFields['bannertext']) ? $aFields['bannertext'] : '';
    $aVariables['htmltemplate']    = !empty($aFields['htmltemplate']) ? $aFields['htmltemplate'] : '';
    $aVariables['description']     = !empty($aFields['description']) ? $aFields['description'] : '';
    $aVariables['imageurl']        = (!empty($aFields['imageurl']) && $aFields['imageurl'] != 'http://') ? $aFields['imageurl'] : '';
    $aVariables['url']             = (!empty($aFields['url']) && $aFields['url'] != 'http://') ? $aFields['url'] : '';
    $aVariables['status']          = ($aFields['status'] != '') ? $aFields['status'] : '';
    $aVariables['statustext']      = !empty($aFields['statustext']) ? $aFields['statustext'] : '';
    $aVariables['storagetype']     = $aFields['type'];
    $aVariables['ext_bannertype']  = $aFields['ext_bannertype'];
    $aVariables['comments']        = $aFields['comments'];
    $aVariables['iframe_friendly'] = $aFields['iframe_friendly'] ? 1 : 0;

    $aVariables['filename']        = !empty($aBanner['filename']) ? $aBanner['filename'] : '';
    $aVariables['contenttype']     = !empty($aBanner['contenttype']) ? $aBanner['contenttype'] : '';
    
    $aVariables['advertiserid']      = !empty($aFields['advertiserid'] != '') ? $aFields['advertiserid'] : '';
    $aVariables['api_description']   = !empty($aFields['api_description'] != '') ? $aFields['api_description'] : '';
    $aVariables['customid']          = !empty($aFields['customid'] != '') ? $aFields['customid'] : '';
	
    $aVariables['duration_start']    = $aFields['start_duration'];
    $aVariables['duration_end']    = $aFields['end_duration'];

    $aVariables['goaltarget']          = !empty($aFields['goaltarget'] != '') ? $aFields['goaltarget'] : '3.0';
    $aVariables['goalthreshold']          = !empty($aFields['goalthreshold'] != '') ? $aFields['goalthreshold'] : '';

    if ($aFields['type'] == 'url') {
        $aVariables['contenttype'] = OA_Creative_File::staticGetContentTypeByExtension($aVariables['imageurl']);
        if (empty($aVariables['contenttype'])) {
            // Assume dynamic urls (i.e. http://www.example.com/foo?bar) are "gif"
            $aVariables['contenttype'] = 'gif';
        }
    } elseif ($aFields['type'] == 'txt') {
        // Text banners should always have a "txt" content type
        $aVariables['contenttype'] = 'txt';
    }

    $aVariables['alt_filename']    = !empty($aBanner['alt_filename']) ? $aBanner['alt_filename'] : '';
    $aVariables['alt_contenttype'] = !empty($aBanner['alt_contenttype']) ? $aBanner['alt_contenttype'] : '';
    $aVariables['alt_imageurl']    = !empty($aFields['alt_imageurl']) ? $aFields['alt_imageurl'] : '';

    if (isset($aFields['keyword']) && $aFields['keyword'] != '') {
        $keywordArray = preg_split('/[ ,]+/D', $aFields['keyword']);
        $aVariables['keyword'] = implode(' ', $keywordArray);
    } else {
        $aVariables['keyword'] = '';
    }

    // Deal with any files that are uploaded.
    if (!empty($_FILES['upload']) && $aFields['replaceimage'] == 't') { //TODO refactor upload to be a valid quickform elem
        $oFile = OA_Creative_File::factoryUploadedFile('upload');
        checkForErrorFileUploaded($oFile);
        $oFile->store($aFields['type']);
        $aFile = $oFile->getFileDetails();

        if (!empty($aFile)) {
            $aVariables['filename']      = $aFile['filename'];
            $aVariables['contenttype']   = $aFile['contenttype'];
            $aVariables['width']         = $aFile['width'];
            $aVariables['height']        = $aFile['height'];
            $aVariables['pluginversion'] = $aFile['pluginversion'];
        }

        // Delete the old file for this banner
        if (!empty($aBanner['filename']) && ($aBanner['filename'] != $aFile['filename']) && ($aBanner['storagetype'] == 'web' || $aBanner['storagetype'] == 'sql')) {
            /*
             * Actually, don't delete it. It might be still being used until the
             * cache expires. See:
             *  - https://github.com/revive-adserver/revive-adserver/issues/341
             *  - https://github.com/revive-adserver/revive-adserver/issues/421
             *
             * DataObjects_Banners::deleteBannerFile($aBanner['storagetype'], $aBanner['filename']);
             *
             */
        }
    }
    if (!empty($_FILES['uploadalt']) && $_FILES['uploadalt']['size'] > 0
        &&  $aFields['replacealtimage'] == 't') {

        //TODO: Check image only? - Wasn't enforced before
        $oFile = OA_Creative_File::factoryUploadedFile('uploadalt');
        checkForErrorFileUploaded($oFile);
        $oFile->store($aFields['type']);
        $aFile = $oFile->getFileDetails();

        if (!empty($aFile)) {
            $aVariables['alt_filename']    = $aFile['filename'];
            $aVariables['alt_contenttype'] = $aFile['contenttype'];
        }
    }

    $aVariables['parameters'] = serialize(null);

    //TODO: deleting images is not viable because they could still be in use in the delivery cache
    //    // Delete any old banners...
    //    if (!empty($aBanner['filename']) && $aBanner['filename'] != $aVariables['filename']) {
    //        phpAds_ImageDelete($aBanner['storagetype'], $aBanner['filename']);
    //    }
    //    if (!empty($aBanner['alt_filename']) && $aBanner['alt_filename'] != $aVariables['alt_filename']) {
    //        phpAds_ImageDelete($aBanner['storagetype'], $aBanner['alt_filename']);
    //    }

    // Clients are only allowed to modify certain fields, ensure that other fields are unchanged
    if (OA_Permission::isAccount(OA_ACCOUNT_ADVERTISER)) {
        $aVariables['weight']       = $aBanner['weight'];
        $aVariables['description']  = $aBanner['name'];
        $aVariables['comments']     = $aBanner['comments'];
    }

    $insert = (empty($bannerid)) ? true : false;

    if ($oComponent)
    {
        $result = $oComponent->preprocessForm($insert, $bannerid, $aFields, $aVariables);
        if ($result === false)
        {
            // handle error
            return false;
        }
    }

    // File the data
    $doBanners->setFrom($aVariables);
    if ($insert) {
        $bannerid = $doBanners->insert();
        
         /*****************dJAX Banner Report***************/
		$tableprefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
		$daily_cron = $_POST['daily_cron'] ? $_POST['daily_cron'] : 0;
		OA_Dal_Delivery_query("Update ".$tableprefix."banners set daily_cron='".$daily_cron."', daily_mail='".$_POST['daily_mail']."' where bannerid=".$bannerid);

         /*****************dJAX Banner Report***************/
         
        // Run the Maintenance Priority Engine process
        OA_Maintenance_Priority::scheduleRun();
    } else {
        $doBanners->update();
        
         /*****************dJAX Banner Report***************/
		$tableprefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
		$daily_cron = $_POST['daily_cron'] ? $_POST['daily_cron'] : 0;
		OA_Dal_Delivery_query("Update ".$tableprefix."banners set daily_cron='".$daily_cron."', daily_mail='".$_POST['daily_mail']."' where bannerid=".$bannerid);

		/*****************dJAX Banner Report***************/
		
        // check if size has changed
        if ($aVariables['width'] != $aBanner['width'] || $aVariables['height'] != $aBanner['height']) {
            MAX_adjustAdZones($bannerid);
            MAX_addDefaultPlacementZones($bannerid, $aVariables['campaignid']);
        }
    }
    
    
    // Curl
    
    if ($aVariables['customid'] != '' && $aVariables['advertiserid'] != '') {
        $custom_api_id = $aFields['customid'];
        $api_adv_id = $aFields['advertiserid'];

        if($insert) {
            $curl_url = 'https://api.appnexus.com/creative?advertiser_id='.$api_adv_id;
            $reqParam = 'POST';
        } else {
            $curl_url = 'https://api.appnexus.com/creative?id='.$aBanner['xandrcreativeid'].'&advertiser_id='.$api_adv_id;
            $reqParam = 'PUT';
        }
 $djprotocol = ($GLOBALS['_MAX']['SSL_REQUEST'])? 'https://': 'http://';
         $imagedata = MAX_PATH.'/www/images/'.$aVariables['filename'];
       
        $base64 = base64_encode($imagedata);
        $media_url = $djprotocol.$GLOBALS['conf']['webpath']['images'].'/'.$aVariables['filename']; 
$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

        $query="select * from {$table_prefix}custom_api where customid='".$custom_api_id."'";
        $rcustomInfo = OA_Dal_Delivery_query($query);
        $acustomInfo = OA_Dal_Delivery_fetchAssoc($rcustomInfo);
        
        // Curl start
        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => $acustomInfo['authurl'],
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS =>'{
            "auth": {
                "username" : "'.trim($acustomInfo['apiname']).'",
                "password" : "'.base64_decode($acustomInfo['apipassword']).'"
            }
        }',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: text/plain',
        ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        $result = json_decode($response, true);
        
        if($result['response']['status'] == 'OK') {
            $auth_token = $result['response']['token'];
            $cookie_token = str_replace(":","%3A",$auth_token);

            $height = $aVariables['height'];
            $width = $aVariables['width'];
            $zoneId=0;
            
          //  $clickurl = $aVariables['url'];
          $secret = join("\t", [
base64_decode($GLOBALS['_MAX']['CONF']['delivery']['secret']),
$bannerid,
$zoneId
]);
 $sig= hash_hmac(
'sha256',
$aVariables['url'],
$secret
); 
			$rand=substr(md5(uniqid(time(), true)), 0, 10);
			$djprotocol = ($GLOBALS['_MAX']['SSL_REQUEST'])? 'https://': 'http://';
            $delivery=$djprotocol.$GLOBALS['_MAX']['CONF']['webpath']['delivery'];;
            $clickurl=  $delivery."/cl.php?bannerid={$bannerid}&zoneid=0&sig={$sig}&dest={$aVariables['url']}";
            $pixelurl= $delivery."/lg.php?bannerid={$bannerid}&campaignid={$aVariables['campaignid']}&zoneid=0&cb={$rand}";
          
            
           // $clickUrl_enc=urlencode($clickurl);
            // creative service
            $curl = curl_init();
            

            curl_setopt_array($curl, array(
            // CURLOPT_URL => 'https://api.appnexus.com/creative?advertiser_id='.$api_adv_id,
            CURLOPT_URL => $curl_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => $reqParam,
            CURLOPT_POSTFIELDS =>'{
            "creative": {
                "name": "'.$aVariables['api_description'].'",
                "advertiser_id": '.$api_adv_id.',
                "format": "image",
                "width": '.$aVariables['width'].',
                "height": '.$aVariables['height'].',
                "click_url": "'.$clickurl.'",
                "click_url_enc": "'.$clickurl.'",
                "allow_audit": false,
                "track_clicks": true,
                "pixels": [{
					"format": "url-image",
					"url": "'.$pixelurl.'"
				}],
                "template":
                {
                    "id": 4,
                    "name": "Image (Xandr Created)",
                    "description": null,
                    "last_modified": "2021-03-16 16:09:49",
                    "is_archived": false,
                    "member_id": null,
                    "ad_type": "banner",
                    "track_on_callback": false,
                    "is_default": true,
                    "content_html": "<a href=\\"${CLICK_URL_ENC}${CLICK_URL}\\" target=\\"_blank\\"><img width=\\"${CREATIVE_WIDTH}\\" height=\\"${CREATIVE_HEIGHT}\\" style=\\"border-style: none\\" src=\\"${MEDIA_URL}\\" /></a>",
                    "content_js": "document.write(\'<a href=\\"${CLICK_URL_ENC}${CLICK_URL}\\" target=\\"_blank\\"><img width=\\"${CREATIVE_WIDTH}\\" height=\\"${CREATIVE_HEIGHT}\\" style=\\"border-style: none\\" src=\\"${MEDIA_URL}\\" /></a>\');",
                    "callback_content_html": null,
                    "media_subtype": {
                        "id": 1,
                        "name": "Standard Banner",
                        "media_type_name": "Banner",
                        "media_type_id": 1
                    },
                    "format": {
                        "id": 4,
                        "name": "image"
                    }
                },
                "media_url_secure": "'.$media_url.'",
                "content": "'.$base64.'"
            }
            }',
            CURLOPT_HTTPHEADER => array(
                'token:'.$auth_token,
                'Content-Type: text/plain',
                'Cookie: HBFAPI_SESSID='.$cookie_token.'; IBAPI_SESSID='.$cookie_token
            ),
            ));

            $response = curl_exec($curl);

            curl_close($curl);
            
            $res = json_decode($response, true);
            
            // echo "<pre>";print_r($res);exit;

            if($res['response']['status'] == 'OK') {
                $xanderId = $res['response']['id'];
                $member_id = '13423';
                OA_Dal_Delivery_query("UPDATE {$table_prefix}banners SET xandrcreativeid = '".$xanderId."' WHERE  bannerid ='".$bannerid."' ");
				
				$curl = curl_init();

                curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://api.appnexus.com/profile?advertiser_id='.$api_adv_id.'&member_id='.$member_id,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS =>'{
                    "profile": {
                        "country_action": "include",
                        "country_targets": [
                            {
                                "id": 59,
                                "name": "Germany",
                                "code": "DE"
                            }
                        ],
                        "region_action": "include",
                        "region_targets": [
                            {
                                "id": 829,
                                "name": "Hessen",
                                "code": "HE",
                                "country_name": "Germany",
                                "country_code": "DE"
                            }
                        ],
                        "city_action": "include",
                        "city_targets": [
                            {
                                "id": 36699,
                                "name": "Aichen",
                                "region_name": "Baden-Wurttemberg",
                                "region_code": "01",
                                "country_name": "Germany",
                                "country_code": "DE"
                            }
                        ],
                        "browser_action": "include",
                        "browser_targets": [
                            {
                                "id": 5,
                                "name": "Firefox 4",
                                "last_modified": "2012-11-27 15:32:43",
                                "is_aggregated": true
                            },
                            {
                                "id": 6,
                                "name": "Firefox 3",
                                "last_modified": "2012-11-27 15:32:43",
                                "is_aggregated": true
                            },
                            {
                                "id": 7,
                                "name": "Firefox (other versions)",
                                "last_modified": "2012-11-27 15:32:43",
                                "is_aggregated": true
                            },
                            {
                                "id": 8,
                                "name": "Chrome (all versions)",
                                "last_modified": "2012-11-27 15:32:43",
                                "is_aggregated": true
                            }
                        ],
                        "language_action": "include",
                        "language_targets": [
                            {
                                "id": 6,
                                "name": "German",
                                "last_activity": "2013-04-01 19:12:00",
                                "code": "DE"
                            }
                        ],
                        "daypart_targets": [
                            {
                                "day" : "all"
                            }
                        ]
                    }
                }',
                CURLOPT_HTTPHEADER => array(
                    'token:'.$auth_token,
                    'Content-Type: text/plain',
                    'Cookie: HBFAPI_SESSID='.$cookie_token.'; IBAPI_SESSID='.$cookie_token
                ),
                ));

                $response = curl_exec($curl);

                curl_close($curl);
                $resp = json_decode($response, true);
                
                if($resp['response']['status'] == 'OK') {

                    $profile_id = $resp['response']['id'];

                    $curl = curl_init();

                    curl_setopt_array($curl, array(
                    CURLOPT_URL => 'https://api.appnexus.com/insertion-order?advertiser_id='.$api_adv_id,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS =>'{
                    "insertion-order": {
                        "name": "'.$aVariables['api_description'].'",
                        "advertiser_id": '.$api_adv_id.',
                        "state": "active",
                        "budget_type": "revenue",
                        "budget_intervals": [
                        {
                            "enable_pacing": true,
                            "start_date": "'.$aVariables['duration_start'].' 00:00:00",
                            "end_date": "'.$aVariables['duration_end'].' 23:59:59",
                            "lifetime_budget": "20000",
                            "lifetime_pacing": "true"
                        }
                        ]
                    }
                    }',
                    CURLOPT_HTTPHEADER => array(
                        'token:'.$auth_token,
                        'Content-Type: text/plain',
                        'Cookie: HBFAPI_SESSID='.$cookie_token.'; IBAPI_SESSID='.$cookie_token
                    ),
                    ));

                    $response = curl_exec($curl);

                    curl_close($curl);
                    // echo $response;
                    $insert_result = json_decode($response, true);

                    if($insert_result['response']['status'] == 'OK') {
                        $insertion_id = $insert_result['response']['id'];

                        $query="select * from {$table_prefix}campaigns where campaignid='".$aVariables['campaignid']."'";
                        $rcampaignInfo = OA_Dal_Delivery_query($query);
                        $acampaignInfo = OA_Dal_Delivery_fetchAssoc($rcampaignInfo);

                        if($acampaignInfo['revenue_type'] == 1) {
                            $rev_type = 'cpm';
                        } else if($acampaignInfo['revenue_type'] == 2) {
                            $rev_type = 'cpc';
                        } else if($acampaignInfo['revenue_type'] == 3) {
                            $rev_type = 'cpa';
                        } else if($acampaignInfo['revenue_type'] == 4) {
                            $rev_type = 'tenancy';
                        } 
						
						if($acampaignInfo['revenue'] == '') {
							$revenue = '2.00';
						} else {
							$revenue = $acampaignInfo['revenue'];
						}
                        $curl = curl_init();

                        curl_setopt_array($curl, array(
                        CURLOPT_URL => 'https://api.appnexus.com/line-item?advertiser_id='.$api_adv_id,
                        CURLOPT_RETURNTRANSFER => true,
						  CURLOPT_ENCODING => '',
						  CURLOPT_MAXREDIRS => 10,
						  CURLOPT_TIMEOUT => 0,
						  CURLOPT_FOLLOWLOCATION => true,
						  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
						  CURLOPT_CUSTOMREQUEST => 'POST',
						  CURLOPT_POSTFIELDS =>'{  
						   "line-item":{  
							  "name":"Line Item '.$aVariables['api_description'].'",
							  "state":"active",
							  "advertiser":{  
								 "id":'.$api_adv_id.'
							  },
							  "insertion_orders":[  
								 {  
									"id":'.$insertion_id.'
								 }
							  ],
							  "manage_creative":true,
							  "creatives":[  
                                {  
                                   "id":'.$xanderId.'
                                }
                             ],
							  "line_item_type":"standard_v2",
							  "profile_id":'.$profile_id.',
							  "revenue_type":"'.$rev_type.'",
							  "revenue_value":'.$revenue.',
							  "budget_intervals": [
								{
									"start_date": "'.$aVariables['duration_start'].' 00:00:00",
                                    "end_date": "'.$aVariables['duration_end'].' 23:59:59",
									"lifetime_pacing":false,
									"enable_pacing":false
								}],
								"goal_type":"cpc",
								"goal_value":null,
							  "supply_strategies":[  
								 {  
									"rtb":true,
									"managed":false,
									"deal":false
								 }
							  ],
							  "ad_types":[  
								 "banner"
							  ],
							  "valuation":{  
								 "goal_target":'.$aVariables['goaltarget'].',
								 "goal_threshold":'.$aVariables['goalthreshold'].'
							  }
						   }
						}',
                        CURLOPT_HTTPHEADER => array(
                            'token:'.$auth_token,
							'Content-Type: text/plain',
							'Cookie: HBFAPI_SESSID='.$cookie_token.'; IBAPI_SESSID='.$cookie_token
                        ),
                        ));

                        $response = curl_exec($curl);

                        curl_close($curl);
                        //echo $response;
						$line_item = json_decode($response, true);
						
                    }
                }

            }
        }
        // Curl end
    }

    
    if ($oComponent)
    {
        $result = $oComponent->processForm($insert, $bannerid, $aFields, $aVariables);
        if ($result === false)
        {
            // handle error
            // remove rec from banners table?
            return false;
        }
    }

    $translation = new OX_Translation ();
    if ($insert) {
        // Queue confirmation message
        $translated_message = $translation->translate ( $GLOBALS['strBannerHasBeenAdded'], array(
            MAX::constructURL(MAX_URL_ADMIN, 'banner-edit.php?clientid=' .  $aFields['clientid'] . '&campaignid=' . $aFields['campaignid'] . '&bannerid=' . $bannerid),
            htmlspecialchars($aFields['description'])
        ));
        OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);

        $nextPage = "campaign-banners.php?clientid=".$aFields['clientid']."&campaignid=".$aFields['campaignid'];
    }
    else {
        $translated_message = $translation->translate($GLOBALS['strBannerHasBeenUpdated'],
        array (
            MAX::constructURL ( MAX_URL_ADMIN, 'banner-edit.php?clientid='.$aFields['clientid'].'&campaignid='.$aFields['campaignid'].'&bannerid='.$aFields['bannerid'] ),
            htmlspecialchars ( $aFields ['description'])
        ));
        OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);
        $nextPage = "banner-edit.php?clientid=".$aFields['clientid']."&campaignid=".$aFields['campaignid']."&bannerid=$bannerid";
    }

    // Go to the next page
    Header("Location: $nextPage");
    exit;
}

function checkForErrorFileUploaded($oFile)
{
	if (PEAR::isError($oFile)) {
	    phpAds_PageHeader(1);
	    phpAds_Die($GLOBALS['strErrorOccurred'], htmlspecialchars($oFile->getMessage()). "<br>Please make sure you selected a valid file.");
	}
}

function _getContentTypeIconImageName($contentType)
{
    $imageName = '';
    if (empty($contentType)) {
        return $imageName;
    }

    switch ($contentType) {
        case 'jpeg': $imageName = 'icon-filetype-jpg.gif'; break;
        case 'gif':  $imageName = 'icon-filetype-gif.gif'; break;
        case 'png':  $imageName = 'icon-filetype-png.gif'; break;
        case 'rpm':  $imageName = 'icon-filetype-rpm.gif'; break;
        case 'mov':  $imageName = 'icon-filetype-mov.gif'; break;
        default:     $imageName = 'icon-banner-stored.gif'; break;
    }

    return $imageName;
}

function _getPrettySize($size)
{
    $kb = round($size / 1024);

    if ($kb > 0) {
        return "{$kb} KB";
    }

    return "{$size} B";
}

function _getBannerSizeText($type, $filename)
{
    return _getPrettySize(phpAds_ImageSize($type, $filename));
}


