<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file
require_once '../../init.php';

// Required files
require_once MAX_PATH . '/www/admin/lib-maintenance-priority.inc.php';
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/www/admin/lib-statistics.inc.php';
require_once MAX_PATH . '/lib/max/other/html.php';
require_once MAX_PATH . '/lib/max/Plugin.php';
require_once MAX_PATH . '/lib/max/other/lib-acl.inc.php';
require_once MAX_PATH . '/lib/max/Delivery/cache.php';
require_once MAX_PATH . '/lib/max/other/capping/lib-capping.inc.php';

// Register input variables
phpAds_registerGlobalUnslashed('acl', 'action', 'submit');

// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_MANAGER);
OA_Permission::enforceAccessToObject('clients',   $clientid);
OA_Permission::enforceAccessToObject('campaigns', $campaignid);
OA_Permission::enforceAccessToObject('banners',   $bannerid);

/*-------------------------------------------------------*/
/* Store preferences									 */
/*-------------------------------------------------------*/
$session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['clientid'] = $clientid;
$session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['campaignid'][$clientid] = $campaignid;
phpAds_SessionDataStore();

// Initialise some parameters
$pageName = basename($_SERVER['SCRIPT_NAME']);
$tabindex = 1;
$aEntities = array('clientid' => $clientid, 'campaignid' => $campaignid, 'bannerid' => $bannerid);

$doBanners = OA_Dal::factoryDO('banners');
if ($doBanners->get($bannerid)) {
    $aBanner = $doBanners->toArray();
}
// echo "<pre>";print_r($_POST);exit;
if (!empty($action)) {
    $acl = MAX_AclAdjust($acl, $action);
} elseif (!empty($submit)) {
    
    OA_Permission::checkSessionToken();
    //print_r($acl);exit;
    $acl = (isset($acl)) ? $acl : array();

    // Only save when inputs are valid
    if (OX_AclCheckInputsFields($acl, $pageName) === true) {
        $aBannerPrev = MAX_cacheGetAd($bannerid, false);
       
        MAX_AclSave($acl, $aEntities);

        $block = _initCappingVariables($time, $cap, $session_capping);

        $values = array();
        $acls_updated = false;
        $now = OA::getNow();

        if ($aBannerPrev['block_ad'] <> $block) {
            $values['block'] = $block;
            $acls_updated = ($block == 0) ? true : $acls_updated;
        }
        if ($aBannerPrev['cap_ad'] <> $cap) {
            $values['capping'] = $cap;
            $acls_updated = ($cap == 0) ? true : $acls_updated;
        }
        if ($aBannerPrev['session_cap_ad'] <> $session_capping) {
            $values['session_capping'] = $session_capping;
            $acls_updated = ($session_capping == 0) ? true : $acls_updated;
        }
        if ($acls_updated) {
            $values['acls_updated'] = $now;
        }

        $doBanners = OA_Dal::factoryDO('banners');
        $doBanners->get($bannerid);
        if (!empty($values)) {
            $values['updated'] = $now;
            $doBanners->setFrom($values);
            $doBanners->update();
		}
		
        if ($_POST['customid'] != '' && $_POST['advertiserid'] != '') {
			// echo "<pre>";print_r('tets');echo "-----";exit;	
				$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
                    $doBanners = OA_Dal::factoryDO('banners');
                    $doBanners->get($bannerid);

                    OA_Dal_Delivery_query("UPDATE {$table_prefix}banners SET line_item_name = '' WHERE bannerid ='".$bannerid."' ");
                    
                    $deliveryQuery=OA_Dal_Delivery_query("SELECT * FROM {$table_prefix}acls where bannerid = ".$bannerid." and type = 'deliveryLimitations:Time:Date' order by executionorder asc");

					if(OA_Dal_Delivery_numRows($deliveryQuery)>0) {
						$time = array();
						$line_name = array();
                        
						while ($deliveryRes = OA_Dal_Delivery_fetchAssoc($deliveryQuery)) 
						{   
							if($deliveryRes['data'] != '00000000') {
								$test = explode('@',$deliveryRes['data']);
								$each = str_split($test['0']);
								$res = $each['0'].$each['1'].$each['2'].$each['3'].'-'.$each['4'].$each['5'].'-'.$each['6'].$each['7'];
								array_push($time,$res);
								$res_name = $each['2'].$each['3'].$each['4'].$each['5'].$each['6'].$each['7'];
								array_push($line_name,$res_name);
							}
						}
						// echo "<pre>";print_r($time);exit;
						$getName = $line_name['0']; 
						if($time['0']) {
							$activat_time = $time['0'];
						} else {
							$activat_time = '';
						}
						if($time['1']) {
							$expired_time = $time['1'];
						} else {
							$expired_time = '';
						}
						
					}
					$query="select * from {$table_prefix}clients where clientid='".$clientid."'";
					$rclientInfo = OA_Dal_Delivery_query($query);
					$aclientInfo = OA_Dal_Delivery_fetchAssoc($rclientInfo);  
					
					if($aBanner['xandrcreativeid'] != 0) {
						if($aBanner['line_item_name']) {
							$line_item_name = $aBanner['line_item_name'];
						} else {
							$line_item_name = $_POST['line_item_name'];
						}
					} else {
						$line_item_name = $getName.$_POST['line_item_name'];
                        // $line_item_name = $_POST['line_item_name'];
					}
                        
                    $values['advertiserid']      = !empty($_POST['advertiserid'] != '') ? $_POST['advertiserid'] : '';
                    $values['customid']          = !empty($_POST['customid'] != '') ? $_POST['customid'] : '';
                                
                    $values['currency']        = !empty($_POST['currency']) ? $_POST['currency'] : 'CHF';
                    $values['paymenttype']        = !empty($_POST['paymenttype']) ? $_POST['paymenttype'] : 'impression';
                    $values['creativerotation']        = !empty($_POST['creativerotation']) ? $_POST['creativerotation'] : 'ctr-optimized';
                    $values['adtype']        = !empty($_POST['adtype']) ? $_POST['adtype'] : 'banner';
                    $values['devicetypes'] = !empty($_POST['devicetypes']) ? $_POST['devicetypes'] : 'pc,phone,tablet';
                    $values['revenuetype'] = !empty($_POST['revenuetype']) ? $_POST['revenuetype'] : 'cost_plus_margin';
                    $values['maxcpm'] = !empty($_POST['maxcpm']) ? $_POST['maxcpm'] : '4';
                    $values['mincpm'] = !empty($_POST['mincpm']) ? $_POST['mincpm'] : '1';
                    $values['goaltarget']          = !empty($_POST['goaltarget'] != '') ? $_POST['goaltarget'] : '0';
                    $values['goalthreshold']       = !empty($_POST['goalthreshold'] != '') ? $_POST['goalthreshold'] : '1';
            
                    $values['lifetimebudget']       = !empty($_POST['lifetimebudget'] != '') ? $_POST['lifetimebudget'] : '12';
                    
                    $values['postgoaltarget']          = !empty($_POST['postgoaltarget'] != '') ? $_POST['postgoaltarget'] : '0';
                    $values['postgoalthreshold']       = !empty($_POST['postgoalthreshold'] != '') ? $_POST['postgoalthreshold'] : '1';
            
                    // $values['duration_start']    = !empty($_POST['banner_start'] != '') ? $_POST['banner_start'] : $activat_time;
                    // $values['duration_end']    =  !empty($_POST['banner_end'] != '') ? $_POST['banner_end'] : $expired_time;

					$values['duration_start']    = $activat_time;
                    $values['duration_end']    =  $expired_time;

                    $values['xandr_duration_start']    = date('Y-m-d', strtotime($values['duration_start'] . ' -'.$aclientInfo['default_date'].' day'));
                    $values['xandr_duration_end']    =  date('Y-m-d', strtotime($values['duration_end'] . ' +'.$aclientInfo['default_date'].' day'));
                    
                    $values['line_item_name']    =  $line_item_name;
                    $values['pacing_percent']       = !empty($_POST['pacing_percent'] != '') ? $_POST['pacing_percent'] : '100';
                    $values['deal_list']       = !empty($_POST['deal_list'] != '') ? $_POST['deal_list'] : '6691';
                
                    $values['api_description']   = !empty($_POST['api_description'] != '') ? $_POST['api_description'] : '';
            
                    $values['countryid']          = !empty($_POST['countryid'] != '') ? $_POST['countryid'] : '46';
                    
                    $values['regionid']       = !empty($_POST['regionid'] != '') ? $_POST['regionid'] : '';
                    $values['citiesid']       = !empty($_POST['citiesid'] != '') ? $_POST['citiesid'] : '';
                    
            
                    // echo "<pre>";print_r($values);exit;
            
                    $doBanners->setFrom($values);
                    $doBanners->update();
            
                    // Curl
                    if($_POST['regionid']){
                        $xandrRegtype = 'include';
                        $xandrregionid = $_POST['regionid'];

                        $allRegions = explode(',',$xandrregionid);
                        $region = array();
                        foreach($allRegions as $t1) {
                            $r1 = "id";
                            $m1 = '{"'.$r1.'":'.$t1.'}';
                            array_push($region,$m1);
                        }
                        $selRegions = implode(", ", $region);

                        $regionTarget = '"region_action": "'.$xandrRegtype.'","region_targets": ['.$selRegions.'],';
                    } 
                    /* else {
                        $xandrRegtype = 'exclude';
                        $xandrregionid = '632';
                    } */
                    

                    if($_POST['citiesid']){
                        $xandrcitytype = 'include';
                        $xandrcityid = $_POST['citiesid'];

                        $allCities = explode(',',$xandrcityid);
                        $city = array();
                        foreach($allCities as $t) {
                            $r = "id";
                            $m = '{"'.$r.'":'.$t.'}';
                            array_push($city,$m);
                        }
                        $selCities = implode(", ", $city);

                        $cityTarget = '"city_action": "'.$xandrcitytype.'","city_targets": ['.$selCities.'],';
                    } 
                    /* else {
                        $xandrcitytype = 'exclude';
                        $xandrcityid = '227702';
                    } */   
                    // echo "<pre>";print_r($cityTarget);exit;

                    
                    $allDevices = explode(',',$_POST['devicetypes']);
                    $devices = array();
                    foreach($allDevices as $devic) {
                        $f1 = '"'.$devic.'"';
                        array_push($devices,$f1);
                    }
                    $selDevices = implode(", ", $devices);
            
                    $custom_api_id = $_POST['customid'];
                    $api_adv_id = $_POST['advertiserid'];
            
                 
                    if($aBanner['xandrcreativeid'] != 0) {
                        // print_r('if');exit;
                        $curl_url = 'https://api.appnexus.com/creative?id='.$aBanner['xandrcreativeid'].'&advertiser_id='.$api_adv_id;
                        $reqParam = 'PUT';
                    } else {
                        $curl_url = 'https://api.appnexus.com/creative?advertiser_id='.$api_adv_id;
                        $reqParam = 'POST';
                    }
                    
                    $djprotocol = ($GLOBALS['_MAX']['SSL_REQUEST'])? 'https://': 'http://';
                     $imagedata = MAX_PATH.'/www/images/'.$aBanner['filename'];
                   
                    $base64 = base64_encode($imagedata);
                    $media_url = $djprotocol.$GLOBALS['conf']['webpath']['images'].'/'.$aBanner['filename']; 
                    $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
            
                    $query="select * from {$table_prefix}custom_api where customid='".$custom_api_id."'";
                    $rcustomInfo = OA_Dal_Delivery_query($query);
                    $acustomInfo = OA_Dal_Delivery_fetchAssoc($rcustomInfo);

                    // Curl start
                    $curl = curl_init();
            
                    curl_setopt_array($curl, array(
                    CURLOPT_URL => $acustomInfo['authurl'],
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS =>'{
                        "auth": {
                            "username" : "'.trim($acustomInfo['apiname']).'",
                            "password" : "'.base64_decode($acustomInfo['apipassword']).'"
                        }
                    }',
                    CURLOPT_HTTPHEADER => array(
                        'Content-Type: text/plain',
                    ),
                    ));
            
                    $response = curl_exec($curl);
            
                    curl_close($curl);
            
                    $result = json_decode($response, true);
                    
                    // echo "<pre>";print_r($result);exit;
                    
                    if($result['response']['status'] == 'OK') {
                        $auth_token = $result['response']['token'];
                        $cookie_token = str_replace(":","%3A",$auth_token);
                        
                        $ctoken = 'HBFAPI_SESSID='.$cookie_token.';IBAPI_SESSID='.$cookie_token;
                            
                        $height = $aBanner['height'];
                        $width = $aBanner['width'];
                        $zoneId=0;
                        
                        $secret = join("\t", [
                                base64_decode($GLOBALS['_MAX']['CONF']['delivery']['secret']),
                                $bannerid,
                                $zoneId
                            ]);
                        $sig= hash_hmac(
                                'sha256',
                                $aBanner['url'],
                                $secret
                            ); 
                        $rand=substr(md5(uniqid(time(), true)), 0, 10);
                        $djprotocol = ($GLOBALS['_MAX']['SSL_REQUEST'])? 'https://': 'http://';
                        $delivery=$djprotocol.$GLOBALS['_MAX']['CONF']['webpath']['delivery'];
                        $bannerUrl = urlencode($aBanner['url']);
                        $clickurl=  $delivery."/cl.php?bannerid={$bannerid}&zoneid=0&sig={$sig}&dest={$bannerUrl}";
                        $pixelurl= $delivery."/lg.php?bannerid={$bannerid}&campaignid={$aBanner['campaignid']}&zoneid=0&cb={$rand}";
                      
                        // creative service
                        $curl = curl_init();
                        
            
                        curl_setopt_array($curl, array(
                        CURLOPT_URL => $curl_url,
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => $reqParam,
                        CURLOPT_POSTFIELDS =>'{
                        "creative": {
                            "name": "'.$_POST['api_description'].'",
                            "advertiser_id": '.$api_adv_id.',
                            "format": "image",
                            "width": '.$aBanner['width'].',
                            "height": '.$aBanner['height'].',
                            "click_url": "'.$clickurl.'",
                            "click_url_enc": "'.$clickurl.'",
                            "allow_audit": true,
							"audit_status": "pending",
                            "track_clicks": true,
                            "pixels": [{
                                "format": "url-image",
                                "secure_url": "'.$pixelurl.'"
                            }],
                            "template":
                            {
                                "id": 4,
                                "name": "Image (Xandr Created)",
                                "description": null,
                                "is_archived": false,
                                "member_id": 13423,
                                "ad_type": "banner",
                                "track_on_callback": false,
                                "is_default": true,
                                "content_html": "<a href=\\"${CLICK_URL_ENC}${CLICK_URL}\\" target=\\"_blank\\"><img width=\\"${CREATIVE_WIDTH}\\" height=\\"${CREATIVE_HEIGHT}\\" style=\\"border-style: none\\" src=\\"${MEDIA_URL}\\" /></a>",
                                "content_js": "document.write(\'<a href=\\"${CLICK_URL_ENC}${CLICK_URL}\\" target=\\"_blank\\"><img width=\\"${CREATIVE_WIDTH}\\" height=\\"${CREATIVE_HEIGHT}\\" style=\\"border-style: none\\" src=\\"${MEDIA_URL}\\" /></a>\');",
                                "callback_content_html": null,
                                "media_subtype": {
                                    "id": 1,
                                    "name": "Standard Banner",
                                    "media_type_name": "Banner",
                                    "media_type_id": 1
                                },
                                "format": {
                                    "id": 4,
                                    "name": "image"
                                }
                            },
                            "media_url_secure": "'.$media_url.'",
                            "content_secure": "'.$base64.'"
                        }
                        }',
                        CURLOPT_HTTPHEADER => array(
                            'token:'.$auth_token,
                            'Content-Type: text/plain',
                            'cookie:'.$ctoken
                        ),
                        ));
            
                        $response = curl_exec($curl);
            
                        curl_close($curl);
                        
                        $res = json_decode($response, true);
                        
                        // echo "<pre>";print_r($res);echo "---";exit; 
                        
                        if($res['response']['status'] == 'OK') {
                            $xanderId = $res['response']['id'];
                            $member_id = '13423';
                            
                            OA_Dal_Delivery_query("UPDATE {$table_prefix}banners SET xandrcreativeid = '".$xanderId."' WHERE  bannerid ='".$bannerid."' ");
                            
                            $curl = curl_init();
            
                            curl_setopt_array($curl, array(
                            CURLOPT_URL => 'https://api.appnexus.com/profile?advertiser_id='.$api_adv_id.'&member_id='.$member_id,
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => '',
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 0,
                            CURLOPT_FOLLOWLOCATION => true,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_CUSTOMREQUEST => 'POST',
                            CURLOPT_POSTFIELDS =>'{
                                "profile": {
                                    "country_action": "include",
                                    "country_targets": [
                                        {
                                            "id": '.$_POST['countryid'].'
                                        }
                                    ],
                                    '.$regionTarget.'
                                    '.$cityTarget.'
                                    "daypart_targets": [
                                        {
                                            "day" : "all"
                                        }
                                    ],
                                    "device_type_action": "include",
                                    "device_type_targets": [
                                        '.$selDevices.'
                                    ],
                                    "deal_action_include": true,
                                    "postal_code_action_include": true,
                                    "ads_txt_authorized_only": false,
                                    "deal_list_targets": [{
                                        "id": '.$_POST['deal_list'].'
                                    }]
                                }
                            }',
                            CURLOPT_HTTPHEADER => array(
                                'token:'.$auth_token,
                                'Content-Type: text/plain',
                                'cookie:'.$ctoken
                            ),
                            ));
            
                            $response = curl_exec($curl);
            
                            curl_close($curl);
                            
                            $resp = json_decode($response, true);
                            
                            // echo "<pre>";print_r($resp);exit;
                            
                            if($resp['response']['status'] == 'OK') {
            
                                $profile_id = $resp['response']['id'];
            
                                $curl = curl_init();
            
                                curl_setopt_array($curl, array(
                                CURLOPT_URL => 'https://api.appnexus.com/insertion-order?advertiser_id='.$api_adv_id,
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_ENCODING => '',
                                CURLOPT_MAXREDIRS => 10,
                                CURLOPT_TIMEOUT => 0,
                                CURLOPT_FOLLOWLOCATION => true,
                                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                CURLOPT_CUSTOMREQUEST => 'POST',
                                CURLOPT_POSTFIELDS =>'{
                                "insertion-order": {
                                    "name": "'.$_POST['api_description'].'",
                                    "advertiser_id": '.$api_adv_id.',
                                    "state": "active",
                                    "budget_type": "revenue",
                                    "currency": "'.$_POST['currency'].'",
                                    "budget_intervals": [
                                    {
                                        "enable_pacing": true,
                                        "start_date": "'.$values['xandr_duration_start'].' 00:00:00",
                                        "end_date": "'.$values['xandr_duration_end'].' 23:59:59",
                                        "lifetime_budget": "'.$_POST['lifetimebudget'].'",
                                        "lifetime_pacing": true,
                                        "lifetime_pacing_pct":'.$_POST['pacing_percent'].'
                                    }
                                    ]
                                }
                                }',
                                CURLOPT_HTTPHEADER => array(
                                    'token:'.$auth_token,
                                    'Content-Type: text/plain',
                                    'cookie:'.$ctoken
                                ),
                                ));
            
                                $response = curl_exec($curl);
            
                                curl_close($curl);
                                
                                $insert_result = json_decode($response, true);
                                // echo "<pre>";print_r($insert_result);echo "********";
                                if($insert_result['response']['status'] == 'OK') {
                                    $insertion_id = $insert_result['response']['id'];
            
                                    $query="select * from {$table_prefix}campaigns where campaignid='".$campaignid."'";
                                    $rcampaignInfo = OA_Dal_Delivery_query($query);
                                    $acampaignInfo = OA_Dal_Delivery_fetchAssoc($rcampaignInfo);
            
                                    $rev_type = 'cpm';
                                    $revenue = $_POST['maxcpm'];
                       
            
                                    if($rev_type == 'cpm') {
                                        $curl = curl_init();
                                        curl_setopt_array($curl, array(
                                            CURLOPT_URL => 'https://api.appnexus.com/line-item?advertiser_id='.$api_adv_id,
                                            CURLOPT_RETURNTRANSFER => true,
                                              CURLOPT_ENCODING => '',
                                              CURLOPT_MAXREDIRS => 10,
                                              CURLOPT_TIMEOUT => 0,
                                              CURLOPT_FOLLOWLOCATION => true,
                                              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                              CURLOPT_CUSTOMREQUEST => 'POST',
                                              CURLOPT_POSTFIELDS =>'{  
                                               "line-item":{  
                                                  "name":"'.$values['line_item_name'].'",
                                                  "state":"active",
                                                  "currency": "'.$_POST['currency'].'",
                                                  "advertiser":{  
                                                     "id":'.$api_adv_id.'
                                                  },
                                                  "creative_distribution_type":"'.$_POST['creativerotation'].'",
                                                  "prefer_delivery_over_performance":false,
                                                  "insertion_orders":[  
                                                     {  
                                                        "id":'.$insertion_id.'
                                                     }
                                                  ],
                                                  "manage_creative":true,
                                                  "creatives":[  
                                                    {  
                                                       "id":'.$xanderId.'
                                                    }
                                                  ],
                                                  "line_item_type":"standard_v2",
                                                  "profile_id":'.$profile_id.',
                                                  "revenue_type":"'.$_POST['revenuetype'].'",
                                                  "budget_intervals": [
                                                    {
                                                        "start_date": "'.$values['xandr_duration_start'].' 00:00:00",
                                                        "end_date": "'.$values['xandr_duration_end'].' 23:59:59",
                                                        "lifetime_budget": "'.$_POST['lifetimebudget'].'",
                                                        "lifetime_pacing":true,
                                                        "enable_pacing":true,
                                                        "lifetime_pacing_pct":'.$_POST['pacing_percent'].'
                                                    }],
                                                    "goal_type":"none",
                                                    "goal_value":null,
                                                    "supply_strategies":[  
                                                        {  
                                                            "rtb":true,
                                                            "managed":false,
                                                            "deal":false,
                                                            "payment_auction_event_type":"'.$_POST['paymenttype'].'"
                                                        }
                                                    ],
                                                    "ad_types":[  
                                                        "'.$_POST['adtype'].'"
                                                    ],
                                                    "valuation":{  
                                                        "min_avg_cpm": '.$_POST['mincpm'].',
                                                        "max_avg_cpm": '.$_POST['maxcpm'].'
                                                    }
                                               }
                                            }',
                                            CURLOPT_HTTPHEADER => array(
                                                'token:'.$auth_token,
                                                'Content-Type: text/plain',
                                                'cookie:'.$ctoken
                                            ),
                                            ));
                    
                                            $response = curl_exec($curl);
                    
                                            curl_close($curl);
                                            // print_r($response);exit;
                                            $line_item = json_decode($response, true);
                                    }else {
                                        $query="select * from {$table_prefix}trackers where clientid='".$clientid."'";
                                        $trackerInfo = OA_Dal_Delivery_query($query);
                                        $trackerRes = OA_Dal_Delivery_fetchAssoc($trackerInfo);
            
                                        $rand=substr(md5(uniqid(time(), true)), 0, 10);
                                        $djprotocol = ($GLOBALS['_MAX']['SSL_REQUEST'])? 'https://': 'http://';
                                        $delivery=$djprotocol.$GLOBALS['_MAX']['CONF']['webpath']['delivery'];
                                        $trackerurl= $delivery."/ti.php?trackerid={$trackerRes['trackerid']}&cb={$rand}";
            
                                        $curl = curl_init();
            
                                        curl_setopt_array($curl, array(
                                        CURLOPT_URL => 'https://api.appnexus.com/pixel?advertiser_id='.$api_adv_id,
                                        CURLOPT_RETURNTRANSFER => true,
                                        CURLOPT_ENCODING => '',
                                        CURLOPT_MAXREDIRS => 10,
                                        CURLOPT_TIMEOUT => 0,
                                        CURLOPT_FOLLOWLOCATION => true,
                                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                        CURLOPT_CUSTOMREQUEST => 'POST',
                                        CURLOPT_POSTFIELDS =>'{
                                            "pixel": {
                                                "name": "'.$_POST['api_description'].' Pixel",
                                                "piggyback_pixels": [
                                                    {
                                                        "pixel_type": "img",
                                                        "url": "'.$trackerurl.'"
                                                    }
                                                ],
                                                "post_view_value": '.$revenue.',
                                                "state": "active",
                                                "trigger_type": "view"
                                            }
                                        }',
                                        CURLOPT_HTTPHEADER => array(
                                            'token:'.$auth_token,
                                            'Content-Type: text/plain',
                                            'cookie:'.$ctoken
                                        ),
                                        ));
            
                                        $pixelRes = curl_exec($curl);
            
                                        curl_close($curl);
            
                                        $pixelData = json_decode($pixelRes, true);
            
                                        if($pixelData['response']['status'] == 'OK') {
                                            $pixel_id = $pixelData['response']['id'];
            
                                            $curl = curl_init();
                                        curl_setopt_array($curl, array(
                                            CURLOPT_URL => 'https://api.appnexus.com/line-item?advertiser_id='.$api_adv_id,
                                            CURLOPT_RETURNTRANSFER => true,
                                              CURLOPT_ENCODING => '',
                                              CURLOPT_MAXREDIRS => 10,
                                              CURLOPT_TIMEOUT => 0,
                                              CURLOPT_FOLLOWLOCATION => true,
                                              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                              CURLOPT_CUSTOMREQUEST => 'POST',
                                              CURLOPT_POSTFIELDS =>'{  
                                               "line-item":{  
                                                  "name":"'.$values['line_item_name'].'",
                                                  "state":"active",
                                                  "currency": "CHF",
                                                  "advertiser":{  
                                                     "id":'.$api_adv_id.'
                                                  },
                                                  "creative_distribution_type":"'.$_POST['creativerotation'].'",
                                                  "prefer_delivery_over_performance":false,
                                                  "insertion_orders":[  
                                                     {  
                                                        "id":'.$insertion_id.'
                                                     }
                                                  ],
                                                  "manage_creative":true,
                                                  "creatives":[  
                                                    {  
                                                       "id":'.$xanderId.'
                                                    }
                                                  ],
                                                  "line_item_type":"standard_v2",
                                                  "profile_id":'.$profile_id.',
                                                  "revenue_type":"'.$_POST['revenuetype'].'",
                                                  "budget_intervals": [
                                                    {
                                                        "start_date": "'.$values['xandr_duration_start'].' 00:00:00",
                                                        "end_date": "'.$values['xandr_duration_end'].' 23:59:59",
                                                        "lifetime_budget": "'.$_POST['lifetimebudget'].'",
                                                        "lifetime_pacing":true,
                                                        "enable_pacing":true,
                                                        "lifetime_pacing_pct":'.$_POST['pacing_percent'].'
                                                    }],
                                                    "pixels":[  
                                                        {  
                                                            "id":'.$pixel_id.'
                                                        }
                                                    ],
                                                    "goal_type":"none",
                                                    "goal_value":null,
                                                    "goal_pixels":[  
                                                        {  
                                                            "id": '.$pixel_id.',
                                                            "post_click_goal_target":'.$_POST['postgoaltarget'].',
                                                            "post_click_goal_threshold":'.$_POST['postgoalthreshold'].'
                                                        }
                                                    ],
                                                  "supply_strategies":[  
                                                     {  
                                                        "rtb":true,
                                                        "managed":false,
                                                        "deal":false,
                                                        "payment_auction_event_type":"'.$_POST['paymenttype'].'"
                                                     }
                                                  ],
                                                  "ad_types":[  
                                                     "'.$_POST['adtype'].'"
                                                  ],
                                                  "valuation":{  
                                                    "min_avg_cpm": '.$_POST['mincpm'].',
                                                    "max_avg_cpm": '.$_POST['maxcpm'].'
                                                  }
                                               }
                                            }',
                                            CURLOPT_HTTPHEADER => array(
                                                'token:'.$auth_token,
                                                'Content-Type: text/plain',
                                                'cookie:'.$ctoken
                                            ),
                                            ));
                    
                                            $response = curl_exec($curl);
                    
                                            curl_close($curl);
                                            $line_item = json_decode($response, true);
            
                                        }
            
                                    }
            
                                }
                            }
            
                        }
                    }
                    // Curl end
                }

    } 
    // Queue confirmation message
    $translation = new OX_Translation ();
    $translated_message = $translation->translate ( $GLOBALS['strBannerAclHasBeenUpdated'], array(
        MAX::constructURL(MAX_URL_ADMIN, 'banner-edit.php?clientid=' .  $clientid . '&campaignid=' . $campaignid . '&bannerid=' . $bannerid),
        htmlspecialchars($doBanners->description)
    ));
    OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);

    header("Location: banner-acl.php?clientid={$clientid}&campaignid={$campaignid}&bannerid={$bannerid}");
    exit;
}

/*-------------------------------------------------------*/
/* HTML framework                                        */
/*-------------------------------------------------------*/
$entityId = OA_Permission::getEntityId();
if (OA_Permission::isAccount(OA_ACCOUNT_ADVERTISER)) {
    $entityType = 'advertiser_id';
} else {
    $entityType = 'agency_id';
}

// Display navigation
$aOtherCampaigns = Admin_DA::getPlacements(array($entityType => $entityId));
$aOtherBanners = Admin_DA::getAds(array('placement_id' => $campaignid), false);
// Setup a fake record for the "Apply to all" entry
$aOtherBanners[-1] = array('name' => '--' . $GLOBALS['strAllBannersInCampaign'] . '--', 'ad_id' => -1, 'placement_id' => $campaignid);
MAX_displayNavigationBanner($pageName, $aOtherCampaigns, $aOtherBanners, $aEntities);

/*-------------------------------------------------------*/
/* Main code                                             */
/*-------------------------------------------------------*/


$doBanners = OA_Dal::factoryDO('banners');
if ($doBanners->get($bannerid)) {
   $aBanner = $doBanners->toArray();
}

$aBannerDet = MAX_cacheGetAd($bannerid, false);
// echo "<pre>";print_r($aBanner);exit;
if (!isset($acl)) {
    $acl = Admin_DA::getDeliveryLimitations(array('ad_id' => $bannerid));
    // This array needs to be sorted by executionorder, this should ideally be done in SQL
    // When we move to DataObject this should be addressed
    ksort($acl);
}
if(count($acl) == 0)
{
    $acl[0] = array('comparison' => '==', 'data' => '', 'executionorder' => '0', 'logical' => 'and', 'type' => 'deliveryLimitations:Time:Date');
    $acl[1] = array('comparison' => '', 'data' => '', 'executionorder' => '1', 'logical' => 'and', 'type' => 'deliveryLimitations:Time:Date');
}

$aParams = array('clientid' => $clientid, 'campaignid' => $campaignid, 'bannerid' => $bannerid);

MAX_displayAcls($acl, $aParams);


echo "
<table border='0' width='100%' cellpadding='0' cellspacing='0' bgcolor='#FFFFFF'>";

$aParams = array(
    'title' => $GLOBALS['strCampaign'],
    'titleLink' => "campaign-edit.php?clientid=$clientid&campaignid=$campaignid",
    'aText' => $GLOBALS['strCappingCampaign'],
    'aCappedObject' => $aBannerDet,
    'type' => 'Campaign'
);
print_r($aParams);
$tabindex = _echoDeliveryCappingHtml($tabindex, $GLOBALS['strCappingBanner'], $aBannerDet, 'Ad', $aParams);

echo "
<tr><td height='1' colspan='6' bgcolor='#888888'>
<img src='" . OX::assetPath() . "/images/break.gif' height='1' width='100%'></td></tr>

</table>
<br /><br /><br />";

$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

$regcit_Query=OA_Dal_Delivery_query("SELECT region_id,city_id,advertiser_id FROM {$table_prefix}clients WHERE clientid='".$_GET['clientid']."'");
$api_Row=OA_Dal_Delivery_fetchAssoc($regcit_Query);

//packets data
$packet_Query=OA_Dal_Delivery_query("SELECT * FROM packets WHERE id=".$aBanner['packetid']);
$packet_Row=OA_Dal_Delivery_fetchAssoc($packet_Query);

if(isset($aBanner['advertiserid']) && $aBanner['advertiserid'] != '' && $aBanner['advertiserid'] > 0) {
    $aBanner['advertiserid'] = $aBanner['advertiserid'];
} else {
    $aBanner['advertiserid'] = $api_Row['advertiser_id'];
}

if(isset($aBanner['goaltarget']) && $aBanner['goaltarget'] != '') {
    $aBanner['goaltarget'] = $aBanner['goaltarget'];
} else {
    $aBanner['goaltarget'] = '0';
}

if(isset($aBanner['goalthreshold']) && $aBanner['goalthreshold'] != '') {
    $aBanner['goalthreshold'] = $aBanner['goalthreshold'];
} else {
    $aBanner['goalthreshold'] = '1';
}

if(isset($packet_Row['lifetime']) && $packet_Row['lifetime'] != '') {
    $aBanner['lifetimebudget'] = $packet_Row['lifetime'];
} else {
    $aBanner['lifetimebudget'] = '12';
}

if(isset($aBanner['postgoaltarget']) && $aBanner['postgoaltarget'] != '') {
    $aBanner['postgoaltarget'] = $aBanner['postgoaltarget'];
} else {
    $aBanner['postgoaltarget'] = '0';
}

if(isset($aBanner['postgoalthreshold']) && $aBanner['postgoalthreshold'] != '') {
    $aBanner['postgoalthreshold'] = $aBanner['postgoalthreshold'];
} else {
    $aBanner['postgoalthreshold'] = '1';
}


        $deliveryQuery=OA_Dal_Delivery_query("SELECT * FROM {$table_prefix}acls where bannerid = ".$bannerid." and type = 'deliveryLimitations:Time:Date' order by executionorder asc");
        if(OA_Dal_Delivery_numRows($deliveryQuery)>0) {
            $time = array();
            $line_name = array();
            while ($deliveryRes = OA_Dal_Delivery_fetchAssoc($deliveryQuery)) 
            {   
                if($deliveryRes['data'] != '00000000') {
                    $test = explode('@',$deliveryRes['data']);
                    $each = str_split($test['0']);
                    $res = $each['0'].$each['1'].$each['2'].$each['3'].'-'.$each['4'].$each['5'].'-'.$each['6'].$each['7'];
                    array_push($time,$res);
                    $res_name = $each['2'].$each['3'].$each['4'].$each['5'].$each['6'].$each['7'];
                    array_push($line_name,$res_name);
                }
            }
                // echo "<pre>";print_r($line_name);exit;
            $getName = $line_name['0']; 
            if($time['0']) {
                $activat_time = $time['0'];
            } else {
                $activat_time = '';
            }
            if($time['1']) {
                $expired_time = $time['1'];
            } else {
                $expired_time = '';
            }
            
        } 

        $query="select * from {$table_prefix}clients where clientid='".$clientid."'";
        $rclientInfo = OA_Dal_Delivery_query($query);
        $aclientInfo = OA_Dal_Delivery_fetchAssoc($rclientInfo);        

        // if($getName) {
            $line_item_name = $getName.'_'.$aclientInfo['clientname'].'_'.$aBanner['description'];
        /*} else {
            $line_item_name = '';
        }*/

        if(isset($aBanner['line_item_name']) && $aBanner['line_item_name'] != '') {
            $aBanner['line_item_name'] = $aBanner['line_item_name'];
        } else {
            $aBanner['line_item_name'] = $line_item_name;
        }

        // echo "<pre>";print_r($line_item_name);exit;
        
        if(isset($aBanner['duration_start']) && $aBanner['duration_start'] != '') {
            $aBanner['duration_start'] = $aBanner['duration_start'];
        } else {
            $aBanner['duration_start'] = $activat_time;
        }

        if(isset($aBanner['duration_end']) && $aBanner['duration_end'] != '') {
            $aBanner['duration_end'] = $aBanner['duration_end'];
        } else {
            $aBanner['duration_end'] = $expired_time;
        }

        // echo "<pre>";print_r($aBanner);echo "----";

        if(isset($aBanner['xandr_duration_start']) && $aBanner['xandr_duration_start'] != '') {
            $aBanner['xandr_duration_start'] = $aBanner['xandr_duration_start'];
        } else {
            if($aBanner['duration_start']) {
                $xandr_sDate = date('Y-m-d', strtotime($aBanner['duration_start'] . ' -'.$aclientInfo['default_date'].' day'));
                $aBanner['xandr_duration_start'] = $xandr_sDate;
            } else {
                $aBanner['xandr_duration_start'] = '';
            }
        }

        if(isset($aBanner['xandr_duration_end']) && $aBanner['xandr_duration_end'] != '') {
            $aBanner['xandr_duration_end'] = $aBanner['xandr_duration_end'];
        } else {
            if($aBanner['duration_end']) {
                $xandr_eDate = date('Y-m-d', strtotime($aBanner['duration_end'] . ' +'.$aclientInfo['default_date'].' day'));
                $aBanner['xandr_duration_end'] = $xandr_eDate;
            } else {
                $aBanner['xandr_duration_end'] = '';
            }
        }

        if(isset($aBanner['regionid']) && $aBanner['regionid'] != '') {
            $aBanner['regionid'] = $aBanner['regionid'];
        } else {
            $aBanner['regionid'] = $api_Row['region_id'];
        }

        if(isset($aBanner['citiesid']) && $aBanner['citiesid'] != '') {
            $aBanner['citiesid'] = $aBanner['citiesid'];
        } else {
            $aBanner['citiesid'] = $api_Row['city_id'];
        }

        if(isset($aBanner['currency']) && $aBanner['currency'] != '') {
            $aBanner['currency'] = $aBanner['currency'];
        } else {
            $aBanner['currency'] = 'CHF';
        }
        if(isset($aBanner['paymenttype']) && $aBanner['paymenttype'] != '') {
            $aBanner['paymenttype'] = $aBanner['paymenttype'];
        } else {
            $aBanner['paymenttype'] = 'impression';
        }
        if(isset($aBanner['creativerotation']) && $aBanner['creativerotation'] != '') {
            $aBanner['creativerotation'] = $aBanner['creativerotation'];
        } else {
            $aBanner['creativerotation'] = 'ctr-optimized';
        }
        if(isset($aBanner['adtype']) && $aBanner['adtype'] != '') {
            $aBanner['adtype'] = $aBanner['adtype'];
        } else {
            $aBanner['adtype'] = 'banner';
        }
        if(isset($aBanner['devicetypes']) && $aBanner['devicetypes'] != '') {
            $aBanner['devicetypes'] = $aBanner['devicetypes'];
        } else {
            $aBanner['devicetypes'] = 'pc,phone,tablet';
        }
        if(isset($aBanner['revenuetype']) && $aBanner['revenuetype'] != '') {
            $aBanner['revenuetype'] = $aBanner['revenuetype'];
        } else {
            $aBanner['revenuetype'] = 'cost_plus_margin';
        }
        if(isset($packet_Row['mx_cpm']) && $packet_Row['mx_cpm'] != '') {
            $aBanner['maxcpm'] = $packet_Row['mx_cpm'];
        } else {
            $aBanner['maxcpm'] = '4';
        }
        if(isset($packet_Row['mcpm']) && $packet_Row['mcpm'] != '') {
            $aBanner['mincpm'] = $packet_Row['mcpm'];
        } else {
            $aBanner['mincpm'] = '1';
        }
        if(isset($packet_Row['imp_cpm']) && $packet_Row['imp_cpm'] != '') {
            $aBanner['imp_cpm'] = $packet_Row['imp_cpm'];
        } else {
            $aBanner['imp_cpm'] = '1';
        }
        if(isset($aBanner['api_description']) && $aBanner['api_description'] != '') {
            $aBanner['api_description'] = $aBanner['api_description'];
        } else {
            $aBanner['api_description'] = $aBanner['description'];
        }
        if(isset($aBanner['pacing_percent']) && $aBanner['pacing_percent'] != '') {
            $aBanner['pacing_percent'] = $aBanner['pacing_percent'];
        } else {
            $aBanner['pacing_percent'] = '100';
        }
        if(isset($aBanner['deal_list']) && $aBanner['deal_list'] != '') {
            $aBanner['deal_list'] = $aBanner['deal_list'];
        } else {
            $aBanner['deal_list'] = '6691';
        } 

echo "<input name='xandrId' type='hidden' value='".$aBanner['xandrcreativeid']."' />
<input id='start_duration' name='start_duration' type='hidden' value='' />
<input id='end_duration' name='end_duration' type='hidden' value='' />
<table border='0' width='100%' cellpadding='0' cellspacing='0' bgcolor='#FFFFFF'>
    <td height='25' colspan='3' bgcolor='#FFFFFF'>
        <b>Custom Api</b>
      </td>        
    <tr>
        <td height='1' colspan='6'>Custom Api</td>
        <td height='1' colspan='6'>
            <select id='customid' name='customid' onchange=customChange(this.value);' class='medium'>
                <option value=''>-- Select Api --</option>";

            $query=OA_Dal_Delivery_query("SELECT api.* FROM {$table_prefix}custom_api as api");
            if(OA_Dal_Delivery_numRows($query)>0)
            {
                while ($row = OA_Dal_Delivery_fetchAssoc($query)) 
                {      
                    if($row['customid'] == $aBanner['customid'])
                    {
                        $djax_chk='selected=selected';
                    }
                    else
                    {
                        $djax_chk='selected=selected';
                        //$djax_chk='';
                    }   
                    
                    echo "<option ".$djax_chk." value=".$row['customid'].">".$row['name']."</option>";
                }
            }
            echo "</select>
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Advertiser Id</td>
        <td height='1' colspan='6'>
            <input name='advertiserid' type='text' value='".$aBanner['advertiserid']."' id='advertiserid' class='medium'>
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>        
        <tr>
        <td height='1' colspan='6'>Custom Name</td>
        <td height='1' colspan='6'>
            <input name='api_description' type='text' value='".$aBanner['api_description']."' id='api_description' class='medium'>
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>        
        <tr>
        <td height='1' colspan='6'>Line Item Name</td>
        <td height='1' colspan='6'>
            <input name='line_item_name' type='text' value='".$aBanner['line_item_name']."' id='line_item_name' class='medium'>
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Goal Target</td>
        <td height='1' colspan='6'>
            <input name='goaltarget' type='text' value='".$aBanner['goaltarget']."' id='goaltarget' class='medium'>
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Goal Threshold</td>
        <td height='1' colspan='6'>
            <input name='goalthreshold' type='text' value='".$aBanner['goalthreshold']."' id='goalthreshold' class='medium'>
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Life Time Budget</td>
        <td height='1' colspan='6'>
            <input name='lifetimebudget' type='text' value='".$aBanner['lifetimebudget']."' id='lifetimebudget' class='medium'>
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Post Click Goal Target</td>
        <td height='1' colspan='6'>
            <input name='postgoaltarget' type='text' value='".$aBanner['postgoaltarget']."' id='postgoaltarget' class='medium'>
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Post Click Goal Threshold</td>
        <td height='1' colspan='6'>
            <input name='postgoalthreshold' type='text' value='".$aBanner['postgoalthreshold']."' id='postgoalthreshold' class='medium'>
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Banner Duration</td>
        <td height='1' colspan='6'>
            <input class='date1' name='banner_start' id='banner_start' type='text' onchange='banner_duration(this.id,this.value)' value='".$aBanner['duration_start']."' tabindex='2'/>
            <input type='image' src='".OX::assetPath ()."/images/icon-calendar.gif' class= 'calendar_icon' id='banner_start_button' align='absmiddle' border='0' tabindex='3' />
            <input class='date1' name='banner_end' id='banner_end' type='text' onchange='banner_duration(this.id,this.value)' value='".$aBanner['duration_end']."' tabindex='4' /> 
            <input type='image' src='".OX::assetPath ()."/images/icon-calendar.gif' class= 'calendar_icon' id='banner_end_button' align='absmiddle' border='0' tabindex='3' />
            <script type='text/javascript'>
                Calendar.setup({
                    inputField: 'banner_start',
                    ifFormat: '%Y-%m-%d',
                    button: 'banner_start_button',
                    align: 'Bl',
                    weekNumbers: false,
                    firstDay: 1,
                    electric: false
                });
            
                Calendar.setup({
                    inputField: 'banner_end',
                    ifFormat: '%Y-%m-%d',
                    button: 'banner_end_button',
                    align: 'Bl',
                    weekNumbers: false,
                    firstDay: 1,
                    electric: false
                });
                
                // var banner_start = '".$aBanner['duration_start']."';
                // var banner_end = '".$aBanner['duration_end']."';
            
                // $('input[id=start_duration]').val(banner_start);
                // $('input[id=end_duration]').val(banner_end);
            
            function banner_duration(id,value){
            // if(id=='duration_start'){ 
                    $('input[id=start_duration]').val($('#banner_start').val());
                    
            // }
            // if(id=='duration_end'){
                    $('input[id=end_duration]').val($('#banner_end').val());
            // }
            }
            </script>
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Banner visible in Xandr/BannerSecondTag</td>
        <td height='1' colspan='6'>
            <input class='date1' name='xandr_banner_start' id='xandr_banner_start' type='text' onchange='banner_duration(this.id,this.value)' value='".$aBanner['xandr_duration_start']."' tabindex='2'/>
            <input type='image' src='".OX::assetPath ()."/images/icon-calendar.gif' class= 'calendar_icon' id='xandr_banner_start_button' align='absmiddle' border='0' tabindex='3' />
            <input class='date1' name='xandr_banner_end' id='xandr_banner_end' type='text' onchange='banner_duration(this.id,this.value)' value='".$aBanner['xandr_duration_end']."' tabindex='4' /> 
            <input type='image' src='".OX::assetPath ()."/images/icon-calendar.gif' class= 'calendar_icon' id='xandr_banner_end_button' align='absmiddle' border='0' tabindex='3' />
            <script type='text/javascript'>
                Calendar.setup({
                    inputField: 'xandr_banner_start',
                    ifFormat: '%Y-%m-%d',
                    button: 'xandr_banner_start_button',
                    align: 'Bl',
                    weekNumbers: false,
                    firstDay: 1,
                    electric: false
                });
            
                Calendar.setup({
                    inputField: 'xandr_banner_end',
                    ifFormat: '%Y-%m-%d',
                    button: 'xandr_banner_end_button',
                    align: 'Bl',
                    weekNumbers: false,
                    firstDay: 1,
                    electric: false
                });
                
            </script>
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Country</td>
        <td height='1' colspan='6'>
            <select id='countryid' name='countryid' class='medium'>
                <option value='46'>Switzerland</option>
            </select>         
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Region</td>
        <td height='1' colspan='6'>
            <textarea name='regionid' id='regionid' class='large small-h'>".$aBanner['regionid']."</textarea>        
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Cities</td>
        <td height='1' colspan='6'>
            <textarea name='citiesid' id='citiesid' class='large small-h'>".$aBanner['citiesid']."</textarea>        
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Currency</td>
        <td height='1' colspan='6'>
            <input name='currency' type='text' value='".$aBanner['currency']."' id='currency' class='medium'  />
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Payment Type</td>
        <td height='1' colspan='6'>
            <input name='paymenttype' type='text' value='".$aBanner['paymenttype']."' id='paymenttype' class='medium'  />
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Creative Rotation</td>
        <td height='1' colspan='6'>
            <input name='creativerotation' type='text' value='".$aBanner['creativerotation']."' id='creativerotation' class='medium'  />
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Ad Type</td>
        <td height='1' colspan='6'>
            <input name='adtype' type='text' value='".$aBanner['adtype']."' id='adtype' class='medium'  />
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Device Types</td>
        <td height='1' colspan='6'>
            <input name='devicetypes' type='text' value='".$aBanner['devicetypes']."' id='devicetypes' class='medium'  />
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Revenue Type</td>
        <td height='1' colspan='6'>
            <input name='revenuetype' type='text' value='".$aBanner['revenuetype']."' id='revenuetype' class='medium'  />
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Minimum CPM</td>
        <td height='1' colspan='6'>
            <input name='mincpm' type='text' value='".$aBanner['mincpm']."' id='mincpm' class='medium'  />
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Maximum CPM</td>
        <td height='1' colspan='6'>
            <input name='maxcpm' type='text' value='".$aBanner['maxcpm']."' id='maxcpm' class='medium'  />
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Impression CPM</td>
        <td height='1' colspan='6'>
            <input name='maxcpm' type='text' value='".$aBanner['imp_cpm']."' id='maxcpm' class='medium'  />
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Pacing Percent</td>
        <td height='1' colspan='6'>
            <input name='pacing_percent' type='text' value='".$aBanner['pacing_percent']."' id='pacing_percent' class='medium'  />
        </td>
        </tr>
        <tr class='space'><td style='height:1px;' colspan='3'>&nbsp;</td></tr>
        <tr>
        <td height='1' colspan='6'>Deal List</td>
        <td height='1' colspan='6'>
            <input name='deal_list' type='text' value='".$aBanner['deal_list']."' id='deal_list' class='medium'  />
        </td>
        </tr>
    </table>
<br /><br /><br />";

echo "<input type='submit' name='submit' value='{$GLOBALS['strSaveChanges']}' tabindex='".($tabindex++)."'>

</form>";


/*-------------------------------------------------------*/
/* Form requirements                                     */
/*-------------------------------------------------------*/
?>
<?php

_echoDeliveryCappingJs();

phpAds_PageFooter();

?>
