<?php

ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

$path = dirname(__FILE__);
require_once $path . '/../../init.php';
require_once MAX_PATH . '/lib/pear/Date.php';

use PHPMailer\PHPMailer\PHPMailer; 
use PHPMailer\PHPMailer\Exception;

require_once 'PHPMailer/src/Exception.php';
require_once 'PHPMailer/src/PHPMailer.php';
require_once 'PHPMailer/src/SMTP.php';


$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

$djprotocol = $GLOBALS['_MAX']['SSL_REQUEST'] ? 'https://' :'http://';

if($_REQUEST['PeriodPreset']!='')
{
	if($_REQUEST['PeriodPreset']=='today')
	{
		$start=date('Y-m-d');
		$end=date('Y-m-d');
	}
	else if($_REQUEST['PeriodPreset']=='yesterday')
	{
		$start=date('Y-m-d', strtotime('Yesterday'));
		$end=date('Y-m-d', strtotime('Yesterday'));
	}
	else if($_REQUEST['PeriodPreset']=='this_week')
	{
	$start=date('Y-m-d', strtotime('this week Monday'));
	$end=date('Y-m-d');
	}
	else if($_REQUEST['PeriodPreset']=='last_week')
	{
		$start=date('Y-m-d', strtotime('previous Monday'));
		$end=date('Y-m-d', strtotime('previous Sunday'));
	}
	else if($_REQUEST['PeriodPreset']=='last_7_days')
	{
		$start=date('Y-m-d', strtotime('Today - 7 Day'));
		$end=date('Y-m-d', strtotime('Today - 1 Day'));
	}
	else if($_REQUEST['PeriodPreset']=='this_month')
	{
		$start=date('Y-m-d', mktime(0, 0, 0, date('m'), 1, date('Y')));
		$end=date('Y-m-d');
	}
	else if($_REQUEST['PeriodPreset']=='last_month')
	{
		$start=date('Y-m-d', mktime(0, 0, 0, (date('m') - 1), 1, date('Y')));
		$end=date('Y-m-d', mktime(0, 0, 0, date('m'), 0, date('Y')));
	}
	else if($_REQUEST['PeriodPreset']=='all_stats')
	{
		$start='0000-00-00';
		$end=date('Y-m-d'); $PeriodPreset='all_stats';
	}
	else if($_REQUEST['PeriodPreset']=='specific')
	{
		$start=$_REQUEST['period_start'];
		$end=$_REQUEST['period_end'];
	}
}
else
{
	$start=date('Y-m-d');
	$end=date('Y-m-d');
}

$start_date=$start;
$end_date=$end;

if($PeriodPreset=='all_stats')
{
	$start_date="0000-00-00 00:00:00";
	$end_day=new Date(date('Y-m-d H:i:00'));
	$end_day->setHour(23);
	$end_day->setMinute(59);
	$end_day->setSecond(59);
	$end_day->toUTC();
	$end_date=$end_day->format('%Y-%m-%d %H:%M:%S');
}
else if($start_date=='' && $end_date=='')
{ 
	$start_day=new Date(date('Y-m-d H:i:00'));
	$start_day->setHour(0);
	$start_day->setMinute(0);
	$start_day->setSecond(0);
	$start_day->toUTC();
	$start_date=$start_day->format('%Y-%m-%d %H:%M:%S');
	$end_day=new Date(date('Y-m-d H:i:00'));
	$end_day->setHour(23);
	$end_day->setMinute(59);
	$end_day->setSecond(59);
	$end_day->toUTC();
	$end_date=$end_day->format('%Y-%m-%d %H:%M:%S'); 
}
else
{
	$end_day=new Date($end_date);
	$end_day->setHour(23);
	$end_day->setMinute(59);
	$end_day->setSecond(59);
	$end_day->toUTC();
	$end_date=$end_day->format('%Y-%m-%d %H:%M:%S');

	$start_day=new Date($start_date);
	$start_day->setHour(0);
	$start_day->setMinute(0);
	$start_day->setSecond(0);
	$start_day->toUTC();
	$start_date=$start_day->format('%Y-%m-%d %H:%M:%S');
}

$SendMail = array();
$clientid     = $_REQUEST['clientid'] ? $_REQUEST['clientid'] : '';
$campaignid   = $_REQUEST['campaignid'] ? $_REQUEST['campaignid'] : '';
$bannerid     = $_REQUEST['bannerid'] ? $_REQUEST['bannerid'] : '';
$PeriodPreset = $_REQUEST['PeriodPreset'] ? $_REQUEST['PeriodPreset'] : '';
$sendMail	  = $_REQUEST['SendMail'] ? $_REQUEST['SendMail'] :'';

if(!empty($sendMail))
{	
	$SendMail = explode(",",$sendMail);
}

$name = 'WilliWay';
$filename = '';
$storagetype = '';
$Banner = OA_Dal_Delivery_query("SELECT description AS name, filename, imageurl, bannertext, storagetype, storagetype FROM ".$table_prefix."banners WHERE bannerid = '".$bannerid."' ") or die("error1");
if(OA_Dal_Delivery_numRows($Banner) > 0 ) 
{	
	$row = OA_Dal_Delivery_fetchAssoc($Banner);
	$name 		 = $row['name'];
	$filename    = $row['filename'];
	$storagetype = $row['storagetype'];
	$contenttype = $row['contenttype'];
	$imageurl    = $row['imageurl'];
	$bannertext  = $row['bannertext'];
}

$bannerType = 0;
if($storagetype =='web')
{
	$ImgPath = $djprotocol . $GLOBALS['_MAX']['CONF']['webpath']['imagesSSL'].'/';   

	$imgSrc = $ImgPath.$filename;
	$bannerType = 1;
}
else if($storagetype =='sql')
{
	$ImgPath = $djprotocol . $GLOBALS['_MAX']['CONF']['webpath']['deliverySSL'].'/ai.php?filename=';   

	$imgSrc = $ImgPath.$filename.'&contenttype='.$contenttype;
	$bannerType = 1;
}
else if($storagetype =='url')
{
	$imgSrc = $imageurl;
	$bannerType = 1;
}
else if($storagetype =='txt')
{
	$imgSrc = $bannertext;
	$bannerType = 2;
}			

$PeriodStart= date("d-m-Y", strtotime($start_date));  
$PeriodEnd= date("d-m-Y", strtotime($end_date)); 


$subject = 'Banner-Bericht';

$message = '<html>
<body style="background-color: #64B5F6;">
	<div class="container text-center" style="background-color: #64B5F6;">
		<table class="table table-striped" style="width: 100%;background-color: #64B5F6;">
			<tr>
				<td width="20%"></td>
				<td width="20%"></td>
				<td width="20%"><img src="'.OX::assetPath ().'/images/Logo.png" style="width:300px;"></td>
				<td width="20%"></td>
				<td width="20%"></td>
			</tr>
		</table>
		<table class="table table-striped" style="width: 100%;background-color: #64B5F6;">
			<tr>
				<td width="30%">
					<h1 style="color:#fff;font-size: 36px;font-weight: bold;text-align: left;">Kampagnen&#252;bersicht</h1>
					<p style="color:#fff;font-size: 30px;font-weight: bold;text-align: left;">'.$name.'</p>
				</td>
				<td width="20%"></td>
				<td width="20%"></td>
				<td width="30%">
					<div style="background-color: white;padding: 5px;border-radius: 10px;">
						<p style="color:#87BFF1;font-size: 24px;font-weight: bold;text-align: center;margin: 2px;">'.$PeriodStart.' - '.$PeriodEnd.'</p>
					</div>
				</td>
			</tr>
		</table>
		<table class="table table-striped" style="width: 100%;background-color: #64B5F6;">
			<tr>
				<td width="35%">';
				
				if($bannerType == 1)
				{
					$message .= '<img src="'.$imgSrc.'" style="width:300px;margin-bottom: 170px;">';
				}
				else if($bannerType == 2)
				{
					$message .= '<div class="bannercode">'.$imgSrc.'</div>';
				}
				
				$message .= '</td>
				<td width="50%">
					<div style="">
						<h1 style="color:#000;font-size: 36px;font-weight: bold;padding:8px;display: inline-block;background-color: #FFF;-webkit-box-shadow: 0 10px 8px -6px black;-moz-box-shadow: 0 10px 8px -6px black;box-shadow: 0 10px 8px -6px black;text-align: left;">Luzerner Rundschau</h1></div>';
					

				//	$Report1 = OA_Dal_Delivery_query("SELECT date_time, sum(impressions) as impressions, sum(clicks) as clicks FROM ".$table_prefix."data_summary_ad_hourly WHERE zone_id != 0 A GROUP BY DATE(date_time) ORDER BY date_time") or die("error1");
					$Report1 = OA_Dal_Delivery_query("SELECT date_time, sum(impressions) as impressions, sum(clicks) as clicks FROM ".$table_prefix."data_summary_ad_hourly WHERE date_time between '{$start_date}' AND '{$end_date}' AND ad_id = '{$bannerid}' AND zone_id != 0 GROUP BY DATE(date_time) ORDER BY date_time") or die("error1");
					
						if(OA_Dal_Delivery_numRows($Report1) > 0 ) 
						{								
							$message .= '<h1 style="color:#fff;font-size: 26px;font-weight: bold;text-align: left;">Anzeigenimpression durch E-Crome</h1>
							<table class="table1" style="background-color:#fff;width: 100%;">';
																	
							$totalimp = 0;
							$totalclk = 0;
							$totalctr = 0;

							$i =1;
							
							while($row1 = OA_Dal_Delivery_fetchAssoc($Report1))
							{
								if($i == 1) 
								{
									$_class = "odd hilite";

									$CSS = 'border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;background-color: #f2f2f2 !important;';
								} 
								elseif($i%2 == 0) 
								{
									$_class = "even";

									$CSS = '';
								} 
								else 
								{
									$_class = "odd";

									$CSS = 'border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;background-color: #f2f2f2 !important;';

								}
								$i++;
								$CTR = 0;
								if(!empty($row1['impressions']) && !empty($row1['clicks']))
								{
									$CTR = number_format((($row1['clicks'] / $row1['impressions']) * 100),2).'%';
								}
								$clicks = $row1['clicks'] ? $row1['clicks'] : '-';						
								$ctr = $CTR ? $CTR : '-';
								$message .= '
									<tr style="'.$CSS.'">
										<td>'.date("d.m.Y", strtotime($row1['date_time'])).'</td>
										<td>'.$row1['impressions'].'</td>
										<td>'.$clicks.'</td>
										<td>'.$ctr.'</td>
									</tr>';


								$totalimp += $row1['impressions'];
								$totalclk += $row1['clicks'];
								$totalctr += $CTR;
							}

							$totalimp = $totalimp ? $totalimp : '-';
							$totalclk = $totalclk ? $totalclk : '-';
							
							$totalctr = number_format((($totalclk / $totalimp) * 100),2);
							$totalctr = $totalctr ? $totalctr.'%' : '-';
							
							$message .= '<tr>
								<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;background-color: #f2f2f2 !important;"></td>
								<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;background-color: #f2f2f2 !important;"><b>Impr.</b></td>
								<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;background-color: #f2f2f2 !important;"><b>Clicks</b></td>
								<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;background-color: #f2f2f2 !important;"><b>CTR</b></td>
							</tr>';


							$message .= '<tr>
								<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;"><b>Summe</b></td>
								<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;">'.$totalimp.'</td>
								<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;">'.$totalclk.'</td>
								<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;">'.$totalctr.'</td>
							</tr>';	
							
							$message .= '</table>';
						}		


					//$Report2 = OA_Dal_Delivery_query("SELECT date_time, sum(impressions) as impressions, sum(clicks) as clicks FROM ".$table_prefix."data_summary_ad_hourly WHERE zone_id = 0 GROUP BY DATE(date_time) ORDER BY date_time") or die("error1");bannerid
					$Report2 = OA_Dal_Delivery_query("SELECT date_time, sum(impressions) as impressions, sum(clicks) as clicks FROM ".$table_prefix."data_summary_ad_hourly WHERE date_time between '{$start_date}' AND '{$end_date}' AND ad_id ='{$bannerid}'  AND zone_id = 0 GROUP BY date_time ORDER BY date_time") or die("error1");
					
			
						if(OA_Dal_Delivery_numRows($Report2) > 0 ) 
						{								
							$message .= '<h1 style="color:#fff;font-size: 26px;font-weight: bold;text-align: left;">Anzeigenimpression durch einzelnes Tag</h1>
							<table class="table2" style="background-color: #fff;width: 100%;">';
							
							$i =1;

							$totalimp2 = 0;
							$totalclk2 = 0;
							$totalctr2 = 0;

							while($row2 = OA_Dal_Delivery_fetchAssoc($Report2))
							{
								if($i == 1) 
								{
									$_class = "odd hilite";

									$CSS = 'border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;background-color: #f2f2f2 !important;';
								} 
								elseif($i%2 == 0) 
								{
									$_class = "even";

									$CSS = '';
								} 
								else 
								{
									$_class = "odd";

									$CSS = 'border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;background-color: #f2f2f2 !important;';

								}
								$i++;
								$CTR = 0;
								if(!empty($row2['impressions']) && !empty($row2['clicks']))
								{
									$CTR = number_format((($row2['clicks'] / $row2['impressions']) * 100),2).'%';
								}
								$clicks = $row2['clicks'] ? $row2['clicks'] : '-';						
								$ctr = $CTR ? $CTR : '-';
								$message .= '
									<tr style="'.$CSS.'">
										<td>'.date("d.m.Y", strtotime($row2['date_time'])).'</td>
										<td>'.$row2['impressions'].'</td>
										<td>'.$clicks.'</td>
										<td>'.$ctr.'</td>
									</tr>';


								$totalimp2 += $row2['impressions'];
								$totalclk2 += $row2['clicks'];
								$totalctr2 += $CTR;
							}

							$totalimp2 = $totalimp2 ? $totalimp2 : '-';
							$totalclk2 = $totalclk2 ? $totalclk2 : '-';
							$totalctr2 = number_format((($totalclk2 / $totalimp2) * 100),2);
							$totalctr2 = $totalctr2 ? $totalctr2.'%' : '-';

							$message .= '<tr>
								<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;background-color: #f2f2f2 !important;"></td>
								<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;background-color: #f2f2f2 !important;"><b>Impr.</b></td>
								<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;background-color: #f2f2f2 !important;"><b>Clicks</b></td>
								<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;background-color: #f2f2f2 !important;"><b>CTR</b></td>
							</tr>';

							$message .= '<tr>
								<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;"><b>Summe</b></td>
								<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;">'.$totalimp2.'</td>
								<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;">'.$totalclk2.'</td>
								<td style="border-top: 1px solid lightgrey !important;border-bottom: 1px solid lightgrey !important;">'.$totalctr2.'</td>
							</tr>';	
							
							$message .= '</table>';

						}		
						
				$message .= '</td>
				<td width="15%"></td>
			</tr>
		</table>
	</div>
</body>
</html>';

echo $message;die();

if(!empty($SendMail))
{
	
	$email = new PHPMailer();
	$email->IsSMTP();
	$email->SMTPDebug = 0;
	$email->SMTPAuth = true;
	$email->SMTPSecure = 'ssl';
	$email->Host = "smtp.gmail.com";
	$email->Port = 465;
	$email->IsHTML(true);
	$email->Username = 'backend.developer2020@gmail.com';
	$email->Password = 'ujxlvdbjadzhjcpx';
	$email->setFrom("backend.developer2020@gmail.com", "Ecrome Admin");

	foreach ($SendMail as $key => $val) {
		
		$email->addAddress($val);
	}
	$email->Subject = $subject;
	$email->Body = $message;
	$mail = $email->send();

	$path = $djprotocol . $GLOBALS['_MAX']['CONF']['webpath']['admin'];       
			
	if(!empty($mail))
	{
		 echo "<script type='text/javascript'> window.location.href = '".$path."/campaign-banners.php';</script>";
		 exit;
	}
	else
	{	
		header("Location: ".$path."/banner-edit.php?clientid=".$clientid."&campaignid=".$campaignid."&bannerid=".$bannerid."");
		exit;
	}
}
else
{
	header("Location: ".$path."/banner-edit.php?clientid=".$clientid."&campaignid=".$campaignid."&bannerid=".$bannerid."");
	exit;
	//echo "<script type='text/javascript'> window.location.href = '".$path."banner-edit.php?clientid=".$clientid."&campaignid=".$campaignid."&bannerid=".$bannerid."; </script>";
}

?>
