<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

require_once LIB_PATH . '/Extension/deliveryLimitations/DeliveryLimitations.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
require_once MAX_PATH . '/lib/max/Delivery/limitations.delivery.php';

/**
 * A Client delivery limitation plugin, for filtering delivery of ads on the
 * basis of the viewer's IP address.
 *
 * Works with:
 * A string that describes a valid IP address, or a range or IP addresses, eg:
 *   10.0.0.*
 *
 * Valid comparison operators:
 * ==, !=
 *
 * @package    OpenXPlugin
 * @subpackage DeliveryLimitations
 */
class Plugins_DeliveryLimitations_Client_BlockedIp extends Plugins_DeliveryLimitations
{
    /**
     * Override the parent contstructor to:
     *  - Set the comparison operators (which are bespoke to this plugin); and
     *  - Set the name of the delivery rule for use in the UI.
     */
    function __construct()
    {
        $this->aOperations = array(
            '!=' => $GLOBALS['strDifferentFrom']);
        $this->aPatternOps = array('!=' => 'NOT LIKE');
        $this->aStandardOps = array('!=' => '!=');
        $aConf = $GLOBALS['_MAX']['CONF'];
        $this->nameEnglish = 'Client - Blocked IP address';
    }

    /**
     * Override the parent method to display the UI for the delivery rule.
     */
    function displayData()
    {
        $this->_displayMainUI();
    }

    /**
     * A private method for displaying the UI for the delivery rule when
     * the PHP intl extension is loaded, and the delivery rule is able to
     * be used.
     */
    function _displayMainUI()
    {
    	global $tabindex;
        // require_once is used here so that the JavaScript that updates lists
        // is only included once in the HTML, no matter times the plugin is
        // used for a single banner
        echo
            "<div style=\"float: left;\">" .
              "<textarea rows='10' cols='50' name='acl[{$this->executionorder}][data]' tabindex='".($tabindex++)."'>".
              htmlspecialchars(isset($this->data) ? $this->data : "") .
              "</textarea>" .
              "<br /><br />" .
              "<br /><br />" .
            "</div>";        
    }
    
}

?>
