<?php 
	include('session.php');
    include('../config.php'); ?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title><?php echo $projecttitle; ?> - GEO | Report </title>

    <meta name="description" content="" />
    <style>
        /* Loader */
        .loader {
            display: none;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999;
            background: rgba(255,255,255,0.8) url("../assets/img/loader.gif") center no-repeat;
        }

        .text-hide {
            display: block;
            width: 125px;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
        }

        .text-hide:hover {
            overflow: inherit;
            width: auto;
        }
        h5 {
            position: relative;
            left: 250%;
        }

        /* Geo Map Styles */
        #container1 {
            height: 500px;
            width: 800px;
            margin: 0 auto;
		}
			
		.highcharts-tooltip>span {
            padding: 10px;
            white-space: normal !important;
            width: 200px;
		}
			
		.loading {
            margin-top: 10em;
            text-align: center;
            color: gray;
		}
		
		.f32 .flag {
            vertical-align: middle !important;
		}

        /* .highcharts-legend-item{
		    display:none;
		} */
		
        /* .highcharts-exporting-group{
		display:none;
		 } */

         /* Close Button */
	   .dataTables_wrapper .dataTables_filter input:not(:valid):not(:focus){
	   box-shadow: 0 0 5px #fff!important;
		}
		.dataTables_wrapper .dataTables_filter input::-webkit-search-cancel-button {
		  -webkit-appearance: none!important;
		}
		.dataTables_wrapper .dataTables_filter button{
		  visibility: hidden;
		  outline: none;
		}
		.dataTables_wrapper .dataTables_filter input:valid ~ button{
		  visibility: visible;
		}
		
		button.close 
		{
		padding: 0;
		background-color: transparent;
		border: 0;
		-webkit-appearance: none;
		-moz-appearance: none;
		appearance: none;
		}
		.close {
		float: right;
		font-size: 1.5rem;
		font-weight: 700;
		line-height: 1;
		color: #000;
		text-shadow: 0 1px 0 #fff;
		opacity: .5;
	}
    </style>

    <!-- <style>
        .svgMap-map-wrapper {
            background: #fff !important;
        }
        .svgMap-country {
            stroke: #8592a3 !important;
            /* stroke: #ADD8E6 !important; */
            stroke-width: 1 !important;
        }
    </style> -->

    <?php include('head.php'); ?>

    <!--<link href="https://code.jquery.com/ui/1.10.4/themes/ui-lightness/jquery-ui.css" rel="stylesheet" />
    <script src="https://code.jquery.com/jquery-1.12.4.min.js"></script>
    <script src="https://code.jquery.com/ui/1.10.4/jquery-ui.js"></script>-->

    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <link href="https://cdn.jsdelivr.net/gh/StephanWagner/svgMap@v2.7.2/dist/svgMap.min.css" rel="stylesheet">

    <!-- Geo Map -->
    <script src="https://cdn.jsdelivr.net/npm/svg-pan-zoom@3.6.1/dist/svg-pan-zoom.min.js"></script>
	<script src="https://cdn.jsdelivr.net/gh/StephanWagner/svgMap@v2.7.2/dist/svgMap.min.js"></script>
	<link href="https://cdn.jsdelivr.net/gh/StephanWagner/svgMap@v2.7.2/dist/svgMap.min.css" rel="stylesheet">
</head>


<body onload="onChangeDetails()">
<div class="loader"></div>
    <!-- Geo Map -->
    <script src="https://code.highcharts.com/maps/highmaps.js"></script>
	<script src="https://code.highcharts.com/maps/modules/data.js"></script>
	<script src="https://code.highcharts.com/maps/modules/exporting.js"></script>
	<script src="https://code.highcharts.com/maps/modules/offline-exporting.js"></script>
	<script src="https://code.highcharts.com/maps/modules/accessibility.js"></script>
    <link rel="stylesheet" type="text/css" href="https://github.com/downloads/lafeber/world-flags-sprite/flags32.css">

    
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->

            <?php include('sidebar.php'); ?>

            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card mt-3">
                            <div class="card-body">
                                <div class='row'>
                                    <div class='col-6'>
                                        <h4 class="mb-4">Geo Report</h4>
                                    </div>
                                    <div class="col-3">
                                        <select id='getZone' class="form-select text-dark" aria-label="Default select example"
                                            onchange="onChangeDetails()">
                                            <option value="country" selected>Country</option>
                                            <option value="region">Region</option>
                                            <option value="city">City</option>
                                        </select>
                                    </div>
                                    <div class='col-3'>
                                        <select id='getDuration' name="allfilter" class="form-select text-dark"
                                            aria-label="Default select example" onchange="onChangeDetails()">
                                            <option value="Today" selected>Today</option>
                                            <option value="Yesterday">Yesterday</option>
                                            <option value="Last 7 days">Last 7 days</option>
                                            <option value="Last 30 days">Last 30 days</option>
                                            <option value="This Month">This Month</option>
                                            <option value="Last Month">Last Month</option>
                                            <option value='All Statistics'>All Statistics</option>
                                            <option value="custom">Custom</option>
                                        </select>
                                        <input style="display: none; width: 95%; margin-left:3%" id="daterange" name="daterange" class='mt-2'/>
                                    </div>
                                </div>
                                <br />

                                <div id="container1"></div>

                                <div class="row mt-5">
                                    <div class="mt-1 mb-3 container">
                                        <div class="table-responsive text-nowrap">
                                            <table id="georep" class="table table-hover table-striped">
                                                <thead id='geo_head'>
                                                    <tr class="text-nowrap text-dark">
                                                        <th class="th-color">Country</th>
                                                        <th class="th-color">ZoneName</th>
                                                        <th class="th-color">Impression</th>
                                                        <th class="th-color">Clicks</th>
                                                        <th class="th-color">CTR %</th>
                                                        <th class="th-color">ECPM</th>
                                                        <th class="th-color text-center">EARNINGS</th>
                                                    </tr>
                                                </thead>
                                                <tbody id='geo_table'></tbody>
                                            </table>
                                            <table id='region_table' class="table table-hover table-striped">
                                                <thead id="region_head">
                                                    <tr>
                                                        <th class="th-color">Country</th>
                                                        <th class="th-color">Region</th>
                                                        <th class="th-color">ZoneName</th>
                                                        <th class="th-color">Impression</th>
                                                        <th class="th-color">Clicks</th>
                                                        <th class="th-color">CTR %</th>
                                                        <th class="th-color">ECPM</th>
                                                        <th class="th-color text-center">EARNINGS</th>
                                                    </tr>
                                                </thead>
                                            </table>
                                            <table id='city_table' class="table table-hover table-striped">
                                                <thead id="city_head">
                                                    <tr>
                                                        <th class="th-color">Country</th>
                                                        <th class="th-color">City</th>
                                                        <th class="th-color">ZoneName</th>
                                                        <th class="th-color">Impression</th>
                                                        <th class="th-color">Clicks</th>
                                                        <th class="th-color">CTR %</th>
                                                        <th class="th-color">ECPM</th>
                                                        <th class="th-color text-center">EARNINGS</th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- / Content -->

                <?php include('footer.php'); ?>

				<script src="https://cdn.jsdelivr.net/npm/svg-pan-zoom@3.6.1/dist/svg-pan-zoom.min.js"></script>
                <script src="https://cdn.jsdelivr.net/gh/StephanWagner/svgMap@v2.7.2/dist/svgMap.min.js"></script>
                <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
                <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
                <script>

                    var live_URL = '<?php echo $apistatpath; ?>';
                    var token = 'Bearer '+ document.getElementById('token').value;
                    var affiliateid = document.getElementById('affiliateid').value;
                    var domain_url = live_URL+'/get_georeport__publisher_statistics/';
                    var map_url = live_URL+'/get_georeport_map__publisher_statistics/';
                    var allMap_url = live_URL + '/get_all_georeport_map__publisher_statistics/' + affiliateid;
                    var allTableData_url = live_URL + '/get_all_georeport__publisher_statistics/'+affiliateid;
					
                
                    function onChangeDetails() {
                        $(".loader").show();
                        let date = new Date();
                        let countryValue = document.getElementById('getZone').value;
                        let filtervalue = document.getElementById('getDuration').value;
                        
                        switch(filtervalue) {
                            case 'Today':
                                $("#daterange").css("display", "none");
                                let v3 = JSON.stringify(date);
                                v3 = v3.slice(1, 11);
                                var start_date = v3, end_date = v3;
                                getGeoDetails(start_date, end_date);
                            break;
                            case 'Yesterday' :
                                $("#daterange").css("display", "none");
                                let current_date = date.setDate(date.getDate() - 1);
                                const get_date = new Date(date);
                                let yesterday_date = JSON.stringify(get_date);
                                yesterday_date = yesterday_date.slice(1, 11);
                                getGeoDetails(yesterday_date, yesterday_date);
                            break;
                            case 'Last 7 days':
                                $("#daterange").css("display", "none");
                                let calculate_7dyas = date.setDate(date.getDate() - 7);
                                let start_7Days = new Date(calculate_7dyas);
                                let first_day = JSON.stringify(start_7Days);
                                first_day = first_day.slice(1, 11);

                                let todayDate = new Date();
                                let current_7Dyas = todayDate.setDate(todayDate.getDate() - 1);
                                let last_7Days = new Date(todayDate);
                                let date_end = JSON.stringify(last_7Days);
                                date_end = date_end.slice(1, 11);
                                getGeoDetails(first_day, date_end);
                            break;
                            case 'Last 30 days':
                                $("#daterange").css("display", "none");
                                let calculate_30dyas = date.setDate(date.getDate() - 30);
                                let start_30Days = new Date(calculate_30dyas);
                                var first_30Days = JSON.stringify(start_30Days);
                                first_30Days = first_30Days.slice(1, 11);

                                let today_Date = new Date();
                                let current_30Dyas = today_Date.setDate(today_Date.getDate() - 1);
                                let last_30Days = new Date(today_Date);
                                let final_30Days = JSON.stringify(last_30Days);
                                final_30Days = final_30Days.slice(1, 11);
                                getGeoDetails(first_30Days, final_30Days);
                            break;
                            case 'Last Month': 
                                $("#daterange").css("display", "none");
                                var prevMonthLastDate = new Date(date.getFullYear(), date.getMonth(), 0);
                                var prevMonthFirstDate = new Date(date.getFullYear() - (date.getMonth() > 0 ? 0 : 1), (date.getMonth() - 1 + 12) % 12, 1);
                                var formatDateComponent = function (dateComponent) {
                                    return (dateComponent < 10 ? '0' : '') + dateComponent;
                                }
                                var formatDate = function (date) {
                                    return date.getFullYear() + "-" + formatDateComponent(date.getMonth() + 1) + "-" + formatDateComponent(date.getDate())
                                };
                                getGeoDetails(formatDate(prevMonthFirstDate), formatDate(prevMonthLastDate));
                            break;
                            case 'This Month':
                                $("#daterange").css("display", "none");
                                let firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                                let cYear = firstDay.getFullYear(), cMonth = firstDay.getMonth() + 1, cDate = firstDay.getDate();
                                let start_thisMonth = cYear + "-" + cMonth + "-" + cDate;

                                let lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);
                                let year = lastDay.getFullYear(), month = lastDay.getMonth() + 1, day = lastDay.getDate();
                                let end_thisMonth = year + "-" + month + "-" + day;
                                getGeoDetails(start_thisMonth, end_thisMonth);
                            break;
                            case 'All Statistics':
                                $("#daterange").css("display", "none"); 
                                let value =0;
                                getGeoDetails(value, value);
                            break;
                            case 'custom':
                                $("#daterange").css("display", "block");
                                $(".loader").hide();
                                $(document).on('change', '#daterange', function () {
                                    let dates = $('#daterange').val();
                                    const daterange = dates.split("-");
                                });
                                $(function () {
                                    $('input[name="daterange"]').daterangepicker({
                                        opens: 'left',
                                        locale: {
                                            format: 'DD/MMM/YYYY'
                                        },
                                    }, function (start, end, label) {
                                        getGeoDetails(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));
                                    })
                                })
                            break;                         
                        };
                    };

                    function getGeoDetails(start_date,end_date) {
                        
                        let countryValue = document.getElementById('getZone').value;
                        let getMap_url = map_url+ start_date + ' 00:00:00,' + end_date + ' 23:59:59,' + affiliateid;
                        let table_url = domain_url + start_date + ' 00:00:00,' + end_date + ' 23:59:59,' + affiliateid;
                        
                        // Geo Map
                        $.ajax({
                            url: start_date ==0 && end_date ==0 ?allMap_url:getMap_url,
                            type: 'GET',
                            beforeSend: function (xhr) {
                                xhr.setRequestHeader('Authorization', token);
							},
                            data: {},
                            success: function (data) {
                                if (data.msg == 'No Stats Available') {
                                    $(".loader").hide();
                                    (async () => {
										const topology = await fetch(
										    'https://code.highcharts.com/mapdata/custom/world.topo.json'
										).then(response => response.json());
										     
										// Initialize the chart
										Highcharts.mapChart('container1', {
										            
                                            chart: { map: topology },
										    title: { text: 'Geo Map' },
										    mapNavigation: {
										        enabled: true,
										        buttonOptions: {
										            verticalAlign: 'bottom'
										        }
										    },
										    tooltip: {
										        backgroundColor: 'none',
										        borderWidth: 0,
										        shadow: false,
										        useHTML: true,
										        padding: 0,
										        pointFormat: '<span class="f32"><span class="flag {point.properties.hc-key}">' +
										        '</span></span> <span style="font-size:18px">{point.country}</span><br>' +
										        '<span style="font-size:18px; color:blue">Impression: {point.impressions}</span><br>'+
										        '<span style="font-size:18px; color:blue">Click: {point.clicks}</span>',
										        positioner: function () {
										            return { x: 0, y: 250 };
										        }
										    },
										    colorAxis: {
										        min: 1,
										        max: 1000,
										        type: 'logarithmic'
										    },
										    series: [{
										        data: [],
										        joinBy: ['iso-a2', 'countrycode'],
										        name: 'Geo Data',
										        states: {
										            hover: {
										                color: '#a4edba'
										            }
										        }
										    }],
											credits: false
										});
									})();
                                }
                                else {
                                    $(".loader").hide();
                                    (async () => {
										const topology = await fetch(
										    'https://code.highcharts.com/mapdata/custom/world.topo.json'
										).then(response => response.json());
										     
										// Initialize the chart
										Highcharts.mapChart('container1', {
                                            chart: { map: topology },
										    title: { text: 'Geo Map' },
										    mapNavigation: {
										        enabled: true,
										        buttonOptions: {
										            verticalAlign: 'bottom'
										        }
										    },
										    tooltip: {
										        backgroundColor: 'none',
										        borderWidth: 0,
										        shadow: false,
										        useHTML: true,
										        padding: 0,
										        pointFormat: '<span class="f32"><span class="flag {point.properties.hc-key}">' +
										        '</span></span> <span style="font-size:18px">{point.country}</span><br>' +
										        '<span style="font-size:18px; color:blue">Impression: {point.impressions}</span><br>'+
										        '<span style="font-size:18px; color:blue">Click: {point.clicks}</span>',
										        positioner: function () {
										            return { x: 0, y: 250 };
										        }
										    },
										    colorAxis: {
										        min: 1,
										        max: 1000,
										        type: 'logarithmic'
										    },
										    series: [{
										        data: data,
										        joinBy: ['iso-a2', 'countrycode'],
										        name: 'Geo Data',
										        states: {
										            hover: {
										                color: '#a4edba'
										            }
										        }
										    }],
											credits: false,
                                            responsive: {  
                                                rules: [{  
                                                    condition: {  
                                                      maxWidth: 500  
                                                    },  
                                                    chartOptions: {  
                                                      legend: {  
                                                        enabled: false  
                                                      }  
                                                    }  
                                                }]  
                                            }
										});
									})();
                                }
							},error: function () { },
						});


                        //Geo Table
                        $.ajax({
                            url: start_date ==0 && end_date ==0?allTableData_url:table_url,
                            type: 'GET',
                            beforeSend: function (xhr) {
                                xhr.setRequestHeader('Authorization', token);
                            },
                            data: {},
                            success: function (data) {                 
                                if (data.msg == 'No Stats Available') {
                                    $(".loader").hide();
                                    if (countryValue == 'country') {
                                        $('#georep').DataTable({
                                            ordering: false,
                                            destroy: true,
                                            responsive: true,
                                            bPaginate: false,
                                            bInfo: false,
                                            data:[],
                                            searching: false,
                                            oLanguage: {
                                                sEmptyTable:"No Data Found"
                                            }
                                        });
                                        document.getElementById('region_table').style.display = "none";
                                        document.getElementById('city_table').style.display = "none";
                                        $('#region_table').parents('div.dataTables_wrapper').first().hide();
                                        $('#city_table').parents('div.dataTables_wrapper').first().hide();
                                    }
                                    else if (countryValue == 'region') {
                                        $('#region_table').DataTable({
                                            ordering: false,
                                            destroy: true,
                                            responsive: true,
                                            bPaginate: false,
                                            bInfo: false,
                                            data:[],
                                            searching: false,
                                            oLanguage: {
                                                sEmptyTable:"No Data Found"
                                            }
                                        });
                                        document.getElementById('georep').style.display = "none";
                                        document.getElementById('city_table').style.display = "none";
                                        $('#georep').parents('div.dataTables_wrapper').first().hide();
                                        $('#city_table').parents('div.dataTables_wrapper').first().hide();
                                    }
                                    else if (countryValue == 'city') {
                                        $('#city_table').DataTable({
                                            ordering: false,
                                            destroy: true,
                                            responsive: true,
                                            bPaginate: false,
                                            bInfo: false,
                                            data:[],
                                            searching: false,
                                            oLanguage: {
                                                sEmptyTable:"No Data Found"
                                            }
                                        });
                                        document.getElementById('region_table').style.display = "none";
                                        document.getElementById('georep').style.display = "none";
                                        $('#georep').parents('div.dataTables_wrapper').first().hide();
                                        $('#region_table').parents('div.dataTables_wrapper').first().hide();
                                    }
                                    else {
                                        console.log("no data is selected");
                                    }
                                    
                                    document.getElementById('getZone').disabled = true;
                                }
                                else {
                                    $(".loader").hide();
                                    document.getElementById('getZone').disabled = false;
                                    if (countryValue == 'country') {
                                        document.getElementById('georep').style.display = "table";
                                        document.getElementById('region_table').style.display = "none";
                                        document.getElementById('city_table').style.display = "none";
                                        $('#region_table').parents('div.dataTables_wrapper').first().hide();
                                        $('#city_table').parents('div.dataTables_wrapper').first().hide();

										$('#georep').DataTable({
                                            ordering: true,
										    destroy: true,
											data: data,
											columns: [
												{ data: 'country'},
												{ data: 'zonename' },
												{ data: 'impressions', className: "text-center" },
												{ data: 'clicks', className: "text-center" },
												{ data: 'ctr', className: "text-center" },
                                                { data: 'ecpm', className: "text-center"},
												{ data: 'total_revenue', className: "text-center" }
											],
                                            initComplete: function(settings) {
											    $('#'+settings.nTable.id+'_filter input')
                                                .wrap(`<div class="d-inline-flex position-relative"></div>`)
                                                .after(`<button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
												        	  <span aria-hidden="true">&times;</span>
												        </button>`)
                                                .attr('required','required')
                                                .attr('title','Search');
                                              
											    // Click Event on Clear button
											    $(document).on('click', '#'+settings.nTable.id+'_filter button', function(){
												    $('#'+settings.nTable.id).DataTable({"retrieve": true})
                                                    .search('').draw(); // reDraw table
											    });
										    }
										});
                                                
                                    }
                                    else if (countryValue == 'region') {
                                        document.getElementById('region_table').style.display = "table";
                                        document.getElementById('georep').style.display = "none";
                                        document.getElementById('city_table').style.display = "none";
                                        $('#georep').parents('div.dataTables_wrapper').first().hide();
                                        $('#city_table').parents('div.dataTables_wrapper').first().hide();
                                                
										$('#region_table').DataTable({
                                            ordering: true,
										    destroy: true,
											data: data,
											columns: [
												{ data: 'country' },
												{ data: 'region' },
												{ data: 'zonename' },
												{ data: 'impressions', className: "text-center"},
												{ data: 'clicks', className: "text-center"},
												{ data: 'ctr', className: "text-center" },
                                                { data: 'ecpm', className: "text-center" },
												{ data: 'total_revenue', className: "text-center" }
											],
                                            initComplete: function(settings){
											    $('#'+settings.nTable.id+'_filter input')
                                                .wrap(`<div class="d-inline-flex position-relative"></div>`)
                                                .after(`<button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
													        <span aria-hidden="true">&times;</span>
													    </button>`)
                                                .attr('required','required').attr('title','Search');
                                              
											   // Click Event on Clear button
											    $(document).on('click', '#'+settings.nTable.id+'_filter button', function(){
												 $('#'+settings.nTable.id).DataTable({
												   "retrieve": true,
												  }).search('').draw();
											    });
											}
										});
                                    }
                                    else if (countryValue == 'city') {
                                        document.getElementById('city_table').style.display = "table";
                                        document.getElementById('region_table').style.display = "none";
                                        document.getElementById('georep').style.display = "none";
                                        $('#georep').parents('div.dataTables_wrapper').first().hide();
                                        $('#region_table').parents('div.dataTables_wrapper').first().hide();

										$('#city_table').DataTable({
                                            ordering: true,
										    destroy: true,
											data: data,
											columns: [
												{ data: 'country' },
												{ data: 'city' },
												{ data: 'zonename' },
												{ data: 'impressions', className: "text-center" },
												{ data: 'clicks', className: "text-center" },
												{ data: 'ctr', className: "text-center" },
                                                { data: 'ecpm', className: "text-center" },
												{ data: 'total_revenue', className: "text-center" }
											],
                                            initComplete: function(settings){
											    //settings.nTable.id --> Get table ID
											    $('#'+settings.nTable.id+'_filter input')
                                                .wrap(`<div class="d-inline-flex position-relative"></div>`)
                                                .after(`<button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
											    	        <span aria-hidden="true">&times;</span>
											    	    </button>`)
                                                .attr('required','required').attr('title','Search');
                                        
											    // Click Event on Clear button
											    $(document).on('click', '#'+settings.nTable.id+'_filter button', function(){
											     $('#'+settings.nTable.id).DataTable({
											       "retrieve": true,
											      }).search('').draw(); // reDraw table
											    });
											}
										});
                                    }
                                    else {
                                        console.log("geo is Not working");
                                    }
                                }                                
                                    
                            }
                        });
                    };

                </script>

                <div class="content-backdrop fade"></div>
            </div>
            <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
    </div>

    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>
    </div>
</body>
</html>