<?php
include('session.php');
include('../config.php');
include('../common.php'); ?>
<!DOCTYPE html>
<!-- beautify ignore:start -->
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="../assets/" data-template="vertical-menu-template-free">
  <head>
  <title><?php echo $projecttitle; ?> - Dashboard</title>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
  <meta name="description" content="" />
  <style>
    .text-hide{
    /* display: block; */
    width: 125px;
    overflow: hidden;
    white-space: nowrap;
    text-overflow: ellipsis;
    }

    .tooltip {
      position: relative;
      display: inline-block;
    }

    .tooltip .tooltiptext {
      visibility: hidden;
      width: 120px;
      background-color: gray;
      color: #fff;
      text-align: center;
      border-radius: 6px;
      padding: 5px 0;
    
      /* Position the tooltip */
      position: absolute;
      z-index: 1;
    }
    
    .tooltip:hover .tooltiptext {
      visibility: visible;
    }

    .text-hide:hover{
    overflow: inherit;
    width: auto;
    }

    .wrapper 
    {
        width: 100%;
        display: block;
        overflow: hidden;
        margin: 0 auto;
        padding: 60px 50px;
        background: #fff;
        border-radius: 4px;
    }

    .bar_canvas {
        background: #fff;
        height: 300px;
    }
    
    .loader
    {
        display: none;
        position: fixed;
        width: 100%;
        height: 100%;
        top: 0;
        left: 0;
        z-index: 999;
        background: rgba(255,255,255,0.8) url("../assets/img/loader.gif") center no-repeat;
    }

    /* colse button */
    .dataTables_wrapper .dataTables_filter input:not(:valid):not(:focus){
	   box-shadow: 0 0 5px #fff!important;
		}
		.dataTables_wrapper .dataTables_filter input::-webkit-search-cancel-button {
		  -webkit-appearance: none!important;
		}
		.dataTables_wrapper .dataTables_filter button{
		  visibility: hidden;
		  outline: none;
		}
		.dataTables_wrapper .dataTables_filter input:valid ~ button{
		  visibility: visible;
		}
    </style>

    <?php include('head.php'); ?>
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.6.0/Chart.min.js"></script>
  </head>

  <body onload="dash_filter()">
  <div class="loader"></div>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->
        <?php include('sidebar.php'); ?>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page" id="myImage">
          <!-- Navbar -->
          <?php include('navbar.php'); ?>
          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->
            <div class="container-xxl flex-grow-1 container-p-y">
                <div class="row">
                    <div class="col col-12 col-xs-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4 d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
                        <div class="d-flex justify-content-start">
                            <!-- <p class="h3">Dashboard</p> -->
                            <p class="h3"><?php echo $GLOBALS['strDashboard_Title']; ?></p>
                            <input type="hidden" name="clientid" id="clientid" value="<?php echo $_SESSION['clientid']; ?>">
                        </div>
                    </div>
                    <div class="col col-12 col-xs-12 col-sm-12 col-md-8 col-lg-8 col-xl-8 col-xxl-8  d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                        <div class="d-flex justify-content-end">
                            <div class="mb-3 w-50" style="padding-left: 20px;">
                                <select id="getDuration" class="form-select text-dark" 
                                onchange="dash_filter()">
                                    <option value="Today"><?php echo $GLOBALS['strToday']; ?></option>
                                    <option value="Yesterday"><?php echo $GLOBALS['strYesterday']; ?></option>
                                    <option selected value="Last 7 days"><?php echo $GLOBALS['strLast_7_days']; ?></option>
                                    <option value="Last 30 days"><?php echo $GLOBALS['strLast 30 days']; ?></option>
                                    <option value="custom"><?php echo $GLOBALS['strCustom']; ?></option> 
                                </select>
                                <input style="display: none; width: 95%; margin-left:3%" id="daterange" name="daterange" class='mt-2' value="select Date"/>
                            </div>
                            <div class="mb-3 w-50">
                                <select id="getTypeofreports" class="form-select text-dark" onchange='dash_filter();'>
                                    <option selected value="xandr"><?php echo $GLOBALS['strXandr']; ?></option>
                                    <option value="revive"><?php echo $GLOBALS['strRevive']; ?></option>
                                    <option value="all"><?php echo $GLOBALS['strAlloption']; ?></option>
                                    <option value="all_web_plus"><?php echo "alle webseite plus" ?></option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mt-1 d-flex justify-content-center">
                    <!-- Campaign Chart -->
                    <div class="col col-xs-12 col-sm-12 col-md-9 col-lg-9 col-xl-9 col-xxl-9">
                        <div class="col-12 col-lg-12 order-2 order-md-3 order-lg-2 mb-4">
                            <div class="card">
                              <div class="row row-bordered g-0">
                                <div class="col-md-12" >
                                    <div class='card-body'>
                                        <div class='container'>
                                            <div class="row">
                                                <div class="col col-xs-4 col-sm-4 col-md-4 col-lg-4 col-xl-4">
                                                    <h5 class="card-header m-0 me-2 pb-3"><?php echo $GLOBALS['campaignChart_title']; ?></h5>
                                                </div>
                                                <div class="col col-xs-8 col-sm-8 col-md-8 col-lg-8 col-xl-8">
                                                    <div class="d-flex justify-content-end">
                                                        <div class="w-50 mt-4" style="margin-right: 6%;">
                                                            <select id='campaignGraph' class="form-select text-dark" onchange='dash_filter()'>
                                                                <option value="impression" selected><?php echo $GLOBALS['strImpression']; ?></option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class='container'>
                                            <canvas id="line-chart1"></canvas>
                                            <script>
                                                function testChart(campaignName, ImpressionValue, clickValue, revenueValue, ctrValue,ecpmValue,
                                                xandr_campaignName, xandr_impressions, xandr_clicks,xandr_spend, xandr_ctr, xandr_ecpm, website_impression, website_clicks,getClient_type){

                                                    $(".loader").hide();
                                                    let getValue = document.getElementById('campaignGraph').value;
                                                    let getXendrRevive = document.getElementById('getTypeofreports').value;
                                                    let newChart, myChart;
                                                    // console.log('getClient_type...',getClient_type);
                                                    if(getClient_type == 'all_web_plus'){
                                                        newChart = new Chart(document.getElementById("line-chart1"), {
                                                            type: 'line',
                                                            data: {
                                                                labels: campaignName,
                                                                datasets: [
                                                                    {
                                                                        data: getValue == 'impression'?ImpressionValue:getValue == 'clicks'?clickValue:
                                                                              getValue == 'ctr'?ctrValue:getValue == 'ecpm'?ecpmValue:"",
                                                                        label:getValue == 'impression'?"<?php echo $GLOBALS['strRevive']; ?>":getValue == 'clicks'?"<?php echo $GLOBALS['strRevive']; ?>":
                                                                              getValue == 'ctr'?"<?php echo $GLOBALS['strRevive']; ?>":getValue == 'ecpm'?"<?php echo $GLOBALS['strRevive']; ?>":"",
                                                                        borderColor:getValue == 'impression'?"#3e95cd":getValue == 'clicks'?"#3e95cd":
                                                                                    getValue == 'ctr'?"#3e95cd":getValue == 'ecpm'?"#3e95cd":"",
                                                                        fill: false
                                                                    },
                                                                    {
                                                                        data: getValue == 'impression'?xandr_impressions:getValue == 'clicks'?xandr_clicks:
                                                                              getValue == 'ctr'?xandr_ctr:getValue == 'ecpm'?xandr_ecpm:"",
                                                                        label:getValue == 'impression'?"<?php echo $GLOBALS['strXandr']; ?>":
                                                                              getValue == 'clicks'?"<?php echo $GLOBALS['strXandr']; ?>":                                                                                
                                                                              getValue == 'ctr'?"<?php echo $GLOBALS['strXandr']; ?>":
                                                                              getValue == 'ecpm'?"<?php echo $GLOBALS['strXandr']; ?>":"",
                                                                        borderColor:getValue == 'impression'?"  #FF0000":getValue == 'clicks'?"#FF0000":                                                                                                                                                                                                                    
                                                                                    getValue == 'ctr'?"#FF0000":getValue == 'ecpm'?"#FF0000":"",
                                                                        fill: false
                                                                    },
                                                                    {
                                                                        data: getValue == 'impression'?website_impression:"",
                                                                        label:getValue == 'impression'?"<?php echo $GLOBALS['graph_allWebsite']; ?>":"",
                                                                        borderColor:getValue == 'impression'?"#AA336A":"",
                                                                        fill: false
                                                                    }
                                                                ]
                                                            },
                                                            options: {
                                                                responsive: true,
                                                                events: ['click'],
                                                                title: {
                                                                    display: true,
                                                                    text: `<?php echo $GLOBALS['campaignChart']; ?>`
                                                                },
                                                                layout:{
                                                                    padding:5
                                                                },                                                            
                                                                scales: {
                                                                    xAxes: [
                                                                        {
                                                                            display: true,
                                                                            scaleLabel: {
                                                                                display: true,
                                                                            },
                                                                            labelWrap: true,
                                                                            ticks: {
                                                                                maxRotation: 90,
                                                                                minRotation: 90
                                                                            },
                                                                        }
                                                                    ],
                                                                    yAxes: [
                                                                        {
                                                                            display: true,
                                                                            scaleLabel: {
                                                                                display: true
                                                                            }
                                                                        }
                                                                    ]
                                                                }
                                                            }
                                                        });
                                                    }
                                                    else if (getClient_type == 'all') {
                                                        console.log("skdbfjkdafj");
                                                        newChart = new Chart(document.getElementById("line-chart1"), {
                                                            type: 'line',
                                                            data: {
                                                                labels: campaignName,
                                                                datasets: [
                                                                    {
                                                                        data: getValue == 'impression'?website_impression:"",
                                                                        label:getValue == 'impression'?"<?php echo $GLOBALS['graph_allWebsite']; ?>":"",
                                                                        borderColor:getValue == 'impression'?"#AA336A":"",
                                                                        fill: false
                                                                    }
                                                                ]
                                                            },
                                                            options: {
                                                                responsive: true,
                                                                events: ['click'],
                                                                title: {
                                                                    display: true,
                                                                    text: `<?php echo $GLOBALS['campaignChart']; ?>`
                                                                },
                                                                layout:{
                                                                    padding:5
                                                                },                                                            
                                                                scales: {
                                                                    xAxes: [
                                                                        {
                                                                            display: true,
                                                                            scaleLabel: {
                                                                                display: true,
                                                                            },
                                                                            labelWrap: true,
                                                                            ticks: {
                                                                                maxRotation: 90,
                                                                                minRotation: 90
                                                                            },
                                                                        }
                                                                    ],
                                                                    yAxes: [
                                                                        {
                                                                            display: true,
                                                                            scaleLabel: {
                                                                                display: true
                                                                            }
                                                                        }
                                                                    ]
                                                                }
                                                            }
                                                        });
                                                    }
                                                    else if (getClient_type == 'xandr') {
                                                        newChart = new Chart(document.getElementById("line-chart1"), {
                                                            type: 'line',
                                                            data: {
                                                                labels: campaignName,
                                                                datasets: [
                                                                    {
                                                                        data: getValue == 'impression'?xandr_impressions:getValue == 'clicks'?xandr_clicks:
                                                                              getValue == 'ctr'?xandr_ctr:getValue == 'ecpm'?xandr_ecpm:"",
                                                                        label:getValue == 'impression'?"<?php echo $GLOBALS['strXandr']; ?>":
                                                                              getValue == 'clicks'?"<?php echo $GLOBALS['strXandr']; ?>":                                                                                
                                                                              getValue == 'ctr'?"<?php echo $GLOBALS['strXandr']; ?>":
                                                                              getValue == 'ecpm'?"<?php echo $GLOBALS['strXandr']; ?>":"",
                                                                        borderColor:getValue == 'impression'?"  #FF0000":getValue == 'clicks'?"#FF0000":                                                                                                                                                                                                                    
                                                                                    getValue == 'ctr'?"#FF0000":getValue == 'ecpm'?"#FF0000":"",
                                                                        fill: false
                                                                    }
                                                                ]
                                                            },
                                                            options: {
                                                                responsive: true,
                                                                events: ['click'],
                                                                title: {
                                                                    display: true,
                                                                    text: `<?php echo $GLOBALS['campaignChart']; ?>`
                                                                },
                                                                layout:{
                                                                    padding:5
                                                                },                                                            
                                                                scales: {
                                                                    xAxes: [
                                                                        {
                                                                            display: true,
                                                                            scaleLabel: {
                                                                                display: true,
                                                                            },
                                                                            labelWrap: true,
                                                                            ticks: {
                                                                                maxRotation: 90,
                                                                                minRotation: 90
                                                                            },
                                                                        }
                                                                    ],
                                                                    yAxes: [
                                                                        {
                                                                            display: true,
                                                                            scaleLabel: {
                                                                                display: true
                                                                            }
                                                                        }
                                                                    ]
                                                                }
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        newChart = new Chart(document.getElementById("line-chart1"), {
                                                            type: 'line',
                                                            data: {
                                                                labels: campaignName,
                                                                datasets: [
                                                                    {
                                                                        data: getValue == 'impression'?ImpressionValue:getValue == 'clicks'?clickValue:
                                                                              getValue == 'ctr'?ctrValue:getValue == 'ecpm'?ecpmValue:"",
                                                                        label:getValue == 'impression'?"<?php echo $GLOBALS['strRevive']; ?>":getValue == 'clicks'?"<?php echo $GLOBALS['strRevive']; ?>":
                                                                              getValue == 'ctr'?"<?php echo $GLOBALS['strRevive']; ?>":getValue == 'ecpm'?"<?php echo $GLOBALS['strRevive']; ?>":"",
                                                                        borderColor:getValue == 'impression'?"#3e95cd":getValue == 'clicks'?"#3e95cd":
                                                                                    getValue == 'ctr'?"#3e95cd":getValue == 'ecpm'?"#3e95cd":"",
                                                                        fill: false
                                                                    }
                                                                ]
                                                            },
                                                            options: {
                                                                responsive: true,
                                                                events: ['click'],
                                                                title: {
                                                                    display: true,
                                                                    text: `<?php echo $GLOBALS['campaignChart']; ?>`
                                                                },
                                                                layout:{
                                                                    padding:5
                                                                },                                                            
                                                                scales: {
                                                                    xAxes: [
                                                                        {
                                                                            display: true,
                                                                            scaleLabel: {
                                                                                display: true,
                                                                            },
                                                                            labelWrap: true,
                                                                            ticks: {
                                                                                maxRotation: 90,
                                                                                minRotation: 90
                                                                            },
                                                                        }
                                                                    ],
                                                                    yAxes: [
                                                                        {
                                                                            display: true,
                                                                            scaleLabel: {
                                                                                display: true
                                                                            }
                                                                        }
                                                                    ]
                                                                }
                                                            }
                                                        });
                                                    }

                                                    var checkChart = document.getElementById("campaignGraph");
                                                    campaignGraph.addEventListener("change", function() {
                                                        newChart.destroy();
                                                    });
                                                };
                                            </script>
                                        </div>
                                    </div>
                                </div>
                              </div>
                            </div>
                          </div>
                    </div>
                    
                    <!-- weights - Request, Impress, Click, Conversion  -->
                    <div class="col col-xs-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3">
                        <div class="card mb-4 mt-sm-2 mt-md-2 mt-lg-5 mt-xl-5 mt-xxl-5 w-100">
                            <div class="card-body text-center">
                                <i class="fa  fa-podcast  fa-2x text-primary"  aria-hidden="true"></i>
                                <span class="fw-semibold d-block text-primary h6 mt-2 mb-2"><b><?php echo $GLOBALS['strImpression']; ?></b></span>
                                <h3 class="card-title mb-1" id="imp">0</h3>
                            </div>
                        </div>
                        <div class="card w-100">
                            <div class="card-body text-center">
                                <i class="fa fa-external-link  fa-2x text-primary" aria-hidden="true"></i>
                                <span class="fw-semibold d-block  text-primary h6 mt-2 mb-2"><b><?php echo $GLOBALS['strClicks']; ?></b></span>
                                <h3 class="card-title  mb-1" id="cli">0</h3>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="mt-3 container">
                    <div class="row d-flex justify-content-center" style="margin-top: -10px;">
                    <!-- Top Campaigns -->
                        <div class="col col-xs-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                            <div class="card mb-4" style='height: 94%'>
                                <div class="card-body table-responsive">
                                <p class="h4"><?php echo $GLOBALS['strTopCampaigns']; ?></p>
                                    <table id="top_campaign" class="table table-hover table-striped table-responsive mt-3">
                                        <thead>
                                            <tr>
                                                <th class="text-start"><?php echo $GLOBALS['strName']; ?></th>
                                                <th class="text-center"><?php echo $GLOBALS['strImpression']; ?></th>
                                                <th class="text-center"><?php echo $GLOBALS['strClicks']; ?></th>
                                            </tr>
                                        </thead>
                                        <tbody class="text-center" id="campaign_table"></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Top Websites -->
                        <div class="col col-xs-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                            <div class="card mb-4" style='height: 94%'>
                                <div class="card-body table-responsive"  id="top_websites">
                                    <p class="h4"><?php echo $GLOBALS['strTopWebsites']; ?></p>
                                    <table id="top_website" class="table table-hover table-striped mt-3">
                                        <thead>
                                            <tr>
                                                <th><?php echo $GLOBALS['strName']; ?></th>
                                                <th class="text-center"><?php echo $GLOBALS['strImpression']; ?></th>
                                                <th class="text-center"><?php echo $GLOBALS['strClicks']; ?></th>
                                            </tr>
                                        </thead>
                                        <tbody class="text-center" id="website_table"></tbody>
                                    </table>
                                </div>

                                <div class="card-body table-responsive" id="top_banners">
                                    <p class="h4"><?php echo $GLOBALS['strTopWebsites']; ?></p>
                                    <table id="top_banner" class="table table-hover table-striped mt-3">
                                        <thead>
                                            <tr>
                                                <th>Name</th>
                                                <th class="text-center">Impression</th>
                                                <th class="text-center">Clicks</th>        
                                            </tr>
                                        </thead>
                                        <tbody class="" id="banner_table"></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- / Content -->
        <?php include('footer.php'); ?>
        
        <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
        <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
        <script>
            let live_URL = '<?php echo $apistatpath; ?>';
            const token = 'Bearer ' + document.getElementById('token').value;
            let client_id = document.getElementById('clientid').value;

            var campaign_url, topCampaign_url,topBanner_url, topWebsite_url, widgets_url, 
            revive, getAllCampaign_url, setDate;            
            localStorage.clear();

            function dash_filter() {
                $(".loader").show();

                const date = new Date();
                var filtervalue = document.getElementById('getDuration').value;
                let getClient = document.getElementById('getTypeofreports').value;

                document.getElementById('daterange').style.display = filtervalue == 'custom'?"block":"none";

                if(getClient == 'revive'){
                    $("#top_website").hide();
                    $("#top_websites").hide();
                    $("#top_banner").show();
                    $("#top_banners").show();
                    campaign_url = live_URL + '/get_advertiser_campaign_graph_statistics/';
                    topCampaign_url = live_URL + '/get_top_campaign_statistics/';
                    topBanner_url = live_URL + '/get_top_banner_statistics/';
                    widgets_url = live_URL + '/get_widgets_advertiser_campaign_statistics/';
                }
                else if(getClient == 'xandr') {

                    $("#top_banner").hide();
                    $("#top_banners").hide();

                    $("#top_website").show();
                    $("#top_websites").show();
                    
                    campaign_url = live_URL + '/get_advertiser_campaign_graph_statistics/';
                    topWebsite_url = live_URL + '/get_top_website_statistics/';
                    topCampaign_url = live_URL + '/get_xandr_top_campaign_statistics/';                    
                    widgets_url = live_URL + '/get_xandr_widgets_advertiser_campaign_statistics/';
                }
                else if (getClient == 'all') {
					$("#top_website").show();
                    $("#top_websites").show();
                    
                    $("#top_banner").hide();
                    $("#top_banners").hide();
                    
					// campaign_url = live_URL + '/get_advertiser_all_web_campaign_graph_statistics/';
                    campaign_url = live_URL + '/get_advertiser_campaign_graph_statistics/';
					topWebsite_url = live_URL + '/get_all_website_top_website_statistics/';
					topCampaign_url = live_URL + '/get_all_website_top_campaign_statistics/';  
					widgets_url = live_URL + '/get_all_websites_widgets_advertiser_campaign_statistics/';
				}
                else {
					$("#top_website").show();
                    $("#top_websites").show();
                    
                    $("#top_banner").hide();
                    $("#top_banners").hide();
                    
					campaign_url = live_URL + '/get_advertiser_campaign_graph_statistics/';
					topWebsite_url = live_URL + '/get_all_website_top_website_statistics/';
					topCampaign_url = live_URL + '/get_all_website_top_campaign_statistics/';  
					widgets_url = live_URL + '/get_all_websites_widgets_advertiser_campaign_statistics/';
				}
               
                if (filtervalue == 'Today') {
                    let v3 = JSON.stringify(date).slice(1, 11);
                    setDate= v3;
                    getDashboardDay(v3, v3,'');
                }
                else if (filtervalue == 'Yesterday') {
                    let current_date = date.setDate(date.getDate() - 1);
                    const get_date = new Date(date);
                    let yesterday_date = JSON.stringify(get_date).slice(1, 11);
                    getDashboardDay(yesterday_date, yesterday_date,'');
                }
                else if (filtervalue == 'Last 7 days') {
                    let date_start = date.setDate(date.getDate() - 7);
                    let get_date = new Date(date_start);
                    let first_day = JSON.stringify(get_date).slice(1, 11);

                    let todayDate = new Date();
                    let current_date = todayDate.setDate(todayDate.getDate() - 1);
                    let last_7Days = new Date(todayDate);
                    let date_end = JSON.stringify(last_7Days).slice(1, 11);
                    getDashboardDay(first_day, date_end,'');
                }
                else if (filtervalue == 'Last 30 days') {
                    let date_start = date.setDate(date.getDate() - 30);
                    let get_date = new Date(date_start);
                    var first_day = JSON.stringify(get_date).slice(1, 11);

                    let todayDate = new Date();
                    let current_date = todayDate.setDate(todayDate.getDate() - 1);
                    let last_30Days = new Date(todayDate);
                    let date_end = JSON.stringify(last_30Days).slice(1, 11)
                    getDashboardDay(first_day, date_end,'');
                }               
                else if (filtervalue == 'custom') {
                    $("#daterange").css("display", "block");
                    $(".loader").hide();
                    var start_date,end_date;
                    //current Date pass in getDashboardDay()
                    getDashboardDay(setDate, setDate,'');
                    
                    $(function () {
                        $('input[name="daterange"]').daterangepicker({
                            opens: 'left',
                            locale: {
                                format: 'DD/MM/YYYY'
                            }
                        }, function (start, end, label) {                            
                             localStorage.setItem("cust_startdate", start.format('YYYY-MM-DD'));
                             localStorage.setItem("cust_enddate", end.format('YYYY-MM-DD'));
                             var local= localStorage.getItem("start_date");
                            //  var check=$("#daterange").val();
                             
                            getDashboardDay(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'),local);
                        })
                    });

                    start_date != 'undefined'?testChart(campaignName = [], ImpressionValue = [], clickValue = [],
                                conversionsValue = [], revenueValue = [], ctrValue = [],
                                ecpmValue = []):"0";
                }
            };

            function getDashboardDay(startDate, endDate,local) {
                var getDuration=document.getElementById('getDuration').value;
                var cust_startdate= localStorage.getItem("cust_startdate");
                var cust_enddate= localStorage.getItem("cust_enddate");
                let getClient_type = document.getElementById('getTypeofreports').value;
                let getClient1 = document.getElementById('getTypeofreports').value;
                let campaignName,ImpressionValue,clickValue,revenueValue,ctrValue,ecpmValue,xandr_campaignName,
                xandr_impressions,xandr_clicks,xandr_spend,xandr_ctr,xandr_ecpm, website_impression,
                website_clicks,website_all_imp;
                
                let start_end_date = (getDuration=="custom" && cust_startdate!=null && cust_enddate!=null )?
                (cust_startdate + ' 00:00:00,' + cust_enddate + ' 23:59:59,'):(startDate + ' 00:00:00,' + endDate + ' 23:59:59,');

                // Campaign Chart Start
                $.ajax({
                    url:  campaign_url + start_end_date + client_id,
                    type: 'GET',
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: {},
                    success: function (data) {
                        console.log("campaign chart", data.todos_allweb);
                        let reviveData = data.todos__revive_sql, 
                        xendrData = data.todos,
                        websiteData = data.todos_allweb;
                        // all_website = data.todos_all; 
                        // console.log("all_website", all_website);

                        if (data.msg == 'No Stats Available') {
                            testChart(campaignName = [], ImpressionValue = [], clickValue = [],
                                conversionsValue = [], revenueValue = [], ctrValue = [],ecpmValue = []);
                        }
                        else {
                            $(".loader").show();

                            // if(getClient1 !== 'all'){
                                // Get Revive Live Data 
                            campaignName = reviveData.map((data) => {
                                return data.campaignname;
                            });

                            ImpressionValue = reviveData.map((data) => {
                                if (data.impressions == null) {
                                    return data.impressions = 0;
                                }
                                else {
                                    return data.impressions;
                                }
                            });

                            clickValue = reviveData.map((data) => {
                                if (data.clicks == null) {
                                    return data.clicks = 0;
                                }
                                else {
                                    return data.clicks;
                                }
                            });

                            // let conversionsValue = reviveData.map((data) => {
                            //     if (data.conversions == null) {
                            //         return data.conversions = 0;
                            //     }
                            //     else {
                            //         return data.conversions;
                            //     }
                            // });

                            revenueValue = reviveData.map((value) => {
                                // let convert = parseInt(value.revenue, 10);
                                // console.log("revenueValue", value.revenue);

                                if (value.revenue == null) {
                                    return value.revenue = 0.00;
                                }
                                else {
                                    return value.revenue;
                                }
                            });

                            ctrValue = reviveData.map((data) => {
                                if (data.ctr == null) {
                                    return data.ctr = 0;
                                }
                                else {
                                    return data.ctr;
                                }
                            });

                            ecpmValue = reviveData.map((data) => {
                                if (data.ecpm == null) {
                                    return data.ecpm = 0;
                                }
                                else {
                                    return data.ecpm;
                                }
                            });

                            //Get xendr Live Data

                            xandr_campaignName = xendrData.map((data) => {                                    
                                    return data.campaignname;
                                });
                            
                            xandr_impressions = xendrData.map((data, index) => {
                                if (data.xandr_impressions == null) {
                                    return data.xandr_impressions[index] = 0;
                                }
                                else {
                                    return data.xandr_impressions;
                                }
                            });
                            
                            xandr_clicks = xendrData.map((data) => {
                                if (data.xandr_clicks == null) {
                                    return data.xandr_clicks[index] = 0;
                                }
                                else {
                                    return data.xandr_clicks;
                                }
                            });

                            // let xandr_conversion = xendrData.map((data) => {
                            //     if (data.conversions == null) {
                            //         return data.conversions[index] = 0;
                            //     }
                            //     else {
                            //         return data.conversions;
                            //     }
                            // });

                            /*xandr_spend = xendrData.map((data) => {
                                if (data.spend == null) {
                                    return data.spend[index] = 0;
                                }
                                else {
                                    return data.spend;
                                }
                            });

                            xandr_ctr = xendrData.map((data, index) => {
                                if (data.xandr_ctr == null) {
                                    return data.xandr_ctr[index] = 0;
                                }
                                else {
                                    return data.xandr_ctr;
                                }
                            });
                            
                            xandr_ecpm = xendrData.map((data, index) => {
                                if (data.xandr_ecpm == null) {
                                    return data.xandr_ecpm[index] = 0;
                                }
                                else {
                                    return data.xandr_ecpm;
                                }
                            }); */

                            //all website plus
                            website_impression = websiteData.map((data) => {
                                return data.impressions == null?0:data.impressions;
                            });

                             website_clicks = websiteData.map((data) => {
                                return data.clicks == null?0:data.clicks;
                            });
                            // website_all_imp = all_website.map((data) => {
                            //     return data.impressions;
                            // });
                            // console.log("website_clicks", website_clicks);
                                testChart(campaignName, ImpressionValue, clickValue, revenueValue, ctrValue,
                                ecpmValue,xandr_campaignName, xandr_impressions, xandr_clicks,xandr_spend, xandr_ctr, xandr_ecpm,
                                website_impression, website_clicks, getClient_type);
                            // }
                            // else {
                            //     //website
                            //     campaignName = websiteData.map((data) => {
                            //     return data.campaignname;
                            // });
                                
                            // website_all_imp = websiteData.map((data) => {
                            //     return data.impressions;
                            // });
                            // console.log("website_all_imp", website_all_imp);
                            // testChart(campaignName, ImpressionValue=0, clickValue=0, revenueValue=0, ctrValue=0,
                            // ecpmValue=0,xandr_campaignName=0, xandr_impressions=0, xandr_clicks=0,xandr_spend=0, 
                            // xandr_ctr=0, xandr_ecpm=0,
                            // website_impression=0, website_clicks=0, getClient_type, website_all_imp);
                            // }

                            

            

                            // testChart(campaignName, ImpressionValue, clickValue, revenueValue, ctrValue,
                            // ecpmValue,xandr_campaignName, xandr_impressions, xandr_clicks,xandr_spend, xandr_ctr, xandr_ecpm,
                            // website_impression, website_clicks, getClient_type, website_all_imp);
                        }
                    },
                    error: function () { },
                });
                // Campaign Chart End

                var getDuration=$("#getDuration").val();
                var cust_startdate= localStorage.getItem("cust_startdate");
                var cust_enddate= localStorage.getItem("cust_enddate");
                
                if(getDuration=="custom" && cust_startdate!=null && cust_enddate!=null ){
                    var custom_start_enddate= cust_startdate + ' 00:00:00,' + cust_enddate + ' 23:59:59,'
                }else{
                    var custom_start_enddate= startDate + ' 00:00:00,' + endDate + ' 23:59:59,';
                }

                // Start impression, click, request and conversion
                $.ajax({
                    url: widgets_url + custom_start_enddate + client_id,

                    type: 'GET',
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: {},
                    success: function (data) {
                        $(".loader").hide();
                        if (data.msg == 'No Stats Available') {
                            document.getElementById('imp').innerHTML = 0;
                            document.getElementById('cli').innerHTML = 0;
                        }
                        else {
                            const entries = Object.values(data);
                            if ( entries[0]['impressions'] == null && entries[0]['clicks'] == null) {
                                document.getElementById('imp').innerHTML = 0;
                                document.getElementById('cli').innerHTML = 0;
                            }
                            else {
								let impressions = clicks =conversions= 0;
								if(data.length > 1) {
									for(let i = 0; i < data.length; i++) {
										impressions += parseInt(data[i].all_imps);
										clicks += parseInt(data[i].all_clks);
										conversions += parseInt(data[i].all_convs);
									}
								} else {
									impressions = data[0].all_imps;
									clicks = data[0].all_clks;
									conversions = data[0].all_convs;
								}
                                document.getElementById('imp').innerHTML = Number(impressions);
                                document.getElementById('cli').innerHTML = Number(clicks);
                            }
                        }
                    },
                    error: function () { },
                });
                // End impression, click, request and conversion

                // Top Campaign Start
                $.ajax({
                    url: topCampaign_url + custom_start_enddate + client_id,
                    type: 'GET',
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: {},
                    success: function (data) {
                        $(".loader").hide();
                        if (data.msg == 'No Stats Available') {
                            document.getElementById('campaign_table').innerHTML = `<tr><td colspan="5">No Data found</td></tr>`;
                        }
                        else {
                            let getCamData = "";
                            data.map((data, index) => {
                                spend = data.spend == null?0.00:data.spend;
                                getCamData += `<tr key='index'>
                                                 <td class="text-hide">${data.campaignname}</td>
                                                 <td>${Number(data.impressions).toLocaleString("en-IN")}</td>
                                                 <td>${Number(data.clicks).toLocaleString("en-IN")}</td>
                                                 <!-- <td>${Number(data.conversions).toLocaleString("en-IN")}</td> -->
                                             </tr>`
                            });
                            document.getElementById('campaign_table').innerHTML = getCamData;
                        }
                    },
                    error: function () { },
                });
                // End Top Campaign

                let getClient = document.getElementById('getTypeofreports').value;
                    if(getClient=="revive"){
                        // Start Top Banner
                        $.ajax({
                            url: topBanner_url + custom_start_enddate + client_id,
                            // url: topBanner_url + startDate + ' 00:00:00,' + endDate + ' 23:59:59,' + client_id,
                            type: 'GET',
                            beforeSend: function (xhr) {
                                xhr.setRequestHeader('Authorization', token);
                            },
                            data: {},
                            success: function (data) {
                                // console.log("campaign data", data.msg);
                                $(".loader").hide();
                                if (data.msg == 'No Stats Available') {
                                    document.getElementById('banner_table').innerHTML = `<tr><td colspan="5">No Data found</td></tr>`;
                                }
                                else {
                                    var getBanData = "";
                                    data.map((data, index) => {
                                        if (data.spend == null) { var spend = 0.00; }
                                        else { var spend = data.spend; }
                                        getBanData += `<tr key='index'>
                                                                <td class='text-hide text-start'>${data.affiliatename}</td>
                                                                <td>${Number(data.impressions)}</td>
                                                                <td>${Number(data.clicks)}</td>
                                                                <!-- <td>${Number(data.conversions)}</td> -->
                                                              
                                                            </tr>`
                                    });
                                    document.getElementById('banner_table').innerHTML = getBanData;
                                }
                            },
                            error: function () { },
                        });
                        // End Top Banner
                    }
                    else{
                        // Start Top website
                        $.ajax({
                            url: topWebsite_url + custom_start_enddate + client_id,

                            type: 'GET',
                            beforeSend: function (xhr) {
                                xhr.setRequestHeader('Authorization', token);
                            },
                            data: {},
                            success: function (data) {
                                // console.log("campaign data", data);
                                $(".loader").hide();
                                if (data.msg == 'No Stats Available') {
                                    document.getElementById('website_table').innerHTML = `<tr><td colspan="4">No Data found</td></tr>`;
                                }
                                else {
                                    var getBanData = "";
                                    data.map((data, index) => {
                                        if (data.spend == null) { var spend = 0.00; }
                                        else { var spend = data.spend; }
                                        getBanData += `<tr key='index'>
                                                                <td class='text-hide text-start'>${data.websitesname}</td>
                                                                <td>${Number(data.impressions)}</td>
                                                                <td>${Number(data.clicks)}</td>                                                             
                                                            </tr>`;
                                    });
                                    document.getElementById('website_table').innerHTML = getBanData;
                                }
                            },
                            error: function () { },
                        });
                        // End Top website
                    }      
            };
        </script>
        <!-- <script src="../assets/js/config.js"></script> -->
        <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>
  </body>
</html>
