<?php
include('session.php');
include('../config.php'); 
include('../common.php'); ?>
<!DOCTYPE html>
<!-- beautify ignore:start -->
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="../assets/" data-template="vertical-menu-template-free">
  <head>
  <title><?php echo $projecttitle; ?> - Dashboard</title>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
  <meta name="description" content="" />
  <style>
    .text-hide{
    /* display: block; */
    width: 125px;
    overflow: hidden;
    white-space: nowrap;
    text-overflow: ellipsis;
    }

    .tooltip {
      position: relative;
      display: inline-block;
    }

    .tooltip .tooltiptext {
      visibility: hidden;
      width: 120px;
      background-color: gray;
      color: #fff;
      text-align: center;
      border-radius: 6px;
      padding: 5px 0;
    
      /* Position the tooltip */
      position: absolute;
      z-index: 1;
    }
    
    .tooltip:hover .tooltiptext {
      visibility: visible;
    }

    .text-hide:hover{
    overflow: inherit;
    width: auto;
    }

    .wrapper 
    {
        width: 100%;
        display: block;
        overflow: hidden;
        margin: 0 auto;
        padding: 60px 50px;
        background: #fff;
        border-radius: 4px;
    }

    .bar_canvas {
        background: #fff;
        height: 300px;
    }
    
    .loader
    {
        display: none;
        position: fixed;
        width: 100%;
        height: 100%;
        top: 0;
        left: 0;
        z-index: 999;
        background: rgba(255,255,255,0.8) url("../assets/img/loader.gif") center no-repeat;
    }

    /* colse button */
    .dataTables_wrapper .dataTables_filter input:not(:valid):not(:focus){
	   box-shadow: 0 0 5px #fff!important;
		}
		.dataTables_wrapper .dataTables_filter input::-webkit-search-cancel-button {
		  -webkit-appearance: none!important;
		}
		.dataTables_wrapper .dataTables_filter button{
		  visibility: hidden;
		  outline: none;
		}
		.dataTables_wrapper .dataTables_filter input:valid ~ button{
		  visibility: visible;
		}
    </style>

    <?php include('head.php'); ?>
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.6.0/Chart.min.js"></script>
  </head>

  <body onload="dash_filter()">


  
  <div class="loader"></div>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->
        <?php include('sidebar.php'); ?>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->
          <?php include('navbar.php'); ?>
          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->
            <div class="container-xxl flex-grow-1 container-p-y">
                <div class="row">
                    <div class="col col-xs-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                        <div class="d-flex justify-content-start">
                            <!-- <p class="h3">Dashboard</p> -->
                            <p class="h3"><?php echo $GLOBALS['strDashboard_Title']; ?></p>

                            <input type="hidden" name="clientid" id="clientid" value="<?php echo $_SESSION['clientid']; ?>">
                        </div>
                    </div>
                    <div class="col col-xs-12 col-sm-12 col-md-8 col-lg-8 col-xl-8 col-xxl-8">
                        <div class="d-flex justify-content-end">
                            <div class="mb-3" style="width:34%">
                                <select id="getDuration" class="form-select text-dark" 
                                onchange="dash_filter()">
                                    <!-- <option selected value="Today">Today</option>
                                    <option value="Yesterday">Yesterday</option>
                                    <option value="Last 7 days">Last 7 days</option>
                                    <option value="Last 30 days">Last 30 days</option>
                                    <option value="Last Month">Last Month</option>
                                    <option value="This Month">This Month</option>
                                    <option value='all statistics'>All Statistics</option>
                                    <option value="custom" id="custom" name="custom">Custom</option> -->


                                    <option selected value="Today"><?php echo $GLOBALS['strToday']; ?></option>
                                    <option value="Yesterday"><?php echo $GLOBALS['strYesterday']; ?></option>
                                    <option value="Last 7 days"><?php echo $GLOBALS['strLast_7_days']; ?></option>
                                    <option value="Last 30 days"><?php echo $GLOBALS['strLast 30 days']; ?></option>
                                    <option value="Last Month"><?php echo $GLOBALS['strLast Month']; ?></option>
                                    <option value="This Month"><?php echo $GLOBALS['strThis Month']; ?></option>
                                    <option value='all statistics'><?php echo $GLOBALS['strAll Statistics']; ?></option>
                                    <option value="custom"><?php echo $GLOBALS['strCustom']; ?></option> 

                                </select>
                                <input style="display: none; width: 95%; margin-left:3%" id="daterange" name="daterange" class='mt-2' value="select Date"/>
                            </div>
                            <div class="mb-3" style="width:34%; padding-left:50px;">
                            <!-- <div> -->
                                <select id="getTypeofreports" class="form-select text-dark" onchange='dash_filter();onChangeReviveXandr();'>
                                    <!-- <option selected value="xandr">Xandr</option>
                                    <option value="revive">Revive</option> -->
                                    <option selected value="xandr"><?php echo $GLOBALS['strXandr']; ?></option>
                                    <option value="revive"><?php echo $GLOBALS['strRevive']; ?></option>


                                </select>
                             <!-- </div> -->
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mt-1 d-flex justify-content-center">
                    <!-- Campaign Chart -->
                    <div class="col col-xs-12 col-sm-12 col-md-11 col-lg-7 col-xl-8 col-xxl-8">
                        <div class="col-12 col-lg-12 order-2 order-md-3 order-lg-2 mb-4">
                            <div class="card">
                              <div class="row row-bordered g-0">
                                <div class="col-md-12" >
                                    <div class='card-body'>
                                        <div class='container'>
                                            <div class="row">
                                                <div class="col col-xs-4 col-sm-4 col-md-4 col-lg-4 col-xl-4">
                                                    <!-- <h5 class="card-header m-0 me-2 pb-3">Campaigns</h5> -->
                                                    <h5 class="card-header m-0 me-2 pb-3"><?php echo $GLOBALS['campaignChart_title']; ?></h5>

                                                </div>
                                                <div class="col col-xs-8 col-sm-8 col-md-8 col-lg-8 col-xl-8">
                                                    <div class="d-flex justify-content-end">
                                                        <div class="w-50 mt-4" style="margin-right: 6%;">
                                                            <select id='campaignGraph' class="form-select text-dark" onchange='dash_filter()'>
                                                                <!-- <option value="impression" selected>Impression</option>
                                                                <option value="clicks">Clicks</option>
                                                                <option value="conversion">Conversion</option>
                                                                <option value="ctr">CTR</option>
                                                                <option value="ecpm">ECPM</option> -->


                                                             <option value="impression" selected><?php echo $GLOBALS['strImpression']; ?></option>
                                                                <option value="clicks"><?php echo $GLOBALS['strClicks']; ?></option>
                                                                <option value="conversion"><?php echo $GLOBALS['strConversion']; ?></option>
                                                                <option value="ctr"><?php echo $GLOBALS['strCTR']; ?></option>
                                                                <option value="ecpm"><?php echo $GLOBALS['strECPM']; ?></option> 
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class='d-flex justify-content-end'>
                                                <div class="mt-3">
                                                    <button class="btn" type="button" data-bs-toggle="modal" title="Campaign Chart Zoom"
                                                        data-bs-target="#fullscreenModal" id='zoomButton'>
                                                        <i class="fa fa-arrows-alt text-primary"></i>
                                                    </button>
                                                </div>
                                                <div class="modal fade" id="fullscreenModal" tabindex="-1" aria-hidden="true">
                                                    <div class="modal-dialog modal-fullscreen" role="document">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                            <h5 class="modal-title" id="modalFullTitle"><?php echo $GLOBALS['campaignChart']; ?></h5>

                                                                <!-- <h5 class="modal-title" id="modalFullTitle">Campaign Chart</h5> -->
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <canvas id="line-chart2"></canvas>
                                                                <script>
                                                                    function campaignChart(xandr_impressions, xandr_clicks, xandr_ctr, xandr_ecpm,campaignName, ImpressionValue, clickValue, conversionsValue, revenueValue, ctrValue, ecpmValue) {
                                                                        var getValue = document.getElementById('campaignGraph').value;


                                                                        // console.log('....getValue....',getValue);
                                            
                                                                      var zoomCampaignChart = new Chart(document.getElementById("line-chart2"), {
                                                                            type: 'line',
                                                                            data: {
                                                                                labels: campaignName,
                                                                                datasets: [
                                                                                    {
                                                                                        data: getValue == 'impression'?ImpressionValue:getValue == 'clicks'?clickValue:
                                                                                              getValue == 'conversion'?conversionsValue:getValue == 'spend'?revenueValue:
                                                                                              getValue == 'ctr'?ctrValue:getValue == 'ecpm'?ecpmValue:"",
                                                                                        label:getValue == 'impression'?"revive":getValue == 'clicks'?"revive":
                                                                                              getValue == 'conversion'?"revive":getValue == 'spend'?"revive":
                                                                                              getValue == 'ctr'?"revive":getValue == 'ecpm'?"revive":"",
                                                                                        // borderColor:getValue == 'impression'?"#3e95cd":getValue == 'clicks'?"#8e5ea2":
                                                                                        //             getValue == 'conversion'?"#e83e8c":getValue == 'spend'?"#e79f0d":
                                                                                        //             getValue == 'ctr'?"#c45850":getValue == 'ecpm'?"#fd7e14":"",
                                                                                        borderColor:getValue == 'impression'?"#3e95cd":getValue == 'clicks'?"#3e95cd":
                                                                                                    getValue == 'conversion'?"#3e95cd":getValue == 'spend'?"#3e95cd":
                                                                                                    getValue == 'ctr'?"#3e95cd":getValue == 'ecpm'?"#3e95cd":"",
                                                                                                    fill: false
                                                                                    },
                                                                                    {
                                                                                        data: getValue == 'impression'?xandr_impressions:getValue == 'clicks'?xandr_clicks:
                                                                                              getValue == 'conversion'?[600, 976]:getValue == 'spend'?[555, 1276]:
                                                                                              getValue == 'ctr'?[720, 1690]:getValue == 'ecpm'?xandr_ecpm:"",
                                                                                        label:getValue == 'impression'?"xandr":getValue == 'clicks'?"xandr":                                                                                
                                                                                              getValue == 'conversion'?"xandr":getValue == 'spend'?"xandr":
                                                                                              getValue == 'ctr'?"xandr":getValue == 'ecpm'?"xandr":"",
                                                                                        // borderColor:getValue == 'impression'?"  #FF0000":getValue == 'clicks'?"#FF0000":                                                                                                                                                                                                                    
                                                                                        //             getValue == 'conversion'?"#e83e8c":getValue == 'spend'?"#e79f0d":
                                                                                        //             getValue == 'ctr'?"#FF0000":getValue == 'ecpm'?"#FF0000":"",
                                                                                        borderColor:getValue == 'impression'?"  #FF0000":getValue == 'clicks'?"#FF0000":                                                                                                                                                                                                                    
                                                                                                    getValue == 'conversion'?"#FF0000":getValue == 'spend'?"#FF0000":
                                                                                                    getValue == 'ctr'?"#FF0000":getValue == 'ecpm'?"#FF0000":"",
                                                                                                    fill: false
                                                                                    }
                                                                                ]
                                                                            },
                                                                            options: {
                                                                                responsive: true,
                                                                                title: {
                                                                                    display: true,
                                                                                    text: `<?php echo $GLOBALS['campaignChart']; ?>`

                                                                                    // text: 'Campaign Chart'
                                                                                },
                                                                                layout:{
                                                                                    padding:5
                                                                                },
                                                                                scales: {
                                                                                    xAxes: [{
                                                                                        display: true,
                                                                                        scaleLabel: {
                                                                                            display: true,
                                                                                            // labelString: '13-03-2023 to 18-03-2023'
                                                                                        },
                                                                                        labelWrap: true,
                                                                                        ticks: {
                                                                                            maxRotation: 90,
                                                                                            minRotation: 90
                                                                                        }
                                                                                    }],
                                                                                    yAxes: [
                                                                                        {
                                                                                            display: true,
                                                                                            scaleLabel: {
                                                                                                display: true
                                                                                            }
                                                                                        }
                                                                                    ]
                                                                                }
                                                                            }
                                                                        });

                                                                        var checkChart = document.getElementById("campaignGraph");
                                                                        campaignGraph.addEventListener("change", function () {
                                                                            zoomCampaignChart.destroy();
                                                                        });
                                                                    };
                                                                </script>
                                                            </div>
                                                        </div>
                                                   </div>
                                               </div>
                                            </div>
                                        </div>
                                        <div class='container'>
                                            <canvas id="line-chart1"></canvas>
                                            <script>
                                                function testChart(campaignName, ImpressionValue, clickValue, conversionsValue, revenueValue, ctrValue,
                                                    ecpmValue,xandr_campaignName, xandr_impressions, xandr_clicks,xandr_conversion,xandr_spend, xandr_ctr, xandr_ecpm){

                                                // function testChart(campaignName, ImpressionValue, clickValue, conversionsValue, revenueValue, ctrValue, ecpmValue) {
                                                    $(".loader").hide();
                                                    let getValue = document.getElementById('campaignGraph').value;
                                                    let getXendrRevive = document.getElementById('getTypeofreports').value;
                                                    
                                                    var newChart = new Chart(document.getElementById("line-chart1"), {
                                                        type: 'line',
                                                        data: {
                                                            labels: getXendrRevive =="revive"?campaignName:xandr_campaignName,
                                                            datasets: [
                                                                {
                                                                    data: getValue == 'impression'?ImpressionValue:getValue == 'clicks'?clickValue:
                                                                          getValue == 'conversion'?conversionsValue:
                                                                          getValue == 'ctr'?ctrValue:getValue == 'ecpm'?ecpmValue:"",
                                                                    label:getValue == 'impression'?"revive":getValue == 'clicks'?"revive":
                                                                          getValue == 'conversion'?"revive":
                                                                          getValue == 'ctr'?"revive":getValue == 'ecpm'?"revive":"",
                                                                     borderColor:getValue == 'impression'?"#3e95cd":getValue == 'clicks'?"#3e95cd":
                                                                                getValue == 'conversion'?"#3e95cd":
                                                                                getValue == 'ctr'?"#3e95cd":getValue == 'ecpm'?"#3e95cd":"",
                                                                                fill: false
                                                                },
                                                                {
                                                                    data: getValue == 'impression'?xandr_impressions:getValue == 'clicks'?xandr_clicks:
                                                                          getValue == 'conversion'?xandr_conversion:
                                                                          getValue == 'ctr'?xandr_ctr:getValue == 'ecpm'?xandr_ecpm:"",
                                                                    label:getValue == 'impression'?"xandr":getValue == 'clicks'?"xandr":                                                                                
                                                                          getValue == 'conversion'?"xandr":
                                                                          getValue == 'ctr'?"xandr":getValue == 'ecpm'?"xandr":"",
                                                                      borderColor:getValue == 'impression'?"  #FF0000":getValue == 'clicks'?"#FF0000":                                                                                                                                                                                                                    
                                                                                getValue == 'conversion'?"#FF0000":
                                                                                getValue == 'ctr'?"#FF0000":getValue == 'ecpm'?"#FF0000":"",
                                                                                fill: false
                                                                }
                                                            ]
                                                        },
                                                        options: {
                                                            responsive: true,
                                                            title: {
                                                                display: true,
                                                                // text: 'Campaign Chart'
                                                                text: `<?php echo $GLOBALS['campaignChart']; ?>`

                                                            },
                                                            layout:{
                                                                padding:5
                                                            },
                                                            // hover: {mode: null},
                                                            // events: [],
                                                            scales: {
                                                                xAxes: [{
                                                                    display: true,
                                                                    scaleLabel: {
                                                                        display: true,
                                                                        // labelString: "Campaign Name"
                                                                    },
                                                                    labelWrap: true,
                                                                    ticks: {
                                                                        maxRotation: 90,
                                                                        minRotation: 90
                                                                    },
                                                                }
                                                            ],
                                                                yAxes: [
                                                                    {
                                                                        display: true,
                                                                        scaleLabel: {
                                                                            display: true
                                                                        }
                                                                    }
                                                                ]
                                                            }
                                                        }
                                                   });

                                                    var checkChart = document.getElementById("campaignGraph");
                                                    campaignGraph.addEventListener("change", function() {
                                                        newChart.destroy();
                                                    });
                                                };
                                                
                                            </script>
                                        </div>
                                    </div>
                                </div>
                              </div>
                            </div>
                          </div>
                    </div>
                    
                    <!-- weights - Request, Impress, Click, Conversion  -->
                    <div class="col col-xs-12 col-sm-12 col-md-11 col-lg-4 col-xl-4 col-xxl-4">
                        <div class="row mb-4 mt-sm-2 mt-md-2 mt-lg-5 mt-xl-5 mt-xxl-5">
                            <div class="col col-xs-12 col-sm-6 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                <div class="card" style='width:95%'>
                                    <div class="card-body text-center">
                                        <i class="fa  fa-podcast  fa-2x text-primary"  aria-hidden="true"></i>
                                        <span class="fw-semibold d-block text-primary h6 mt-2 mb-2"><b><?php echo $GLOBALS['strImpression']; ?></b></span>

                                        <!-- <span class="fw-semibold d-block text-primary  h6 mt-2 mb-2"><b>Impressions</b></span> -->
                                        <h3 class="card-title mb-1" id="imp">0</h3>
                                    
                                    </div>
                                </div>
                            </div>
                            <div class="col col-xs-12 col-sm-6 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                <div class="card" style='width:95%'>
                                    <div class="card-body text-center">
                                        <i class="fa fa-external-link  fa-2x text-primary" aria-hidden="true"></i>
                                        <span class="fw-semibold d-block  text-primary h6 mt-2 mb-2"><b><?php echo $GLOBALS['strClicks']; ?></b></span>

                                        <!-- <span class="fw-semibold d-block text-primary h6 mt-2 mb-2"><b>Clicks</b></span> -->
                                        <h3 class="card-title  mb-1" id="cli">0</h3>
                                        <!-- <small class="text-success fw-semibold"> fa-external-link
                                            <i class="bx bx-up-arrow-alt"></i> +00.00%</small>text-nowrap -->
                                    </div>
                                  </div>
                            </div>
                        </div>
                     
                        <div class="row mb-4 mt-2">
                            <div class="col col-xs-12 col-sm-6 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                <div class="card" style='width:95%'>
                                    <div class="card-body text-center">
                                        <i class="fa  fa-hand-pointer-o  fa-2x text-primary" aria-hidden="true"></i>
                                        <span class="fw-semibold d-block text-primary h6 mt-2 mb-2"><b><?php echo $GLOBALS['strConversion']; ?></b></span>

                                        <!-- <span class="fw-semibold d-block  text-primary h6 mt-2 mb-2"><b>Conversions</b></span> -->
                                        <h3 class="card-title text-nowrap mb-1" id="con">0</h3>
                                        <!-- <small class="text-danger fw-semibold"> a-paper-plane-o
                                          <i class="bx bx-down-arrow-alt"></i> -00.00%</small> -->
                                    </div>
                                </div>
                            </div>
                            <!-- <div class="col col-xs-12 col-sm-6 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                <div class="card" style='width:95%'>
                                    <div class="card-body text-center">
                                        <i class="fa fa-credit-card-alt fa-2x text-primary" aria-hidden="true"></i>
                                        <span class="fw-semibold d-block text-primary h6 mt-2 mb-2"><b>Conversions</b></span>
                                        <h3 class="card-title mb-1" id="con">0</h3>
                                      
                                    </div>
                                </div>
                            </div> -->
                        </div>
                    </div>
                </div>

                <div class="mt-3" >
                    <div class="row d-flex justify-content-center" style="margin-top: -10px;">
                    <!-- Top Campaigns -->
                        <div class="col col-xs-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                            <div class="card mb-4" style='height: 94%'>
                                <div class="card-body table-responsive">
                                <p class="h4"><?php echo $GLOBALS['strTopCampaigns']; ?></p>

                                    <!-- <p class="h4">Top Campaigns</p> -->
                                    <table id="top_campaign" class="table table-hover table-striped table-responsive mt-3">
                                        <thead>
                                            <tr>

                                            <th ><?php echo $GLOBALS['strName']; ?></th>
                                                <th class="text-center"><?php echo $GLOBALS['strImpression']; ?></th>
                                                <th class="text-center"><?php echo $GLOBALS['strClicks']; ?></th>
                                                <th class="text-center"><?php echo $GLOBALS['strConversion']; ?></th>

                                                <!-- <th >Name</th>
                                                <th class="text-center">Impression</th>
                                                <th class="text-center">Clicks</th>
                                                <th class="text-center">Conversions</th> -->
                                            </tr>
                                        </thead>
                                        <tbody class="text-center" id="campaign_table"></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Top Websites -->
                        <div class="col col-xs-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                            <div class="card mb-4" style='height: 94%'>
                                <div class="card-body table-responsive"  id="top_websites">
                                    <!-- <p class="h4">Top Websites</p> -->
                                    <p class="h4"><?php echo $GLOBALS['strTopWebsites']; ?></p>

                                    <table id="top_website" class="table table-hover table-striped mt-3">
                                        <thead>
                                            <tr>

                                             <th><?php echo $GLOBALS['strName']; ?></th>
                                                <th class="text-center"><?php echo $GLOBALS['strImpression']; ?></th>
                                                <th class="text-center"><?php echo $GLOBALS['strClicks']; ?></th>

                                                <!-- <th>Name</th>
                                                <th class="text-center">Impression</th>
                                                <th class="text-center">Clicks</th>                                       -->
                                            </tr>
                                        </thead>
                                        <tbody class="text-center" id="website_table"></tbody>
                                    </table>
                                </div>


                                <div class="card-body table-responsive" id="top_banners">
                                    <!-- <p class="h4">Top Banners</p> -->
                                    <p class="h4">Top Webites</p>

                                    <table id="top_banner" class="table table-hover table-striped mt-3">
                                        <thead>
                                            <tr>
                                                <th>Name</th>
                                                <th class="text-center">Impression</th>
                                                <th class="text-center">Clicks</th>        
                                                <th class="text-center">Conversions</th>                              
                                                <!-- <th class="text-center">Spend</th> -->
                                            </tr>
                                        </thead>
                                        <tbody class="text-center" id="banner_table"></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- / Content -->
        <?php include('footer.php'); ?>
        
        <!-- <script type="text/javascript" src="https://cdn.jsdelivr.net/jquery/latest/jquery.min.js"></script> -->
        <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
        <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
        <script>
            var live_URL = '<?php echo $apistatpath; ?>';
            var token = 'Bearer ' + document.getElementById('token').value;
            var client_id = document.getElementById('clientid').value;

            var campaign_url, topCampaign_url,topBanner_url, topWebsite_url, widgets_url, revive, getAllCampaign_url, 
            setDate;            
            localStorage.clear();

            function dash_filter() {
                $(".loader").show();

                var filtervalue = document.getElementById('getDuration').value;
                const date = new Date();

                let getClient = document.getElementById('getTypeofreports').value;
                // console.log("get client", getClient);
                if(getClient == 'revive'){

                    $("#top_website").hide();
                    $("#top_websites").hide();

                    $("#top_banner").show();
                    $("#top_banners").show();
                    campaign_url = live_URL + '/get_advertiser_campaign_graph_statistics/';
                    topCampaign_url = live_URL + '/get_top_campaign_statistics/';
                    topBanner_url = live_URL + '/get_top_banner_statistics/';
                    widgets_url = live_URL + '/get_widgets_advertiser_campaign_statistics/';
                    // getAllCampaign_url = live_URL + '/get_all_revive_advertiser_campaign_graph_statistics/'+ client_id;
                }
                else if(getClient == 'xandr') {

                    $("#top_banner").hide();
                    $("#top_banners").hide();

                    $("#top_website").show();
                    $("#top_websites").show();
                    
                    
                    
                    campaign_url = live_URL + '/get_advertiser_campaign_graph_statistics/';
                    topWebsite_url = live_URL + '/get_top_website_statistics/';
                    topCampaign_url = live_URL + '/get_xandr_top_campaign_statistics/';                    
                    widgets_url = live_URL + '/get_xandr_widgets_advertiser_campaign_statistics/';
                    // getAllCampaign_url = live_URL + '/get_all_advertiser_campaign_graph_statistics/'+client_id;
                }
               

                if (filtervalue == 'Today') {
                    $("#daterange").css("display", "none");

                    let v3 = JSON.stringify(date);
                    v3 = v3.slice(1, 11);
                    var start_date = v3, end_date = v3;
                    setDate= v3;
                    getDashboardDay(start_date, end_date,'');
                }
                else if (filtervalue == 'Yesterday') {
                    $("#daterange").css("display", "none");

                    let current_date = date.setDate(date.getDate() - 1);
                    const get_date = new Date(date);
                    let yesterday_date = JSON.stringify(get_date);
                    yesterday_date = yesterday_date.slice(1, 11);
                    var start_date = yesterday_date, end_date = yesterday_date;
                    getDashboardDay(start_date, end_date,'');
                }
                else if (filtervalue == 'Last 7 days') {
                    $("#daterange").css("display", "none");

                    let date_start = date.setDate(date.getDate() - 7);
                    let get_date = new Date(date_start);
                    let first_day = JSON.stringify(get_date);
                    first_day = first_day.slice(1, 11);

                    let todayDate = new Date();
                    let current_date = todayDate.setDate(todayDate.getDate() - 1);
                    let last_7Days = new Date(todayDate);
                    let date_end = JSON.stringify(last_7Days);
                    date_end = date_end.slice(1, 11);
                    getDashboardDay(first_day, date_end,'');
                }
                else if (filtervalue == 'Last 30 days') {
                    $("#daterange").css("display", "none");

                    let date_start = date.setDate(date.getDate() - 30);
                    let get_date = new Date(date_start);
                    var first_day = JSON.stringify(get_date);
                    first_day = first_day.slice(1, 11);

                    let todayDate = new Date();
                    let current_date = todayDate.setDate(todayDate.getDate() - 1);
                    let last_30Days = new Date(todayDate);
                    let date_end = JSON.stringify(last_30Days);
                    date_end = date_end.slice(1, 11);
                    getDashboardDay(first_day, date_end,'');
                }
                else if (filtervalue == 'This Month') {
                    $("#daterange").css("display", "none");

                    let firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                    let cDate = firstDay.getDate(), cMonth = firstDay.getMonth() + 1, cYear = firstDay.getFullYear();
                    let first_day = cYear + "-" + cMonth + "-" + cDate;

                    let lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);
                    let year = lastDay.getFullYear(), month = lastDay.getMonth() + 1, day = lastDay.getDate();
                    let date_end = year + "-" + month + "-" + day;
                    getDashboardDay(first_day, date_end,'');
                }
                else if (filtervalue == 'Last Month') {
                    $("#daterange").css("display", "none");

                    var prevMonthLastDate = new Date(date.getFullYear(), date.getMonth(), 0);
                    var prevMonthFirstDate = new Date(date.getFullYear() - (date.getMonth() > 0 ? 0 : 1), (date.getMonth() - 1 + 12) % 12, 1);
                    var formatDateComponent = function (dateComponent) {
                        return (dateComponent < 10 ? '0' : '') + dateComponent;
                    }
                    var formatDate = function (date) {
                        return date.getFullYear() + "-" + formatDateComponent(date.getMonth() + 1) + "-" + formatDateComponent(date.getDate())
                    };
                    var start_date = formatDate(prevMonthFirstDate), end_date = formatDate(prevMonthLastDate);
                    getDashboardDay(start_date, end_date,'');
                }
                else if (filtervalue == 'all statistics') {
                    $("#daterange").css("display", "none");
                   
                    let getTypeofreports = document.getElementById('getTypeofreports').value;
                    if(getTypeofreports=="revive"){
                        revive_url= live_URL + '/get_all_top_campaign_statistics/' + client_id;
                        widgetsurl =  '/get_all_widgets_advertiser_campaign_statistics/';
                    }else if(getTypeofreports=="xandr"){
                        revive_url= live_URL + '/get_all_xandr_top_campaign_statistics/' + client_id;
                        widgetsurl =  '/get_all_xandr_widgets_advertiser_campaign_statistics/';
                    }
            

                    // Start impression, click, request and conversion
                    $.ajax({
                        url: live_URL + '/get_all_dashboard_advertiser_campaign_statistics/' + client_id, 
                        type: 'GET',
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        data: {},
                        success: function (data) {
                            // console.log("data....getalldashadvcampstat", data);
                            $(".loader").hide();
                            if (data.msg == 'No Stats Available') {
                                document.getElementById('imp').innerHTML = 0;
                                document.getElementById('cli').innerHTML = 0;
                                document.getElementById('con').innerHTML = 0;
                                // document.getElementById('req').innerHTML = 0;
                            }
                            else {
                                const entries = Object.values(data);
                                // console.log("data1", entries[0]['impressions']);
                                if (entries[0]['impressions'] == undefined) {
                                    document.getElementById('imp').innerHTML = 0;
                                }
                                else if (entries[0]['clicks'] == undefined) {
                                    document.getElementById('cli').innerHTML = 0;
                                }
                                else if (entries[0]['conversions'] == undefined) {
                                    document.getElementById('con').innerHTML = 0;
                                }
                                // else if (entries[0]['requests'] == undefined) {
                                //     document.getElementById('req').innerHTML = 0;
                                // }
                                else {
                                    // document.getElementById('req').innerHTML = Number(data[0].requests).toLocaleString("en-IN");
                                    document.getElementById('imp').innerHTML = Number(data[0].impressions).toLocaleString("en-IN");
                                    document.getElementById('cli').innerHTML = Number(data[0].clicks).toLocaleString("en-IN");
                                    document.getElementById('con').innerHTML = Number(data[0].conversions).toLocaleString("en-IN");
                                }
                            }
                        },
                        error: function () { },
                    });
                    // End impression, click, request and conversion

                    // Start Top Campaign
                    $.ajax({
                        url: revive_url,
                        // url: live_URL + '/get_all_top_campaign_statistics/' + client_id,
                        type: 'GET',
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        data: {},
                        success: function (data) {
                            // console.log("campaign data", data.msg);
                            $(".loader").hide();
                            if (data.msg == 'No Stats Available') {
                                // document.getElementById('campaign_table').innerHTML = `<tr><td colspan="5">No Data found</td></tr>`;
                                 document.getElementById('campaign_table').innerHTML = `<tr><td colspan="5"><?php echo $GLOBALS['strNo_Data_Meassages']; ?></td></tr>`;

                         
                            }
                            else {
                                var  TableData = "";

                                data.map((data, index) => {
                                    if (data.spend == null) { var spend = 0.00; }
                                    else { var spend = data.spend; }
                                    TableData += `<tr key='index'>
                                    <td class="text-hide">${data.campaignname}</td>
                                    <td>${Number(data.impressions).toLocaleString("en-IN")}</td>
                                    <td>${Number(data.clicks).toLocaleString("en-IN")}</td>
                                    <td>${Number(data.conversions).toLocaleString("en-IN")}</td>
                                 
                                </tr>`
                                });
                                document.getElementById('campaign_table').innerHTML = TableData;
                            }
                        },
                        error: function () { },
                    });
                    // End Top Campaign

                    let getClient = document.getElementById('getTypeofreports').value;
              
                    if(getClient=="revive"){
                    // Top Banner Start
                    $.ajax({
                        url: live_URL + '/get_all_top_banner_statistics/' + client_id,
                        type: 'GET',
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        data: {},
                        success: function (data) {
                            $(".loader").hide();
                            if (data.msg == 'No Stats Available') {
                                document.getElementById('banner_table').innerHTML = `<tr><td colspan="5"><?php echo $GLOBALS['strNo_Data_Meassages']; ?></td></tr>`;

                                // document.getElementById('banner_table').innerHTML = `<tr><td colspan="5">No Data found</td></tr>`;
                            }
                            else {
                                var getBanData = "";

                                data.map((data, index) => {
                                    // let sum = data.spend;
                                    if (data.spend == null) { var spend = 0.00; }
                                    else { var spend = data.spend; }
                                    getBanData += `<tr key='index'>
                                                <td class="text-hide">${data.affiliatename}</td>
                                                <td>${Number(data.impressions).toLocaleString("en-IN")}</td>
                                                <td>${Number(data.clicks).toLocaleString("en-IN")}</td>
                                                <td>${Number(data.conversions).toLocaleString("en-IN")}</td>
                                            
                                            </tr>`
                                });
                                document.getElementById('banner_table').innerHTML = getBanData;
                            }
                        },
                        error: function () { },
                    });
                    // End Banner Start

                    }
                    else if(getClient=="xandr"){
                        // console.log("alll....", getClient);
                        // Top Website Start
                        $.ajax({
                                url: live_URL + '/get_all_top_website_statistics',
                                type: 'GET',
                                beforeSend: function (xhr) {
                                    xhr.setRequestHeader('Authorization', token);
                                },
                                data: {},
                                success: function (data) {
                                    // console.log('all top,,,web stat.....',data);
                                    $(".loader").hide();
                                    if (data.msg == 'No Stats Available') {
                                        document.getElementById('website_table').innerHTML = `<tr><td colspan="4">No Data found</td></tr>`;
                                    }
                                    else {
                                        var getBanData = "";

                                        data.map((data, index) => {
                                            // let sum = data.spend;
                                            if (data.spend == null) { var spend = 0.00; }
                                            else { var spend = data.spend; }
                                            getBanData += `<tr key='index'>
                                                        <td class="text-hide">${data.websitesname}</td>
                                                        <td>${Number(data.impressions).toLocaleString("en-IN")}</td>
                                                        <td>${Number(data.clicks).toLocaleString("en-IN")}</td>                                                      
                                                    </tr>`
                                        });
                                        document.getElementById('website_table').innerHTML = getBanData;
                                    }
                                },
                                error: function () { },
                            });
                            // End Website Start

                    }
                        
                    // Start impression, click, request and conversion
                    $.ajax({
                        // url: live_URL + '/get_all_widgets_advertiser_campaign_statistics/' + client_id,
                        url: live_URL + widgetsurl + client_id,
                        type: 'GET',
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        data: {},
                        success: function (data) {
                            //$('#hmm').html(data);
                            // console.log("data....", data);
                            $(".loader").hide();
                            if (data.msg == 'No Stats Available') {
                                document.getElementById('imp').innerHTML = 0;
                                document.getElementById('cli').innerHTML = 0;
                                document.getElementById('con').innerHTML = 0;
                                // document.getElementById('req').innerHTML = 0;
                            }
                            else {
                                const entries = Object.values(data);
                                if ( entries[0]['impressions'] == null && entries[0]['clicks'] == null && entries[0]['conversions'] == null) {
                                    // document.getElementById('req').innerHTML = 0;
                                    document.getElementById('imp').innerHTML = 0;
                                    document.getElementById('cli').innerHTML = 0;
                                    document.getElementById('con').innerHTML = 0;
                                }
                                else {
                                    // document.getElementById('req').innerHTML = Number(data[0].requests).toLocaleString("en-IN");
                                    document.getElementById('imp').innerHTML = Number(data[0].impressions).toLocaleString("en-IN");
                                    document.getElementById('cli').innerHTML = Number(data[0].clicks).toLocaleString("en-IN");
                                    document.getElementById('con').innerHTML = Number(data[0].conversions).toLocaleString("en-IN");
                                }
                            }
                        },
                        error: function () { },
                    });
                    // End impression, click, request and conversion
                      

                    // Campaign Chart Start
                    $.ajax({
                        url: live_URL + '/get_all_advertiser_campaign_graph_statistics/' + client_id,
                        type: 'GET',
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        data: {},
                        success: function (data) {
                            // console.log("Campaign all data", data);
                            let reviveData = data.todos__revive_sql, xendrData = data.todos;
                            if (data.msg == 'No Stats Available') {
                                testChart(campaignName = [], ImpressionValue = [], clickValue = [],
                                    conversionsValue = [], revenueValue = [], ctrValue = [],
                                    ecpmValue = []);
                                    // document.getElementById("zoomButton").disabled = true;
                                    document.getElementById("zoomButton").style.display = "none";
                                    document.getElementById("zoomButton").title="No data, so button disabled";
                            }
                            else {
                                $(".loader").show();
                                // document.getElementById("zoomButton").disabled = true;
                                document.getElementById("zoomButton").style.display = "none";
                                document.getElementById("zoomButton").title="Zoom Button";

                                //revive
                                var campaignName = reviveData.map((data) => {
                                    return data.campaignname;
                                });

                                var ImpressionValue = reviveData.map((data, index) => {
                                    let convert = parseInt(data.impressions, 10);
                                    if (data.impressions == null) {
                                        convert[index] = 0;
                                    } else {
                                        return convert;
                                    }
                                });

                                var clickValue = reviveData.map((data, index) => {
                                    let convert = parseInt(data.clicks, 10);
                                    if (data.clicks == null) {
                                        convert[index] = 0;
                                    } else {
                                        return convert;
                                    }
                                });

                                var conversionsValue = reviveData.map((data, index) => {
                                    let convert = parseInt(data.conversions, 10);
                                    if (data.conversions == null) {
                                        convert[index] = 0;
                                    } else {
                                        return convert;
                                    }
                                });

                                var revenueValue = reviveData.map((value, index) => {
                                    let convert = parseInt(value.spend, 10);
                                    if (value.spend == null) {
                                        return convert[index] = 0;
                                    }
                                    else {
                                        return convert;
                                    }
                                });
                                
                                var ctrValue = reviveData.map((data, index) => {
                                    let convert = parseInt(data.ctr, 10);
                                    if (data.ctr == null) {
                                        return convert[index] = 0;
                                    }
                                    else {
                                        return convert;
                                    }
                                });
                                
                                var ecpmValue = reviveData.map((data, index) => {
                                    let convert = parseInt(data.ecpm, 10);
                                    if (data.ecpm == null) {
                                        return convert[index] = 0;
                                    }
                                    else {
                                        return convert;
                                    }
                                    return convert;
                                });

                                //Get Xandr Live data
                                
                                var xandr_campaignName = xendrData.map((data) => {                                    
                                    return data.campaignname;
                                });

                                var xandr_impressions = xendrData.map((data, index) => {
                                    let convert = parseInt(data.xandr_impressions, 10);
                                    if (data.xandr_impressions == null) {
                                        convert[index] = 0;
                                    } else {
                                        return convert;
                                    }
                                });

                                var xandr_clicks = xendrData.map((data, index) => {
                                    let convert = parseInt(data.xandr_clicks, 10);
                                    if (data.xandr_clicks == null) {
                                        convert[index] = 0;
                                    } else {
                                        return convert;
                                    }
                                });

                                var xandr_conversion = xendrData.map((data, index) => {
                                    let convert = parseInt(data.conversions, 10);
                                    if (data.conversions == null) {
                                        return convert[index] = 0;
                                    }
                                    else {
                                        return convert;
                                    }
                                });

                                var xandr_spend = xendrData.map((data, index) => {
                                    let convert = parseInt(data.spend, 10);
                                    if (data.spend == null) {
                                        return convert[index] = 0;
                                    }
                                    else {
                                        return convert;
                                    }
                                });
                                // console.log("xandr_spend:", xandr_spend);
                                
                                var xandr_ctr = xendrData.map((data, index) => {
                                    let convert = parseInt(data.xandr_ctr, 10);
                                    if (data.xandr_ctr == null) {
                                        return convert[index] = 0;
                                    }
                                    else {
                                        return convert;
                                    }
                                });

                                var xandr_ecpm = xendrData.map((data, index) => {
                                    let convert = parseInt(data.xandr_ecpm, 10);
                                    if (data.xandr_ecpm == null) {
                                        return convert[index] = 0;
                                    }
                                    else {
                                        return convert;
                                    }
                                    return convert;
                                });

                                testChart(campaignName, ImpressionValue, clickValue, conversionsValue, revenueValue, ctrValue,
                                ecpmValue, xandr_campaignName, xandr_impressions, xandr_clicks,xandr_conversion,xandr_spend, xandr_ctr, xandr_ecpm);
                                campaignChart(campaignName, ImpressionValue, clickValue, conversionsValue, revenueValue, ctrValue,
                                ecpmValue,xandr_impressions, xandr_clicks,xandr_conversion,xandr_spend, xandr_ctr, xandr_ecpm);
                            }
                        },
                        error: function () { },
                    });
                    // Campaign Chart End
                }
                else if (filtervalue == 'custom') {
                    $("#daterange").css("display", "block");
                    $(".loader").hide();
                    var start_date,end_date;
                    //current Date pass in getDashboardDay()
                    getDashboardDay(setDate, setDate,'');
                    // var check=$("#daterange").val();
                    // console.log('check',check);

                    
                    
                    $(function () {
                        $('input[name="daterange"]').daterangepicker({
                            opens: 'left',
                            locale: {
                                format: 'DD/MMM/YYYY'
                            }
                        }, function (start, end, label) {
                             start_date = start.format('YYYY-MM-DD'), end_date = end.format('YYYY-MM-DD');
                             console.log('start_date...',start_date);
                             console.log('end_date...',end_date);


                //     var input = document.createElement("input");
                //     input.setAttribute("type", "hidden");
                //     input.setAttribute("name", "cust_startdate");
                //     input.setAttribute("value", start_date);                  
                //     document.getElementById("cust_startdate").appendChild(input);

                //   var cust_startdate=  $("#cust_startdate").val();
                //     console.log('cust_startdate.....',cust_startdate);



                             localStorage.setItem("cust_startdate", start_date);
                             localStorage.setItem("cust_enddate", end_date);
                             var local= localStorage.getItem("start_date");
                             console.log('local',local);

                             var check=$("#daterange").val();
                             console.log('check',check);
                             
                            getDashboardDay(start_date, end_date,local);
                        })
                    });



                    start_date != 'undefined'?testChart(campaignName = [], ImpressionValue = [], clickValue = [],
                                conversionsValue = [], revenueValue = [], ctrValue = [],
                                ecpmValue = []):"0";
                                document.getElementById("zoomButton").disabled = true;
                                // console.log("start", start_date, "end", end_date);
                }
            };

            onChangeReviveXandr = () => {
                let getSelectedDay = document.getElementById('getDuration').value;
                // console.log("get Selected Day", getSelectedDay);
                let typeofreports = document.getElementById('getTypeofreports').value;
                console.log("typeofreports", typeofreports);
                

                // getSelectedDay == "custom"?dash_filter().onload():"";
                if(getSelectedDay == "custom"){
                    // const getDuration1 = document.getElementById('getDuration');
                    // getDuration1.value = 'Today';
                    // $("#daterange").css("display", "none");
                    
                    // document.getElementById('getDuration').getElementsByTagName('option')['Today'].selected = 'selected'

                }
                // getSelectedDay == "custom"?location.reload():"";

                // document.getElementById('getTypeofreports').value='Revive';

            };

            function getDashboardDay(startDate, endDate,local) {
                console.log('local',local);

                var getDuration=$("#getDuration").val();
                console.log('getDuration',getDuration);
                var cust_startdate= localStorage.getItem("cust_startdate");
                console.log('cust_startdate',cust_startdate);
                var cust_enddate= localStorage.getItem("cust_enddate");
                console.log('cust_enddate',cust_enddate);


                console.log('startDate',startDate);
                console.log('endDate',endDate);
                
                if(getDuration=="custom" && cust_startdate!=null && cust_enddate!=null ){
                    console.log('........');
                    var start_end_date= cust_startdate + ' 00:00:00,' + cust_enddate + ' 23:59:59,'
                }else{
                    var start_end_date= startDate + ' 00:00:00,' + endDate + ' 23:59:59,';
                }

              
              
                // var start_end_date= startDate + ' 00:00:00,' + endDate + ' 23:59:59,'


                // Campaign Chart Start
                $.ajax({
                    url:  campaign_url + start_end_date + client_id,

                    // url:  campaign_url + startDate + ' 00:00:00,' + endDate + ' 23:59:59,' + client_id,
                    type: 'GET',
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: {},
                    success: function (data) {
                        // console.log("Campaign data", data.todos);
                        // console.log("todos__revive_sql data", data.todos__revive_sql);
                        let reviveData = data.todos__revive_sql, xendrData = data.todos;

                        if (data.msg == 'No Stats Available') {
                            testChart(campaignName = [], ImpressionValue = [], clickValue = [],
                                conversionsValue = [], revenueValue = [], ctrValue = [],
                                ecpmValue = []);
                            // document.getElementById("zoomButton").disabled = true;
                            document.getElementById("zoomButton").style.display = "none";
                            document.getElementById("zoomButton").title="No data, so button disabled";
                        }
                        else {
                            $(".loader").show();
                            // document.getElementById("zoomButton").disabled = true;
                            document.getElementById("zoomButton").style.display = "none";
                            document.getElementById("zoomButton").title="Zoom Button";

                            //         let data.todos=data1;
                            // let campaignName1 = data.map((data1) => {
                            //     console.log('campaignName1',data1);
                            //     // return data.campaignname;
                            // });

                            // Get Revive Live Data 
                            let campaignName = reviveData.map((data) => {
                                return data.campaignname;
                            });

                            let ImpressionValue = reviveData.map((data) => {
                                if (data.impressions == null) {
                                    return data.impressions = 0;
                                }
                                else {
                                    return data.impressions;
                                }
                            });

                            let clickValue = reviveData.map((data) => {
                                if (data.clicks == null) {
                                    return data.clicks = 0;
                                }
                                else {
                                    return data.clicks;
                                }
                            });

                            let conversionsValue = reviveData.map((data) => {
                                if (data.conversions == null) {
                                    return data.conversions = 0;
                                }
                                else {
                                    return data.conversions;
                                }
                            });

                            let revenueValue = reviveData.map((value) => {
                                // let convert = parseInt(value.revenue, 10);
                                // console.log("revenueValue", value.revenue);

                                if (value.revenue == null) {
                                    return value.revenue = 0.00;
                                }
                                else {
                                    return value.revenue;
                                }
                            });

                            let ctrValue = reviveData.map((data) => {
                                if (data.ctr == null) {
                                    return data.ctr = 0;
                                }
                                else {
                                    return data.ctr;
                                }
                            });

                            let ecpmValue = reviveData.map((data) => {
                                if (data.ecpm == null) {
                                    return data.ecpm = 0;
                                }
                                else {
                                    return data.ecpm;
                                }
                            });

                            //Get xendr Live Data

                            var xandr_campaignName = xendrData.map((data) => {                                    
                                    return data.campaignname;
                                });
                            
                            let xandr_impressions = xendrData.map((data, index) => {
                                if (data.xandr_impressions == null) {
                                    return data.xandr_impressions[index] = 0;
                                }
                                else {
                                    return data.xandr_impressions;
                                }
                            });
                            
                            let xandr_clicks = xendrData.map((data) => {
                                if (data.xandr_clicks == null) {
                                    return data.xandr_clicks[index] = 0;
                                }
                                else {
                                    return data.xandr_clicks;
                                }
                            });

                            let xandr_conversion = xendrData.map((data) => {
                                if (data.conversions == null) {
                                    return data.conversions[index] = 0;
                                }
                                else {
                                    return data.conversions;
                                }
                            });

                            let xandr_spend = xendrData.map((data) => {
                                if (data.spend == null) {
                                    return data.spend[index] = 0;
                                }
                                else {
                                    return data.spend;
                                }
                            });

                            let xandr_ctr = xendrData.map((data, index) => {
                                if (data.xandr_ctr == null) {
                                    return data.xandr_ctr[index] = 0;
                                }
                                else {
                                    return data.xandr_ctr;
                                }
                            });
                            
                            var xandr_ecpm = xendrData.map((data, index) => {
                                if (data.xandr_ecpm == null) {
                                    return data.xandr_ecpm[index] = 0;
                                }
                                else {
                                    return data.xandr_ecpm;
                                }
                            });

                            testChart(campaignName, ImpressionValue, clickValue, conversionsValue, revenueValue, ctrValue,
                            ecpmValue,xandr_campaignName, xandr_impressions, xandr_clicks,xandr_conversion,xandr_spend, xandr_ctr, xandr_ecpm);
                            campaignChart(campaignName, ImpressionValue, clickValue, conversionsValue, revenueValue, ctrValue,
                            ecpmValue,xandr_impressions, xandr_clicks,xandr_conversion,xandr_spend, xandr_ctr, xandr_ecpm);
                        }
                    },
                    error: function () { },
                });
                // Campaign Chart End



                var getDuration=$("#getDuration").val();
                console.log('1...getDuration',getDuration);
                var cust_startdate= localStorage.getItem("cust_startdate");
                console.log('2...cust_startdate',cust_startdate);
                var cust_enddate= localStorage.getItem("cust_enddate");
                console.log('3...cust_enddate',cust_enddate);


                
                
                if(getDuration=="custom" && cust_startdate!=null && cust_enddate!=null ){
                    console.log('........1');
                    var custom_start_enddate= cust_startdate + ' 00:00:00,' + cust_enddate + ' 23:59:59,'
                }else{
                    var custom_start_enddate= startDate + ' 00:00:00,' + endDate + ' 23:59:59,';
                }

                // Start impression, click, request and conversion
                $.ajax({
                    url: widgets_url + custom_start_enddate + client_id,

                    // url: widgets_url + startDate + ' 00:00:00,' + endDate + ' 23:59:59,' + client_id,
                    type: 'GET',
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: {},
                    success: function (data) {
                        //$('#hmm').html(data);
                        // console.log("data....", data);
                        $(".loader").hide();
                        if (data.msg == 'No Stats Available') {
                            document.getElementById('imp').innerHTML = 0;
                            document.getElementById('cli').innerHTML = 0;
                            document.getElementById('con').innerHTML = 0;
                            // document.getElementById('req').innerHTML = 0;
                        }
                        else {
                            const entries = Object.values(data);
                            if ( entries[0]['impressions'] == null && entries[0]['clicks'] == null && entries[0]['conversions'] == null) {
                                // document.getElementById('req').innerHTML = 0;
                                document.getElementById('imp').innerHTML = 0;
                                document.getElementById('cli').innerHTML = 0;
                                document.getElementById('con').innerHTML = 0;
                            }
                            else {
                                // document.getElementById('req').innerHTML = Number(data[0].requests).toLocaleString("en-IN");
                                document.getElementById('imp').innerHTML = Number(data[0].impressions).toLocaleString("en-IN");
                                document.getElementById('cli').innerHTML = Number(data[0].clicks).toLocaleString("en-IN");
                                document.getElementById('con').innerHTML = Number(data[0].conversions).toLocaleString("en-IN");
                            }
                        }
                    },
                    error: function () { },
                });
                // End impression, click, request and conversion

                // Top Campaign Start
                $.ajax({
                    url: topCampaign_url + custom_start_enddate + client_id,
                    // url: topCampaign_url + startDate + ' 00:00:00,' + endDate + ' 23:59:59,' + client_id,
                    type: 'GET',
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: {},
                    success: function (data) {
                        // console.log("campaign data", data.msg);
                        $(".loader").hide();
                        if (data.msg == 'No Stats Available') {
                            // let start = ;
                            document.getElementById('campaign_table').innerHTML = `<tr><td colspan="5">No Data found</td></tr>`;
                        }
                        else {
                            var getCamData = "";
                            data.map((data, index) => {
                                if (data.spend == null) { var spend = 0.00; }
                                else { var spend = data.spend; }
                                getCamData += `<tr key='index'>
                                                 <td class="text-hide">${data.campaignname}</td>
                                                 <td>${Number(data.impressions).toLocaleString("en-IN")}</td>
                                                 <td>${Number(data.clicks).toLocaleString("en-IN")}</td>
                                                 <td>${Number(data.conversions).toLocaleString("en-IN")}</td>
                                             </tr>`
                            });
                            document.getElementById('campaign_table').innerHTML = getCamData;
                        }
                    },
                    error: function () { },
                });


                // <td>`+ spend + `</td>

                // End Top Campaign

                let getClient = document.getElementById('getTypeofreports').value;
                // console.log("alll....", getClient);
                    if(getClient=="revive"){
                        // Start Top Banner
                        $.ajax({
                            url: topBanner_url + custom_start_enddate + client_id,
                            // url: topBanner_url + startDate + ' 00:00:00,' + endDate + ' 23:59:59,' + client_id,
                            type: 'GET',
                            beforeSend: function (xhr) {
                                xhr.setRequestHeader('Authorization', token);
                            },
                            data: {},
                            success: function (data) {
                                // console.log("campaign data", data.msg);
                                $(".loader").hide();
                                if (data.msg == 'No Stats Available') {
                                    document.getElementById('banner_table').innerHTML = `<tr><td colspan="5">No Data found</td></tr>`;
                                }
                                else {
                                    var getBanData = "";
                                    data.map((data, index) => {
                                        if (data.spend == null) { var spend = 0.00; }
                                        else { var spend = data.spend; }
                                        getBanData += `<tr key='index'>
                                                                <td class='text-hide text-start'>${data.affiliatename}</td>
                                                                <td>${Number(data.impressions).toLocaleString("en-IN")}</td>
                                                                <td>${Number(data.clicks).toLocaleString("en-IN")}</td>
                                                                <td>${Number(data.conversions).toLocaleString("en-IN")}</td>
                                                              
                                                            </tr>`
                                    });
                                    document.getElementById('banner_table').innerHTML = getBanData;
                                }
                            },
                            error: function () { },
                        });
                        // End Top Banner
                    }
                    else{

                        // Start Top website
                        $.ajax({
                            url: topWebsite_url + custom_start_enddate + client_id,

                            // url: topWebsite_url + startDate + ' 00:00:00,' + endDate + ' 23:59:59' ,
                            type: 'GET',
                            beforeSend: function (xhr) {
                                xhr.setRequestHeader('Authorization', token);
                            },
                            data: {},
                            success: function (data) {
                                // console.log("campaign data", data);
                                $(".loader").hide();
                                if (data.msg == 'No Stats Available') {
                                    document.getElementById('website_table').innerHTML = `<tr><td colspan="4">No Data found</td></tr>`;
                                }
                                else {
                                    var getBanData = "";
                                    data.map((data, index) => {
                                        if (data.spend == null) { var spend = 0.00; }
                                        else { var spend = data.spend; }
                                        getBanData += `<tr key='index'>
                                                                <td class='text-hide text-start'>${data.websitesname}</td>
                                                                <td>${Number(data.impressions).toLocaleString("en-IN")}</td>
                                                                <td>${Number(data.clicks).toLocaleString("en-IN")}</td>                                                             
                                                            </tr>`;
                                    });
                                    document.getElementById('website_table').innerHTML = getBanData;
                                }
                            },
                            error: function () { },
                        });
                        // End Top website
                    }      
            };
        </script>
        <!-- <script src="../assets/js/config.js"></script> -->
        <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>
  </body>
</html>
