<?php
include('session.php');
include('../config.php');
include('../common.php');

 ?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <!-- <title><?php echo $projecttitle; ?> - Campaign | Report</title> -->
    <title><?php echo $projecttitle; ?> - <?php echo $GLOBALS['strReport_Campaign_Report_Head']; ?></title>

    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <meta name="description" content="" />
    <?php include('head.php'); ?>
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <style>
        .text-hide {
            display: block;
            width: 125px;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
        }

        .text-hide:hover {
            overflow: inherit;
            width: auto;
        }

        .loader {
            display: none;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999;
            background: rgba(255, 255, 255, 0.8) url("../assets/img/loader.gif") center no-repeat;
        }

        h5 {
            position: relative;
            left: 200%;
        }
         /* Close Button */
         .dataTables_wrapper .dataTables_filter input:not(:valid):not(:focus){
  box-shadow: 0 0 5px #fff!important;
	}
	.dataTables_wrapper .dataTables_filter input::-webkit-search-cancel-button {
	  -webkit-appearance: none!important;
	}
	.dataTables_wrapper .dataTables_filter button{
	  visibility: hidden;
	  outline: none;
	}
	.dataTables_wrapper .dataTables_filter input:valid ~ button{
	  visibility: visible;
	}
	
	button.close 
	{
    padding: 0;
    background-color: transparent;
    border: 0;
    -webkit-appearance: none;
    -moz-appearance: none;
    appearance: none;
    }
	.close {
    float: right;
    font-size: 1.5rem;
    font-weight: 700;
    line-height: 1;
    color: #000;
    text-shadow: 0 1px 0 #fff;
    opacity: .5;
}
    </style>
</head>

<body  onload="onChangeDetails()">
    <div class="loader" ></div>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page" id="myImage">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card mt-3 mb-5">
                            <div class="card-body">
                                <div>
                                    <div class="row mb-4 mt-2">
                                        <div class="col-9">
                                        <p class='h4'><?php echo $GLOBALS['strReport_Campaign_Report_Head']; ?></p>
                                            <!-- <p class='h4'>Campaign Report</p> -->
                                        </div>
                                        <div class="mb-3" style="width:28%; margin-left: 38%;">
                                            <select id="getCampaign" class="form-select text-dark"
                                                aria-label="Default select example" onchange="onChangeDetails()">
                                                <option value="Today"><?php echo $GLOBALS['strToday']; ?></option>
                                                <option value="Yesterday"><?php echo $GLOBALS['strYesterday']; ?></option>
                                                <option selected value="Last 7 days"><?php echo $GLOBALS['strLast 7 days']; ?></option>
                                                <option value="Last 30 days"><?php echo $GLOBALS['strLast 30 days']; ?></option>
                                                <option value="Last Month"><?php echo $GLOBALS['strLast Month']; ?></option>
                                                <option value="This Month"><?php echo $GLOBALS['strThis Month']; ?></option>
                                                <option value='all statistics'><?php echo $GLOBALS['strAll Statistics']; ?></option>
                                                <option value="custom"><?php echo $GLOBALS['strCustom']; ?></option>
                                          
                                            </select>
                                            <input style="display: none; width: 95%; margin-left:3%" id="daterange" name="daterange" class='mt-2'  />
                                        </div>
                                        <div class="mb-3" style="width:30%" >
                                <select id="getTypeofreports" class="form-select text-dark" onchange="onChangeDetails();">
                                    <option selected value="Xandr"><?php echo $GLOBALS['strXandr']; ?></option>
                                    <option value="Revive"><?php echo $GLOBALS['strRevive']; ?></option>
                                     <option value="all"><?php echo $GLOBALS['strAlloption']; ?></option>
                                </select>
                            </div>
                                    </div>
                                    <div class="table-responsive text-nowrap">
                                        <!-- id="example2" -->
                                        <table id="camapaignrep" class="table table-striped">
                                            <thead>
                                                <tr class="text-dark">
                                                 
                                                    <th class="text-dark"><?php echo $GLOBALS['strName']; ?></th>
                                                    <th class="text-dark text-center"><?php echo $GLOBALS['strImpression']; ?></th>
                                                    <th class="text-dark text-center"><?php echo $GLOBALS['strClicks']; ?></th>
                                                    <!-- <th class="text-dark text-center" style="text-align: center;"><?php echo $GLOBALS['strConversion']; ?></th> -->
                                                    <th class="text-dark text-center" style="text-align: center;"><?php echo $GLOBALS['strCTR']; ?> %</th>
                                                    <!-- <th class="text-dark text-start"><?php echo $GLOBALS['strECPM']; ?></th> -->

                                                </tr>
                                            </thead>
                                            <tbody id="camp_table"></tbody>
                                        
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- / Content -->

                    <!-- Footer -->
                    <?php 
                    include('footer.php'); 
                    ?>
                    <!-- / Footer -->
                    <!--<script type="text/javascript" src="https://cdn.jsdelivr.net/jquery/latest/jquery.min.js"></script>-->
                    <script type="text/javascript"
                        src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
                    <script type="text/javascript"
                        src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
                    <script>
                        var live_URL = '<?php echo $apistatpath; ?>';
                        
                        var domain_url = live_URL + '/get_advertiser_campaign_report_statistics/';
                        var  Xandr_url  = live_URL + '/get_advertiser_campaign_xender_report_statistics/';
                        var all_website_url = live_URL + '/get_all_website_campaign_report_statistics/';
                        
                        var token = 'Bearer ' + document.getElementById('token').value;
                        var client_id = document.getElementById('clientid').value;
                        var getCampData = "", setDate;
             
                        localStorage.clear();

                        function onChangeDetails() {
                            $(".loader").show();
                            const date = new Date();
                            var getTypeofreports = document.getElementById('getTypeofreports').value;
                            let getSelectedDay = document.getElementById('getCampaign').value;
                                                      
                            var getCampData = "";

                            if (getSelectedDay == 'Today') {
                                $("#daterange").css("display", "none");
                                let v3 = JSON.stringify(date);
                                v3 = v3.slice(1, 11);
                                var start_date = v3, end_date = v3;
                                setDate = v3;
                                if(getTypeofreports=='Xandr')
                                {
                                    getXandrDate(start_date, end_date);
                                }
                                else if(getTypeofreports=='Revive')
                                {
                                    getCampaignDate(start_date, end_date);
                                }
                                else 
                                {
									getAllWebsiteDate(start_date, end_date);
								}
                                
                            }
                            else if (getSelectedDay == 'Yesterday') {
                                $("#daterange").css("display", "none");
                                let current_date = date.setDate(date.getDate() - 1);
                                const get_date = new Date(date);
                                let yesterday_date = JSON.stringify(get_date);
                                yesterday_date = yesterday_date.slice(1, 11);
                                var start_date = yesterday_date, end_date = yesterday_date;
                                if(getTypeofreports=='Xandr')
                                {
                                    getXandrDate(start_date, end_date);
                                }
                                else if(getTypeofreports=='Revive')
                                {
                                    getCampaignDate(start_date, end_date);
                                }
                                else 
                                {
									getAllWebsiteDate(start_date, end_date);
								}
                            }
                            else if (getSelectedDay == 'Last 7 days') {
                                $("#daterange").css("display", "none");
                                let date_start = date.setDate(date.getDate() - 7);
                                let get_date = new Date(date_start);
                                let first_day = JSON.stringify(get_date);
                                first_day = first_day.slice(1, 11);

                                let todayDate = new Date();
                                let current_date = todayDate.setDate(todayDate.getDate() - 1);
                                const last_7Days = new Date(todayDate);
                                let date_end = JSON.stringify(last_7Days);
                                date_end = date_end.slice(1, 11);
                                if(getTypeofreports=='Xandr')
                                {
                                    getXandrDate(first_day, date_end);
                                }
                                else if(getTypeofreports=='Revive')
                                {
                                    getCampaignDate(first_day, date_end);
                                }
                                else 
                                {
									getAllWebsiteDate(first_day, date_end);
								}
                            }
                            else if (getSelectedDay == 'Last 30 days') {
                                $("#daterange").css("display", "none");
                                let date_start = date.setDate(date.getDate() - 30);
                                let get_date = new Date(date_start);
                                var first_day = JSON.stringify(get_date);
                                first_day = first_day.slice(1, 11);

                                let todayDate = new Date();
                                let current_date = todayDate.setDate(todayDate.getDate() - 1);
                                const last_30Days = new Date(todayDate);
                                let date_end = JSON.stringify(last_30Days);
                                date_end = date_end.slice(1, 11);
                                console.log(getTypeofreports);
                                if(getTypeofreports=='Xandr')
                                {
                                    getXandrDate(first_day, date_end);
                                }
                               else if(getTypeofreports=='Revive')
                                {
                                    getCampaignDate(first_day, date_end);
                                }
                                else 
                                {
									getAllWebsiteDate(first_day, date_end);
								}
                            }
                            else if (getSelectedDay == 'This Month') {
                                $("#daterange").css("display", "none");
                                let firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                                let cYear = firstDay.getFullYear(), cMonth = firstDay.getMonth() + 1, cDate = firstDay.getDate();
                                let first_day = cYear + "-" + cMonth + "-" + cDate;

                                let lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);
                                let year = lastDay.getFullYear(), month = lastDay.getMonth() + 1, day = lastDay.getDate();
                                let date_end = year + "-" + month + "-" + day;
                                if(getTypeofreports=='Xandr')
                                {
                                    getXandrDate(first_day, date_end);
                                }
                                else if(getTypeofreports=='Revive')
                                {
                                    getCampaignDate(first_day, date_end);
                                }
                                else 
                                {
									getAllWebsiteDate(first_day, date_end);
								}
                            }
                            else if (getSelectedDay == 'Last Month') {
                                $("#daterange").css("display", "none");
                                var prevMonthLastDate = new Date(date.getFullYear(), date.getMonth(), 0);
                                var prevMonthFirstDate = new Date(date.getFullYear() - (date.getMonth() > 0 ? 0 : 1), (date.getMonth() - 1 + 12) % 12, 1);
                                var formatDateComponent = function (dateComponent) {
                                    return (dateComponent < 10 ? '0' : '') + dateComponent;
                                }
                                var formatDate = function (date) {
                                    return date.getFullYear() + "-" + formatDateComponent(date.getMonth() + 1) + "-" + formatDateComponent(date.getDate())
                                };
                                var start_date = formatDate(prevMonthFirstDate), end_date = formatDate(prevMonthLastDate);
                                if(getTypeofreports=='Xandr')
                                {
                                    getXandrDate(start_date, end_date);
                                }
                                else if(getTypeofreports=='Revive')
                                {
                                    getCampaignDate(start_date, end_date);
                                }
                                else 
                                {
									getAllWebsiteDate(start_date, end_date);
								}
                            }
                            else if (getSelectedDay == 'all statistics') {
                                 if(getTypeofreports=='Xandr'){
                                    $("#daterange").css("display", "none");
                                $.ajax({
                                    url: live_URL + '/get_all_advertiser_campaign__xender_statistics/' + client_id,
                                    type: 'GET',
                                    beforeSend: function (xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: {},
                                    success: function (data) {
                                        
                                        $(".loader").hide();
                                        if (data.msg == 'No Stats Available') {
                                            $('#camapaignrep').DataTable({
                                            ordering: false,
                                            destroy: true,
                                            responsive: true,
                                            bPaginate: false,
                                            bInfo: false,
                                            data:[],
                                            searching: false,
                                            oLanguage: {
                                                sEmptyTable:"No Data Found"
                                            }
                                        });
                                        }
                                        else {
                                            var xandr="xandr";
                                            var getCampaign = $("#getCampaign").val();
                                            var cust_startdate= localStorage.getItem("cust_startdate");                                  
                                            var cust_enddate= localStorage.getItem("cust_enddate");
                                        
                                                if(getCampaign=="custom" && cust_startdate!=null && cust_enddate!=null ){
                                                    console.log('........');
                                                    var start_date=cust_startdate;
                                                    var end_date=cust_enddate;
                                                }else{
                                                    var start_date=start_date;
                                                    var end_date=end_date;
                                                }
                                       
                                            // document.getElementById('camp_table').innerHTML = getCampData;
                                            $('#camapaignrep').DataTable({
                                                "ordering": true,
                                                "destroy": true,
                                                data: data,
                                                columns: [
                                                    { 'data': null, title: 'Name', wrap: true, "render": function (campaign) { return '<a href="campaign_reportgraph.php?campaignid='+campaign.campaignid+'&campaignname='+campaign.campaignname+'&start_date='+start_date+'&end_date='+end_date+'&params='+xandr+'">'+campaign.campaignname+'</a>' } },
                                                    { data: 'xandr_impressions', className: "text-center" },
                                                    { data: 'xandr_clicks', className: "text-center" },
                                                    //{ data: 'conversions', className: "text-center" },
                                                    { data: 'xandr_ctr', className: "text-center" },
                                                    /*{ data: 'xandr_ecpm', className: "text-start", render: function(data, type, row, meta) {
                                                        return row.ecpm == null?"0.0000":row.ecpm;
                                                    } },*/
                                                ],
												footerCallback: function ( row, data, start, end, display ) {
                                                var api = this.api(), data;
                                    
                                                // converting to interger to find total
                                                var intVal = function ( i ) {
                                                    return typeof i === 'string' ?
                                                        i.replace(/[\$,]/g, '')*1 :
                                                        typeof i === 'number' ?
                                                            i : 0;
                                                };
                                    
                                                // computing column Total of the complete result 
                                                var impressions = api
                                                    .column( 1 )
                                                    .data()
                                                    .reduce( function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0 );
                                                    
                                                var clicks = api
                                                    .column( 2 )
                                                    .data()
                                                    .reduce( function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0 );
                                                    
                                                
                                                    
                                                var ctr = api
                                                    .column( 3 )
                                                    .data()
                                                    .reduce( function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0 );
                                                    
                                                
                                                    
                                            // Update footer by showing the total with the reference of the column index 
                                            $( api.column( 0 ).footer() ).html('Total');
                                                $( api.column( 1 ).footer() ).html(impressions);
                                                $( api.column( 2 ).footer() ).html(clicks);
                                                $( api.column( 3 ).footer() ).html(ctr.toFixed(2));
                                            },
                                            initComplete: function(settings) 
											{
											    //settings.nTable.id --> Get table ID
											    $('#'+settings.nTable.id+'_filter input').wrap(`
												    <div class="d-inline-flex position-relative"></div>
											  ` ).after(`
													<button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
													  <span aria-hidden="true">&times;</span>
													</button>
											   `).attr('required','required').attr('title','Search');
                                              
											   // Click Event on Clear button
											    $(document).on('click', '#'+settings.nTable.id+'_filter button', function(){
												 $('#'+settings.nTable.id).DataTable({
												   "retrieve": true,
												  }).search('').draw(); // reDraw table
											    });
											}   
                                            });
                                        }
                                    },
                                    error: function () { },
                                });
                }
                else if(getTypeofreports=='Revive'){
                    $("#daterange").css("display", "none");
                                $.ajax({
                                    url: live_URL + '/get_all_advertiser_campaign_statistics/' + client_id,
                                    type: 'GET',
                                    beforeSend: function (xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: {},
                                    success: function (data) {
                                        console.log("cm data", data);
                                        $(".loader").hide();
                                        if (data.msg == 'No Stats Available') {
                                            $('#camapaignrep').DataTable({
                                            ordering: false,
                                            destroy: true,
                                            responsive: true,
                                            bPaginate: false,
                                            bInfo: false,
                                            data:[],
                                            searching: false,
                                            oLanguage: {
                                                sEmptyTable:"No Data Found"
                                            }
                                        });
                                        }
                                        else {
                                            var revive='revive';
                                            var getCampaign = $("#getCampaign").val();
                                            var cust_startdate= localStorage.getItem("cust_startdate");                                  
                                            var cust_enddate= localStorage.getItem("cust_enddate");
                                        
                                                if(getCampaign=="custom" && cust_startdate!=null && cust_enddate!=null )
                                                {                                                    
                                                    var start_date=cust_startdate;
                                                    var end_date=cust_enddate;
                                                }else{
                                                    var start_date=start_date;
                                                    var end_date=end_date;
                                                }
                                            
                                            $('#camapaignrep').DataTable({
                                                "ordering": true,
                                                "destroy": true,
                                                data: data,
                                                columns: [
                                                    { 'data': null, title: 'Name', wrap: true, "render": function (campaign) { 
														return '<a href="campaign_reportgraph.php?campaignid='+campaign.campaignid+'&campaignname='+campaign.campaignname+'&start_date='+start_date+'&end_date='+end_date+'&params='+revive+'">'+campaign.campaignname+'</a>' } },
                                                    { data: 'impressions', className: "text-center" },
                                                    { data: 'clicks', className: "text-center" },
                                                    // { data: 'conversions', className: "text-center" },
                                                    { data: 'ctr', className: "text-center" },                                          
                                                    /* { data: 'ecpm', className: "text-start", render: function(data, type, row, meta) {
                                                        return row.ecpm == null?"0.0000":row.ecpm;
                                                    } }, */
                                                ],
												footerCallback: function ( row, data, start, end, display ) {
                                                var api = this.api(), data;
                                    
                                                // converting to interger to find total
                                                var intVal = function ( i ) {
                                                    return typeof i === 'string' ?
                                                        i.replace(/[\$,]/g, '')*1 :
                                                        typeof i === 'number' ?
                                                            i : 0;
                                                };
                                    
                                                // computing column Total of the complete result 
                                                var impressions = api
                                                    .column( 1 )
                                                    .data()
                                                    .reduce( function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0 );
                                                    
                                                var clicks = api
                                                    .column( 2 )
                                                    .data()
                                                    .reduce( function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0 );
                                                    
                                                
                                                    
                                                var ctr = api
                                                    .column( 3 )
                                                    .data()
                                                    .reduce( function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0 );
                                                    
                                                
                                                    
                                            // Update footer by showing the total with the reference of the column index 
                                            $( api.column( 0 ).footer() ).html('Total');
                                                $( api.column( 1 ).footer() ).html(impressions);
                                                $( api.column( 2 ).footer() ).html(clicks);
                                                $( api.column( 3 ).footer() ).html(ctr.toFixed(2));
                                            },
                                            initComplete: function(settings) 
											{
											    //settings.nTable.id --> Get table ID
											    $('#'+settings.nTable.id+'_filter input').wrap(`
												    <div class="d-inline-flex position-relative"></div>
											  ` ).after(`
													<button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
													  <span aria-hidden="true">&times;</span>
													</button>
											   `).attr('required','required').attr('title','Search');
                                              
											   // Click Event on Clear button
											    $(document).on('click', '#'+settings.nTable.id+'_filter button', function(){
												 $('#'+settings.nTable.id).DataTable({
												   "retrieve": true,
												  }).search('').draw(); // reDraw table
											    });
											}   
                                            });
                                        }
                                    },
                                    error: function () { },
                                });
                            } 
                            else {
								$("#daterange").css("display", "none");
                                $.ajax({
                                    url: live_URL + '/get_all_website_all_stat_advertiser_campaign__statistics/' + client_id,
                                    type: 'GET',
                                    beforeSend: function (xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: {},
                                    success: function (data) {
                                        console.log("cm data", data);
                                        $(".loader").hide();
                                        if (data.msg == 'No Stats Available') {
                                            $('#camapaignrep').DataTable({
                                            ordering: false,
                                            destroy: true,
                                            responsive: true,
                                            bPaginate: false,
                                            bInfo: false,
                                            data:[],
                                            searching: false,
                                            oLanguage: {
                                                sEmptyTable:"No Data Found"
                                            }
                                        });
                                        }
                                        else {
                                            var all='all';
                                            var getCampaign = $("#getCampaign").val();
                                            var cust_startdate= localStorage.getItem("cust_startdate");                                  
                                            var cust_enddate= localStorage.getItem("cust_enddate");
                                        
                                                if(getCampaign=="custom" && cust_startdate!=null && cust_enddate!=null )
                                                {                                                    
                                                    var start_date=cust_startdate;
                                                    var end_date=cust_enddate;
                                                }else{
                                                    var start_date=start_date;
                                                    var end_date=end_date;
                                                }
                                            
                                            $('#camapaignrep').DataTable({
                                                "ordering": true,
                                                "destroy": true,
                                                data: data,
                                                columns: [
                                                    { 'data': null, title: 'Name', wrap: true, "render": function (campaign) { return '<a href="campaign_reportgraph.php?campaignid='+campaign.campaignid+'&campaignname='+campaign.campaignname+'&start_date='+start_date+'&end_date='+end_date+'&params='+all+'">'+campaign.campaignname+'</a>' } },
                                                    { data: 'impressions', className: "text-center" },
                                                    { data: 'clicks', className: "text-center" },
                                                    // { data: 'conversions', className: "text-center" },
                                                    { data: 'ctr', className: "text-center" },                                          
                                                    /* { data: 'ecpm', className: "text-start", render: function(data, type, row, meta) {
                                                        return row.ecpm == null?"0.0000":row.ecpm;
                                                    } }, */
                                                ],
												footerCallback: function ( row, data, start, end, display ) {
                                                var api = this.api(), data;
                                    
                                                // converting to interger to find total
                                                var intVal = function ( i ) {
                                                    return typeof i === 'string' ?
                                                        i.replace(/[\$,]/g, '')*1 :
                                                        typeof i === 'number' ?
                                                            i : 0;
                                                };
                                    
                                                // computing column Total of the complete result 
                                                var impressions = api
                                                    .column( 1 )
                                                    .data()
                                                    .reduce( function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0 );
                                                    
                                                var clicks = api
                                                    .column( 2 )
                                                    .data()
                                                    .reduce( function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0 );
                                                    
                                                
                                                    
                                                var ctr = api
                                                    .column( 3 )
                                                    .data()
                                                    .reduce( function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0 );
                                                    
                                                
                                                    
                                            // Update footer by showing the total with the reference of the column index 
                                            $( api.column( 0 ).footer() ).html('Total');
                                                $( api.column( 1 ).footer() ).html(impressions);
                                                $( api.column( 2 ).footer() ).html(clicks);
                                                $( api.column( 3 ).footer() ).html(ctr.toFixed(2));
                                            },
                                            initComplete: function(settings) 
											{
											    //settings.nTable.id --> Get table ID
											    $('#'+settings.nTable.id+'_filter input').wrap(`
												    <div class="d-inline-flex position-relative"></div>
											  ` ).after(`
													<button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
													  <span aria-hidden="true">&times;</span>
													</button>
											   `).attr('required','required').attr('title','Search');
                                              
											   // Click Event on Clear button
											    $(document).on('click', '#'+settings.nTable.id+'_filter button', function(){
												 $('#'+settings.nTable.id).DataTable({
												   "retrieve": true,
												  }).search('').draw(); // reDraw table
											    });
											}   
                                            });
                                        }
                                    },
                                    error: function () { },
                                });
							}
                }
                                
                            else if (getSelectedDay == 'custom') {
                                $("#daterange").css("display", "block");
                                $(".loader").hide();setDate
                             
                                // getTypeofreports=='Xandr'?getXandrDate(setDate, setDate):getCampaignDate(setDate, setDate);
                                
                                if(getTypeofreports=='Xandr')
                                {
                                    getXandrDate(setDate, setDate);
                                }
                                else if(getTypeofreports=='Revive')
                                {
                                    getCampaignDate(setDate, setDate);
                                }
                                else 
                                {
									getAllWebsiteDate(setDate, setDate);
								}
                                
                                $(function () {
                                    $('input[name="daterange"]').daterangepicker({
                                        opens: 'left',
                                        locale: {
                                            format: 'DD/MMM/YYYY'
                                        },
                                    }, function (start, end, label) {
                                        var start_date = start.format('YYYY-MM-DD'), end_date = end.format('YYYY-MM-DD');
                                        
                                        var domaintype = $("#getCampaign").val();

                                        localStorage.setItem("cust_startdate", start_date);
                                        localStorage.setItem("cust_enddate", end_date);
                                                        
                                        var getDuration=$("#getDuration").val();
                                        if(getTypeofreports=='Xandr')
                                        {
                                            getXandrDate(start_date, end_date); 
                                        }
                                        else if(getTypeofreports=='Revive')
										{
											getCampaignDate(start_date, end_date);
										}
										else 
										{
											getAllWebsiteDate(start_date, end_date);
										}
                                        
                                    })
                                })
                            }
                        };

                        // onChangeReviveXandr = () => {
                        //     let getSelectedDay = document.getElementById('getCampaign').value;
                        //     // getSelectedDay == "custom"?location.reload():"";
                        // };

                        function getCampaignDate(start_date, end_date) {

                            
                                var cust_startdate= localStorage.getItem("cust_startdate");
                                var cust_enddate= localStorage.getItem("cust_enddate");
                        
                                localStorage.setItem("start_date", start_date);
                                localStorage.setItem("end_date", end_date);

                                var getCampaign = $("#getCampaign").val();                         
                                if(getCampaign=="custom" && cust_startdate!=null && cust_enddate!=null ){
                                    var start_end_date= cust_startdate + ' 00:00:00,' + cust_enddate + ' 23:59:59,'
                                }else{
                                    var start_end_date= start_date + ' 00:00:00,' + end_date + ' 23:59:59,';
                                }


                            $.ajax({
                                url: domain_url + start_end_date + client_id,
                                type: 'GET',
                                beforeSend: function (xhr) {
                                    xhr.setRequestHeader('Authorization', token);
                                },
                                data: {},
                                success: function (data) {
                                    // console.log("data", data);
                                    $(".loader").hide();
                                    if (data.msg == 'No Stats Available') {
                                        $('#camapaignrep').DataTable({
                                            ordering: false,
                                            destroy: true,
                                            responsive: true,
                                            bPaginate: false,
                                            bInfo: false,
                                            data:[],
                                            searching: false,
                                            oLanguage: {
                                                sEmptyTable:     "No Data Found"
                                            }
                                        });
                                    }
                                    else {
                                       var revive="revive";

                                       var getCampaign = $("#getCampaign").val();
                                       var cust_startdate= localStorage.getItem("cust_startdate");                                  
                                        var cust_enddate= localStorage.getItem("cust_enddate");

                                        var start_date= localStorage.getItem("start_date");
                                        var end_date= localStorage.getItem("end_date");
                                 
                                        if(getCampaign=="custom" && cust_startdate!=null && cust_enddate!=null ){                                          
                                            var start_date=cust_startdate;
                                            var end_date=cust_enddate;
                                        }else{
                                            var start_date=start_date;
                                            var end_date=end_date;
                                        }
                                       
                                        $('#camapaignrep').DataTable({
                                            ordering: true,
                                            destroy: true,
                                            // responsive: true,
                                            data: data,
                                            columns: [                                                
                                                { 'data': null, title: 'Name', wrap: true, 
                                                    "render": function (campaign) { 
                                                        return '<a href="campaign_reportgraph.php?campaignid='+campaign.campaignid+'&campaignname='+campaign.campaignname+'">'+campaign.campaignname+'</a>'} },
                                                { data: 'impressions', className: "text-center" },
                                                { data: 'clicks', className: "text-center" },
                                                // { data: 'conversions', className: "text-center" },
                                                { data: 'ctr', className: "text-center" },                                             
                                                /* { data: 'ecpm', className: "text-start", render: function(data, type, row, meta) {
                                                    return row.ecpm == null?"0.0000":row.ecpm;
                                                } }, */
                                            ],
                                            footerCallback: function ( row, data, start, end, display ) {
                                            var api = this.api(), data;
                                
										// converting to interger to find total
										var intVal = function ( i ) {
											return typeof i === 'string' ?
												i.replace(/[\$,]/g, '')*1 :
												typeof i === 'number' ?
													i : 0;
										};
                                
                                        // computing column Total of the complete result 
                                        var impressions = api
                                                .column( 1 )
                                                .data()
                                                .reduce( function (a, b) {
                                                    return intVal(a) + intVal(b);
                                                }, 0 );
                                                
                                        var clicks = api
                                                .column( 2 )
                                                .data()
                                                .reduce( function (a, b) {
                                                    return intVal(a) + intVal(b);
                                                }, 0 );
                                                
                                      
                                                
                                        var ctr = api
                                                .column( 3 )
                                                .data()
                                                .reduce( function (a, b) {
                                                    return intVal(a) + intVal(b);
                                                }, 0 );
                                                
                                      
                                                  
                                        // Update footer by showing the total with the reference of the column index 
                                        $( api.column( 0 ).footer() ).html('Total');
                                            $( api.column( 1 ).footer() ).html(impressions);
                                            $( api.column( 2 ).footer() ).html(clicks);
                                            $( api.column( 3 ).footer() ).html(ctr.toFixed(2));
                                        }, 
                                        initComplete: function(settings) 
											{
											    //settings.nTable.id --> Get table ID
											    $('#'+settings.nTable.id+'_filter input').wrap(`
												    <div class="d-inline-flex position-relative"></div>
											  ` ).after(`
													<button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
													  <span aria-hidden="true">&times;</span>
													</button>
											   `).attr('required','required').attr('title','Search');
                                              
											   // Click Event on Clear button
											    $(document).on('click', '#'+settings.nTable.id+'_filter button', function(){
												 $('#'+settings.nTable.id).DataTable({
												   "retrieve": true,
												  }).search('').draw(); // reDraw table
											    });
											}
                                        });
                                    }
                                },
                                error: function () { },
                            });
                        };

                        function getXandrDate(start_date, end_date) {

                            var getDuration=$("#getDuration").val();
                            var cust_startdate= localStorage.getItem("cust_startdate");
                            var cust_enddate= localStorage.getItem("cust_enddate");

                            localStorage.setItem("start_date", start_date); 
                            localStorage.setItem("end_date", end_date);

                            var getCampaign = $("#getCampaign").val();
                            if(getCampaign=="custom" && cust_startdate!=null && cust_enddate!=null )
                            {                                   
                                var start_end_date= cust_startdate + ' 00:00:00,' + cust_enddate + ' 23:59:59,'
                            }
                            else
                            {
                                var start_end_date= start_date + ' 00:00:00,' + end_date + ' 23:59:59,';
                            }


                            $.ajax({
                                url:  Xandr_url + start_end_date + client_id,
                                type: 'GET',
                                beforeSend: function (xhr) {
                                    xhr.setRequestHeader('Authorization', token);
                                },
                                data: {},
                                success: function (data) {                                   
                                    $(".loader").hide();
                                    if (data.msg == 'No Stats Available') {
                                        $('#camapaignrep').DataTable({
                                            ordering: false,
                                            destroy: true,
                                            responsive: true,
                                            bPaginate: false,
                                            bInfo: false,
                                            data:[],
                                            searching: false,
                                            oLanguage: {
                                                sEmptyTable:     "No Data Found"
                                            }
                                        });
                                    }
                                    else {
                                       var xandr="xandr";                                    
                                       var getCampaign = $("#getCampaign").val();

                                       var cust_startdate= localStorage.getItem("cust_startdate");                                  
                                        var cust_enddate= localStorage.getItem("cust_enddate");
                                        var start_date= localStorage.getItem("start_date");
                                        var end_date= localStorage.getItem("end_date");
                                      
                                        if(getCampaign=="custom" && cust_startdate!=null && cust_enddate!=null ){
                                            var start_date=cust_startdate;
                                            var end_date=cust_enddate;
                                        }
                                        else{
                                            var start_date=start_date;
                                            var end_date=end_date;
                                        }
                                        
                                        $('#camapaignrep').DataTable({
                                            ordering: true,
                                            destroy: true,
                                            // responsive: true,
                                            data: data,
                                            columns: [
                                                { 'data': null, title: 'Name', wrap: true, "render": function (campaign) { 
                                                    return '<a href="campaign_reportgraph.php?campaignid='+campaign.campaignid+'&campaignname='+campaign.campaignname+'">'+campaign.campaignname+'</a>' } },
                                                { data: 'xandr_impressions', className: "text-center" },
                                                { data: 'xandr_clicks', className: "text-center" },
                                                // { data: 'conversions', className: "text-center" },
                                                { data: 'xandr_ctr', className: "text-center" },                                               
                                                /* { data: 'xandr_ecpm', className: "text-start", render: function(data, type, row, meta) {
                                                    return row.ecpm == null?"0.0000":row.ecpm;
                                                } }, */
                                            ],
                                            footerCallback: function ( row, data, start, end, display ) {
                                            var api = this.api(), data;
                                
										// converting to interger to find total
										var intVal = function ( i ) {
											return typeof i === 'string' ?
												i.replace(/[\$,]/g, '')*1 :
												typeof i === 'number' ?
													i : 0;
										};
                                
                                        // computing column Total of the complete result 
                                        var impressions = api
                                                .column( 1 )
                                                .data()
                                                .reduce( function (a, b) {
                                                    return intVal(a) + intVal(b);
                                                }, 0 );
                                                
                                        var clicks = api
                                                .column( 2 )
                                                .data()
                                                .reduce( function (a, b) {
                                                    return intVal(a) + intVal(b);
                                                }, 0 );
                                                
                                                
                                        var ctr = api
                                                .column( 3 )
                                                .data()
                                                .reduce( function (a, b) {
                                                    return intVal(a) + intVal(b);
                                                }, 0 );
                                                
                                                  
                                        // Update footer by showing the total with the reference of the column index 
                                        $( api.column( 0 ).footer() ).html('Total');
                                            $( api.column( 1 ).footer() ).html(impressions);
                                            $( api.column( 2 ).footer() ).html(clicks);
                                            $( api.column( 3 ).footer() ).html(ctr.toFixed(2));
                                        },
                                        initComplete: function(settings) 
											{
											    //settings.nTable.id --> Get table ID
											    $('#'+settings.nTable.id+'_filter input').wrap(`
												    <div class="d-inline-flex position-relative"></div>
											  ` ).after(`
													<button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
													  <span aria-hidden="true">&times;</span>
													</button>
											   `).attr('required','required').attr('title','Search');
                                              
											   // Click Event on Clear button
											    $(document).on('click', '#'+settings.nTable.id+'_filter button', function(){
												 $('#'+settings.nTable.id).DataTable({
												   "retrieve": true,
												  }).search('').draw(); // reDraw table
											    });
											}
                                        });
                                    }
                                },
                                error: function () { },
                            });
                        };
                        
                        function getAllWebsiteDate(start_date, end_date) {

                            var getDuration=$("#getDuration").val();
                            var cust_startdate= localStorage.getItem("cust_startdate");
                            var cust_enddate= localStorage.getItem("cust_enddate");

                            localStorage.setItem("start_date", start_date); 
                            localStorage.setItem("end_date", end_date);

                            var getCampaign = $("#getCampaign").val();
                            if(getCampaign=="custom" && cust_startdate!=null && cust_enddate!=null )
                            {                                   
                                var start_end_date= cust_startdate + ' 00:00:00,' + cust_enddate + ' 23:59:59,'
                            }
                            else
                            {
                                var start_end_date= start_date + ' 00:00:00,' + end_date + ' 23:59:59,';
                            }


                            $.ajax({
                                url:  all_website_url + start_end_date + client_id,
                                type: 'GET',
                                beforeSend: function (xhr) {
                                    xhr.setRequestHeader('Authorization', token);
                                },
                                data: {},
                                success: function (data) {                                   
                                    $(".loader").hide();
                                    if (data.msg == 'No Stats Available') {
                                        $('#camapaignrep').DataTable({
                                            ordering: false,
                                            destroy: true,
                                            responsive: true,
                                            bPaginate: false,
                                            bInfo: false,
                                            data:[],
                                            searching: false,
                                            oLanguage: {
                                                sEmptyTable:     "No Data Found"
                                            }
                                        });
                                    }
                                    else {
                                       var all="all";                                    
                                       var getCampaign = $("#getCampaign").val();

                                       var cust_startdate= localStorage.getItem("cust_startdate");                                  
                                        var cust_enddate= localStorage.getItem("cust_enddate");
                                        var start_date= localStorage.getItem("start_date");
                                        var end_date= localStorage.getItem("end_date");
                                      
                                        if(getCampaign=="custom" && cust_startdate!=null && cust_enddate!=null ){
                                            var start_date=cust_startdate;
                                            var end_date=cust_enddate;
                                        }
                                        else{
                                            var start_date=start_date;
                                            var end_date=end_date;
                                        }
                                        
                                        $('#camapaignrep').DataTable({
                                            ordering: true,
                                            destroy: true,
                                            // responsive: true,
                                            data: data,
                                            columns: [
                                                { 'data': null, title: 'Name', wrap: true, "render": function (campaign) { 
                                                    return '<a href="campaign_reportgraph.php?campaignid='+campaign.campaignid+'&campaignname='+campaign.campaignname+'">'+campaign.campaignname+'</a>' } },
                                                { data: 'impressions', className: "text-center" },
                                                { data: 'clicks', className: "text-center" },
                                                { data: 'ctr', className: "text-center" },                                               
                                                
                                            ],
                                            footerCallback: function ( row, data, start, end, display ) {
                                            var api = this.api(), data;
                                
										// converting to interger to find total
										var intVal = function ( i ) {
											return typeof i === 'string' ?
												i.replace(/[\$,]/g, '')*1 :
												typeof i === 'number' ?
													i : 0;
										};
                                
                                        // computing column Total of the complete result 
                                        var impressions = api
                                                .column( 1 )
                                                .data()
                                                .reduce( function (a, b) {
                                                    return intVal(a) + intVal(b);
                                                }, 0 );
                                                
                                        var clicks = api
                                                .column( 2 )
                                                .data()
                                                .reduce( function (a, b) {
                                                    return intVal(a) + intVal(b);
                                                }, 0 );
                                                
                                                
                                        var ctr = api
                                                .column( 3 )
                                                .data()
                                                .reduce( function (a, b) {
                                                    return intVal(a) + intVal(b);
                                                }, 0 );
                                                
                                                  
                                        // Update footer by showing the total with the reference of the column index 
                                        $( api.column( 0 ).footer() ).html('Total');
                                            $( api.column( 1 ).footer() ).html(impressions);
                                            $( api.column( 2 ).footer() ).html(clicks);
                                            $( api.column( 3 ).footer() ).html(ctr.toFixed(2));
                                        },
                                        initComplete: function(settings) 
											{
											    //settings.nTable.id --> Get table ID
											    $('#'+settings.nTable.id+'_filter input').wrap(`
												    <div class="d-inline-flex position-relative"></div>
											  ` ).after(`
													<button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
													  <span aria-hidden="true">&times;</span>
													</button>
											   `).attr('required','required').attr('title','Search');
                                              
											   // Click Event on Clear button
											    $(document).on('click', '#'+settings.nTable.id+'_filter button', function(){
												 $('#'+settings.nTable.id).DataTable({
												   "retrieve": true,
												  }).search('').draw(); // reDraw table
											    });
											}
                                        });
                                    }
                                },
                                error: function () { },
                            });
                        };
                    </script>

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>
        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
</body>

</html>
