<?php
include('session.php');
include('../config.php');
include('../common.php');

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <!-- <title>Adserver - Campaign </title> -->
    <title><?php echo $projecttitle; ?> - <?php echo $GLOBALS['strInventory_Campaign_List_Head']; ?> </title>

    <meta name="description" content="" />
    <?php include('head.php'); ?>

    <style>
        .swal-button--danger {
            background-color: #2523b3;
        }

        .swal-button--cancel {
            color: white;
            background-color: #ff3e1d;
        }

        .swal-button--cancel:not([disabled]):hover {
            background-color: red;
        }

        .swal-button--danger:not([disabled]):hover {
            background-color: #2523b3;
        }

        .text-hide {
            display: block;
            width: 270px;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
        }

        .text-hide:hover {
            overflow: hidden;
        }

        .card-body {
            padding: 0 !important;
        }

        .statuswidth {
            width: 13%;
        }

        .dataTables_scrollBody {
            height: auto !important;
        }

        .campaign-name {
            display: block;
            height: 20px;
            overflow-y: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
        }

        .text_convert {
            text-transform: capitalize;
        }
    </style>
</head>

<body onload="getCampaignlist()">
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>

            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card mt-5">
                            <div class="card-header">
                                <div class="row">
                                    <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                        <p class="h3 text-center text-sm-center text-md-start text-lg-start text-xl-start text-xxl-start">
                                            <?php echo $GLOBALS['strInventory_Campaign_List_Head']; ?>
                                        </p>
                                    </div>
                                    <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                        <div class="d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                            <button type="button" class="btn btn-primary" style="margin-right: 2%;" id="deleteall">
                                                <a href="#" style="color:white" id="deleteallbtn">
                                                    <i class="bx bx-trash bg-label-white" aria-hidden="true" title="Delete"></i>
                                                    <?php echo $GLOBALS['strInventory_DeleteCampaign']; ?>
                                                </a>
                                            </button>
                                            <button type="button" class="btn btn-primary" onclick="window.location.href='campaign_add.php'">
                                                <a href="campaign_add.php" style="color:white">
                                                    <i class="menu-icon tf-icons bx bx-plus"></i>
                                                    <?php echo $GLOBALS['strInventory_AddCampaign']; ?>
                                                </a>
                                            </button>
                                        </div>
                                        <!-- <span class="rows_selected" id="select_count"></span>style="position:relative;left:50%" -->


                                        <!-- <button type="button" class="btn btn-primary" style="position:relative;left:50%" id="deleteall"><a href="#" style="color:white" id="deleteallbtn"><i class="bx bx-trash bg-label-white"  aria-hidden="true" title="Delete"></i> Delete</a></button> -->

                                    </div>
                                </div>
                                <hr class="solid">
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="mt-2 mb-4 container">
                                        <div class="table-responsive text-nowrap">
                                            <table id="example2" class="table table-striped table-responsive table-hover">
                                                <thead>
                                                    <tr class="text-nowrap">
                                                        <th class="th-color text-center"><input type="checkbox" class="form-check-input" id="select-all"></th>
                                                        <th class="th-color text-center"> <?php echo $GLOBALS['strName']; ?></th>
                                                        <th class="th-color"> <?php echo $GLOBALS['strInventory_Campaign_List_Type']; ?></th>
                                                        <th class="th-color text-center"> <?php echo $GLOBALS['strInventory_Campaign_List_Update']; ?></th>
                                                        <th class="th-color text-center"><?php echo $GLOBALS['strInventory_Campaign_List_Status']; ?></th>
                                                        <th class="th-color"><?php echo $GLOBALS['strInventory_Campaign_List_Action']; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <!-- / Content -->

                    <?php include('footer.php'); ?>
                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper , className: "text-hide" -->

    <script>
        var live_URL = '<?php echo $apiinvenpath; ?>';
        var token = 'Bearer ' + document.getElementById('token').value;
        var client_id = document.getElementById('clientid').value;
        var campaignAllStats_URL = live_URL + '/get_all_campaigns/' + client_id;
        var deleteCampaign = live_URL + '/campaign_delete/';
        var activeDeactive = live_URL + '/campaign_status_update/';
        // $(document).ready(function(){
        //        var checkBox = document.getElementById('checedkrows');
        // // // // Check if the element is selected/checked
        // if(checkBox.checked) {
        // // //  console.log(true);
        // }
        // $(document).ready(function(){
        //     $('#element').is(':checked')
        // });
        function getCampaignlist() {

            $.ajax({
                type: "GET",
                url: campaignAllStats_URL,
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function(data) {
                console.log(data);
                showdata(data);

            });
        }

        function showdata(data) {
            console.log(data);
            if (data.msg == 'No Stats Available') {
                $('#example2').DataTable({
                    ordering: false,
                    destroy: true,
                    responsive: true,
                    bPaginate: false,
                    bAutoWidth: false,
                    bInfo: false,
                    data: [],
                    searching: false,
                    oLanguage: {
                        sEmptyTable: `<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`

                        // sEmptyTable:"No Data Found"
                    }
                });
            } else {
                $(document).ready(function() {
                    var table = $('#example2').DataTable({
                        ordering: true,
                        destroy: true,
                        scrollY: 450,
                        responsive: false,
                        columnDefs: [{
                            orderable: false,
                            className: 'select-checkbox',
                            targets: 0
                        }],
                        data: data.data,
                        columns: [{
                                data: 'campaignid',
                                className: "text-center",
                                render: function(data, type, row, meta) {
                                    return '<input type="checkbox" name="checkrow[]" class="form-check-input chkCountry" id="checedkrows" value="' + row.campaignid + '" data-campaign-id="' + row.campaignid + '">';

                                }
                            },
                            {
                                'data': null,
                                title: 'Name',
                                wrap: true,
                                className: "text-left",
                                "render": function(campaign) {
                                    return '<a href="campaign_edit.php?campaignid=' + campaign.campaignid + '"><div class="campaign-name text-wrap text-break w-100">' + campaign.campaignname + '</div></a>'
                                }
                            },
                            {
                                data: 'priority',
                                className: "text-start text-center",
                                render: function(data, type, row, meta) {
                                    if (row.priority == 0) {
                                        var priority = `<?php echo $GLOBALS['strRemnant']; ?>`;
                                        // var priority='Remenant';
                                    } else if (row.priority == -1) {
                                        var priority = `<?php echo $GLOBALS['strOverride']; ?>`;
                                        // var priority='Override';
                                    } else if (row.priority == 5) {
                                        // var priority='Contract';
                                        var priority = `<?php echo $GLOBALS['strContract']; ?>`;

                                    }
                                    return priority;
                                }
                            },
                            {
                                data: 'updated',
                                className: "text-center"
                            },
                            {
                                data: 'status',
                                className: "statuswidth text-center",
                                render: function(data, type, row, meta) {

                                    if (row.status == 0) {
                                        var status = '<span class="badge bg-success fw-bold w-100 p-2 text_convert">&nbsp; <?php echo $GLOBALS['strInventory_Campaign_List_Active']; ?> &nbsp;</span> &nbsp; <!-- <a href="#"> <i class="fa fa-toggle-on mt-0 " id="activestatus" aria-hidden="true" title=<?php echo $GLOBALS['deactivate']; ?> style="font-size:20px;color:red"  onclick="activeDeactivate(' + row.campaignid + ');"></i></a>-->';
                                    } else if (row.status == 1) {
                                        var status = '<span class="badge bg-info fw-bold w-100 p-2 text_convert">&nbsp; <?php echo $GLOBALS['strInventory_Campaign_List_Paused']; ?> &nbsp;</span>  &nbsp; <!-- <a href="#"> <i class="fa fa-toggle-on mt-0" disabled style="font-size:20px; color:grey"></i></a> -->';
                                    } else if (row.status == 2) {
                                        var status = '<span class="badge bg-warning  fw-bold w-100 p-2 text_convert">&nbsp; <?php echo $GLOBALS['awaiting']; ?> &nbsp;</span> &nbsp; <!-- <a href="#"> <i class="fa fa-toggle-on mt-0" disabled style="font-size:20px; color:grey"></i></a> -->';
                                    } else if (row.status == 3) {
                                        var status = '<span class="badge bg-primary  fw-bold w-100 p-2 text_convert">&nbsp; <?php echo $GLOBALS['strInventory_Campaign_List_Completed']; ?> &nbsp;</span> &nbsp; <!-- <a href="#"> <i class="fa fa-toggle-on mt-0" disabled style="font-size:20px; color:grey"></i></a> -->';
                                    } else if (row.status == 4) {
                                        var status = '<span class="badge bg-danger  fw-bold w-100 p-2 text_convert">&nbsp; <?php echo $GLOBALS['strInventory_Campaign_List_Inactive']; ?>  &nbsp;</span>  &nbsp; <!-- <a href="#"> <i class="fa fa-toggle-on mt-0 " id="activestatus" aria-hidden="true" title=<?php echo $GLOBALS['activate']; ?> style="font-size:20px;color:green"  onclick="activeDeactivate(' + row.campaignid + ');"></i></a>-->';
                                    }
                                    return status;
                                }
                            },
                            {
                                data: 'campaignid',
                                className: "text-center",
                                render: function(data, type, row, meta) {
                                    if (row.status == 4) {
                                        var activestatus = '<a href="#"> <i class="fa fa-toggle-on mt-0" id="activestatus" aria-hidden="true" title=<?php echo $GLOBALS['activate']; ?> style="font-size:20px;color:green"  onclick="activeDeactivate(' + row.campaignid + ');"></i></a>';
                                        // var activestatus = '<a href="#"> <i class="fa fa-toggle-on mt-0" id="activestatus" aria-hidden="true" title="Activate" style="font-size:20px;color:green"  onclick="activeDeactivate('+row.campaignid+');"></i></a>';
                                    } else if (row.status == 1) {
                                        var activestatus = '<a href="#"> <i class="fa fa-toggle-on mt-0" disabled style="font-size:20px; color:grey"></i></a>';
                                    } else if (row.status == 2) {
                                        var activestatus = '<a href="#"> <i class="fa fa-toggle-on mt-0" disabled style="font-size:20px; color:grey"></i></a>';
                                    } else if (row.status == 3) {
                                        var activestatus = '<a href="#"> <i class="fa fa-toggle-on mt-0 " disabled style="font-size:20px;color:grey"></i></a>';
                                    } else if (row.status == 0) {
                                        var activestatus = '<a href="#"> <i class="fa fa-toggle-on mt-0 " id="activestatus" aria-hidden="true" title=<?php echo $GLOBALS['deactivate']; ?> style="font-size:20px;color:red"  onclick="activeDeactivate(' + row.campaignid + ');"></i></a>';

                                        // var activestatus = '<a href="#"> <i class="fa fa-toggle-on mt-0 " id="activestatus" aria-hidden="true" title="Deactivate" style="font-size:20px;color:red"  onclick="activeDeactivate('+row.campaignid+');"></i></a>';
                                    }
                                    // var bannericon = '<a href="bannerlist.php?campaignid='+row.campaignid+'"><i class="bx bx-list-ul   mt-0 text-white" id="activestatus" aria-hidden="true" title="Campaignwise Banner" style="font-size:20px;background-color: #ffab00 !important;"></i></a>';
                                    var bannericon = '<a href="bannerlist.php?campaignid=' + row.campaignid + '"><i class="bx bx-list-ul   mt-0 text-white" id="activestatus" aria-hidden="true" title=<?php echo $GLOBALS['campaign_wise_banner']; ?> style="font-size:20px;background-color: #ffab00 !important;"></i></a>&nbsp;&nbsp;<a title=<?php echo $GLOBALS['linked_zones']; ?> class="btn btn-icon btn-xs btn-primary" href="campaign_linked_zones.php?campaignid=' + row.campaignid + '"><i class="fas fa-link"></i></a>';
                                    return '<div class="row"><div class="col-3"><a class="btn btn-icon btn-xs btn-primary" style="margin-right:6px" href="banner_add.php?campaignid=' + row.campaignid + '&campaign_name=' + row.campaignname + '"><i class="bx bx-plus mt-0 bg-label-dark" title=<?php echo $GLOBALS['add_new_banner']; ?> style="font-size:14px; marginRight:20%"></i></a>&nbsp;<a class="btn btn-icon btn-xs btn-primary" style="margin-right:6px" href="campaign_edit.php?campaignid=' + row.campaignid + '"><i class="bx bx-edit mt-0 label-primary" title=<?php echo $GLOBALS['edit_campaign']; ?> style="font-size:14px"></i></a>&nbsp;' + bannericon + '&nbsp;<a class="btn btn-icon btn-xs btn-danger" style="margin-left:6px" href="#">&nbsp;<i class="bx bx-trash ms-0 label-danger"  onclick="Deletebtn(' + row.campaignid + ')"  title=<?php echo $GLOBALS['delete_campaign']; ?> style="font-size:14px"></i></a></div></div>';

                                    // return '<div class="row"><div class="col-3"><a class="btn btn-icon btn-xs btn-primary" style="margin-right:6px" href="banner_add.php?campaignid='+row.campaignid+'"><i class="bx bx-plus mt-0 bg-label-dark" title="Add New Banner" style="font-size:14px; marginRight:20%"></i></a>&nbsp;<a class="btn btn-icon btn-xs btn-primary" style="margin-right:6px" href="campaign_edit.php?campaignid='+row.campaignid+'"><i class="bx bx-edit mt-0 label-primary" title="Edit Campaign" style="font-size:14px"></i></a>&nbsp;'+bannericon+'&nbsp;<a class="btn btn-icon btn-xs btn-danger" style="margin-left:6px" href="#">&nbsp;<i class="bx bx-trash ms-0 label-danger"  onclick="Deletebtn('+row.campaignid+')"  title="Delete Campaign" style="font-size:14px"></i></a></div></div>';
                                }
                            }
                        ],
                        //             if($('.chkCountry:checked').length > 0){
                        //     $("#deleteall").prop('disabled', false);   
                        // }else{
                        //     $("#deleteall").prop('disabled', true); 
                        // }

                        // if ($('.chkCountry:checked').length == $('.chkCountry').length) {
                        //     $('#select-all').prop('checked', true);               
                        // } else {
                        //     $('#select-all').prop('checked', false);               
                        // }
                        //            { $(document).ready('.chkCountry', function() {		

                        // if($('.chkCountry:checked').length > 0){
                        //     $("#deleteall").prop('disabled', false);   
                        // }else{
                        //     $("#deleteall").prop('disabled', true); 
                        // }

                        // if ($('.chkCountry:checked').length == $('.chkCountry').length) {
                        //     $('#select-all').prop('checked', true);               
                        // } else {
                        //     $('#select-all').prop('checked', false);               
                        // }
                        // // $("#select_count").html($("input.chkCountry:checked").length+" Selected");
                        // });}
                    })
                    //             $(document).on('click', '#select-all', function() { 
                    //     var info = table.page.info();
                    //     console.log(info.page);
                    //     $(".chkCountry").prop("checked", this.checked);
                    //     if($('.chkCountry:checked').length > 0){
                    //         $("#deleteall").prop('disabled', false);   
                    //     }else{
                    //         $("#deleteall").prop('disabled', true); 
                    //     }
                    //     // $("#select_count").html($("input.chkCountry:checked").length+" Selected");
                    // });	
                })

            }
        }

        function activeDeactivate(campaignid) {

            console.log("campaignid", campaignid);
            swal({
                title: `<?php echo $GLOBALS['update_status']; ?>`,

                // title: "Are you sure want to update the status?",
                buttons: true,
                dangerMode: true,
                type: "success"
            }).then(function(isConfirm) {
                if (isConfirm) {
                    $.ajax({
                        type: "POST",
                        url: activeDeactive + campaignid,
                        beforeSend: function(xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        dataType: "json",
                        encode: true,
                    }).done(function(data) {
                        console.log(data.msg);
                        console.log(campaignid);
                        if (data.msg == "Campaign Activated successfully!") {
                            location.reload();
                            // $("#activestatus").css("color", "#696cff");
                        } else {
                            location.reload();
                            // $("#activestatus").css("color", "#777");  
                        }
                    });

                } else {
                    console.log(campaignid);
                }
            });
        }


        function Deletebtn(campaignid) {
            console.log("campaignid", campaignid)

            swal({
                title: `<?php echo $GLOBALS['want_delete']; ?>`,

                // title: "Are you sure want to delete?",
                buttons: true,
                dangerMode: true,
                type: "success"
            }).then(function(isConfirm) {

                if (isConfirm) {
                    $.ajax({
                        type: "DELETE",
                        url: deleteCampaign + campaignid,
                        beforeSend: function(xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        dataType: "json",
                        encode: true,
                    }).done(function(data) {
                        location.reload();
                    });
                    swal(`<?php echo $GLOBALS['campaign_deleted_successfully']; ?>`);

                    // swal("Campaign deleted successfully");
                } else {
                    //swal("Campaign delete failed");
                }
            });

        }



        // function getSelectedCampaign(getCampaignId) {
        //     var checkboxes = document.querySelectorAll('input[type="checkbox"]');
        //     arrayValue.push(getCampaignId);
        //     console.log("cmapign id", arrayValue);
        //     for (var checkbox of checkboxes) {
        //         checkbox.checked = this.checked;
        //         count=count+1;
        //         $("#deleteall").prop('disabled', false); 

        //     }  

        // };



        $("#deleteall").prop('disabled', true);

        // let arrayValue = []; 

        // var arrchecked;

        // function getSelectedCampaign(getCampaignId) {

        //     arrchecked = $('.chkCountry').map(function() {
        //     if(this.checked)
        //         return getCampaignId;
        //     }).get();

        //     var arrunchecked = $('.chkCountry').map(function() {
        //     if(!this.checked)
        //         return getCampaignId;
        //     }).get();

        //     console.log(arrchecked);
        //     console.log(arrunchecked);
        //     console.log("length",arrchecked.length);

        //     if(arrchecked.length > 0){
        //         $("#deleteall").prop('disabled', false);   
        //     }else if($('input[name="checkrow"]:checked').length == 0){
        //         $("#deleteall").prop('disabled', true); 
        //     }

        // }

        // document.getElementById('select-all').onclick = function (e) 
        // {         
        //     var checkboxes = $("input:checkbox[name='checkrow']");
        //         if(document.getElementById('select-all').checked) { 
        //             for (var checkbox of checkboxes) {
        //                 checkbox.checked = this.checked;                        
        //                 $("#deleteall").prop('disabled', false);                                      
        //             }   
        //         } else {
        //             for (var checkbox of checkboxes) {
        //                 checkbox.checked = false;                 
        //                 $("#deleteall").prop('disabled', true);                               
        //             } 
        //         }

        //     // var allVals = [];  
        //     // $(".chkCountry:checked").each(function() {  
        //     //     allVals.push($(this).data('id'));
        //     // }); 
        //     // console.log("allVals", allVals); 



        // }
        //     $('#example2').on( 'page.dt', function () {
        // 	var info = table.page.info();
        // 	var checked = false;
        // 	if(pageChecked[info.page])
        // 	{
        // 	checked = true;
        // 	}
        // 	$('#select-all').prop('checked', checked);
        //   });

        $(document).on('click', '#select-all', function() {
            // var info = table.page.info();
            // console.log(info);
            $(".chkCountry").prop("checked", this.checked);
            if ($('.chkCountry:checked').length > 0) {
                $("#deleteall").prop('disabled', false);
            } else {
                $("#deleteall").prop('disabled', true);
            }
            // $("#select_count").html($("input.chkCountry:checked").length+" Selected");
        });
        $(document).on('click', '.chkCountry', function() {

            if ($('.chkCountry:checked').length > 0) {
                $("#deleteall").prop('disabled', false);
            } else {
                $("#deleteall").prop('disabled', true);
            }

            if ($('.chkCountry:checked').length == $('.chkCountry').length) {
                $('#select-all').prop('checked', true);
            } else {
                $('#select-all').prop('checked', false);
            }
            // $("#select_count").html($("input.chkCountry:checked").length+" Selected");
        });


        document.getElementById('deleteallbtn').onclick = function(e) {

            var campaigndeleteids = [];
            $(".chkCountry:checked").each(function() {
                campaigndeleteids.push($(this).attr('data-campaign-id'));
            });
            if (campaigndeleteids.length <= 0) {
                alert("Please select campaign.");
            }

            console.log(campaigndeleteids);
            swal({
                title: `<?php echo $GLOBALS['want_delete']; ?>`,
                // title: "Are you sure want to delete?",
                buttons: true,
                dangerMode: true,
                type: "success"
            }).then(function(isConfirm) {

                if (isConfirm) {
                    $.ajax({
                        type: "DELETE",
                        url: deleteCampaign + campaigndeleteids,
                        beforeSend: function(xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        dataType: "json",
                        encode: true,
                    }).done(function(data) {
                        location.reload();
                    });
                    swal(`<?php echo $GLOBALS['campaign_deleted_successfully']; ?>`);
                    // swal("Campaign deleted successfully");
                } else {
                    //swal("Campaign delete failed");
                }

            });
        }
    </script>
</body>

</html>