<?php
include('session.php');
include('../config.php');
include('../common.php'); ?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='assets/' data-template="vertical-menu-template-free">

<head>
	<meta charset="utf-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
	<title>Banner | Edit Banner</title>

	<meta name="description" content="" />
	<?php include('head.php'); ?>
	<style>
		.cancel-style {
			color: red !important;
			margin-right: 2%;
		}

		.cancel-style:hover {
			color: #fff !important;
		}

		.loader {
			display: none;
			position: fixed;
			width: 100%;
			height: 100%;
			top: 0;
			left: 0;
			z-index: 999;
			background: rgba(255, 255, 255, 0.8) url("../assets/img/loader.gif") center no-repeat;
		}
	</style>
</head>

<body onload="getBannerData();getAllPackets();">
	<div class="loader"></div>
	<!-- Layout wrapper "-->
	<div class="layout-wrapper layout-content-navbar">
		<div class="layout-container">
			<!-- Menu -->
			<?php include('sidebar.php'); ?>
			<!-- / Menu -->

			<!-- Layout container -->
			<div class="layout-page">
				<!-- Navbar -->
				<?php include('navbar.php'); ?>
				<!-- / Navbar -->

				<!-- Content wrapper -->
				<div class="content-wrapper">
					<input type='hidden' name="bannerid" id="bannerid" value="<?php echo $_GET['bannerid']; ?>" />
					<input type='hidden' name="campaignid" id="campaignid" value="<?php echo $_GET['campaignid']; ?>" />

					<input type='hidden' name="extType" id="extType" value="" />
					<!-- Content -->
					<div class="container">
						<div class="nav-align-top my-4 mx-3">
							<ul class="nav nav-tabs" role="tablist">
								<li class="nav-item">
									<a class="nav-link active" href="#"><?php echo $GLOBALS['strBanner_Edit_Head']; ?></a>
								</li>
								<li class="nav-item">
									<a class="nav-link" href="delivery_options.php?bannerid=<?php echo $_GET['bannerid']; ?>&campaignid=<?php echo $_GET['campaignid']; ?>"><?php echo $GLOBALS['delivery_options']; ?></a>
								</li>
								<li class="nav-item">
									<a class="nav-link" href="linked_zones.php?bannerid=<?php echo $_GET['bannerid']; ?>&campaignid=<?php echo $_GET['campaignid']; ?>"><?php echo $GLOBALS['link_zones']; ?></a>
								</li>
								<li class="nav-item">
									<a class="nav-link" href="banner_advanced.php?bannerid=<?php echo $_GET['bannerid']; ?>&campaignid=<?php echo $_GET['campaignid']; ?>"><?php echo $GLOBALS['advanced']; ?></a>
								</li>
								<li class="nav-item">
									<a class="nav-link" href="banner-secondtag.php?bannerid=<?php echo $_GET['bannerid']; ?>&campaignid=<?php echo $_GET['campaignid']; ?>"><?php echo $GLOBALS['banner_secondtag']; ?></a>
								</li>
							</ul>
							<div class="tab-content">
								<p class="h3 text-secondary mt-4"><?php echo $GLOBALS['strBanner_Edit_Head']; ?></p>
								<form action="" method="POST">
									<!-- campaign name and destination_url -->
									<div class="row mb-2">
										<div class='col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6'>
											<label class="form-label mb-2" style="font-size: 1.4ch;"><?php echo $GLOBALS['campaign_name']; ?></label>
											<input type="text" disabled class="form-control text-dark" id="campaign_name">
											<p id="error_campaignError" style="color:red"></p>
										</div>
										<div class='col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6' id="main_destinationURL">
											<label class="form-label mb-2" style="font-size: 1.4ch;"><?php echo $GLOBALS['strDestination_URL']; ?></label>
											<input type="text" class="form-control text-dark" value="" id="destination_url" name="destination_url" placeholder=<?php echo $GLOBALS['strDestination_URL']; ?> onchange="destinationUrlValidation()" onkeyup="destinationUrlValidation()" />
											<p id="error_destinationURL" style="color:red"></p>
										</div>
									</div>
									<!-- name and banner type -->
									<div class="row">
										<div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
											<label class="form-label" style="font-size: 1.4ch;"><?php echo $GLOBALS['strName']; ?></label>
											<input type="text" class="form-control text-dark" id="name" name="name" placeholder=<?php echo $GLOBALS['strName']; ?> onchange="bannernameval()" onkeyup="bannernameval()">
											<p id="errors" style="color:red"></p>
										</div>
										<div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
											<label class="form-label" style="font-size: 1.4ch;"><?php echo $GLOBALS['strInventory_Campaign_List_Type']; ?></label>
											<select id="banner" disabled name="bannert_type" class="form-select text-dark" onchange="banner_type(this.value);">
												<option value="">Select Banner Type</option>
												<optgroup label="Web">
													<option value="web">Web Banner</option>
												</optgroup>
												<optgroup label="SQL">
													<option value="sql">SQL Banner</option>
												</optgroup>
												<optgroup label="URL">
													<option value="url">URL Banner</option>
												</optgroup>
												<optgroup label=<?php echo $GLOBALS['strHTML']; ?>>
													<option value="bannerTypeHtml:VideoAds:Videoads">Video Ads</option>
													<option value="bannerTypeHtml:oxHtml:genericHtml">Generic HTML Banner</option>
													<option value="bannerTypeHtml:oxHtml:html5">HTML 5 Banner (Zip Package)</option>
													<option value="bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml">Inline Video Ad (Pre/Mid/Post-roll)</option>
													<option value="bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml">Overlay Video Ad</option>
												</optgroup>
												<optgroup label="Text">
													<option value="bannerTypeText:oxText:genericText">Generic TEXT Banner</option>
												</optgroup>
											</select>
											<p id="errors1" style="color:red"></p><br />
										</div>
									</div>
									<!-- package name and banner size -->
									<div class="row mb-4" style="margin-top: -12px;">
										<div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
											<label for="package_size" class="form-label"><?php echo $GLOBALS['package_size']; ?></label>
											<select class="form-select text-dark" id="package_size" onchange="onChangePacket()"></select>
											<p id="error_packageSize" class="text-danger"></p>
										</div>
										<div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6" id="getBannerSize">
											<label class="form-label" style="font-size: 1.4ch;"><?php echo $GLOBALS['strSize']; ?></label>
											<select class="form-select text-dark" name="bannerSize" id="bannerSize" onchange="custom_select(this.value)"></select>
											<p id="errors2" style="color:red"></p>
										</div>
									</div>

									<div class="row">
										<div class="col-3">
											<label for="startDate" class="form-label"><?php echo $GLOBALS['strStartDate']; ?></label>
											<input type="date" class="form-control" id="startDate" onchange="onchangeStartDate()" />
											<p id="error_startDate" class="text-danger"></p>
										</div>
										<div class="col-3">
											<label for="endDate" class="form-label"><?php echo $GLOBALS['strEndDate']; ?></label>
											<input type="date" class="form-control" id="endDate" onchange="onchangeEndDate()" />
											<p id="error_endDate" class="text-danger"></p>
										</div>
										<div class="col-6">
											<div class="col" id="webbanner" style="display:none;">
												<label class="form-label mb-2" style="font-size: 1.4ch;">
													<?php echo $GLOBALS['strUpload_Image']; ?>
												</label>
												<input type="text" class="form-control" disabled id="webBannerImage" name="webBannerImage" />
												<input type="file" name="file" id="change_image" class="my-2" onchange="preview()" />
												<p id="webuploaderrors" style="color:red"></p>
											</div>
											<div class="col" id="sqlbanner" style="display:none;">
												<label class="form-label mb-2" style="font-size: 1.4ch;">
													<?php echo $GLOBALS['strSQL']; ?>
												</label>
												<input type="text" disabled name="sqlban" id="sqlban" class="form-control mb-2" />
												<input type="file" id="sql_image" name="sql_image" onchange="preview()" />
												<p id="sqlerrors" style="color:red"></p>
											</div>
											<div class="col" id="urlbanner" style="display:none;">
												<label class="form-label mb-2" style="font-size: 1.4ch;">
													<?php echo $GLOBALS['strIMAGE_URL']; ?>
												</label>
												<input type="text" name="bannerurl" id="bannerurl" class="form-control text-dark" placeholder=<?php echo $GLOBALS['strIMAGE_URL']; ?> value="" onchange="urlbanner()" onkeyup="urlbanner()" />
												<p id="errors3" style="color:red"></p>
											</div>
											<div class="col" id="textbanner" style="display:none;">
												<label class="form-label mb-2" style="font-size: 1.4ch;">
													<?php echo $GLOBALS['strText']; ?>
												</label>
												<textarea class="form-control text-dark" name="textBanner_text" id="textBanner_text" placeholder=<?php echo $GLOBALS['strText']; ?> onchange='bannertextVal()' onkeyup="bannertextVal()"></textarea>
												<p id="txtBanner_error" style="color:red"></p>
											</div>
											<div class="col" id="htmlbanner" style="display:none;">
												<label class="form-label mb-2" style="font-size: 1.4ch;">
													<?php echo $GLOBALS['strHTML']; ?>
												</label>
												<textarea class="form-control text-dark" name="htmlBanner_html" id="htmlBanner_html" onchange="htmlbannerVal()" onkeyup="htmlbannerVal()" placeholder=<?php echo $GLOBALS['strHTML']; ?>></textarea>
												<p id="htmlBanner_error" style="color:red"></p>
											</div>
											<div class="col" id="html5banner" style="display:none;">
												<label class="form-label mb-2" style="font-size: 1.4ch;">
													<?php echo $GLOBALS['strHTML_5']; ?>
												</label>
												<input type="text" disabled name="html5ban" id="html5ban" class="form-control" />
												<input type="file" name="change_html5banner" id="change_html5banner" class="my-2" onchange="preview()" />
												<p id="html5_bannerError" style="color:red"></p>
												<div style="display:none;" id="html5_tag">
													<iframe id="html5_banner_image" src="" style="width:200px; height:200px;"></iframe>
												</div>
											</div>
										</div>
										<div id="bannerarea" style="display:block;">
											<div class="row">
												<div class="col-6"></div>
												<div class="col-6 mt-1">
													<div id="bannerimage" style="display:none;">
														<div class="col item" style="height: 80px ; width:200px">
															<a href="#">
																<img id="banner_image" class="img-fluid" src="" style="height: 120px ; width:200px">
															</a>
														</div>
													</div>
												</div>
											</div>

											<!------- video ads -->
											<div class="col" id="videoads" style="display:none;">
												<div class="row mb-3">
													<b><?php echo $GLOBALS['create_videoad']; ?></b>
													<hr>
												</div>
												<div class="row mb-3">
													<div class="col-6">
														<label class="form-label mb-2" style="font-size: 1.4ch;">
															<?php echo $GLOBALS['video_type']; ?> * </label>
														<select class="form-select text-dark" id="html_videoads_videotype" name="html_videoads_videotype" onchange="videoads_videotype()" onkeyup="videoads_videotype()">
															<option value="Internal"><?php echo $GLOBALS['video_upload']; ?></option>
															<option value="External"><?php echo $GLOBALS['video_url']; ?></option>
														</select>
													</div>
													<div class="col-6" id="videoads_vidupload" style="display:block;">
														<label id="videoads_viduploadlabel" class="form-label mb-2" style="font-size: 1.4ch;">
															<?php echo $GLOBALS['select_video_upload']; ?>
														</label>
														<input size="26" style="width: 250px" name="rm_video" type="file" id="rm_video1" onchange="preview()" />
														<span id="namespan"></span>
														<p id="error_rm_video" style="color:red;"></p>
													</div>
													<div class="col-6" id="videoads_vidurl" style="display:none;font-size: 1.4ch;">
														<label id="videoads_vidurllabel" class="form-label mb-2" style="font-size: 1.4ch;">
															<?php echo $GLOBALS['select_video_url']; ?>
														</label>
														<input type="url" id="videoadsvideo_url" name="videoadsvideo_url" class="form-control" />
													</div>
												</div>
												<div class="row">
													<div class="col">
														<label class="form-label mb-2" style="font-size: 1.4ch;">
															<?php echo $GLOBALS['extension_type']; ?>
														</label>
														<select id="extension_videoType" name="extension_videoType" class="form-select text-dark">
															<option value="video/mp4"><?php echo $GLOBALS['mp4']; ?></option>
															<option value="video/webm"><?php echo $GLOBALS['webm']; ?></option>
														</select>
													</div>
													<div class="col">
														<video id='video_image' width="200" height="150"></video>
													</div>
													<script src="https://cdn.fluidplayer.com/v3/current/fluidplayer.min.js"></script>
													<script>
														fluidPlayer(
															'video_image', {
																layoutControls: {
																	fillToContainer: true
																}
															}
														);
													</script>
												</div>
												<div class="row">
													<div class="col" id="filename">
														<label class="form-label" style="font-size: 1.4ch;">
															<?php echo $GLOBALS['skip_in_secs']; ?>
														</label>
														<input placeholder="00:00:00" type="text" name="videoads_skipads" id="videoads_skipads" class="form-control" value="" onkeyup="videoads_skipadserrors()" />
														<p id="videoads_skipadserrors" style="color:red;"></p>
													</div>
													<div class="col"></div>
												</div>
												<div class="row">
													<!-- <b>Banner display</b> -->
													<b><?php echo $GLOBALS['banner_display']; ?></b>
													<hr>
													<div class="col-6">
														<label class="form-label" style="font-size: 1.4ch;">
															<?php echo $GLOBALS['width']; ?>
														</label>
														<input type="text" name="videoads_width" id="videoads_width" class="form-control" value="" />
													</div>

													<div class="col-6">
														<label class="form-label" style="font-size: 1.4ch;">
															<?php echo $GLOBALS['height']; ?>
														</label>
														<input type="text" name="videoads_height" id="videoads_height" class="form-control" value="" />
													</div>
												</div>
											</div>

											<div class="col" id="inlinevideoad" style="display:none;">
												<b><?php echo $GLOBALS['strCreate_InlineVideo_Ad']; ?></b>
												<hr>
												<div class="row mb-3">
													<div class="col-6">
														<label class="form-label mb-2" style="font-size: 1.4ch;">
															<?php echo $GLOBALS['strVideo_Delivery_Method']; ?>
														</label>
														<select class="form-select text-dark" id="inlineVideo-deliveryType" name="inlineVideo-deliveryType" onchange="progressivechange(this.value)">
															<option value=""><?php echo $GLOBALS['strSelect_Video_Type']; ?></option>
															<option value="streaming"><?php echo $GLOBALS['strStreaming_RTMP']; ?></option>
															<option value="progressive"><?php echo $GLOBALS['strProgressive_HTTP']; ?></option>
														</select>
														<p id="vediodeliveryerrors" style="color:red;"></p>
													</div>
													<div class="col-6" id="strem" style="display:none;">
														<label class="form-label mb-2" style="font-size: 1.4ch;">
															<?php echo $GLOBALS['strRtmp_Server_URL']; ?>
														</label>
														<input type="text" name="rtmpurl" id="inlineRTMP_serverURL" class="form-control text-dark" value="" onkeyup="inlinertmpurl()" placeholder=<?php echo $GLOBALS['strRtmp_Server_URL']; ?> />
														<p id="rtms_server_url" style="color:red;"></p>
													</div>
													<div class="col-6" id="prgs">
														<label class="form-label mb-2" style="font-size: 1.4ch;">
															<?php echo $GLOBALS['video_url']; ?>
														</label>
														<input type="text" name="inlineProgressive_videoURL" class="form-control text-dark" id="inlineProgressive_videoURL" onchange="inlinevediourl()" onkeyup="inlinevediourl()" placeholder=<?php echo $GLOBALS['video_url']; ?> />
														<p id="video_URLerror" style="color:red;"></p>
													</div>
												</div>
												<div class="row mb-3">
													<div class="col-6" id="filename" style="display:none;">
														<label class="form-label mb-2" style="font-size: 1.4ch;">
															<?php echo $GLOBALS['strVIDEO_FILE_NAME']; ?>
														</label>
														<input type="text" name="inlineStreaming_videoFileName" id="inlineStreaming_videoFileName" class="form-control text-dark" onkeyup="vediouploadval()" placeholder=<?php echo $GLOBALS['strVIDEO_FILE_NAME']; ?> />
														<p id="vediourlerrors" style="color:red;"></p>
													</div>
													<div class="col-6">
														<label class="form-label mb-2" style="font-size: 1.4ch;">
															<?php echo $GLOBALS['strVIDEO TYPE']; ?>
														</label>
														<select id="inlineVideo_type" name="inlineVideo_type" class="form-select text-dark" onchange="vediofiletypeval()">
															<option selected value=""><?php echo $GLOBALS['strSelect_Video_Type']; ?></option>
															<option value="video/x-mp4"><?php echo $GLOBALS['strMP4']; ?></option>
														</select>
														<p id="vediofiletypeerrors" style="color:red;"></p>
													</div>
												</div>
												<div class="row mb-3">
													<div class="col-6">
														<label class="form-label mb-2" style="font-size: 1.4ch;">
															<?php echo $GLOBALS['video_duration_in_seconds']; ?>
														</label>
														<input type="text" name="inline_videoDuration" id="inline_videoDuration" class="form-control text-dark" value="" onkeyup="vediodurationval()" placeholder=<?php echo $GLOBALS['video_duration_in_seconds']; ?> />
														<p id="vediodurationerrors" style="color:red;"></p>
													</div>
												</div>
												<div class="row mb-3" id="companion">
													<div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
														<label class="form-label" style="font-size: 1.4ch;">
															<?php echo $GLOBALS['companion_banner']; ?>
														</label>
														<select id="inline_companion_banner" name="inline_companion_banner" class="form-select text-dark"></select>
													</div>
													<div class="col col-xs-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6"></div>
												</div>
											</div>
											<div class="col" id="overlayvideoad" style="display:none;">
												<div class="row mb-3">
													<div class="col-6">
														<div>
															<label class="form-label"><?php echo $GLOBALS['strOverlay_Type']; ?></label>
															<select class="form-select text-dark" id="overlayType" name="overlayType" onchange="overlayad(this.value)">
																<option value="" selected><?php echo $GLOBALS['strSelect_Overlay_Type']; ?></option>
																<option value="image_overlay"><?php echo $GLOBALS['strImage_Overlay']; ?></option>
																<option value="text_overlay"><?php echo $GLOBALS['strText_Overlay']; ?></option>
																<option value="html_overlay"><?php echo $GLOBALS['strHTML_Overlay']; ?></option>
															</select>
															<p id="error_overlayType" style="color:red;"></p>
														</div>
														<div class="col" id="imageoverlay" style="display:none;">
															<b><?php echo $GLOBALS['overlay_image']; ?></b>
															<hr>
															<label class="form-label mb-2" style="font-size: 1.4ch;">
																<?php echo $GLOBALS['upload_overlay_image']; ?>
															</label>
															<input type="text" disabled class="form-control" id="overlay_imageName" name="overlay_imageName" />
															<input type="file" class="mt-2" id="overlay_imageUpload" name="overlay_imageUpload" onchange="overlayImage()" />
															<div id="overlay_image" style="display:none;">
																<div class="col item" style="height: 80px ; width:200px">
																	<a href="#">
																		<img id="overlay_imagePreview" name="overlay_imagePreview" class="img-fluid" src="" style="height: 120px ; width:200px">
																	</a>
																</div>
															</div>
														</div>
														<div class="col" id="textoverlay" style="display:none;">
															<b><?php echo $GLOBALS['overlay_text']; ?></b>
															<hr>
															<div class="mb-3">
																<label class="form-label mb-2" style="font-size: 1.4ch;">
																	<?php echo $GLOBALS['title']; ?>
																</label>
																<input type="text" class="form-control text-dark" name="title" id="title" placeholder=<?php echo $GLOBALS['title']; ?> />
															</div>
															<div class="mb-3">
																<label class="form-label mb-2" style="font-size: 1.4ch;">
																	<?php echo $GLOBALS['strInventory_Description']; ?>
																</label>
																<textarea type="text" class="form-control text-dark" name="description" id="description" placeholder=<?php echo $GLOBALS['strInventory_Description']; ?>></textarea>
															</div>
															<div class="mb-3">
																<label class="form-label mb-2" style="font-size: 1.4ch;">
																	<?php echo $GLOBALS['call_to_action']; ?>
																</label>
																<input type="text" class="form-control text-dark" name="calltoaction" id="calltoaction" placeholder=<?php echo $GLOBALS['call_to_action']; ?> />
															</div>
														</div>
														<div class="col mt-2" id="htmloverlay" style="display:none;">
															<b><?php echo $GLOBALS['overlay_html']; ?></b>
															<hr>
															<b><?php echo $GLOBALS['overlay_html_label']; ?></b>
															<textarea type="text" class="form-control" name="overlayhtml" id="overlayhtml" placeholder=<?php echo $GLOBALS['overlay_html_label']; ?>></textarea>
														</div>
													</div>
													<div class="col-6">
														<div class="col">
															<label class="form-label mb-2" style="font-size: 1.4ch;">
																<?php echo $GLOBALS['strOverlay_Click_Action']; ?>
															</label>
															<select class="form-select text-dark" name="overlayClick_action" id="overlayClick_action" onchange="overlayclick(this.value)">
																<option value="" selected><?php echo $GLOBALS['strSelect_Overlay_Action']; ?></option>
																<option value="click_to_page"><?php echo $GLOBALS['strOpen_page_window']; ?></option>
																<option value="click_to_video"><?php echo $GLOBALS['strPlay_Video']; ?></option>
															</select>
															<p id="overlayclick_error" style="color:red;"></p>
														</div>
														<div class="col" id="overlayclickpage" style="display:none;">
															<b><?php echo $GLOBALS['strWhen_user_clicks_overlay']; ?></b>
															<hr>
															<label class="form-label mb-2"><?php echo $GLOBALS['strDestination_URL']; ?></label>
															<input type="text" name="overlay_destinationURL" id="overlay_destinationURL" class="form-control text-dark" value="" onkeyup="inlineDestinationUrlValidation()" placeholder=<?php echo $GLOBALS['strDestination_URL']; ?> />
															<p id="error_inlineDestinationURL" style="color:red"></p>
														</div>
														<div class="col" id="overlayclickaction" style="display:none;">
															<b><?php echo $GLOBALS['overlay_click_action']; ?></b>
															<hr>
															<div class="mb-3">
																<label class="form-label mb-2" style="font-size: 1.4ch;">
																	<?php echo $GLOBALS['strVideo_Delivery_Method']; ?>
																</label>
																<select class="form-select text-dark" id="vast_video_delivery" name="vast_video_delivery" onchange="overlayprogressivechange(this.value)">
																	<option value="" selected><?php echo $GLOBALS['overlay_video_delivery']; ?></option>
																	<option value="streaming"><?php echo $GLOBALS['strStreaming_RTMP']; ?></option>
																	<option value="progressive"><?php echo $GLOBALS['strProgressive_HTTP']; ?></option>
																</select>
																<p id="overlaydeliverymethod" style="color:red;"></p>
															</div>
															<div class="col" id="overlaystrem" style="display:block;">
																<label class="form-label mb-2" style="font-size: 1.4ch;">
																	<?php echo $GLOBALS['strRtmp_Server_URL']; ?>
																</label>
																<input type="text" name="rtmpurl" id="url" class="form-control" value="" onkeyup="overlayrtmserverurl()" placeholder=<?php echo $GLOBALS['strRtmp_Server_URL']; ?> />
																<p id="overlayrtmerrors" style="color:red;"></p>
															</div>
															<div class="col mb-2" id="overlayprgs" style="display:none;">
																<label class="form-label mb-2" style="font-size: 1.4ch;">
																	<?php echo $GLOBALS['video_url']; ?>
																</label>
																<input type="text" name="progressive_videoURL" id="progressive_videoURL" class="form-control text-dark" onkeyup="overlayvediourl()" placeholder=<?php echo $GLOBALS['video_url']; ?> />
																<p id="overlayvedioerrors" style="color:red;"></p>
															</div>
															<div class="col" id="filenameoverlay">
																<label class="form-label mb-2" style="font-size: 1.4ch;">
																	<?php echo $GLOBALS['strVIDEO_FILE_NAME']; ?>
																</label>
																<input type="text" name="videofile" id="videofile" class="form-control text-dark" value="" placeholder=<?php echo $GLOBALS['strVIDEO_FILE_NAME']; ?> />
																<p id="error_overlay_fileName" style="color:red;"></p>
															</div>
															<div>
																<label class="form-label mb-2" style="font-size: 1.4ch;">
																	<?php echo $GLOBALS['strVIDEO TYPE']; ?>
																</label>
																<select id="video_type" name="video_type" class="form-select text-dark" onchange="overlay_vediotype()">
																	<option selected value=""><?php echo $GLOBALS['strSelect_Video_Type']; ?></option>
																	<option value="MP4"><?php echo $GLOBALS['strMP4']; ?></option>
																	<!-- <option value="FLV">FLV</option>
														                	<option value="WEBM">WEBM</option> -->
																</select>
																<p id="overlayvediofiletype" style="color:red;"></p>
															</div>
															<div>
																<label class="form-label mb-2" style="font-size: 1.4ch;">
																	<?php echo $GLOBALS['video_duration_in_seconds']; ?>
																</label>
																<input type="text" name="videoduration" id="videoduration" class="form-control text-dark" value="" onkeyup="overlay_vedioduration()" placeholder=<?php echo $GLOBALS['video_duration_in_seconds']; ?> />
																<p id="overlayvediodurationerrors" style="color:red;"></p>
															</div>
														</div>
														<div>
															<label class="form-label" style="font-size: 1.4ch;">
																<?php echo $GLOBALS['companion_banner']; ?>
															</label>
															<select id="overlay_companion_banner" name="overlay_companion_banner" class="form-select text-dark"></select>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
									<div class="row mb-4">
										<div class="col">
											<div class="form-check">
												<input class="form-check-input" type="checkbox" value="" id="flexCheckDefault" onclick="onChangeXandr()">
												<label class="form-check-label text-dark" for="flexCheckDefault">
													<?php echo $GLOBALS['strXandr']; ?>
												</label>
											</div>
											<p class="text-danger" id="error_xandr"></p>
										</div>
										<div class="col"></div>
									</div>
									<div class="row">
										<div class="col">
											<label class="form-label" style="font-size: 1.4ch;"><?php echo $GLOBALS['Salesperson']; ?></label>
											<input type="text" class="form-control text-dark" id="salespersonname" name="salespersonname" placeholder="<?php echo $GLOBALS['Salesperson']; ?>" onchange="salespersonval()" onkeyup="salespersonval()">
											<p id="error_salesperson" style="color:red"></p>
										</div>
										<div class="col"></div>
									</div>
									<div class="d-flex justify-content-end">
										<a href="bannerlist.php" class="btn btn-outline-danger cancel-style"><?php echo $GLOBALS['strCancel']; ?></a>
										<a class="btn btn-primary text-white" id="submit" onclick="bannerSubmit()"><?php echo $GLOBALS['strUpdate']; ?></a>
									</div>
								</form>
								<!-- </div> -->
							</div>
						</div>
						<!-- / Content -->

						<!-- Footer -->
						<?php include('footer.php'); ?>
						<!-- / Footer -->
						<div class="content-backdrop fade"></div>
					</div>
					<!-- Content wrapper -->
				</div>
				<!-- / Layout page -->
			</div>

			<script>
				const live_URL = '<?php echo $apiinvenpath; ?>';
				// let image_path = '<?php echo $bannerpath; ?>';
				const token = 'Bearer ' + document.getElementById('token').value;
				let getBanner_id = document.getElementById('bannerid').value;
				let passImageValue, defaultWidth, defaultHeight, fileWidth, fileHeight, getBannerWidth,
					getBannerHeight, imageFormat, image_path, selectXander = '',
					campaign_startDate, campaign_endDate, startError = false,
					endError = false;
				let pattern = new RegExp(
					'^(https?:\\/\\/)?' + // protocol
					'((([a-z\\d]([a-z\\d-]*[a-z\\d])*)\\.)+[a-z]{2,}|' + // domain name
					'((\\d{1,3}\\.){3}\\d{1,3}))' + // OR ip (v4) address
					'(\\:\\d+)?(\\/[-a-z\\d%_.~+]*)*' + // port and path
					'(\\?[;&a-z\\d%_.~+=-]*)?' + // query string
					'(\\#[-a-z\\d_]*)?$', // fragment locator
					'i'
				);
				let client_id = document.getElementById('clientid').value;

				const sizeArray = [{
						id: 0,
						key: "Select Size",
						value: ""
					},
					// {
					// 	id: 1,
					// 	key: "IAB Full Banner (468 x 60)",
					// 	value: "468x60"
					// },
					// {
					// 	id: 2,
					// 	key: "IAB Skyscraper (120 x 600)",
					// 	value: "120x600"
					// },
					// {
					// 	id: 3,
					// 	key: "IAB Leaderboard (728 x 90)",
					// 	value: "728x90"
					// },
					// {
					// 	id: 4,
					// 	key: "IAB Button 1 (120 x 90)",
					// 	value: "120x90"
					// },
					// {
					// 	id: 5,
					// 	key: "IAB Button 2 (120 x 60)",
					// 	value: "120x60"
					// },
					// {
					// 	id: 6,
					// 	key: "IAB Micro Bar (88 x 31)",
					// 	value: "88x31"
					// },
					// {
					// 	id: 7,
					// 	key: "IAB Square Button (125 x 125)",
					// 	value: "125x125"
					// },
					// {
					// 	id: 8,
					// 	key: "IAB Vertical Banner (120 x 240)",
					// 	value: "120x240"
					// },
					// {
					// 	id: 9,
					// 	key: "IAB Rectangle (180 x 150)",
					// 	value: "180x150"
					// },
					{
						key: "300 x 250",
						value: "300x250"
					},
					{
						key: "300 x 600",
						value: '300x600'
					},
					{
						key: "994 x 250",
						value: "994x250"
					},
					// {
					// 	id: 11,
					// 	key: "IAB Large Rectangle (336 x 280)",
					// 	value: "336x280"
					// },
					// {
					// 	id: 12,
					// 	key: "IAB Vertical Rectangle (240 x 400)",
					// 	value: "240x400"
					// },
					// {
					// 	id: 13,
					// 	key: "IAB Square Pop-up (250 x 250)",
					// 	value: "250x250"
					// },
					// {
					// 	id: 14,
					// 	key: "IAB Wide Skyscraper (160 x 600)",
					// 	value: "160x600"
					// },
					// {
					// 	id: 15,
					// 	key: "IAB Pop-Under (720 x 300)",
					// 	value: "720x300"
					// },
					// {
					// 	id: 16,
					// 	key: "IAB 3:1 Rectangle (300 x 100)",
					// 	value: "300x100"
					// },
					// {
					// 	id: 17,
					// 	key: "Custom",
					// 	value: "-"
					// }
				];

				let viewArray = sizeArray.map((data, index) => {
					return `<option key=${index} value=${data.value}>${data.key}</option>`;
				});
				document.getElementById('bannerSize').innerHTML = viewArray;

				getBannerData = () => {
					$(".loader").show();
					$.ajax({
						url: live_URL + '/get_banner/' + getBanner_id,
						type: "GET",
						beforeSend: function(xhr) {
							xhr.setRequestHeader('Authorization', token);
						},
						data: {},
						dataType: "json",
						encode: true,
					}).done(function(data) {
						$(".loader").hide();


						console.log("banner get data", data.data.width);
						console.log("data...", data.data);
						let serializedData = data.data.parameters;

						document.getElementById("videoads_width").value = data.data.width;
						document.getElementById("videoads_height").value = data.data.height;
						if (serializedData != "N;" && serializedData != null) {
							const PHP = {
								stdClass: function() {},
								stringify(val) {
									const hash = new Map([
										[Infinity, "d:INF;"],
										[-Infinity, "d:-INF;"],
										[NaN, "d:NAN;"],
										[null, "N;"],
										[undefined, "N;"]
									]);
									const utf8length = str => str ? encodeURI(str).match(/(%.)?./g).length : 0;
									const serializeString = (s, delim = '"') => `${utf8length(s)}:${delim[0]}${s}${delim[delim.length-1]}`;
									let ref = 0;

									function serialize(val, canReference = true) {
										if (hash.has(val)) return hash.get(val);
										ref += canReference;
										if (typeof val === "string") return `s:${serializeString(val)};`;
										if (typeof val === "number") return `${Math.round(val) === val ? "i" : "d"}:${(""+val).toUpperCase().replace(/(-?\d)E/, "$1.0E")};`;
										if (typeof val === "boolean") return `b:${+val};`;
										const a = Array.isArray(val) || val.constructor === Object;
										hash.set(val, `${"rR"[+a]}:${ref};`);
										if (typeof val.serialize === "function") {
											return `C:${serializeString(val.constructor.name)}:${serializeString(val.serialize(), "{}")}`;
										}
										const vals = Object.entries(val).filter(([k, v]) => typeof v !== "function");
										return (a ? "a" : `O:${serializeString(val.constructor.name)}`) +
											`:${vals.length}:{${vals.map(([k, v]) => serialize(a && /^\d{1,16}$/.test(k) ? +k : k, false) + serialize(v)).join("")}}`;
									}
									return serialize(val);
								},
								// Provide in second argument the classes that may be instantiated
								parse(str, allowedClasses = {}) {
									allowedClasses.stdClass = PHP.stdClass; // Always allowed.
									let offset = 0;
									const values = [null];
									const specialNums = {
										"INF": Infinity,
										"-INF": -Infinity,
										"NAN": NaN
									};
									const kick = (msg, i = offset) => {
										throw new Error(`Error at ${i}: ${msg}\n${str}\n${" ".repeat(i)}^`)
									}
									const read = (expected, ret) => expected === str.slice(offset, offset += expected.length) ? ret :
										kick(`Expected '${expected}'`, offset - expected.length);

									function readMatch(regex, msg, terminator = ";") {
										read(":");
										const match = regex.exec(str.slice(offset));
										if (!match) kick(`Exected ${msg}, but got '${str.slice(offset).match(/^[:;{}]|[^:;{}]*/)[0]}'`);
										offset += match[0].length;
										return read(terminator, match[0]);
									}

									function readUtf8chars(numUtf8Bytes, terminator = "") {
										const i = offset;
										while (numUtf8Bytes > 0) {
											const code = str.charCodeAt(offset++);
											numUtf8Bytes -= code < 0x80 ? 1 : code < 0x800 || code >> 11 === 0x1B ? 2 : 3;
										}
										return numUtf8Bytes ? kick("Invalid string length", i - 2) : read(terminator, str.slice(i, offset));
									}

									const create = className => !className ? {} :
										allowedClasses[className] ? Object.create(allowedClasses[className].prototype) :
										new {
											[className]: function() {}
										} [className]; // Create a mock class for this name
									const readBoolean = () => readMatch(/^[01]/, "a '0' or '1'", ";");
									const readInt = () => +readMatch(/^-?\d+/, "an integer", ";");
									const readUInt = terminator => +readMatch(/^\d+/, "an unsigned integer", terminator);
									const readString = (terminator = "") => readUtf8chars(readUInt(':"'), '"' + terminator);

									function readDecimal() {
										const num = readMatch(/^-?(\d+(\.\d+)?(E[+-]\d+)?|INF)|NAN/, "a decimal number", ";");
										return num in specialNums ? specialNums[num] : +num;
									}

									function readKey() {
										const typ = str[offset++];
										return typ === "s" ? readString(";") :
											typ === "i" ? readUInt(";") :
											kick("Expected 's' or 'i' as type for a key, but got ${str[offset-1]}", offset - 1);
									}

									function readObject(obj) {
										for (let i = 0, length = readUInt(":{"); i < length; i++) obj[readKey()] = readValue();
										return read("}", obj);
									}

									function readArray() {
										const obj = readObject({});
										return Object.keys(obj).some((key, i) => key != i) ? obj : Object.values(obj);
									}

									function readCustomObject(obj) {
										if (typeof obj.unserialize !== "function") kick(`Instance of ${obj.constructor.name} does not have an "unserialize" method`);
										obj.unserialize(readUtf8chars(readUInt(":{")));
										return read("}", obj);
									}

									function readValue() {
										const typ = str[offset++].toLowerCase();
										const ref = values.push(null) - 1;
										const val = typ === "n" ? read(";", null) :
											typ === "s" ? readString(";") :
											typ === "b" ? readBoolean() :
											typ === "i" ? readInt() :
											typ === "d" ? readDecimal() :
											typ === "a" ? readArray() // Associative array
											:
											typ === "o" ? readObject(create(readString())) // Object
											:
											typ === "c" ? readCustomObject(create(readString())) // Custom serialized object
											:
											typ === "r" ? values[readInt()] // Backreference
											:
											kick(`Unexpected type ${typ}`, offset - 1);
										if (typ !== "r") values[ref] = val;
										return val;
									}

									const val = readValue();
									if (offset !== str.length) kick("Unexpected trailing character");
									return val;
								}
							}
							var unserializeddata = PHP.parse(serializedData);


							document.getElementById('html_videoads_videotype').value = unserializeddata.vid_upload_type;
							var select = document.getElementById('html_videoads_videotype').value;

							if (unserializeddata.vid_upload_type == "External") {
								document.getElementById("videoads_vidurl").style.display = "block";
								document.getElementById("videoadsvideo_url").style.display = "block";
								document.getElementById("videoads_vidurllabel").style.display = "block";

								document.getElementById("videoads_vidupload").style.display = "none";
								document.getElementById("rm_video1").style.display = "none";
								document.getElementById("videoads_viduploadlabel").style.display = "none";

								document.getElementById("videoadsvideo_url").value = unserializeddata.video_url;
								document.getElementById("video_image").src = unserializeddata.video_url;

								// document.getElementById("video_image").src =  'https://content.jwplatform.com/manifests/yp34SRmf.m3u8';
								// <source src="https://content.jwplatform.com/manifests/yp34SRmf.m3u8" type='application/x-mpegURL'/>

							} else if (unserializeddata.vid_upload_type == "Internal") {
								document.getElementById("videoads_vidurl").style.display = "none";
								document.getElementById("videoadsvideo_url").style.display = "none";
								document.getElementById("videoads_vidurllabel").style.display = "none";

								document.getElementById("videoads_vidupload").style.display = "block";
								document.getElementById("rm_video1").style.display = "block";
								document.getElementById("videoads_viduploadlabel").style.display = "block";
								document.getElementById("namespan").textContent = unserializeddata.rm_video_filename;
								document.getElementById("video_image").src = data.data.imagepath + "/" + unserializeddata.rm_video_filename;
							}
							document.getElementById('extension_videoType').value = unserializeddata.extension_type;
							document.getElementById("videoads_skipads").value = unserializeddata.skip;
						}

						let size = data.data.width + "x" + data.data.height;
						let ext_type = data.data.ext_bannertype;
						getBannerWidth = data.data.width;
						getBannerHeight = data.data.height;
						defaultWidth = data.data.width;
						defaultHeight = data.data.height;
						imageFormat = data.data.contenttype;
						fileWidth = data.data.fileoriginalwidth;
						fileHeight = data.data.fileoriginalheight;
						image_path = data.data.imagepath;
						campaign_startDate = data.data.activate_time;
						campaign_endDate = data.data.expire_time;
						console.log("campaign_startDate12:", campaign_startDate, "campaign_endDate12:", campaign_endDate);

						document.getElementById('name').value = data.data.description;
						document.getElementById('destination_url').value = data.data.url;
						document.getElementById('campaign_name').value = data.data.campaignname;
						document.getElementById('salespersonname').value = data.data.salespersonname;
						document.getElementById('flexCheckDefault').checked = data.data.xandr == 2 ? true : false;
						document.getElementById('startDate').value = data.data.start;
						document.getElementById('endDate').value = data.data.end;
						//web
						document.getElementById('webBannerImage').value = data.data.filename;
						//sql
						document.getElementById('sqlban').value = data.data.filename;
						// document.getElementById("html5_tag").style.display = "block";


						if (data.data.ext_bannertype != 'url') {
							document.getElementById("banner_image").src = data.data.imageurl;
						}
						// else if(data.data.ext_bannertype == 'bannerTypeHtml:oxHtml:html5') {
						// 	document.getElementById("html5_banner_image").src = "https://"+data.data.imageurl;
						// }
						else {
							document.getElementById("banner_image").src = data.data.imageurl;
							document.getElementById("bannerimage").style.display = "block";
							// document.getElementById("html5_tag").style.display = "none";
						}
						//HTML5 Image Preview
						let image_url = data.data.imageurl;
						document.getElementById("html5_tag").style.display = data.data.ext_bannertype == 'bannerTypeHtml:oxHtml:html5' ? "block" : "";
						document.getElementById("html5_banner_image").src = data.data.ext_bannertype == 'bannerTypeHtml:oxHtml:html5' ? image_url : "";

						document.getElementById("overlay_imagePreview").src = data.data.imageurl;
						document.getElementById('banner').value = data.data.ext_bannertype;

						document.getElementById('textBanner_text').value = data.data.bannertext;
						document.getElementById('bannerurl').value = data.data.imageurl;
						document.getElementById('bannerSize').value = size;
						document.getElementById('extType').value = data.data.ext_bannertype;
						if (size !== document.getElementById('bannerSize').value) {
							document.getElementById('bannerSize').value = "-";
							// document.getElementById('width').value = data.data.width <= 0 ? "0" : data.data.width;
							// document.getElementById('height').value = data.data.height <= 0 ? "0" : data.data.height;
							if (data.data.ext_bannertype == "bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml" ||
								data.data.ext_bannertype == "bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml" ||
								data.data.ext_bannertype == "bannerTypeText:oxText:genericText") {
								console.log("size not have");
							} else {
								custom_select();
								// cus="-"
							}
						}
						document.getElementById('htmlBanner_html').value = data.data.htmltemplate;
						if (data.data.ext_bannertype == "bannerTypeHtml:oxHtml:html5") {
							document.getElementById('html5ban').value = data.data.filename;
						}
						document.getElementById('bannerimage').src = data.data.filename;

						if (data.data.ext_bannertype == "bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml" ||
							data.data.ext_bannertype == "bannerTypeHtml:oxHtml:html5") {
							passImageValue = data.data.filename == "" ? data.data.imagepath + '/' + data.data.filename : data.data.filename;
						} else {
							passImageValue = data.data.imagepath + '/' + data.data.filename;
						}
						banner_type(data.data.ext_bannertype);

						//inline
						document.getElementById('inlineVideo-deliveryType').value = data.data.vast_video_delivery;
						progressivechange(data.data.vast_video_delivery);
						document.getElementById('inlineStreaming_videoFileName').value = data.data.vast_video_outgoing_filename;
						document.getElementById('inline_videoDuration').value = data.data.vast_video_duration;
						document.getElementById('inlineVideo_type').value = data.data.vast_video_type;
						document.getElementById('inlineRTMP_serverURL').value = data.data.vast_video_clickthrough_url;
						document.getElementById('inlineProgressive_videoURL').value = data.data.vast_video_clickthrough_url;

						//overlay
						document.getElementById('overlayType').value = data.data.vast_overlay_format;
						overlayad(data.data.vast_overlay_format);
						document.getElementById('overlayClick_action').value = data.data.vast_overlay_action;
						overlayclick(data.data.vast_overlay_action);
						document.getElementById('vast_video_delivery').value = data.data.vast_video_delivery;
						overlayprogressivechange(data.data.vast_video_delivery);
						document.getElementById('url').value = data.data.vast_video_clickthrough_url;
						document.getElementById("overlay_destinationURL").value = data.data.url;
						document.getElementById('videofile').value = data.data.vast_video_outgoing_filename;
						document.getElementById('video_type').value = data.data.vast_video_type;
						document.getElementById('videoduration').value = data.data.vast_video_duration;
						//companion banner
						getCompanionBanner(data.data.campaignid, data.data.vast_companion_banner_id);
						//overlay-html
						document.getElementById('overlayhtml').value = data.data.htmltemplate;
						//overlay-text
						document.getElementById('title').value = data.data.vast_overlay_text_title;
						document.getElementById('description').value = data.data.vast_overlay_text_description;
						document.getElementById('calltoaction').value = data.data.vast_overlay_text_call;
						document.getElementById('progressive_videoURL').value = data.data.vast_video_clickthrough_url
						//overlay-image 
						document.getElementById('overlay_imageName').value = data.data.filename;
						if (data.data.vast_overlay_format == "image_overlay") {
							document.getElementById('overlay_image').src = data.data.imagepath + data.data.filename;
							document.getElementById("overlay_image").style.display = "block";
							document.getElementById("bannerimage").style.display = "none";
							document.getElementById("overlay_image").style.marginTop = "4%";
						} else if (data.data.vast_overlay_format == "text_overlay" || data.data.vast_overlay_format == "html_overlay") {
							document.getElementById("overlay_image").style.display = "none";
							document.getElementById("bannerimage").style.display = "none";
						}
						getAllPackets(data.data.packetid);
					});
				};

				getAllPackets = (packageData) => {
					console.log("packageData", packageData);
					$.ajax({
						url: live_URL + '/get_all_packets/' + client_id,
						type: "GET",
						beforeSend: function(xhr) {
							xhr.setRequestHeader('Authorization', token);
						},
						data: {},
						dataType: "json",
						encode: true,
					}).done(function(data) {
						let selectPacket = `<option value="" selected><?php echo $GLOBALS['select_package']; ?></option>`;
						let getPacket = data.map((data, index) => {
							return `<option key=${index} value=${data.id}>${data.packetname}</option>`
						})
						document.getElementById('package_size').innerHTML = selectPacket + getPacket;
						document.getElementById('package_size').value = packageData ? packageData : "";
					});
				};

				getCompanionBanner = (campaignId, getCampanion_banner) => {
					$.ajax({
						type: "GET",
						url: live_URL + '/get_campaignwise_companion_banner/' + campaignId,
						beforeSend: function(xhr) {
							xhr.setRequestHeader('Authorization', token);
						},
						data: {},
						dataType: "json",
						encode: true,
					}).done(function(data) {
						let campanion_array = [],
							defaultValue = `<option value="0" selected><?php echo $GLOBALS['select_companion_banner']; ?></option>`;
						data.data.map((data, index) => {
							campanion_array += `<option key=${index} value=${data.bannerid}>${data.bannername}</option>`;
						});
						document.getElementById('inline_companion_banner').innerHTML = defaultValue + campanion_array;
						document.getElementById('overlay_companion_banner').innerHTML = defaultValue + campanion_array;

						if (getCampanion_banner) {
							document.getElementById('overlay_companion_banner').value = getCampanion_banner;
							document.getElementById('inline_companion_banner').value = getCampanion_banner;
						}

					});
				};

				onChangePacket = () => {
					let getSelectPacket = document.getElementById('package_size').value;
					document.getElementById('error_packageSize').innerHTML = getSelectPacket == "" ? `<?php echo $GLOBALS['select_package']; ?>` : "";
				};

				onChangeXandr = () => {
					let getXander = document.getElementById('flexCheckDefault');
					selectXander = (getXander.checked == true) ? "2" : "1";
					document.getElementById('error_xandr').innerHTML = (getXander.checked == true) ? "" : `<?php echo $GLOBALS['select_xandr_checkBox']; ?>`;
				};

				onchangeStartDate = () => {
					startError = false;
					console.log("campaign_startDate",campaign_startDate);
					let getstartDate = document.getElementById('startDate').value;
					// if(campaign_endDate == ""){
					// 	document.getElementById('error_startDate').innerHTML = "";
					// 	startError = false;
					// }

					if (getstartDate == "") {
						document.getElementById('error_startDate').innerHTML = `<?php echo $GLOBALS['strSelectDate_type']; ?>`;
						startError = true;
						console.log("11");
					} 
					// && getstartDate <= campaign_endDate)||(campaign_endDate == "")
					else if (campaign_startDate <= getstartDate && (getstartDate <= campaign_endDate || campaign_endDate == "")) {
						document.getElementById('error_startDate').innerHTML = "";
						startError = false;
						console.log("22");
					}
					
					
					// else if (campaign_endDate == "") {
					// 	document.getElementById('error_startDate').innerHTML = "";
					// 	startError = false;
					// 	console.log("33");
					// } 
					else {						
						// if(getstartDate <= campaign_startDate && campaign_endDate=='')
						// {
						// 	document.getElementById('error_startDate').innerHTML = 'not match';
						// 	startError = true;
						// 	console.log("55");
						// 	return false;
						// }
						document.getElementById('error_startDate').innerHTML = `<?php echo $GLOBALS['bannerDate_campaignDate']; ?>`;
						startError = true;
						console.log("44");
					}
				};

				onchangeEndDate = () => {
					endError = false;
					let getEndDate = document.getElementById('endDate').value;
					// document.getElementById('error_endDate').innerHTML = getEndDate == "" ? `<?php echo $GLOBALS['strSelectDate_type']; ?>` : "";
					if (getEndDate == "") {
						document.getElementById('error_endDate').innerHTML = `<?php echo $GLOBALS['strSelectDate_type']; ?>`;
						endError = true;
					} else if (campaign_startDate <= getEndDate && (getEndDate <= campaign_endDate || campaign_endDate == "")) {
						document.getElementById('error_endDate').innerHTML = "";
						endError = false;
					}
					// else if (campaign_endDate == "") {
					// 	document.getElementById('error_endDate').innerHTML = "";
					// 	endError = false;
					// } 
					else {
						document.getElementById('error_endDate').innerHTML = `<?php echo $GLOBALS['bannerDate_campaignDate']; ?>`;
						endError = true;
					}
				};

				async function preview() {
					let bannert_type = document.getElementById('banner').value;
					$(".loader").show();

					if (confirm("Are You sure want to Change ?") == true) {
						let form_Data = new FormData();
						banner_image.src = URL.createObjectURL(event.target.files[0]);
						document.getElementById('bannerimage').style.display = "none";

						// imageFormat = event.target.files[0].type == "image/jpeg" ? "jpeg" :
						// 	event.target.files[0].type == "image/jpg" ? "jpg" :
						// 	event.target.files[0].type == "image/png" ? "png" :
						// 	event.target.files[0].type == "application/zip" ? "zip" :
						// 	event.target.files[0].type == "application/x-zip-compressed" ? "zip" : "";

						if (bannert_type == 'web') {
							if (event.target.files[0].type == "image/jpeg" || event.target.files[0].type == "image/png" || event.target.files[0].type == "image/gif") {
								document.getElementById("webBannerImage").value = event.target.files[0].name;
								document.getElementById("webuploaderrors").innerHTML = "";
								form_Data.append("filetype", bannert_type);
								form_Data.append("internal_file", change_image.files[0]);
							} else {
								document.getElementById("webBannerImage").value = "";
								document.getElementById("webuploaderrors").innerHTML = `<?php echo $GLOBALS['image_format']; ?>`;
							}
							$(".loader").hide();
						} else if (bannert_type == 'sql') {
							if (event.target.files[0].type == "image/jpeg" || event.target.files[0].type == "image/png" || event.target.files[0].type == "image/gif") {
								document.getElementById("sqlerrors").innerHTML = "";
								document.getElementById("sqlban").value = event.target.files[0].name;
								form_Data.append("filetype", bannert_type);
								form_Data.append("internal_file", sql_image.files[0]);
							} else {
								document.getElementById("sqlban").value = "";
								document.getElementById("sqlerrors").innerHTML = `<?php echo $GLOBALS['image_format']; ?>`;
							}
							$(".loader").hide();
						} else if (bannert_type == 'bannerTypeHtml:oxHtml:html5') {
							if (event.target.files[0].type == "application/zip") {
								document.getElementById("html5ban").value = event.target.files[0].name;
								document.getElementById("html5_bannerError").innerHTML = "";
								form_Data.append("filetype", bannert_type);
								form_Data.append("internal_file", change_html5banner.files[0]);
							} else if (event.target.files[0].type == "application/x-zip-compressed") {
								document.getElementById("html5ban").value = event.target.files[0].name;
								document.getElementById("html5_bannerError").innerHTML = "";
								form_Data.append("filetype", bannert_type);
								form_Data.append("internal_file", change_html5banner.files[0]);
							} else {
								document.getElementById("html5ban").value = "";
								document.getElementById("html5_bannerError").innerHTML = `<?php echo $GLOBALS['strBanner_HTML5_validation']; ?>`;
							}
							$(".loader").hide();
						}
						$.ajax({
							type: "POST",
							url: live_URL + '/image_upload',
							beforeSend: function(xhr) {
								xhr.setRequestHeader('Authorization', token);
							},
							data: form_Data,
							dataType: "json",
							contentType: false,
							processData: false,
							// encode: true,
						}).done(function(data) {
							// console.log("image upload", data);
							fileWidth = data.fileoriginalwidth;
							fileHeight = data.fileoriginalheight;
							imageFormat = data.fileformat;
							document.getElementById('bannerimage').style.display = "block";

							let image = new Image();
							image.src = bannert_type == "web" ? image_path + '/' + data.filename :
								bannert_type == "sql" ? image_path + '/' + data.filename : "";

							if (Number(defaultWidth) == fileWidth && Number(defaultHeight) == fileHeight) {
								console.log("banner width and height is match");
								document.getElementById("bannerimage").style.display = "block";
								document.getElementById("webuploaderrors").innerHTML = "";
								document.getElementById('sqlerrors').innerHTML = "";
							} else {
								console.log("banner width and height is not match");
								document.getElementById("bannerimage").style.display = "none";
								document.getElementById("webuploaderrors").innerHTML = `<?php echo $GLOBALS['file_width']; ?>` + Number(defaultWidth) + `<?php echo $GLOBALS['file_height']; ?>` + Number(defaultHeight) + `<?php echo $GLOBALS['file_size_is_not_match']; ?>`;
								document.getElementById("sqlerrors").innerHTML = `<?php echo $GLOBALS['file_width']; ?>` + Number(defaultWidth) + `<?php echo $GLOBALS['file_height']; ?>` + Number(defaultHeight) + `<?php echo $GLOBALS['file_size_is_not_match']; ?>`;
							}
							passImageValue = bannert_type == "web" ? image_path + '/' + data.filename :
								bannert_type == "sql" ? image_path + '/' + data.filename :
								bannert_type == "bannerTypeHtml:oxHtml:html5" ? image_path + '/' + data.filename : "";
						});
					} else {
						console.log("Not Changed");
						getBannerData();
						document.getElementById("change_image").value = "";
					}
				};

				async function overlayImage() {
					overlay_imagePreview.src = URL.createObjectURL(event.target.files[0]);
					document.getElementById("overlay_image").style.display = "block";
					// document.getElementById("bannerimage").style.display = "none";
					if (confirm("Are you sure want to change") == true) {
						if (event.target.files[0].type == "image/jpeg" || event.target.files[0].type == "image/png" || event.target.files[0].type == "image/gif") {
							let formData = new FormData();
							formData.append("file", overlay_imageUpload.files[0]);
							document.getElementById("overlay_imageName").value = event.target.files[0].name;
							await fetch('imageupload.php', {
								method: "POST",
								body: formData
							});
						}
					} else {
						console.log("Not Changed");
					}
					passImageValue = image_path + '/' + overlay_imageUpload.files[0].name;
				};

				Submit = () => {
					let name = document.getElementById('name').value;
					let banner = document.getElementById("banner");
					let size = document.getElementById("bannerSize");
					let getSelectPacket = document.getElementById('package_size').value;
					let getstartDate = document.getElementById('startDate').value;
					let getEndDate = document.getElementById('endDate').value;

					console.log("getstartDate", getstartDate, "getEndDate", getEndDate);
					console.log("campaign_startDate", campaign_startDate, "campaign_endDate", campaign_endDate);
					document.getElementById('error_startDate').innerHTML = getstartDate == "" ? `<?php echo $GLOBALS['strSelectDate_type']; ?>` :
						(campaign_startDate <= getstartDate) ? "122321" : `<?php echo $GLOBALS['check_bannerDate']; ?>`;
					document.getElementById('error_endDate').innerHTML = getEndDate == "" ? `<?php echo $GLOBALS['strSelectDate_type']; ?>` :
						(getEndDate <= campaign_endDate) ? "" : `<?php echo $GLOBALS['check_bannerDate']; ?>`;
					if (getEndDate <= campaign_endDate) {
						console.log("greater then is done");
						// document.getElementById('error_endDate').innerHTML ="";
					} else {
						console.log("greater then is not done");
						// document.getElementById('error_endDate').innerHTML = "uygfhdghjgfdhsg";
					}

					if (name == "") {
						document.getElementById("errors").innerHTML = "please enter your name";
						return false;
					} else {
						// document.getElementById("errors").style.display="none";
						document.getElementById("errors").innerHTML = "";
					}

					if (banner.value == "") {
						document.getElementById("errors1").innerHTML = "please select type ";
						return false;
					} else {
						document.getElementById("errors1").style.display = "none";
					}

					if (size.value == "") {
						document.getElementById("errors2").innerHTML = "please select the size";
						return false;
					} else {
						document.getElementById("errors2").style.display = "none";
					}
					// document.getElementById('error_packageSize').innerHTML = getSelectPacket == "" ? `<?php echo $GLOBALS['select_package']; ?>` : "";


					//banner width and height
					// document.getElementById("customWidth").innerHTML = widthValue == "" ? `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>` :
					// 	widthValue == 0 ? `<?php echo $GLOBALS['strValue_Greaterthen_Zero']; ?>` : "";
					// document.getElementById("customHeight").innerHTML = heightValue == "" ? `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>` :
					// 	heightValue == 0 ? `<?php echo $GLOBALS['strValue_Greaterthen_Zero']; ?>` : "";
				};

				bannerSubmit = () => {
					Submit();
					onchangeEndDate();
					onchangeStartDate();
					console.log("default width1:", defaultWidth, "default height1:", getBannerHeight);
					console.log("submit fileWidth:", fileWidth, "submit fileHeight:", fileHeight);

					let bannerData, bannerWidth, bannerHeight;
					let getName = document.getElementById('name').value;
					let getBannerType = document.getElementById('banner').value;
					let getURL = document.getElementById('destination_url').value;
					let getBannerSize = document.getElementById('bannerSize').value;
					let getURLbanner_imageURL = document.getElementById('bannerurl').value;
					let getFileFormate = getURLbanner_imageURL.split('.').pop();
					let getTextBanner = document.getElementById('textBanner_text').value;
					let getHTMLbanner = document.getElementById('htmlBanner_html').value;
					let getUploadImage_web = document.getElementById('webBannerImage').value;
					let salespersonname = document.getElementById('salespersonname').value;
					let getSelectPacket = document.getElementById('package_size').value;
					//date
					let getstartDate = document.getElementById('startDate').value;
					let getEndDate = document.getElementById('endDate').value;
					// confirm("Changing the banner size will unlink this banner from any zones") == true
					if (getBannerSize == "-") {
						bannerWidth = document.getElementById('width').value;
						bannerHeight = document.getElementById('height').value;
					} else {
						let size = getBannerSize.split("x");
						bannerWidth = size[0];
						bannerHeight = size[1];
					}
					if (getBannerSize == "-") {
						var getWidth = document.getElementById('width').value;
						var getHeight = document.getElementById('height').value;
						console.log("width:", getWidth, "height", getHeight);
					} else {
						var size = getBannerSize.split("x");
						var getWidth = size[0];
						var getHeight = size[1];
					}
					// console.log("banner testName1", getName);
					// console.log("size:", getBannerSize);
					// console.log("onchange image", passImageValue);
					//html5
					let html5_zipFile = document.getElementById("html5ban").value;

					//video ads-------------------------

					let rm_video_banner = document.getElementById('video_image').src;
					var myArray = rm_video_banner.split("//");
					myArray = myArray[1];

					var rm_video_banner1 = myArray;
					let html_videoads_videotype = document.getElementById('html_videoads_videotype').value;
					let rm_video = document.getElementById('rm_video1').value;

					var rm_video_path = rm_video.split('\\');
					rm_video_path = rm_video_path[2];

					if (rm_video_path == null) {
						rm_video_banner1 = myArray;
					} else {
						rm_video_banner1 = rm_video_path;
					}
					let videoadsvideo_url = document.getElementById('videoadsvideo_url').value;
					let extension_videoType = document.getElementById('extension_videoType').value;
					let videoads_skipads = document.getElementById('videoads_skipads').value;
					let videoads_width = document.getElementById('videoads_width').value;
					let videoads_height = document.getElementById('videoads_height').value;

					//inline
					let inlineDelivery_method = document.getElementById('inlineVideo-deliveryType').value;
					let inlineVideo_fileType = document.getElementById('inlineVideo_type').value;
					let inlineVideo_duration = document.getElementById('inline_videoDuration').value;
					let inline_videoURL = document.getElementById('inlineProgressive_videoURL').value;
					let inlineStreamingVideo_fileName = document.getElementById('inlineStreaming_videoFileName').value;
					let rtmsserver = document.getElementById('inlineRTMP_serverURL').value;
					let inline_compnionBanner = document.getElementById('inline_companion_banner').value;
					//overlay 
					let overlay_type = document.getElementById('overlayType').value;
					let overlay_ClickeAction = document.getElementById('overlayClick_action').value;
					let overlayVideo_deliveryMethod = document.getElementById('vast_video_delivery').value;
					let overlayRTMP_serverURL = document.getElementById('url').value;
					let overlayVideo_fileName = document.getElementById('videofile').value;
					let overlayVideo_type = document.getElementById('video_type').value;
					let overlayVideo_duration = document.getElementById('videoduration').value;
					let overlay_destinationURL = document.getElementById('overlay_destinationURL').value;
					let overlay_compnionBanner = document.getElementById('overlay_companion_banner').value;
					//overlay-html
					let overlay_HTMLoverlay = document.getElementById('overlayhtml').value;
					//overlay-text
					let overlay_textOverlay_title = document.getElementById('title').value;
					let overlay_textOverlay_description = document.getElementById('description').value;
					let overlay_textOverlay_callToAction = document.getElementById('calltoaction').value;
					let overlay_textOverlay_progressiveVideoURL = document.getElementById('progressive_videoURL').value;

					if (getBannerType == "web") {
						bannerData = {
							"description": getName,
							"contenttype": imageFormat,
							"storagetype": getBannerType,
							"url": getURL,
							"width": getWidth,
							"height": getHeight,
							// "imageurl":getURLbanner_imageURL ==""?sendFileName_web:getURLbanner_imageURL,
							// "imageurl":passImageValue == undefined?sendFileName_web:passImageValue,
							"imageurl": passImageValue,
							"start": getstartDate,
							"end": getEndDate,
							"packetid": getSelectPacket,
							"xandr": selectXander == "" ? "1" : selectXander,
							"salespersonname": salespersonname,
							"mode": "edit"
						};
					} else if (getBannerType == "sql") {
						bannerData = {
							"description": getName,
							"contenttype": imageFormat,
							"storagetype": getBannerType,
							"url": getURL,
							"width": getWidth,
							"height": getHeight,
							// "imageurl":passImageValue == undefined?sendFileName_web:passImageValue,
							"imageurl": passImageValue,
							"start": getstartDate,
							"end": getEndDate,
							"packetid": getSelectPacket,
							"xandr": selectXander == "" ? "1" : selectXander,
							"salespersonname": salespersonname,
							"mode": "edit"
						};
					} else if (getBannerType == "url") {
						bannerData = {
							"description": getName,
							"contenttype": getFileFormate,
							"storagetype": getBannerType,
							"url": getURL,
							"width": getWidth,
							"height": getHeight,
							"imageurl": getURLbanner_imageURL,
							"url_banner_imageurl": getURLbanner_imageURL,
							"start": getstartDate,
							"end": getEndDate,
							"packetid": getSelectPacket,
							"xandr": selectXander == "" ? "1" : selectXander,
							"salespersonname": salespersonname,
							"mode": "edit"
						};
					} else if (getBannerType == "bannerTypeHtml:VideoAds:Videoads") {
						bannerData = {
							"description": getName,
							"storagetype": "html",
							"destination_url": getURL,
							"html_videoads_videotype": html_videoads_videotype,
							"rm_video": rm_video_banner1,
							"videoadsvideo_url": videoadsvideo_url,
							"extension_videoType": extension_videoType,
							"videoads_skipads": videoads_skipads,
							"width": videoads_width,
							"height": videoads_height,
							"ext_bannertype": "bannerTypeHtml:VideoAds:Videoads",
							"start": getstartDate,
							"end": getEndDate,
							"packetid": getSelectPacket,
							"xandr": selectXander == "" ? "1" : selectXander,
							"salespersonname": salespersonname,
							"mode": "edit"
						};
					} else if (getBannerType == "bannerTypeText:oxText:genericText") {
						bannerData = {
							"description": getName,
							"storagetype": "txt",
							"url": getURL,
							"bannertext": getTextBanner,
							"ext_bannertype": "bannerTypeText:oxText:genericText",
							"start": getstartDate,
							"end": getEndDate,
							"packetid": getSelectPacket,
							"xandr": selectXander == "" ? "1" : selectXander,
							"salespersonname": salespersonname,
							"mode": "edit"
						};
						console.log("update text banner", bannerData);
					} else if (getBannerType == "bannerTypeHtml:oxHtml:genericHtml") {
						bannerData = {
							"description": getName,
							"storagetype": "html",
							"url": getURL,
							"width": getWidth,
							"height": getHeight,
							"htmltemplate": getHTMLbanner,
							"ext_bannertype": "bannerTypeHtml:oxHtml:genericHtml",
							"start": getstartDate,
							"end": getEndDate,
							"packetid": getSelectPacket,
							"xandr": selectXander == "" ? "1" : selectXander,
							"salespersonname": salespersonname,
							"mode": "edit"
						};
					} else if (getBannerType == "bannerTypeHtml:oxHtml:html5") {
						bannerData = {
							"description": getName,
							"storagetype": "html",
							"url": getURL,
							"width": getWidth,
							"height": getHeight,
							// "filename":passImageValue == undefined?sendFileName_web:passImageValue,
							"filename": passImageValue,
							"ext_bannertype": "bannerTypeHtml:oxHtml:html5",
							"start": getstartDate,
							"end": getEndDate,
							"packetid": getSelectPacket,
							"xandr": selectXander == "" ? "1" : selectXander,
							"salespersonname": salespersonname,
							"mode": "edit"
						};
					} else if (getBannerType == "bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml") {
						bannerData = {
							"description": getName,
							"storagetype": "html",
							"url": inlineDelivery_method == "streaming" ? rtmsserver : inline_videoURL,
							"width": "-2",
							"height": "-2",
							"ext_bannertype": "bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml",
							"mode": "edit",
							"vast_video_delivery": inlineDelivery_method,
							"vast_video_outgoing_filename": inlineDelivery_method == "streaming" ? inlineStreamingVideo_fileName : "",
							"vast_video_duration": inlineVideo_duration,
							"vast_video_type": inlineVideo_fileType,
							"vast_video_clickthrough_url": getURL,
							"vast_companion_banner_id": inline_compnionBanner,
							"start": getstartDate,
							"end": getEndDate,
							"packetid": getSelectPacket,
							"xandr": selectXander == "" ? "1" : selectXander,
							"salespersonname": salespersonname,
						};
					} else if (getBannerType == "bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml") {
						bannerData = {
							"description": getName,
							"storagetype": "html",
							"url": overlay_destinationURL == "" ? "" : overlay_destinationURL,
							"ext_bannertype": "bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml",
							"mode": "edit",
							"vast_overlay_format": overlay_type,
							"vast_overlay_action": overlay_ClickeAction,
							"vast_video_delivery": overlayVideo_deliveryMethod,
							"vast_video_clickthrough_url": overlayRTMP_serverURL == "" ? overlay_textOverlay_progressiveVideoURL : overlayRTMP_serverURL,
							"vast_video_outgoing_filename": overlayVideo_fileName,
							"vast_video_type": overlayVideo_type,
							"vast_video_duration": overlayVideo_duration,
							"vast_companion_banner_id": overlay_compnionBanner,
							//overlay-html
							"htmltemplate": overlay_HTMLoverlay,
							//overlay-text
							"vast_overlay_text_title": overlay_textOverlay_title,
							"vast_overlay_text_description": overlay_textOverlay_description,
							"vast_overlay_text_call": overlay_te < tOverlay_callToAction,
							//overlay-image
							// "imageurl":passImageValue == undefined?sendFileName_web:passImageValue
							"imageurl": passImageValue,
							"start": getstartDate,
							"end": getEndDate,
							"packetid": getSelectPacket,
							"xandr": selectXander == "" ? "1" : selectXander,
							"salespersonname": salespersonname,
						};
					} else {
						console.log("not working");
					}


					function time_format(videoads_skipads) {
						// let regEx = /^([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])(:|\.)\d{1,2}?$/;
						let regEx = /^([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])?$/;

						// console.log('videoads_skipads...', videoads_skipads);
						// console.log('sjip ads...', regEx.test(videoads_skipads));
						var videoads_skip_val = regEx.test(videoads_skipads);
						return videoads_skip_val;
					}

					if (getName == "") {
						document.getElementById("errors").innerHTML = `<?php echo $GLOBALS['strName_validation']; ?>`;
						console.log("1");
					} else if (getBannerType == "") {
						document.getElementById("errors1").innerHTML = `<?php echo $GLOBALS['strBannertype_validation']; ?>`;
						console.log("2");
					} else if (getBannerType !== "bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml" && getURL == "") {
						document.getElementById("error_destinationURL").innerHTML = `<?php echo $GLOBALS['strBanner_URL_validation']; ?>`;
						console.log("3");
					} else if (getBannerType !== "bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml" && pattern.test(getURL) == false) {
						document.getElementById("error_destinationURL").innerHTML = `<?php echo $GLOBALS['enter_valid_url']; ?>`;
						console.log("4");
					}
					//  else if (getstartDate == "") {
					// 	document.getElementById('error_startDate').innerHTML = `<?php echo $GLOBALS['strSelectDate_type']; ?>`;
					// } else if (campaign_startDate > getstartDate) {
					// 	document.getElementById('error_startDate').innerHTML = `<?php echo $GLOBALS['check_bannerDate']; ?>`;
					// } else if (getEndDate == "") {
					// 	document.getElementById('error_endDate').innerHTML = `<?php echo $GLOBALS['strSelectDate_type']; ?>`;
					// } else if (campaign_endDate > getEndDate) {
					// 	document.getElementById('error_endDate').innerHTML = `<?php echo $GLOBALS['check_bannerDate']; ?>`;
					// }
					//web
					else if (getBannerType == "web" && getBannerSize == "") {
						document.getElementById("errors2").innerHTML = `<?php echo $GLOBALS['strBanner_Size_validation']; ?>`;
						console.log("5");
					} else if (getBannerType == "web" && passImageValue == "") {
						document.getElementById("webuploaderrors").innerHTML = `<?php echo $GLOBALS['strBanner_Upload_Image_validation']; ?>`;
						console.log("submit web upload image");
					} else if (getBannerType == "web" && passImageValue !== "" && Number(defaultWidth) !== Number(fileWidth)) {
						document.getElementById("webuploaderrors").innerHTML = `<?php echo $GLOBALS['file_width']; ?>` + Number(defaultWidth) + `<?php echo $GLOBALS['file_height']; ?>` + Number(defaultHeight) + `<?php echo $GLOBALS['file_size_is_not_match']; ?>`;
						console.log("submit web bannersize file width");
					} else if (getBannerType == "web" && passImageValue !== "" && Number(defaultHeight) !== Number(fileHeight)) {
						document.getElementById("webuploaderrors").innerHTML = `<?php echo $GLOBALS['file_width']; ?>` + Number(defaultWidth) + `<?php echo $GLOBALS['file_height']; ?>` + Number(defaultHeight) + `<?php echo $GLOBALS['file_size_is_not_match']; ?>`;
						console.log("submit web bannersize file height");
					}
					//sql
					else if (getBannerType == "sql" && getBannerSize == "") {
						document.getElementById("errors2").innerHTML = `<?php echo $GLOBALS['strBanner_Size_validation']; ?>`;
						console.log("13");
					} else if (getBannerType == "sql" && passImageValue == "") {
						document.getElementById("sqlerrors").innerHTML = `<?php echo $GLOBALS['strBanner_Upload_Image_validation']; ?>`;
						console.log("submit sql upload image");
					} else if (getBannerType == "sql" && passImageValue !== "" && Number(defaultWidth) !== Number(fileWidth)) {
						// document.getElementById("bannerimage").style.display = "none";
						document.getElementById("sqlerrors").innerHTML = `<?php echo $GLOBALS['file_width']; ?>` + Number(defaultWidth) + `<?php echo $GLOBALS['file_height']; ?>` + Number(defaultHeight) + `<?php echo $GLOBALS['file_size_is_not_match']; ?>`;
						console.log("submit sql file width");
					} else if (getBannerType == "sql" && passImageValue !== "" && Number(defaultHeight) !== Number(fileHeight)) {
						// document.getElementById("bannerimage").style.display = "none";
						document.getElementById("sqlerrors").innerHTML = `<?php echo $GLOBALS['file_width']; ?>` + Number(defaultWidth) + `<?php echo $GLOBALS['file_height']; ?>` + Number(defaultHeight) + `<?php echo $GLOBALS['file_size_is_not_match']; ?>`;
						console.log("24");
					}
					//url
					else if (getBannerType == "url" && getURLbanner_imageURL == "") {
						document.getElementById("errors3").innerHTML = `<?php echo $GLOBALS['strBanner_URL_validation']; ?>`;
						console.log("21");
					} else if (getBannerType == "url" && pattern.test(getURLbanner_imageURL) == false) {
						document.getElementById("errors3").innerHTML = `<?php echo $GLOBALS['enter_valid_url']; ?>`;
						console.log("22");
					} else if (getBannerType == "url" && getBannerSize == "") {
						document.getElementById("errors2").innerHTML = `<?php echo $GLOBALS['strBanner_Size_validation']; ?>`;
						console.log("23");
					}
					//HTML
					else if (getBannerType == "bannerTypeHtml:oxHtml:genericHtml" && getBannerSize == "") {
						document.getElementById("errors2").innerHTML = `<?php echo $GLOBALS['strBanner_Size_validation']; ?>`;
						console.log("32");
					} else if (getBannerType == "bannerTypeHtml:oxHtml:genericHtml" && getHTMLbanner == "") {
						document.getElementById("htmlBanner_error").innerHTML = `<?php echo $GLOBALS['strBanner_HTML_validation']; ?>`;
						console.log("33");
					}
					//HTML5
					else if (getBannerType == "bannerTypeHtml:oxHtml:html5" && getBannerSize == "") {
						document.getElementById("errors2").innerHTML = `<?php echo $GLOBALS['strBanner_Size_validation']; ?>`;
						console.log("40");
					} else if (getBannerType == "bannerTypeHtml:oxHtml:html5" && html5_zipFile == "") {
						document.getElementById("html5_bannerError").innerHTML = `<?php echo $GLOBALS['select_a_file']; ?>`;
						console.log("41");
					}
					//text
					else if (getBannerType == "bannerTypeText:oxText:genericText" && getTextBanner == "") {
						document.getElementById("txtBanner_error").innerHTML = `<?php echo $GLOBALS['enter_the_text']; ?>`;
						console.log("47");
					}

					//videoads
					else if (getBannerType == "bannerTypeHtml:VideoAds:Videoads" && videoads_skipads != "" && time_format(videoads_skipads) == false) {
						document.getElementById("videoads_skipadserrors").innerHTML = "Please enter a valid time format";
						console.log("vid ads 7");
					} else if (getBannerType == "bannerTypeHtml:VideoAds:Videoads" && html_videoads_videotype == "video_upload" && rm_video_path == "") {
						document.getElementById("error_rm_video").innerHTML = `<?php echo $GLOBALS['videoads_videoupload_error']; ?>`;
						console.log("vid ads 3");
					}

					//inline
					else if (getBannerType == "bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml" && inlineDelivery_method == "") {
						document.getElementById("vediodeliveryerrors").innerHTML = `<?php echo $GLOBALS['select_delivery_method']; ?>`;
						console.log("submit inline delivery method");
					} else if (getBannerType == "bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml" && inlineDelivery_method == "streaming" && inlineStreamingVideo_fileName == "") {
						document.getElementById("vediourlerrors").innerHTML = `<?php echo $GLOBALS['strBanner_Vediofile_Name_validation']; ?>`;
						console.log("submit inline deliveryMethod->streaming filename");
					} else if (getBannerType == "bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml" && inlineDelivery_method == "streaming" && rtmsserver == "") {
						document.getElementById("rtms_server_url").innerHTML = `<?php echo $GLOBALS['strBanner_RTMSserver_URL_validation']; ?>`;
						console.log("submit inline deliveryMethod->streaming rtmp url");
					} else if (getBannerType == "bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml" && inlineDelivery_method == "progressive" && inline_videoURL == "") {
						document.getElementById("video_URLerror").innerHTML = `<?php echo $GLOBALS['enter_the_url']; ?>`;
						console.log("submit inline deliveryMethod->progressive video url");
					} else if (getBannerType == "bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml" && inlineVideo_fileType == "") {
						document.getElementById("vediofiletypeerrors").innerHTML = `<?php echo $GLOBALS['strBanner_Vediofile_Name_validation']; ?>`;
						console.log("submit inline video type");
					} else if (getBannerType == "bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml" && inlineVideo_duration == "") {
						document.getElementById("vediodurationerrors").innerHTML = `<?php echo $GLOBALS['select_video_duration']; ?>`;
						console.log("submit inline video duration");
					}
					//Overlay
					else if (getBannerType == "bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml" && overlay_ClickeAction == "") {
						document.getElementById("overlayclick_error").innerHTML = `<?php echo $GLOBALS['strBanner_Overlayclick_Action_validation']; ?>`;
						console.log("submit overlay click action");
					} else if (getBannerType == "bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml" && overlay_type == "") {
						document.getElementById("error_overlayType").innerHTML = `<?php echo $GLOBALS['strBanner_Overlaytype_validation']; ?>`;
						console.log("submit overlay type");
					} else if (getBannerType == "bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml" && overlay_ClickeAction == "click_to_video" && overlayVideo_deliveryMethod == "") {
						document.getElementById("overlaydeliverymethod").innerHTML = `<?php echo $GLOBALS['strBanner_Selectvedio_validation']; ?>`;
						console.log("submit overlay clickAction-> delivery method");
					} else if (getBannerType == "bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml" && overlay_ClickeAction == "click_to_video" &&
						inlineDelivery_method == "streaming" && overlayRTMP_serverURL == "") {
						document.getElementById("overlayrtmerrors").innerHTML = `<?php echo $GLOBALS['strBanner_RTMSserver_URL_validation']; ?>`;
						console.log("submit overlay deliveryMethod->click_to_video->rtmp url");
					} else if (getBannerType == "bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml" && overlay_ClickeAction == "click_to_video" &&
						inlineDelivery_method == "streaming" && overlayVideo_fileName == "") {
						document.getElementById("error_overlay_fileName").innerHTML = `<?php echo $GLOBALS['strBanner_Vediofile_Name_validation']; ?>`;
						console.log("submit overlay deliveryMethod->click_to_video->fileName");
					} else if (getBannerType == "bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml" && overlay_ClickeAction == "click_to_video" &&
						inlineDelivery_method == "progressive" && overlay_textOverlay_progressiveVideoURL == "") {
						document.getElementById("overlayvedioerrors").innerHTML = `<?php echo $GLOBALS['enter_the_url']; ?>`;
						console.log("submit overlay click_to_video->progressive-> video url");
					} else if (getBannerType == "bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml" && overlay_ClickeAction == "click_to_video" && overlayVideo_type == "") {
						document.getElementById("overlayvediofiletype").innerHTML = `<?php echo $GLOBALS['select_video_format']; ?>`;
						console.log("submit overlay video type");
					} else if (getBannerType == "bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml" && overlay_ClickeAction == "click_to_video" && overlayVideo_duration == "") {
						document.getElementById("overlayvediodurationerrors").innerHTML = `<?php echo $GLOBALS['enter_the_video_duration']; ?>`;
						console.log("submit overlay video duration");
					} else {
						document.getElementById("errors").innerHTML = "";
						document.getElementById("errors1").innerHTML = "";
						document.getElementById("error_destinationURL").innerHTML = "";
						document.getElementById('error_startDate').innerHTML = "";
						// document.getElementById('error_endDate').innerHTML ="";
						document.getElementById("bannerimage").style.display = getBannerType == "web" ? "block" :
							getBannerType == "sql" ? "block" :
							getBannerType == "url" ? "block" : "none";
						//size Validation
						document.getElementById("errors2").innerHTML = "";
						//web
						document.getElementById("webuploaderrors").innerHTML = "";
						//sql
						document.getElementById("sqlerrors").innerHTML = "";
						//url
						document.getElementById("errors3").innerHTML = "";
						//HTML
						document.getElementById("htmlBanner_error").innerHTML = "";
						//HTML5
						document.getElementById("html5_bannerError").innerHTML = "";
						//text
						document.getElementById("txtBanner_error").innerHTML = "";
						//videoads
						document.getElementById("videoads_skipadserrors").innerHTML = "";
						document.getElementById("error_rm_video").innerHTML = "";

						//inline
						document.getElementById("vediodeliveryerrors").innerHTML = "";
						document.getElementById("vediourlerrors").innerHTML = "";
						document.getElementById("rtms_server_url").innerHTML = "";
						document.getElementById("video_URLerror").innerHTML = "";
						document.getElementById("vediofiletypeerrors").innerHTML = "";
						document.getElementById("vediodurationerrors").innerHTML = "";
						//overlay
						document.getElementById("overlayclick_error").innerHTML = "";
						document.getElementById("error_overlayType").innerHTML = "";
						document.getElementById("overlaydeliverymethod").innerHTML = "";
						document.getElementById("overlayrtmerrors").innerHTML = "";
						document.getElementById("error_overlay_fileName").innerHTML = "";
						document.getElementById("overlayvedioerrors").innerHTML = "";
						document.getElementById("overlayvediofiletype").innerHTML = "";
						document.getElementById("overlayvediodurationerrors").innerHTML = "";

						if (startError != true && endError != true) {
							$.ajax({
								url: live_URL + '/edit_banner/' + getBanner_id,
								type: "POST",
								beforeSend: function(xhr) {
									xhr.setRequestHeader('Authorization', token);
								},
								data: bannerData,
								dataType: "json",
								encode: true,
							}).done(function(data) {
								console.log("res:", data.msg, "statcode", data.statuscode);
								if (data.msg == 'Banner Updated Successfully' && data.statuscode == 200) {
									swal({
											title: `<?php echo $GLOBALS['banner_update_successfully']; ?>`,
											type: "success"
										})
										.then(data => {
											if (data) {
									window.location.href = "bannerlist.php";
										}
									});
								} else {
									console.error(data.msg);
								}
							});
							event.preventDefault();
						}
					}
				};

				banner_type = (ext_bannerType) => {
					console.log("ext banner type:", ext_bannerType);
					let getBanner_size = document.getElementById("bannerSize").value;
					console.log("getBanner_size", getBanner_size);
					document.getElementById("errors1").innerHTML = ext_bannerType == "" ? `<?php echo $GLOBALS['strSelect_Banner_Type']; ?>` : "";
					document.getElementById("getBannerSize").style.display = ext_bannerType == 'bannerTypeText:oxText:genericText' ? "none" :
						ext_bannerType == 'bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml' ? "none" :
						ext_bannerType == 'bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml' ? "none" : "";
					ext_bannerType == 'bannerTypeHtml:VideoAds:Videoads' ? "none" : "block";

					document.getElementById("webbanner").style.display = ext_bannerType == 'web' ? "block" : "none";
					document.getElementById("bannerimage").style.display = ext_bannerType == 'web' ? "block" :
						ext_bannerType == 'sql' ? "block" : ext_bannerType == 'url' ? "block" :
						ext_bannerType == 'bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml' ? "block" : "none";
					document.getElementById("sqlbanner").style.display = ext_bannerType == 'sql' ? "block" : "none";
					document.getElementById("urlbanner").style.display = ext_bannerType == 'url' ? "block" : "none";
					document.getElementById("textbanner").style.display = ext_bannerType == 'bannerTypeText:oxText:genericText' ? "block" : "none";
					document.getElementById("htmlbanner").style.display = ext_bannerType == 'bannerTypeHtml:oxHtml:genericHtml' ? "block" : "none";
					document.getElementById("html5banner").style.display = ext_bannerType == 'bannerTypeHtml:oxHtml:html5' ? "block" : "none";
					document.getElementById("overlayvideoad").style.display = ext_bannerType == 'bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml' ? "block" : "none";
					document.getElementById("inlinevideoad").style.display = ext_bannerType == 'bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml' ? "block" : "none";
					document.getElementById("bannerarea").style.display = "block";
					document.getElementById("main_destinationURL").style.display = ext_bannerType == "bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml" ? "none" : "block";
					// document.getElementById("custom").style.display = ext_bannerType == 'bannerTypeText:oxText:genericText' || ext_bannerType == "bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml" 
					// || ext_bannerType == "bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml"?"none":"";
					// document.getElementById("custom").style.display = ((ext_bannerType == 'web' && getBanner_size = "-") || ext_bannerType == (ext_bannerType == 'sql' && getBanner_size = "-") 
					// || ext_bannerType == (ext_bannerType == 'url' && getBanner_size = "-") || ext_bannerType == (ext_bannerType == 'bannerTypeHtml:oxHtml:genericHtml' && getBanner_size = "-")
					// ||ext_bannerType == (ext_bannerType == 'bannerTypeHtml:oxHtml:html5' && getBanner_size = "-")) ?"block":"none";
					// document.getElementById("custom").style.display =ext_bannerType == 'web'?getBanner_size = "-"?"block":"none":
					// ext_bannerType == 'sql'?getBanner_size = "-"?"block":"none":ext_bannerType == 'url'?getBanner_size = "-"?"block":"none":
					// ext_bannerType == 'bannerTypeHtml:oxHtml:genericHtml'?getBanner_size = "-"?"block":"none":
					// ext_bannerType == 'bannerTypeHtml:oxHtml:html5'?getBanner_size = "-"?"block":"none":"none";
					document.getElementById("videoads").style.display = ext_bannerType == "bannerTypeHtml:VideoAds:Videoads" ? "block" : "none";
					// document.getElementById("getBannerSize").style.display = ext_bannerType == "bannerTypeHtml:VideoAds:Videoads" ? "none" : "";
					if (ext_bannerType == "bannerTypeHtml:VideoAds:Videoads") {
						document.getElementById("custom").style.display = "none";
					}

				};

				overlayclick = (selectclickaction) => {
					document.getElementById("overlayclickpage").style.display = selectclickaction == 'click_to_page' ? "block" : "none";
					document.getElementById("overlayclickaction").style.display = selectclickaction == 'click_to_video' ? "block" : "none";
					document.getElementById("overlayclick_error").innerHTML = selectclickaction == "" ? "select the overlay" : "";
				};

				overlayad = (overlayadselect) => {
					console.log("overlay type", overlayadselect);
					let getOverlayType = document.getElementById("overlayType").value;
					console.log("overlay type2", getOverlayType);
					if (getOverlayType !== "") {
						document.getElementById("imageoverlay").style.display = getOverlayType == 'image_overlay' ? "block" : "none";
						document.getElementById("bannerimage").style.display = getOverlayType == 'image_overlay' ? "block" : "none";
						document.getElementById("textoverlay").style.display = getOverlayType == 'text_overlay' ? "block" : "none";
						document.getElementById("htmloverlay").style.display = getOverlayType == 'html_overlay' ? "block" : "none";
					}
					// if(overlayadselect== 'imageoverlay'){
					// 	// $("#imageoverlay").css("display", "block");
					// 	// $("#textoverlay").css("display", "none");
					// 	// $("#htmloverlay").css("display", "none");
					//     $("#bannerimage").css("display", "block");
					// 	}else if(overlayadselect== 'textoverlay'){
					// 	// $("#textoverlay").css("display", "block");
					// 	// $("#imageoverlay").css("display", "none");
					// 	// $("#htmloverlay").css("display", "none");
					//     $("#bannerimage").css("display", "none");
					// 	}else if(overlayadselect== 'htmloverlay'){
					// 	// $("#htmloverlay").css("display", "block");
					// 	// $("#textoverlay").css("display", "none");
					// 	// $("#imageoverlay").css("display", "none");
					//     $("#bannerimage").css("display", "none");
					// }
				};

				custom_select = () => {
					let getbanner_size = document.getElementById('bannerSize').value;
					let getBannerType = document.getElementById('banner').value;

					if (confirm('banner need to change') == true) {
						document.getElementById("bannerimage").style.display = getBannerType == "web" ? "none" : getBannerType == "sql" ? "none" :
							getBannerType == "bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml" ? "none" :
							getBannerType == "url" ? "none" :
							getBannerType == "bannerTypeHtml:oxHtml:genericHtml" ? "none" :
							getBannerType == "bannerTypeHtml:oxHtml:html5" ? "none" : "";
					} else {
						getBannerData();
					}
					let size = getbanner_size.split("x");
					defaultWidth = size[0];
					defaultHeight = size[1];
					document.getElementById("errors2").innerHTML = getbanner_size !== "" ? "" : `<?php echo $GLOBALS['strBanner_Size_validation']; ?>`;
				};


				videoads_videotype = () => {
					var select = document.getElementById('html_videoads_videotype').value;
					console.log('select....', select);

					document.getElementById("videoads_vidupload").style.display = select == 'Internal' ? "block" : "none";
					document.getElementById("rm_video1").style.display = select == 'Internal' ? "block" : "none";
					document.getElementById("videoads_viduploadlabel").style.display = select == 'Internal' ? "block" : "none";

					document.getElementById("videoads_vidurl").style.display = select == 'External' ? "block" : "none";
					document.getElementById("videoadsvideo_url").style.display = select == 'External' ? "block" : "none";
					document.getElementById("videoads_vidurllabel").style.display = select == 'External' ? "block" : "none";
				};

				progressivechange = (select) => {
					console.log("output", select);
					document.getElementById("prgs").style.display = select == 'progressive' ? "block" : "none";
					document.getElementById("strem").style.display = select == 'progressive' ? "none" : "block";
					document.getElementById("filename").style.display = select == 'progressive' ? "none" : "block";
					document.getElementById("vediodeliveryerrors").innerHTML = select == "" ? `<?php echo $GLOBALS['strBanner_Videodelivery_Method_validation']; ?>` : "";
					// document.getElementById("strem").style.display = select == 'streaming'?"block":"none";
					// document.getElementById("filename").style.display = select == 'streaming'?"block":"none";
				};

				overlayprogressivechange = (select) => {
					document.getElementById("overlayprgs").style.display = select == 'progressive' ? "block" : "none";
					document.getElementById("overlaystrem").style.display = select == 'streaming' ? "block" : "none";
					document.getElementById("filenameoverlay").style.display = select == 'streaming' ? "block" : "none";
					document.getElementById("overlaydeliverymethod").innerHTML = select == "" ? `<?php echo $GLOBALS['strBanner_Videodelivery_Method_validation']; ?>` : "";
					// 	if (select == 'progressive') {
					// 		// $("#overlayprgs").css("display", "block");
					//         // $("#overlaystrem").css("display", "none");
					//         $("#filenameoverlay").css("display", "none");

					// 	} else if (select == 'streaming') {
					//     // $("#overlaystrem").css("display", "block");
					//     // $("#overlayprgs").css("display", "none");
					//     $("#filenameoverlay").css("display", "block");
					// }
				};

				restrictAlphabets = (e) => {
					var x = e.which || e.keycode;
					if ((x >= 48 && x <= 57)) {
						return true;
					} else {
						return false;
					}
				};

				function bannernameval() {
					let getName = document.getElementById('name').value;
					if (getName == "") {
						document.getElementById("errors").innerHTML = `<?php echo $GLOBALS['strName_validation']; ?>`;
					} else {
						document.getElementById("errors").innerHTML = "";
					}
				};

				function urlbanner() {
					let getURLbanner_imageURL = document.getElementById('bannerurl').value;
					if (getURLbanner_imageURL == "") {
						document.getElementById("errors3").innerHTML = `<?php echo $GLOBALS['strBanner_URL_validation']; ?>`;
					} else if (pattern.test(getURLbanner_imageURL) == false) {
						document.getElementById("errors3").innerHTML = `<?php echo $GLOBALS['enter_valid_url']; ?>`;
					} else {
						document.getElementById("errors3").innerHTML = "";
					}
				};

				function bannertextVal() {
					let getTextBanner = document.getElementById('textBanner_text').value;
					if (getTextBanner == "") {
						document.getElementById("txtBanner_error").innerHTML = `<?php echo $GLOBALS['enter_the_text']; ?>`;
					} else {
						document.getElementById("txtBanner_error").innerHTML = "";
					}
				};

				function htmlbannerVal() {
					let getHTMLbanner = document.getElementById('htmlBanner_html').value;
					if (getHTMLbanner == "") {
						document.getElementById("htmlBanner_error").innerHTML = `<?php echo $GLOBALS['strBanner_HTML_validation']; ?>`;
						console.log("che1");
					}
					// else if (getHTMLbanner == "" && getHTMLbanner.style.display == true ) {
					// 	document.getElementById("htmlBanner_error").innerHTML = "";
					// 	console.log("che2");
					// }
					else {
						document.getElementById("htmlBanner_error").innerHTML = "";
						console.log("che3");
					}
				};






				function vediouploadval() {
					let inlineStreamingVideo_fileName = document.getElementById('inlineStreaming_videoFileName').value;
					if (inlineStreamingVideo_fileName == "") {
						document.getElementById("vediourlerrors").innerHTML = `<?php echo $GLOBALS['strBanner_Vediofile_Name_validation']; ?>`;
						// return false;
					} else {
						document.getElementById("vediourlerrors").innerHTML = "";
					}
				}




				///video ads


				function time_format(videoads_skipads_val) {
					// let regEx = /^([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])(:|\.)\d{1,2}?$/;
					let regEx = /^([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])?$/;

					console.log('videoads_skipads_val...', videoads_skipads_val);
					console.log('sjip ads...', regEx.test(videoads_skipads_val));
					var videoads_skip_val = regEx.test(videoads_skipads_val);
					return videoads_skip_val;

				};


				function videoads_skipadserrors() {
					var videoads_skipads_val = document.getElementById("videoads_skipads").value;
					if (videoads_skipads_val != "") {
						console.log('skipds...', videoads_skipads_val);
						var videoads_skip_val = time_format(videoads_skipads_val);
						console.log('videoads_skip_val ...', videoads_skip_val);


						if (videoads_skip_val == false) {
							document.getElementById("videoads_skipadserrors")
								.innerHTML = "Please enter a valid time format";

						} else {
							document.getElementById("videoads_skipadserrors").innerHTML = "";

						}
					}

				}

				function inlinertmpurl() {
					let rtmsserver = document.getElementById('inlineRTMP_serverURL').value;
					if (rtmsserver == "") {
						document.getElementById("rtms_server_url").innerHTML = `<?php echo $GLOBALS['strBanner_RTMSserver_URL_validation']; ?>`;
					} else {
						document.getElementById("rtms_server_url").innerHTML = "";
					}
				};

				function vediofiletypeval() {
					let inlineVideo_fileType = document.getElementById('inlineVideo_type').value;
					if (inlineVideo_fileType == "") {
						document.getElementById("vediofiletypeerrors").innerHTML = `<?php echo $GLOBALS['strBanner_Videofile_Type_validation']; ?>`;
						// return false;
					} else {
						document.getElementById("vediofiletypeerrors").innerHTML = "";
					}
				};

				function vediodurationval() {
					let inlineVideo_duration = document.getElementById('inline_videoDuration').value;
					if (inlineVideo_duration == "") {
						document.getElementById("vediodurationerrors").innerHTML = `<?php echo $GLOBALS['select_video_duration']; ?>`;
					} else {
						document.getElementById("vediodurationerrors").innerHTML = "";
					}
				};

				function inlinevediourl() {
					let inline_videoURL = document.getElementById('inlineProgressive_videoURL').value;
					console.log("inline video", inline_videoURL);
					if (inline_videoURL == "") {
						document.getElementById("video_URLerror").innerHTML = `<?php echo $GLOBALS['enter_the_url']; ?>`;
					} else {
						document.getElementById("video_URLerror").innerHTML = "";
					}
				};

				function overlayvediourl() {
					let overlay_textOverlay_progressiveVideoURL = document.getElementById('progressive_videoURL').value;
					if (overlay_textOverlay_progressiveVideoURL == "") {
						document.getElementById("overlayvedioerrors").innerHTML = `<?php echo $GLOBALS['enter_the_url']; ?>`;
					} else {
						document.getElementById("overlayvedioerrors").innerHTML = "";
					}
				};

				function overlay_vediotype() {
					let overlayVideo_type = document.getElementById('video_type').value;
					if (overlayVideo_type == "") {
						document.getElementById("overlayvediofiletype").innerHTML = `<?php echo $GLOBALS['select_video_format']; ?>`;
					} else {
						document.getElementById("overlayvediofiletype").innerHTML = "";
					}
				};

				function overlay_vedioduration() {
					let overlayVideo_duration = document.getElementById('videoduration').value;
					if (overlayVideo_duration == "") {
						document.getElementById("overlayvediodurationerrors").innerHTML = `<?php echo $GLOBALS['enter_the_video_duration']; ?>`;
					} else {
						document.getElementById("overlayvediodurationerrors").innerHTML = "";
					}
				};

				function overlayrtmserverurl() {
					let overlayRTMP_serverURL = document.getElementById('url').value;
					if (overlayRTMP_serverURL == "") {
						document.getElementById("overlayrtmerrors").innerHTML = `<?php echo $GLOBALS['strBanner_RTMSserver_URL_validation']; ?>`;
					} else {
						document.getElementById("overlayrtmerrors").innerHTML = "";
					}
				};

				destinationUrlValidation = () => {
					let getUrl = document.getElementById('destination_url').value;

					if (getUrl == "") {
						document.getElementById("error_destinationURL").innerHTML = `<?php echo $GLOBALS['enter_destination_url']; ?>`;
					} else if (pattern.test(getUrl)) {
						document.getElementById("error_destinationURL").innerHTML = "";
						return true;
					} else {
						document.getElementById("error_destinationURL").innerHTML = `<?php echo $GLOBALS['enter_valid_url']; ?>`;
						return false;
					}
				};

				inlineDestinationUrlValidation = () => {
					let getUrl = document.getElementById('overlay_destinationURL').value;

					if (getUrl == "") {
						document.getElementById("error_inlineDestinationURL").innerHTML = `<?php echo $GLOBALS['enter_destination_url']; ?>`;
					} else if (pattern.test(getUrl)) {
						document.getElementById("error_inlineDestinationURL").innerHTML = "";
						console.log("pass");
						return true;
					} else {
						document.getElementById("error_inlineDestinationURL").innerHTML = `<?php echo $GLOBALS['enter_valid_url']; ?>`;
						console.log("fail");
						return false;
					}
				};

				function salespersonval() {
					var salespersonname = document.getElementById('salespersonname').value;
					if (salespersonname == "") {
						document.getElementById("error_salesperson").innerHTML = `<?php echo $GLOBALS['strsalesperson_validation']; ?>`;
					} else {
						document.getElementById("error_salesperson").innerHTML = "";
					}
				};
			</script>
			<!-- Overlay -->
			<div class="layout-overlay layout-menu-toggle"></div>
		</div>
</body>

</html>