import React from "react";  
import { utils, writeFile } from 'xlsx';

const HomeComponent = () => {

    const body2 = [
        { firstname: "Edison", lastname: "Padilla", Company: "djax" },
        { firstname: "Cheila", lastname: "RodrRodrigez",Company: "apple" },
        { firstname: "Cheila", lastname: "Rodrigez",Company: "microsoft" },
        { firstname: "sath", lastname: "Rodrigez",  Company: "google" },
        { firstname: "Cheila", lastname: "Rodrigez",Company: "facebook" },
        { firstname: "dddss", lastname: "Rodrigez", Company: "twitter" },
        { firstname: "aqwert", lastname: "Rodrigez",Company: "instagram"},
      ];


    const handleExport = () => {
        const headings = [[
            'Movie',
            'Category',
            'Director',
        ]];
        const wb = utils.book_new();
        const ws = utils.json_to_sheet([]);
        utils.sheet_add_aoa(ws, headings);
        utils.sheet_add_json(ws, body2, { origin: 'A2' });
        var wscols = [
            {wch:10},
            {wch:30},
            {wch:10},
            {wpx: 100}
        ];
        ws['!cols'] = wscols;
        utils.book_append_sheet(wb, ws, 'Report');
        writeFile(wb, 'Movie Report.xlsx');
    }

    return (
        <>
            <div className="row mb-2 mt-5">
                <div className="col-sm-6 offset-3">
                    <div className="row">
                        <div className="col-md-6">
                            <button onClick={handleExport} className="btn btn-primary float-right">
                                Export <i className="fa fa-download"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div className="row">
                <div className="col-sm-6 offset-3">
                    <table className="table">
                        <thead>
                            <tr>
                                <th scope="col">Id</th>
                                <th scope="col">Movie</th>
                                <th scope="col">Category</th>
                                <th scope="col">Lastname</th>
                            </tr>
                        </thead>
                        <tbody> 
                                {
                                    body2.length
                                    ?
                                    body2.map((movie, index) => (
                                        <tr key={index}>
                                            <th scope="row">{ index + 1 }</th>
                                            <td>{ movie.firstname }</td>
                                            <td>{ movie.lastname }</td>
                                            <td>{ movie.Company }</td>
                                        </tr> 
                                    ))
                                    :
                                    <tr>
                                        <td colSpan="5" className="text-center">No Movies Found.</td>
                                    </tr> 
                                }
                        </tbody>
                    </table>
                </div>
            </div>
        </>

    );
};

export default HomeComponent;