import React from "react";
import ExcelJS from 'exceljs'

const Exceljs = () => {

    const body2 = [
        { id: 1, firstname: "Edison", lastname: "Padilla", Company: "djax" },
        { id: 2, firstname: "Cheila", lastname: "RodrRodrigez", Company: "apple" },
        { id: 3, firstname: "Cheila", lastname: "Rodrigez", Company: "microsoft" },
        { id: 4, firstname: "sath", lastname: "Rodrigez", Company: "google" },
        { id: 5, firstname: "Cheila", lastname: "Rodrigez", Company: "facebook" },
        { id: 6, firstname: "dddss", lastname: "Rodrigez", Company: "twitter" },
        { id: 7, firstname: "aqwert", lastname: "Rodrigez", Company: "instagram" },
    ];

    const handleExport = () => {
        const workbook = new ExcelJS.Workbook();
        const sheet = workbook.addWorksheet("My sheet");
        sheet.properties.defaultRowHeight = 40;
        sheet.getCell("A1").font = { family: 4, size: 14, bold: true };
        sheet.getCell("A2").font = { family: 4, size: 14, bold: true };
        sheet.getCell("A3").font = { family: 4, size: 14, bold: true };
        // sheet.addRow({id: 2, name: 'Jane Doe', dob: new Date(1965,1,7)});
        // sheet.getRow(1).border={
        //     top: { style: 'thick',color: { argb: 'darkblue'}},
        //     bottom: { style: 'thick',color: { argb: 'darkblue'}},
        //     left: { style: 'thick',color: { argb: 'darkblue'}},
        //     right: { style: 'thick',color: { argb: 'darkblue'}}
        // }
        

        // body2.map((data)=>{
        //     sheet.addRow({
        //         id: data.id,
        //         movie: data.firstname,
        //         category: data.lastname,
        //         lastName: data.Company
        //     })
        // })
        
        sheet.addTable({
            name: 'MyTable',
            ref: 'A5',
            headerRow: true,
            // totalsRow: true,
            style: {
                // theme: 'TableStyleDark3',
                showRowStripes: true,
                width: '20'
            },
            columns: [
                { name: 'id', filterButton: false },
                { name: 'Movie', filterButton: false },
                { name: 'category', filterButton: false },
                { name: 'LastName', filterButton: false },
            ],
            rows: [
                [1, "Edison", "Padilla", "djax"],
                [2, "Cheila", "RodrRodrigez", "apple"],
                [3, "Cheila", "Rodrigez", "microsoft"],
                [4, "sath", "Rodrigez", "google"],
                [5, "Cheila", "Rodrigez", "facebook"],
                [6, "dddss", "Rodrigez", "twitter"],
                [7, "aqwert", "Rodrigez", "instagram"],
            ],
        });
        // sheet.mergeCells('A1:B1');

        // sheet.getRow(1).fill = {
        //     type: "pattern",
        //     pattern: 'solid',
        //     fgColor: { argb:'FF0' }
        // }
        // sheet.getCell('A1').fill = {
        //     type: "pattern",
        //     pattern: 'solid',
        //     width: '15',
        //     fgColor: { argb: 'FF949494' }
        // }
        sheet.eachRow(function(row, rowNumber){
            row.eachCell( function(cell, colNumber){
                if(cell.value && cell.value.hyperlink)
                    row.getCell(colNumber).font = {color: {argb: "004e47cc"}};
            });
        })
        sheet.getCell('A1').value = 'publisher: ';
        sheet.getCell('C1').value = 'Sathish>>(Master)';
        sheet.getCell('A2').value = 'Invoice amount';
        sheet.getCell('C2').value = '$12,000'
        sheet.getCell('A3').value = 'Invoice Period'
        sheet.getCell('C3').value = 'April 2023'
        sheet.getRow(8).commit();
        //  sheet.columns = [
        //     {
        //         header: "id",
        //         key:"id",
        //         width:"10"
        //     },
        //     {
        //         header: "movie",
        //         key:"movie",
        //         width:"10"
        //     },
        //     {
        //         header: "Category",
        //         key:"category",
        //         width:"15"
        //     },
        //     {
        //         header: "LastName",
        //         key:"lastName",
        //         width:"10"
        //     }
        // ];
        

        workbook.xlsx.writeBuffer().then(data => {
            const blob = new Blob([data], {
                type: "application/vnd.openxmlformats-officedocument.spreadsheet.sheet",
            });
            const url = window.URL.createObjectURL(blob);
            const anchor = document.createElement('a');
            anchor.href = url;
            anchor.download = 'user.xlsx';
            anchor.click();
            window.URL.revokeObjectURL(url)
        })
    }


    return (
        <>
            <div className="row mb-2 mt-5">
                <div className="col-sm-6 offset-3">
                    <div className="row">
                        <div className="col-md-6">
                            <button onClick={handleExport} className="btn btn-primary float-right">
                                Export <i className="fa fa-download"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div className="row">
                <div className="col-sm-6 offset-3">
                    <table className="table">
                        <thead>
                            <tr>
                                <th scope="col">Id</th>
                                <th scope="col">Movie</th>
                                <th scope="col">Category</th>
                                <th scope="col">Lastname</th>
                            </tr>
                        </thead>
                        <tbody>
                            {
                                body2.length
                                    ?
                                    body2.map((movie, index) => (
                                        <tr key={index}>
                                            <th scope="row">{movie.id}</th>
                                            <td>{movie.firstname}</td>
                                            <td>{movie.lastname}</td>
                                            <td>{movie.Company}</td>
                                        </tr>
                                    ))
                                    :
                                    <tr>
                                        <td colSpan="5" className="text-center">No Movies Found.</td>
                                    </tr>
                            }
                        </tbody>
                    </table>
                </div>
            </div>
        </>

    );
};

export default Exceljs;