import React from "react";
import jsPDF from "jspdf";
import "jspdf-autotable";
import './App.css';
import { downloadExcel } from "react-export-table-to-excel";
import Exportxlsx from './components/Exportxlsx'
import Exceljs from "./components/Exceljs";
const App = () => {
  const header = ["Firstname", "Lastname","Company"];
 
  const body2 = [
    { firstname: "Edison", lastname: "Padilla", Company: "djax" },
    { firstname: "Cheila", lastname: "Rodrigez",Company: "apple" },
    { firstname: "Cheila", lastname: "Rodrigez",Company: "microsoft" },
    { firstname: "sath", lastname: "Rodrigez",  Company: "google" },
    { firstname: "Cheila", lastname: "Rodrigez",Company: "facebook" },
    { firstname: "dddss", lastname: "Rodrigez", Company: "twitter" },
    { firstname: "aqwert", lastname: "Rodrigez",Company: "instagram"},
  ];

  // const dataFirstname = body2.map((datas)=> [datas.firstname])

  function handleDownloadExcel() {
    downloadExcel({
      fileName: "user",
      sheet: "user",
      tablePayload: {
        header,
        // accept two different data structures
        body: body2
      },
    });
  }

 const exportPDF = () => {

    const title = "My Report";
    const headers = [["FIRSTNAME", "LASTNAME","COMPANY","EXPERIENCE","CATEGORY","HOBBIES","STATUS","AGE"]];

    const data =body2.map(elt=> [elt.firstname, elt.lastname,elt.Company,
                                elt.experience, elt.category, elt.hobbies,elt.status, elt.age]);
    let content = {
      startY: 50,
      head: headers,
      headStyles :{fillColor : [124, 95, 240],overflow: 'visible'},
      body: data,
      tableWidth: 'auto',
      columnWidth: 'wrap',
      columnStyles: {
        0: {cellWidth: 80},
        1: {cellWidth: 80},
        2: {cellWidth: 80},      },
      styles: { overflow: 'linebreak',
                columnWidth: 'wrap',
                fontSize: 10,
                cellPadding: 8,
                overflowColumns: 'linebreak'
               },
    };
     const unit = "pt";
    const size = "A4"; // Use A1, A2, A3 or A4
    const orientation = "portrait"; // portrait or landscape
    const marginLeft = 40;
    const doc = new jsPDF(orientation, unit, size);
    doc.setFontSize(15);

    doc.text(title, marginLeft, 40);
    // doc.addImage(myImage, 'JPEG', 10, 30, 150, 76);
    doc.autoTable(content);
    doc.save("report.pdf")
  }

  return (
    <div>
      {/* <Exportxlsx/> */}
      <Exceljs/>
      {/* <div className="table-responsive">
        <table className="table">
          <thead>
            <tr>
              <th>Period</th>
              <th>Description</th>
              <th>Company</th>
            </tr>
          </thead>
          <tbody>
            {body2.map((product, key) => (
              <tr key={key}>
                <td>{product.firstname}</td>
                <td>{product.lastname}</td>
                <td>{product.Company}</td>
              </tr>
            ))}
          </tbody>
        </table>
      </div>
      <div className='mb-3 float-right'>
        <button variant="contained" color="primary"
          className="caret btn-sm mr-10 "
          onClick={handleDownloadExcel}>
          Export to Excel
        </button>
        <button variant="contained" color="primary"
          className="caret btn-sm mr-10 "
          onClick={() => exportPDF()}>
          Export to Pdf
        </button>
      </div> */}
    </div>
  );
};

export default App;