<?php

/*ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);*/


require_once MAX_PATH . '/lib/OA.php';
require_once MAX_PATH . '/lib/max/Plugin/Common.php';
require_once LIB_PATH . '/Extension/bannerTypeHtml/bannerTypeHtml.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';

if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

class Plugins_BannerTypeHTML_InbannerVideo_Inbanner extends Plugins_BannerTypeHTML
{
    /**
     * Return type of plugin
     *
     * @return string A string describing the type of plugin.
     */
     
    function getStorageType()
    {
        return 'html';
    }

    /**
     * Return the media (content) type
     *
     */
    function getContentType()
    {
        return 'html';
    }
     
    function getOptionDescription()
    {
        return $this->translate("In-Banner Video Ad");
    }

    function validateForm(&$form)
    {
        return true;
    }

    function processForm($insert, $bannerid, $aFields , $aVariables)
    {
        $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
        $oDbh = OA_DB::singleton();

        $rowParam = ($aVariables['parameters'] != '') ? unserialize($aVariables['parameters']) : '';

        $img_type = 'web';

        //~ $aVariables['storagetype'] = 'html' ;
        $bg_img = array();
        $thumb_img = array();
        if (!empty($_FILES['bg_image']) && $_FILES['bg_image']['size'] > 0) { //TODO refactor upload to be a valid quickform elem
            $oFile = OA_Creative_File::factoryUploadedFile('bg_image');
            checkForErrorFileUploaded($oFile);
            $oFile->store($img_type);
            $aFile = $oFile->getFileDetails();
            if (!empty($aFile)) {
                $bg_img['filename']      = $aFile['filename'];
                $bg_img['contenttype']   = $aFile['contenttype'];
                $bg_img['width']         = $aFile['width'];
                $bg_img['height']        = $aFile['height'];
                $bg_img['pluginversion'] = $aFile['pluginversion'];
                $editSwf                 = $aFile['editswf'];
            }

            
            // Delete old file for this banner
            if (!empty($_FILES['bg_image']) && !empty($rowParam) && ($rowParam['bg_image'] != $aFile['filename'])) {
                DataObjects_Banners::deleteBannerFile($img_type, $rowParam['bg_image']);
            }
        }
        
        if (!empty($_FILES['thumbnail_image']) && $_FILES['thumbnail_image']['size'] > 0) { //TODO refactor upload to be a valid quickform elem
            $oFile = OA_Creative_File::factoryUploadedFile('thumbnail_image');
            checkForErrorFileUploaded($oFile);
            $oFile->store($img_type);
            $aFile1 = $oFile->getFileDetails();
            if (!empty($aFile)) {
                $thumb_img['filename']      = $aFile1['filename'];
                $thumb_img['contenttype']   = $aFile1['contenttype'];
                $thumb_img['width']         = $aFile1['width'];
                $thumb_img['height']        = $aFile1['height'];
                $thumb_img['pluginversion'] = $aFile1['pluginversion'];
                $editSwf                     = $aFile1['editswf'];
            }
            
            // Delete old file for this banner
            if (!empty($rowParam) && !empty($_FILES['thumbnail_image']) && ($rowParam['thumbnail_image'] != $aFile1['filename'])) {
                DataObjects_Banners::deleteBannerFile($img_type, $rowParam['thumbnail_image']);
            }
        }

        $bg_img = ($bg_img['filename'] == '') ? $_POST['bg_Img'] : $bg_img['filename'];
        $thumbnail_image = ($thumb_img['filename'] == '') ? $_POST['thumbnail_Img'] : $thumb_img['filename'];
        $inlinefields = array(
            'video_url'         => $_POST['video_url'],
            'skip'              => $_POST['skip'],
            'bg_image'          => $bg_img,
            'thumbnail_image'   => $thumbnail_image,
            'destination_url'   => $_POST['destination_url'],
            'extension_type'    => $_POST['extension_type']
            // 'external_wrapper'  => $_POST['external_wrapper'],
        );


        
        $aVariables['parameters'] = serialize($inlinefields);
        

        // if(!empty($params) || $_POST['destination_url']){
            $query = "UPDATE {$table_prefix}banners SET `parameters` = '".serialize($inlinefields)."', `url` ='".$_POST['destination_url']."' WHERE bannerid = {$bannerid}";
            // echo $query;die();
            $oDbh->exec($query);
        // }else{
            // OA_Dal_Delivery_query("UPDATE {$table_prefix}banners SET `parameters` = '".$params."', `url` ='".$_POST['destination_url']."' WHERE bannerid = {$bannerid}") OR die('sql_err');
        // }
        
        
        $doBanners = OA_Dal::factoryDO('banners');
        
        // Get existing banner details
        if (!empty($bannerid)) {
            if ($doBanners->get($bannerid)) {
                $row = $doBanners->toArray();
            }
        }
        
        
        return true;
    }
     
    function preprocessForm($insert, $bannerid, &$aFields, &$aVariables)
    {
        return true;
    }
    
    function buildForm(&$form, &$row)
    {
        //FETCH VALUE 
        $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
        
        $array = OA_Dal_Delivery_query("SELECT parameters FROM {$table_prefix}banners WHERE bannerid ='".$row['bannerid']."' ");
        $values1 = OA_Dal_Delivery_fetchAssoc($array);
        
        if(empty($values1) || $values1['parameters'] == '' ){
            $values = '';
        }else{
            $values = unserialize($values1['parameters']);
        }
        /*$header = $form->createElement('header', 'header_b_inbanner', 'Create an In-banner video Ad');
        $header->setAttribute('icon', 'icon-banner-url.gif');
        $form->addElement($header);*/

        $form->addElement('header', 'header_b_display', 'Banner display');
        //INBANNER VIDEO 
        $form->addElement('text', 'video_url', 'Video URL');

        $extension_type = array("MP4" => "MP4","WEBM" => "WEBM","HLS" => "HLS");
        $form->addElement('select', 'extension_type','Extension Type',$extension_type); 
        $form->addElement('text', 'skip', 'Skip (In Secs.)', array("placeholder"=> "00:00:00"));
        
        $backg_img = explode(".", $values['bg_image']);
        $front_image = _getContentTypeIconImageName($backg_img[1]);
        $front_size = _getBannerSizeText($back_img[1], $values['bg_image']);   
        
        $thumbnail_img = explode(".", $values['thumbnail_image']);       
        $front_image1 = _getContentTypeIconImageName($thumbnail_img[1]);
        $front_size1 = _getBannerSizeText($thumbnail_img[1], $values['thumbnail_image']); 
        
        addUploadGroup($form, $row,
            array(
                'uploadName' => 'bg_image',
                'radioName' => 'replacebg_image',
                'imageName'  => $front_image,
                'fileName'  => $values['bg_image'],
                'fileSize'  => $front_size,
                'newLabel'  => "Background Image",
                'updateLabel'  => "Do you wish to keep your existing <b>Background Image</b>, or do you want to upload another? ",
                'handleSWF' => true
              )
        );

        addUploadGroup($form, $row,
            array(
                'uploadName' => 'thumbnail_image',
                'radioName' => 'replacethumbnail_image',
                'imageName'  => $front_image1,
                'fileName'  => $values['thumbnail_image'],
                'fileSize'  => $front_size1,
                'newLabel'  => "Thumbnail Image",
                'updateLabel'  => "Do you wish to keep your existing <b>Thumbnail Image</b>, or do you want to upload another? ",
                'handleSWF' => true
              )
        );
        $form->addElement('text', 'destination_url',"Destination URL");
        
        // $form->addElement('textarea', 'external_wrapper', 'Third Party Wrapper');
        
        

        
        $sizeG['width'] = $form->createElement('text', 'width', $GLOBALS['strWidth'].":");
        $sizeG['width']->setAttribute('onChange', 'oa_sizeChangeUpdateMessage("warning_change_banner_size");');
        $sizeG['width']->setSize(5);

        $sizeG['height'] = $form->createElement('text', 'height', $GLOBALS['strHeight'].":");
        $sizeG['height']->setAttribute('onChange', 'oa_sizeChangeUpdateMessage("warning_change_banner_size");');
        $sizeG['height']->setSize(5);

        $form->addGroup($sizeG, 'size', $GLOBALS['strSize'], "&nbsp;", false);
        //Inbanner Video - Ends

        $form->addElement('header', 'header_b_links', "Banner link");
        
        
        $form->addElement('text', 'tp_tag', 'Third Party Tags (optional)',$tp_tag);
        
        
        //~DEFAULT VALUES
        $form->setDefaults(array(video_url => $values['video_url'])); 
        $form->setDefaults(array(destination_url => $values['destination_url'])); 
        // $form->setDefaults(array(external_wrapper => $values['external_wrapper']));
                
        $form->setDefaults(array(skip => $values['skip'])); 
        $form->setDefaults(array(height => $values['height']));
        $form->setDefaults(array(width => $values['width']));
        $form->setDefaults(array(bg_image => $values['bg_image']));
        $form->setDefaults(array(thumbnail_image => $values['thumbnail_image']));
        
        
        //~UNIQUE BANNER FOR BANNER LINK
        $form->addElement('hidden', 'ext_bannertype', $this->getComponentIdentifier());
        $form->addElement('hidden', 'bg_Img', $values['bg_image']);
        $form->addElement('hidden', 'thumbnail_Img', $values['thumbnail_image']);

        $form->addRule('video_url', $urlRequiredMsg, 'required');
        
        $translation = new OX_Translation();
        $widthRequiredRule = array($translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strWidth'])), 'required');
        $widthPositiveRule = array($translation->translate($GLOBALS['strXGreaterThanZeroField'], array($GLOBALS['strWidth'])), 'min', 1);
        $heightRequiredRule = array($translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strHeight'])), 'required');
        $heightPositiveRule = array($translation->translate($GLOBALS['strXGreaterThanZeroField'], array($GLOBALS['strHeight'])), 'min', 1);
        $numericRule = array($GLOBALS['strNumericField'] , 'numeric');
        
        $form->addGroupRule('size', array(
                'width' => array($widthRequiredRule, $numericRule, $widthPositiveRule),
                'height' => array($heightRequiredRule, $numericRule, $heightPositiveRule)));
    }

    
    function checkForErrorFileUploaded($oFile)
    {
        if (PEAR::isError($oFile)) {
        die('here');

            phpAds_PageHeader(1);
            phpAds_Die($GLOBALS['strErrorOccurred'], htmlspecialchars($oFile->getMessage()). "<br>Please make sure you selected a valid file.");
        }
    }

        
    function _getContentTypeIconImageName($contentType)
    {
        $imageName = '';
        if (empty($contentType)) {
            return $imageName;
        }

        switch ($contentType) {
            case 'swf':
            case 'dcr':  $imageName = 'icon-filetype-swf.gif'; break;
            case 'jpeg': $imageName = 'icon-filetype-jpg.gif'; break;
            case 'gif':  $imageName = 'icon-filetype-gif.gif'; break;
            case 'png':  $imageName = 'icon-filetype-png.gif'; break;
            case 'rpm':  $imageName = 'icon-filetype-rpm.gif'; break;
            case 'mov':  $imageName = 'icon-filetype-mov.gif'; break;
            default:     $imageName = 'icon-banner-stored.gif'; break;
        }

        return $imageName;
    }


    function _getBannerSizeText($type, $filename)
    {
        $size = phpAds_ImageSize($type, $filename);
        if (round($size / 1024) == 0) {
             $size = $size." bytes";
        }
        else {
             $size = round($size / 1024)." Kb";
        }

        return $size;
    }

    
}
