<?php
include('session.php');
include('../config.php'); ?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title><?php echo $projecttitle; ?> - Zone | Report </title>

    <meta name="description" content="" />
    <style>
    .loader{
        display: none;
        position: fixed;
        width: 100%;
        height: 100%;
        top: 0;
        left: 0;
        z-index: 999;
        background: rgba(255,255,255,0.8) url("../assets/img/loader.gif") center no-repeat;
    }
    h5 {
            position: relative;
            left: 250%;
        }
        /* Close Button */
	   .dataTables_wrapper .dataTables_filter input:not(:valid):not(:focus){
	   box-shadow: 0 0 5px #fff!important;
		}
		.dataTables_wrapper .dataTables_filter input::-webkit-search-cancel-button {
		  -webkit-appearance: none!important;
		}
		.dataTables_wrapper .dataTables_filter button{
		  visibility: hidden;
		  outline: none;
		}
		.dataTables_wrapper .dataTables_filter input:valid ~ button{
		  visibility: visible;
		}
		
		button.close 
		{
		padding: 0;
		background-color: transparent;
		border: 0;
		-webkit-appearance: none;
		-moz-appearance: none;
		appearance: none;
		}
		.close {
		float: right;
		font-size: 1.5rem;
		font-weight: 700;
		line-height: 1;
		color: #000;
		text-shadow: 0 1px 0 #fff;
		opacity: .5;
	}
    </style>
    <?php include('head.php'); ?>
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
</head>

<body onload="onChangeDetails()">
    <div class="loader"></div>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->

            <?php include('sidebar.php'); ?>

            <!-- / Menu -->
            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card mt-3 mb-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-9">
                                        <p class="h4">Zone Report</p>
                                        <input type='hidden' name="campaignid" id="campaignid" value="<?php echo $_GET['campaignid']; ?>"/>
                                        <input type='hidden' id="startDate" value="<?php echo $_GET['start_date']; ?>"/>
                                        <input type='hidden' id="endDate" value="<?php echo $_GET['end_date']; ?>"/>
                                    </div>
                                    <div class="col-3">
                                        <select id="getBanner" name="allfilter" class="form-select text-dark"
                                            aria-label="Default select example" onchange="onChangeDetails(this.value)">
                                            <option value="Today" selected>Today</option>
                                            <option value="Yesterday">Yesterday</option>
                                            <option value="Last 7 days">Last 7 days</option>
                                            <option value="Last 30 days">Last 30 days</option>
                                            <option value="This Month">This Month</option>
                                            <option value="Last Month">Last Month</option>
                                            <option value='All Statistics'>All Statistics</option>
                                            <option value="Custom">Custom</option>
                                        </select>
                                        <input style="display: none; width: 95%; margin-left:3%" id="daterange" name="daterange" class='mt-2'/>
                                    </div>
                                </div>

                                <div>
                                    <div class="table-responsive text-nowrap mt-4">
                                        <table id="bannerrep" class="table table-striped">
                                            <thead>
                                            <tr class="text-dark">
                                                    <th class="text-dark">Name</th>
                                                    <th class="text-dark text-center">Impression</th>
                                                    <th class="text-dark text-center">Clicks</th>
                                                    <th class="text-dark text-center">Conversion</th>
                                                    <th class="text-dark text-center">CTR %</th>
                                                    <th class="text-dark text-start">EARNINGS</th>
                                                    <th class="text-dark text-start">eCPM</th>
                                                </tr>
                                            </thead>
                                            <tbody id="ban_table"></tbody>
                                            <!--<tfoot>
												<tr>
													<th>Total</th>
													<th></th>
													<th></th>
													<th></th>
													<th></th>
													<th></th>
													<th></th>
												</tr>
											</tfoot>-->
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- / Content -->

                    <!-- Footer -->
                    <?php include('footer.php'); ?>
                    <!-- / Footer -->
                    <!--<script type="text/javascript" src="https://cdn.jsdelivr.net/jquery/latest/jquery.min.js"></script>-->
                    <script type="text/javascript"
                        src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
                    <script type="text/javascript"
                        src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
                    <script>
                        var live_URL = '<?php echo $apistatpath; ?>';
                        var token = 'Bearer '+ document.getElementById('token').value;
                        var affiliate_id = document.getElementById('affiliateid').value;
                        var domain_url = live_URL + '/get_publisher_zone_statistics/';
                        var allZone_url = live_URL + '/get_all_publisher_zone_statistics/'+affiliate_id;
                        

                        function onChangeDetails() {
                            $(".loader").show();
                            let date = new Date();
                            let getSelectedDay = document.getElementById('getBanner').value;

                            switch(getSelectedDay) {
                                case 'Today':
                                    $("#daterange").css("display", "none");
                                    let v3 = JSON.stringify(date);
                                    v3 = v3.slice(1, 11);
                                    var start_date = v3, end_date = v3;
                                    getBannerDate(start_date, end_date);
                                break;
                                case 'Yesterday' :
                                    $("#daterange").css("display", "none");
                                    let current_date = date.setDate(date.getDate() - 1);
                                    const get_date = new Date(date);
                                    let yesterday_date = JSON.stringify(get_date);
                                    yesterday_date = yesterday_date.slice(1, 11);
                                    getBannerDate(yesterday_date, yesterday_date);
                                break;
                                case 'Last 7 days':
                                    $("#daterange").css("display", "none");
                                    let calculate_7dyas = date.setDate(date.getDate() - 7);
                                    let start_7Days = new Date(calculate_7dyas);
                                    let first_day = JSON.stringify(start_7Days);
                                    first_day = first_day.slice(1, 11);
    
                                    let todayDate = new Date();
                                    let current_7Dyas = todayDate.setDate(todayDate.getDate() - 1);
                                    let last_7Days = new Date(todayDate);
                                    let date_end = JSON.stringify(last_7Days);
                                    date_end = date_end.slice(1, 11);
                                    getBannerDate(first_day, date_end);
                                break;
                                case 'Last 30 days':
                                    $("#daterange").css("display", "none");
                                    let calculate_30dyas = date.setDate(date.getDate() - 30);
                                    let start_30Days = new Date(calculate_30dyas);
                                    var first_30Days = JSON.stringify(start_30Days);
                                    first_30Days = first_30Days.slice(1, 11);
    
                                    let today_Date = new Date();
                                    let current_30Dyas = today_Date.setDate(today_Date.getDate() - 1);
                                    let last_30Days = new Date(today_Date);
                                    let final_30Days = JSON.stringify(last_30Days);
                                    final_30Days = final_30Days.slice(1, 11);
                                    getBannerDate(first_30Days, final_30Days);
                                break;
                                case 'Last Month': 
                                    $("#daterange").css("display", "none");
                                    var prevMonthLastDate = new Date(date.getFullYear(), date.getMonth(), 0);
                                    var prevMonthFirstDate = new Date(date.getFullYear() - (date.getMonth() > 0 ? 0 : 1), (date.getMonth() - 1 + 12) % 12, 1);
                                    var formatDateComponent = function (dateComponent) {
                                        return (dateComponent < 10 ? '0' : '') + dateComponent;
                                    }
                                    var formatDate = function (date) {
                                        return date.getFullYear() + "-" + formatDateComponent(date.getMonth() + 1) + "-" + formatDateComponent(date.getDate())
                                    };
                                    getBannerDate(formatDate(prevMonthFirstDate), formatDate(prevMonthLastDate));
                                break;
                                case 'This Month':
                                    $("#daterange").css("display", "none");
                                    let firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                                    let cYear = firstDay.getFullYear(), cMonth = firstDay.getMonth() + 1, cDate = firstDay.getDate();
                                    let start_thisMonth = cYear + "-" + cMonth + "-" + cDate;
    
                                    let lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);
                                    let year = lastDay.getFullYear(), month = lastDay.getMonth() + 1, day = lastDay.getDate();
                                    let end_thisMonth = year + "-" + month + "-" + day;
                                    getBannerDate(start_thisMonth, end_thisMonth);
                                break;
                                case 'All Statistics':
                                    $("#daterange").css("display", "none"); 
                                    // var value =0;
                                    getBannerDate(start_holeDate =0, end_holeDate =0);
                                break;
                                case 'Custom':
                                    $("#daterange").css("display", "block");
                                    $(".loader").hide();
                                    $(document).on('change', '#daterange', function () {
                                        var dates = $('#daterange').val();
                                        const daterange = dates.split("-");
                                    });
                                    $(function () {
                                        $('input[name="daterange"]').daterangepicker({
                                            opens: 'left',
                                            locale: {
                                                format: 'DD/MMM/YYYY'
                                           },
                                        }, function (start, end, label) {
                                            // console.log("A new date selection was made: " + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
                                            getBannerDate(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));
                                        })
                                    })
                                break;                         
                            };
                        };

                        function getBannerDate(start_date, end_date) {

                            let zoneReport = domain_url + start_date + ' 00:00:00,' + end_date + ' 23:59:59,'+affiliate_id;
                            $.ajax({
                                    url: start_date ==0 && end_date ==0?allZone_url:zoneReport,
                                    type: 'GET',
                                    beforeSend: function (xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: {},
                                    success: function (data) {
                                        $(".loader").hide();
                                        if (data.msg == 'No Stats Available') {
                                            $('#bannerrep').DataTable({
                                                ordering: false,
                                                destroy: true,
                                                responsive: true,
                                                bPaginate: false,
                                                bInfo: false,
                                                data:[],
                                                searching: false,
                                                oLanguage: {
                                                    sEmptyTable:"No Data Found"
                                                }
                                            });
                                        }
                                        else {
                                            $('#bannerrep').DataTable({
                                                ordering: true,
                                                destroy: true,
                                                data: data,
                                                columns: [
                                                    { data: 'zonename' },
                                                    { data: 'impressions', className: "text-center" },
                                                    { data: 'clicks', className: "text-center" },
                                                    { data: 'conversions', className: "text-center" },
                                                    { data: 'ctr', className: "text-start"},
                                                    { data: 'revenue', className: "text-start", render: function(data, type, row, meta) {
                                                        return row.revenue == null?"0.00":row.revenue;
                                                    }},
                                                    { data: 'ecpm', className: "text-start", render: function(data, type, row, meta) {
                                                        return row.ecpm == null?"0.00":row.ecpm;
                                                    } },
                                                ],
                                                "footerCallback": function ( row, data, start, end, display ) {
                                                var api = this.api(), data;
                                    
                                                // converting to interger to find total
                                                var intVal = function ( i ) {
                                                    return typeof i === 'string' ?
                                                        i.replace(/[\$,]/g, '')*1 :
                                                        typeof i === 'number' ?i : 0;
                                                };
                                             
                                                // computing column Total of the complete result 
                                                var impressions = api.column( 1 ).data().reduce( function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0 );
                                                    
                                                var clicks = api.column( 2 ).data().reduce( function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0 );
                                                    
                                                var conversions = api.column( 3 ).data().reduce( function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0 );
                                                    
                                                var ctr = api.column( 4 ).data().reduce( function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0 );
                                                    
                                                var revenue = api.column( 5 ).data().reduce( function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0 );

                                                var ecpm = api.column( 6 ).data().reduce( function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0 );
                                                
                                                
                                                    
                                                // Update footer by showing the total with the reference of the column index 
                                            $( api.column( 0 ).footer() ).html('Total');
                                                $( api.column( 1 ).footer() ).html(impressions);
                                                $( api.column( 2 ).footer() ).html(clicks);
                                                $( api.column( 3 ).footer() ).html(conversions);
                                                $( api.column( 4 ).footer() ).html(ctr.toFixed(2));
                                                $( api.column( 5 ).footer() ).html(revenue.toFixed(2));
                                                $( api.column( 6 ).footer() ).html(ecpm.toFixed(2));
                                            },
											initComplete: function(settings) 
											{
											    //settings.nTable.id --> Get table ID
											    $('#'+settings.nTable.id+'_filter input').wrap(`
												    <div class="d-inline-flex position-relative"></div>
											  ` ).after(`
													<button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
													  <span aria-hidden="true">&times;</span>
													</button>
											   `).attr('required','required').attr('title','Search');
                                              
											   // Click Event on Clear button
											    $(document).on('click', '#'+settings.nTable.id+'_filter button', function(){
												 $('#'+settings.nTable.id).DataTable({
												   "retrieve": true,
												  }).search('').draw(); // reDraw table
											    });
											}
                                            });
                                        }
                                    },
                                    error: function () { },
                                });
                        };
                    </script>

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>
        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
</body>
</html>