<?php
/*
 * 
 * File Created by DAC141
 * 
 */

/*--------------- Start of Advertiser Statistics ------------*/

// Get Advertiser campaign Statistics

$app->get('/get_advertiser_campaign_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them group by campaignid
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date ='';
		$end_date = '';
		if($client)
		{
	        $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			$sql="select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			h.ad_id as ad_id,
			b.bannerid as bannerid,
			b.description as bannername,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."'";



		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		
		$todos = $sth->fetchAll();
		
		if($todos)
		{
			if(!empty($todos[0]['ad_id']))
			{
				return $this->response->withJson($todos);
			}
			else{
				$response = array('response'=>'ok','msg'=>'No Stats Available');
				return $this->response->withJson($response);
			}
		}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
		return $this->response->withJson($response);
		}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));

// All Advertiser Campaign Statistics

$app->get('/get_all_dashboard_advertiser_campaign_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		if($client)
		{
			
			$sql="select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			h.ad_id as ad_id,
			b.bannerid as bannerid,
			b.description as bannername,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		
		$todos = $sth->fetchAll();

		if($todos)
		{
		if(!empty($todos[0]['ad_id']))
			{
				return $this->response->withJson($todos);
			}
			else{
				$response = array('response'=>'ok','msg'=>'No Stats Available');
				return $this->response->withJson($response);
			}
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});






//camp id Graph Statistics

$app->get('/get_campaignid_campaign_graph_statistics/[{start_date},{end_date},{campaign_id}]', function($request, $response, $args)
{
	// print_r(campaign_id);exit;
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$campaign_id = $args['campaign_id']; 
		echo "....hiiii...";
		print_r(campaign_id);exit;
		$stc = "select * from ".$table_prefix."banners where campaignid=:campaignid";
		$std = $this->db->prepare($stc);
		$std->bindParam("campaignid",$campaignid);
		$std->execute();
		$client = $std->fetchAll();
        $start_date ='';
		$end_date = '';
		if($client)
		{
		    $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			$sql="select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
			TIMESTAMP(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),0) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,0) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND cl.clientid = c.clientid
			AND c.clientid = :campaignid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by c.campaignid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":campaignid",$campaignid);

			$sth->execute();

			$todos = $sth->fetchAll();
			
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));




//Campaign  Graph Statistics

$app->get('/get_all_dashboard_banner_graph_statistics/[{bannerid}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$bannerid = $args['bannerid']; 

	
		$stc = "select * from ".$table_prefix."banners where bannerid=:bannerid";
		$std = $this->db->prepare($stc);
		$std->bindParam("bannerid",$bannerid);
		$std->execute();
		$campaigns = $std->fetchAll();

		if($campaigns)
		{	
			
			
			
			// print_r($end_date );
			$sql="select 
			cl.clientid as clientid,
			b.bannerid as bannerid,
			b.description as bannername,
			cl.clientname as clientname,
			CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
			TIMESTAMP(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),0) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,0) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			
			

			h.ad_id = b.bannerid
			
			AND cl.clientid = c.clientid
			AND c.campaignid = b.campaignid
			AND b.bannerid = :bannerid

			group by b.bannerid";
			
			
			// print_r($sql );

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":bannerid",$bannerid);
			// print_r($sth );exit;
			$sth->execute();

			$todos = $sth->fetchAll();
			
		
		// exit;
			
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});





//Campaign  Graph Statistics

$app->get('/get_dashboard_banner_graph_statistics/[{start_date},{end_date},{bannerid}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$bannerid = $args['bannerid']; 

// print_r($enddate);
	
		$stc = "select * from ".$table_prefix."banners where bannerid=:bannerid";
		$std = $this->db->prepare($stc);
		$std->bindParam("bannerid",$bannerid);
		$std->execute();
		$campaigns = $std->fetchAll();
        // echo "..campaigns ..";

		// print_r($campaigns );
		$start_date ='';
		$end_date = '';
		if($campaigns)
		{	
			$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			// print_r($end_date );
			$sql="select 
			cl.clientid as clientid,
			b.bannerid as bannerid,
			b.description as bannername,
			cl.clientname as clientname,
			CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
			TIMESTAMP(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),0) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,0) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			
			

			h.ad_id = b.bannerid
			
			AND cl.clientid = c.clientid
			AND c.campaignid = b.campaignid
			AND b.bannerid = :bannerid

			AND h.date_time between '".$start_date."'
			AND '".$end_date."'";
			
			// print_r($sql );

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":bannerid",$bannerid);
			// print_r($sth );exit;
			$sth->execute();

			$todos = $sth->fetchAll();
			
		
		// exit;
			
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid banner Id');
			return $this->response->withJson($response);

		}
  
}
 
});




//Campaign  Graph Statistics

$app->get('/get_all_dashboard_campaign_graph_statistics/[{campaign_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');	
		$campaign_id = $args['campaign_id']; 
	
		$stc = "select * from ".$table_prefix."campaigns where campaignid=:campaignid";
		$std = $this->db->prepare($stc);
		$std->bindParam("campaignid",$campaign_id);
		$std->execute();
		$campaigns = $std->fetchAll();
        
	
		if($campaigns)
		{	
			
			$sql="select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
			TIMESTAMP(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),0) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,0) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND cl.clientid = c.clientid
			AND c.campaignid = :campaignid
			group by c.campaignid";


			$sth = $this->db->prepare($sql);
			$sth->bindParam(":campaignid",$campaign_id);
			$sth->execute();
			$todos = $sth->fetchAll();		
			
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid campaign Id');
			return $this->response->withJson($response);

		}
  
}
 
});






//Campaign  Graph Statistics

$app->get('/get_dashboard_campaign_graph_statistics/[{start_date},{end_date},{campaign_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$campaign_id = $args['campaign_id']; 


	
		$stc = "select * from ".$table_prefix."campaigns where campaignid=:campaignid";
		$std = $this->db->prepare($stc);
		$std->bindParam("campaignid",$campaign_id);
		$std->execute();
		$campaigns = $std->fetchAll();
        
		$start_date ='';
		$end_date = '';
		if($campaigns)
		{	
			$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
					
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			// print_r($end_date );
			$sql="select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
			TIMESTAMP(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),0) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,0) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND cl.clientid = c.clientid
			AND c.campaignid = :campaignid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."'";		

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":campaignid",$campaign_id);
			$sth->execute();
			$todos = $sth->fetchAll();
	
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});






//Advertiser Graph Statistics

$app->get('/get_advertiser_campaign_graph_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
        $start_date ='';
		$end_date = '';
		if($client)
		{
		    $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();			
		
			$timezone = $TimeZoneRow[0]['timezone'];			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			$sql="select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
			TIMESTAMP(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),0) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,0) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by c.campaignid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);
			$sth->execute();
			$todos = $sth->fetchAll();
			
			
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));





//Advertiser All Graph Statistics

$app->get('/get_all_advertiser_campaign_graph_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
			
		$sql="select 
		cl.clientid as clientid,
		cl.clientname as clientname,
		CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
		TIMESTAMP(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.requests) as requests,
		round(sum(h.total_revenue),0) as revenue,
		
		round((sum(h.clicks)/sum(h.impressions)),0) * 100 as ctr,
		round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl 
		where
		h.ad_id = b.bannerid
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		group by c.campaignid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		$todos = $sth->fetchAll();
		/* $impressionsarr = array(); 
		$clicksarr = array(); 
		$conversionsarr = array(); 
		$revenuearr = array(); 
		$ctrarr = array(); 
		$ecpmarr = array(); 
		foreach($todos as $todorow => $imrow)
		{
		
		$impressionsarr[$todorow] = $imrow['impressions'];
		$clicksarr[$todorow] = $imrow['clicks'];
		$conversionsarr[$todorow] = $imrow['conversions'];
		$revenuearr[$todorow] = $imrow['revenue'];
		$ctrarr[$todorow] = $imrow['ctr'];
		$ecpmarr[$todorow] = $imrow['ecpm'];
		
		}
		$maximpressions = max($impressionsarr);
		$maxclicks = max($clicksarr);
		$maxconversions = max($conversionsarr);
		$maxrevenue = max($revenuearr);
		$maxctr = max($ctrarr);
		$maxecpm = max($ecpmarr);

		// find the key of the impression with the highest value
		$impression_key = array_search($maximpressions, $impressionsarr);
		$clicks_key = array_search($maxclicks, $clicksarr);
		$conversions_key = array_search($maxconversions, $conversionsarr);
		$revenue_key = array_search($maxrevenue, $revenuearr);
		$ctr_key = array_search($maxctr, $ctrarr);
		$ecpm_key = array_search($maxecpm, $ecpmarr);

		$impression_with_highest_value = $todos[$impression_key];
		$clicks_with_highest_value = $todos[$clicks_key];
		$conversions_with_highest_value = $todos[$conversions_key];
		$revenue_with_highest_value = $todos[$revenue_key];
		$ctr_with_highest_value = $todos[$ctr_key];
		$ecpm_with_highest_value = $todos[$ecpm_key];
        
		$impression = $impression_with_highest_value['impressions'];
		$clicks = $clicks_with_highest_value['clicks'];
		$conversions = $conversions_with_highest_value['conversions'];
		$revenue = $revenue_with_highest_value['revenue'];
		$ctr = $ctr_with_highest_value['ctr'];
		$ecpm = $ecpm_with_highest_value['ecpm'];
		 
		$todos[] = array("maximpression" => ($impression),
					"maxclicks" => ($clicks),
					"maxconversions" => ($conversions),
					"maxrevenue" => ($revenue),
					"maxctr" => ($ctr),
					"maxecpm" => ($ecpm));
					//print_r($data);
        //exit; */
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});




//Advertiser All Graph Statistics

$app->get('/get_all_campaign_graph_statistics/[{campaign_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$campaign_id = $args['campaign_id']; 
		print_r($campaign_id);
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$campaign_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
			
		$sql="select 
		cl.clientid as clientid,
		cl.clientname as clientname,
		CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
		TIMESTAMP(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.requests) as requests,
		round(sum(h.total_revenue),0) as revenue,
		
		round((sum(h.clicks)/sum(h.impressions)),0) * 100 as ctr,
		round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl 
		where
		h.ad_id = b.bannerid
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		group by c.campaignid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		$todos = $sth->fetchAll();
	
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});



// Top Banner Statistics

$app->get('/get_top_banner_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		$start_date ='';
		$end_date = '';
		if($client)
		{
		    $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			$sql="select 
			c.campaignname as campaignname,
			b.description as bannername,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as spend,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by b.bannerid ORDER BY spend DESC limit 5";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);

			$sth->execute();

			$todos = $sth->fetchAll();

			// echo "query";
			// print_r($todos);exit;

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));

// top campaign statistics

$app->get('/get_top_campaign_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		$start_date ='';
		$end_date = '';
		if($client)
		{
		    $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			$sql="select 
			c.campaignname as campaignname,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as spend,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by c.campaignid ORDER BY spend DESC limit 5";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		$todos = $sth->fetchAll();

		// echo "query";
		// print_r($todos);exit;

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));

//All Top Banner

$app->get('/get_all_top_website_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
			
			$sql="select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.pub_income),2) as spend,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.pub_income)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as websitesname,
			z.zoneid AS zoneid,
			z.zonename as zonename
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z,
			".$table_prefix."clients as cl
			where		
			p.affiliateid = z.affiliateid
			AND			
			z.zoneid = h.zone_id  			
			AND p.agencyid = cl.agencyid	
			AND cl.clientid = :advertiserid
			 group by p.affiliateid ORDER BY ctr DESC limit 5";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);
		$sth->execute();
		$todos = $sth->fetchAll();	

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});



$app->get('/get_top_website_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id']; 

		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 



		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
	
		$start_date ='';
		$end_date = '';
	

		if($client)
		{

			$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();		
		
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);			
			
			$sql="select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.pub_income),2) as spend,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.pub_income)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as websitesname,
			z.zoneid AS zoneid,
			z.zonename as zonename
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z,
			".$table_prefix."clients as cl
			where		
			z.affiliateid=p.affiliateid 
			AND			
			z.zoneid = h.zone_id  			
			AND p.agencyid = cl.agencyid	
			AND cl.clientid = :advertiserid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by p.affiliateid ORDER BY ctr DESC limit 5";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);		
			$sth->execute();	
			$todos = $sth->fetchAll();	
		

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});






//All Top Campaign 

$app->get('/get_all_top_campaign_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
			
		$sql="select 
		c.campaignname as campaignname,
		b.description as bannername,
        DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		round(sum(h.total_revenue),2) as spend,
		round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl 
		where
		h.ad_id = b.bannerid
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		group by c.campaignid ORDER BY spend DESC limit 5";
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		$todos = $sth->fetchAll();

		// echo "query";
		// print_r($todos);exit;

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});

//Campaign Report Statistics

$app->get('/get_advertiser_campaign_report_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them group by campaignid h.ad_id as ad_id,b.bannerid as bannerid,b.description as bannername,
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date ='';
		$end_date = '';
		if($client)
		{
			$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			$sql="select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by campaignid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);

			$sth->execute();

		    $todos = $sth->fetchAll();

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));

// All Advertiser Campaign Statistics

$app->get('/get_all_advertiser_campaign_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		if($client)
		{
			
			$sql="select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			h.ad_id as ad_id,
			b.bannerid as bannerid,
			b.description as bannername,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			group by b.campaignid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		
		$todos = $sth->fetchAll();

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});

//Advertiser Banner Statistics

$app->get('/get_advertiser_banner_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
		
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		
        $start_date ='';
		$end_date = '';
		if($client)
		{
	        $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			$sql="select 
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			b.description as bannername,
			cl.clientid as clientid,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl
			where
			h.ad_id = b.bannerid
			AND c.clientid = :advertiserid
			AND cl.clientid = c.clientid
			AND b.campaignid = c.campaignid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' GROUP BY ad_id";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));

//All Advertiser Banner Statistics

$app->get('/get_all_advertiser_banner_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix']; 
		$advertiser_id = $args['advertiser_id']; 
		
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
		$sql="select 
		h.ad_id as ad_id,
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		round(sum(h.total_revenue),2) as revenue,
		b.bannerid as bannerid,
		b.campaignid as campaignid,
		b.description as bannername,
		cl.clientid as clientid,		
		round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
		round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl
		where
		h.ad_id = b.bannerid
		AND c.clientid = :advertiserid
		AND cl.clientid = c.clientid
		AND b.campaignid = c.campaignid
		GROUP BY ad_id";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});

//Advertiser Campaignwise Banner Statistics

$app->get('/get_advertiser_campaignwise_banner_statistics/[{start_date},{end_date},{advertiser_id},{campaign_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
		$campaign_id = $args['campaign_id']; 
		
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date ='';
		$end_date = '';

		if($client)
		{
	        $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			$sql="select 
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			b.description as bannername,
			cl.clientid as clientid,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl
			where
			h.ad_id = b.bannerid
			AND c.clientid = :advertiserid
			AND c.campaignid = :campaignid
			AND cl.clientid = c.clientid
			AND b.campaignid = c.campaignid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' GROUP BY ad_id";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);
			$sth->bindParam(":campaignid",$campaign_id);

			$sth->execute();
			$todos = $sth->fetchAll();
			if($todos)
			{
			return $this->response->withJson($todos);
	       }else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	    }
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));

//Top Country

$app->get('/get_top_country_details/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them AND c.clientid = cl.clientid
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
     
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
		
		$stc = "select * from ".$table_prefix."campaigns where clientid=:clientid";
		$std = $this->db->prepare($stc);
		$std->bindParam("clientid",$advertiser_id);
		$std->execute();
		$campaign = $std->fetchAll();
        $start_date='';
        $end_date='';
		if($campaign)
		{
	        $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
	        
			$sql = "select 
			c.campaignname as campaignname,
			c.revenue as revenues,
			c.revenue_type as revenue_type,
			c.weight,
			b.description as bannername, 
			adh.country as country,
			TIMESTAMP(adh.date_time) as date_time,
			sum(adh.impressions) as impressions,
			sum(adh.clicks) as clicks,
			round((case when  c.revenue_type = 1 then adh.impressions*c.revenue/1000 
			when c.revenue_type = 2 then adh.clicks*c.revenue
			else adh.impressions*c.revenue
			end),2) as revenue,
			round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
			round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm		
			from
			" . $table_prefix . "stats_country as adh,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
			" . $table_prefix . "zones as z 
			where
			adh.creative_id=b.bannerid
			And z.zoneid = adh.zone_id
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND adh.creative_id >= 0
			AND DATE(adh.date_time) between '" . $start_date . "'
			AND '" . $end_date . "' group by adh.country ORDER BY revenue DESC limit 5";
			/* print_r($sql); limit 5
			exit; */
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);
			$sth->execute();
			$todos = $sth->fetchAll();
			
			$country_array = array("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");
		
			$data = array();
			
			for ($i = 0; $i < count($todos); $i++) {
		
				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue  = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
	
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = 0;
				}
				
				$icountry = '';				
				$icountrycode = '';

				if ($todos[$i]['country'] != "-") {
				    $icountrycode = $todos[$i]['country'] ? $todos[$i]['country'] : "";				    
					$icountry = $todos[$i]['country'] ? $country_array[$todos[$i]['country']]: "";
					
				} else {

					$todos[$i]['country'] = "Others";
				}
				
				//print_r($newArray);die();

				$data[] = array(
					"countryname" => ($icountry ? $icountry : 'Others'),
					"countrycode" => ($icountrycode ? $icountrycode : 'Others'),
					"campaignname" => ($todos[$i]['campaignname']) ? $todos[$i]['campaignname'] : '-',
					"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					"clicks" => $todos[$i]['clicks'],
					"revenue" => ($todos[$i]['revenue'] > 0) ? $todos[$i]['revenue']  : 0.00,
				);

				}

			if($data)
			{
				return $this->response->withJson($data);
			}else{
				$response = array('response'=>'ok','msg'=>'No Stats Available');
				return $this->response->withJson($response);
			}
		}
		else{
			$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
		}

		
}

  
})->add($container->get('datevalidation'));


//All Top Country

$app->get('/get_all_top_country_details/[{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
     
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id']; 
		
		$stc = "select * from ".$table_prefix."campaigns where clientid=:clientid";
		$std = $this->db->prepare($stc);
		$std->bindParam("clientid",$advertiser_id);
		$std->execute();
		$campaign = $std->fetchAll();

		if($campaign)
		{
		    $sql = "select 
			c.campaignname as campaignname,
			c.revenue as revenues,
			c.revenue_type as revenue_type,
			c.weight,
			b.description as bannername, 
			adh.country as country,
			TIMESTAMP(adh.date_time) as date_time,
			sum(adh.impressions) as impressions,
			sum(adh.clicks) as clicks,
			round((case when  c.revenue_type = 1 then adh.impressions*c.revenue/1000 
			when c.revenue_type = 2 then adh.clicks*c.revenue
			else adh.impressions*c.revenue
			end),2) as revenue,
			round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
			round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm		
			from
			" . $table_prefix . "stats_country as adh,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
			" . $table_prefix . "zones as z 
			where
			adh.creative_id=b.bannerid
			And z.zoneid = adh.zone_id
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND adh.creative_id >= 0
			group by adh.country ORDER BY revenue DESC limit 5";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);
			$sth->execute();
			$todos = $sth->fetchAll();
			
			$country_array = array("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");
		
			$data = array();
			
			for ($i = 0; $i < count($todos); $i++) {
		
				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue  = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
	
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = 0;
				}
				
				$icountry = '';				
				$icountrycode = '';

				if ($todos[$i]['country'] != "-") {
				    $icountrycode = $todos[$i]['country'] ? $todos[$i]['country'] : "";				    
					$icountry = $todos[$i]['country'] ? $country_array[$todos[$i]['country']]: "";
					
				} else {

					$todos[$i]['country'] = "Others";
				}
				
				//print_r($newArray);die();

				$data[] = array(
					"countryname" => ($icountry ? $icountry : 'Others'),
					"countrycode" => ($icountrycode ? $icountrycode : 'Others'),
					"campaignname" => ($todos[$i]['campaignname']) ? $todos[$i]['campaignname'] : '-',
					"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					"clicks" => $todos[$i]['clicks'],
					"revenue" => ($todos[$i]['revenue'] > 0) ? $todos[$i]['revenue']  : 0.00,
				);

				}

			if($data)

		{
		return $this->response->withJson($data);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
		}
		
}

  
});


// Geo report api - Advertiser

$app->get('/get_georeport_statistics/[{start_date},{end_date},{advertiser_id}]', function ($request, $response, $args)
{

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them AND c.clientid = cl.clientid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$startdate = $args['start_date'];
		$enddate = $args['end_date'];
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
        $start_date ='';
		$end_date = '';
		if ($client) {
		
		    $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);

			$sql = "select 
			c.campaignname as campaignname,
			c.revenue as revenues,
			c.revenue_type as revenue_type,
			c.weight,
			b.description as bannername, 
			adh.country as country,
			adh.region as region, 
			adh.city as city,
			TIMESTAMP(adh.date_time) as date_time,
			sum(adh.impressions) as impressions,
			sum(adh.clicks) as clicks,
			round((case when  c.revenue_type = 1 then adh.impressions*c.revenue/1000 
			when c.revenue_type = 2 then adh.clicks*c.revenue
			else adh.impressions*c.revenue
			end),2) as revenue,
			round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
			round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm		
			from
			" . $table_prefix . "stats_country as adh,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
			" . $table_prefix . "zones as z 
			where
			adh.creative_id=b.bannerid
			And z.zoneid = adh.zone_id
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND adh.creative_id >= 0
			AND DATE(adh.date_time) between '" . $start_date . "'
			AND '" . $end_date . "' group by adh.country,c.campaignid";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);

			$sth->execute();

			$todos = $sth->fetchAll();
			
			// print_r($sql);exit;

			$country_array = array("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");
		
			$data = array();
			
			for ($i = 0; $i < count($todos); $i++) {
		
				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue  = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
	
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = 0;
				}


				$newArray = array();
				if ($todos[$i]['region']) {
					$code = $todos[$i]['country'] . '-' . $todos[$i]['region'];

					$region_query = ("select subdivision_name as region from rv_region where country_code='" . $todos[$i]['country'] . "' AND code='" . $code . "'");

					$sth = $this->db->prepare($region_query);
					$sth->execute();

					$region_query = $sth->fetchAll();

					
					foreach ($region_query as $key => $value) {
						foreach ($value as $key2 => $value2) {
							 $newArray[$key2] = $value2;
						}
					}

				}
				
				$icountry = '';				
				$icountrycode = '';

				if ($todos[$i]['country'] != "-") {
				    $icountrycode = $todos[$i]['country'] ? $todos[$i]['country'] : "";				    
					$icountry = $todos[$i]['country'] ? $country_array[$todos[$i]['country']]: "";
					
				} else {

					$todos[$i]['country'] = "Others";
				}
				
				//print_r($newArray);die();


				$data[] = array(
					"country" => ($icountry ? $icountry : 'Others'),
					"countrycode" => ($icountrycode ? $icountrycode : 'Others'),
					"region" => ($newArray) ? $newArray[$key2] :  '-',
					"city" => ($todos[$i]['city']) ? $todos[$i]['city'] : '-',
					"campaignname" => ($todos[$i]['campaignname']) ? $todos[$i]['campaignname'] : '-',
					//"bannername" => ($todos[$i]['bannername']) ? $todos[$i]['bannername'] : '-',
					//"request"=>$row['requests'],
					"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					"clicks" => $todos[$i]['clicks'],
					//"conversions"=>$todos[$i]['conversions'],
					"ctr" => ($todos[$i]['impressions'] > 0) ? round($todos[$i]['clicks'] / $todos[$i]['impressions'] * 100, 2) : 0.00,
					"ecpm" => ($todos[$i]['impressions'] > 0) ? round(($total_revenue / $todos[$i]['impressions']) * 1000, 2) : 0.00,
				    //"pub_income" => $pub_income,
					"total_revenue" => ($todos[$i]['revenue'] > 0) ? $todos[$i]['revenue']  : 0.00,
				);

				}


				if ($data) {
					return $this->response->withJson($data);
				} else {
					$response = array('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			//}
		} else { 

			$response = array('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('datevalidation'));

//All Geo report api

$app->get('/get_all_georeport_statistics/[{advertiser_id}]', function ($request, $response, $args)
{

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if ($client) {

			$sql = "select 
			c.campaignname as campaignname,
			c.revenue as revenues,
			c.revenue_type as revenue_type,
			c.weight,
			b.description as bannername, 
			adh.country as country,
			adh.region as region, 
			adh.city as city,
			TIMESTAMP(adh.date_time) as date_time,
			sum(adh.impressions) as impressions,
			sum(adh.clicks) as clicks,
			round((case when  c.revenue_type = 1 then adh.impressions*c.revenue/1000 
			when c.revenue_type = 2 then adh.clicks*c.revenue
			else adh.impressions*c.revenue
			end),2) as revenue,
			round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
			round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm		
			from
			" . $table_prefix . "stats_country as adh,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl, 
			" . $table_prefix . "zones as z 
			where
			adh.creative_id=b.bannerid
			And z.zoneid = adh.zone_id
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			group by adh.country,c.campaignid ";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);

			$sth->execute();

			$todos = $sth->fetchAll();

			$country_array = array("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");
		
			$data = array();
			
			for ($i = 0; $i < count($todos); $i++) {
		
				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue  = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
	
				} else if ($todos[$i]['revenue_type'] == 2) {

					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					
					$total_revenue = 0;
				}

				$newArray = array();

				if ($todos[$i]['region']) {
					$code = $todos[$i]['country'] . '-' . $todos[$i]['region'];

					$region_query = ("select subdivision_name as region from rv_region where country_code='" . $todos[$i]['country'] . "' AND code='" . $code . "'");

					$sth = $this->db->prepare($region_query);
					$sth->execute();

					$region_query = $sth->fetchAll();

					
					foreach ($region_query as $key => $value) {
						foreach ($value as $key2 => $value2) {
							$newArray[$key2] = $value2;
						}
					}

				}

				$icountry = '';				
				$icountrycode = '';

				if ($todos[$i]['country'] != "-") {
					$icountrycode = $todos[$i]['country'] ? $todos[$i]['country'] : "";				    
					$icountry = $todos[$i]['country'] ? $country_array[$todos[$i]['country']]: "";
					
				} else {

					$todos[$i]['country'] = "Others";
				}

				//print_r($newArray);die();

				$data[] = array(
					"country" => ($icountry ? $icountry : 'Others'),
					"countrycode" => ($icountrycode ? $icountrycode : 'Others'),
					"region" => ($newArray) ? $newArray[$key2] :  '-',
					"city" => ($todos[$i]['city']) ? $todos[$i]['city'] : '-',
					"campaignname" => ($todos[$i]['campaignname']) ? $todos[$i]['campaignname'] : '-',
					"bannername" => ($todos[$i]['bannername']) ? $todos[$i]['bannername'] : '-',
					//"request"=>$row['requests'],
					"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					"clicks" => $todos[$i]['clicks'],
					"conversions"=> 0,
					"ctr" => ($todos[$i]['impressions'] > 0) ? round($todos[$i]['clicks'] / $todos[$i]['impressions'] * 100, 2) : 0.00,
					"ecpm" => ($todos[$i]['impressions'] > 0) ? round(($todos[$i]['revenue'] / $todos[$i]['impressions']) * 1000, 2) : 0.00,
				   //"pub_income" => $pub_income,
					"total_revenue" => ($todos[$i]['revenue'] > 0) ? $todos[$i]['revenue'] : 0.00,
				);

				}


				if ($data) {
					return $this->response->withJson($data);
				} else {
					$response = array('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			//}
		} else {

			$response = array('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

// Geo Report Map API 

$app->get('/get_georeport_map_statistics/[{start_date},{end_date},{advertiser_id}]', function ($request, $response, $args)
{

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them AND c.clientid = cl.clientid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$startdate = $args['start_date'];
		$enddate = $args['end_date'];
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		
		$start_date ='';
		$end_date = '';

		if ($client) {
		
		    $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);

			$sql = "select 
			c.campaignname as campaignname,
			c.revenue as revenues,
			c.revenue_type as revenue_type,
			c.weight,
			b.description as bannername, 
			adh.country as country,
			adh.region as region, 
			adh.city as city,
			TIMESTAMP(adh.date_time) as date_time,
			sum(adh.impressions) as impressions,
			sum(adh.clicks) as clicks,
			round((adh.impressions*c.revenue/1000),2) as rev,
			round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
			round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm		
			from
			" . $table_prefix . "stats_country as adh,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl, 
			" . $table_prefix . "zones as z 
			where
			adh.creative_id=b.bannerid
			And z.zoneid = adh.zone_id
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND DATE(adh.date_time) between '" . $start_date . "'
			AND '" . $end_date . "' group by adh.country";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);

			$sth->execute();

			$todos = $sth->fetchAll();
			
			//print_r($sql);exit;
            $country_array = [];
			
			$country_array = array("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");
		
		    $data = [];
			for ($i = 0; $i < count($todos); $i++) {
		
				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue  = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
	
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = 0;
				}



				if ($todos[$i]['region']) {
					$code = $todos[$i]['country'] . '-' . $todos[$i]['region'];

					$region_query = ("select subdivision_name as region from rv_region where country_code='" . $todos[$i]['country'] . "' AND code='" . $code . "'");

					$sth = $this->db->prepare($region_query);
					$sth->execute();

					$region_query = $sth->fetchAll();

					$newArray = array();
					foreach ($region_query as $key => $value) {
						foreach ($value as $key2 => $value2) {
							$newArray[$key2] = $value2;
						}
					}

				}
       
				$icountry = '';				
				$icountrycode = '';

				if ($todos[$i]['country'] != "-") {
				    $icountrycode = $todos[$i]['country'] ? $todos[$i]['country'] : "";				    
					$icountry = $todos[$i]['country'] ? $country_array[$todos[$i]['country']]: "";
					
				} else {

					//$todos[$i]['country'] = "";
				}

				if($icountry) {
				$data[] = array(
					"country" => ($icountry ? $icountry : ''),
					"countrycode" => ($icountrycode ? $icountrycode : ''),
					"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					"clicks" => $todos[$i]['clicks'],
					"value" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
				);
                }

				}


				if ($data) {
					return $this->response->withJson($data);
				} else {
					$response = array('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			//}
		} else {

			$response = array('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('datevalidation'));


// All Geo Report Map API 

$app->get('/get_all_georeport_map_statistics/[{advertiser_id}]', function ($request, $response, $args)
{	

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if ($client) {

	    $sql = "select 
		c.campaignname as campaignname,
		c.revenue as revenues,
		c.revenue_type as revenue_type,
		c.weight,
        b.description as bannername, 
        adh.country as country,
        adh.region as region, 
        adh.city as city,
        TIMESTAMP(adh.date_time) as date_time,
		sum(adh.impressions) as impressions,
		sum(adh.clicks) as clicks,
        round((case when  c.revenue_type = 1 then adh.impressions*c.revenue/1000 
		when c.revenue_type = 2 then adh.clicks*c.revenue
		else adh.impressions*c.revenue
		end),2) as revenue,
		round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
		round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm		
		from
		" . $table_prefix . "stats_country as adh,
		" . $table_prefix . "banners as b,
		" . $table_prefix . "campaigns as c,
		" . $table_prefix . "clients as cl, 
		" . $table_prefix . "zones as z 
		where
		adh.creative_id=b.bannerid
		And z.zoneid = adh.zone_id
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		group by adh.country";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);

			$sth->execute();

			$todos = $sth->fetchAll();
			
			// print_r($sql);exit;

			$country_array = array("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");
			$data = array();
			for ($i = 0; $i < count($todos); $i++) {
		
				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue  = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
	
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = 0;
				}



				if ($todos[$i]['region']) {
					$code = $todos[$i]['country'] . '-' . $todos[$i]['region'];

					$region_query = ("select subdivision_name as region from rv_region where country_code='" . $todos[$i]['country'] . "' AND code='" . $code . "'");

					$sth = $this->db->prepare($region_query);
					$sth->execute();

					$region_query = $sth->fetchAll();

					$newArray = array();
					foreach ($region_query as $key => $value) {
						foreach ($value as $key2 => $value2) {
							$newArray[$key2] = $value2;
						}
					}

				}

				$icountry = '';				
				$icountrycode = '';

				if ($todos[$i]['country'] != "-") {
					$icountrycode = $todos[$i]['country'] ? $todos[$i]['country'] : "";				    
					$icountry = $todos[$i]['country'] ? $country_array[$todos[$i]['country']]: "";
					
				} else {

					//$todos[$i]['country'] = "Others";
				}

				if($icountry) {
				$data[] = array(
					"country" => ($icountry ? $icountry : ''),
					"countrycode" => ($icountrycode ? $icountrycode : ''),
					"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					"clicks" => $todos[$i]['clicks'],
					"value" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
				);
                }
			}

				if ($data) {
					return $this->response->withJson($data);
				} else {
					$response = array('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			//}
		} else {

			$response = array('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

/*--------------- End of Advertiser Statistics ------------*/


/*--------------- Start of Publisher Statistics ------------*/


// Geo Report Map API  - publisher

$app->get('/get_georeport_map__publisher_statistics/[{start_date},{end_date},{publisher_id}]', function ($request, $response, $args)
{

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them AND c.clientid = cl.clientid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$startdate = $args['start_date'];
		$enddate = $args['end_date'];
		$publisherid = $args['publisher_id'];

		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		$start_date='';
        $end_date='';

		if ($publisherid) {
		    
			$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);

			$sql = "select 
			c.campaignname as campaignname,
			c.revenue as revenues,
			c.revenue_type as revenue_type,
			c.weight,
			b.description as bannername, 
			adh.country as country,
			adh.region as region, 
			adh.city as city,
			TIMESTAMP(adh.date_time) as date_time,
			sum(adh.impressions) as impressions,
			sum(adh.clicks) as clicks,
			round((adh.impressions*c.revenue/1000),2) as rev,
			round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
			round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm		
			from
			".$table_prefix."stats_country as adh,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."zones as z,
			".$table_prefix."affiliates as p
			where
			adh.creative_id=b.bannerid
			And z.zoneid = adh.zone_id
			AND c.campaignid = b.campaignid
			AND p.affiliateid = :publisherid
			AND p.affiliateid = z.affiliateid
			AND DATE(adh.date_time) between '" . $start_date . "'
			AND '" . $end_date . "' group by adh.country";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid", $publisherid);

			$sth->execute();

			$todos = $sth->fetchAll();
			
			// print_r($sql);exit;

			$country_array = array("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");
		
			$data = array();
			for ($i = 0; $i < count($todos); $i++) {
		
				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue  = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
	
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = 0;
				}



				if ($todos[$i]['region']) {
					$code = $todos[$i]['country'] . '-' . $todos[$i]['region'];

					$region_query = ("select subdivision_name as region from rv_region where country_code='" . $todos[$i]['country'] . "' AND code='" . $code . "'");

					$sth = $this->db->prepare($region_query);
					$sth->execute();

					$region_query = $sth->fetchAll();

					$newArray = array();
					foreach ($region_query as $key => $value) {
						foreach ($value as $key2 => $value2) {
							$newArray[$key2] = $value2;
						}
					}

				}
				
				$icountry = '';				
				$icountrycode = '';

				if ($todos[$i]['country'] != "-") {
				    $icountrycode = $todos[$i]['country'] ? $todos[$i]['country'] : "";				    
					$icountry = $todos[$i]['country'] ? $country_array[$todos[$i]['country']]: "";
					
				} else {

					//$todos[$i]['country'] = "Others";
				}
                if($icountry) {
				$data[] = array(
					"country" => ($icountry ? $icountry : ''),
					"countrycode" => ($icountrycode ? $icountrycode : ''),
					"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					"clicks" => $todos[$i]['clicks'],
					"value" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
				);
                }
				}


				if ($data) {
					return $this->response->withJson($data);
				} else {
					$response = array('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			//}
		} else {

			$response = array('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('datevalidation'));

// All Geo Report Map API -publisher

$app->get('/get_all_georeport_map__publisher_statistics/[{publisher_id}]', function ($request, $response, $args)
{

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id'];
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		if ($publisherid) {

	    $sql = "select 
		c.campaignname as campaignname,
		c.revenue as revenues,
		c.revenue_type as revenue_type,
		c.weight,
        b.description as bannername, 
        adh.country as country,
        adh.region as region, 
        adh.city as city,
        TIMESTAMP(adh.date_time) as date_time,
		sum(adh.impressions) as impressions,
		sum(adh.clicks) as clicks,
        round((adh.impressions*c.revenue/1000),2) as rev,
		round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
		round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm		
		from
		".$table_prefix."stats_country as adh,
        ".$table_prefix."banners as b,
        ".$table_prefix."campaigns as c,
        ".$table_prefix."zones as z,
        ".$table_prefix."affiliates as p
        where
        adh.creative_id=b.bannerid
        And z.zoneid = adh.zone_id
        AND c.campaignid = b.campaignid
        AND p.affiliateid = :publisherid
		AND p.affiliateid = z.affiliateid
	    group by adh.country";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid", $publisherid);

			$sth->execute();

			$todos = $sth->fetchAll();
			
			// print_r($sql);exit;

			$country_array = array("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");
			
			$data = array();
			$newArray = array();
			for ($i = 0; $i < count($todos); $i++) {
		
				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue  = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
	
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['conversions'] * $todos[$i]['revenues'];
				}



				if ($todos[$i]['region']) {
					$code = $todos[$i]['country'] . '-' . $todos[$i]['region'];

					$region_query = ("select subdivision_name as region from rv_region where country_code='" . $todos[$i]['country'] . "' AND code='" . $code . "'");

					$sth = $this->db->prepare($region_query);
					$sth->execute();

					$region_query = $sth->fetchAll();

					
					foreach ($region_query as $key => $value) {
						foreach ($value as $key2 => $value2) {
							$newArray[$key2] = $value2;
						}
					}

				}

				$icountry = '';				
				$icountrycode = '';

				if ($todos[$i]['country'] != "-") {
				    $icountrycode = $todos[$i]['country'] ? $todos[$i]['country'] : "";				    
					$icountry = $todos[$i]['country'] ? $country_array[$todos[$i]['country']]: "";
					
				} else {

					$todos[$i]['country'] = "Others";
				}
                if($icountry) {
				$data[] = array(
					"country" => ($icountry ? $icountry : 'Others'),
					"countrycode" => ($icountrycode ? $icountrycode : 'Others'),
					"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					"clicks" => $todos[$i]['clicks'],
					"value" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
				);
                }
				}


				if ($data) {
					return $this->response->withJson($data);
				} else {
					$response = array('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			//}
		} else {

			$response = array('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

//Geo Report API - Publisher

$app->get('/get_georeport__publisher_statistics/[{start_date},{end_date},{publisher_id}]', function ($request, $response, $args)
{

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them AND c.clientid = cl.clientid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$startdate = $args['start_date'];
		$enddate = $args['end_date'];
		$publisherid = $args['publisher_id'];

		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		$start_date='';
        $end_date='';

		if ($publisherid) {
		    
			$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);

			$sql = "select 
			z.zonename as zonename,
			c.revenue as revenues,
			c.revenue_type as revenue_type,
			b.description as bannername, 
			adh.country as country,
			adh.region as region, 
			adh.city as city,
			TIMESTAMP(adh.date_time) as date_time,
			sum(adh.impressions) as impressions,
			sum(adh.clicks) as clicks,	
			round((case when  c.revenue_type = 1 then adh.impressions*c.revenue/1000 
			when c.revenue_type = 2 then adh.clicks*c.revenue
			else adh.impressions*c.revenue
			end),2) as revenue,
			round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
			round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm        
			from
			".$table_prefix."stats_country as adh,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."zones as z,
			".$table_prefix."affiliates as p
			where
			adh.creative_id=b.bannerid
			And z.zoneid = adh.zone_id
			AND c.campaignid = b.campaignid
			AND p.affiliateid = :publisherid
			AND p.affiliateid = z.affiliateid
			AND DATE(adh.date_time) between '" . $start_date . "'
			AND '" . $end_date . "' group by adh.zone_id,adh.country";
			$sth = $this->db->prepare($sql);
			// $sth->bindParam(":affiliateid", $publisherid);
			$sth->bindParam(":publisherid",$publisherid);
			$sth->execute();

			$todos = $sth->fetchAll();
			
			//print_r($sql);exit;

			$country_array = array("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");
			$data = array();
			for ($i = 0; $i < count($todos); $i++) {
		
				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue  = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
	
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue  = 0;
				}
                //echo $total_revenue; 
				$newArray = array();

				if ($todos[$i]['region']) {
					$code = $todos[$i]['country'] . '-' . $todos[$i]['region'];

					$region_query = ("select subdivision_name as region from rv_region where country_code='" . $todos[$i]['country'] . "' AND code='" . $code . "'");

					$sth = $this->db->prepare($region_query);
					$sth->execute();

					$region_query = $sth->fetchAll();

					
					foreach ($region_query as $key => $value) {
						foreach ($value as $key2 => $value2) {
							$newArray[$key2] = $value2;
						}
					}

				}

				$icountry = '';				
				$icountrycode = '';

				if ($todos[$i]['country'] != "-") {
					$icountrycode = $todos[$i]['country'] ? $todos[$i]['country'] : "";				    
					$icountry = $todos[$i]['country'] ? $country_array[$todos[$i]['country']]: "";
					
				} else {

					$todos[$i]['country'] = "Others";
				}

				//print_r($newArray);die();


				$data[] = array(
					"country" => ($icountry ? $icountry : 'Others'),
					"countrycode" => ($icountrycode ? $icountrycode : 'Others'),
					"region" => ($newArray) ? $newArray[$key2] :  '-',
					"city" => ($todos[$i]['city']) ? $todos[$i]['city'] : '-',
					"zonename" => ($todos[$i]['zonename']) ? $todos[$i]['zonename'] : '-',
					//"bannername" => ($todos[$i]['bannername']) ? $todos[$i]['bannername'] : '-',
					//"request"=>$row['requests'],
					"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					"clicks" => $todos[$i]['clicks'],
					"conversions"=>0,
					"ctr" => ($todos[$i]['impressions'] > 0) ? round($todos[$i]['clicks'] / $todos[$i]['impressions'] * 100, 2) : 0.00,
					"ecpm" => ($todos[$i]['impressions'] > 0) ? round(($total_revenue / $todos[$i]['impressions']) * 1000, 2) : 0.00,
				   //"pub_income" => $pub_income,
					"total_revenue" => ($todos[$i]['revenue'] > 0) ? $todos[$i]['revenue'] : 0.00,
				);

				}

				// echo "data"; 
				// print_r($data);exit;

				if ($data) {
					return $this->response->withJson($data);
				} else {
					$response = array('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			//}
		} else {

			$response = array('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('datevalidation'));


//All Geo report API - Publisher


$app->get('/get_all_georeport__publisher_statistics/[{publisher_id}]', function ($request, $response, $args)
{

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them AND c.clientid = cl.clientid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id'];

		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		if ($publishers) {

	    $sql = "select 
        z.zonename as zonename,
        c.revenue as revenues,
        c.revenue_type as revenue_type,
        b.description as bannername, 
        adh.country as country,
        adh.region as region, 
        adh.city as city,
        TIMESTAMP(adh.date_time) as date_time,
        sum(adh.impressions) as impressions,
        sum(adh.clicks) as clicks,
		round((case when  c.revenue_type = 1 then adh.impressions*c.revenue/1000 
		when c.revenue_type = 2 then adh.clicks*c.revenue
		else adh.impressions*c.revenue
		end),2) as revenue,
        round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
        round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm        
        from
        ".$table_prefix."stats_country as adh,
        ".$table_prefix."banners as b,
        ".$table_prefix."campaigns as c,
        ".$table_prefix."zones as z,
        ".$table_prefix."affiliates as p
        where
        adh.creative_id=b.bannerid
        And z.zoneid = adh.zone_id
        AND c.campaignid = b.campaignid
        AND p.affiliateid = :publisherid
		AND p.affiliateid = z.affiliateid
	    group by adh.zone_id,adh.country";
		/* print_r($sql);
		exit; */
			$sth = $this->db->prepare($sql);
			// $sth->bindParam(":affiliateid", $publisherid);
			$sth->bindParam(":publisherid",$publisherid);
			$sth->execute();

			$todos = $sth->fetchAll();
			
			//print_r($sql);exit;

			$country_array = array("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");
		
			$data = array();
			
			$newArray = array();
		
			for ($i = 0; $i < count($todos); $i++) {
		
				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue  = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
	
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['conversions'] * $todos[$i]['revenues'];
				}



				if ($todos[$i]['region']) {
					$code = $todos[$i]['country'] . '-' . $todos[$i]['region'];

					$region_query = ("select subdivision_name as region from rv_region where country_code='" . $todos[$i]['country'] . "' AND code='" . $code . "'");

					$sth = $this->db->prepare($region_query);
					$sth->execute();

					$region_query = $sth->fetchAll();

					
					foreach ($region_query as $key => $value) {
						foreach ($value as $key2 => $value2) {
							$newArray[$key2] = $value2;
						}
					}

				}

				$icountry = '';				
				$icountrycode = '';

				if ($todos[$i]['country'] != "-") {
					$icountrycode = $todos[$i]['country'] ? $todos[$i]['country'] : "";				    
					$icountry = $todos[$i]['country'] ? $country_array[$todos[$i]['country']]: "";
					
				} else {

					$todos[$i]['country'] = "Others";
				}

				//print_r($newArray);die();

				$data[] = array(
					"country" => ($icountry ? $icountry : 'Others'),
					"countrycode" => ($icountrycode ? $icountrycode : 'Others'),
					"region" => ($newArray) ? $newArray[$key2] :  '-',
					"city" => ($todos[$i]['city']) ? $todos[$i]['city'] : '-',
					"zonename" => ($todos[$i]['zonename']) ? $todos[$i]['zonename'] : '-',
					//"bannername" => ($todos[$i]['bannername']) ? $todos[$i]['bannername'] : '-',
					//"request"=>$row['requests'],
					"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					"clicks" => $todos[$i]['clicks'],
					"conversions"=>0,
					"ctr" => ($todos[$i]['impressions'] > 0) ? round($todos[$i]['clicks'] / $todos[$i]['impressions'] * 100, 2) : 0.00,
					"ecpm" => ($todos[$i]['impressions'] > 0) ? round(($total_revenue / $todos[$i]['impressions']) * 1000, 2) : 0.00,
				   //"pub_income" => $pub_income,
					"total_revenue" => ($todos[$i]['revenue'] > 0) ? $todos[$i]['revenue'] : 0.00,
				);
				}
				if ($data) {
					return $this->response->withJson($data);
				} else {
					$response = array('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			//}
		} else {

			$response = array('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

// Publisher Zone Statistics

$app->get('/get_publisher_zone_statistics/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		$start_date='';
        $end_date='';

		if ($publishers) {
		    
			$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			// $sql="select 		  
			// 	DATE(h.date_time) as date_time,
			// 	sum(h.impressions) as impressions,
			// 	sum(h.clicks) as clicks,
			// 	sum(h.conversions) as conversions,
			// 	sum(h.total_revenue) as revenue,		
			// 	cl.clientid as clientid,
			// 	(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			// 	(sum(h.total_revenue)/sum(h.impressions)) * 1000 as ecpm,
			// 	p.affiliateid as affiliateid,
			// 	p.name as affiliatename,
			// 	z.zonename as zonename
			// 	from
			// 	".$table_prefix."data_summary_ad_hourly as h,
			// 	".$table_prefix."banners as b,
			// 	".$table_prefix."campaigns as c,
			// 	".$table_prefix."clients as cl,
			// 	".$table_prefix."affiliates as p,
			// 	".$table_prefix."zones as z
			// 	where
			// 	h.ad_id = b.bannerid
			// 	AND cl.clientid = c.clientid
			// 	AND p.affiliateid = :publisherid
			// 	and p.affiliateid=z.affiliateid
			// 	AND z.zoneid = h.zone_id
			// 	AND b.campaignid = c.campaignid
			// 	AND h.date_time between '".$startdate."'
			// 	AND '".$enddate."' group by h.zone_id";

			$sql="select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.pub_income),2) as revenue,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.pub_income)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			z.zoneid AS zoneid,
			z.zonename as zonename
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			p.affiliateid = :publisherid
			AND
			p.affiliateid = z.affiliateid
			AND
			z.zoneid = h.zone_id  
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by h.zone_id";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid",$publisherid);
			$sth->execute();
			$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation')); 

// All Publisher Zone Statistics

$app->get('/get_all_publisher_zone_statistics/[{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.pub_income),2) as revenue,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.pub_income)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			z.zoneid AS zoneid,
			z.zonename as zonename
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			p.affiliateid = :publisherid
			AND
			p.affiliateid = z.affiliateid
			AND
			z.zoneid = h.zone_id  
		    group by h.zone_id";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
}); 

//Publisher Top Zone Statistics - Revenue

$app->get('/get_publisher_top_zone_revenue/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		$start_date='';
        $end_date='';

		if ($publishers) {
		    
			$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
		    $sql="select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.pub_income),2) as spend,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.pub_income)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			z.zoneid AS zoneid,
			z.zonename as zonename
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			p.affiliateid = :publisherid
			AND
			p.affiliateid = z.affiliateid
			AND
			z.zoneid = h.zone_id  
		    AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by z.zoneid ORDER BY spend DESC limit 5";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid",$publisherid);
			$sth->execute();
			$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation'));


// Publisher Top Zone Statistics - ctr

$app->get('/get_publisher_top_zone_ctr_statistics/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		$start_date='';
        $end_date='';

		if ($publishers) {
		    
			$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
		    $sql="select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.pub_income),2) as spend,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.pub_income)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			z.zoneid AS zoneid,
			z.zonename as zonename
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			p.affiliateid = :publisherid
			AND
			p.affiliateid = z.affiliateid
			AND
			z.zoneid = h.zone_id  
		    AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by z.zoneid ORDER BY ctr DESC limit 5";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid",$publisherid);
			$sth->execute();
			$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation'));

// All top zone
$app->get('/get_all_publisher_top_zone_revenue/[{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
			$sql="select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.pub_income),2) as spend,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.pub_income)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			z.zoneid AS zoneid,
			z.zonename as zonename
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			p.affiliateid = :publisherid
			AND
			p.affiliateid = z.affiliateid
			AND
			z.zoneid = h.zone_id  
		    group by z.zoneid ORDER BY spend DESC limit 5";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
});

// All publisher top zone - ctr

$app->get('/get_all_publisher_top_zone_ctr_statistics/[{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
			$sql="select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.pub_income),2) as spend,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.pub_income)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			z.zoneid AS zoneid,
			z.zonename as zonename
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			p.affiliateid = :publisherid
			AND
			p.affiliateid = z.affiliateid
			AND
			z.zoneid = h.zone_id  
		    group by z.zoneid ORDER BY ctr DESC limit 5";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
});

// Publisher Top Country

$app->get('/get_publisher_top_country_details/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them AND c.clientid = cl.clientid
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
     
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisher_id = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisher_id);
		$std->execute();
		$campaign = $std->fetchAll();

		$start_date='';
        $end_date='';

		if ($campaign) {
		    
			$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			$sql="select 		
			co.country_name as countryname,
			c.campaignname as campaignname,
			round((case when  c.revenue_type = 1 then h.impressions*c.revenue/1000 
				 when c.revenue_type = 2 then h.clicks*c.revenue
				 else h.impressions*c.revenue
				 end),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks
			from
			" . $table_prefix . "stats_country as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z,
			da_country as co
			where
			h.creative_id=b.bannerid
			And z.zoneid = h.zone_id
			And c.campaignid = b.campaignid
			AND p.affiliateid = :publisherid
			AND co.counrty_code = h.country
			AND p.affiliateid = z.affiliateid
			AND h.date_time between '".$start_date."' AND '".$end_date."'
			group by co.country_name ORDER BY ctr DESC limit 5";
			
			/* print_r($sql); 
			exit; */

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid",$publisher_id);
			$sth->execute();
			$todos = $sth->fetchAll();

		if($todos)
		{
		return $this->response->withJson($todos);
		}else{
			$response = array('response'=>'ok','msg'=>'No Stats Available');
				return $this->response->withJson($response);
		}
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
		
}

})->add($container->get('datevalidation'));

//All Publisher Top Country

$app->get('/get_all_publisher_top_country_details/[{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them AND c.clientid = cl.clientid
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
     
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix']; 
		$publisher_id = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisher_id);
		$std->execute();
		$campaign = $std->fetchAll();

		if($campaign)
		{
		$sql="select 		
		co.country_name as countryname,
		c.campaignname as campaignname,
		round((case when  c.revenue_type = 1 then h.impressions*c.revenue/1000 
             when c.revenue_type = 2 then h.clicks*c.revenue
             else h.impressions*c.revenue
             end),2) as revenue,
		round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks
		from
		" . $table_prefix . "stats_country as h,
		" . $table_prefix . "banners as b,
		" . $table_prefix . "campaigns as c,
		" . $table_prefix . "affiliates as p,
		" . $table_prefix . "zones as z,
        da_country as co
		where
		h.creative_id=b.bannerid
		And z.zoneid = h.zone_id
		And c.campaignid = b.campaignid
		AND co.counrty_code = h.country
		AND p.affiliateid = :publisherid
		AND p.affiliateid = z.affiliateid
		group by co.country_name ORDER BY ctr DESC limit 5";
       
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisher_id);
		$sth->execute();
		$todos = $sth->fetchAll();

		if($todos)
		{
		return $this->response->withJson($todos);
		}else{
			$response = array('response'=>'ok','msg'=>'No Stats Available');
				return $this->response->withJson($response);
		}
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
		
}

});

// Publisher Website Statistics

$app->get('/get_publisher_website_statistics/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		$start_date='';
        $end_date='';

		if ($publishers) 
		{
			$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
		    $sql="select 		  
			DATE_FORMAT(h.date_time,'%d-%m-%Y') as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.pub_income),2) as revenue,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.pub_income)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			p.name as website,
			z.zonename as zonename
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by p.affiliateid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation')); 

//All Publisher Website Statistics

$app->get('/get_all_publisher_website_statistics/[{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 		  
			DATE_FORMAT(h.date_time,'%d-%m-%Y') as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.pub_income),2) as revenue,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.pub_income)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			p.name as website,
			z.zonename as zonename
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			group by p.affiliateid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
}); 

//Publisher Zone Chart Statistics

$app->get('/get_publisher_zone_chart_statistics/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		$start_date='';
        $end_date='';

		if ($publishers) 
		{
			$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
		    $sql="select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.pub_income),2) as revenue,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.pub_income)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			CONCAT(SUBSTRING(z.zonename FROM 1 FOR 4),'-',z.zoneid) as zonename
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by h.zone_id";

			// echo "sql";
			// print_r($sql);exit;
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid",$publisherid);
			$sth->execute();
			$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation')); 

//All Publisher Zone Chart Statistics

$app->get('/get_all_publisher_zone_chart_statistics/[{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.pub_income),2) as revenue,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.pub_income)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			CONCAT(SUBSTRING(z.zonename FROM 1 FOR 4),'-',z.zoneid) as zonename
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			group by h.zone_id";

		/* echo "sql";
		print_r($sql);
		exit; */

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
}); 

//publisher total counts 

$app->get('/get_publisher_widget_count_statistics/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		$start_date='';
        $end_date='';

		if ($publishers) 
		{
			$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);

			$sql="select
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			sum(h.pub_income) as revenue,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(sum(h.pub_income)/sum(h.impressions))*1000 as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by p.affiliateid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid",$publisherid);
			$sth->execute();
			$todos = $sth->fetchAll();
	if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation'));


//All publisher widget counts statistics


$app->get('/get_all_publisher_widget_count_statistics/[{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{

		$sql="select
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.requests) as requests,
		sum(h.pub_income) as revenue,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(sum(h.pub_income)/sum(h.impressions))*1000 as ecpm,
		p.affiliateid as affiliateid,
		p.name as affiliatename
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."affiliates as p,
		".$table_prefix."zones as z
		where
		p.affiliateid = :publisherid
		and p.affiliateid=z.affiliateid
		AND z.zoneid = h.zone_id
		group by p.affiliateid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
	if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
});

// Publisher Widgets Statistics

$app->get('/get_publisher_widgets_statistics/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		$start_date='';
        $end_date='';

		if ($publishers) 
		{
			$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
		    $sql="select 			
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			sum(h.pub_income) as revenue,			
			cl.clientid as clientid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(Sum(h.pub_income)/sum(h.impressions))*1000 as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			cl.clientname as clientname
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by clientid";

			/* echo "query";
			print_r($sql);exit; */
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid",$publisherid);
			$sth->execute();
			$todos = $sth->fetchAll();
	if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation'));

// All Publisher Widgets Statistics

$app->get('/get_all_publisher_widgets_statistics/[{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 			
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			sum(h.pub_income) as revenue,			
			cl.clientid as clientid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(Sum(h.pub_income)/sum(h.impressions))*1000 as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			cl.clientname as clientname
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			group by clientid";

			
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
	if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
}); 

//Publisher Top Banner Statistics

$app->get('/get_top_publisher_banner_statistics/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		$start_date='';
        $end_date='';

		if ($publishers) 
		{
			$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
		    $sql="select 
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.pub_income),2) as spend,	
			cl.clientid as clientid,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.pub_income)/sum(h.impressions))*1000,2) as ecpm,
			b.description as bannername
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND p.affiliateid = :publisherid
			And p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by h.ad_id ORDER BY spend DESC limit 5";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid",$publisherid);
			$sth->execute();
			$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation')); 

//All Publisher Top Banner Statistics

$app->get('/get_all_top_publisher_banner_statistics/[{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.pub_income),2) as spend,	
			cl.clientid as clientid,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.pub_income)/sum(h.impressions))*1000,2) as ecpm,
			b.description as bannername
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			group by h.ad_id ORDER BY spend DESC limit 5";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
}); 

/*--------------- End of Publisher Statistics ------------*/
