<?php
/*
 * 
 * File Created by DAC141
 * 
 */

/*--------------- Start of Advertiser Statistics ------------*/







$app->get('/get_widgets_advertiser_campaign_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them group by campaignid
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date ='';
		$end_date = '';
		if($client)
		{
	        $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();				
			
			$timezone = $TimeZoneRow[0]['timezone'];			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			// $sql="select 



			
			// sum(h.impressions) as impressions,
			// sum(h.clicks) as clicks,
			// sum(h.conversions) as conversions,
			// sum(h.requests) as requests,
			// round(sum(h.total_revenue),2) as revenue,
			// round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			// round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	,

			// cl.clientid as clientid,
			// cl.clientname as clientname,
			// b.campaignid as campaignid,
			// c.campaignname as campaignname,
			// h.ad_id as ad_id,
			// b.bannerid as bannerid,
			// b.description as bannername,
			// DATE(h.date_time) as date_time		
		
		
			// from
			// ".$table_prefix."data_summary_ad_hourly as h,
			// ".$table_prefix."banners as b,
			// ".$table_prefix."campaigns as c,
			// ".$table_prefix."clients as cl 
			
			// where
			
			//  h.ad_id = b.bannerid
			// AND c.campaignid = b.campaignid
			// AND c.clientid = cl.clientid
			// AND cl.clientid = :advertiserid
			// AND h.date_time between '".$start_date."'
			// AND '".$end_date."'";

			$sql="select 
	
		
			
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	,
			round(sum(h.total_revenue),2) as spend,		
			c.campaignname as campaignname,
			
			DATE(h.date_time) as date_time
	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
		
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."'";

			// print_r($sql);
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);
		$sth->execute();		
		$todos = $sth->fetchAll();	
		// print_r($todos);
		if($todos)
		{
			return $this->response->withJson($todos);
		}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
		return $this->response->withJson($response);
		}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));




//widgets-----------get all-----------------------------------------



	
$app->get('/get_all_widgets_advertiser_campaign_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them group by campaignid
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');

		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		
		if($client)
		{
	       
			

			$sql="select 
	
		
			
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	,
			round(sum(h.total_revenue),2) as spend,		
			c.campaignname as campaignname,
			
			DATE(h.date_time) as date_time
	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			
			where
		
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid	";

		
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);
		$sth->execute();		
		$todos = $sth->fetchAll();	
		// print_r($todos);
		if($todos)
		{
			return $this->response->withJson($todos);
		}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
		return $this->response->withJson($response);
		}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});




//xandr widgets statistics 


	
$app->get('/get_all_xandr_widgets_advertiser_campaign_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them group by campaignid
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');

		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		
		if($client)
		{
	       
			

			$sql="select 
	
		
			sum(x.impressions) as impressions,
			sum(x.clicks) as clicks,
			sum(x.ctr) as ctr,	
			round(sum(x.total_revenue),2) as revenue,	
			sum(x.ecpm) as ecpm,		
			round(sum(x.total_revenue),2) as spend,
			sum(x.total_convs) as conversions,
			sum(h.requests) as requests,			
			
			c.campaignname as campaignname,			
			DATE(h.date_time) as date_time
	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl ,
			".$table_prefix."xandr_reports as x 
			where
			x.creative_id=b.xandrcreativeid
			AND
		
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid	";

		
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);
		$sth->execute();		
		$todos = $sth->fetchAll();	
		// print_r($todos);
		if($todos)
		{
			return $this->response->withJson($todos);
		}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
		return $this->response->withJson($response);
		}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});







//All  revive Top websites 

$app->get('/get_all_top_banner_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
			
		// $sql="select 
		// c.campaignname as campaignname,
		// b.description as bannername,
		// DATE(h.date_time) as date_time,
		// sum(h.impressions) as impressions,
		// sum(h.clicks) as clicks,
		// sum(h.conversions) as conversions,
		// round(sum(h.total_revenue),2) as spend,
		// round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
		// from
		// ".$table_prefix."data_summary_ad_hourly as h,
		// ".$table_prefix."banners as b,
		// ".$table_prefix."campaigns as c,
		// ".$table_prefix."clients as cl 
		// where
		// h.ad_id = b.bannerid
		// AND c.campaignid = b.campaignid
		// AND c.clientid = cl.clientid
		// AND cl.clientid = :advertiserid
		// group by b.bannerid ORDER BY spend DESC limit 5";


		$sql="select 
			c.campaignname as campaignname,
			a.name as affiliatename,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as spend,
			round((sum(h.clicks)/sum(h.impressions)) * 100,0) as ctr,

			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."zones as z,
			".$table_prefix."affiliates as a,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			z.affiliateid = a.affiliateid
			 AND
			h.zone_id = z.zoneid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid			
			 group by a.affiliateid ORDER BY ctr DESC limit 5";


		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);
		$sth->execute();
		$todos = $sth->fetchAll();	

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});





//  revive Top websites  Statistics

$app->get('/get_top_banner_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		$start_date ='';
		$end_date = '';
		if($client)
		{
		    $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();			
			
			$timezone = $TimeZoneRow[0]['timezone'];			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			// $sql="select 
			// c.campaignname as campaignname,
			// b.description as bannername,
			// DATE(h.date_time) as date_time,
			// sum(h.impressions) as impressions,
			// sum(h.clicks) as clicks,
			// sum(h.conversions) as conversions,
			// round(sum(h.total_revenue),2) as spend,
			// round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			// from
			// ".$table_prefix."data_summary_ad_hourly as h,
			// ".$table_prefix."banners as b,
			// ".$table_prefix."campaigns as c,
			// ".$table_prefix."clients as cl 
			// where
			// h.ad_id = b.bannerid
			// AND c.campaignid = b.campaignid
			// AND c.clientid = cl.clientid
			// AND cl.clientid = :advertiserid
			// AND h.date_time between '".$start_date."'
			// AND '".$end_date."' group by b.bannerid ORDER BY spend DESC limit 5";



			$sql="select 
			c.campaignname as campaignname,
			a.name as affiliatename,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as spend,
			round((sum(h.clicks)/sum(h.impressions)) * 100,0) as ctr,

			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."zones as z,
			".$table_prefix."affiliates as a,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			z.affiliateid = a.affiliateid
			 AND
			h.zone_id = z.zoneid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by a.affiliateid ORDER BY ctr DESC limit 5";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);
			$sth->execute();
			$todos = $sth->fetchAll();			

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}  
}
 
})->add($container->get('datevalidation'));






// Get Advertiser campaign Statistics

$app->get('/get_advertiser_campaign_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them group by campaignid
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date ='';
		$end_date = '';
		if($client)
		{
	        $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			$sql="select 

			sum(x.impressions) as impressions,
			sum(x.clicks) as clicks,
			sum(x.ctr) as ctr,	
			round(sum(x.total_revenue),2) as revenue,	
			sum(x.ecpm) as ecpm,		
			round(sum(x.total_revenue),2) as spend,
			sum(x.total_convs) as conversions,
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			h.ad_id as ad_id,
			b.bannerid as bannerid,
			b.description as bannername,
			DATE(h.date_time) as date_time,			
			sum(h.requests) as requests
		
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl ,
			".$table_prefix."xandr_reports as x 
			where
			x.creative_id=b.xandrcreativeid
			AND h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."'";



		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		
		$todos = $sth->fetchAll();

		// print_r($todos );
		
		if($todos)
		{
			if(!empty($todos[0]['ad_id']))
			{
				return $this->response->withJson($todos);
			}
			else{
				$response = array('response'=>'ok','msg'=>'No Stats Available');
				return $this->response->withJson($response);
			}
		}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
		return $this->response->withJson($response);
		}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));









// Get Advertiser campaign Statistics

$app->get('/get_xandr_advertiser_campaign_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them group by campaignid
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date ='';
		$end_date = '';
		if($client)
		{
	        $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			$sql="select 

			sum(x.impressions) as xandr_impressions,
			sum(x.clicks) as xandr_clicks,
			round(sum(x.ctr),2) as xandr_ctr,			
			round(sum(x.ecpm),2) as xandr_ecpm,
			
			round(sum(x.total_revenue),2) as revenue,			
			round(sum(x.total_revenue),2) as spend,
			sum(x.total_convs) as conversions,
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			h.ad_id as ad_id,
			b.bannerid as bannerid,
			b.description as bannername,
			DATE(h.date_time) as date_time,			
			sum(h.requests) as requests
		
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl ,
			".$table_prefix."xandr_reports as x 
			where
			x.creative_id=b.xandrcreativeid
			AND h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."'";



		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		
		$todos = $sth->fetchAll();

		// print_r($todos );
		
		if($todos)
		{
			if(!empty($todos[0]['ad_id']))
			{
				return $this->response->withJson($todos);
			}
			else{
				$response = array('response'=>'ok','msg'=>'No Stats Available');
				return $this->response->withJson($response);
			}
		}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
		return $this->response->withJson($response);
		}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));



// All Advertiser Campaign Statistics

$app->get('/get_all_dashboard_advertiser_campaign_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		if($client)
		{
			
			$sql="select 


			sum(x.impressions) as xandr_impressions,
			sum(x.clicks) as xandr_clicks,
			round(sum(x.ctr),2) as xandr_ctr,			
			round(sum(x.ecpm),2) as xandr_ecpm,		
			round(sum(x.total_revenue),2) as revenue,			
			round(sum(x.total_revenue),2) as spend,
			sum(x.total_convs) as conversions,
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			h.ad_id as ad_id,
			b.bannerid as bannerid,
			b.description as bannername,
			DATE(h.date_time) as date_time,		
			sum(h.requests) as requests
			
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl ,

			".$table_prefix."xandr_reports as x 
			where
			x.creative_id=b.xandrcreativeid
			AND
		
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		
		$todos = $sth->fetchAll();

		if($todos)
		{
		if(!empty($todos[0]['ad_id']))
			{
				return $this->response->withJson($todos);
			}
			else{
				$response = array('response'=>'ok','msg'=>'No Stats Available');
				return $this->response->withJson($response);
			}
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});






//camp id Graph Statistics

$app->get('/get_campaignid_campaign_graph_statistics/[{start_date},{end_date},{campaign_id}]', function($request, $response, $args)
{
	// print_r(campaign_id);exit;
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$campaign_id = $args['campaign_id']; 
		echo "....hiiii...";
		print_r(campaign_id);exit;
		$stc = "select * from ".$table_prefix."banners where campaignid=:campaignid";
		$std = $this->db->prepare($stc);
		$std->bindParam("campaignid",$campaignid);
		$std->execute();
		$client = $std->fetchAll();
        $start_date ='';
		$end_date = '';
		if($client)
		{
		    $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			$sql="select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
			TIMESTAMP(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),0) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,0) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND cl.clientid = c.clientid
			AND c.clientid = :campaignid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by c.campaignid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":campaignid",$campaignid);

			$sth->execute();

			$todos = $sth->fetchAll();
			
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));




//Campaign  Graph Statistics

$app->get('/get_all_dashboard_banner_graph_statistics/[{bannerid}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$bannerid = $args['bannerid']; 

	
		$stc = "select * from ".$table_prefix."banners where bannerid=:bannerid";
		$std = $this->db->prepare($stc);
		$std->bindParam("bannerid",$bannerid);
		$std->execute();
		$campaigns = $std->fetchAll();

		if($campaigns)
		{	
			
			
			
			// print_r($end_date );
			$sql="select 
			cl.clientid as clientid,
			b.bannerid as bannerid,
			b.description as bannername,
			cl.clientname as clientname,
			CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
			TIMESTAMP(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),0) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,0) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			
			

			h.ad_id = b.bannerid
			
			AND cl.clientid = c.clientid
			AND c.campaignid = b.campaignid
			AND b.bannerid = :bannerid

			group by b.bannerid";
			
			
			// print_r($sql );

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":bannerid",$bannerid);
			// print_r($sth );exit;
			$sth->execute();

			$todos = $sth->fetchAll();
			
		
		// exit;
			
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});





//Campaign  Graph Statistics

$app->get('/get_dashboard_banner_graph_statistics/[{start_date},{end_date},{bannerid}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$bannerid = $args['bannerid']; 

// print_r($enddate);
	
		$stc = "select * from ".$table_prefix."banners where bannerid=:bannerid";
		$std = $this->db->prepare($stc);
		$std->bindParam("bannerid",$bannerid);
		$std->execute();
		$campaigns = $std->fetchAll();
        // echo "..campaigns ..";

		// print_r($campaigns );
		$start_date ='';
		$end_date = '';
		if($campaigns)
		{	
			$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			// print_r($end_date );
			$sql="select 
			cl.clientid as clientid,
			b.bannerid as bannerid,
			b.description as bannername,
			cl.clientname as clientname,
			CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
			TIMESTAMP(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),0) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,0) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			
			

			h.ad_id = b.bannerid
			
			AND cl.clientid = c.clientid
			AND c.campaignid = b.campaignid
			AND b.bannerid = :bannerid

			AND h.date_time between '".$start_date."'
			AND '".$end_date."'";
			
			// print_r($sql );

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":bannerid",$bannerid);
			// print_r($sth );exit;
			$sth->execute();

			$todos = $sth->fetchAll();
			
		
		// exit;
			
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid banner Id');
			return $this->response->withJson($response);

		}
  
}
 
});




//Campaign  Graph Statistics

$app->get('/get_all_dashboard_campaign_graph_statistics/[{campaign_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');	
		$campaign_id = $args['campaign_id']; 
	
		$stc = "select * from ".$table_prefix."campaigns where campaignid=:campaignid";
		$std = $this->db->prepare($stc);
		$std->bindParam("campaignid",$campaign_id);
		$std->execute();
		$campaigns = $std->fetchAll();
        
	
		if($campaigns)
		{	
			
			$sql="select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
			TIMESTAMP(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),0) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,0) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND cl.clientid = c.clientid
			AND c.campaignid = :campaignid
			group by c.campaignid";


			$sth = $this->db->prepare($sql);
			$sth->bindParam(":campaignid",$campaign_id);
			$sth->execute();
			$todos = $sth->fetchAll();		
			
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid campaign Id');
			return $this->response->withJson($response);

		}
  
}
 
});






//Campaign  Graph Statistics

$app->get('/get_dashboard_campaign_graph_statistics/[{start_date},{end_date},{campaign_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$campaign_id = $args['campaign_id']; 


	
		$stc = "select * from ".$table_prefix."campaigns where campaignid=:campaignid";
		$std = $this->db->prepare($stc);
		$std->bindParam("campaignid",$campaign_id);
		$std->execute();
		$campaigns = $std->fetchAll();
        
		$start_date ='';
		$end_date = '';
		if($campaigns)
		{	
			$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
					
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			// print_r($end_date );
			$sql="select 
			sum(x.impressions) as xandr_impressions,
			sum(x.clicks) as xandr_clicks,
			round(sum(x.ctr),2) as xandr_ctr,			
			round(sum(x.ecpm),2) as xandr_ecpm,
			round(sum(x.total_revenue),2) as revenue,
			
			round(sum(x.total_revenue),2) as spend,
			sum(x.total_convs) as conversions,
			cl.clientid as clientid,
			cl.clientname as clientname,
			CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
			TIMESTAMP(h.date_time) as date_time,
		
			sum(h.requests) as requests
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl ,
			".$table_prefix."xandr_reports as x 
			where
			x.creative_id=b.xandrcreativeid
			AND
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND cl.clientid = c.clientid
			AND c.campaignid = :campaignid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."'";		

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":campaignid",$campaign_id);
			$sth->execute();
			$todos = $sth->fetchAll();

			// print_r($todos );
	
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});






//Advertiser Graph Statistics

$app->get('/get_revivee_advertiser_campaign_graph_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
        $start_date ='';
		$end_date = '';
		if($client)
		{
		    $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();			
		
			$timezone = $TimeZoneRow[0]['timezone'];			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			$sql="select 
			
			
			cl.clientid as clientid,
			cl.clientname as clientname,
			CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
			TIMESTAMP(h.date_time) as date_time,

			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
	
	
		
			
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			
			".$table_prefix."clients as cl 
			where
			

			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by c.campaignid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);
			$sth->execute();
			$todos = $sth->fetchAll();
			// print_r(	$todos );
			
			
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));



// //Advertiser Graph Statistics

// $app->get('/get_advertiser_campaign_graph_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
// {
	
// 	if ($request->getAttribute('has_errors')) {
//         //There are errors, read them
//         $errors = $request->getAttribute('errors');      
//         return $this->response->withJson($errors);
        
//         return $response;
//     } else {
    
// 		$input = $request->getParsedBody();
// 		$table_prefix= $this->get('settings')['path']['table_prefix'];
// 		$datetime=date('Y-m-d H:i:s');
// 		$startdate=$args['start_date'];
// 		$enddate=$args['end_date']; 
// 		$advertiser_id = $args['advertiser_id']; 
	
// 		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
// 		$std = $this->db->prepare($stc);
// 		$std->bindParam("client_id",$advertiser_id);
// 		$std->execute();
// 		$client = $std->fetchAll();
//         $start_date ='';
// 		$end_date = '';
// 		if($client)
// 		{
// 		    $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
// 			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
// 			$TimeZonestd->execute();
// 			$TimeZoneRow = $TimeZonestd->fetchAll();			
		
// 			$timezone = $TimeZoneRow[0]['timezone'];			
// 			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
//             $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
// 			date_default_timezone_set($timezone);
// 			$Starts = strtotime($startdate);
// 			$Ends = strtotime($enddate);
// 			date_default_timezone_set("UTC");
// 			$start_date = date("Y-m-d H:i:s", $Starts);
// 			$end_date  = date("Y-m-d H:i:s", $Ends);
			
// 			$sql="select 
// 			x.creative_name as creative_name,
// 			sum(x.impressions) as xandr_impressions,
// 			sum(x.clicks) as xandr_clicks,
// 			sum(x.ctr) as xandr_ctr,	
// 			round(sum(x.total_revenue),2) as revenue,	
// 			sum(x.ecpm) as xandr_ecpm,		
// 			round((Sum(h.total_revenue)/sum(x.impressions))*1000,0) as xandr_ecpm	,
// 			round(sum(x.total_revenue),2) as spend,
// 			sum(x.total_convs) as conversions,
// 			cl.clientid as clientid,
// 			cl.clientname as clientname,
// 			CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
// 			TIMESTAMP(h.date_time) as date_time,

// 			sum(h.impressions) as impressions,
// 			sum(h.clicks) as clicks,
// 			sum(h.conversions) as conversions,
// 			sum(h.requests) as requests,
// 			round(sum(h.total_revenue),2) as revenue,
// 			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
// 			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
	
	
		
			
// 			from
// 			".$table_prefix."data_summary_ad_hourly as h,
// 			".$table_prefix."banners as b,
// 			".$table_prefix."campaigns as c,
			
// 			".$table_prefix."clients as cl ,			

// 			".$table_prefix."xandr_reports as x 
// 			where
// 			x.creative_id=b.xandrcreativeid
// 			AND

// 			h.ad_id = b.bannerid
// 			AND c.campaignid = b.campaignid
// 			AND c.clientid = cl.clientid
// 			AND cl.clientid = :advertiserid
// 			AND h.date_time between '".$start_date."'
// 			AND '".$end_date."' group by c.campaignid";
// 			// print_r(	$sql );
// 			$sth = $this->db->prepare($sql);
// 			$sth->bindParam(":advertiserid",$advertiser_id);
// 			$sth->execute();
// 			$todos = $sth->fetchAll();
// 			// print_r(	$todos );
			
			
// 		if($todos)
// 		{
// 		return $this->response->withJson($todos);
// 	}else{
// 		$response = array('response'=>'ok','msg'=>'No Stats Available');
// 			return $this->response->withJson($response);
// 	}
// 		}
// 		else{
			
// 			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
// 			return $this->response->withJson($response);

// 		}
  
// }
 
// })->add($container->get('datevalidation'));



//Advertiser Graph Statistics

$app->get('/get_advertiser_campaign_graph_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		
		$enddate=$args['end_date']; 

		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
        $start_date ='';
		$end_date = '';
		if($client)
		{
		    $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();			
		
			$timezone = $TimeZoneRow[0]['timezone'];			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
//             $xandr_end_date=date('Y-m-d', strtotime($end_date));
// print_r($xandr_end_date);
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);

			// $xandr_startdate = date("Y-m-d", $Starts);
			// $xandr_end_date  = date("Y-m-d", $Ends);

		
			//
			
			$revive_sql="select 
			
			cl.clientid as clientid,
			cl.clientname as clientname,
			CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
			TIMESTAMP(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round(sum(h.total_revenue),2) as spend,		

			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
	
	
		
			
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,			
			".$table_prefix."clients as cl 			
 
			where
			

			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by c.campaignid";
			// print_r($revive_sql );
			
			$sth_revive_sql = $this->db->prepare($revive_sql);
			$sth_revive_sql->bindParam(":advertiserid",$advertiser_id);
			$sth_revive_sql->execute();
			$todos__revive_sql = $sth_revive_sql->fetchAll();
			// print_r($todos__revive_sql );
			

			// $xandr_startdate = date("Y-m-d", $startdate);
			// $xandr_end_date  = date("Y-m-d", $enddate);
			// print_r($startdate);
			// 	print_r($enddate);
	
			// 	print_r($xandr_startdate);
			// 	print_r($xandr_end_date);
			// 	exit;


			$sql="select 
			
			sum(x.impressions) as xandr_impressions,
			sum(x.clicks) as xandr_clicks,

			round(sum(x.ctr),2) as xandr_ctr,			
			round(sum(x.ecpm),2) as xandr_ecpm,			
			round(sum(x.total_revenue),2) as revenue,	
		
			round(sum(x.total_revenue),2) as spend,
			sum(x.total_convs) as conversions,
			cl.clientid as clientid,
			cl.clientname as clientname,
			CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
			TIMESTAMP(h.date_time) as date_time			
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,			
			".$table_prefix."clients as cl ,
			".$table_prefix."xandr_reports as x 
			where
			x.creative_id=b.xandrcreativeid
			AND

			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid

			
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by c.campaignid";

			// print_r(	$sql );
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);
			$sth->execute();
			$todos = $sth->fetchAll();
			// print_r(	$todos );
			
		if($todos)
		{
			// $response = array('response'=>'ok','msg'=>'No Stats Available');
			$response = array('todos__revive_sql'=>$todos__revive_sql,'todos'=>$todos);
		return $this->response->withJson($response);
	}
	else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));



//Advertiser Graph Statistics

// $app->get('/get_advertiser_campaign_graph_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
// {
	
// 	if ($request->getAttribute('has_errors')) {
//         //There are errors, read them
//         $errors = $request->getAttribute('errors');      
//         return $this->response->withJson($errors);
        
//         return $response;
//     } else {
    
// 		$input = $request->getParsedBody();
// 		$table_prefix= $this->get('settings')['path']['table_prefix'];
// 		$datetime=date('Y-m-d H:i:s');
// 		$startdate=$args['start_date'];
// 		$enddate=$args['end_date']; 
// 		$advertiser_id = $args['advertiser_id']; 
	
// 		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
// 		$std = $this->db->prepare($stc);
// 		$std->bindParam("client_id",$advertiser_id);
// 		$std->execute();
// 		$client = $std->fetchAll();
//         $start_date ='';
// 		$end_date = '';
// 		if($client)
// 		{
// 		    $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
// 			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
// 			$TimeZonestd->execute();
// 			$TimeZoneRow = $TimeZonestd->fetchAll();			
		
// 			$timezone = $TimeZoneRow[0]['timezone'];			
// 			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
//             $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
// 			date_default_timezone_set($timezone);
// 			$Starts = strtotime($startdate);
// 			$Ends = strtotime($enddate);
// 			date_default_timezone_set("UTC");
// 			$start_date = date("Y-m-d H:i:s", $Starts);
// 			$end_date  = date("Y-m-d H:i:s", $Ends);
			


			
			
// 		if($todos)
// 		{
// 		return $this->response->withJson($todos);
// 	}else{
// 		$response = array('response'=>'ok','msg'=>'No Stats Available');
// 			return $this->response->withJson($response);
// 	}
// 		}
// 		else{
			
// 			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
// 			return $this->response->withJson($response);

// 		}
  
// }
 
// })->add($container->get('datevalidation'));







//Advertiser All Graph Statistics

$app->get('/get_all_revive_advertiser_campaign_graph_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
			
		$sql="select 

			
		cl.clientid as clientid,
		cl.clientname as clientname,
		CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
		TIMESTAMP(h.date_time) as date_time,			
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,	
		round(sum(h.total_revenue),2) as revenue,	
		round((sum(h.clicks)/sum(h.impressions)) * 100,0) as ctr,
		round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	,
		round(sum(h.total_revenue),2) as spend,
		sum(h.conversions) as conversions,	
		sum(h.requests) as requests


	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl 

		where	
	
		h.ad_id = b.bannerid
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		group by c.campaignid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		$todos = $sth->fetchAll();
		
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});





//Advertiser All Graph Statistics

$app->get('/get_all_advertiser_campaign_graph_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
			

	
			$revive_sql="select 
			
			cl.clientid as clientid,
			cl.clientname as clientname,
			CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
			TIMESTAMP(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as spend,		
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
	
		
			
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,			
			".$table_prefix."clients as cl 	 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid 
			group by c.campaignid";
		
			
			$sth_revive_sql = $this->db->prepare($revive_sql);
			$sth_revive_sql->bindParam(":advertiserid",$advertiser_id);
			$sth_revive_sql->execute();
			$todos__revive_sql = $sth_revive_sql->fetchAll();
			


			$sql="select 
			
			sum(x.impressions) as xandr_impressions,
			sum(x.clicks) as xandr_clicks,
			round(sum(x.ctr),2) as xandr_ctr,			
			round(sum(x.ecpm),2) as xandr_ecpm,
			
			round(sum(x.total_revenue),2) as revenue,				
			round(sum(x.total_revenue),2) as spend,
			sum(x.total_convs) as conversions,
			cl.clientid as clientid,
			cl.clientname as clientname,
			CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
			TIMESTAMP(h.date_time) as date_time			
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,			
			".$table_prefix."clients as cl ,
			".$table_prefix."xandr_reports as x 
			where
			x.creative_id=b.xandrcreativeid
			AND
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid		
		
			group by c.campaignid";

			// print_r(	$sql );
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);
			$sth->execute();
			$todos = $sth->fetchAll();
			




		// $sql="select 

		// sum(x.impressions) as xandr_impressions,
		// sum(x.clicks) as xandr_clicks,
		// sum(x.ctr) as xandr_ctr,	
		// round(sum(x.total_revenue),2) as revenue,	
		// sum(x.ecpm) as xandr_ecpm,		
		// round((Sum(h.total_revenue)/sum(x.impressions))*1000,0) as xandr_ecpm	,
		// round(sum(x.total_revenue),2) as spend,
		// sum(x.total_convs) as conversions,		
		// cl.clientid as clientid,
		// cl.clientname as clientname,
		// CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
		// TIMESTAMP(h.date_time) as date_time,	
		
		// sum(h.impressions) as impressions,
		// sum(h.clicks) as clicks,	
		// round(sum(h.total_revenue),2) as revenue,	
		// round((sum(h.clicks)/sum(h.impressions)) * 100,0) as ctr,
		// round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	,
		// round(sum(h.total_revenue),2) as spend,
		// sum(h.conversions) as conversions,	
		// sum(h.requests) as requests


	
		// from
		// ".$table_prefix."data_summary_ad_hourly as h,
		// ".$table_prefix."banners as b,
		// ".$table_prefix."campaigns as c,
		// ".$table_prefix."clients as cl ,
		
		// ".$table_prefix."xandr_reports as x 
		// where
		// x.creative_id=b.xandrcreativeid
		// AND	
		// h.ad_id = b.bannerid
		// AND c.campaignid = b.campaignid
		// AND c.clientid = cl.clientid
		// AND cl.clientid = :advertiserid
		// group by c.campaignid";
		// $sth = $this->db->prepare($sql);
		// $sth->bindParam(":advertiserid",$advertiser_id);
		// $sth->execute();
		// $todos = $sth->fetchAll();
	
		if($todos)
		{
			$response = array('todos__revive_sql'=>$todos__revive_sql,'todos'=>$todos);

		return $this->response->withJson($response);
	}
	else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});




//Advertiser All Graph Statistics

$app->get('/get_all_campaign_graph_statistics/[{campaign_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$campaign_id = $args['campaign_id']; 
		print_r($campaign_id);
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$campaign_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
			
		$sql="select 
		cl.clientid as clientid,
		cl.clientname as clientname,
		CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
		TIMESTAMP(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.requests) as requests,
		round(sum(h.total_revenue),0) as revenue,
		
		round((sum(h.clicks)/sum(h.impressions)),0) * 100 as ctr,
		round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl 
		where
		h.ad_id = b.bannerid
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		group by c.campaignid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		$todos = $sth->fetchAll();
	
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});







//All Top Campaign 

$app->get('/get_all_top_campaign_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
			
		$sql="select 



				

	sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.requests) as requests,
		round(sum(h.total_revenue),2) as revenue,
		round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
		round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	,
		round(sum(h.total_revenue),2) as spend,	

		c.campaignname as campaignname,
		b.description as bannername,
        DATE(h.date_time) as date_time
		
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl 
		
		where		
		h.ad_id = b.bannerid
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		group by c.campaignid ORDER BY ctr DESC limit 5";
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		$todos = $sth->fetchAll();

		// echo "query";
		// print_r($todos);exit;

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});








// Get Advertiser campaign Statistics

$app->get('/get_xandr_widgets_advertiser_campaign_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them group by campaignid
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 

		// print_r($startdate);
		// print_r($enddate);
		// $xandr_start_date=date('Y-m-d', $startdate);
		// $xandr_end_date=date('Y-m-d', $enddate);
		// print_r($xandr_start_date);
		// print_r($xandr_end_date);
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date ='';
		$end_date = '';
		if($client)
		{
	        $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();			
			
			$timezone = $TimeZoneRow[0]['timezone'];			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			// print_r($start_date);
			// print_r($end_date);
			// DATE(x.date) as date_time,	

			$sql="select 
			sum(x.impressions) as impressions,
			sum(x.clicks) as clicks,
			round(sum(x.ctr),2) as ctr,	
			round(sum(x.total_revenue),2) as revenue,	
			sum(x.ecpm) as ecpm,		
			round(sum(x.total_revenue),2) as spend,
			sum(x.total_convs) as conversions,
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			h.ad_id as ad_id,
			b.bannerid as bannerid,
			b.description as bannername,
		
			DATE(h.date_time) as date_time,		
			sum(h.requests) as requests
		
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl ,
			".$table_prefix."xandr_reports as x 
			where
			x.creative_id=b.xandrcreativeid
			AND h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid


			 AND h.date_time between '".$start_date."'
			 AND '".$end_date."'";

			 // $xandr_start_date=date('Y-m-d', $startdate);
		// $xandr_end_date=date('Y-m-d', $enddate);
		// print_r($xandr_start_date);
		// print_r($xandr_end_date);

		
		// DATE(x.date) as date_time,	


			// AND x.date between '".$xandr_start_date."'
			// AND '".$xandr_end_date."'";

			
// print_r($sql);
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);
		$sth->execute();		
		$todos = $sth->fetchAll();	
		
		if($todos)
		{
			if(!empty($todos[0]['ad_id']))
			{
				return $this->response->withJson($todos);
			}
			else{
				$response = array('response'=>'ok','msg'=>'No Stats Available');
				return $this->response->withJson($response);
			}
		}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
		return $this->response->withJson($response);
		}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));



// Get Advertiser campaign Statistics

// $app->get('/get_xandr_widgets_advertiser_campaign_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
// {
// 	if ($request->getAttribute('has_errors')) {
//         //There are errors, read them group by campaignid
//         $errors = $request->getAttribute('errors');      
//         return $this->response->withJson($errors);
        
//         return $response;
//     } else {
    
// 		$input = $request->getParsedBody();
// 		$table_prefix= $this->get('settings')['path']['table_prefix'];
// 		$datetime=date('Y-m-d H:i:s');
// 		$startdate=$args['start_date'];
// 		$enddate=$args['end_date']; 
// 		$advertiser_id = $args['advertiser_id']; 


// 		$startdate_chunks = explode(' ', $startdate);
// 		$enddate_chunks = explode(' ', $enddate);

// 		// print_r($startdate_chunks[0]);
// 		// print_r($enddate_chunks[0]);

// 		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
// 		$std = $this->db->prepare($stc);
// 		$std->bindParam("client_id",$advertiser_id);
// 		$std->execute();
// 		$client = $std->fetchAll();
// 		$start_date ='';
// 		$end_date = '';
// 		if($client)
// 		{
// 	        $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
// 			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
// 			$TimeZonestd->execute();
// 			$TimeZoneRow = $TimeZonestd->fetchAll();			
			
// 			$timezone = $TimeZoneRow[0]['timezone'];			
// 			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
//             $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
// 			date_default_timezone_set($timezone);
// 			$Starts = strtotime($startdate);
// 			$Ends = strtotime($enddate);
// 			date_default_timezone_set("UTC");
// 			$start_date = date("Y-m-d H:i:s", $Starts);
// 			$end_date  = date("Y-m-d H:i:s", $Ends);
// 			// print_r($start_date);
// 			// print_r($end_date);
// 			// DATE(x.date) as date_time,	

// 			$sql="select 
// 			sum(x.impressions) as impressions,
// 			sum(x.clicks) as clicks,
// 			round(sum(x.ctr),2) as ctr,	
// 			round(sum(x.total_revenue),2) as revenue,	
// 			sum(x.ecpm) as ecpm,		
// 			round(sum(x.total_revenue),2) as spend,
// 			sum(x.total_convs) as conversions,
// 			cl.clientid as clientid,
// 			cl.clientname as clientname,
// 			b.campaignid as campaignid,
// 			c.campaignname as campaignname,
// 			h.ad_id as ad_id,
// 			b.bannerid as bannerid,
// 			b.description as bannername,
		
// 			x.date as date_time,		
// 			sum(h.requests) as requests
		
// 			from
// 			".$table_prefix."data_summary_ad_hourly as h,
// 			".$table_prefix."banners as b,
// 			".$table_prefix."campaigns as c,
// 			".$table_prefix."clients as cl ,
// 			".$table_prefix."xandr_reports as x 
// 			where
// 			x.creative_id=b.xandrcreativeid
// 			AND h.ad_id = b.bannerid
// 			AND b.campaignid= c.campaignid 
// 			AND c.clientid = cl.clientid
// 			AND cl.clientid = :advertiserid
// 			 AND x.date between '".$startdate_chunks[0]."'
// 			AND '".$enddate_chunks[0]."'";

// 			//  AND h.date_time between '".$start_date."'
// 			//  AND '".$end_date."'";

		

		
// 		// DATE(x.date) as date_time,	


// 			// AND x.date between '".$startdate_chunks[0]."'
// 			// AND '".$enddate_chunks[0]."'";

			
// 		// print_r($startdate_chunks[0]);
// 		// print_r($enddate_chunks[0]);
// print_r($sql);
// 		$sth = $this->db->prepare($sql);
// 		$sth->bindParam(":advertiserid",$advertiser_id);
// 		$sth->execute();		
// 		$todos = $sth->fetchAll();	
		
// 		if($todos)
// 		{
// 			if(!empty($todos[0]['ad_id']))
// 			{
// 				return $this->response->withJson($todos);
// 			}
// 			else{
// 				$response = array('response'=>'ok','msg'=>'No Stats Available');
// 				return $this->response->withJson($response);
// 			}
// 		}else{
// 		$response = array('response'=>'ok','msg'=>'No Stats Available');
// 		return $this->response->withJson($response);
// 		}
// 		}
// 		else{
			
// 			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
// 			return $this->response->withJson($response);

// 		}
  
// }
 
// });



//All xandr Top Campaign 

$app->get('/get_all_xandr_top_campaign_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
			
		$sql="select 

		sum(x.impressions) as impressions,
			sum(x.clicks) as clicks,
			sum(x.ctr) as ctr,	
			round(sum(x.total_revenue),2) as revenue,	
			sum(x.ecpm) as ecpm,		
			round((Sum(h.total_revenue)/sum(x.impressions))*1000,0) as ecpm	,
			round(sum(x.total_revenue),2) as spend,
			sum(x.total_convs) as conversions,
		c.campaignname as campaignname,
		b.description as bannername,
        DATE(h.date_time) as date_time
		
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl ,
		".$table_prefix."xandr_reports as x 
		where
		x.creative_id = b.xandrcreativeid
		AND
		h.ad_id = b.bannerid
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		group by c.campaignid ORDER BY ctr DESC limit 5";
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		$todos = $sth->fetchAll();

		// echo "query";
		// print_r($todos);exit;

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});


// top campaign statistics

$app->get('/get_top_campaign_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		$start_date ='';
		$end_date = '';
		if($client)
		{
		    $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();			
			
			$timezone = $TimeZoneRow[0]['timezone'];			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			// $sql="select 
	
		
			
			// sum(h.impressions) as impressions,
			// sum(h.clicks) as clicks,
			// sum(h.conversions) as conversions,
			// sum(h.requests) as requests,
			// round(sum(h.total_revenue),2) as revenue,
			// round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			// round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	,
			// round(sum(h.total_revenue),2) as spend,		
			// c.campaignname as campaignname,
			
			// DATE(h.date_time) as date_time
	
			// from
			// ".$table_prefix."data_summary_ad_hourly as h,
			// ".$table_prefix."banners as b,
			// ".$table_prefix."campaigns as c,
			// ".$table_prefix."clients as cl ,
			// ".$table_prefix."xandr_reports as x 
			// where
			// x.creative_id = b.xandrcreativeid
			// AND 
			// h.ad_id = b.bannerid
			// AND c.campaignid = b.campaignid
			// AND c.clientid = cl.clientid
			// AND cl.clientid = :advertiserid
			// AND h.date_time between '".$start_date."'
			// AND '".$end_date."' group by c.campaignid ORDER BY ctr DESC limit 5";


			$sql="select 
	
		
			
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	,
			round(sum(h.total_revenue),2) as spend,		
			c.campaignname as campaignname,
			
			DATE(h.date_time) as date_time
	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			
			where		
			
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by c.campaignid ORDER BY ctr DESC limit 5";

// print_r();


			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);








		$sth->execute();

		$todos = $sth->fetchAll();

		// echo "query";
		// print_r($todos);exit;

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));







//xandr top campaigns


// top campaign statistics

$app->get('/get_xandr_top_campaign_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		$start_date ='';
		$end_date = '';
		if($client)
		{
		    $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();			
			
			$timezone = $TimeZoneRow[0]['timezone'];			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			$sql="select 
			sum(x.impressions) as impressions,
			sum(x.clicks) as clicks,
			sum(x.ctr) as ctr,	
			round(sum(x.total_revenue),2) as revenue,	
			sum(x.ecpm) as xandr_ecpm,		
			round((Sum(h.total_revenue)/sum(x.impressions))*1000,0) as ecpm	,
			round(sum(x.total_revenue),2) as spend,
			sum(x.total_convs) as conversions,			
			c.campaignname as campaignname,
			DATE(h.date_time) as date_time
	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl ,
			".$table_prefix."xandr_reports as x 
			where
			x.creative_id = b.xandrcreativeid
			AND 
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by c.campaignid ORDER BY ctr DESC limit 5";

			// print_r($sql);
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);








		$sth->execute();

		$todos = $sth->fetchAll();

		// echo "query";
		// print_r($todos);exit;

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));





//All Top websites xandr

$app->get('/get_all_top_website_statistics', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		// if($client)
		// {
			$sql="select 							  
			DATE(x.date) as date_time,
			sum(x.impressions) as impressions,
			sum(x.clicks) as clicks,
			sum(x.ctr) as ctr,				
			x.domain_name as websitesname			
			from
			".$table_prefix."xandr_site_reports as x		
							
			ORDER BY x.ctr DESC limit 5";


		$sth = $this->db->prepare($sql);
		$sth->execute();
		$todos = $sth->fetchAll();	


		// if there is no website avaliable it should not return null to front end js
		$no_website=array();
		for($i=0;$i<count($todos);$i++){
			$websitesname = $todos[$i]['websitesname'];
			if($todos[$i]['websitesname']==null){
				$no_website[]=$websitesname ;
			}
		}

		if(count($todos)==count($no_website)){
			$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
		}

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		// }
		// else{
			
		// 	$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
		// 	return $this->response->withJson($response);

		// }
  
}
 
});



$app->get('/get_top_website_statistics/[{start_date},{end_date}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];

		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 	
		$start_date ='';
		$end_date = '';		

			$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();		
		
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d', strtotime($start_date));
            $end_date=date('Y-m-d', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
		
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d", $Starts);
			$end_date  = date("Y-m-d", $Ends);			
		
			$sql="select 								  
			DATE(x.date) as date_time,
			sum(x.impressions) as impressions,
			sum(x.clicks) as clicks,
			sum(x.ctr) as ctr,			
			round(sum(x.total_revenue),2) as spend,	
			x.domain_name as websitesname			
			from
			".$table_prefix."xandr_site_reports as x		
			where		
			x.date between '".$start_date."'
			AND '".$end_date."' ORDER BY x.ctr DESC limit 5";
			$sth = $this->db->prepare($sql);
			$sth->execute();	
			$todos = $sth->fetchAll();	
		

// if there is no website avaliable it should not return null to front end js
           $no_website=array();
			for($i=0;$i<count($todos);$i++){
				$websitesname = $todos[$i]['websitesname'];
				if($todos[$i]['websitesname']==null){
					$no_website[]=$websitesname ;
				}
			}

			if(count($todos)==count($no_website)){
				$response = array('response'=>'ok','msg'=>'No Stats Available');
				return $this->response->withJson($response);
			}

			
			
		

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
	
  
}
 
});






//Campaign Report Statistics
// $app->get('/get_advertiser_campaign_xender_report_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
// {
	$app->get('/get_advertiser_campaign_report_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them group by campaignid h.ad_id as ad_id,b.bannerid as bannerid,b.description as bannername,
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date ='';
		$end_date = '';
		if($client)
		{
			$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			


			$sql="select 
		cl.clientid as clientid,
		cl.clientname as clientname,
		c.campaignname as campaignname,
		DATE(h.date_time) as date_time,	
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.requests) as requests,
		round(sum(h.total_revenue),0) as revenue,
		
		round((sum(h.clicks)/sum(h.impressions)),0) * 100 as ctr,
		round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl 
		where
		h.ad_id = b.bannerid
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by c.campaignid";
			// $sql="select 

			// sum(x.impressions) as xandr_impressions,
			// sum(x.clicks) as xandr_clicks,
			// sum(x.ctr) as xandr_ctr,	
			// round(sum(x.total_revenue),2) as revenue,	
			// sum(x.ecpm) as xandr_ecpm,		
			// round((Sum(h.total_revenue)/sum(x.impressions))*1000,0) as xandr_ecpm	,
			// round(sum(x.total_revenue),2) as spend,
			// sum(x.total_convs) as conversions,
			// cl.clientid as clientid,
			// cl.clientname as clientname,
			// b.campaignid as campaignid,
			// c.campaignname as campaignname,
			// DATE(h.date_time) as date_time,		
			// sum(h.requests) as requests		
			
			// from
			// ".$table_prefix."data_summary_ad_hourly as h,
			// ".$table_prefix."banners as b,
			// ".$table_prefix."campaigns as c,
			// ".$table_prefix."clients as cl ,
			// ".$table_prefix."xandr_reports as x 
			// where
			// x.creative_id = b.xandrcreativeid
			// AND
			// h.ad_id = b.bannerid
			// AND c.campaignid = b.campaignid
			// AND c.clientid = cl.clientid
			// AND cl.clientid = :advertiserid
			// AND h.date_time between '".$start_date."'
			// AND '".$end_date."' group by campaignid";

			$sth = $this->db->prepare($sql);
			
			$sth->bindParam(":advertiserid",$advertiser_id);
			
			$sth->execute();

		    $todos = $sth->fetchAll();

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));
// $app->get('/get_advertiser_campaign_report_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
// {
	$app->get('/get_advertiser_campaign_xender_report_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them group by campaignid h.ad_id as ad_id,b.bannerid as bannerid,b.description as bannername,
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date ='';
		$end_date = '';
		if($client)
		{
			$TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			$sql="select 

			sum(x.impressions) as xandr_impressions,
			sum(x.clicks) as xandr_clicks,
			round(sum(x.ctr),2) as xandr_ctr,			
			round(sum(x.ecpm),2) as xandr_ecpm,

			round(sum(x.total_revenue),2) as revenue,	
			round(sum(x.total_revenue),2) as spend,
			sum(x.total_convs) as conversions,
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			DATE(h.date_time) as date_time,		
			sum(h.requests) as requests		
			
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl ,
			".$table_prefix."xandr_reports as x 
			where
			x.creative_id = b.xandrcreativeid
			AND
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' group by c.campaignid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);

			$sth->execute();

		    $todos = $sth->fetchAll();

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));

// All Advertiser Campaign Statistics
$app->get('/get_all_advertiser_campaign__xender_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		if($client)
		{
			
			$sql="select 

			sum(x.impressions) as xandr_impressions,
			sum(x.clicks) as xandr_clicks,
			round(sum(x.ctr),2) as xandr_ctr,			
			round(sum(x.ecpm),2) as xandr_ecpm,		
			round(sum(x.total_revenue),2) as revenue,	
			
			round(sum(x.total_revenue),2) as spend,
			sum(x.total_convs) as conversions,
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			DATE(h.date_time) as date_time,		
			sum(h.requests) as requests		
			
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl ,
			".$table_prefix."xandr_reports as x 
			where
			x.creative_id = b.xandrcreativeid
			AND
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			 group by campaignid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		
		$todos = $sth->fetchAll();

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});

$app->get('/get_all_advertiser_campaign_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		if($client)
		{
			
			$sql="select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			h.ad_id as ad_id,
			b.bannerid as bannerid,
			b.description as bannername,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			group by b.campaignid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		
		$todos = $sth->fetchAll();

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});

//Advertiser Banner Statistics

$app->get('/get_advertiser_banner_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
		
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		
        $start_date ='';
		$end_date = '';
		if($client)
		{
	        $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			$sql="select 
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			b.description as bannername,
			cl.clientid as clientid,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl
			where
			h.ad_id = b.bannerid
			AND c.clientid = :advertiserid
			AND cl.clientid = c.clientid
			AND b.campaignid = c.campaignid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' GROUP BY ad_id";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));

//All Advertiser Banner Statistics
$app->get('/get_all_advertiser_banner_xender_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix']; 
		$advertiser_id = $args['advertiser_id']; 
		
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
		$sql="select 
		h.ad_id as ad_id,
		DATE(h.date_time) as date_time,
		sum(x.impressions) as impressions,
		sum(x.clicks) as clicks,
		sum(x.total_convs) as conversions,
		round(sum(x.total_revenue),2) as revenue,
		b.bannerid as bannerid,
		b.campaignid as campaignid,
		b.description as bannername,
		cl.clientid as clientid,		
		round((sum(x.clicks)/sum(x.impressions)) * 100,2) as ctr,
		round((Sum(x.total_revenue)/sum(x.impressions))*1000,2) as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl,
		".$table_prefix."xandr_reports as x 
		where
		x.creative_id = b.xandrcreativeid
	    AND
		h.ad_id = b.bannerid
		AND c.clientid = :advertiserid
		AND cl.clientid = c.clientid
		AND b.campaignid = c.campaignid
		GROUP BY ad_id";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});
$app->get('/get_all_advertiser_banner_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix']; 
		$advertiser_id = $args['advertiser_id']; 
		
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
		$sql="select 
		h.ad_id as ad_id,
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		round(sum(h.total_revenue),2) as revenue,
		b.bannerid as bannerid,
		b.campaignid as campaignid,
		b.description as bannername,
		cl.clientid as clientid,		
		round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
		round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl
		where
		h.ad_id = b.bannerid
		AND c.clientid = :advertiserid
		AND cl.clientid = c.clientid
		AND b.campaignid = c.campaignid
		GROUP BY ad_id";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});

//Advertiser Campaignwise Banner Statistics
$app->get('/get_advertiser_campaignwise_banner_xender_statistics/[{start_date},{end_date},{advertiser_id},{campaign_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
		$campaign_id = $args['campaign_id']; 
		
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date ='';
		$end_date = '';

		if($client)
		{
	        $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			$sql="select 
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(x.impressions) as impressions,
			sum(x.clicks) as clicks,
			sum(x.total_convs) as conversions,
			round(sum(x.total_revenue),2) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			b.description as bannername,
			cl.clientid as clientid,		
			round((sum(x.clicks)/sum(x.impressions)) * 100,2) as ctr,
			round((Sum(x.total_revenue)/sum(x.impressions))*1000,2) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."xandr_reports as x 
		    where
		    x.creative_id = b.xandrcreativeid
	        AND
			h.ad_id = b.bannerid
			AND c.clientid = :advertiserid
			AND c.campaignid = :campaignid
			AND cl.clientid = c.clientid
			AND b.campaignid = c.campaignid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' GROUP BY ad_id";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);
			$sth->bindParam(":campaignid",$campaign_id);

			$sth->execute();
			$todos = $sth->fetchAll();
			if($todos)
			{
			return $this->response->withJson($todos);
	       }else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	    }
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));


$app->get('/get_advertiser_campaignwise_banner_statistics/[{start_date},{end_date},{advertiser_id},{campaign_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
		$campaign_id = $args['campaign_id']; 
		
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date ='';
		$end_date = '';

		if($client)
		{
	        $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			$sql="select 
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			b.description as bannername,
			cl.clientid as clientid,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl
			where
			h.ad_id = b.bannerid
			AND c.clientid = :advertiserid
			AND c.campaignid = :campaignid
			AND cl.clientid = c.clientid
			AND b.campaignid = c.campaignid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' GROUP BY ad_id";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid",$advertiser_id);
			$sth->bindParam(":campaignid",$campaign_id);

			$sth->execute();
			$todos = $sth->fetchAll();
			if($todos)
			{
			return $this->response->withJson($todos);
	       }else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	    }
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));



/*--------------- End of Advertiser Statistics ------------*/







$app->get('/get_advertiser_banner_xender_report_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
		
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		
        $start_date ='';
		$end_date = '';
		if($client)
		{
	        $TimeZone="SELECT apa.value AS timezone FROM ".$table_prefix."accounts AS a JOIN ".$table_prefix."account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN ".$table_prefix."preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";	
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;
			
			$timezone = $TimeZoneRow[0]['timezone'];
			
			$start_date=date('Y-m-d 00:00:00', strtotime($start_date));
            $end_date=date('Y-m-d 23:59:59', strtotime($end_date));
			
			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date  = date("Y-m-d H:i:s", $Ends);
			
			
			$sql="select 
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(x.impressions) as impressions,
			sum(x.clicks) as clicks,
			sum(x.total_convs) as conversions,
			round(sum(x.total_revenue),2) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			b.description as bannername,
			cl.clientid as clientid,		
			round((sum(x.clicks)/sum(x.impressions)) * 100,2) as ctr,
			round((Sum(x.total_revenue)/sum(x.impressions))*1000,2) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."xandr_reports as x 
			where
			x.creative_id = b.xandrcreativeid
			AND
			h.ad_id = b.bannerid
			AND c.clientid = :advertiserid
			AND cl.clientid = c.clientid
			AND b.campaignid = c.campaignid
			AND h.date_time between '".$start_date."'
			AND '".$end_date."' GROUP BY ad_id";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));


/*--------------- Start of Publisher Statistics ------------*/




/*--------------- End of Publisher Statistics ------------*/










