<?php
include('session.php');
include('../config.php'); 
include('../common.php');

$parameter = $_SERVER['QUERY_STRING'];
$parameters  = explode("&", $parameter );
$title  = explode("=", $parameters[1] );
$startdate  = explode("=", $parameters[2] );
$enddate  = explode("=", $parameters[3] );
$title=$title[1] ;
$title  = explode("%", $title );
$startdate=$startdate[1];
$enddate=$enddate[1];
$title =$title[0];
            
?>
<!DOCTYPE html>
<!-- beautify ignore:start -->
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="../assets/" data-template="vertical-menu-template-free">
  <head>
  <title><?php echo $title; ?> - Campaign Report</title>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
  <meta name="description" content="" />
  <style>
    .text-hide{
    display: block;
    width: 125px;
    overflow: hidden;
    white-space: nowrap;
    text-overflow: ellipsis;
    }

    .tooltip {
      position: relative;
      display: inline-block;
    }

    .tooltip .tooltiptext {
      visibility: hidden;
      width: 120px;
      background-color: gray;
      color: #fff;
      text-align: center;
      border-radius: 6px;
      padding: 5px 0;
    
      /* Position the tooltip */
      position: absolute;
      z-index: 1;
    }
    
    .tooltip:hover .tooltiptext {
      visibility: visible;
    }

    .text-hide:hover{
    overflow: inherit;
    width: auto;
    }

    .wrapper 
    {
        width: 100%;
        display: block;
        overflow: hidden;
        margin: 0 auto;
        padding: 60px 50px;
        background: #fff;
        border-radius: 4px;
    }

    .bar_canvas {
        background: #fff;
        height: 300px;
    }
    
    .loader
    {
        display: none;
        position: fixed;
        width: 100%;
        height: 100%;
        top: 0;
        left: 0;
        z-index: 999;
        background: rgba(255,255,255,0.8) url("../assets/img/loader.gif") center no-repeat;
    }

    /* colse button */
    .dataTables_wrapper .dataTables_filter input:not(:valid):not(:focus){
	   box-shadow: 0 0 5px #fff!important;
		}
		.dataTables_wrapper .dataTables_filter input::-webkit-search-cancel-button {
		  -webkit-appearance: none!important;
		}
		.dataTables_wrapper .dataTables_filter button{
		  visibility: hidden;
		  outline: none;
		}
		.dataTables_wrapper .dataTables_filter input:valid ~ button{
		  visibility: visible;
		}
    </style>

    <?php include('head.php'); ?>
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.6.0/Chart.min.js"></script>
  </head>

  <body onload="getDashboardDay()">
  <div class="loader"></div>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->
        <?php include('sidebar.php'); ?>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->
          <?php include('navbar.php'); ?>
          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->
            <div class="container-xxl flex-grow-1 container-p-y">
                <div class="row">
                    <div class="col col-xs-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                        <div class="d-flex justify-content-start">
                           <!-- <p class="h3">Campaign Report</p> -->
                        <p class='h4'><?php echo $GLOBALS['strReport_Campaign_Report_Head']; ?></p>
                            <input type="hidden" name="clientid" id="clientid" value="<?php echo $_SESSION['clientid']; ?>">
                        </div>
                    </div>
     
                </div>

                <div class="row mt-1 d-flex justify-content-center">
                    <!-- Campaign Chart -->
                    <div class="col col-xs-12 col-sm-12 col-md-11 col-lg-7 col-xl-8 col-xxl-8">
                        <div class="col-12 col-lg-12 order-2 order-md-3 order-lg-2 mb-4">
                            <div class="card">
                              <div class="row row-bordered g-0">
                                <div class="col-md-12" >
                                    <div class='card-body'>
                                        <div class='container'>
                                            <div class="row">
                                                <div class="col col-xs-6 col-sm-6 col-md-6 col-lg-6 col-xl-6">
                                                <h5 class="card-header"><?php echo $title; ?>-Campaign</h5>

                                                <!-- <h5 class="card-header m-0 me-2 pb-3"><?php echo $title; ?>-Campaign</h5> -->
                                                </div>
                                                <div class="col col-xs-6 col-sm-6 col-md-6 col-lg-6 col-xl-6">
                                                    <div class="d-flex justify-content-end">
                                                        <div class="w-50 mt-4" style="margin-right: 6%;">
                                                            <select id='campaignGraph' class="form-select text-dark" onchange="getDashboardDay()">
                                                                <!-- <option value="impression" selected>Impression</option>
                                                                <option value="clicks">Clicks</option>
                                                                <option value="conversion">Conversion</option>
                                                                <option value="ctr">CTR</option>
                                                                <option value="ecpm">ECPM</option> -->
                                                        
                                                                <option value="impression"><?php echo $GLOBALS['strImpression']; ?></option>
                                                                <option value="clicks"><?php echo $GLOBALS['strClicks']; ?></option>
                                                                <option value="conversion"><?php echo $GLOBALS['strConversion']; ?></option>
                                                                <option value="ctr"><?php echo $GLOBALS['strCTR']; ?></option>
                                                                <option value="ecpm"><?php echo $GLOBALS['strECPM']; ?></option>

                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class='d-flex justify-content-end'>
                                                <div class="mt-3">
                                                    <button class="btn" type="button" data-bs-toggle="modal" title="Campaign Chart Zoom"
                                                        data-bs-target="#fullscreenModal" id='zoomButton'>
                                                        <i class="fa fa-arrows-alt text-primary"></i>
                                                    </button>
                                                </div>
                                                <div class="modal fade" id="fullscreenModal" tabindex="-1" aria-hidden="true">
                                                    <div class="modal-dialog modal-fullscreen" role="document">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <!-- <h5 class="modal-title" id="modalFullTitle">Campaign Chart</h5> -->
                                                                <h5 class="modal-title" id="modalFullTitle"><?php echo $GLOBALS['campaignChart']; ?></h5>

                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <canvas id="line-chart2"></canvas>
                                                                <script>
                                                                    function campaignChart(campaignName, ImpressionValue, clickValue, conversionsValue, ctrValue, ecpmValue) {
                                                                        var getValue = document.getElementById('campaignGraph').value;
                                            
                                                                      var zoomCampaignChart = new Chart(document.getElementById("line-chart2"), {
                                                                            type: 'line',
                                                                            data: {
                                                                                labels: campaignName,
                                                                                datasets: [{
                                                                                    data: getValue == 'impression' ? ImpressionValue : getValue == 'clicks' ? clickValue :
                                                                                        getValue == 'conversion' ? conversionsValue :
                                                                                            getValue == 'ctr' ? ctrValue : getValue == 'ecpm' ? ecpmValue : "",
                                                                                    label: getValue == 'impression' ? "impression" : getValue == 'clicks' ? "Clicks" :
                                                                                        getValue == 'conversion' ? "Conversion" : 
                                                                                            getValue == 'ctr' ? "CTR" : getValue == 'ecpm' ? "ECPM" : "",
                                                                                    borderColor: getValue == 'impression' ? "#3e95cd" : getValue == 'clicks' ? "#8e5ea2" :
                                                                                        getValue == 'conversion' ? "#e83e8c" : 
                                                                                            getValue == 'ctr' ? "#c45850" : getValue == 'ecpm' ? "#fd7e14" : "",
                                                                                    fill: false
                                                                                }]
                                                                            },
                                                                            options: {
                                                                                responsive: true,
                                                                                title: {
                                                                                    display: true,
                                                                                    // text: 'Campaign Chart'
                                                                                    text: `<?php echo $GLOBALS['campaignChart']; ?>`

                                                                                },
                                                                                layout:{
                                                                                    padding:5
                                                                                },
                                                                                scales: {
                                                                                    xAxes: [{
                                                                                        display: true,
                                                                                        scaleLabel: {
                                                                                            display: true,
                                                                                            // labelString: '13-03-2023 to 18-03-2023'
                                                                                        },
                                                                                        labelWrap: true,
                                                                                        ticks: {
                                                                                            maxRotation: 90,
                                                                                            minRotation: 90
                                                                                        }
                                                                                    }],
                                                                                    yAxes: [
                                                                                        {
                                                                                            display: true,
                                                                                            scaleLabel: {
                                                                                                display: true
                                                                                            }
                                                                                        }
                                                                                    ]
                                                                                }
                                                                            }
                                                                        });

                                                                        var checkChart = document.getElementById("campaignGraph");
                                                                        campaignGraph.addEventListener("change", function () {
                                                                            zoomCampaignChart.destroy();
                                                                        });
                                                                    };
                                                                </script>
                                                            </div>
                                                        </div>
                                                   </div>
                                               </div>
                                            </div>
                                        </div>
                                        <div class='container'>
                                            <canvas id="line-chart1"></canvas>
                                            <script>
                                                function testChart(campaignName, ImpressionValue, clickValue, conversionsValue, ctrValue, ecpmValue) {
                                                    $(".loader").hide();
                                                    var getValue = document.getElementById('campaignGraph').value;

                                                    var newChart = new Chart(document.getElementById("line-chart1"), {
                                                        type: 'line',
                                                        data: {
                                                            labels: campaignName,
                                                            datasets: [{
                                                                data: getValue == 'impression'?ImpressionValue:getValue == 'clicks'?clickValue:
                                                                      getValue == 'conversion'?conversionsValue:
                                                                      getValue == 'ctr'?ctrValue:getValue == 'ecpm'?ecpmValue:"",
                                                                // label:getValue == 'impression'?"impression":getValue == 'clicks'?"Clicks":
                                                                //       getValue == 'conversion'?"Conversion":
                                                                //       getValue == 'ctr'?"CTR":getValue == 'ecpm'?"ECPM":"",


                                                                label:getValue == 'impression'?`<?php echo $GLOBALS['strImpression']; ?>`:getValue == 'clicks'?`<?php echo $GLOBALS['strClicks']; ?>`:                                                                
                                                                      getValue == 'conversion'?`<?php echo $GLOBALS['strConversion']; ?>`:
                                                                      getValue == 'ctr'?`<?php echo $GLOBALS['strCTR']; ?>`:getValue == 'ecpm'?`<?php echo $GLOBALS['strECPM']; ?>`:"",
                                                                borderColor:getValue == 'impression'?"#3e95cd":getValue == 'clicks'?"#8e5ea2":
                                                                            getValue == 'conversion'?"#e83e8c":
                                                                            getValue == 'ctr'?"#c45850":getValue == 'ecpm'?"#fd7e14":"",
                                                                fill: false
                                                            }]
                                                        },
                                                        options: {
                                                            responsive: true,
                                                            title: {
                                                                display: true,
                                                                // text: 'Campaign Chart'
                                                                text: `<?php echo $GLOBALS['campaignChart']; ?>`

                                                            },
                                                            layout:{
                                                                padding:5
                                                            },
                                                            // hover: {mode: null},
                                                            // events: [],
                                                            scales: {
                                                                xAxes: [{
                                                                    display: true,
                                                                    scaleLabel: {
                                                                        display: true,
                                                                        // labelString: "Campaign Name"
                                                                    },
                                                                    labelWrap: true,
                                                                    ticks: {
                                                                        maxRotation: 90,
                                                                        minRotation: 90
                                                                    },
                                                                }],
                                                                yAxes: [
                                                                    {
                                                                        display: true,
                                                                        scaleLabel: {
                                                                            display: true
                                                                        }
                                                                    }
                                                                ]
                                                            }
                                                        }
                                                   });

                                                    var checkChart = document.getElementById("campaignGraph");
                                                    campaignGraph.addEventListener("change", function() {
                                                        newChart.destroy();
                                                    });
                                                };
                                            </script>
                                        </div>
                                    </div>
                                </div>
                              </div>
                            </div>
                          </div>
                    </div>
                    
                    <!-- weights - Request, Impress, Click, Conversion  -->
                    <div class="col col-xs-12 col-sm-12 col-md-11 col-lg-4 col-xl-4 col-xxl-4">
                        <div class="row mb-4 mt-sm-2 mt-md-2 mt-lg-5 mt-xl-5 mt-xxl-5">
                            <div class="col col-xs-12 col-sm-6 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                <div class="card" style='width:95%'>
                                    <div class="card-body text-center">
                                        <i class="fa  fa-podcast  fa-2x text-primary"  aria-hidden="true"></i>
                                        <span class="fw-semibold d-block text-primary  h6 mt-2 mb-2"><b><?php echo $GLOBALS['strImpression']; ?></b></span>
                                        <h3 class="card-title mb-1" id="imp">0</h3>                                        
                                    </div>
                                </div>
                            </div>
                            <div class="col col-xs-12 col-sm-6 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                <div class="card" style='width:95%'>
                                    <div class="card-body text-center">
                                        <i class="fa fa-external-link  fa-2x text-primary" aria-hidden="true"></i>
                                        <span class="fw-semibold d-block text-primary h6 mt-2 mb-2"><b><?php echo $GLOBALS['strClicks']; ?></b></span>
                                        <h3 class="card-title  mb-1" id="cli">0</h3>                                        
                                    </div>
                                  </div>
                            </div>
                        </div>
                        <div class="row mb-4 mt-2">
                        <div class="col col-xs-12 col-sm-6 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                <div class="card" style='width:95%'>
                                    <div class="card-body text-center">
                                        <i class="fa  fa-hand-pointer-o  fa-2x text-primary" aria-hidden="true"></i>
                                        <span class="fw-semibold d-block  text-primary h6 mt-2 mb-2"><b><?php echo $GLOBALS['strConversion']; ?></b></span>
                                        <h3 class="card-title text-nowrap mb-1" id="con">0</h3>                                      
                                    </div>
                                </div>
                            </div>                         
                        </div>                        
                    </div>
                </div>                                        
            </div>
        </div>

        <!-- / Content -->
        <?php include('footer.php'); ?>        
        <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
        <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
        <script>
            var live_URL = '<?php echo $apistatpath; ?>';           
            var token = 'Bearer ' + document.getElementById('token').value;

            var urlParams = new URLSearchParams(window.location.search);
            var url_string =urlParams.toString();           
            var url_parameters = url_string.split('&');           
            var campid=url_parameters[0];
            var campid = campid.split('=');
            var campaign_id =campid[1];
           
            function getDashboardDay() {
                
                var urlParams = new URLSearchParams(window.location.search);
                var url_string =urlParams.toString();
                var url_parameters = url_string.split('&');
               
                var campid=url_parameters[0];
                var startdate=url_parameters[2];
                var enddate=url_parameters[3];
                var domaintype=url_parameters[4];

                var campid = campid.split('=');
                var campaign_id =campid[1];

                var startdate = startdate.split('=');
                var startdate =startdate[1];

                var enddate = enddate.split('=');
                var enddate =enddate[1];

                var domaintype = domaintype.split('=');
                var domaintype =domaintype[1];

                var getTypeofreports = $("#getTypeofreports").val();
                console.log('getTypeofreports....2',getTypeofreports);



              

                if( startdate=='undefined' || enddate=='undefined' ){

                    var getCampaign = $("#getCampaign").val();

                    campaign_url=live_URL + '/get_all_dashboard_campaign_graph_statistics/'+ campaign_id;

                    console.log('domaintype',domaintype);
                    if(domaintype=='revive'){
                        campaign_url=live_URL + '/get_all_dashboard_campaign_graph_statistics/'+ campaign_id;

                    }else{
                        campaign_url=live_URL + '/get_all_xandr_dashboard_campaign_graph_statistics/'+ campaign_id;


                    }


                }else{

                    var getCampaign = $("#getCampaign").val();
                    console.log('getCampaign....2',getCampaign);

                    if(domaintype=='revive'){
                        campaign_url=live_URL + '/get_revive_campaign_graph_statistics/' + startdate+' 00:00:00,' + enddate +' 23:59:59,'+ campaign_id;

                    }else{
                        campaign_url=live_URL + '/get_dashboard_campaign_graph_statistics/' + startdate+' 00:00:00,' + enddate +' 23:59:59,'+ campaign_id;

                    }

                }

                
                // Campaign Chart Start
                $.ajax({
                    // url: live_URL + '/get_all_dashboard_campaign_graph_statistics/' + startdate+' 00:00:00,' + enddate +' 23:59:59,'+ campaign_id,

                    url: campaign_url ,
                    type: 'GET',
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: {},
                    success: function (data) {
                        console.log('data123..',data);

                        if (data.msg == 'No Stats Available') {
                            testChart(campaignName = [], ImpressionValue = [], clickValue = [],
                                conversionsValue = [], revenueValue = [], ctrValue = [],
                                ecpmValue = []);
                                $("#zoomButton").hide();

                            document.getElementById("zoomButton").disabled = true;
                            document.getElementById("zoomButton").title="No data, so button disabled";
                        }
                        else {
                            $(".loader").show();
                            $("#zoomButton").hide();

                            document.getElementById("zoomButton").disabled = true;
                            document.getElementById("zoomButton").title="No data, so button disabled";

                            // document.getElementById("zoomButton").disabled = false;
                            // document.getElementById("zoomButton").title="Zoom Button";

                            let campaignName = data.map((data) => {
                                return data.campaignname;
                            });

                            let ImpressionValue = data.map((data, index) => {
                                if (data.impressions == null) {
                                    return data.impressions[index] = 0;
                                }
                                else {
                                    return data.impressions;
                                }
                            });

                            let clickValue = data.map((data) => {
                                if (data.clicks == null) {
                                    return data.clicks[index] = 0;
                                }
                                else {
                                    return data.clicks;
                                }
                            });

                            var conversionsValue = data.map((data) => {
                                if (data.conversions == null) {
                                    return data.conversions[index] = 0;
                                }
                                else {
                                    return data.conversions;
                                }
                            });

                           /* var revenueValue = data.map((value, index) => {
                                // let convert = parseInt(value.revenue, 10);
                                console.log(value.revenue);
                                if (value.revenue == null || value.revenue == 'null' || value.revenue == '') {
                                    return value.revenue[index] = 0;
                                }
                                else {
                                    return value.revenue;
                                }
                                console.log('after_rev: '+value.revenue);
                            }); */

                            var ctrValue = data.map((data, index) => {
                                if (data.ctr == null) {
                                    return data.ctr = 0;
                                }
                                else {
                                    return data.ctr;
                                }
                            });

                            var ecpmValue = data.map((data, index) => {
                                if (data.ecpm == null) {
                                    return data.ecpm = 0; 
                                }
                                else {
                                    return data.ecpm;
                                }
                            });

                            campaignChart(campaignName, ImpressionValue, clickValue, conversionsValue, ctrValue, ecpmValue);
                            testChart(campaignName, ImpressionValue, clickValue, conversionsValue, ctrValue, ecpmValue);
                        }
                    },
                    error: function () { },
                });
                // Campaign Chart End

                // Start impression, click, request and conversion
                $.ajax({
                    // url: widgets_url + startDate + ' 00:00:00,' + endDate + ' 23:59:59,' + campid,
                    // url: live_URL + '/get_all_dashboard_campaign_graph_statistics/' + startdate +' 00:00:00,'+ enddate +' 23:59:59,'+ campaign_id,
                    url: campaign_url ,
                    type: 'GET',
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: {},
                    success: function (data) {
                       
                        $(".loader").hide();
                        if (data.msg == 'No Stats Available') {
                            document.getElementById('imp').innerHTML = 0;
                            document.getElementById('cli').innerHTML = 0;
                            document.getElementById('con').innerHTML = 0;
                            // document.getElementById('req').innerHTML = 0;
                        }
                        
                        else {
                            const entries = Object.values(data);
                            console.log('entries...',entries);
                            // entries[0]['requests'] == null 
                            if (entries[0]['impressions'] == null && entries[0]['clicks'] == null && entries[0]['conversions'] == null) {
                                // document.getElementById('req').innerHTML = 0;
                                document.getElementById('imp').innerHTML = 0;
                                document.getElementById('cli').innerHTML = 0;
                                document.getElementById('con').innerHTML = 0;
                            }
                            else {
                                // document.getElementById('req').innerHTML = Number(data[0].requests).toLocaleString("en-IN");
                                document.getElementById('imp').innerHTML = Number(data[0].impressions).toLocaleString("en-IN");
                                document.getElementById('cli').innerHTML = Number(data[0].clicks).toLocaleString("en-IN");
                                document.getElementById('con').innerHTML = Number(data[0].conversions).toLocaleString("en-IN");
                            }
                        }
                    },
                    error: function () { },
                });
                // End impression, click, request and conversion
                            
            };
        </script>
        <!-- <script src="../assets/js/config.js"></script> -->
        <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>
  </body>
</html>
