<?php
include('session.php');
include('../config.php');
include('../common.php');

?>
<!DOCTYPE html>
<!-- beautify ignore:start -->
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="../assets/" data-template="vertical-menu-template-free">
  <head>
  <title><?php echo $title; ?> - Campaign Report</title>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
  <meta name="description" content="" />
  <style>
    .text-hide{
    display: block;
    width: 125px;
    overflow: hidden;
    white-space: nowrap;
    text-overflow: ellipsis;
    }

    .tooltip {
      position: relative;
      display: inline-block;
    }

    .tooltip .tooltiptext {
      visibility: hidden;
      width: 120px;
      background-color: gray;
      color: #fff;
      text-align: center;
      border-radius: 6px;
      padding: 5px 0;
    
      /* Position the tooltip */
      position: absolute;
      z-index: 1;
    }
    
    .tooltip:hover .tooltiptext {
      visibility: visible;
    }

    .text-hide:hover{
    overflow: inherit;
    width: auto;
    }

    .wrapper 
    {
        width: 100%;
        display: block;
        overflow: hidden;
        margin: 0 auto;
        padding: 60px 50px;
        background: #fff;
        border-radius: 4px;
    }

    .bar_canvas {
        background: #fff;
        height: 300px;
    }
    
    .loader
    {
        display: none;
        position: fixed;
        width: 100%;
        height: 100%;
        top: 0;
        left: 0;
        z-index: 999;
        background: rgba(255,255,255,0.8) url("../assets/img/loader.gif") center no-repeat;
    }

    /* colse button */
    .dataTables_wrapper .dataTables_filter input:not(:valid):not(:focus){
	   box-shadow: 0 0 5px #fff!important;
		}
		.dataTables_wrapper .dataTables_filter input::-webkit-search-cancel-button {
		  -webkit-appearance: none!important;
		}
		.dataTables_wrapper .dataTables_filter button{
		  visibility: hidden;
		  outline: none;
		}
		.dataTables_wrapper .dataTables_filter input:valid ~ button{
		  visibility: visible;
		}
    </style>

    <?php include('head.php'); ?>
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.6.0/Chart.min.js"></script>
  </head>

  <body onload="onChangeDetails();">
  <div class="loader"></div>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->
        <?php include('sidebar.php'); ?>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page" id="myImage">
          <!-- Navbar -->
          <?php include('navbar.php'); ?>
          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->
            <div class="container-xxl flex-grow-1 container-p-y">
                <div class="row mb-4">
                    <div class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                        <div class="d-flex justify-content-start">
                            <p class="h4" id='reportTitle'><?php echo $GLOBALS['strReport_Banner_Report_Head']; ?></p>
                            <input type="hidden" name="clientid" id="clientid" value="<?php echo $_SESSION['clientid']; ?>">
                        </div>
                    </div>
                    <div class="col col-12 col-sm-12 col-md-8 col-lg-8 col-xl-8 col-xxl-8 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                        <div class="row">
                            <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                <select id="getCampaign" class="form-select text-dark" aria-label="Default select example" onchange="onChangeDetails()">
                                    <option value="Today"><?php echo $GLOBALS['strToday']; ?></option>
                                    <option value="Yesterday"><?php echo $GLOBALS['strYesterday']; ?></option>
                                    <option selected value="Last 7 days"><?php echo $GLOBALS['strLast 7 days']; ?></option>
                                    <option value="Last 30 days"><?php echo $GLOBALS['strLast 30 days']; ?></option>
                                    <!-- <option value="Last Month"><?php echo $GLOBALS['strLast Month']; ?></option> -->
                                    <!-- <option value="This Month"><?php echo $GLOBALS['strThis Month']; ?></option> -->
                                    <!-- <option value='all statistics'><?php echo $GLOBALS['strAll Statistics']; ?></option> -->
                                    <option value="custom"><?php echo $GLOBALS['strCustom']; ?></option>
                                </select>
                                <input style="display: none; width: 95%; margin-left:3%" id="daterange" name="daterange" class='mt-2'  />
                            </div>
                            <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                <select id="getTypeofreports" class="form-select text-dark" onchange="onChangeDetails()"></select>
                            </div>
                        </div>
                    </div>
     
                </div>

                <div class="row mt-1 d-flex justify-content-center">
                    <!-- Campaign Chart -->
                    <div class="col col-xs-12 col-sm-12 col-md-9 col-lg-9 col-xl-9 col-xxl-9">
                        <div class="col-12 col-lg-12 order-2 order-md-3 order-lg-2 mb-4">
                            <div class="card">
                              <div class="row row-bordered g-0">
                                <div class="col-md-12" >
                                    <div class='card-body'>
                                        <div class='container'>
                                            <div class="row">
                                                <div class="col col-xs-6 col-sm-6 col-md-6 col-lg-6 col-xl-6">
                                                <h5 class="card-header" id="dynamic_bannerName"></h5>
                                                <!-- <h5 class="card-header m-0 me-2 pb-3"><?php echo $title; ?>-Campaign</h5> -->
                                                <div class="row text-dark" id="start_end_Date" style="margin-left: 3%;">
                                                        <div class="col col-6 col-sm-6 col-md-6 col-lg-6 col-xl-6 col-xx-6">
                                                            <p id="from_date" class="ml-4" style="width: 109%;"></p>
                                                        </div>
                                                        <div class="col col-6 col-xs-6 col-sm-6 col-md-6 col-lg-6 col-xl-6 col-xx-6">
                                                            <p id="to_date" style="width: 108%;"></p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col col-xs-6 col-sm-6 col-md-6 col-lg-6 col-xl-6">
                                                    <div class="d-flex justify-content-end">
                                                        <div class="w-75 mt-4" style="margin-right: 6%;">
                                                            <select id='campaignGraph' class="form-select text-dark" onchange="onChangeDetails()">
                                                                <option value="impression"><?php echo $GLOBALS['strImpression']; ?></option>
                                                                <!-- <option value="clicks"><?php echo $GLOBALS['strClicks']; ?></option> -->
                                                                <!-- <option value="conversion"><?php echo $GLOBALS['strConversion']; ?></option> -->
                                                                <!-- <option value="ctr"><?php echo $GLOBALS['strCTR']; ?></option> -->
                                                                <!-- <option value="ecpm"><?php echo $GLOBALS['strECPM']; ?></option> -->


                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class='container'>
                                            <canvas id="line-chart1"></canvas>
                                            <script>
                                                function testChart(bannername, ImpressionValue, clickValue, ctrValue, ecpmValue, AppType) {
                                                    $(".loader").hide();
                                                    var getValue = document.getElementById('campaignGraph').value;

                                                    var newChart = new Chart(document.getElementById("line-chart1"), {
                                                        type: 'line',
                                                        data: {
                                                            labels: bannername,
                                                            datasets: [{
                                                                data: getValue == 'impression'?ImpressionValue:"",
                                                                label:getValue == 'impression'?`<?php echo $GLOBALS['strImpression']; ?>`:"",
                                                                borderColor:
                                                                AppType == 'revive'?getValue == 'impression'?"#3e95cd":"":
                                                                AppType == 'xander'?getValue == 'impression'?"#FF0000":"":
                                                                AppType == 'website'?getValue == 'impression'?"#AA336A":"":"",
                                                                fill: false
                                                            }]
                                                        },
                                                        options: {
                                                            responsive: true,
                                                            events: ['click'],
                                                            title: {
                                                                display: true,
                                                                text: `<?php echo $GLOBALS['bannerChart']; ?>`
                                                            },
                                                            layout:{
                                                                padding:5
                                                            },
                                                            scales: {
                                                                xAxes: [{
                                                                    display: true,
                                                                    scaleLabel: {
                                                                        display: true,
                                                                    },
                                                                    labelWrap: true,
                                                                    ticks: {
                                                                        maxRotation: 90,
                                                                        minRotation: 90
                                                                    },
                                                                }],
                                                                yAxes: [
                                                                    {
                                                                        display: true,
                                                                        scaleLabel: {
                                                                            display: true
                                                                        }
                                                                    }
                                                                ]
                                                            }
                                                        }
                                                   });

                                                    var checkChart = document.getElementById("campaignGraph");
                                                    campaignGraph.addEventListener("change", function() {
                                                        newChart.destroy();
                                                    });
                                                };
                                            </script>
                                        </div>
                                    </div>
                                </div>
                              </div>
                            </div>
                          </div>
                    </div>
                    
                    <!-- weights - Request, Impress, Click, Conversion  -->
                    <div class="col col-xs-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3">
                        <div class="card mb-4 mt-sm-2 mt-md-2 mt-lg-5 mt-xl-5 mt-xxl-5 w-100">
                            <div class="card-body text-center">
                                <i class="fa  fa-podcast  fa-2x text-primary"  aria-hidden="true"></i>
                                <span class="fw-semibold d-block text-primary  h6 mt-2 mb-2"><b><?php echo $GLOBALS['strImpression']; ?></b></span>
                                <h3 class="card-title mb-1" id="imp">0</h3>
                            </div>
                        </div>

                        <div class="card w-100">
                            <div class="card-body text-center">
                                <i class="fa fa-external-link  fa-2x text-primary" aria-hidden="true"></i>
                                <span class="fw-semibold d-block text-primary h6 mt-2 mb-2"><b><?php echo $GLOBALS['strClicks']; ?></b></span>
                                <h3 class="card-title  mb-1" id="cli">0</h3>
                            </div>
                        </div>
                    </div>
                </div>
                
                </div>
            </div>
            <!-- / Content -->
        <?php include('footer.php'); ?>
        
        <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
        <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
        <script>
            let live_URL = '<?php echo $apistatpath; ?>';
            const token = 'Bearer ' + document.getElementById('token').value;
            let urlParams = new URLSearchParams(window.location.search);
            let url_string =urlParams.toString();
            let url_parameters = url_string.split('&');
            let getBannerId=url_parameters[0].split('=');
            let bannerid = getBannerId[1];
            let startdate=url_parameters[2];
            let enddate=url_parameters[3];
            const date = new Date();

            const appFilter =[
                {name: "<?php echo $GLOBALS['strXandr']; ?>", value:'Xandr'},
                {name: `<?php echo $GLOBALS['strRevive']; ?>`, value:'Revive'},
                {name: `<?php echo $GLOBALS['strAlloption']; ?>`, value:'all'},
            ];
            let mapAppFilter = appFilter.map((data, index) => {
                return `<option key=${index} value=${data.value}>${data.name}</option>`;
            });
            document.getElementById('getTypeofreports').innerHTML = mapAppFilter;

            onChangeDetails = () => {
                const date = new Date();
                let getTypeofreports = document.getElementById('getTypeofreports').value;
                let getSelectedDay = document.getElementById('getCampaign').value;
                let setDate;

                if (getSelectedDay == 'Today') {
                    document.getElementById('daterange').style.display = "none";
                    document.getElementById('start_end_Date').style.display = "compact";
                    let v3 = JSON.stringify(date);
                    v3 = v3.slice(1, 11);
                    setDate = v3;
                    if(getTypeofreports=='Xandr'){
                        getXandrDate(v3, v3);
                    }
                    else if (getTypeofreports=='Revive'){
                        getReviveDate(v3, v3);
                    }
                    else {
                        getAllWebsite(v3, v3);
                    }
                }
                else if (getSelectedDay == 'Yesterday') {
                    document.getElementById('daterange').style.display = "none";
                    document.getElementById('start_end_Date').style.display = "compact";
                    let current_date = date.setDate(date.getDate() - 1);
                    const get_date = new Date(date);
                    let yesterday_date = JSON.stringify(get_date);
                    yesterday_date = yesterday_date.slice(1, 11);
                    if(getTypeofreports=='Xandr'){
                        getXandrDate(yesterday_date, yesterday_date);
                    }
                    else if (getTypeofreports=='Revive'){
                        getReviveDate(yesterday_date, yesterday_date);
                    }
                    else {
                        getAllWebsite(yesterday_date, yesterday_date);
                    }
                }
                else if (getSelectedDay == 'Last 7 days') {
                    document.getElementById('daterange').style.display = "none";
                    document.getElementById('start_end_Date').style.display = "compact";
                    let date_start = date.setDate(date.getDate() - 7);
                    let get_date = new Date(date_start);
                    let first_day = JSON.stringify(get_date);
                    first_day = first_day.slice(1, 11);

                    let todayDate = new Date();
                    let current_date = todayDate.setDate(todayDate.getDate() - 1);
                    const last_7Days = new Date(todayDate);
                    let date_end = JSON.stringify(last_7Days);
                    date_end = date_end.slice(1, 11);
                    if(getTypeofreports=='Xandr'){
                        getXandrDate(first_day, date_end);
                    }
                    else if (getTypeofreports=='Revive'){
                        getReviveDate(first_day, date_end);
                    }
                    else {
                        getAllWebsite(first_day, date_end);
                    }
                }
                else if (getSelectedDay == 'Last 30 days') {
                    document.getElementById('daterange').style.display = "none";
                    document.getElementById('start_end_Date').style.display = "compact";
                    let date_start = date.setDate(date.getDate() - 30);
                    let get_date = new Date(date_start);
                    var first_day = JSON.stringify(get_date);
                    first_day = first_day.slice(1, 11);

                    let todayDate = new Date();
                    let current_date = todayDate.setDate(todayDate.getDate() - 1);
                    const last_30Days = new Date(todayDate);
                    let date_end = JSON.stringify(last_30Days);
                    date_end = date_end.slice(1, 11);
                    if(getTypeofreports=='Xandr'){
                        getXandrDate(first_day, date_end);
                    }
                    else if (getTypeofreports=='Revive'){
                        getReviveDate(first_day, date_end);
                    }
                    else {
                        getAllWebsite(first_day, date_end);
                    }
                }
                else if (getSelectedDay == 'This Month') {
                    document.getElementById('daterange').style.display = "none";
                    document.getElementById('start_end_Date').style.display = "compact";
                    let firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                    let cYear = firstDay.getFullYear(), cMonth = firstDay.getMonth() + 1, cDate = firstDay.getDate();
                    let first_day = cYear + "-" + cMonth + "-" + cDate;

                    let lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);
                    let year = lastDay.getFullYear(), month = lastDay.getMonth() + 1, day = lastDay.getDate();
                    let date_end = year + "-" + month + "-" + day;
                    if(getTypeofreports=='Xandr'){
                        getXandrDate(first_day, date_end);
                    }
                    else if (getTypeofreports=='Revive'){
                        getReviveDate(first_day, date_end);
                    }
                    else {
                        getAllWebsite(first_day, date_end);
                    }
                }
                else if (getSelectedDay == 'Last Month') {
                    document.getElementById('daterange').style.display = "none";
                    document.getElementById('start_end_Date').style.display = "compact";
                    let prevMonthLastDate = new Date(date.getFullYear(), date.getMonth(), 0);
                    let prevMonthFirstDate = new Date(date.getFullYear() - (date.getMonth() > 0 ? 0 : 1), (date.getMonth() - 1 + 12) % 12, 1);
                    let formatDateComponent = function (dateComponent) {
                        return (dateComponent < 10 ? '0' : '') + dateComponent;
                    }
                    var formatDate = function (date) {
                        return date.getFullYear() + "-" + formatDateComponent(date.getMonth() + 1) + "-" + formatDateComponent(date.getDate())
                    };
                    var start_date = formatDate(prevMonthFirstDate), end_date = formatDate(prevMonthLastDate);
                    getTypeofreports=='Xandr'?getXandrDate(start_date, end_date):
                    getTypeofreports=='Revive'?getReviveDate(start_date, end_date):getAllWebsite(start_date, end_date);
                }
                else if (getSelectedDay == 'all statistics') {
                    document.getElementById('daterange').style.display = "none";
                    document.getElementById('start_end_Date').style.display = "none";
                    start_date = 0, end_date = 0;
                    getTypeofreports=='Xandr'?getXandrDate(start_date, end_date):
                    getTypeofreports=='Revive'?getReviveDate(start_date, end_date):getAllWebsite(start_date, end_date);
                }
                else if (getSelectedDay == 'custom') {
                    document.getElementById('daterange').style.display = "block";
                    document.getElementById('start_end_Date').style.display = "compact";

                    let getCurrentDate = JSON.stringify(date).slice(1, 11);
                    getTypeofreports=='Xandr'?getXandrDate(getCurrentDate, getCurrentDate):
                    getTypeofreports=='Revive'?getReviveDate(getCurrentDate, getCurrentDate):getAllWebsite(getCurrentDate, getCurrentDate);

                    $(function () {
                        $('input[name="daterange"]').daterangepicker({
                            opens: 'left',
                            locale: {
                                format: 'DD/MM/YYYY'
                            },
                        }, function (start, end, label) {
                                var start_date = start.format('YYYY-MM-DD'), end_date = end.format('YYYY-MM-DD');
                                var domaintype = $("#getCampaign").val();
                                var getDuration=$("#getDuration").val();

                                localStorage.setItem("cust_startdate", start_date);
                                localStorage.setItem("cust_enddate", end_date);
                                                        
                                getTypeofreports=='Xandr'?getXandrDate(start_date, end_date):
                                getTypeofreports=='Revive'?getReviveDate(start_date, end_date):getAllWebsite(start_date, end_date);
                            }
                        )
                    });
                }
            };

            getXandrDate = (start_date,end_date) => {
                let AppType='xander';
                let getSelectedDay = document.getElementById('getCampaign').value;
                let campaign_startDate = localStorage.getItem('cust_startdate');
                let banner_EndDate = localStorage.getItem('cust_enddate');
                let getCurrentDate = JSON.stringify(date).slice(1, 11);

                if(getSelectedDay == 'custom'){
                    start_date=campaign_startDate;end_date=banner_EndDate;
                }
                else {
                    start_date=start_date;end_date=end_date;
                    localStorage.setItem('cust_startdate', getCurrentDate);
                    localStorage.setItem('cust_enddate', getCurrentDate);
                }
                document.getElementById('from_date').innerHTML = start_date;
                document.getElementById('to_date').innerHTML = end_date;

                // Campaign Chart Start
                $.ajax({
                    url: (start_date == 0 && end_date ==0)?live_URL + '/get_all_xandr_banner_graph_statistics/'+ bannerid:
                    live_URL + '/get_dashboard_banner_graph_statistics/' + start_date+' 00:00:00,' + end_date +' 23:59:59,'+ bannerid ,
                    type: 'GET',
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: {},
                    success: function (data) {

                        if (data.msg == 'No Stats Available') {
                            testChart(bannername = [], ImpressionValue = [], clickValue = [],
                                conversionsValue = [], revenueValue = [], ctrValue = [],
                                ecpmValue = []);

                            //widgets
                            document.getElementById('imp').innerHTML = 0;
                            document.getElementById('cli').innerHTML = 0;
                            
                            document.getElementById('dynamic_bannerName').innerHTML = `<?php echo $GLOBALS['no_banner']; ?>`;
                        }
                        else {
                            $(".loader").show();
                            document.getElementById('dynamic_bannerName').innerHTML = data[0].bannername1;

                            let bannername = data.map((data) => {
                                return data.bannername;
                            });

                            let ImpressionValue = data.map((data, index) => {
                                if (data.impressions == null) {
                                    return data.impressions[index] = 0;
                                }
                                else {
                                    return data.impressions;
                                }
                            });
                            let arr = [], sum=0;
                            let cal_imp = data.map((data) => {
                                arr.push(Number(data.impressions));
                            });
                            for(let i =0; i< arr.length; i++) {
                                sum += arr[i];
                            }

                            let clickValue = data.map((data) => {
                                if (data.clicks == null) {
                                    return data.clicks[index] = 0;
                                }
                                else {
                                    return data.clicks;
                                }
                            });
                            let arr1 =[], sum1 =0;
                            let cal2 = data.map((data) => {
                                arr1.push(Number(data.clicks));
                            });
                            for(let i =0; i< arr1.length; i++) {
                                sum1 += arr1[i];
                            }

                            var ctrValue = data.map((data, index) => {
                                if (data.ctr == null) {
                                    return data.ctr = 0;
                                }
                                else {
                                    return data.ctr;
                                }
                            });

                            var ecpmValue = data.map((data, index) => {
                                if (data.ecpm == null) {
                                    return data.ecpm = 0;
                                }
                                else {
                                    return data.ecpm;
                                }
                            });

                            testChart(bannername, ImpressionValue, clickValue, ctrValue, ecpmValue, AppType);

                            //widgets
                            const entries = Object.values(data);
                            if (entries[0]['impressions'] == null && entries[0]['clicks'] == null) {
                                document.getElementById('imp').innerHTML = 0;
                                document.getElementById('cli').innerHTML = 0;
                            }
                            else {
                                document.getElementById('imp').innerHTML =sum;
                                document.getElementById('cli').innerHTML =sum1;
                            }
                        }
                    },
                    error: function () { },
                });
                // Campaign Chart End
            };

            getReviveDate= (start_date,end_date) => {
                let AppType='revive';
                let getSelectedDay = document.getElementById('getCampaign').value;
                let campaign_startDate = localStorage.getItem('cust_startdate');
                let banner_EndDate = localStorage.getItem('cust_enddate');
                let getCurrentDate = JSON.stringify(date).slice(1, 11);

                if(getSelectedDay == 'custom'){
                    start_date=campaign_startDate;end_date=banner_EndDate;
                }
                else {
                    start_date=start_date;end_date=end_date;
                    localStorage.setItem('cust_startdate', getCurrentDate);
                    localStorage.setItem('cust_enddate', getCurrentDate);
                }
                document.getElementById('from_date').innerHTML = start_date;
                document.getElementById('to_date').innerHTML = end_date;

                // Campaign Chart Start
                $.ajax({
                    url: (start_date == 0 && end_date ==0)?live_URL + '/get_all_dashboard_banner_graph_statistics/'+ bannerid:
                    live_URL + '/get_revive_banner_graph_statistics/' + start_date+' 00:00:00,' + end_date +' 23:59:59,'+ bannerid ,
                    type: 'GET',
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: {},
                    success: function (data) {

                        if (data.msg == 'No Stats Available') {
                            testChart(bannername = [], ImpressionValue = [], clickValue = [],
                                conversionsValue = [], revenueValue = [], ctrValue = [],
                                ecpmValue = []);

                            //widgets
                            document.getElementById('imp').innerHTML = 0;
                            document.getElementById('cli').innerHTML = 0;
                            document.getElementById('dynamic_bannerName').innerHTML = `<?php echo $GLOBALS['no_banner']; ?>`;
                        }
                        else {
                            $(".loader").show();
                            document.getElementById('dynamic_bannerName').innerHTML = data[0].bannername1;

                            let bannername = data.map((data) => {
                                return data.bannername;
                            });

                            let ImpressionValue = data.map((data, index) => {
                                if (data.impressions == null) {
                                    return data.impressions[index] = 0;
                                }
                                else {
                                    return data.impressions;
                                }
                            });
                            let arr = [], sum=0;
                            let cal_imp = data.map((data) => {
                                arr.push(Number(data.impressions));
                            });
                            for(let i =0; i< arr.length; i++) {
                                sum += arr[i];
                            }

                            let clickValue = data.map((data) => {
                                if (data.clicks == null) {
                                    return data.clicks[index] = 0;
                                }
                                else {
                                    return data.clicks;
                                }
                            });
                            let arr1 =[], sum1 =0;
                            let cal2 = data.map((data) => {
                                arr1.push(Number(data.clicks));
                            });
                            for(let i =0; i< arr1.length; i++) {
                                sum1 += arr1[i];
                            }
                            var ctrValue = data.map((data, index) => {
                                if (data.ctr == null) {
                                    return data.ctr = 0;
                                }
                                else {
                                    return data.ctr;
                                }
                            });

                            var ecpmValue = data.map((data, index) => {
                                if (data.ecpm == null) {
                                    return data.ecpm = 0;
                                }
                                else {
                                    return data.ecpm;
                                }
                            });

                            testChart(bannername, ImpressionValue, clickValue, ctrValue, ecpmValue, AppType);

                            //widgets
                            const entries = Object.values(data);
                            if (entries[0]['impressions'] == null && entries[0]['clicks'] == null) {
                                document.getElementById('imp').innerHTML = 0;
                                document.getElementById('cli').innerHTML = 0;
                            }
                            else {
                                document.getElementById('imp').innerHTML =sum;
                                document.getElementById('cli').innerHTML =sum1;
                            }
                        }
                    },
                    error: function () { },
                });
                // Campaign Chart End
            };

            getAllWebsite = (start_date,end_date) => {
                let arr = [], sum=0, arr1 =[], sum1 =0, AppType='website';
                let getSelectedDay = document.getElementById('getCampaign').value;
                let campaign_startDate = localStorage.getItem('cust_startdate');
                let banner_EndDate = localStorage.getItem('cust_enddate');
                let getCurrentDate = JSON.stringify(date).slice(1, 11);

                if(getSelectedDay == 'custom'){
                    start_date=campaign_startDate;end_date=banner_EndDate;
                }
                else {
                    start_date=start_date;end_date=end_date;
                    localStorage.setItem('cust_startdate', getCurrentDate);
                    localStorage.setItem('cust_enddate', getCurrentDate);
                }
                document.getElementById('from_date').innerHTML = start_date;
                document.getElementById('to_date').innerHTML = end_date;

                // Campaign Chart Start
                $.ajax({
                    url: (start_date == 0 && end_date ==0)?live_URL + '/get_all_websites_banner_graph_statistics/'+'0'+','+'0'+','+ bannerid:
                    live_URL + '/get_all_websites_banner_graph_statistics/' + start_date+' 00:00:00,' + end_date +' 23:59:59,'+ bannerid ,
                    type: 'GET',
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: {},
                    success: function (data) {

                        if (data.msg == 'No Stats Available') {
                            testChart(bannername = [], ImpressionValue = [], clickValue = [],
                                conversionsValue = [], revenueValue = [], ctrValue = [],
                                ecpmValue = []);

                            //widgets
                            document.getElementById('imp').innerHTML = 0;
                            document.getElementById('cli').innerHTML = 0;
                            document.getElementById('dynamic_bannerName').innerHTML = `<?php echo $GLOBALS['no_banner']; ?>`;
                        }
                        else {
                            $(".loader").show();
                            document.getElementById('dynamic_bannerName').innerHTML = data[0].bannername1;

                            let bannername = data.map((data) => {
                                return data.bannername;
                            });

                            let ImpressionValue = data.map((data, index) => {
                                if (data.impressions == null) {
                                    return data.impressions[index] = 0;
                                }
                                else {
                                    return data.impressions;
                                }
                            });
                            
                            let cal_imp = data.map((data) => {
                                arr.push(Number(data.impressions));
                            });
                            for(let i =0; i< arr.length; i++) {
                                sum += arr[i];
                            }

                            let clickValue = data.map((data) => {
                                if (data.clicks == null) {
                                    return data.clicks[index] = 0;
                                }
                                else {
                                    return data.clicks;
                                }
                            });
                            
                            let cal2 = data.map((data) => {
                                arr1.push(Number(data.clicks));
                            });
                            for(let i =0; i< arr1.length; i++) {
                                sum1 += arr1[i];
                            }

                            var ctrValue = data.map((data, index) => {
                                if (data.ctr == null) {
                                    return data.ctr = 0;
                                }
                                else {
                                    return data.ctr;
                                }
                            });

                            var ecpmValue = data.map((data, index) => {
                                if (data.ecpm == null) {
                                    return data.ecpm = 0;
                                }
                                else {
                                    return data.ecpm;
                                }
                            });

                            testChart(bannername, ImpressionValue, clickValue, ctrValue, ecpmValue, AppType);

                            //widgets
                            const entries = Object.values(data);
                            if (entries[0]['impressions'] == null && entries[0]['clicks'] == null) {
                                document.getElementById('imp').innerHTML = 0;
                                document.getElementById('cli').innerHTML = 0;
                            }
                            else {
                                document.getElementById('imp').innerHTML =sum;
                                document.getElementById('cli').innerHTML =sum1;
                            }
                        }
                    },
                    error: function () { },
                });
                // Campaign Chart End
            };
        </script>
        <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>
  </body>
</html>