/*
 Highcharts JS v11.0.0 (2023-04-26)

 X-range series

 (c) 2010-2021 Torstein Honsi, Lars A. V. Cabrera

 License: www.highcharts.com/license
*/
'use strict';(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/xrange",["highcharts"],function(e){a(e);a.Highcharts=e;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function e(a,b,r,l){a.hasOwnProperty(b)||(a[b]=l.apply(null,r),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:b,module:a[b]}})))}a=a?a._modules:
{};e(a,"Series/XRange/XRangeSeriesDefaults.js",[a["Core/Utilities.js"]],function(a){const {correctFloat:b,isNumber:k,isObject:l}=a;"";return{colorByPoint:!0,dataLabels:{formatter:function(){let a=this.point.partialFill;l(a)&&(a=a.amount);if(k(a)&&0<a)return b(100*a)+"%"},inside:!0,verticalAlign:"middle"},tooltip:{headerFormat:'<span style="font-size: 0.8em">{point.x} - {point.x2}</span><br/>',pointFormat:'<span style="color:{point.color}">\u25cf</span> {series.name}: <b>{point.yCategory}</b><br/>'},
borderRadius:3,pointRange:0}});e(a,"Series/XRange/XRangePoint.js",[a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,b){const {series:{prototype:{pointClass:{prototype:k}}},seriesTypes:{column:{prototype:{pointClass:l}}}}=a;({extend:a}=b);class e extends l{constructor(){super(...arguments);this.series=this.options=void 0}static getColorByCategory(a,k){const b=a.options.colors||a.chart.options.colors;a=k.y%(b?b.length:a.chart.options.chart.colorCount);return{colorIndex:a,color:b&&
b[a]}}resolveColor(){const a=this.series;if(a.options.colorByPoint&&!this.options.color){const b=e.getColorByCategory(a,this);a.chart.styledMode||(this.color=b.color);this.options.colorIndex||(this.colorIndex=b.colorIndex)}else this.color||(this.color=a.color)}init(){k.init.apply(this,arguments);this.y||(this.y=0);return this}setState(){k.setState.apply(this,arguments);this.series.drawPoint(this,this.series.getAnimationVerb())}getLabelConfig(){const a=k.getLabelConfig.call(this),b=this.series.yAxis.categories;
a.x2=this.x2;a.yCategory=this.yCategory=b&&b[this.y];return a}isValid(){return"number"===typeof this.x&&"number"===typeof this.x2}}a(e.prototype,{ttBelow:!1,tooltipDateKeys:["x","x2"]});"";return e});e(a,"Series/XRange/XRangeSeries.js",[a["Core/Globals.js"],a["Core/Color/Color.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"],a["Series/XRange/XRangeSeriesDefaults.js"],a["Series/XRange/XRangePoint.js"]],function(a,b,e,l,F,G){function k(){let c,a;if(this.isXAxis){c=x(this.dataMax,-Number.MAX_VALUE);
for(const B of this.series)if(B.x2Data)for(const q of B.x2Data)q&&q>c&&(c=q,a=!0);a&&(this.dataMax=c)}}({noop:a}=a);const {parse:A}=b,{series:{prototype:C},seriesTypes:{column:D}}=e,{addEvent:r,clamp:y,defined:H,extend:I,find:E,isNumber:w,isObject:z,merge:t,pick:x}=l,J=[];class u extends D{constructor(){super(...arguments);this.points=this.options=this.data=void 0}static compose(c){l.pushUnique(J,c)&&r(c,"afterGetSeriesExtremes",k)}init(){super.init.apply(this,arguments);this.options.stacking=void 0}getColumnMetrics(){const c=
()=>{for(const c of this.chart.series){const a=c.xAxis;c.xAxis=c.yAxis;c.yAxis=a}};c();const a=super.getColumnMetrics();c();return a}cropData(c,a,q,b){a=C.cropData.call(this,this.x2Data,a,q,b);a.xData=c.slice(a.start,a.end);return a}findPointIndex(c){const {cropStart:a,points:q}=this,{id:b}=c;if(b)var d=(d=E(q,a=>a.id===b))?d.index:void 0;"undefined"===typeof d&&(d=(d=E(q,a=>a.x===c.x&&a.x2===c.x2&&!a.touched))?d.index:void 0);this.cropped&&w(d)&&w(a)&&d>=a&&(d-=a);return d}alignDataLabel(a){const c=
a.plotX;a.plotX=x(a.dlBox&&a.dlBox.centerX,a.plotX);super.alignDataLabel.apply(this,arguments);a.plotX=c}translatePoint(a){const c=this.xAxis;var b=this.yAxis,v=this.columnMetrics,d=this.options,{borderRadius:e}=d,k=d.minPointLength||0,g=(a.shapeArgs&&a.shapeArgs.width||0)/2,h=this.pointXOffset=v.offset,n=x(a.x2,a.x+(a.len||0));let p=a.plotX;var f=c.translate(n,0,0,0,1);n=Math.abs(f-p);const m=this.chart.inverted,l=x(d.borderWidth,1)%2/2;let u=v.offset,r=Math.round(v.width);k&&(k-=n,0>k&&(k=0),p-=
k/2,f+=k/2);p=Math.max(p,-10);f=y(f,-10,c.len+10);H(a.options.pointWidth)&&(u-=(Math.ceil(a.options.pointWidth)-r)/2,r=Math.ceil(a.options.pointWidth));d.pointPlacement&&w(a.plotY)&&b.categories&&(a.plotY=b.translate(a.y,0,1,0,1,d.pointPlacement));d=Math.floor(Math.min(p,f))+l;d={x:d,y:Math.floor(a.plotY+u)+l,width:Math.floor(Math.max(p,f))+l-d,height:r};a.shapeArgs=d;w(e)&&(a.shapeArgs.r=e);m?a.tooltipPos[1]+=h+g:a.tooltipPos[0]-=g+h-d.width/2;g=d.x;h=g+d.width;0>g||h>c.len?(g=y(g,0,c.len),h=y(h,
0,c.len),f=h-g,a.dlBox=t(d,{x:g,width:h-g,centerX:f?f/2:null})):a.dlBox=null;g=a.tooltipPos;h=m?1:0;f=m?0:1;v=this.columnMetrics?this.columnMetrics.offset:-v.width/2;g[h]=m?g[h]+d.width/2:y(g[h]+(c.reversed?-1:0)*d.width,0,c.len-1);g[f]=y(g[f]+(m?-1:1)*v,0,b.len-1);if(b=a.partialFill)z(b)&&(b=b.amount),w(b)||(b=0),w(e)&&(a.partShapeArgs=t(d,{r:e})),e=Math.max(Math.round(n*b+a.plotX-p),0),a.clipRectArgs={x:c.reversed?d.x+n-e:d.x,y:d.y,width:e,height:d.height}}translate(){super.translate.apply(this,
arguments);for(const a of this.points)this.translatePoint(a)}drawPoint(a,b){const c=this.options,e=this.chart.renderer,d=a.shapeType,k=a.shapeArgs,l=a.partShapeArgs,g=a.clipRectArgs;var h=a.state,n=c.states[h||"normal"]||{};const p="undefined"===typeof h?"attr":b;h=this.pointAttribs(a,h);n=x(this.chart.options.chart.animation,n.animation);let f=a.graphic,m=a.partialFill;if(a.isNull||!1===a.visible)f&&(a.graphic=f.destroy());else{if(f)f.rect[b](k);else a.graphic=f=e.g("point").addClass(a.getClassName()).add(a.group||
this.group),f.rect=e[d](t(k)).addClass(a.getClassName()).addClass("highcharts-partfill-original").add(f);l&&(f.partRect?(f.partRect[b](t(l)),f.partialClipRect[b](t(g))):(f.partialClipRect=e.clipRect(g.x,g.y,g.width,g.height),f.partRect=e[d](l).addClass("highcharts-partfill-overlay").add(f).clip(f.partialClipRect)));this.chart.styledMode||(f.rect[b](h,n).shadow(c.shadow),l&&(z(m)||(m={}),z(c.partialFill)&&(m=t(c.partialFill,m)),a=m.fill||A(h.fill).brighten(-.3).get()||A(a.color||this.color).brighten(-.3).get(),
h.fill=a,f.partRect[p](h,n).shadow(c.shadow)))}}drawPoints(){const a=this.getAnimationVerb();for(const b of this.points)this.drawPoint(b,a)}getAnimationVerb(){return this.chart.pointCount<(this.options.animationLimit||250)?"animate":"attr"}isPointInside(a){const b=a.shapeArgs,c=a.plotX,e=a.plotY;return b?"undefined"!==typeof c&&"undefined"!==typeof e&&0<=e&&e<=this.yAxis.len&&0<=(b.x||0)+(b.width||0)&&c<=this.xAxis.len:super.isPointInside.apply(this,arguments)}}u.defaultOptions=t(D.defaultOptions,
F);I(u.prototype,{pointClass:G,cropShoulder:1,getExtremesFromAll:!0,parallelArrays:["x","x2","y"],requireSorting:!1,type:"xrange",animate:C.animate,autoIncrement:a,buildKDTree:a});e.registerSeriesType("xrange",u);return u});e(a,"masters/modules/xrange.src.js",[a["Core/Globals.js"],a["Series/XRange/XRangeSeries.js"]],function(a,b){b.compose(a.Axis)})});
//# sourceMappingURL=xrange.js.map