/*
 Highcharts JS v11.0.0 (2023-04-26)

 (c) 2016-2021 Highsoft AS
 Authors: Jon Arild Nygard

 License: www.highcharts.com/license
*/
'use strict';(function(d){"object"===typeof module&&module.exports?(d["default"]=d,module.exports=d):"function"===typeof define&&define.amd?define("highcharts/modules/wordcloud",["highcharts"],function(f){d(f);d.Highcharts=f;return d}):d("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(d){function f(d,e,g,y){d.hasOwnProperty(e)||(d[e]=y.apply(null,g),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:d[e]}})))}d=d?d._modules:
{};f(d,"Series/DrawPointUtilities.js",[d["Core/Utilities.js"]],function(d){return{draw:function(d,g){const {animatableAttribs:e,onComplete:f,css:r,renderer:m}=g,t=d.series&&d.series.chart.hasRendered?void 0:d.series&&d.series.options.animation;let n=d.graphic;g.attribs=Object.assign(Object.assign({},g.attribs),{"class":d.getClassName()})||{};if(d.shouldDraw())n||(d.graphic=n="text"===g.shapeType?m.text():m[g.shapeType](g.shapeArgs||{}),n.add(g.group)),r&&n.css(r),n.attr(g.attribs).animate(e,g.isNew?
!1:t,f);else if(n){const g=()=>{d.graphic=n=n&&n.destroy();"function"===typeof f&&f()};Object.keys(e).length?n.animate(e,void 0,()=>g()):g()}}}});f(d,"Series/Wordcloud/WordcloudPoint.js",[d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,e){({seriesTypes:{column:{prototype:{pointClass:d}}}}=d);({extend:e}=e);class g extends d{constructor(){super(...arguments);this.series=this.rect=this.polygon=this.options=this.dimensions=void 0}isValid(){return!0}}e(g.prototype,{weight:1});return g});
f(d,"Series/Wordcloud/WordcloudUtils.js",[d["Core/Globals.js"],d["Core/Utilities.js"]],function(d,e){function g(a,b){return!(b.left>a.right||b.right<a.left||b.top>a.bottom||b.bottom<a.top)}function f(a,b){const c=b[0]-a[0];a=b[1]-a[1];return[[-a,c],[a,-c]]}function r(a){let b,c=a.axes||[];c.length||(c=[],b=b=a.concat([a[0]]),b.reduce(function(a,b){const h=f(a,b)[0];C(c,a=>a[0]===h[0]&&a[1]===h[1])||c.push(h);return b}),a.axes=c);return c}function z(a,b){a=a.map(a=>a[0]*b[0]+a[1]*b[1]);return{min:Math.min.apply(this,
a),max:Math.max.apply(this,a)}}function m(a,b){var c=r(a);const h=r(b);c=c.concat(h);return!C(c,c=>{var h=z(a,c);c=z(b,c);return h=!!(c.min>h.max||c.max<h.min)})}function t(a,b){let c=!1,h=a.rect,d=a.polygon,l=a.lastCollidedWith,e=function(b){let c=g(h,b.rect);c&&(a.rotation%90||b.rotation%90)&&(c=m(d,b.polygon));return c};l&&((c=e(l))||delete a.lastCollidedWith);c||(c=!!C(b,function(b){const c=e(b);c&&(a.lastCollidedWith=b);return c}));return c}function n(a,b){b=4*a;let c=Math.ceil((Math.sqrt(b)-
1)/2),h=2*c+1,d=Math.pow(h,2),l=!1;--h;1E4>=a&&("boolean"===typeof l&&b>=d-h&&(l={x:c-(d-b),y:-c}),d-=h,"boolean"===typeof l&&b>=d-h&&(l={x:-c,y:-c+(d-b)}),d-=h,"boolean"===typeof l&&(l=b>=d-h?{x:-c+(d-b),y:c}:{x:c,y:c-(d-b-h)}),l.x*=5,l.y*=5);return l}function v(a,b){var c=b.width/2,h=-(b.height/2),d=b.height/2;return!(-(b.width/2)<a.left&&c>a.right&&h<a.top&&d>a.bottom)}function M(a,b,c){return c.map(function(c){return[c[0]+a,c[1]+b]})}function x(a,b){b=k(b)?b:14;b=Math.pow(10,b);return Math.round(a*
b)/b}function D(a,b){const c=a[0];a=a[1];var d=H*-b;b=Math.cos(d);d=Math.sin(d);return[x(c*b-a*d),x(c*d+a*b)]}function w(a,b,c){a=D([a[0]-b[0],a[1]-b[1]],c);return[a[0]+b[0],a[1]+b[1]]}const {deg2rad:H}=d,{extend:F,find:C,isNumber:k,isObject:E,merge:A}=e;return{archimedeanSpiral:function(a,b){var c=b.field;b=!1;c=c.width*c.width+c.height*c.height;let d=.8*a;1E4>=a&&(b={x:d*Math.cos(d),y:d*Math.sin(d)},Math.min(Math.abs(b.x),Math.abs(b.y))<c||(b=!1));return b},extendPlayingField:function(a,b){let c,
d;if(E(a)&&E(b)){var q=b.bottom-b.top;c=b.right-b.left;b=a.ratioX;d=a.ratioY;q=c*b>q*d?c:q;a=A(a,{width:a.width+q*b*2,height:a.height+q*d*2})}return a},getBoundingBoxFromPolygon:function(a){return a.reduce(function(a,c){const b=c[0];c=c[1];a.left=Math.min(b,a.left);a.right=Math.max(b,a.right);a.bottom=Math.max(c,a.bottom);a.top=Math.min(c,a.top);return a},{left:Number.MAX_VALUE,right:-Number.MAX_VALUE,bottom:-Number.MAX_VALUE,top:Number.MAX_VALUE})},getPlayingField:function(a,b,c){c=c.reduce(function(a,
b){b=b.dimensions;const c=Math.max(b.width,b.height);a.maxHeight=Math.max(a.maxHeight,b.height);a.maxWidth=Math.max(a.maxWidth,b.width);a.area+=c*c;return a},{maxHeight:0,maxWidth:0,area:0});c=Math.max(c.maxHeight,c.maxWidth,.85*Math.sqrt(c.area));const d=a>b?a/b:1;a=b>a?b/a:1;return{width:c*d,height:c*a,ratioX:d,ratioY:a}},getPolygon:function(a,b,c,d,g){const h=[a,b],e=a-c/2;a+=c/2;c=b-d/2;b+=d/2;return[[e,c],[a,c],[a,b],[e,b]].map(function(a){return w(a,h,-g)})},getRandomPosition:function(a){return Math.round(a*
(Math.random()+.5)/2)},getRotation:function(a,b,c,d){let h=!1;k(a)&&k(b)&&k(c)&&k(d)&&0<a&&-1<b&&d>c&&(h=c+b%a*((d-c)/(a-1||1)));return h},getScale:function(a,b,c){const d=2*Math.max(Math.abs(c.top),Math.abs(c.bottom));c=2*Math.max(Math.abs(c.left),Math.abs(c.right));return Math.min(0<c?1/c*a:1,0<d?1/d*b:1)},getSpiral:function(a,b){let c,d=[];for(c=1;1E4>c;c++)d.push(a(c,b));return function(a){return 1E4>=a?d[a-1]:!1}},intersectionTesting:function(a,b){let c=b.placed,d=b.field,g=b.rectangle,e=b.polygon,
n=b.spiral,f=1,p={x:0,y:0},k=a.rect=F({},g);a.polygon=e;for(a.rotation=b.rotation;!1!==p&&(t(a,c)||v(k,d));)p=n(f),E(p)&&(k.left=g.left+p.x,k.right=g.right+p.x,k.top=g.top+p.y,k.bottom=g.bottom+p.y,a.polygon=M(p.x,p.y,e)),f++;return p},isPolygonsColliding:m,isRectanglesIntersecting:g,rectangularSpiral:function(a,b){a=n(a,b);b=b.field;a&&(a.x*=b.ratioX,a.y*=b.ratioY);return a},rotate2DToOrigin:D,rotate2DToPoint:w,squareSpiral:n,updateFieldBoundaries:function(a,b){if(!k(a.left)||a.left>b.left)a.left=
b.left;if(!k(a.right)||a.right<b.right)a.right=b.right;if(!k(a.top)||a.top>b.top)a.top=b.top;if(!k(a.bottom)||a.bottom<b.bottom)a.bottom=b.bottom;return a}}});f(d,"Series/Wordcloud/WordcloudSeries.js",[d["Series/DrawPointUtilities.js"],d["Core/Globals.js"],d["Core/Series/Series.js"],d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"],d["Series/Wordcloud/WordcloudPoint.js"],d["Series/Wordcloud/WordcloudUtils.js"]],function(d,e,g,f,K,z,m){const {noop:t}=e,{seriesTypes:{column:n}}=f,{extend:v,
isArray:r,isNumber:x,isObject:D,merge:w}=K,{archimedeanSpiral:H,extendPlayingField:F,getBoundingBoxFromPolygon:C,getPlayingField:k,getPolygon:E,getRandomPosition:A,getRotation:a,getScale:b,getSpiral:c,intersectionTesting:h,isPolygonsColliding:q,rectangularSpiral:l,rotate2DToOrigin:y,rotate2DToPoint:L,squareSpiral:p,updateFieldBoundaries:N}=m;class B extends n{constructor(){super(...arguments);this.points=this.options=this.data=void 0}bindAxes(){const a={endOnTick:!1,gridLineWidth:0,lineWidth:0,maxPadding:0,
startOnTick:!1,title:void 0,tickPositions:[]};g.prototype.bindAxes.call(this);v(this.yAxis.options,a);v(this.xAxis.options,a)}pointAttribs(a,b){a=e.seriesTypes.column.prototype.pointAttribs.call(this,a,b);delete a.stroke;delete a["stroke-width"];return a}deriveFontSize(a,b,c){a=x(a)?a:0;b=x(b)?b:1;c=x(c)?c:1;return Math.floor(Math.max(c,a*b))}drawPoints(){let a=this,g=a.hasRendered;var e=a.xAxis;let f=a.yAxis,n=a.group,l=a.options,p=l.animation,t=l.allowExtendPlayingField,r=a.chart.renderer,m=r.text().add(n),
q=[],z=a.placementStrategy[l.placementStrategy],w,A=l.rotation,B=a.points.map(function(a){return a.weight}),y=Math.max.apply(null,B),G=a.points.concat().sort(function(a,b){return b.weight-a.weight}),u;a.group.attr({scaleX:1,scaleY:1});G.forEach(function(b){var c=a.deriveFontSize(1/y*b.weight,l.maxFontSize,l.minFontSize);c=v({fontSize:c+"px"},l.style);m.css(c).attr({x:0,y:0,text:b.name});c=m.getBBox(!0);b.dimensions={height:c.height,width:c.width}});u=k(e.len,f.len,G);w=c(a.spirals[l.spiral],{field:u});
G.forEach(function(b){var c=a.deriveFontSize(1/y*b.weight,l.maxFontSize,l.minFontSize);c=v({fontSize:c+"px"},l.style);let e=z(b,{data:G,field:u,placed:q,rotation:A}),f=v(a.pointAttribs(b,b.selected&&"select"),{align:"center","alignment-baseline":"middle","dominant-baseline":"middle",x:e.x,y:e.y,text:b.name,rotation:x(e.rotation)?e.rotation:void 0}),I=E(e.x,e.y,b.dimensions.width,b.dimensions.height,e.rotation),k=C(I),m=h(b,{rectangle:k,polygon:I,field:u,placed:q,spiral:w,rotation:e.rotation}),J;!m&&
t&&(u=F(u,k),m=h(b,{rectangle:k,polygon:I,field:u,placed:q,spiral:w,rotation:e.rotation}));D(m)?(f.x=(f.x||0)+m.x,f.y=(f.y||0)+m.y,k.left+=m.x,k.right+=m.x,k.top+=m.y,k.bottom+=m.y,u=N(u,k),q.push(b),b.isNull=!1,b.isInside=!0):b.isNull=!0;p&&(J={x:f.x,y:f.y},g?(delete f.x,delete f.y):(f.x=0,f.y=0));d.draw(b,{animatableAttribs:J,attribs:f,css:c,group:n,renderer:r,shapeArgs:void 0,shapeType:"text"})});m=m.destroy();e=b(e.len,f.len,u);a.group.attr({scaleX:e,scaleY:e})}hasData(){return D(this)&&!0===
this.visible&&r(this.points)&&0<this.points.length}getPlotBox(){const a=this.chart;var b=a.inverted;const c=this[b?"yAxis":"xAxis"];b=this[b?"xAxis":"yAxis"];return{translateX:(c?c.left:a.plotLeft)+(c?c.len:a.plotWidth)/2,translateY:(b?b.top:a.plotTop)+(b?b.len:a.plotHeight)/2,scaleX:1,scaleY:1}}}B.defaultOptions=w(n.defaultOptions,{allowExtendPlayingField:!0,animation:{duration:500},borderWidth:0,clip:!1,colorByPoint:!0,cropThreshold:Infinity,minFontSize:1,maxFontSize:25,placementStrategy:"center",
rotation:{from:0,orientations:2,to:90},showInLegend:!1,spiral:"rectangular",style:{fontFamily:"sans-serif",fontWeight:"900",whiteSpace:"nowrap"},tooltip:{followPointer:!0,pointFormat:'<span style="color:{point.color}">\u25cf</span> {series.name}: <b>{point.weight}</b><br/>'}});v(B.prototype,{animate:t,animateDrilldown:t,animateDrillupFrom:t,pointClass:z,setClip:t,placementStrategy:{random:function(b,c){const d=c.field;c=c.rotation;return{x:A(d.width)-d.width/2,y:A(d.height)-d.height/2,rotation:a(c.orientations,
b.index,c.from,c.to)}},center:function(b,c){c=c.rotation;return{x:0,y:0,rotation:a(c.orientations,b.index,c.from,c.to)}}},pointArrayMap:["weight"],spirals:{archimedean:H,rectangular:l,square:p},utils:{extendPlayingField:F,getRotation:a,isPolygonsColliding:q,rotate2DToOrigin:y,rotate2DToPoint:L}});f.registerSeriesType("wordcloud",B);"";return B});f(d,"masters/modules/wordcloud.src.js",[],function(){})});
//# sourceMappingURL=wordcloud.js.map