/*
 Highcharts JS v11.0.0 (2023-04-26)

 (c) 2017-2021 Highsoft AS
 Authors: Jon Arild Nygard

 License: www.highcharts.com/license
*/
'use strict';(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/venn",["highcharts"],function(m){a(m);a.Highcharts=m;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function m(a,f,e,A){a.hasOwnProperty(f)||(a[f]=A.apply(null,e),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:f,module:a[f]}})))}a=a?a._modules:
{};m(a,"Core/Geometry/GeometryUtilities.js",[],function(){var a;(function(a){a.getCenterOfPoints=function(a){const e=a.reduce((a,e)=>{a.x+=e.x;a.y+=e.y;return a},{x:0,y:0});return{x:e.x/a.length,y:e.y/a.length}};a.getDistanceBetweenPoints=function(a,f){return Math.sqrt(Math.pow(f.x-a.x,2)+Math.pow(f.y-a.y,2))};a.getAngleBetweenPoints=function(a,f){return Math.atan2(f.x-a.x,f.y-a.y)}})(a||(a={}));return a});m(a,"Core/Geometry/CircleUtilities.js",[a["Core/Geometry/GeometryUtilities.js"]],function(a){const {getAngleBetweenPoints:f,
getCenterOfPoints:e,getDistanceBetweenPoints:A}=a;var r;(function(a){function t(a,d){d=Math.pow(10,d);return Math.round(a*d)/d}function n(a){if(0>=a)throw Error("radius of circle must be a positive number.");return Math.PI*a*a}function h(a,d){return a*a*Math.acos(1-d/a)-(a-d)*Math.sqrt(d*(2*a-d))}function r(a,d){var p=A(a,d),f=a.r,l=d.r,e=[];if(p<f+l&&p>Math.abs(f-l)){f*=f;var w=(f-l*l+p*p)/(2*p);l=Math.sqrt(f-w*w);f=a.x;e=d.x;a=a.y;const h=d.y;d=f+w*(e-f)/p;w=a+w*(h-a)/p;a=l/p*-(h-a);p=l/p*-(e-f);
e=[{x:t(d+a,14),y:t(w-p,14)},{x:t(d-a,14),y:t(w+p,14)}]}return e}function m(a){return a.reduce((a,f,l,e)=>{e=e.slice(l+1).reduce((a,d,e,p)=>{const h=[l,e+l+1];return a.concat(r(f,d).map(a=>{a.indexes=h;return a}))},[]);return a.concat(e)},[])}function z(a,d){return A(a,d)<=d.r+1e-10}function B(a,d){return!d.some(function(d){return!z(a,d)})}function D(a){return m(a).filter(function(d){return B(d,a)})}a.round=t;a.getAreaOfCircle=n;a.getCircularSegmentArea=h;a.getOverlapBetweenCircles=function(a,d,f){var e=
0;f<a+d&&(f<=Math.abs(d-a)?e=n(a<d?a:d):(e=(a*a-d*d+f*f)/(2*f),f-=e,e=h(a,a-e)+h(d,d-f)),e=t(e,14));return e};a.getCircleCircleIntersection=r;a.getCirclesIntersectionPoints=m;a.isCircle1CompletelyOverlappingCircle2=function(a,d){return A(a,d)+d.r<a.r+1e-10};a.isPointInsideCircle=z;a.isPointInsideAllCircles=B;a.isPointOutsideAllCircles=function(a,d){return!d.some(function(d){return z(a,d)})};a.getCirclesIntersectionPolygon=D;a.getAreaOfIntersectionBetweenCircles=function(a){var d=D(a);let h;if(1<d.length){const p=
e(d);d=d.map(function(a){a.angle=f(p,a);return a}).sort(function(a,d){return d.angle-a.angle});const l=d[d.length-1];d=d.reduce(function(d,h){const {startPoint:l}=d,p=e([l,h]),n=h.indexes.filter(function(a){return-1<l.indexes.indexOf(a)}).reduce(function(x,b){b=a[b];var c=f(b,h);const k=f(b,l);c=k-(k-c+(k<c?2*Math.PI:0))/2;c=A(p,{x:b.x+b.r*Math.sin(c),y:b.y+b.r*Math.cos(c)});({r:b}=b);c>2*b&&(c=2*b);if(!x||x.width>c)x={r:b,largeArc:c>b?1:0,width:c,x:h.x,y:h.y};return x},null);if(n){const {r:a}=n;
d.arcs.push(["A",a,a,0,n.largeArc,1,n.x,n.y]);d.startPoint=h}return d},{startPoint:l,arcs:[]}).arcs;0!==d.length&&1!==d.length&&(d.unshift(["M",l.x,l.y]),h={center:p,d})}return h}})(r||(r={}));return r});m(a,"Series/DrawPointUtilities.js",[a["Core/Utilities.js"]],function(a){return{draw:function(a,e){const {animatableAttribs:f,onComplete:r,css:m,renderer:t}=e,n=a.series&&a.series.chart.hasRendered?void 0:a.series&&a.series.options.animation;let h=a.graphic;e.attribs=Object.assign(Object.assign({},
e.attribs),{"class":a.getClassName()})||{};if(a.shouldDraw())h||(a.graphic=h="text"===e.shapeType?t.text():t[e.shapeType](e.shapeArgs||{}),h.add(e.group)),m&&h.css(m),h.attr(e.attribs).animate(f,e.isNew?!1:n,r);else if(h){const e=()=>{a.graphic=h=h&&h.destroy();"function"===typeof r&&r()};Object.keys(f).length?h.animate(f,void 0,()=>e()):e()}}}});m(a,"Series/Venn/VennPoint.js",[a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,f){({seriesTypes:{scatter:{prototype:{pointClass:a}}}}=
a);const {isNumber:e}=f;class m extends a{constructor(){super(...arguments);this.series=this.options=void 0}isValid(){return e(this.value)}shouldDraw(){return!!this.shapeArgs}}return m});m(a,"Series/Venn/VennUtils.js",[a["Core/Geometry/CircleUtilities.js"],a["Core/Geometry/GeometryUtilities.js"],a["Core/Utilities.js"]],function(a,f,e){function m(a){const b={};a.filter(a=>2===a.sets.length).forEach(a=>{a.sets.forEach((c,g,u)=>{y(b[c])||(b[c]={totalOverlap:0,overlapping:{}});b[c]={totalOverlap:(b[c].totalOverlap||
0)+a.value,overlapping:Object.assign(Object.assign({},b[c].overlapping||{}),{[u[1-g]]:a.value})}})});a.filter(h).forEach(a=>{G(a,b[a.sets[0]])});return a}function r(a,b,c,k,g){let u=a(b),v=a(c);g=g||100;k=k||1e-10;let d=c-b,x=1,q,e;if(b>=c)throw Error("a must be smaller than b.");if(0<u*v)throw Error("f(a) and f(b) must have opposite signs.");if(0===u)q=b;else if(0===v)q=c;else for(;x++<=g&&0!==e&&d>k;)d=(c-b)/2,q=b+d,e=a(q),0<u*e?b=q:c=q;return q}function B(a){a=a.slice(0,-1);const b=a.length,c=
[],k=function(a,c){a.sum+=c[a.i];return a};for(let g=0;g<b;g++)c[g]=a.reduce(k,{sum:0,i:g}).sum/b;return c}function t(a,b,c){let k=a+b;return 0>=c?k:I(a<b?a:b)<=c?0:r(g=>{g=l(a,b,g);return c-g},0,k)}function n(a){var b=0;2===a.length&&(b=a[0],a=a[1],b=l(b.r,a.r,C(b,a)));return b}function h(a){return w(a.sets)&&1===a.sets.length}function z(a){const b={};return y(a)&&E(a.value)&&-1<a.value&&w(a.sets)&&0<a.sets.length&&!a.sets.some(function(a){let c=!1;!b[a]&&H(a)?b[a]=!0:c=!0;return c})}function K(a,
b){return b.reduce(function(c,b){var g=0;1<b.sets.length&&(g=b.value,b=n(b.sets.map(function(c){return a[c]})),b=g-b,g=Math.round(b*b*1E11)/1E11);return c+g},0)}function L(a,b){return"undefined"!==typeof b.totalOverlap&&"undefined"!==typeof a.totalOverlap?b.totalOverlap-a.totalOverlap:NaN}const {getAreaOfCircle:I,getCircleCircleIntersection:D,getOverlapBetweenCircles:l,isPointInsideAllCircles:d,isPointInsideCircle:p,isPointOutsideAllCircles:F}=a,{getDistanceBetweenPoints:C}=f,{extend:G,isArray:w,
isNumber:E,isObject:y,isString:H}=e;return{geometry:f,geometryCircles:a,addOverlapToSets:m,getCentroid:B,getDistanceBetweenCirclesByOverlap:t,getLabelWidth:function(a,b,c){const k=b.reduce((a,c)=>Math.min(c.r,a),Infinity),g=c.filter(function(c){return!p(a,c)});c=function(c,v){return r(function(k){var u={x:a.x+v*k,y:a.y};u=d(u,b)&&F(u,g);return-(c-k)+(u?0:Number.MAX_VALUE)},0,c)};return 2*Math.min(c(k,-1),c(k,1))},getMarginFromCircles:function(a,b,c){b=b.reduce(function(c,b){b=b.r-C(a,b);return b<=
c?b:c},Number.MAX_VALUE);return b=c.reduce(function(c,b){b=C(a,b)-b.r;return b<=c?b:c},b)},isSet:h,layoutGreedyVenn:function(a){const b=[],c={};a.filter(function(a){return 1===a.sets.length}).forEach(function(a){c[a.sets[0]]=a.circle={x:Number.MAX_VALUE,y:Number.MAX_VALUE,r:Math.sqrt(a.value/Math.PI)}});const d=function(a,c){const g=a.circle;g&&(g.x=c.x,g.y=c.y);b.push(a)};m(a);const g=a.filter(h).sort(L);d(g.shift(),{x:0,y:0});const u=a.filter(function(a){return 2===a.sets.length});g.forEach(function(a){const g=
a.circle;if(g){var k=g.r,v=a.overlapping,e=b.reduce((a,d,e)=>{const q=d.circle;if(!q||!v)return a;const f=t(k,q.r,v[d.sets[0]]);let J=[{x:q.x+f,y:q.y},{x:q.x-f,y:q.y},{x:q.x,y:q.y+f},{x:q.x,y:q.y-f}];b.slice(e+1).forEach(function(a){const c=a.circle;c&&(a=t(k,c.r,v[a.sets[0]]),J=J.concat(D({x:q.x,y:q.y,r:f},{x:c.x,y:c.y,r:a})))});J.forEach(function(b){g.x=b.x;g.y=b.y;const d=K(c,u);d<a.loss&&(a.loss=d,a.coordinates=b)});return a},{loss:Number.MAX_VALUE,coordinates:void 0});d(a,e.coordinates)}});return c},
loss:K,nelderMead:function(a,b){const c=function(a,c){return a.fx-c.fx},d=(a,c,b,g)=>c.map((c,d)=>a*c+b*g[d]),g=(c,b)=>{b.fx=a(b);c[c.length-1]=b;return c},u=c=>{const b=c[0];return c.map(c=>{c=d(.5,b,.5,c);c.fx=a(c);return c})},v=(c,b,g,v)=>{c=d(g,c,v,b);c.fx=a(c);return c};b=(c=>{const b=c.length,g=Array(b+1);g[0]=c;g[0].fx=a(c);for(let d=0;d<b;++d){const b=c.slice();b[d]=b[d]?1.05*b[d]:.001;b.fx=a(b);g[d+1]=b}return g})(b);for(let a=0;100>a;a++){b.sort(c);var e=b[b.length-1],f=B(b);const a=v(f,
e,2,-1);a.fx<b[0].fx?(e=v(f,e,3,-2),b=g(b,e.fx<a.fx?e:a)):a.fx>=b[b.length-2].fx?a.fx>e.fx?(f=v(f,e,.5,.5),b=f.fx<e.fx?g(b,f):u(b)):(f=v(f,e,1.5,-.5),b=f.fx<a.fx?g(b,f):u(b)):b=g(b,a)}return b[0]},processVennData:function(a,b){a=w(a)?a:[];const c=a.reduce(function(a,c){var b;if(b=c.sets)b=z(c)&&h(c)&&0<c.value;b&&-1===a.indexOf(c.sets[0])&&a.push(c.sets[0]);return a},[]).sort(),d=a.reduce(function(a,d){d.sets&&z(d)&&!d.sets.some(function(a){return-1===c.indexOf(a)})&&(a[d.sets.sort().join(b)]={sets:d.sets,
value:d.value||0});return a},{});c.reduce(function(a,c,d,e){e.slice(d+1).forEach(function(d){a.push(c+b+d)});return a},[]).forEach(function(a){if(!d[a]){const c={sets:a.split(b),value:0};d[a]=c}});return Object.keys(d).map(function(a){return d[a]})},sortByTotalOverlap:L}});m(a,"Series/Venn/VennSeries.js",[a["Core/Animation/AnimationUtilities.js"],a["Core/Color/Color.js"],a["Core/Geometry/CircleUtilities.js"],a["Series/DrawPointUtilities.js"],a["Core/Geometry/GeometryUtilities.js"],a["Core/Series/SeriesRegistry.js"],
a["Series/Venn/VennPoint.js"],a["Series/Venn/VennUtils.js"],a["Core/Legend/LegendSymbol.js"],a["Core/Utilities.js"]],function(a,f,e,m,r,B,t,n,h,M){const {animObject:z}=a,{parse:A}=f,{getAreaOfIntersectionBetweenCircles:I,getCirclesIntersectionPolygon:D,isCircle1CompletelyOverlappingCircle2:l,isPointInsideAllCircles:d,isPointOutsideAllCircles:p}=e,{getCenterOfPoints:F}=r,{seriesTypes:{scatter:C}}=B,{addEvent:G,extend:w,isArray:E,isNumber:y,isObject:H,merge:x}=M;class b extends C{constructor(){super(...arguments);
this.points=this.options=this.mapOfIdToRelation=this.data=void 0}static getLabelPosition(a,b){var c=a.reduce((c,d)=>{const g=d.r/2;return[{x:d.x,y:d.y},{x:d.x+g,y:d.y},{x:d.x-g,y:d.y},{x:d.x,y:d.y+g},{x:d.x,y:d.y-g}].reduce((c,d)=>{const g=n.getMarginFromCircles(d,a,b);c.margin<g&&(c.point=d,c.margin=g);return c},c)},{point:void 0,margin:-Number.MAX_VALUE}).point;c=n.nelderMead(function(c){return-n.getMarginFromCircles({x:c[0],y:c[1]},a,b)},[c.x,c.y]);c={x:c[0],y:c[1]};d(c,a)&&p(c,b)||(c=1<a.length?
F(D(a)):{x:a[0].x,y:a[0].y});return c}static getLabelValues(a,d){const c=a.sets,e=d.reduce((a,b)=>{const d=-1<c.indexOf(b.sets[0]);b.circle&&a[d?"internal":"external"].push(b.circle);return a},{internal:[],external:[]});e.external=e.external.filter(a=>e.internal.some(c=>!l(a,c)));a=b.getLabelPosition(e.internal,e.external);d=n.getLabelWidth(a,e.internal,e.external);return{position:a,width:d}}static layout(a){const c={},d={};if(0<a.length){const g=n.layoutGreedyVenn(a),e=a.filter(n.isSet);a.forEach(function(a){var f=
a.sets;const k=f.join();if(f=n.isSet(a)?g[k]:I(f.map(a=>g[a])))c[k]=f,d[k]=b.getLabelValues(a,e)})}return{mapOfIdToShape:c,mapOfIdToLabelValues:d}}static getScale(a,b,d){var c=d.bottom-d.top;const e=d.right-d.left;c=Math.min(0<e?1/e*a:1,0<c?1/c*b:1);return{scale:c,centerX:a/2-(d.right+d.left)/2*c,centerY:b/2-(d.top+d.bottom)/2*c}}static updateFieldBoundaries(a,b){const c=b.x-b.r,d=b.x+b.r,e=b.y+b.r;b=b.y-b.r;if(!y(a.left)||a.left>c)a.left=c;if(!y(a.right)||a.right<d)a.right=d;if(!y(a.top)||a.top>
b)a.top=b;if(!y(a.bottom)||a.bottom<e)a.bottom=e;return a}animate(a){if(!a){const a=z(this.options.animation);this.points.forEach(function(c){const b=c.shapeArgs;if(c.graphic&&b){const d={},e={};b.d?d.opacity=.001:(d.r=0,e.r=b.r);c.graphic.attr(d).animate(e,a);b.d&&setTimeout(function(){c&&c.graphic&&c.graphic.animate({opacity:1})},a.duration)}},this)}}drawPoints(){const a=this,b=a.chart,d=a.group,e=b.renderer;(a.points||[]).forEach(function(c){const f={zIndex:E(c.sets)?c.sets.length:0},g=c.shapeArgs;
b.styledMode||w(f,a.pointAttribs(c,c.state));m.draw(c,{isNew:!c.graphic,animatableAttribs:g,attribs:f,group:d,renderer:e,shapeType:g&&g.d?"path":"circle"})})}init(){C.prototype.init.apply(this,arguments);delete this.opacity}pointAttribs(a,b){const c=this.options||{};a=x(c,{color:a&&a.color},a&&a.options||{},b&&c.states[b]||{});return{fill:A(a.color).brighten(a.brightness).get(),opacity:a.opacity,stroke:a.borderColor,"stroke-width":a.borderWidth,dashstyle:a.borderDashStyle}}translate(){var a=this.chart;
this.processedXData=this.xData;this.generatePoints();var d=n.processVennData(this.options.data,b.splitter);const {mapOfIdToShape:e,mapOfIdToLabelValues:f}=b.layout(d);d=Object.keys(e).filter(function(a){return(a=e[a])&&y(a.r)}).reduce(function(a,c){return b.updateFieldBoundaries(a,e[c])},{top:0,bottom:0,left:0,right:0});a=b.getScale(a.plotWidth,a.plotHeight,d);const h=a.scale,l=a.centerX,m=a.centerY;this.points.forEach(function(a){let b=E(a.sets)?a.sets:[];var c=b.join(),d=e[c];let g;var k=f[c]||
{};c=k.width;k=k.position;let n=a.options&&a.options.dataLabels;d&&(d.r?g={x:l+d.x*h,y:m+d.y*h,r:d.r*h}:d.d&&(d=d.d,d.forEach(a=>{"M"===a[0]?(a[1]=l+a[1]*h,a[2]=m+a[2]*h):"A"===a[0]&&(a[1]*=h,a[2]*=h,a[6]=l+a[6]*h,a[7]=m+a[7]*h)}),g={d}),k?(k.x=l+k.x*h,k.y=m+k.y*h):k={},y(c)&&(c=Math.round(c*h)));a.shapeArgs=g;k&&g&&(a.plotX=k.x,a.plotY=k.y);c&&g&&(a.dlOptions=x(!0,{style:{width:c}},H(n,!0)?n:void 0));a.name=a.options.name||b.join("\u2229")})}}b.splitter="highcharts-split";b.defaultOptions=x(C.defaultOptions,
{borderColor:"#cccccc",borderDashStyle:"solid",borderWidth:1,brighten:0,clip:!1,colorByPoint:!0,dataLabels:{enabled:!0,verticalAlign:"middle",formatter:function(){return this.point.name}},inactiveOtherPoints:!0,marker:!1,opacity:.75,showInLegend:!1,legendType:"point",states:{hover:{opacity:1,borderColor:"#333333"},select:{color:"#cccccc",borderColor:"#000000",animation:!1},inactive:{opacity:.075}},tooltip:{pointFormat:"{point.name}: {point.value}"}});w(b.prototype,{axisTypes:[],directTouch:!0,drawLegendSymbol:h.drawRectangle,
isCartesian:!1,pointArrayMap:["value"],pointClass:t,utils:n});B.registerSeriesType("venn",b);"";G(b,"afterSetOptions",function(a){const b=a.options.states;this.is("venn")&&Object.keys(b).forEach(function(a){b[a].halo=!1})});return b});m(a,"masters/modules/venn.src.js",[],function(){})});
//# sourceMappingURL=venn.js.map